// File is generated by JavaScriptCore/inspector/scripts/CodeGeneratorInspector.py

// Copyright (c) 2013 Apple Inc. All Rights Reserved.
// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef InspectorJSTypeBuilders_h
#define InspectorJSTypeBuilders_h

#if ENABLE(INSPECTOR)

#include <inspector/InspectorTypeBuilder.h>

#include <wtf/Assertions.h>
#include <wtf/PassRefPtr.h>

namespace Inspector {

namespace TypeBuilder {

// Forward declarations.
namespace Debugger {
class Scope;
} // Debugger

namespace Runtime {
class RemoteObject;
class ObjectPreview;
class PropertyPreview;
} // Runtime

// End of forward declarations.

// Typedefs.
namespace Debugger {
/* Breakpoint identifier. */
typedef String BreakpointId;

/* Breakpoint action identifier. */
typedef int BreakpointActionIdentifier;

/* Unique script identifier. */
typedef String ScriptId;

/* Call frame identifier. */
typedef String CallFrameId;

} // Debugger

namespace Runtime {
/* Unique object identifier. */
typedef String RemoteObjectId;

/* Id of an execution context. */
typedef int ExecutionContextId;

/* Unique frame identifier. FIXME: Duplicate of Network.FrameId <https://webkit.org/b/125664> Web Inspector: FIX Type Dependency Issues */
typedef String RuntimeFrameId;

} // Runtime

// End of typedefs.



JS_EXPORT_PRIVATE String getJSEnumConstantValue(int code);

namespace Debugger {
/* Location in the source code. */
class Location : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ScriptIdSet = 1 << 0,
        LineNumberSet = 1 << 1,
        AllFieldsSet = (ScriptIdSet | LineNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Location*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Location;
    public:

        Builder<STATE | ScriptIdSet>& setScriptId(const Inspector::TypeBuilder::Debugger::ScriptId& value)
        {
            COMPILE_ASSERT(!(STATE & ScriptIdSet), property_scriptId_already_set);
            m_result->setString(ASCIILiteral("scriptId"), value);
            return castState<ScriptIdSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber(ASCIILiteral("lineNumber"), value);
            return castState<LineNumberSet>();
        }

        operator RefPtr<Location>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Location) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Location>*>(&m_result);
        }

        PassRefPtr<Location> release()
        {
            return RefPtr<Location>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Location> result = Location::create()
     *     .setScriptId(...)
     *     .setLineNumber(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;

    void setColumnNumber(int value)
    {
        this->setNumber(ASCIILiteral("columnNumber"), value);
    }
#if !ASSERT_DISABLED
    static JS_EXPORT_PRIVATE void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Action to perform when a breakpoint is triggered. */
class BreakpointAction : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating BreakpointAction.
    struct Type {
        enum Enum {
            Log = 0,
            Evaluate = 1,
            Sound = 2,
            Probe = 3,
        };
    }; // struct Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*BreakpointAction*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class BreakpointAction;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::TypeBuilder::getJSEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<BreakpointAction>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BreakpointAction) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<BreakpointAction>*>(&m_result);
        }

        PassRefPtr<BreakpointAction> release()
        {
            return RefPtr<BreakpointAction>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<BreakpointAction> result = BreakpointAction::create()
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;

    void setData(const String& value)
    {
        this->setString(ASCIILiteral("data"), value);
    }
};

/* Extra options that modify breakpoint behavior. */
class BreakpointOptions : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*BreakpointOptions*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class BreakpointOptions;
    public:

        operator RefPtr<BreakpointOptions>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BreakpointOptions) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<BreakpointOptions>*>(&m_result);
        }

        PassRefPtr<BreakpointOptions> release()
        {
            return RefPtr<BreakpointOptions>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<BreakpointOptions> result = BreakpointOptions::create();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;

    void setCondition(const String& value)
    {
        this->setString(ASCIILiteral("condition"), value);
    }

    void setActions(PassRefPtr<Inspector::TypeBuilder::Array<Inspector::TypeBuilder::Debugger::BreakpointAction> > value)
    {
        this->setValue(ASCIILiteral("actions"), value);
    }

    void setAutoContinue(bool value)
    {
        this->setBoolean(ASCIILiteral("autoContinue"), value);
    }
};

/* Information about the function. */
class FunctionDetails : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LocationSet = 1 << 0,
        AllFieldsSet = (LocationSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*FunctionDetails*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class FunctionDetails;
    public:

        Builder<STATE | LocationSet>& setLocation(PassRefPtr<Inspector::TypeBuilder::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setValue(ASCIILiteral("location"), value);
            return castState<LocationSet>();
        }

        operator RefPtr<FunctionDetails>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FunctionDetails) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<FunctionDetails>*>(&m_result);
        }

        PassRefPtr<FunctionDetails> release()
        {
            return RefPtr<FunctionDetails>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<FunctionDetails> result = FunctionDetails::create()
     *     .setLocation(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;

    void setName(const String& value)
    {
        this->setString(ASCIILiteral("name"), value);
    }

    void setDisplayName(const String& value)
    {
        this->setString(ASCIILiteral("displayName"), value);
    }

    void setInferredName(const String& value)
    {
        this->setString(ASCIILiteral("inferredName"), value);
    }

    void setScopeChain(PassRefPtr<Inspector::TypeBuilder::Array<Inspector::TypeBuilder::Debugger::Scope> > value)
    {
        this->setValue(ASCIILiteral("scopeChain"), value);
    }
    static PassRefPtr<FunctionDetails> runtimeCast(PassRefPtr<Inspector::InspectorValue> value)
    {
        RefPtr<Inspector::InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(FunctionDetails) == sizeof(Inspector::InspectorObjectBase), type_cast_problem);
        return static_cast<FunctionDetails*>(static_cast<Inspector::InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static JS_EXPORT_PRIVATE void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* JavaScript call frame. Array of call frames form the call stack. */
class CallFrame : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CallFrameIdSet = 1 << 0,
        FunctionNameSet = 1 << 1,
        LocationSet = 1 << 2,
        ScopeChainSet = 1 << 3,
        ThisSet = 1 << 4,
        AllFieldsSet = (CallFrameIdSet | FunctionNameSet | LocationSet | ScopeChainSet | ThisSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CallFrame*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CallFrame;
    public:

        Builder<STATE | CallFrameIdSet>& setCallFrameId(const Inspector::TypeBuilder::Debugger::CallFrameId& value)
        {
            COMPILE_ASSERT(!(STATE & CallFrameIdSet), property_callFrameId_already_set);
            m_result->setString(ASCIILiteral("callFrameId"), value);
            return castState<CallFrameIdSet>();
        }

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString(ASCIILiteral("functionName"), value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | LocationSet>& setLocation(PassRefPtr<Inspector::TypeBuilder::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setValue(ASCIILiteral("location"), value);
            return castState<LocationSet>();
        }

        Builder<STATE | ScopeChainSet>& setScopeChain(PassRefPtr<Inspector::TypeBuilder::Array<Inspector::TypeBuilder::Debugger::Scope> > value)
        {
            COMPILE_ASSERT(!(STATE & ScopeChainSet), property_scopeChain_already_set);
            m_result->setValue(ASCIILiteral("scopeChain"), value);
            return castState<ScopeChainSet>();
        }

        Builder<STATE | ThisSet>& setThis(PassRefPtr<Inspector::TypeBuilder::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ThisSet), property_this_already_set);
            m_result->setValue(ASCIILiteral("this"), value);
            return castState<ThisSet>();
        }

        operator RefPtr<CallFrame>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallFrame) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CallFrame>*>(&m_result);
        }

        PassRefPtr<CallFrame> release()
        {
            return RefPtr<CallFrame>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CallFrame> result = CallFrame::create()
     *     .setCallFrameId(...)
     *     .setFunctionName(...)
     *     .setLocation(...)
     *     .setScopeChain(...)
     *     .setThis(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;
    static PassRefPtr<CallFrame> runtimeCast(PassRefPtr<Inspector::InspectorValue> value)
    {
        RefPtr<Inspector::InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(CallFrame) == sizeof(Inspector::InspectorObjectBase), type_cast_problem);
        return static_cast<CallFrame*>(static_cast<Inspector::InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static JS_EXPORT_PRIVATE void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Scope description. */
class Scope : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating Scope.
    struct Type {
        enum Enum {
            Global = 4,
            Local = 5,
            With = 6,
            Closure = 7,
            Catch = 8,
        };
#if !ASSERT_DISABLED
        static void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
    }; // struct Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        ObjectSet = 1 << 1,
        AllFieldsSet = (TypeSet | ObjectSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Scope*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Scope;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::TypeBuilder::getJSEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | ObjectSet>& setObject(PassRefPtr<Inspector::TypeBuilder::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ObjectSet), property_object_already_set);
            m_result->setValue(ASCIILiteral("object"), value);
            return castState<ObjectSet>();
        }

        operator RefPtr<Scope>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Scope) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Scope>*>(&m_result);
        }

        PassRefPtr<Scope> release()
        {
            return RefPtr<Scope>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Scope> result = Scope::create()
     *     .setType(...)
     *     .setObject(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;
#if !ASSERT_DISABLED
    static JS_EXPORT_PRIVATE void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* A sample collected by evaluating a probe breakpoint action. */
class ProbeSample : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ProbeIdSet = 1 << 0,
        SampleIdSet = 1 << 1,
        BatchIdSet = 1 << 2,
        TimestampSet = 1 << 3,
        PayloadSet = 1 << 4,
        AllFieldsSet = (ProbeIdSet | SampleIdSet | BatchIdSet | TimestampSet | PayloadSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ProbeSample*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ProbeSample;
    public:

        Builder<STATE | ProbeIdSet>& setProbeId(int value)
        {
            COMPILE_ASSERT(!(STATE & ProbeIdSet), property_probeId_already_set);
            m_result->setNumber(ASCIILiteral("probeId"), value);
            return castState<ProbeIdSet>();
        }

        Builder<STATE | SampleIdSet>& setSampleId(int value)
        {
            COMPILE_ASSERT(!(STATE & SampleIdSet), property_sampleId_already_set);
            m_result->setNumber(ASCIILiteral("sampleId"), value);
            return castState<SampleIdSet>();
        }

        Builder<STATE | BatchIdSet>& setBatchId(int value)
        {
            COMPILE_ASSERT(!(STATE & BatchIdSet), property_batchId_already_set);
            m_result->setNumber(ASCIILiteral("batchId"), value);
            return castState<BatchIdSet>();
        }

        Builder<STATE | TimestampSet>& setTimestamp(double value)
        {
            COMPILE_ASSERT(!(STATE & TimestampSet), property_timestamp_already_set);
            m_result->setNumber(ASCIILiteral("timestamp"), value);
            return castState<TimestampSet>();
        }

        Builder<STATE | PayloadSet>& setPayload(PassRefPtr<Inspector::TypeBuilder::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & PayloadSet), property_payload_already_set);
            m_result->setValue(ASCIILiteral("payload"), value);
            return castState<PayloadSet>();
        }

        operator RefPtr<ProbeSample>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ProbeSample) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ProbeSample>*>(&m_result);
        }

        PassRefPtr<ProbeSample> release()
        {
            return RefPtr<ProbeSample>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ProbeSample> result = ProbeSample::create()
     *     .setProbeId(...)
     *     .setSampleId(...)
     *     .setBatchId(...)
     *     .setTimestamp(...)
     *     .setPayload(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;
};

} // Debugger

namespace GenericTypes {
/* Search match in a resource. */
class SearchMatch : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LineNumberSet = 1 << 0,
        LineContentSet = 1 << 1,
        AllFieldsSet = (LineNumberSet | LineContentSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SearchMatch*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SearchMatch;
    public:

        Builder<STATE | LineNumberSet>& setLineNumber(double value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber(ASCIILiteral("lineNumber"), value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | LineContentSet>& setLineContent(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LineContentSet), property_lineContent_already_set);
            m_result->setString(ASCIILiteral("lineContent"), value);
            return castState<LineContentSet>();
        }

        operator RefPtr<SearchMatch>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SearchMatch) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SearchMatch>*>(&m_result);
        }

        PassRefPtr<SearchMatch> release()
        {
            return RefPtr<SearchMatch>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SearchMatch> result = SearchMatch::create()
     *     .setLineNumber(...)
     *     .setLineContent(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;
};

} // GenericTypes

namespace Runtime {
/* Mirror object referencing original JavaScript object. */
class RemoteObject : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating RemoteObject.
    struct Type {
        enum Enum {
            Object = 9,
            Function = 10,
            Undefined = 11,
            String = 12,
            Number = 13,
            Boolean = 14,
        };
#if !ASSERT_DISABLED
        static void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
    }; // struct Type
    // Named after property name 'subtype' while generating RemoteObject.
    struct Subtype {
        enum Enum {
            Array = 15,
            Null = 16,
            Node = 17,
            Regexp = 18,
            Date = 19,
        };
#if !ASSERT_DISABLED
        static void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
    }; // struct Subtype
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*RemoteObject*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class RemoteObject;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::TypeBuilder::getJSEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<RemoteObject>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RemoteObject) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<RemoteObject>*>(&m_result);
        }

        PassRefPtr<RemoteObject> release()
        {
            return RefPtr<RemoteObject>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<RemoteObject> result = RemoteObject::create()
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;

    void setSubtype(Subtype::Enum value)
    {
        this->setString(ASCIILiteral("subtype"), Inspector::TypeBuilder::getJSEnumConstantValue(value));
    }

    void setClassName(const String& value)
    {
        this->setString(ASCIILiteral("className"), value);
    }

    void setValue(PassRefPtr<Inspector::InspectorValue> value)
    {
        this->setValue(ASCIILiteral("value"), value);
    }
    using Inspector::InspectorObjectBase::setValue;


    void setDescription(const String& value)
    {
        this->setString(ASCIILiteral("description"), value);
    }

    void setObjectId(const Inspector::TypeBuilder::Runtime::RemoteObjectId& value)
    {
        this->setString(ASCIILiteral("objectId"), value);
    }

    void setPreview(PassRefPtr<Inspector::TypeBuilder::Runtime::ObjectPreview> value)
    {
        this->setValue(ASCIILiteral("preview"), value);
    }
    static PassRefPtr<RemoteObject> runtimeCast(PassRefPtr<Inspector::InspectorValue> value)
    {
        RefPtr<Inspector::InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(RemoteObject) == sizeof(Inspector::InspectorObjectBase), type_cast_problem);
        return static_cast<RemoteObject*>(static_cast<Inspector::InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static JS_EXPORT_PRIVATE void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Object containing abbreviated remote object value. */
class ObjectPreview : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LosslessSet = 1 << 0,
        OverflowSet = 1 << 1,
        PropertiesSet = 1 << 2,
        AllFieldsSet = (LosslessSet | OverflowSet | PropertiesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ObjectPreview*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ObjectPreview;
    public:

        Builder<STATE | LosslessSet>& setLossless(bool value)
        {
            COMPILE_ASSERT(!(STATE & LosslessSet), property_lossless_already_set);
            m_result->setBoolean(ASCIILiteral("lossless"), value);
            return castState<LosslessSet>();
        }

        Builder<STATE | OverflowSet>& setOverflow(bool value)
        {
            COMPILE_ASSERT(!(STATE & OverflowSet), property_overflow_already_set);
            m_result->setBoolean(ASCIILiteral("overflow"), value);
            return castState<OverflowSet>();
        }

        Builder<STATE | PropertiesSet>& setProperties(PassRefPtr<Inspector::TypeBuilder::Array<Inspector::TypeBuilder::Runtime::PropertyPreview> > value)
        {
            COMPILE_ASSERT(!(STATE & PropertiesSet), property_properties_already_set);
            m_result->setValue(ASCIILiteral("properties"), value);
            return castState<PropertiesSet>();
        }

        operator RefPtr<ObjectPreview>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectPreview) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ObjectPreview>*>(&m_result);
        }

        PassRefPtr<ObjectPreview> release()
        {
            return RefPtr<ObjectPreview>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ObjectPreview> result = ObjectPreview::create()
     *     .setLossless(...)
     *     .setOverflow(...)
     *     .setProperties(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;
#if !ASSERT_DISABLED
    static JS_EXPORT_PRIVATE void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

class PropertyPreview : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating PropertyPreview.
    struct Type {
        enum Enum {
            Object = 9,
            Function = 10,
            Undefined = 11,
            String = 12,
            Number = 13,
            Boolean = 14,
        };
#if !ASSERT_DISABLED
        static void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
    }; // struct Type
    // Named after property name 'subtype' while generating PropertyPreview.
    struct Subtype {
        enum Enum {
            Array = 15,
            Null = 16,
            Node = 17,
            Regexp = 18,
            Date = 19,
        };
#if !ASSERT_DISABLED
        static void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
    }; // struct Subtype
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (NameSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*PropertyPreview*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class PropertyPreview;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::TypeBuilder::getJSEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<PropertyPreview>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PropertyPreview) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<PropertyPreview>*>(&m_result);
        }

        PassRefPtr<PropertyPreview> release()
        {
            return RefPtr<PropertyPreview>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<PropertyPreview> result = PropertyPreview::create()
     *     .setName(...)
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;

    void setValue(const String& value)
    {
        this->setString(ASCIILiteral("value"), value);
    }
    using Inspector::InspectorObjectBase::setValue;


    void setValuePreview(PassRefPtr<Inspector::TypeBuilder::Runtime::ObjectPreview> value)
    {
        this->setValue(ASCIILiteral("valuePreview"), value);
    }

    void setSubtype(Subtype::Enum value)
    {
        this->setString(ASCIILiteral("subtype"), Inspector::TypeBuilder::getJSEnumConstantValue(value));
    }
#if !ASSERT_DISABLED
    static JS_EXPORT_PRIVATE void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Object property descriptor. */
class PropertyDescriptor : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ConfigurableSet = 1 << 1,
        EnumerableSet = 1 << 2,
        AllFieldsSet = (NameSet | ConfigurableSet | EnumerableSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*PropertyDescriptor*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class PropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | ConfigurableSet>& setConfigurable(bool value)
        {
            COMPILE_ASSERT(!(STATE & ConfigurableSet), property_configurable_already_set);
            m_result->setBoolean(ASCIILiteral("configurable"), value);
            return castState<ConfigurableSet>();
        }

        Builder<STATE | EnumerableSet>& setEnumerable(bool value)
        {
            COMPILE_ASSERT(!(STATE & EnumerableSet), property_enumerable_already_set);
            m_result->setBoolean(ASCIILiteral("enumerable"), value);
            return castState<EnumerableSet>();
        }

        operator RefPtr<PropertyDescriptor>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PropertyDescriptor) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<PropertyDescriptor>*>(&m_result);
        }

        PassRefPtr<PropertyDescriptor> release()
        {
            return RefPtr<PropertyDescriptor>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<PropertyDescriptor> result = PropertyDescriptor::create()
     *     .setName(...)
     *     .setConfigurable(...)
     *     .setEnumerable(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;

    void setValue(PassRefPtr<Inspector::TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue(ASCIILiteral("value"), value);
    }
    using Inspector::InspectorObjectBase::setValue;


    void setWritable(bool value)
    {
        this->setBoolean(ASCIILiteral("writable"), value);
    }

    void setGet(PassRefPtr<Inspector::TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue(ASCIILiteral("get"), value);
    }

    void setSet(PassRefPtr<Inspector::TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue(ASCIILiteral("set"), value);
    }

    void setWasThrown(bool value)
    {
        this->setBoolean(ASCIILiteral("wasThrown"), value);
    }

    void setIsOwn(bool value)
    {
        this->setBoolean(ASCIILiteral("isOwn"), value);
    }
    static PassRefPtr<PropertyDescriptor> runtimeCast(PassRefPtr<Inspector::InspectorValue> value)
    {
        RefPtr<Inspector::InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(PropertyDescriptor) == sizeof(Inspector::InspectorObjectBase), type_cast_problem);
        return static_cast<PropertyDescriptor*>(static_cast<Inspector::InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static JS_EXPORT_PRIVATE void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Object internal property descriptor. This property isn't normally visible in JavaScript code. */
class InternalPropertyDescriptor : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*InternalPropertyDescriptor*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class InternalPropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        operator RefPtr<InternalPropertyDescriptor>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(InternalPropertyDescriptor) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<InternalPropertyDescriptor>*>(&m_result);
        }

        PassRefPtr<InternalPropertyDescriptor> release()
        {
            return RefPtr<InternalPropertyDescriptor>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<InternalPropertyDescriptor> result = InternalPropertyDescriptor::create()
     *     .setName(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;

    void setValue(PassRefPtr<Inspector::TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue(ASCIILiteral("value"), value);
    }
    using Inspector::InspectorObjectBase::setValue;

    static PassRefPtr<InternalPropertyDescriptor> runtimeCast(PassRefPtr<Inspector::InspectorValue> value)
    {
        RefPtr<Inspector::InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(InternalPropertyDescriptor) == sizeof(Inspector::InspectorObjectBase), type_cast_problem);
        return static_cast<InternalPropertyDescriptor*>(static_cast<Inspector::InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static JS_EXPORT_PRIVATE void assertCorrectValue(Inspector::InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Represents function call argument. Either remote object id <code>objectId</code> or primitive <code>value</code> or neither of (for undefined) them should be specified. */
class CallArgument : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CallArgument*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CallArgument;
    public:

        operator RefPtr<CallArgument>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallArgument) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CallArgument>*>(&m_result);
        }

        PassRefPtr<CallArgument> release()
        {
            return RefPtr<CallArgument>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CallArgument> result = CallArgument::create();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;

    void setValue(PassRefPtr<Inspector::InspectorValue> value)
    {
        this->setValue(ASCIILiteral("value"), value);
    }
    using Inspector::InspectorObjectBase::setValue;


    void setObjectId(const Inspector::TypeBuilder::Runtime::RemoteObjectId& value)
    {
        this->setString(ASCIILiteral("objectId"), value);
    }
};

/* Description of an isolated world. */
class ExecutionContextDescription : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        IsPageContextSet = 1 << 1,
        NameSet = 1 << 2,
        FrameIdSet = 1 << 3,
        AllFieldsSet = (IdSet | IsPageContextSet | NameSet | FrameIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ExecutionContextDescription*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ExecutionContextDescription;
    public:

        Builder<STATE | IdSet>& setId(int value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setNumber(ASCIILiteral("id"), value);
            return castState<IdSet>();
        }

        Builder<STATE | IsPageContextSet>& setIsPageContext(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsPageContextSet), property_isPageContext_already_set);
            m_result->setBoolean(ASCIILiteral("isPageContext"), value);
            return castState<IsPageContextSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const Inspector::TypeBuilder::Runtime::RuntimeFrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString(ASCIILiteral("frameId"), value);
            return castState<FrameIdSet>();
        }

        operator RefPtr<ExecutionContextDescription>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ExecutionContextDescription) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ExecutionContextDescription>*>(&m_result);
        }

        PassRefPtr<ExecutionContextDescription> release()
        {
            return RefPtr<ExecutionContextDescription>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ExecutionContextDescription> result = ExecutionContextDescription::create()
     *     .setId(...)
     *     .setIsPageContext(...)
     *     .setName(...)
     *     .setFrameId(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;
};

/* Syntax error type: "none" for no error, "irrecoverable" for unrecoverable errors, "unterminated-literal" for when there is an unterminated literal, "recoverable" for when the expression is unfinished but valid so far. */
struct SyntaxErrorType {
    enum Enum {
        None = 20,
        Irrecoverable = 21,
        UnterminatedLiteral = 22,
        Recoverable = 23,
    };
}; // struct SyntaxErrorType
/* Range of an error in source code. */
class ErrorRange : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartOffsetSet = 1 << 0,
        EndOffsetSet = 1 << 1,
        AllFieldsSet = (StartOffsetSet | EndOffsetSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<Inspector::InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ErrorRange*/Inspector::InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ErrorRange;
    public:

        Builder<STATE | StartOffsetSet>& setStartOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & StartOffsetSet), property_startOffset_already_set);
            m_result->setNumber(ASCIILiteral("startOffset"), value);
            return castState<StartOffsetSet>();
        }

        Builder<STATE | EndOffsetSet>& setEndOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & EndOffsetSet), property_endOffset_already_set);
            m_result->setNumber(ASCIILiteral("endOffset"), value);
            return castState<EndOffsetSet>();
        }

        operator RefPtr<ErrorRange>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ErrorRange) == sizeof(Inspector::InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ErrorRange>*>(&m_result);
        }

        PassRefPtr<ErrorRange> release()
        {
            return RefPtr<ErrorRange>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ErrorRange> result = ErrorRange::create()
     *     .setStartOffset(...)
     *     .setEndOffset(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(Inspector::InspectorObject::create());
    }
    typedef Inspector::TypeBuilder::StructItemTraits ItemTraits;
};

} // Runtime


} // namespace TypeBuilder

} // namespace Inspector

#endif // ENABLE(INSPECTOR)

#endif // !defined(InspectorJSTypeBuilders_h)
