## TFSA-2018-005: Old Snappy Library Usage Resulting in Memcpy Parameter Overlap

### CVE Number

CVE-2018-7577

### Issue Description

TensorFlow checkpoint meta file uses Google's [https://github.com/google/snappy](snappy)
compression/decompression library. There is a memcpy-param-overlap issue in the
version of snappy currently used by TensorFlow.

### Impact

A maliciously crafted checkpoint meta file could cause TensorFlow to crash or
read from other parts of its process memory.

### Vulnerable Versions

TensorFlow 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0, 1.4.1, 1.5.0, 1.5.1, 1.6.0, 1.7.0

### Mitigation

We have patched the vulnerability in GitHub commit
[dfa9921e](https://github.com/tensorflow/tensorflow/commit/dfa9921e6343727b05f42f8d4a918b19528ff994)
by upgrading the version of the snappy library used by TensorFlow to v1.1.7.

If users are loading untrusted checkpoints in TensorFlow, we encourage users to
apply the patch to upgrade snappy.

Additionally, we have released TensorFlow version 1.7.1 to mitigate this
vulnerability.

### Credits

This issue was discovered by the Blade Team of Tencent.
