package games.strategy.twoIfBySea.delegate;

import java.util.Collection;

import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.MapSupport;
import games.strategy.triplea.delegate.AbstractPlaceDelegate;
import games.strategy.triplea.delegate.Matches;

/**
 * Logic for placing units.
 */
@MapSupport
public class PlaceDelegate extends AbstractPlaceDelegate {
  /**
   * @return gets the production of the territory, ignores whether the territory was an original factory.
   */
  @Override
  protected int getProduction(final Territory territory) {
    final Collection<Unit> allUnits = territory.getUnits().getUnits();
    final int factoryCount = Matches.countMatches(allUnits, Matches.unitCanProduceUnits());
    return 5 * factoryCount;
  }
}
