package org.apache.maven.surefire.util;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import junit.framework.TestCase;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Kristian Rosenvold
 */
public class ScanResultTest
    extends TestCase
{
    public void testWriteTo()
        throws Exception
    {
        List<String> files = Arrays.asList( "abc", "cde" );
        DefaultScanResult scanResult = new DefaultScanResult( files );
        Map<String, String> serialized = new HashMap<String, String>();
        scanResult.writeTo( serialized );

        DefaultScanResult read = DefaultScanResult.from( serialized );
        List classes = read.getClasses();
        assertEquals( 2, classes.size() );
        assertTrue( classes.contains( "abc" ) );
        assertTrue( classes.contains( "cde" ) );
    }
}
