// Copyright 2012-2018 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "scripts/unicode.py", do not edit directly

#![allow(missing_docs)]
use crate::quick_check::IsNormalized;
use crate::quick_check::IsNormalized::*;

#[allow(unused)]
pub const UNICODE_VERSION: (u8, u8, u8) = (15, 0, 0);

pub(crate) const CANONICAL_COMBINING_CLASS_SALT: &[u16] = &[
    0x0,
    0x1,
    0x224,
    0x197,
    0x4,
    0x0,
    0x6f,
    0x4,
    0xaf,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x88,
    0xa,
    0x8,
    0x0,
    0x0,
    0x0,
    0x1c,
    0x46,
    0x1,
    0xd,
    0x1b,
    0x0,
    0x15,
    0x12,
    0x45,
    0xec,
    0x36,
    0x10,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x94,
    0x0,
    0x57,
    0x0,
    0x8,
    0x3,
    0x7,
    0x0,
    0x16,
    0x3a,
    0x2,
    0x23,
    0x3,
    0x4,
    0x1c,
    0x1,
    0x0,
    0x47,
    0x11,
    0x17,
    0x4,
    0x1b,
    0x0,
    0x13,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x7,
    0x7,
    0x4,
    0x2e,
    0x0,
    0x0,
    0x2c,
    0x0,
    0x0,
    0x3,
    0xf,
    0x0,
    0x0,
    0x13,
    0x0,
    0x1,
    0x2,
    0x1,
    0x9,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0x3,
    0x2,
    0x1e,
    0x0,
    0x8,
    0x11,
    0x1,
    0x0,
    0x5,
    0x0,
    0x79,
    0x0,
    0x4,
    0x13,
    0x0,
    0x0,
    0x5,
    0x2,
    0x0,
    0x5,
    0x1,
    0x15,
    0x1,
    0x0,
    0x3,
    0xc,
    0x0,
    0x35,
    0x3,
    0x2,
    0x5,
    0x6,
    0x0,
    0x5,
    0x4,
    0x2,
    0x1c,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x9,
    0x2,
    0x9,
    0x7,
    0x0,
    0x5,
    0x0,
    0x8,
    0x7,
    0x0,
    0x12,
    0x9,
    0x0,
    0x39,
    0x2,
    0x9,
    0x0,
    0x4,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x22,
    0x2,
    0x0,
    0x1b,
    0x13,
    0xc,
    0x14,
    0x6,
    0x4,
    0x5,
    0x13,
    0x2,
    0x0,
    0x3,
    0x4,
    0x2,
    0x0,
    0x18,
    0x0,
    0x6,
    0x4,
    0x0,
    0x0,
    0xa,
    0xa,
    0x0,
    0x1,
    0x0,
    0xf,
    0x10,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0xf,
    0x1,
    0x4,
    0x2,
    0xa,
    0xb,
    0x9,
    0x4,
    0x1,
    0x0,
    0xb,
    0x0,
    0x3,
    0x0,
    0x6,
    0x0,
    0x6,
    0x0,
    0x3,
    0x4,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x2,
    0x15,
    0x0,
    0x0,
    0x0,
    0x14,
    0x1b,
    0x0,
    0xc,
    0x0,
    0x0,
    0x8,
    0x3,
    0xc,
    0x0,
    0xe,
    0x2,
    0x0,
    0x3,
    0x0,
    0xa,
    0x2,
    0x6,
    0x1,
    0x0,
    0x4,
    0x0,
    0x1,
    0x6,
    0x2,
    0x3,
    0x2,
    0x10,
    0x0,
    0xf,
    0x0,
    0x0,
    0x0,
    0x3,
    0x3,
    0x4,
    0xd,
    0x6,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x18,
    0xa,
    0x6,
    0x1,
    0x1,
    0x8,
    0x0,
    0x1,
    0x1,
    0x7,
    0x0,
    0x3,
    0x9,
    0x11,
    0x5,
    0x1,
    0x5,
    0x3,
    0x16,
    0x7,
    0x5,
    0x4,
    0x0,
    0xa,
    0x6,
    0x3,
    0x0,
    0x1,
    0x0,
    0x7,
    0x0,
    0x6,
    0x0,
    0x5,
    0x41,
    0x9,
    0x1,
    0xa,
    0x0,
    0x5,
    0x2,
    0x11,
    0xb,
    0x3,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x6,
    0x18,
    0x3,
    0x0,
    0x3,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x9,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x3,
    0x1,
    0x1,
    0x1,
    0x0,
    0x3,
    0xc,
    0x1,
    0x3,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x5,
    0x1,
    0x5,
    0x0,
    0x1,
    0xb,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xf,
    0x0,
    0x0,
    0x2,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x9,
    0x8,
    0x0,
    0x0,
    0x3,
    0x3,
    0x1,
    0x4,
    0x3,
    0x4,
    0x5,
    0x2,
    0x0,
    0x0,
    0x2,
    0x6,
    0x1,
    0x5,
    0x1,
    0x0,
    0x3,
    0x6,
    0x8,
    0x2,
    0x2,
    0x6,
    0x3,
    0x0,
    0x10,
    0x6,
    0x6,
    0x5,
    0x1,
    0x7,
    0x0,
    0x2,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x8,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0xc,
    0x4,
    0x1,
    0x2,
    0x1,
    0x4,
    0x2,
    0x5,
    0x4,
    0x0,
    0x3,
    0x4,
    0x2,
    0x0,
    0x1,
    0x3,
    0x7,
    0x6,
    0x8,
    0x0,
    0x2,
    0x3,
    0x0,
    0x2,
    0x2,
    0x2,
    0x4,
    0x0,
    0x0,
    0x6,
    0x6,
    0x6,
    0xc,
    0x5,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x3,
    0x0,
    0x9,
    0x3,
    0x2,
    0x1,
    0x1,
    0x9,
    0x1,
    0x0,
    0x8,
    0x1,
    0x6,
    0x0,
    0x3,
    0x0,
    0x5,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x4,
    0x0,
    0x2,
    0x0,
    0x2,
    0x6,
    0x6,
    0x2,
    0x8,
    0x5,
    0x6,
    0x5,
    0x1,
    0x6,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x9,
    0x5,
    0x5,
    0xe,
    0x0,
    0x3,
    0x5,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x2,
    0x4,
    0x6,
    0x5,
    0x6,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x5,
    0x2,
    0x8,
    0x8,
    0x1,
    0x6,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x8,
    0x0,
    0x4,
    0x7,
    0xa,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x0,
    0x2,
    0x1,
    0x4,
    0x4,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x3,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x2,
    0x2,
    0x0,
    0x4,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0x2,
    0x2,
    0x0,
    0x1,
    0x5,
    0x4,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x4,
    0x1,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x4,
    0x1,
    0x2,
    0x0,
    0x1,
    0xd,
    0x4,
    0x0,
    0x1,
    0x4,
    0x0,
    0x5,
    0x3,
    0x7,
    0x3,
    0x3,
    0x3,
    0x2,
    0x0,
    0x2,
    0x2,
    0x2,
    0x1,
    0x0,
    0x1,
    0x3,
    0x4,
    0x1,
    0x0,
    0x1,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0x1,
    0x4,
    0x1,
    0x8,
    0x2,
    0x4,
    0x1,
    0x1,
    0x1,
    0x5,
    0x1,
    0x4,
    0x1,
    0x1,
    0x2,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x6,
    0x3,
    0x1,
    0x3,
    0x2,
    0x3,
    0x5,
    0x4,
    0x1,
    0x0,
    0x5,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x5,
    0x5,
    0x8,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x5,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0x7,
    0x1,
    0x1,
    0x2,
    0x0,
    0x2,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x2,
    0x2,
    0x4,
    0x1,
    0x4,
    0x0,
    0x2,
    0x2,
    0x4,
    0x4,
    0x0,
    0x8,
    0x4,
    0x6,
    0x2,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x6,
    0x1,
    0x0,
    0x3,
    0x2,
    0x1,
    0x0,
    0x5,
    0x4,
    0x0,
    0x0,
    0x5,
    0x2,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x4,
    0x3,
    0x0,
    0x9,
    0x5,
    0x2,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x7,
    0x0,
    0x3,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0x2,
    0x3,
    0x1,
    0x2,
    0x1,
    0x2,
    0x0,
    0x4,
    0x2,
    0x1,
    0x1,
    0x1,
    0x2,
    0x2,
    0x0,
    0x4,
    0x2,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0x2,
    0x3,
    0x5,
    0x3,
    0x1,
    0x0,
    0x1,
    0x3,
    0x7,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x3,
    0x1,
];
pub(crate) const CANONICAL_COMBINING_CLASS_KV: &[u32] = &[
    0x34AE6,
    0x2DFAE6,
    0x1DFADA,
    0x339DC,
    0x1DFCE9,
    0xA4D09,
    0x20D0E6,
    0x593E6,
    0x102E0DC,
    0x1CF4E6,
    0x5A2DC,
    0xFE26E6,
    0x11D4509,
    0x5C219,
    0x6EADC,
    0xA675E6,
    0x10F4EDC,
    0xA8EBE6,
    0x332DC,
    0xC4D09,
    0x741E6,
    0x1D171D8,
    0xFE2DDC,
    0x1DF2E6,
    0x1DDEE6,
    0xA8E1E6,
    0x5BB14,
    0x1DD5E6,
    0x8CEE6,
    0x1A7BE6,
    0xF7484,
    0xA8E6E6,
    0x6191F,
    0x114C307,
    0x1A79E6,
    0x65DE6,
    0x8F11C,
    0x1E020E6,
    0xA8F1E6,
    0x1DFDDC,
    0xFE25E6,
    0x1E947E6,
    0x1A75E6,
    0xEBA09,
    0x1E02AE6,
    0x64B1B,
    0x6D9E6,
    0x116B609,
    0x1DECE6,
    0xE3A09,
    0x954E6,
    0x2DE9E6,
    0x1AB3E6,
    0x8F3E6,
    0x8F7E6,
    0xA8E2E6,
    0x1E00BE6,
    0xFE28DC,
    0x20D801,
    0xAAB0E6,
    0x10F4DDC,
    0x825E6,
    0x611E6,
    0xAABEE6,
    0x820E6,
    0x8E8E6,
    0x306E6,
    0x2DE4E6,
    0x11F4109,
    0x111CA07,
    0x2CF0E6,
    0x1CD7DC,
    0x10A3ADC,
    0x1E131E6,
    0x103A09,
    0x73BDC,
    0x358E8,
    0x487E6,
    0x1AB1E6,
    0x11370E6,
    0x1CD0E6,
    0xA8EEE6,
    0x33CDC,
    0x20D5E6,
    0x819E6,
    0x16B30E6,
    0x16AF301,
    0x9BC07,
    0x1DE9E6,
    0x1DDAE6,
    0x1136BE6,
    0x82BE6,
    0x173409,
    0x1DDBE6,
    0x5B40E,
    0x1D16DE2,
    0x1D16901,
    0x34CE6,
    0x2DF0E6,
    0x33701,
    0x11373E6,
    0x112E907,
    0x1AC0DC,
    0x20EA01,
    0x33EE6,
    0xF7181,
    0x1D16801,
    0x346E6,
    0x1E8D6DC,
    0x1E8D0DC,
    0xFE2CDC,
    0x1CE0E6,
    0x8EAE6,
    0x20DBE6,
    0x16B31E6,
    0x735E6,
    0x10EFDDC,
    0x1D17EDC,
    0x11A3409,
    0x81FE6,
    0x1E01CE6,
    0x1DDFE6,
    0x20E8DC,
    0xABED09,
    0x1DE1E6,
    0x316DC,
    0x1D182DC,
    0x20D7E6,
    0x64F1F,
    0x8F5E6,
    0xD4D09,
    0x1AC9E6,
    0x110B909,
    0x1ABCE6,
    0xA67AE6,
    0x1D1AAE6,
    0x1E4EEDC,
    0x1E130E6,
    0x59FE6,
    0x1939DE,
    0x357E6,
    0x119E009,
    0x16FF006,
    0x733E6,
    0xFE29DC,
    0x1CF8E6,
    0xF8409,
    0x364E6,
    0x317DC,
    0x483E6,
    0x36CE6,
    0x5B10B,
    0x1CD2E6,
    0x307E6,
    0x65121,
    0x330DC,
    0x319DC,
    0x656DC,
    0x1DE4E6,
    0x952DC,
    0x345F0,
    0x2DF1E6,
    0x193BDC,
    0x659E6,
    0x5ABE6,
    0x1B73E6,
    0x2CF1E6,
    0xABC07,
    0xF7C82,
    0x1136AE6,
    0xA8E4E6,
    0x8FBE6,
    0x5B20C,
    0xFE21E6,
    0x2DFBE6,
    0x31AE8,
    0x738DC,
    0x20D301,
    0xFE2ADC,
    0x11369E6,
    0xF7282,
    0x1AC2E6,
    0x1D17BDC,
    0xF86E6,
    0x327CA,
    0x1DC0E6,
    0x10F48E6,
    0x1104609,
    0x1B6BE6,
    0x8E6DC,
    0x1E134E6,
    0x341E6,
    0x1DF6E8,
    0xA8ECE6,
    0x1D1ABE6,
    0x6ECE6,
    0x1E2AEE6,
    0x5B50F,
    0x1AC7E6,
    0x1E002E6,
    0xFC6DC,
    0x1E136E6,
    0x8DFE6,
    0x64C1C,
    0x658E6,
    0x6E1E6,
    0x2DE7E6,
    0x8CFDC,
    0x302E6,
    0x1AC4DC,
    0xAABFE6,
    0x5B913,
    0x1D18BDC,
    0x1172B09,
    0x2DF3E6,
    0x739DC,
    0x2DE0E6,
    0x1CDCDC,
    0x1107009,
    0xA92CDC,
    0x823E6,
    0x1DF3E6,
    0xA67DE6,
    0x10F46DC,
    0x1DCCE6,
    0x6DCE6,
    0x11A4709,
    0xEB976,
    0x36BE6,
    0x65EE6,
    0x1CF9E6,
    0x8D6E6,
    0x8E0E6,
    0x1B6EE6,
    0x8D8E6,
    0x1E026E6,
    0x343E6,
    0x20D901,
    0x1E948E6,
    0x5B610,
    0x1E011E6,
    0x1DE8E6,
    0x1DF7E4,
    0x2DFCE6,
    0x11D9709,
    0x486E6,
    0x1DC1E6,
    0x591DC,
    0x11D4409,
    0xA8C409,
    0x1BAA09,
    0x10EFFDC,
    0x6EDDC,
    0x356DC,
    0x1DEEE6,
    0x2DEDE6,
    0x64D1D,
    0x17D209,
    0xD3C09,
    0x1E945E6,
    0x114C209,
    0x303E6,
    0xA6F0E6,
    0x302FE0,
    0x1E01BE6,
    0x11368E6,
    0x1163F09,
    0x1CE301,
    0x5A3DC,
    0x8EFDC,
    0x596DC,
    0x1E028E6,
    0x10F4FDC,
    0xA82C09,
    0x1D172D8,
    0x2CEFE6,
    0x10F49E6,
    0xA8EAE6,
    0x32CDC,
    0xD3B09,
    0x1E00FE6,
    0x8EDDC,
    0x171409,
    0x1ABBE6,
    0x1E8D3DC,
    0xB3C07,
    0x59DE6,
    0x10AE6DC,
    0x1DFBE6,
    0x16FF106,
    0x82AE6,
    0x20EEDC,
    0x1CDFDC,
    0x1CDDDC,
    0x8D2DC,
    0x135FE6,
    0xF7A82,
    0x610E6,
    0x1144209,
    0x2DEEE6,
    0x1145EE6,
    0x73DE6,
    0x35DEA,
    0xFE2FE6,
    0xCBC07,
    0x1DC7E6,
    0x6E7E6,
    0x321CA,
    0x5A6DC,
    0xA8F0E6,
    0x5BA13,
    0x2DECE6,
    0x8EEDC,
    0x16AF201,
    0x5C712,
    0x612E6,
    0x59CE6,
    0x11D4207,
    0x1ABADC,
    0x1AB4E6,
    0x1E8D2DC,
    0x85BDC,
    0x1B72E6,
    0x1E000E6,
    0x5B00A,
    0x5C5DC,
    0x10F47DC,
    0x1A78E6,
    0x1113409,
    0x1144607,
    0x10D26E6,
    0x20DCE6,
    0x350E6,
    0xF7D82,
    0x31FDC,
    0x103909,
    0x8D3DC,
    0x1BE607,
    0x731DC,
    0x312E6,
    0x829E6,
    0x8FADC,
    0x7EBE6,
    0x1DDDE6,
    0x1D165D8,
    0x20E9E6,
    0x1E01EE6,
    0x1E135E6,
    0x1DEDE6,
    0xC565B,
    0x1E012E6,
    0x2DE3E6,
    0xF7B82,
    0x1CDEDC,
    0x36DE6,
    0x8F4E6,
    0x1E8D4DC,
    0x73CDC,
    0x11374E6,
    0x5ACE6,
    0x1AC8E6,
    0x2DEBE6,
    0xA92BDC,
    0x1117307,
    0x111C009,
    0x33601,
    0xF8082,
    0x20D4E6,
    0x59BDC,
    0x1E001E6,
    0x827E6,
    0x33401,
    0x31BD8,
    0x20D201,
    0x1E003E6,
    0x1DF0E6,
    0x31DDC,
    0x2DF4E6,
    0x11372E6,
    0x314E6,
    0x18A9E4,
    0x1136CE6,
    0x2DE5E6,
    0x1113309,
    0x135DE6,
    0x1A77E6,
    0xE3967,
    0x10D27E6,
    0xCCD09,
    0x32DDC,
    0x592E6,
    0x2DEFE6,
    0x8CAE6,
    0x2DE1E6,
    0x657E6,
    0x32BDC,
    0x10EACE6,
    0x309E6,
    0x730E6,
    0x65FDC,
    0x1E014E6,
    0x8DEE6,
    0x2DFEE6,
    0x16B33E6,
    0x8CDE6,
    0x329DC,
    0x8F21D,
    0x93C07,
    0x747E6,
    0x859DC,
    0x736E6,
    0x10A38E6,
    0x81DE6,
    0x1CD5DC,
    0x743E6,
    0x746DC,
    0x899DC,
    0x61A20,
    0x1CE201,
    0x301E6,
    0x1E944E6,
    0x1D186E6,
    0x6E0E6,
    0x1194307,
    0x355DC,
    0x6181E,
    0xA66FE6,
    0x8FFE6,
    0x11100E6,
    0x33DE6,
    0x1DC2DC,
    0x615E6,
    0x342E6,
    0x1A17E6,
    0x11367E6,
    0x10EABE6,
    0x6EBE6,
    0x1E01FE6,
    0xE4A6B,
    0x325DC,
    0x349DC,
    0xFE23E6,
    0x10376E6,
    0x2DFFE6,
    0x1D16FD8,
    0x30FE6,
    0x1BAB09,
    0x2DE2E6,
    0x740E6,
    0x1193E09,
    0xF39D8,
    0x20EFDC,
    0x2DE6E6,
    0x1D187E6,
    0x1DD2E6,
    0x10F4AE6,
    0x6D8E6,
    0x1B3407,
    0x2DEAE6,
    0xA679E6,
    0x10F84E6,
    0xF87E6,
    0x35FE9,
    0x300E6,
    0x7EEE6,
    0x2DF2E6,
    0x11F4209,
    0x73AE6,
    0x31EDC,
    0x1E00DE6,
    0x1DCED6,
    0x1AB7DC,
    0x1D16ED8,
    0x352E6,
    0x8F6DC,
    0xA677E6,
    0x1A7CE6,
    0x8E7E6,
    0x16B32E6,
    0x1DD9E6,
    0x1DF9DC,
    0x8E9DC,
    0x11366E6,
    0x1AC6E6,
    0x1CE701,
    0x1CD1E6,
    0x35EEA,
    0x16AF401,
    0x1AB0E6,
    0x34BE6,
    0x33BDC,
    0x67023,
    0x366E6,
    0x10D25E6,
    0x9FEE6,
    0xAAB4DC,
    0xBCD09,
    0x1DC9E6,
    0x5BD16,
    0x8D0DC,
    0x816E6,
    0x101FDDC,
    0xA3C07,
    0x1D17CDC,
    0x732E6,
    0x826E6,
    0x1133B07,
    0x1CD9DC,
    0x81EE6,
    0x10F83DC,
    0x313E6,
    0x1DFFDC,
    0x1D17FDC,
    0x1D16701,
    0x1A6009,
    0x1E949E6,
    0x10A0DDC,
    0x1183909,
    0xF19DC,
    0x1DE7E6,
    0xB4D09,
    0x89CE6,
    0x2DFDE6,
    0x367E6,
    0xA9C009,
    0xA67BE6,
    0x333DC,
    0x5A1E6,
    0x8EBE6,
    0x1E009E6,
    0x1DEFE6,
    0x324DC,
    0xFE2BDC,
    0xFE27DC,
    0x10D24E6,
    0x81BE6,
    0x1E008E6,
    0x1E01DE6,
    0xA95309,
    0x6DBE6,
    0xC5554,
    0x2D7F09,
    0x1CDAE6,
    0x5BC15,
    0x59ADE,
    0xA676E6,
    0x2DF8E6,
    0x20D6E6,
    0x5B30D,
    0x1D181DC,
    0x1ACADC,
    0x953E6,
    0x328CA,
    0x5A0E6,
    0x595E6,
    0x8D5E6,
    0x308E6,
    0xA674E6,
    0x30CE6,
    0x1A76E6,
    0x1DC6E6,
    0x6E2E6,
    0x10F4CE6,
    0x20F0E6,
    0x8CBE6,
    0x10A0FE6,
    0x135EE6,
    0x1B6FE6,
    0x1AB2E6,
    0x1DF8E4,
    0x5AADC,
    0x10AE5E6,
    0x89FE6,
    0x1E00CE6,
    0x20E501,
    0x8FCE6,
    0x65020,
    0x8ECE6,
    0x898E6,
    0x1E2EDE6,
    0x1DD7E6,
    0xE3867,
    0x89DE6,
    0x1B71E6,
    0x85ADC,
    0x1DC5E6,
    0x1D189E6,
    0xA69FE6,
    0x348DC,
    0x8DBE6,
    0x1DC4E6,
    0x320DC,
    0xA8E3E6,
    0x1E946E6,
    0x1D170D8,
    0xAAF609,
    0x1ACCE6,
    0x360EA,
    0x1ABFDC,
    0x1AC1E6,
    0x302CE8,
    0x2DF7E6,
    0xEB876,
    0x1E132E6,
    0x1DFEE6,
    0x33FE6,
    0x20EB01,
    0x82DE6,
    0x347DC,
    0x1123607,
    0xA6F1E6,
    0x749E6,
    0x17DDE6,
    0x7F1E6,
    0x617E6,
    0x1ACDE6,
    0x1DE6E6,
    0x8E4E6,
    0x351E6,
    0x89EE6,
    0x613E6,
    0x1DCDEA,
    0x655DC,
    0x20E1E6,
    0x65CDC,
    0x1ABDDC,
    0x1AB9DC,
    0xA678E6,
    0x10A3F09,
    0x32ADC,
    0xA8EDE6,
    0x302ADA,
    0x20DA01,
    0x30DE6,
    0x302BE4,
    0x8D7E6,
    0x8F01B,
    0x8DCE6,
    0x5B711,
    0xA80609,
    0x1D1ADE6,
    0x6E4E6,
    0x1DE0E6,
    0x5ADDE,
    0x1DF1E6,
    0x11102E6,
    0x1E8D5DC,
    0x30EE6,
    0x7EFE6,
    0x7F0E6,
    0x597E6,
    0x1E027E6,
    0x1E2ECE6,
    0x31CDC,
    0x315E8,
    0xAAB7E6,
    0x616E6,
    0x2DF6E6,
    0x5BF17,
    0x10A3901,
    0x653E6,
    0x1D166D8,
    0x1AC5E6,
    0x361EA,
    0x8F8E6,
    0x1AC3DC,
    0x103707,
    0x1123509,
    0x36EE6,
    0x1E004E6,
    0x1E023E6,
    0x368E6,
    0x1DD6E6,
    0x344E6,
    0x742DC,
    0x485E6,
    0x110BA07,
    0x1CD8DC,
    0x1CD401,
    0x8FEE6,
    0x2DF5E6,
    0x1E00EE6,
    0xECB7A,
    0x94D09,
    0x1DEBE6,
    0x1133C07,
    0x1E4EFE6,
    0x359DC,
    0x1E010E6,
    0x304E6,
    0x5A8E6,
    0x1CD6DC,
    0xAAB3E6,
    0x1B70E6,
    0x6E8E6,
    0xA92DDC,
    0x8D9E6,
    0x16B34E6,
    0xF18DC,
    0x30AE6,
    0x20EDDC,
    0x1E4ECE8,
    0x1E2EFE6,
    0x1D242E6,
    0x354DC,
    0x16AF101,
    0x35BE6,
    0x1DE3E6,
    0x73EDC,
    0x1E005E6,
    0x115BF09,
    0x1DC8E6,
    0x484E6,
    0x81CE6,
    0x1E133E6,
    0x5B812,
    0x340E6,
    0x598E6,
    0x1BC9E01,
    0x1DDCE6,
    0x115C007,
    0x8E3DC,
    0x11C3F09,
    0x10F85DC,
    0x35CE9,
    0x1CDBE6,
    0x1D1ACE6,
    0x1E8D1DC,
    0x1AB5DC,
    0xDCA09,
    0x322CA,
    0x10F4BDC,
    0x1DC3E6,
    0x35ADC,
    0x7ECE6,
    0x112EA09,
    0xE4B6B,
    0x7FDDC,
    0x32EDC,
    0x65BE6,
    0xFE22E6,
    0x1DD3E6,
    0x89ADC,
    0xA8E8E6,
    0x8F9DC,
    0x36FE6,
    0x1B6DE6,
    0x8CCE6,
    0x1134D09,
    0x193AE6,
    0x309A08,
    0xFE20E6,
    0x1DE2E6,
    0x1CEDDC,
    0x10EFEDC,
    0x1E013E6,
    0x8D4E6,
    0x34EDC,
    0x16B35E6,
    0x1037AE6,
    0x1107F09,
    0x8DDE6,
    0x1DD1E6,
    0x33801,
    0xA67CE6,
    0x1ACEE6,
    0x1E08FE6,
    0x1183A07,
    0x1D244E6,
    0x1E018E6,
    0xACD09,
    0x5A5DC,
    0x64E1E,
    0x1CE401,
    0xF37DC,
    0x745E6,
    0xC3C07,
    0x65222,
    0x305E6,
    0x33ADC,
    0x1DF5E6,
    0x1E017E6,
    0x1CE801,
    0x1193D09,
    0x20D1E6,
    0x318DC,
    0x822E6,
    0x116B707,
    0x310E6,
    0x821E6,
    0x10378E6,
    0x5A4DC,
    0xF83E6,
    0xAAC1E6,
    0x1DD0CA,
    0x1D185E6,
    0x8D1DC,
    0x5AFE6,
    0x1DE5E6,
    0x309908,
    0x365E6,
    0x951E6,
    0x369E6,
    0x748DC,
    0xEC97A,
    0x817E6,
    0x6DAE6,
    0x1E4EDE8,
    0x1CE501,
    0x737DC,
    0x311E6,
    0x6E3DC,
    0x1BF309,
    0x89BDC,
    0x11101E6,
    0x5C118,
    0x2DE8E6,
    0x614E6,
    0xFE2EE6,
    0x10379E6,
    0x1DCFDC,
    0x82CE6,
    0x32FDC,
    0x1B4409,
    0x171509,
    0x1ACBE6,
    0x1B6CDC,
    0xECA7A,
    0x1E015E6,
    0x20E601,
    0xFE24E6,
    0x1D243E6,
    0x1E021E6,
    0xE496B,
    0x71124,
    0x6DFE6,
    0xA9B307,
    0x65AE6,
    0x1A7FDC,
    0x8DAE6,
    0x8E1E6,
    0x11A9909,
    0x1D180DC,
    0xA8EFE6,
    0x1DF4E6,
    0x10377E6,
    0x362E9,
    0x594E6,
    0x33501,
    0x7F2DC,
    0x1D18ADC,
    0x1DCBE6,
    0x5A9E6,
    0x1CE601,
    0x34DDC,
    0xEC87A,
    0x6D7E6,
    0x108DDC,
    0x5C4E6,
    0x36AE6,
    0x326DC,
    0x1E00AE6,
    0xA8E0E6,
    0x5A7DC,
    0x1DEAE6,
    0x6D6E6,
    0xA8E7E6,
    0x30BE6,
    0x16AF001,
    0x1C3707,
    0x302EE0,
    0xE486B,
    0x1DD8E6,
    0x1AB8DC,
    0x1A18DC,
    0x2DF9E6,
    0xFB1E1A,
    0x363E6,
    0x74AE6,
    0x1E024E6,
    0x599E6,
    0x59EE6,
    0x7F3E6,
    0x1BF209,
    0x818E6,
    0xA8E9E6,
    0x16B36E6,
    0x10F50DC,
    0x1DD4E6,
    0xAAB2E6,
    0xA8E5E6,
    0x744DC,
    0x10F82E6,
    0x302DDE,
    0x331DC,
    0x1D188E6,
    0x7EDE6,
    0x1E006E6,
    0xAAB8E6,
    0x353DC,
    0x1E016E6,
    0x1DCADC,
    0x73FE6,
    0xF35DC,
    0xA69EE6,
    0x323DC,
    0x8E5E6,
    0x20ECDC,
    0x1E2EEE6,
    0x5AEE4,
    0x11371E6,
    0x1E029E6,
    0x734DC,
    0x1AB6DC,
    0x20E7E6,
    0x1D17DDC,
    0x8FDE6,
    0x9CD09,
    0xF82E6,
    0x1A7AE6,
    0x654E6,
    0x1E94A07,
];


pub(crate) const COMPOSITION_TABLE_SALT: &[u16] = &[
    0x0,
    0x0,
    0x0,
    0x0,
    0x25d,
    0x3,
    0x5d,
    0x0,
    0x2,
    0x9,
    0x4,
    0x87,
    0x6,
    0x135,
    0x1,
    0x0,
    0x0,
    0x4,
    0x3,
    0xe1,
    0x78,
    0x0,
    0x2,
    0x29,
    0x8,
    0x8f,
    0x24,
    0x0,
    0x0,
    0x0,
    0x31,
    0x0,
    0x0,
    0x6d,
    0x0,
    0x33,
    0x1,
    0x4c,
    0x0,
    0x1,
    0x0,
    0x0,
    0x8,
    0x7c,
    0x6,
    0x4c,
    0x45,
    0x2a,
    0x2,
    0x0,
    0x0,
    0x0,
    0xa,
    0x0,
    0x0,
    0x59,
    0x0,
    0x10,
    0x3,
    0x9,
    0xe,
    0x6,
    0x1,
    0xc,
    0x10,
    0x0,
    0x0,
    0x0,
    0x3d,
    0x0,
    0x0,
    0x2a,
    0x0,
    0x0,
    0x1,
    0x20,
    0xa,
    0x0,
    0x1,
    0xe,
    0x2,
    0x10,
    0x22,
    0x0,
    0x61,
    0x0,
    0x4,
    0x15,
    0x0,
    0x4,
    0x3,
    0x0,
    0x0,
    0x3,
    0x0,
    0xd,
    0x1,
    0x1,
    0x24,
    0x3,
    0x4,
    0x0,
    0x0,
    0x18,
    0x58,
    0x0,
    0x0,
    0xa,
    0x19,
    0x10,
    0x0,
    0x2,
    0x0,
    0x0,
    0x12,
    0x15,
    0x0,
    0xc,
    0x7,
    0x3,
    0x0,
    0x1a,
    0x7,
    0xc,
    0x1,
    0x5,
    0x4,
    0x21,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1,
    0xa,
    0x0,
    0xa,
    0x0,
    0x4,
    0x9,
    0x5,
    0xd,
    0x5,
    0x0,
    0x3,
    0x6,
    0x26,
    0xb,
    0x0,
    0x4,
    0x6,
    0x0,
    0x13,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x24,
    0x1,
    0x1d,
    0x1,
    0x0,
    0x0,
    0x10,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0xa,
    0x0,
    0xd,
    0x0,
    0x10,
    0x0,
    0x6,
    0x5,
    0x0,
    0x0,
    0x9,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x0,
    0x16,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x6,
    0x1,
    0x25,
    0x5,
    0x0,
    0xa,
    0xd,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x12,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x4,
    0x9,
    0x0,
    0x1,
    0x4,
    0x0,
    0x4,
    0x1,
    0x6,
    0xb,
    0x3,
    0x6,
    0x7,
    0x0,
    0x0,
    0x0,
    0xd,
    0xf,
    0xe,
    0x0,
    0x1,
    0x1,
    0x4,
    0xf,
    0x10,
    0x0,
    0x5,
    0x0,
    0x19,
    0x1,
    0xe,
    0x0,
    0x8,
    0x1,
    0x3,
    0x0,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x11,
    0x0,
    0x4,
    0x5,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x5,
    0x8,
    0x0,
    0x0,
    0xc,
    0xa,
    0x0,
    0x6,
    0x9,
    0x3,
    0x1,
    0x6,
    0x1,
    0x0,
    0x1b,
    0x1,
    0xe,
    0x0,
    0x8,
    0x5,
    0x3,
    0x15,
    0x0,
    0x2,
    0x7,
    0xb,
    0x3,
    0x0,
    0xa,
    0x3,
    0x0,
    0x6,
    0x0,
    0xa,
    0x0,
    0x1,
    0x3,
    0x8,
    0x0,
    0x9,
    0x0,
    0x1,
    0x2,
    0x0,
    0x5,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x17,
    0x0,
    0x0,
    0x2,
    0x0,
    0x5,
    0x16,
    0x0,
    0x10,
    0x3,
    0x4,
    0x11,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0x5,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x12,
    0x1,
    0x4,
    0xa,
    0xb,
    0x4,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x4,
    0x5,
    0x0,
    0x0,
    0x11,
    0x1,
    0x6,
    0x6,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x1,
    0x7,
    0x0,
    0x3,
    0xa,
    0x0,
    0x1,
    0xa,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0xd,
    0x5,
    0x1,
    0x1,
    0x0,
    0x0,
    0x5,
    0x6,
    0x8,
    0x4,
    0x5,
    0x0,
    0xb,
    0x0,
    0x4,
    0xb,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0xb,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x6,
    0x0,
    0x0,
    0x7,
    0x13,
    0x4,
    0x19,
    0x3,
    0x1,
    0x0,
    0x1,
    0x6,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0xc,
    0x2,
    0x3,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x1,
    0x5,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x7,
    0x1,
    0x9,
    0x6,
    0x4,
    0x1,
    0x5,
    0x0,
    0x1,
    0x2,
    0x8,
    0x0,
    0x9,
    0x0,
    0x0,
    0x1,
    0x3,
    0xb,
    0x0,
    0x1,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0x6,
    0x2,
    0x5,
    0x8,
    0x12,
    0x0,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x1,
    0x4,
    0xd,
    0x0,
    0x0,
    0xb,
    0x0,
    0x1,
    0x0,
    0x0,
    0xc,
    0x0,
    0x0,
    0x0,
    0x5,
    0x8,
    0x2,
    0x0,
    0x2,
    0x1,
    0x6,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x5,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0xe,
    0x10,
    0x0,
    0x5,
    0x4,
    0x2,
    0x1,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x1,
    0x4,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x5,
    0x2,
    0x3,
    0x4,
    0x0,
    0x3,
    0x3,
    0x6,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0xe,
    0x1,
    0x2,
    0x1,
    0x4,
    0x2,
    0x5,
    0x2,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x5,
    0x5,
    0x6,
    0x6,
    0x5,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x4,
    0x1,
    0x0,
    0x5,
    0x0,
    0x6,
    0x2,
    0x8,
    0x0,
    0x0,
    0x7,
    0x1,
    0x2,
    0x2,
    0x5,
    0x4,
    0x11,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x1,
    0x4,
    0x0,
    0x3,
    0x2,
    0x0,
    0x1,
    0x3,
    0x0,
    0xb,
    0x6,
    0x0,
    0x6,
    0x0,
    0x4,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x6,
    0x0,
    0x0,
    0x2,
    0x4,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0xc,
    0xc,
    0x0,
    0x0,
    0x0,
    0x4,
    0x4,
    0x0,
    0x8,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x5,
    0x0,
    0x5,
    0x1,
    0x0,
    0x3,
    0x4,
    0x1,
    0x2,
    0x3,
    0x0,
    0x1,
    0x7,
    0x0,
    0x0,
    0x7,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1,
    0xb,
    0x0,
    0x4,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x1,
    0x5,
    0x0,
    0x0,
    0x3,
    0x6,
    0x0,
    0x0,
    0x4,
    0x2,
    0x1,
    0x3,
    0x3,
    0xa,
    0x7,
    0x0,
    0x4,
    0x1,
    0x6,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x4,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x6,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x1,
    0x2,
    0x6,
    0x0,
    0x2,
    0x0,
    0x3,
    0x7,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x3,
    0x5,
    0x2,
    0x0,
    0x1,
    0x1,
    0x2,
    0x2,
    0x4,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x3,
    0x2,
    0x0,
    0x1,
    0x0,
    0x2,
    0x4,
    0x2,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x5,
    0x2,
    0x0,
    0x8,
    0x3,
    0x1,
    0x1,
    0x1,
    0x3,
    0x4,
    0x0,
    0x2,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x1,
    0x3,
    0x1,
    0x3,
    0x1,
    0x2,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x3,
    0x1,
    0x2,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x4,
    0x0,
    0x5,
    0x5,
    0x0,
    0x5,
    0x2,
    0x0,
    0x1,
    0x3,
    0x1,
    0x0,
    0x2,
    0x6,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
];
pub(crate) const COMPOSITION_TABLE_KV: &[(u32, char)] = &[
    (0x64A0654, '\u{0626}'),
    (0x690309, '\u{1EC9}'),
    (0x650306, '\u{0115}'),
    (0x423030B, '\u{04F2}'),
    (0x47030C, '\u{01E6}'),
    (0x570301, '\u{1E82}'),
    (0xC50301, '\u{01FA}'),
    (0x21D20338, '\u{21CF}'),
    (0x430307, '\u{010A}'),
    (0x7A0307, '\u{017C}'),
    (0x49030C, '\u{01CF}'),
    (0x720307, '\u{1E59}'),
    (0x304B3099, '\u{304C}'),
    (0x1F610345, '\u{1FA1}'),
    (0x410307, '\u{0226}'),
    (0x6B0323, '\u{1E33}'),
    (0x3990304, '\u{1FD9}'),
    (0x1F490301, '\u{1F4D}'),
    (0x3CA0342, '\u{1FD7}'),
    (0x550304, '\u{016A}'),
    (0x30DB309A, '\u{30DD}'),
    (0x1F6E0345, '\u{1FAE}'),
    (0x420331, '\u{1E06}'),
    (0x41E0308, '\u{04E6}'),
    (0x410325, '\u{1E00}'),
    (0x520331, '\u{1E5E}'),
    (0x1FF60345, '\u{1FF7}'),
    (0x22720338, '\u{2274}'),
    (0x22480338, '\u{2249}'),
    (0x1FBF0301, '\u{1FCE}'),
    (0x30C63099, '\u{30C7}'),
    (0x760323, '\u{1E7F}'),
    (0x700307, '\u{1E57}'),
    (0x1F510301, '\u{1F55}'),
    (0x750328, '\u{0173}'),
    (0x305B3099, '\u{305C}'),
    (0x41030A, '\u{00C5}'),
    (0x1A10323, '\u{1EE3}'),
    (0x550311, '\u{0216}'),
    (0x530307, '\u{1E60}'),
    (0xDC030C, '\u{01D9}'),
    (0x4F0300, '\u{00D2}'),
    (0x6F0307, '\u{022F}'),
    (0x470301, '\u{01F4}'),
    (0x610309, '\u{1EA3}'),
    (0x1F080301, '\u{1F0C}'),
    (0x3B90301, '\u{03AF}'),
    (0x4330301, '\u{0453}'),
    (0x1F200345, '\u{1F90}'),
    (0x620307, '\u{1E03}'),
    (0x1F030345, '\u{1F83}'),
    (0x570308, '\u{1E84}'),
    (0x5A0307, '\u{017B}'),
    (0x30C13099, '\u{30C2}'),
    (0x1A10309, '\u{1EDF}'),
    (0x6270655, '\u{0625}'),
    (0x3BF0314, '\u{1F41}'),
    (0x670301, '\u{01F5}'),
    (0x39F0301, '\u{038C}'),
    (0xEA0301, '\u{1EBF}'),
    (0x63030C, '\u{010D}'),
    (0x1F000345, '\u{1F80}'),
    (0x4130301, '\u{0403}'),
    (0x4B0323, '\u{1E32}'),
    (0x790301, '\u{00FD}'),
    (0x770301, '\u{1E83}'),
    (0x1F0E0345, '\u{1F8E}'),
    (0x480308, '\u{1E26}'),
    (0x30A63099, '\u{30F4}'),
    (0x1020300, '\u{1EB0}'),
    (0x6C0301, '\u{013A}'),
    (0x450309, '\u{1EBA}'),
    (0x1F390301, '\u{1F3D}'),
    (0x690311, '\u{020B}'),
    (0x4230304, '\u{04EE}'),
    (0x61030C, '\u{01CE}'),
    (0x1F100300, '\u{1F12}'),
    (0x4380300, '\u{045D}'),
    (0x480323, '\u{1E24}'),
    (0x1B111B35, '\u{1B12}'),
    (0x430301, '\u{0106}'),
    (0x540323, '\u{1E6C}'),
    (0x490303, '\u{0128}'),
    (0x1EA10302, '\u{1EAD}'),
    (0x4350308, '\u{0451}'),
    (0x610307, '\u{0227}'),
    (0x1F000300, '\u{1F02}'),
    (0x6D0307, '\u{1E41}'),
    (0x760303, '\u{1E7D}'),
    (0x730327, '\u{015F}'),
    (0x470304, '\u{1E20}'),
    (0x470306, '\u{011E}'),
    (0x1F6D0345, '\u{1FAD}'),
    (0x6F0303, '\u{00F5}'),
    (0x6B0331, '\u{1E35}'),
    (0x720331, '\u{1E5F}'),
    (0x1B00300, '\u{1EEB}'),
    (0x1B0B1B35, '\u{1B0C}'),
    (0x55032D, '\u{1E76}'),
    (0x61030A, '\u{00E5}'),
    (0x30463099, '\u{3094}'),
    (0x1B3A1B35, '\u{1B3B}'),
    (0x55030A, '\u{016E}'),
    (0x928093C, '\u{0929}'),
    (0x3C90313, '\u{1F60}'),
    (0x650330, '\u{1E1B}'),
    (0x590303, '\u{1EF8}'),
    (0x450330, '\u{1E1A}'),
    (0x640331, '\u{1E0F}'),
    (0x3B90308, '\u{03CA}'),
    (0x309D3099, '\u{309E}'),
    (0x443030B, '\u{04F3}'),
    (0xB470B3E, '\u{0B4B}'),
    (0x6F030F, '\u{020D}'),
    (0x6E0323, '\u{1E47}'),
    (0x690308, '\u{00EF}'),
    (0x65032D, '\u{1E19}'),
    (0x15A0307, '\u{1E64}'),
    (0x1F180301, '\u{1F1C}'),
    (0x1F090301, '\u{1F0D}'),
    (0x1F270345, '\u{1F97}'),
    (0x7A0302, '\u{1E91}'),
    (0x590301, '\u{00DD}'),
    (0x4C0331, '\u{1E3A}'),
    (0x1F640345, '\u{1FA4}'),
    (0x1EB90302, '\u{1EC7}'),
    (0x1F240345, '\u{1F94}'),
    (0x1130300, '\u{1E15}'),
    (0x69030F, '\u{0209}'),
    (0x740331, '\u{1E6F}'),
    (0x1F480301, '\u{1F4C}'),
    (0x7A0331, '\u{1E95}'),
    (0x1F290345, '\u{1F99}'),
    (0xD40301, '\u{1ED0}'),
    (0xC40304, '\u{01DE}'),
    (0x3970301, '\u{0389}'),
    (0x72030C, '\u{0159}'),
    (0x1F110301, '\u{1F15}'),
    (0xF40309, '\u{1ED5}'),
    (0x450327, '\u{0228}'),
    (0x6F031B, '\u{01A1}'),
    (0xC60304, '\u{01E2}'),
    (0x3990308, '\u{03AA}'),
    (0x3CE0345, '\u{1FF4}'),
    (0x6D0301, '\u{1E3F}'),
    (0x1030309, '\u{1EB3}'),
    (0x6F0302, '\u{00F4}'),
    (0x73030C, '\u{0161}'),
    (0x750301, '\u{00FA}'),
    (0x1F690301, '\u{1F6D}'),
    (0x3A90301, '\u{038F}'),
    (0x3D0338, '\u{2260}'),
    (0x1FC60345, '\u{1FC7}'),
    (0x770300, '\u{1E81}'),
    (0x2280306, '\u{1E1C}'),
    (0x6C0331, '\u{1E3B}'),
    (0x30AD3099, '\u{30AE}'),
    (0x1EB80302, '\u{1EC6}'),
    (0x550302, '\u{00DB}'),
    (0xDD90DCF, '\u{0DDC}'),
    (0x3A50304, '\u{1FE9}'),
    (0x3A90314, '\u{1F69}'),
    (0x740327, '\u{0163}'),
    (0x530326, '\u{0218}'),
    (0x55030B, '\u{0170}'),
    (0x306F309A, '\u{3071}'),
    (0x6B0327, '\u{0137}'),
    (0x750330, '\u{1E75}'),
    (0x730301, '\u{015B}'),
    (0x1F300342, '\u{1F36}'),
    (0x470307, '\u{0120}'),
    (0xCC60CD5, '\u{0CC7}'),
    (0x1F690300, '\u{1F6B}'),
    (0x1030301, '\u{1EAF}'),
    (0x750311, '\u{0217}'),
    (0x930093C, '\u{0931}'),
    (0x30613099, '\u{3062}'),
    (0x770323, '\u{1E89}'),
    (0xF50301, '\u{1E4D}'),
    (0xFC0300, '\u{01DC}'),
    (0x49030F, '\u{0208}'),
    (0x690302, '\u{00EE}'),
    (0x1F230345, '\u{1F93}'),
    (0xF40300, '\u{1ED3}'),
    (0x44B0308, '\u{04F9}'),
    (0x1F2E0345, '\u{1F9E}'),
    (0x650300, '\u{00E8}'),
    (0x490308, '\u{00CF}'),
    (0x1F280301, '\u{1F2C}'),
    (0x1F180300, '\u{1F1A}'),
    (0x6270653, '\u{0622}'),
    (0x1F200301, '\u{1F24}'),
    (0x22030338, '\u{2204}'),
    (0x790304, '\u{0233}'),
    (0x1F390300, '\u{1F3B}'),
    (0x610325, '\u{1E01}'),
    (0x790309, '\u{1EF7}'),
    (0x1AF0303, '\u{1EEE}'),
    (0x6F0301, '\u{00F3}'),
    (0x640323, '\u{1E0D}'),
    (0x304F3099, '\u{3050}'),
    (0x1F010345, '\u{1F81}'),
    (0xCA0309, '\u{1EC2}'),
    (0x3D20308, '\u{03D4}'),
    (0x1F500301, '\u{1F54}'),
    (0x1F010300, '\u{1F03}'),
    (0x3A90345, '\u{1FFC}'),
    (0x4270308, '\u{04F4}'),
    (0x530302, '\u{015C}'),
    (0x520301, '\u{0154}'),
    (0x450306, '\u{0114}'),
    (0x530323, '\u{1E62}'),
    (0x670306, '\u{011F}'),
    (0x22760338, '\u{2278}'),
    (0x4350300, '\u{0450}'),
    (0x30B53099, '\u{30B6}'),
    (0x6F030B, '\u{0151}'),
    (0x4180304, '\u{04E2}'),
    (0x630307, '\u{010B}'),
    (0x3D20301, '\u{03D3}'),
    (0x227C0338, '\u{22E0}'),
    (0x610304, '\u{0101}'),
    (0xA80300, '\u{1FED}'),
    (0x440331, '\u{1E0E}'),
    (0x650311, '\u{0207}'),
    (0xF80301, '\u{01FF}'),
    (0x75030C, '\u{01D4}'),
    (0x530327, '\u{015E}'),
    (0x30573099, '\u{3058}'),
    (0x3B70345, '\u{1FC3}'),
    (0x69030C, '\u{01D0}'),
    (0x6E0327, '\u{0146}'),
    (0x780307, '\u{1E8B}'),
    (0x1F000342, '\u{1F06}'),
    (0x1B00303, '\u{1EEF}'),
    (0x470327, '\u{0122}'),
    (0xC20309, '\u{1EA8}'),
    (0x6C032D, '\u{1E3D}'),
    (0x304D3099, '\u{304E}'),
    (0x690303, '\u{0129}'),
    (0x1AF0323, '\u{1EF0}'),
    (0x4F0302, '\u{00D4}'),
    (0x1020301, '\u{1EAE}'),
    (0x4470308, '\u{04F5}'),
    (0x22A80338, '\u{22AD}'),
    (0x3C50300, '\u{1F7A}'),
    (0x3910313, '\u{1F08}'),
    (0x64032D, '\u{1E13}'),
    (0xCF0301, '\u{1E2E}'),
    (0x61030F, '\u{0201}'),
    (0x1EA10306, '\u{1EB7}'),
    (0x790323, '\u{1EF5}'),
    (0x21900338, '\u{219A}'),
    (0x1F250345, '\u{1F95}'),
    (0x4F0304, '\u{014C}'),
    (0x4F0306, '\u{014E}'),
    (0x30B33099, '\u{30B4}'),
    (0x440327, '\u{1E10}'),
    (0xB920BD7, '\u{0B94}'),
    (0x550308, '\u{00DC}'),
    (0x650323, '\u{1EB9}'),
    (0x307B3099, '\u{307C}'),
    (0x4F030C, '\u{01D1}'),
    (0x670304, '\u{1E21}'),
    (0x6A030C, '\u{01F0}'),
    (0x550323, '\u{1EE4}'),
    (0x1A10301, '\u{1EDB}'),
    (0x590323, '\u{1EF4}'),
    (0x410300, '\u{00C0}'),
    (0x30B93099, '\u{30BA}'),
    (0x4230308, '\u{04F0}'),
    (0x530301, '\u{015A}'),
    (0x30D8309A, '\u{30DA}'),
    (0x750309, '\u{1EE7}'),
    (0x550330, '\u{1E74}'),
    (0x520327, '\u{0156}'),
    (0x4370308, '\u{04DF}'),
    (0xCA0300, '\u{1EC0}'),
    (0x21940338, '\u{21AE}'),
    (0x3B10306, '\u{1FB0}'),
    (0x1F610342, '\u{1F67}'),
    (0x223C0338, '\u{2241}'),
    (0x30D23099, '\u{30D3}'),
    (0x1F6B0345, '\u{1FAB}'),
    (0x490307, '\u{0130}'),
    (0x410323, '\u{1EA0}'),
    (0x550309, '\u{1EE6}'),
    (0x75030B, '\u{0171}'),
    (0x30533099, '\u{3054}'),
    (0x305D3099, '\u{305E}'),
    (0x4C0323, '\u{1E36}'),
    (0x2260304, '\u{01E0}'),
    (0x475030F, '\u{0477}'),
    (0x490328, '\u{012E}'),
    (0x1F210300, '\u{1F23}'),
    (0x1F610301, '\u{1F65}'),
    (0x1F210342, '\u{1F27}'),
    (0x670302, '\u{011D}'),
    (0x4E0301, '\u{0143}'),
    (0x4E0303, '\u{00D1}'),
    (0x3990300, '\u{1FDA}'),
    (0x3BF0301, '\u{03CC}'),
    (0x4150300, '\u{0400}'),
    (0x3C90314, '\u{1F61}'),
    (0x22A20338, '\u{22AC}'),
    (0x30DB3099, '\u{30DC}'),
    (0x3A50314, '\u{1F59}'),
    (0x52030F, '\u{0210}'),
    (0x4E0323, '\u{1E46}'),
    (0x1F0D0345, '\u{1F8D}'),
    (0x1ECD0302, '\u{1ED9}'),
    (0xFC030C, '\u{01DA}'),
    (0xD60304, '\u{022A}'),
    (0x1F000301, '\u{1F04}'),
    (0x30CF3099, '\u{30D0}'),
    (0x4350306, '\u{04D7}'),
    (0x220B0338, '\u{220C}'),
    (0x590300, '\u{1EF2}'),
    (0x4170308, '\u{04DE}'),
    (0x6E030C, '\u{0148}'),
    (0x4C030C, '\u{013D}'),
    (0x1690301, '\u{1E79}'),
    (0x4100308, '\u{04D2}'),
    (0x1A00301, '\u{1EDA}'),
    (0x41030F, '\u{0200}'),
    (0x720301, '\u{0155}'),
    (0x450303, '\u{1EBC}'),
    (0x1B0D1B35, '\u{1B0E}'),
    (0x1120301, '\u{1E16}'),
    (0x4A0302, '\u{0134}'),
    (0x3BF0300, '\u{1F78}'),
    (0x30593099, '\u{305A}'),
    (0x4F030B, '\u{0150}'),
    (0x610328, '\u{0105}'),
    (0x30D83099, '\u{30D9}'),
    (0x1F2B0345, '\u{1F9B}'),
    (0x1F400301, '\u{1F44}'),
    (0x65030F, '\u{0205}'),
    (0x3AE0345, '\u{1FC4}'),
    (0x1680301, '\u{1E78}'),
    (0x740326, '\u{021B}'),
    (0x3B90342, '\u{1FD6}'),
    (0x1F6F0345, '\u{1FAF}'),
    (0x3A50301, '\u{038E}'),
    (0x1F090345, '\u{1F89}'),
    (0x550300, '\u{00D9}'),
    (0x41030C, '\u{01CD}'),
    (0x430327, '\u{00C7}'),
    (0x460307, '\u{1E1E}'),
    (0x3B50301, '\u{03AD}'),
    (0xD470D3E, '\u{0D4B}'),
    (0x610311, '\u{0203}'),
    (0xD50308, '\u{1E4E}'),
    (0x3C90300, '\u{1F7C}'),
    (0x4430306, '\u{045E}'),
    (0x1FFE0301, '\u{1FDE}'),
    (0x3990301, '\u{038A}'),
    (0x790307, '\u{1E8F}'),
    (0x1E5A0304, '\u{1E5C}'),
    (0x75030F, '\u{0215}'),
    (0x9C709BE, '\u{09CB}'),
    (0x1B071B35, '\u{1B08}'),
    (0x690330, '\u{1E2D}'),
    (0x307B309A, '\u{307D}'),
    (0x30C83099, '\u{30C9}'),
    (0x22B30338, '\u{22EB}'),
    (0x1B00301, '\u{1EE9}'),
    (0x790300, '\u{1EF3}'),
    (0x570307, '\u{1E86}'),
    (0x690328, '\u{012F}'),
    (0x5A0323, '\u{1E92}'),
    (0x3C50342, '\u{1FE6}'),
    (0x4F0309, '\u{1ECE}'),
    (0x1F290342, '\u{1F2F}'),
    (0x1A00300, '\u{1EDC}'),
    (0x1F2A0345, '\u{1F9A}'),
    (0x14D0301, '\u{1E53}'),
    (0x21D00338, '\u{21CD}'),
    (0x550328, '\u{0172}'),
    (0x680331, '\u{1E96}'),
    (0x68030C, '\u{021F}'),
    (0x4C0301, '\u{0139}'),
    (0x22860338, '\u{2288}'),
    (0x39F0314, '\u{1F49}'),
    (0x3A50306, '\u{1FE8}'),
    (0xB470B56, '\u{0B48}'),
    (0x30753099, '\u{3076}'),
    (0x1E5B0304, '\u{1E5D}'),
    (0x1F6A0345, '\u{1FAA}'),
    (0x540327, '\u{0162}'),
    (0x1020303, '\u{1EB4}'),
    (0x39F0313, '\u{1F48}'),
    (0x1F090342, '\u{1F0F}'),
    (0x4100306, '\u{04D0}'),
    (0x14D0300, '\u{1E51}'),
    (0x4430304, '\u{04EF}'),
    (0x21920338, '\u{219B}'),
    (0x22610338, '\u{2262}'),
    (0xF50304, '\u{022D}'),
    (0x3B90313, '\u{1F30}'),
    (0x6F0308, '\u{00F6}'),
    (0x730307, '\u{1E61}'),
    (0x75031B, '\u{01B0}'),
    (0x30B73099, '\u{30B8}'),
    (0x1E620307, '\u{1E68}'),
    (0x410306, '\u{0102}'),
    (0x3970314, '\u{1F29}'),
    (0x630302, '\u{0109}'),
    (0x6A0302, '\u{0135}'),
    (0xE50301, '\u{01FB}'),
    (0x730326, '\u{0219}'),
    (0x1F740345, '\u{1FC2}'),
    (0x650309, '\u{1EBB}'),
    (0x5A030C, '\u{017D}'),
    (0x22250338, '\u{2226}'),
    (0x3A90313, '\u{1F68}'),
    (0x720327, '\u{0157}'),
    (0x1F090300, '\u{1F0B}'),
    (0x4360308, '\u{04DD}'),
    (0x1F080345, '\u{1F88}'),
    (0x620331, '\u{1E07}'),
    (0x22730338, '\u{2275}'),
    (0x560323, '\u{1E7E}'),
    (0x4F0323, '\u{1ECC}'),
    (0x22E0304, '\u{0230}'),
    (0x6D50654, '\u{06C0}'),
    (0x3B10313, '\u{1F00}'),
    (0x4F0303, '\u{00D5}'),
    (0x1F010301, '\u{1F05}'),
    (0x650304, '\u{0113}'),
    (0x450323, '\u{1EB8}'),
    (0xBC60BBE, '\u{0BCA}'),
    (0x22650338, '\u{2271}'),
    (0x3910314, '\u{1F09}'),
    (0x1120300, '\u{1E14}'),
    (0x4E0307, '\u{1E44}'),
    (0x680308, '\u{1E27}'),
    (0x4F0311, '\u{020E}'),
    (0x550303, '\u{0168}'),
    (0x3A10314, '\u{1FEC}'),
    (0x3B10301, '\u{03AC}'),
    (0x55030F, '\u{0214}'),
    (0x3E0338, '\u{226F}'),
    (0x1610307, '\u{1E67}'),
    (0x1F040345, '\u{1F84}'),
    (0x450300, '\u{00C8}'),
    (0x1B091B35, '\u{1B0A}'),
    (0x30FD3099, '\u{30FE}'),
    (0x1F680301, '\u{1F6C}'),
    (0x650303, '\u{1EBD}'),
    (0x3B90304, '\u{1FD1}'),
    (0x9C709D7, '\u{09CC}'),
    (0x42B0308, '\u{04F8}'),
    (0x4E0327, '\u{0145}'),
    (0x1F630345, '\u{1FA3}'),
    (0x4380306, '\u{0439}'),
    (0x3B10314, '\u{1F01}'),
    (0x540326, '\u{021A}'),
    (0x740307, '\u{1E6B}'),
    (0x3C90301, '\u{03CE}'),
    (0x3990314, '\u{1F39}'),
    (0x30B13099, '\u{30B2}'),
    (0x750302, '\u{00FB}'),
    (0xCC60CD6, '\u{0CC8}'),
    (0x30BD3099, '\u{30BE}'),
    (0x6E0300, '\u{01F9}'),
    (0x1F390342, '\u{1F3F}'),
    (0x2270304, '\u{01E1}'),
    (0x22080338, '\u{2209}'),
    (0x4180306, '\u{0419}'),
    (0x44030C, '\u{010E}'),
    (0x75030A, '\u{016F}'),
    (0x6270654, '\u{0623}'),
    (0x750306, '\u{016D}'),
    (0x3B70300, '\u{1F74}'),
    (0x1F660345, '\u{1FA6}'),
    (0x1F690345, '\u{1FA9}'),
    (0x15B0307, '\u{1E65}'),
    (0x1F280342, '\u{1F2E}'),
    (0x1F700345, '\u{1FB2}'),
    (0x1F0F0345, '\u{1F8F}'),
    (0x540331, '\u{1E6E}'),
    (0x227B0338, '\u{2281}'),
    (0x22870338, '\u{2289}'),
    (0x1F010342, '\u{1F07}'),
    (0x3A50308, '\u{03AB}'),
    (0x1F650345, '\u{1FA5}'),
    (0xD40300, '\u{1ED2}'),
    (0xF60304, '\u{022B}'),
    (0xCBF0CD5, '\u{0CC0}'),
    (0x1F380342, '\u{1F3E}'),
    (0x22B20338, '\u{22EA}'),
    (0x72030F, '\u{0211}'),
    (0x30BF3099, '\u{30C0}'),
    (0x4E90308, '\u{04EB}'),
    (0x22830338, '\u{2285}'),
    (0x3CB0300, '\u{1FE2}'),
    (0xCA0301, '\u{1EBE}'),
    (0x590304, '\u{0232}'),
    (0x690301, '\u{00ED}'),
    (0x305F3099, '\u{3060}'),
    (0x440307, '\u{1E0A}'),
    (0x1ECC0302, '\u{1ED8}'),
    (0x1F210345, '\u{1F91}'),
    (0x410311, '\u{0202}'),
    (0x720311, '\u{0213}'),
    (0x3A50300, '\u{1FEA}'),
    (0x1F590300, '\u{1F5B}'),
    (0xE40304, '\u{01DF}'),
    (0x1F500300, '\u{1F52}'),
    (0x224D0338, '\u{226D}'),
    (0x6E0301, '\u{0144}'),
    (0x75032D, '\u{1E77}'),
    (0xF40301, '\u{1ED1}'),
    (0x3C90342, '\u{1FF6}'),
    (0x3B70301, '\u{03AE}'),
    (0x6E0307, '\u{1E45}'),
    (0x410304, '\u{0100}'),
    (0x1F190301, '\u{1F1D}'),
    (0x3B10304, '\u{1FB1}'),
    (0x3078309A, '\u{307A}'),
    (0x570323, '\u{1E88}'),
    (0x4430308, '\u{04F1}'),
    (0x45032D, '\u{1E18}'),
    (0x4150308, '\u{0401}'),
    (0x4F0328, '\u{01EA}'),
    (0x4D90308, '\u{04DB}'),
    (0x4060308, '\u{0407}'),
    (0xF40303, '\u{1ED7}'),
    (0x3B90306, '\u{1FD0}'),
    (0x650307, '\u{0117}'),
    (0x1F680342, '\u{1F6E}'),
    (0x4380304, '\u{04E3}'),
    (0x1F410300, '\u{1F43}'),
    (0x1FFE0300, '\u{1FDD}'),
    (0x4F0301, '\u{00D3}'),
    (0x640327, '\u{1E11}'),
    (0x2290306, '\u{1E1D}'),
    (0x7A0301, '\u{017A}'),
    (0x620323, '\u{1E05}'),
    (0x1F7C0345, '\u{1FF2}'),
    (0x1B00323, '\u{1EF1}'),
    (0x1F600301, '\u{1F64}'),
    (0x30663099, '\u{3067}'),
    (0x22640338, '\u{2270}'),
    (0x1F310300, '\u{1F33}'),
    (0x610323, '\u{1EA1}'),
    (0x1F480300, '\u{1F4A}'),
    (0x550301, '\u{00DA}'),
    (0xC460C56, '\u{0C48}'),
    (0x3CA0300, '\u{1FD2}'),
    (0x1B7030C, '\u{01EE}'),
    (0x720323, '\u{1E5B}'),
    (0x1F200342, '\u{1F26}'),
    (0x4300308, '\u{04D3}'),
    (0x22820338, '\u{2284}'),
    (0x1F590301, '\u{1F5D}'),
    (0x1F080342, '\u{1F0E}'),
    (0x440323, '\u{1E0C}'),
    (0x1025102E, '\u{1026}'),
    (0x3910304, '\u{1FB9}'),
    (0x4B0331, '\u{1E34}'),
    (0x690300, '\u{00EC}'),
    (0x48032E, '\u{1E2A}'),
    (0x630301, '\u{0107}'),
    (0x1F690342, '\u{1F6F}'),
    (0x3B50313, '\u{1F10}'),
    (0x30CF309A, '\u{30D1}'),
    (0x4E030C, '\u{0147}'),
    (0xB470B57, '\u{0B4C}'),
    (0x3910301, '\u{0386}'),
    (0x650328, '\u{0119}'),
    (0x1FBF0300, '\u{1FCD}'),
    (0x3B70342, '\u{1FC6}'),
    (0x450307, '\u{0116}'),
    (0x1F380301, '\u{1F3C}'),
    (0x3075309A, '\u{3077}'),
    (0x4B0301, '\u{1E30}'),
    (0x1030300, '\u{1EB1}'),
    (0xE20303, '\u{1EAB}'),
    (0x410302, '\u{00C2}'),
    (0x650308, '\u{00EB}'),
    (0x580307, '\u{1E8A}'),
    (0x54030C, '\u{0164}'),
    (0x3C50313, '\u{1F50}'),
    (0x3B50314, '\u{1F11}'),
    (0x1B3E1B35, '\u{1B40}'),
    (0x1F100301, '\u{1F14}'),
    (0x3072309A, '\u{3074}'),
    (0x1F280345, '\u{1F98}'),
    (0x22770338, '\u{2279}'),
    (0x227A0338, '\u{2280}'),
    (0x470302, '\u{011C}'),
    (0x450308, '\u{00CB}'),
    (0x550324, '\u{1E72}'),
    (0x1F2C0345, '\u{1F9C}'),
    (0x4B0327, '\u{0136}'),
    (0x490302, '\u{00CE}'),
    (0x680302, '\u{0125}'),
    (0x520307, '\u{1E58}'),
    (0x610301, '\u{00E1}'),
    (0x4B030C, '\u{01E8}'),
    (0x490309, '\u{1EC8}'),
    (0x6C030C, '\u{013E}'),
    (0x4D0307, '\u{1E40}'),
    (0x1E360304, '\u{1E38}'),
    (0x3C50304, '\u{1FE1}'),
    (0x79030A, '\u{1E99}'),
    (0x3970313, '\u{1F28}'),
    (0x54032D, '\u{1E70}'),
    (0x1F490300, '\u{1F4B}'),
    (0x1B421B35, '\u{1B43}'),
    (0x3B70313, '\u{1F20}'),
    (0xEF0301, '\u{1E2F}'),
    (0xE70301, '\u{1E09}'),
    (0x16A0308, '\u{1E7A}'),
    (0xCA0303, '\u{1EC4}'),
    (0x3B10300, '\u{1F70}'),
    (0x6D20654, '\u{06D3}'),
    (0x30D53099, '\u{30D6}'),
    (0x1F2F0345, '\u{1F9F}'),
    (0x3B50300, '\u{1F72}'),
    (0x750324, '\u{1E73}'),
    (0x4150306, '\u{04D6}'),
    (0x65030C, '\u{011B}'),
    (0x570302, '\u{0174}'),
    (0x1EA00306, '\u{1EB6}'),
    (0x1F070345, '\u{1F87}'),
    (0xA80301, '\u{0385}'),
    (0x790302, '\u{0177}'),
    (0x6E032D, '\u{1E4B}'),
    (0x6F030C, '\u{01D2}'),
    (0x3C90345, '\u{1FF3}'),
    (0x430302, '\u{0108}'),
    (0x790303, '\u{1EF9}'),
    (0x740323, '\u{1E6D}'),
    (0xE20309, '\u{1EA9}'),
    (0x1F300300, '\u{1F32}'),
    (0x6B0301, '\u{1E31}'),
    (0x22920338, '\u{22E3}'),
    (0x3950314, '\u{1F19}'),
    (0x1F290301, '\u{1F2D}'),
    (0x450328, '\u{0118}'),
    (0x1FB60345, '\u{1FB7}'),
    (0xD50304, '\u{022C}'),
    (0x4300306, '\u{04D1}'),
    (0xF50308, '\u{1E4F}'),
    (0x1EA00302, '\u{1EAC}'),
    (0x1F680300, '\u{1F6A}'),
    (0x3970300, '\u{1FCA}'),
    (0x450301, '\u{00C9}'),
    (0x690304, '\u{012B}'),
    (0xBC60BD7, '\u{0BCC}'),
    (0x6F0304, '\u{014D}'),
    (0x4F0308, '\u{00D6}'),
    (0xBC70BBE, '\u{0BCB}'),
    (0x55030C, '\u{01D3}'),
    (0x3AC0345, '\u{1FB4}'),
    (0x1FBF0342, '\u{1FCF}'),
    (0x30D2309A, '\u{30D4}'),
    (0x660307, '\u{1E1F}'),
    (0x4E0300, '\u{01F8}'),
    (0x790308, '\u{00FF}'),
    (0x68032E, '\u{1E2B}'),
    (0x64030C, '\u{010F}'),
    (0x4F0307, '\u{022E}'),
    (0x1F590342, '\u{1F5F}'),
    (0x30AF3099, '\u{30B0}'),
    (0xE60304, '\u{01E3}'),
    (0x3C50301, '\u{03CD}'),
    (0x770308, '\u{1E85}'),
    (0x3B90314, '\u{1F31}'),
    (0x750323, '\u{1EE5}'),
    (0x590309, '\u{1EF6}'),
    (0x292030C, '\u{01EF}'),
    (0x550306, '\u{016C}'),
    (0xE60301, '\u{01FD}'),
    (0x16B0308, '\u{1E7B}'),
    (0x4F030F, '\u{020C}'),
    (0x3BF0313, '\u{1F40}'),
    (0xD80301, '\u{01FE}'),
    (0xC20303, '\u{1EAA}'),
    (0x1F510300, '\u{1F53}'),
    (0x1B00309, '\u{1EED}'),
    (0x4E032D, '\u{1E4A}'),
    (0x6F0309, '\u{1ECF}'),
    (0x4180300, '\u{040D}'),
    (0x22A90338, '\u{22AE}'),
    (0x1F680345, '\u{1FA8}'),
    (0x1B3C1B35, '\u{1B3D}'),
    (0x1F400300, '\u{1F42}'),
    (0x1F0B0345, '\u{1F8B}'),
    (0x3C50306, '\u{1FE0}'),
    (0x44032D, '\u{1E12}'),
    (0xCCA0CD5, '\u{0CCB}'),
    (0xEA0303, '\u{1EC5}'),
    (0x4230306, '\u{040E}'),
    (0xC70301, '\u{1E08}'),
    (0x7A030C, '\u{017E}'),
    (0x670307, '\u{0121}'),
    (0x450311, '\u{0206}'),
    (0x6F0300, '\u{00F2}'),
    (0x30BB3099, '\u{30BC}'),
    (0x4180308, '\u{04E4}'),
    (0x30513099, '\u{3052}'),
    (0x6C0323, '\u{1E37}'),
    (0x3B70314, '\u{1F21}'),
    (0x77030A, '\u{1E98}'),
    (0x690323, '\u{1ECB}'),
    (0x610303, '\u{00E3}'),
    (0x30F13099, '\u{30F9}'),
    (0x3B10345, '\u{1FB3}'),
    (0xD460D3E, '\u{0D4A}'),
    (0x3B90300, '\u{1F76}'),
    (0x21D40338, '\u{21CE}'),
    (0x1F620345, '\u{1FA2}'),
    (0x770302, '\u{0175}'),
    (0xFC0304, '\u{01D6}'),
    (0x1130301, '\u{1E17}'),
    (0x30683099, '\u{3069}'),
    (0x1F600342, '\u{1F66}'),
    (0x680323, '\u{1E25}'),
    (0x3950313, '\u{1F18}'),
    (0xEA0300, '\u{1EC1}'),
    (0x3CB0342, '\u{1FE7}'),
    (0x22430338, '\u{2244}'),
    (0x30783099, '\u{3079}'),
    (0x3990313, '\u{1F38}'),
    (0x490330, '\u{1E2C}'),
    (0x770307, '\u{1E87}'),
    (0x650301, '\u{00E9}'),
    (0x680327, '\u{1E29}'),
    (0x22B50338, '\u{22ED}'),
    (0x3B10342, '\u{1FB6}'),
    (0x3910306, '\u{1FB8}'),
    (0x4D0301, '\u{1E3E}'),
    (0x410309, '\u{1EA2}'),
    (0x1B051B35, '\u{1B06}'),
    (0x3C0338, '\u{226E}'),
    (0x590308, '\u{0178}'),
    (0x1030303, '\u{1EB5}'),
    (0x480327, '\u{1E28}'),
    (0x6D0323, '\u{1E43}'),
    (0x30643099, '\u{3065}'),
    (0x4560308, '\u{0457}'),
    (0x590302, '\u{0176}'),
    (0x6C10654, '\u{06C2}'),
    (0x43A0301, '\u{045C}'),
    (0xE20300, '\u{1EA7}'),
    (0x3950301, '\u{0388}'),
    (0x630327, '\u{00E7}'),
    (0x17F0307, '\u{1E9B}'),
    (0x6480654, '\u{0624}'),
    (0x30AB3099, '\u{30AC}'),
    (0x1A00323, '\u{1EE2}'),
    (0x4D80308, '\u{04DA}'),
    (0x5A0331, '\u{1E94}'),
    (0x67030C, '\u{01E7}'),
    (0x39F0300, '\u{1FF8}'),
    (0x650327, '\u{0229}'),
    (0x490323, '\u{1ECA}'),
    (0x1F110300, '\u{1F13}'),
    (0x1F510342, '\u{1F57}'),
    (0x4D0323, '\u{1E42}'),
    (0x1F300301, '\u{1F34}'),
    (0x6C0327, '\u{013C}'),
    (0x1F050345, '\u{1F85}'),
    (0x1A10300, '\u{1EDD}'),
    (0x4160308, '\u{04DC}'),
    (0x640307, '\u{1E0B}'),
    (0x4C032D, '\u{1E3C}'),
    (0x3C10314, '\u{1FE5}'),
    (0x1EA0304, '\u{01EC}'),
    (0x1F080300, '\u{1F0A}'),
    (0x650302, '\u{00EA}'),
    (0x3910300, '\u{1FBA}'),
    (0x700301, '\u{1E55}'),
    (0x1F020345, '\u{1F82}'),
    (0x1020309, '\u{1EB2}'),
    (0x750303, '\u{0169}'),
    (0x1F0C0345, '\u{1F8C}'),
    (0x3CB0301, '\u{03B0}'),
    (0x740308, '\u{1E97}'),
    (0x3950300, '\u{1FC8}'),
    (0x227D0338, '\u{22E1}'),
    (0x7A0323, '\u{1E93}'),
    (0x6F0311, '\u{020F}'),
    (0x6F0328, '\u{01EB}'),
    (0x1F200300, '\u{1F22}'),
    (0x1F190300, '\u{1F1B}'),
    (0x560303, '\u{1E7C}'),
    (0x6B030C, '\u{01E9}'),
    (0x4E80308, '\u{04EA}'),
    (0x3A90300, '\u{1FFA}'),
    (0xA80342, '\u{1FC1}'),
    (0x4360306, '\u{04C2}'),
    (0xDC0301, '\u{01D7}'),
    (0x750304, '\u{016B}'),
    (0x22450338, '\u{2247}'),
    (0x490304, '\u{012A}'),
    (0x4380308, '\u{04E5}'),
    (0xD460D57, '\u{0D4C}'),
    (0x750300, '\u{00F9}'),
    (0x22B40338, '\u{22EC}'),
    (0x750308, '\u{00FC}'),
    (0x3C50314, '\u{1F51}'),
    (0x1600307, '\u{1E66}'),
    (0x4160306, '\u{04C1}'),
    (0x55031B, '\u{01AF}'),
    (0x22AB0338, '\u{22AF}'),
    (0x14C0300, '\u{1E50}'),
    (0x1F310342, '\u{1F37}'),
    (0x1F260345, '\u{1F96}'),
    (0x22910338, '\u{22E2}'),
    (0x500301, '\u{1E54}'),
    (0x4C0327, '\u{013B}'),
    (0x5A0301, '\u{0179}'),
    (0x420307, '\u{1E02}'),
    (0x3C10313, '\u{1FE4}'),
    (0x1F410301, '\u{1F45}'),
    (0x500307, '\u{1E56}'),
    (0x43030C, '\u{010C}'),
    (0x730323, '\u{1E63}'),
    (0x30553099, '\u{3056}'),
    (0x306F3099, '\u{3070}'),
    (0x44D0308, '\u{04ED}'),
    (0x1F670345, '\u{1FA7}'),
    (0x1AF0301, '\u{1EE8}'),
    (0x1F290300, '\u{1F2B}'),
    (0x1B3F1B35, '\u{1B41}'),
    (0x450302, '\u{00CA}'),
    (0x6F0306, '\u{014F}'),
    (0xFC0301, '\u{01D8}'),
    (0x30F23099, '\u{30FA}'),
    (0x1F2D0345, '\u{1F9D}'),
    (0x14C0301, '\u{1E52}'),
    (0x610308, '\u{00E4}'),
    (0x1F600345, '\u{1FA0}'),
    (0x1F0A0345, '\u{1F8A}'),
    (0x610306, '\u{0103}'),
    (0x1F600300, '\u{1F62}'),
    (0x1AF0300, '\u{1EEA}'),
    (0x43E0308, '\u{04E7}'),
    (0x22230338, '\u{2224}'),
    (0x3CA0301, '\u{0390}'),
    (0x30D5309A, '\u{30D7}'),
    (0x1F220345, '\u{1F92}'),
    (0xD50301, '\u{1E4C}'),
    (0x1F6C0345, '\u{1FAC}'),
    (0x540307, '\u{1E6A}'),
    (0x1E370304, '\u{1E39}'),
    (0xDD90DCA, '\u{0DDA}'),
    (0x1A10303, '\u{1EE1}'),
    (0x48030C, '\u{021E}'),
    (0xEA0309, '\u{1EC3}'),
    (0x52030C, '\u{0158}'),
    (0xD40303, '\u{1ED6}'),
    (0x45030C, '\u{011A}'),
    (0x30EF3099, '\u{30F7}'),
    (0x480302, '\u{0124}'),
    (0x520323, '\u{1E5A}'),
    (0xC20300, '\u{1EA6}'),
    (0x74032D, '\u{1E71}'),
    (0x42D0308, '\u{04EC}'),
    (0xDD90DDF, '\u{0DDE}'),
    (0x410308, '\u{00C4}'),
    (0x474030F, '\u{0476}'),
    (0xC60301, '\u{01FC}'),
    (0x1F310301, '\u{1F35}'),
    (0x1F610300, '\u{1F63}'),
    (0xCC60CC2, '\u{0CCA}'),
    (0xC20301, '\u{1EA4}'),
    (0x3C50308, '\u{03CB}'),
    (0xE20301, '\u{1EA5}'),
    (0x1F500342, '\u{1F56}'),
    (0x610300, '\u{00E0}'),
    (0x490311, '\u{020A}'),
    (0x670327, '\u{0123}'),
    (0x590307, '\u{1E8E}'),
    (0x3970345, '\u{1FCC}'),
    (0xD40309, '\u{1ED4}'),
    (0x1A00303, '\u{1EE0}'),
    (0x1FFE0342, '\u{1FDF}'),
    (0x41A0301, '\u{040C}'),
    (0x74030C, '\u{0165}'),
    (0xDC0300, '\u{01DB}'),
    (0x780308, '\u{1E8D}'),
    (0xDC0304, '\u{01D5}'),
    (0x610302, '\u{00E2}'),
    (0x5A0302, '\u{1E90}'),
    (0x933093C, '\u{0934}'),
    (0x4F031B, '\u{01A0}'),
    (0x520311, '\u{0212}'),
    (0x6E0303, '\u{00F1}'),
    (0x45030F, '\u{0204}'),
    (0x1AF0309, '\u{1EEC}'),
    (0x450304, '\u{0112}'),
    (0x1F210301, '\u{1F25}'),
    (0x22F0304, '\u{0231}'),
    (0x3990306, '\u{1FD8}'),
    (0x4E0331, '\u{1E48}'),
    (0x1F380300, '\u{1F3A}'),
    (0x490306, '\u{012C}'),
    (0x690306, '\u{012D}'),
    (0x1F060345, '\u{1F86}'),
    (0x490301, '\u{00CD}'),
    (0x570300, '\u{1E80}'),
    (0x30F03099, '\u{30F8}'),
    (0x53030C, '\u{0160}'),
    (0x490300, '\u{00CC}'),
    (0x30723099, '\u{3073}'),
    (0x1F280300, '\u{1F2A}'),
    (0x480307, '\u{1E22}'),
    (0x1A00309, '\u{1EDE}'),
    (0x1EB0304, '\u{01ED}'),
    (0x1E630307, '\u{1E69}'),
    (0x6F0323, '\u{1ECD}'),
    (0x410303, '\u{00C3}'),
    (0x3910345, '\u{1FBC}'),
    (0x410328, '\u{0104}'),
    (0x680307, '\u{1E23}'),
    (0x6E0331, '\u{1E49}'),
    (0xDDC0DCA, '\u{0DDD}'),
    (0x580308, '\u{1E8C}'),
    (0x410301, '\u{00C1}'),
    (0x30C43099, '\u{30C5}'),
    (0x420323, '\u{1E04}'),
    (0x730302, '\u{015D}'),
];

pub(crate) fn composition_table_astral(c1: char, c2: char) -> Option<char> {
    match (c1, c2) {
        ('\u{11099}', '\u{110BA}') => Some('\u{1109A}'),
        ('\u{1109B}', '\u{110BA}') => Some('\u{1109C}'),
        ('\u{110A5}', '\u{110BA}') => Some('\u{110AB}'),
        ('\u{11131}', '\u{11127}') => Some('\u{1112E}'),
        ('\u{11132}', '\u{11127}') => Some('\u{1112F}'),
        ('\u{11347}', '\u{1133E}') => Some('\u{1134B}'),
        ('\u{11347}', '\u{11357}') => Some('\u{1134C}'),
        ('\u{114B9}', '\u{114B0}') => Some('\u{114BC}'),
        ('\u{114B9}', '\u{114BA}') => Some('\u{114BB}'),
        ('\u{114B9}', '\u{114BD}') => Some('\u{114BE}'),
        ('\u{115B8}', '\u{115AF}') => Some('\u{115BA}'),
        ('\u{115B9}', '\u{115AF}') => Some('\u{115BB}'),
        ('\u{11935}', '\u{11930}') => Some('\u{11938}'),
        _ => None,
    }
}

pub(crate) const CANONICAL_DECOMPOSED_CHARS: &[char] = &[
    '\u{0041}',
    '\u{0300}',
    '\u{0041}',
    '\u{0301}',
    '\u{0041}',
    '\u{0302}',
    '\u{0041}',
    '\u{0303}',
    '\u{0041}',
    '\u{0308}',
    '\u{0041}',
    '\u{030A}',
    '\u{0043}',
    '\u{0327}',
    '\u{0045}',
    '\u{0300}',
    '\u{0045}',
    '\u{0301}',
    '\u{0045}',
    '\u{0302}',
    '\u{0045}',
    '\u{0308}',
    '\u{0049}',
    '\u{0300}',
    '\u{0049}',
    '\u{0301}',
    '\u{0049}',
    '\u{0302}',
    '\u{0049}',
    '\u{0308}',
    '\u{004E}',
    '\u{0303}',
    '\u{004F}',
    '\u{0300}',
    '\u{004F}',
    '\u{0301}',
    '\u{004F}',
    '\u{0302}',
    '\u{004F}',
    '\u{0303}',
    '\u{004F}',
    '\u{0308}',
    '\u{0055}',
    '\u{0300}',
    '\u{0055}',
    '\u{0301}',
    '\u{0055}',
    '\u{0302}',
    '\u{0055}',
    '\u{0308}',
    '\u{0059}',
    '\u{0301}',
    '\u{0061}',
    '\u{0300}',
    '\u{0061}',
    '\u{0301}',
    '\u{0061}',
    '\u{0302}',
    '\u{0061}',
    '\u{0303}',
    '\u{0061}',
    '\u{0308}',
    '\u{0061}',
    '\u{030A}',
    '\u{0063}',
    '\u{0327}',
    '\u{0065}',
    '\u{0300}',
    '\u{0065}',
    '\u{0301}',
    '\u{0065}',
    '\u{0302}',
    '\u{0065}',
    '\u{0308}',
    '\u{0069}',
    '\u{0300}',
    '\u{0069}',
    '\u{0301}',
    '\u{0069}',
    '\u{0302}',
    '\u{0069}',
    '\u{0308}',
    '\u{006E}',
    '\u{0303}',
    '\u{006F}',
    '\u{0300}',
    '\u{006F}',
    '\u{0301}',
    '\u{006F}',
    '\u{0302}',
    '\u{006F}',
    '\u{0303}',
    '\u{006F}',
    '\u{0308}',
    '\u{0075}',
    '\u{0300}',
    '\u{0075}',
    '\u{0301}',
    '\u{0075}',
    '\u{0302}',
    '\u{0075}',
    '\u{0308}',
    '\u{0079}',
    '\u{0301}',
    '\u{0079}',
    '\u{0308}',
    '\u{0041}',
    '\u{0304}',
    '\u{0061}',
    '\u{0304}',
    '\u{0041}',
    '\u{0306}',
    '\u{0061}',
    '\u{0306}',
    '\u{0041}',
    '\u{0328}',
    '\u{0061}',
    '\u{0328}',
    '\u{0043}',
    '\u{0301}',
    '\u{0063}',
    '\u{0301}',
    '\u{0043}',
    '\u{0302}',
    '\u{0063}',
    '\u{0302}',
    '\u{0043}',
    '\u{0307}',
    '\u{0063}',
    '\u{0307}',
    '\u{0043}',
    '\u{030C}',
    '\u{0063}',
    '\u{030C}',
    '\u{0044}',
    '\u{030C}',
    '\u{0064}',
    '\u{030C}',
    '\u{0045}',
    '\u{0304}',
    '\u{0065}',
    '\u{0304}',
    '\u{0045}',
    '\u{0306}',
    '\u{0065}',
    '\u{0306}',
    '\u{0045}',
    '\u{0307}',
    '\u{0065}',
    '\u{0307}',
    '\u{0045}',
    '\u{0328}',
    '\u{0065}',
    '\u{0328}',
    '\u{0045}',
    '\u{030C}',
    '\u{0065}',
    '\u{030C}',
    '\u{0047}',
    '\u{0302}',
    '\u{0067}',
    '\u{0302}',
    '\u{0047}',
    '\u{0306}',
    '\u{0067}',
    '\u{0306}',
    '\u{0047}',
    '\u{0307}',
    '\u{0067}',
    '\u{0307}',
    '\u{0047}',
    '\u{0327}',
    '\u{0067}',
    '\u{0327}',
    '\u{0048}',
    '\u{0302}',
    '\u{0068}',
    '\u{0302}',
    '\u{0049}',
    '\u{0303}',
    '\u{0069}',
    '\u{0303}',
    '\u{0049}',
    '\u{0304}',
    '\u{0069}',
    '\u{0304}',
    '\u{0049}',
    '\u{0306}',
    '\u{0069}',
    '\u{0306}',
    '\u{0049}',
    '\u{0328}',
    '\u{0069}',
    '\u{0328}',
    '\u{0049}',
    '\u{0307}',
    '\u{004A}',
    '\u{0302}',
    '\u{006A}',
    '\u{0302}',
    '\u{004B}',
    '\u{0327}',
    '\u{006B}',
    '\u{0327}',
    '\u{004C}',
    '\u{0301}',
    '\u{006C}',
    '\u{0301}',
    '\u{004C}',
    '\u{0327}',
    '\u{006C}',
    '\u{0327}',
    '\u{004C}',
    '\u{030C}',
    '\u{006C}',
    '\u{030C}',
    '\u{004E}',
    '\u{0301}',
    '\u{006E}',
    '\u{0301}',
    '\u{004E}',
    '\u{0327}',
    '\u{006E}',
    '\u{0327}',
    '\u{004E}',
    '\u{030C}',
    '\u{006E}',
    '\u{030C}',
    '\u{004F}',
    '\u{0304}',
    '\u{006F}',
    '\u{0304}',
    '\u{004F}',
    '\u{0306}',
    '\u{006F}',
    '\u{0306}',
    '\u{004F}',
    '\u{030B}',
    '\u{006F}',
    '\u{030B}',
    '\u{0052}',
    '\u{0301}',
    '\u{0072}',
    '\u{0301}',
    '\u{0052}',
    '\u{0327}',
    '\u{0072}',
    '\u{0327}',
    '\u{0052}',
    '\u{030C}',
    '\u{0072}',
    '\u{030C}',
    '\u{0053}',
    '\u{0301}',
    '\u{0073}',
    '\u{0301}',
    '\u{0053}',
    '\u{0302}',
    '\u{0073}',
    '\u{0302}',
    '\u{0053}',
    '\u{0327}',
    '\u{0073}',
    '\u{0327}',
    '\u{0053}',
    '\u{030C}',
    '\u{0073}',
    '\u{030C}',
    '\u{0054}',
    '\u{0327}',
    '\u{0074}',
    '\u{0327}',
    '\u{0054}',
    '\u{030C}',
    '\u{0074}',
    '\u{030C}',
    '\u{0055}',
    '\u{0303}',
    '\u{0075}',
    '\u{0303}',
    '\u{0055}',
    '\u{0304}',
    '\u{0075}',
    '\u{0304}',
    '\u{0055}',
    '\u{0306}',
    '\u{0075}',
    '\u{0306}',
    '\u{0055}',
    '\u{030A}',
    '\u{0075}',
    '\u{030A}',
    '\u{0055}',
    '\u{030B}',
    '\u{0075}',
    '\u{030B}',
    '\u{0055}',
    '\u{0328}',
    '\u{0075}',
    '\u{0328}',
    '\u{0057}',
    '\u{0302}',
    '\u{0077}',
    '\u{0302}',
    '\u{0059}',
    '\u{0302}',
    '\u{0079}',
    '\u{0302}',
    '\u{0059}',
    '\u{0308}',
    '\u{005A}',
    '\u{0301}',
    '\u{007A}',
    '\u{0301}',
    '\u{005A}',
    '\u{0307}',
    '\u{007A}',
    '\u{0307}',
    '\u{005A}',
    '\u{030C}',
    '\u{007A}',
    '\u{030C}',
    '\u{004F}',
    '\u{031B}',
    '\u{006F}',
    '\u{031B}',
    '\u{0055}',
    '\u{031B}',
    '\u{0075}',
    '\u{031B}',
    '\u{0041}',
    '\u{030C}',
    '\u{0061}',
    '\u{030C}',
    '\u{0049}',
    '\u{030C}',
    '\u{0069}',
    '\u{030C}',
    '\u{004F}',
    '\u{030C}',
    '\u{006F}',
    '\u{030C}',
    '\u{0055}',
    '\u{030C}',
    '\u{0075}',
    '\u{030C}',
    '\u{0055}',
    '\u{0308}',
    '\u{0304}',
    '\u{0075}',
    '\u{0308}',
    '\u{0304}',
    '\u{0055}',
    '\u{0308}',
    '\u{0301}',
    '\u{0075}',
    '\u{0308}',
    '\u{0301}',
    '\u{0055}',
    '\u{0308}',
    '\u{030C}',
    '\u{0075}',
    '\u{0308}',
    '\u{030C}',
    '\u{0055}',
    '\u{0308}',
    '\u{0300}',
    '\u{0075}',
    '\u{0308}',
    '\u{0300}',
    '\u{0041}',
    '\u{0308}',
    '\u{0304}',
    '\u{0061}',
    '\u{0308}',
    '\u{0304}',
    '\u{0041}',
    '\u{0307}',
    '\u{0304}',
    '\u{0061}',
    '\u{0307}',
    '\u{0304}',
    '\u{00C6}',
    '\u{0304}',
    '\u{00E6}',
    '\u{0304}',
    '\u{0047}',
    '\u{030C}',
    '\u{0067}',
    '\u{030C}',
    '\u{004B}',
    '\u{030C}',
    '\u{006B}',
    '\u{030C}',
    '\u{004F}',
    '\u{0328}',
    '\u{006F}',
    '\u{0328}',
    '\u{004F}',
    '\u{0328}',
    '\u{0304}',
    '\u{006F}',
    '\u{0328}',
    '\u{0304}',
    '\u{01B7}',
    '\u{030C}',
    '\u{0292}',
    '\u{030C}',
    '\u{006A}',
    '\u{030C}',
    '\u{0047}',
    '\u{0301}',
    '\u{0067}',
    '\u{0301}',
    '\u{004E}',
    '\u{0300}',
    '\u{006E}',
    '\u{0300}',
    '\u{0041}',
    '\u{030A}',
    '\u{0301}',
    '\u{0061}',
    '\u{030A}',
    '\u{0301}',
    '\u{00C6}',
    '\u{0301}',
    '\u{00E6}',
    '\u{0301}',
    '\u{00D8}',
    '\u{0301}',
    '\u{00F8}',
    '\u{0301}',
    '\u{0041}',
    '\u{030F}',
    '\u{0061}',
    '\u{030F}',
    '\u{0041}',
    '\u{0311}',
    '\u{0061}',
    '\u{0311}',
    '\u{0045}',
    '\u{030F}',
    '\u{0065}',
    '\u{030F}',
    '\u{0045}',
    '\u{0311}',
    '\u{0065}',
    '\u{0311}',
    '\u{0049}',
    '\u{030F}',
    '\u{0069}',
    '\u{030F}',
    '\u{0049}',
    '\u{0311}',
    '\u{0069}',
    '\u{0311}',
    '\u{004F}',
    '\u{030F}',
    '\u{006F}',
    '\u{030F}',
    '\u{004F}',
    '\u{0311}',
    '\u{006F}',
    '\u{0311}',
    '\u{0052}',
    '\u{030F}',
    '\u{0072}',
    '\u{030F}',
    '\u{0052}',
    '\u{0311}',
    '\u{0072}',
    '\u{0311}',
    '\u{0055}',
    '\u{030F}',
    '\u{0075}',
    '\u{030F}',
    '\u{0055}',
    '\u{0311}',
    '\u{0075}',
    '\u{0311}',
    '\u{0053}',
    '\u{0326}',
    '\u{0073}',
    '\u{0326}',
    '\u{0054}',
    '\u{0326}',
    '\u{0074}',
    '\u{0326}',
    '\u{0048}',
    '\u{030C}',
    '\u{0068}',
    '\u{030C}',
    '\u{0041}',
    '\u{0307}',
    '\u{0061}',
    '\u{0307}',
    '\u{0045}',
    '\u{0327}',
    '\u{0065}',
    '\u{0327}',
    '\u{004F}',
    '\u{0308}',
    '\u{0304}',
    '\u{006F}',
    '\u{0308}',
    '\u{0304}',
    '\u{004F}',
    '\u{0303}',
    '\u{0304}',
    '\u{006F}',
    '\u{0303}',
    '\u{0304}',
    '\u{004F}',
    '\u{0307}',
    '\u{006F}',
    '\u{0307}',
    '\u{004F}',
    '\u{0307}',
    '\u{0304}',
    '\u{006F}',
    '\u{0307}',
    '\u{0304}',
    '\u{0059}',
    '\u{0304}',
    '\u{0079}',
    '\u{0304}',
    '\u{0300}',
    '\u{0301}',
    '\u{0313}',
    '\u{0308}',
    '\u{0301}',
    '\u{02B9}',
    '\u{003B}',
    '\u{00A8}',
    '\u{0301}',
    '\u{0391}',
    '\u{0301}',
    '\u{00B7}',
    '\u{0395}',
    '\u{0301}',
    '\u{0397}',
    '\u{0301}',
    '\u{0399}',
    '\u{0301}',
    '\u{039F}',
    '\u{0301}',
    '\u{03A5}',
    '\u{0301}',
    '\u{03A9}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0308}',
    '\u{0301}',
    '\u{0399}',
    '\u{0308}',
    '\u{03A5}',
    '\u{0308}',
    '\u{03B1}',
    '\u{0301}',
    '\u{03B5}',
    '\u{0301}',
    '\u{03B7}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0308}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0308}',
    '\u{03C5}',
    '\u{0308}',
    '\u{03BF}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0301}',
    '\u{03C9}',
    '\u{0301}',
    '\u{03D2}',
    '\u{0301}',
    '\u{03D2}',
    '\u{0308}',
    '\u{0415}',
    '\u{0300}',
    '\u{0415}',
    '\u{0308}',
    '\u{0413}',
    '\u{0301}',
    '\u{0406}',
    '\u{0308}',
    '\u{041A}',
    '\u{0301}',
    '\u{0418}',
    '\u{0300}',
    '\u{0423}',
    '\u{0306}',
    '\u{0418}',
    '\u{0306}',
    '\u{0438}',
    '\u{0306}',
    '\u{0435}',
    '\u{0300}',
    '\u{0435}',
    '\u{0308}',
    '\u{0433}',
    '\u{0301}',
    '\u{0456}',
    '\u{0308}',
    '\u{043A}',
    '\u{0301}',
    '\u{0438}',
    '\u{0300}',
    '\u{0443}',
    '\u{0306}',
    '\u{0474}',
    '\u{030F}',
    '\u{0475}',
    '\u{030F}',
    '\u{0416}',
    '\u{0306}',
    '\u{0436}',
    '\u{0306}',
    '\u{0410}',
    '\u{0306}',
    '\u{0430}',
    '\u{0306}',
    '\u{0410}',
    '\u{0308}',
    '\u{0430}',
    '\u{0308}',
    '\u{0415}',
    '\u{0306}',
    '\u{0435}',
    '\u{0306}',
    '\u{04D8}',
    '\u{0308}',
    '\u{04D9}',
    '\u{0308}',
    '\u{0416}',
    '\u{0308}',
    '\u{0436}',
    '\u{0308}',
    '\u{0417}',
    '\u{0308}',
    '\u{0437}',
    '\u{0308}',
    '\u{0418}',
    '\u{0304}',
    '\u{0438}',
    '\u{0304}',
    '\u{0418}',
    '\u{0308}',
    '\u{0438}',
    '\u{0308}',
    '\u{041E}',
    '\u{0308}',
    '\u{043E}',
    '\u{0308}',
    '\u{04E8}',
    '\u{0308}',
    '\u{04E9}',
    '\u{0308}',
    '\u{042D}',
    '\u{0308}',
    '\u{044D}',
    '\u{0308}',
    '\u{0423}',
    '\u{0304}',
    '\u{0443}',
    '\u{0304}',
    '\u{0423}',
    '\u{0308}',
    '\u{0443}',
    '\u{0308}',
    '\u{0423}',
    '\u{030B}',
    '\u{0443}',
    '\u{030B}',
    '\u{0427}',
    '\u{0308}',
    '\u{0447}',
    '\u{0308}',
    '\u{042B}',
    '\u{0308}',
    '\u{044B}',
    '\u{0308}',
    '\u{0627}',
    '\u{0653}',
    '\u{0627}',
    '\u{0654}',
    '\u{0648}',
    '\u{0654}',
    '\u{0627}',
    '\u{0655}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D5}',
    '\u{0654}',
    '\u{06C1}',
    '\u{0654}',
    '\u{06D2}',
    '\u{0654}',
    '\u{0928}',
    '\u{093C}',
    '\u{0930}',
    '\u{093C}',
    '\u{0933}',
    '\u{093C}',
    '\u{0915}',
    '\u{093C}',
    '\u{0916}',
    '\u{093C}',
    '\u{0917}',
    '\u{093C}',
    '\u{091C}',
    '\u{093C}',
    '\u{0921}',
    '\u{093C}',
    '\u{0922}',
    '\u{093C}',
    '\u{092B}',
    '\u{093C}',
    '\u{092F}',
    '\u{093C}',
    '\u{09C7}',
    '\u{09BE}',
    '\u{09C7}',
    '\u{09D7}',
    '\u{09A1}',
    '\u{09BC}',
    '\u{09A2}',
    '\u{09BC}',
    '\u{09AF}',
    '\u{09BC}',
    '\u{0A32}',
    '\u{0A3C}',
    '\u{0A38}',
    '\u{0A3C}',
    '\u{0A16}',
    '\u{0A3C}',
    '\u{0A17}',
    '\u{0A3C}',
    '\u{0A1C}',
    '\u{0A3C}',
    '\u{0A2B}',
    '\u{0A3C}',
    '\u{0B47}',
    '\u{0B56}',
    '\u{0B47}',
    '\u{0B3E}',
    '\u{0B47}',
    '\u{0B57}',
    '\u{0B21}',
    '\u{0B3C}',
    '\u{0B22}',
    '\u{0B3C}',
    '\u{0B92}',
    '\u{0BD7}',
    '\u{0BC6}',
    '\u{0BBE}',
    '\u{0BC7}',
    '\u{0BBE}',
    '\u{0BC6}',
    '\u{0BD7}',
    '\u{0C46}',
    '\u{0C56}',
    '\u{0CBF}',
    '\u{0CD5}',
    '\u{0CC6}',
    '\u{0CD5}',
    '\u{0CC6}',
    '\u{0CD6}',
    '\u{0CC6}',
    '\u{0CC2}',
    '\u{0CC6}',
    '\u{0CC2}',
    '\u{0CD5}',
    '\u{0D46}',
    '\u{0D3E}',
    '\u{0D47}',
    '\u{0D3E}',
    '\u{0D46}',
    '\u{0D57}',
    '\u{0DD9}',
    '\u{0DCA}',
    '\u{0DD9}',
    '\u{0DCF}',
    '\u{0DD9}',
    '\u{0DCF}',
    '\u{0DCA}',
    '\u{0DD9}',
    '\u{0DDF}',
    '\u{0F42}',
    '\u{0FB7}',
    '\u{0F4C}',
    '\u{0FB7}',
    '\u{0F51}',
    '\u{0FB7}',
    '\u{0F56}',
    '\u{0FB7}',
    '\u{0F5B}',
    '\u{0FB7}',
    '\u{0F40}',
    '\u{0FB5}',
    '\u{0F71}',
    '\u{0F72}',
    '\u{0F71}',
    '\u{0F74}',
    '\u{0FB2}',
    '\u{0F80}',
    '\u{0FB3}',
    '\u{0F80}',
    '\u{0F71}',
    '\u{0F80}',
    '\u{0F92}',
    '\u{0FB7}',
    '\u{0F9C}',
    '\u{0FB7}',
    '\u{0FA1}',
    '\u{0FB7}',
    '\u{0FA6}',
    '\u{0FB7}',
    '\u{0FAB}',
    '\u{0FB7}',
    '\u{0F90}',
    '\u{0FB5}',
    '\u{1025}',
    '\u{102E}',
    '\u{1B05}',
    '\u{1B35}',
    '\u{1B07}',
    '\u{1B35}',
    '\u{1B09}',
    '\u{1B35}',
    '\u{1B0B}',
    '\u{1B35}',
    '\u{1B0D}',
    '\u{1B35}',
    '\u{1B11}',
    '\u{1B35}',
    '\u{1B3A}',
    '\u{1B35}',
    '\u{1B3C}',
    '\u{1B35}',
    '\u{1B3E}',
    '\u{1B35}',
    '\u{1B3F}',
    '\u{1B35}',
    '\u{1B42}',
    '\u{1B35}',
    '\u{0041}',
    '\u{0325}',
    '\u{0061}',
    '\u{0325}',
    '\u{0042}',
    '\u{0307}',
    '\u{0062}',
    '\u{0307}',
    '\u{0042}',
    '\u{0323}',
    '\u{0062}',
    '\u{0323}',
    '\u{0042}',
    '\u{0331}',
    '\u{0062}',
    '\u{0331}',
    '\u{0043}',
    '\u{0327}',
    '\u{0301}',
    '\u{0063}',
    '\u{0327}',
    '\u{0301}',
    '\u{0044}',
    '\u{0307}',
    '\u{0064}',
    '\u{0307}',
    '\u{0044}',
    '\u{0323}',
    '\u{0064}',
    '\u{0323}',
    '\u{0044}',
    '\u{0331}',
    '\u{0064}',
    '\u{0331}',
    '\u{0044}',
    '\u{0327}',
    '\u{0064}',
    '\u{0327}',
    '\u{0044}',
    '\u{032D}',
    '\u{0064}',
    '\u{032D}',
    '\u{0045}',
    '\u{0304}',
    '\u{0300}',
    '\u{0065}',
    '\u{0304}',
    '\u{0300}',
    '\u{0045}',
    '\u{0304}',
    '\u{0301}',
    '\u{0065}',
    '\u{0304}',
    '\u{0301}',
    '\u{0045}',
    '\u{032D}',
    '\u{0065}',
    '\u{032D}',
    '\u{0045}',
    '\u{0330}',
    '\u{0065}',
    '\u{0330}',
    '\u{0045}',
    '\u{0327}',
    '\u{0306}',
    '\u{0065}',
    '\u{0327}',
    '\u{0306}',
    '\u{0046}',
    '\u{0307}',
    '\u{0066}',
    '\u{0307}',
    '\u{0047}',
    '\u{0304}',
    '\u{0067}',
    '\u{0304}',
    '\u{0048}',
    '\u{0307}',
    '\u{0068}',
    '\u{0307}',
    '\u{0048}',
    '\u{0323}',
    '\u{0068}',
    '\u{0323}',
    '\u{0048}',
    '\u{0308}',
    '\u{0068}',
    '\u{0308}',
    '\u{0048}',
    '\u{0327}',
    '\u{0068}',
    '\u{0327}',
    '\u{0048}',
    '\u{032E}',
    '\u{0068}',
    '\u{032E}',
    '\u{0049}',
    '\u{0330}',
    '\u{0069}',
    '\u{0330}',
    '\u{0049}',
    '\u{0308}',
    '\u{0301}',
    '\u{0069}',
    '\u{0308}',
    '\u{0301}',
    '\u{004B}',
    '\u{0301}',
    '\u{006B}',
    '\u{0301}',
    '\u{004B}',
    '\u{0323}',
    '\u{006B}',
    '\u{0323}',
    '\u{004B}',
    '\u{0331}',
    '\u{006B}',
    '\u{0331}',
    '\u{004C}',
    '\u{0323}',
    '\u{006C}',
    '\u{0323}',
    '\u{004C}',
    '\u{0323}',
    '\u{0304}',
    '\u{006C}',
    '\u{0323}',
    '\u{0304}',
    '\u{004C}',
    '\u{0331}',
    '\u{006C}',
    '\u{0331}',
    '\u{004C}',
    '\u{032D}',
    '\u{006C}',
    '\u{032D}',
    '\u{004D}',
    '\u{0301}',
    '\u{006D}',
    '\u{0301}',
    '\u{004D}',
    '\u{0307}',
    '\u{006D}',
    '\u{0307}',
    '\u{004D}',
    '\u{0323}',
    '\u{006D}',
    '\u{0323}',
    '\u{004E}',
    '\u{0307}',
    '\u{006E}',
    '\u{0307}',
    '\u{004E}',
    '\u{0323}',
    '\u{006E}',
    '\u{0323}',
    '\u{004E}',
    '\u{0331}',
    '\u{006E}',
    '\u{0331}',
    '\u{004E}',
    '\u{032D}',
    '\u{006E}',
    '\u{032D}',
    '\u{004F}',
    '\u{0303}',
    '\u{0301}',
    '\u{006F}',
    '\u{0303}',
    '\u{0301}',
    '\u{004F}',
    '\u{0303}',
    '\u{0308}',
    '\u{006F}',
    '\u{0303}',
    '\u{0308}',
    '\u{004F}',
    '\u{0304}',
    '\u{0300}',
    '\u{006F}',
    '\u{0304}',
    '\u{0300}',
    '\u{004F}',
    '\u{0304}',
    '\u{0301}',
    '\u{006F}',
    '\u{0304}',
    '\u{0301}',
    '\u{0050}',
    '\u{0301}',
    '\u{0070}',
    '\u{0301}',
    '\u{0050}',
    '\u{0307}',
    '\u{0070}',
    '\u{0307}',
    '\u{0052}',
    '\u{0307}',
    '\u{0072}',
    '\u{0307}',
    '\u{0052}',
    '\u{0323}',
    '\u{0072}',
    '\u{0323}',
    '\u{0052}',
    '\u{0323}',
    '\u{0304}',
    '\u{0072}',
    '\u{0323}',
    '\u{0304}',
    '\u{0052}',
    '\u{0331}',
    '\u{0072}',
    '\u{0331}',
    '\u{0053}',
    '\u{0307}',
    '\u{0073}',
    '\u{0307}',
    '\u{0053}',
    '\u{0323}',
    '\u{0073}',
    '\u{0323}',
    '\u{0053}',
    '\u{0301}',
    '\u{0307}',
    '\u{0073}',
    '\u{0301}',
    '\u{0307}',
    '\u{0053}',
    '\u{030C}',
    '\u{0307}',
    '\u{0073}',
    '\u{030C}',
    '\u{0307}',
    '\u{0053}',
    '\u{0323}',
    '\u{0307}',
    '\u{0073}',
    '\u{0323}',
    '\u{0307}',
    '\u{0054}',
    '\u{0307}',
    '\u{0074}',
    '\u{0307}',
    '\u{0054}',
    '\u{0323}',
    '\u{0074}',
    '\u{0323}',
    '\u{0054}',
    '\u{0331}',
    '\u{0074}',
    '\u{0331}',
    '\u{0054}',
    '\u{032D}',
    '\u{0074}',
    '\u{032D}',
    '\u{0055}',
    '\u{0324}',
    '\u{0075}',
    '\u{0324}',
    '\u{0055}',
    '\u{0330}',
    '\u{0075}',
    '\u{0330}',
    '\u{0055}',
    '\u{032D}',
    '\u{0075}',
    '\u{032D}',
    '\u{0055}',
    '\u{0303}',
    '\u{0301}',
    '\u{0075}',
    '\u{0303}',
    '\u{0301}',
    '\u{0055}',
    '\u{0304}',
    '\u{0308}',
    '\u{0075}',
    '\u{0304}',
    '\u{0308}',
    '\u{0056}',
    '\u{0303}',
    '\u{0076}',
    '\u{0303}',
    '\u{0056}',
    '\u{0323}',
    '\u{0076}',
    '\u{0323}',
    '\u{0057}',
    '\u{0300}',
    '\u{0077}',
    '\u{0300}',
    '\u{0057}',
    '\u{0301}',
    '\u{0077}',
    '\u{0301}',
    '\u{0057}',
    '\u{0308}',
    '\u{0077}',
    '\u{0308}',
    '\u{0057}',
    '\u{0307}',
    '\u{0077}',
    '\u{0307}',
    '\u{0057}',
    '\u{0323}',
    '\u{0077}',
    '\u{0323}',
    '\u{0058}',
    '\u{0307}',
    '\u{0078}',
    '\u{0307}',
    '\u{0058}',
    '\u{0308}',
    '\u{0078}',
    '\u{0308}',
    '\u{0059}',
    '\u{0307}',
    '\u{0079}',
    '\u{0307}',
    '\u{005A}',
    '\u{0302}',
    '\u{007A}',
    '\u{0302}',
    '\u{005A}',
    '\u{0323}',
    '\u{007A}',
    '\u{0323}',
    '\u{005A}',
    '\u{0331}',
    '\u{007A}',
    '\u{0331}',
    '\u{0068}',
    '\u{0331}',
    '\u{0074}',
    '\u{0308}',
    '\u{0077}',
    '\u{030A}',
    '\u{0079}',
    '\u{030A}',
    '\u{017F}',
    '\u{0307}',
    '\u{0041}',
    '\u{0323}',
    '\u{0061}',
    '\u{0323}',
    '\u{0041}',
    '\u{0309}',
    '\u{0061}',
    '\u{0309}',
    '\u{0041}',
    '\u{0302}',
    '\u{0301}',
    '\u{0061}',
    '\u{0302}',
    '\u{0301}',
    '\u{0041}',
    '\u{0302}',
    '\u{0300}',
    '\u{0061}',
    '\u{0302}',
    '\u{0300}',
    '\u{0041}',
    '\u{0302}',
    '\u{0309}',
    '\u{0061}',
    '\u{0302}',
    '\u{0309}',
    '\u{0041}',
    '\u{0302}',
    '\u{0303}',
    '\u{0061}',
    '\u{0302}',
    '\u{0303}',
    '\u{0041}',
    '\u{0323}',
    '\u{0302}',
    '\u{0061}',
    '\u{0323}',
    '\u{0302}',
    '\u{0041}',
    '\u{0306}',
    '\u{0301}',
    '\u{0061}',
    '\u{0306}',
    '\u{0301}',
    '\u{0041}',
    '\u{0306}',
    '\u{0300}',
    '\u{0061}',
    '\u{0306}',
    '\u{0300}',
    '\u{0041}',
    '\u{0306}',
    '\u{0309}',
    '\u{0061}',
    '\u{0306}',
    '\u{0309}',
    '\u{0041}',
    '\u{0306}',
    '\u{0303}',
    '\u{0061}',
    '\u{0306}',
    '\u{0303}',
    '\u{0041}',
    '\u{0323}',
    '\u{0306}',
    '\u{0061}',
    '\u{0323}',
    '\u{0306}',
    '\u{0045}',
    '\u{0323}',
    '\u{0065}',
    '\u{0323}',
    '\u{0045}',
    '\u{0309}',
    '\u{0065}',
    '\u{0309}',
    '\u{0045}',
    '\u{0303}',
    '\u{0065}',
    '\u{0303}',
    '\u{0045}',
    '\u{0302}',
    '\u{0301}',
    '\u{0065}',
    '\u{0302}',
    '\u{0301}',
    '\u{0045}',
    '\u{0302}',
    '\u{0300}',
    '\u{0065}',
    '\u{0302}',
    '\u{0300}',
    '\u{0045}',
    '\u{0302}',
    '\u{0309}',
    '\u{0065}',
    '\u{0302}',
    '\u{0309}',
    '\u{0045}',
    '\u{0302}',
    '\u{0303}',
    '\u{0065}',
    '\u{0302}',
    '\u{0303}',
    '\u{0045}',
    '\u{0323}',
    '\u{0302}',
    '\u{0065}',
    '\u{0323}',
    '\u{0302}',
    '\u{0049}',
    '\u{0309}',
    '\u{0069}',
    '\u{0309}',
    '\u{0049}',
    '\u{0323}',
    '\u{0069}',
    '\u{0323}',
    '\u{004F}',
    '\u{0323}',
    '\u{006F}',
    '\u{0323}',
    '\u{004F}',
    '\u{0309}',
    '\u{006F}',
    '\u{0309}',
    '\u{004F}',
    '\u{0302}',
    '\u{0301}',
    '\u{006F}',
    '\u{0302}',
    '\u{0301}',
    '\u{004F}',
    '\u{0302}',
    '\u{0300}',
    '\u{006F}',
    '\u{0302}',
    '\u{0300}',
    '\u{004F}',
    '\u{0302}',
    '\u{0309}',
    '\u{006F}',
    '\u{0302}',
    '\u{0309}',
    '\u{004F}',
    '\u{0302}',
    '\u{0303}',
    '\u{006F}',
    '\u{0302}',
    '\u{0303}',
    '\u{004F}',
    '\u{0323}',
    '\u{0302}',
    '\u{006F}',
    '\u{0323}',
    '\u{0302}',
    '\u{004F}',
    '\u{031B}',
    '\u{0301}',
    '\u{006F}',
    '\u{031B}',
    '\u{0301}',
    '\u{004F}',
    '\u{031B}',
    '\u{0300}',
    '\u{006F}',
    '\u{031B}',
    '\u{0300}',
    '\u{004F}',
    '\u{031B}',
    '\u{0309}',
    '\u{006F}',
    '\u{031B}',
    '\u{0309}',
    '\u{004F}',
    '\u{031B}',
    '\u{0303}',
    '\u{006F}',
    '\u{031B}',
    '\u{0303}',
    '\u{004F}',
    '\u{031B}',
    '\u{0323}',
    '\u{006F}',
    '\u{031B}',
    '\u{0323}',
    '\u{0055}',
    '\u{0323}',
    '\u{0075}',
    '\u{0323}',
    '\u{0055}',
    '\u{0309}',
    '\u{0075}',
    '\u{0309}',
    '\u{0055}',
    '\u{031B}',
    '\u{0301}',
    '\u{0075}',
    '\u{031B}',
    '\u{0301}',
    '\u{0055}',
    '\u{031B}',
    '\u{0300}',
    '\u{0075}',
    '\u{031B}',
    '\u{0300}',
    '\u{0055}',
    '\u{031B}',
    '\u{0309}',
    '\u{0075}',
    '\u{031B}',
    '\u{0309}',
    '\u{0055}',
    '\u{031B}',
    '\u{0303}',
    '\u{0075}',
    '\u{031B}',
    '\u{0303}',
    '\u{0055}',
    '\u{031B}',
    '\u{0323}',
    '\u{0075}',
    '\u{031B}',
    '\u{0323}',
    '\u{0059}',
    '\u{0300}',
    '\u{0079}',
    '\u{0300}',
    '\u{0059}',
    '\u{0323}',
    '\u{0079}',
    '\u{0323}',
    '\u{0059}',
    '\u{0309}',
    '\u{0079}',
    '\u{0309}',
    '\u{0059}',
    '\u{0303}',
    '\u{0079}',
    '\u{0303}',
    '\u{03B1}',
    '\u{0313}',
    '\u{03B1}',
    '\u{0314}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0300}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0300}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0301}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0301}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0342}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0342}',
    '\u{0391}',
    '\u{0313}',
    '\u{0391}',
    '\u{0314}',
    '\u{0391}',
    '\u{0313}',
    '\u{0300}',
    '\u{0391}',
    '\u{0314}',
    '\u{0300}',
    '\u{0391}',
    '\u{0313}',
    '\u{0301}',
    '\u{0391}',
    '\u{0314}',
    '\u{0301}',
    '\u{0391}',
    '\u{0313}',
    '\u{0342}',
    '\u{0391}',
    '\u{0314}',
    '\u{0342}',
    '\u{03B5}',
    '\u{0313}',
    '\u{03B5}',
    '\u{0314}',
    '\u{03B5}',
    '\u{0313}',
    '\u{0300}',
    '\u{03B5}',
    '\u{0314}',
    '\u{0300}',
    '\u{03B5}',
    '\u{0313}',
    '\u{0301}',
    '\u{03B5}',
    '\u{0314}',
    '\u{0301}',
    '\u{0395}',
    '\u{0313}',
    '\u{0395}',
    '\u{0314}',
    '\u{0395}',
    '\u{0313}',
    '\u{0300}',
    '\u{0395}',
    '\u{0314}',
    '\u{0300}',
    '\u{0395}',
    '\u{0313}',
    '\u{0301}',
    '\u{0395}',
    '\u{0314}',
    '\u{0301}',
    '\u{03B7}',
    '\u{0313}',
    '\u{03B7}',
    '\u{0314}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0300}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0300}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0301}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0301}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0342}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0342}',
    '\u{0397}',
    '\u{0313}',
    '\u{0397}',
    '\u{0314}',
    '\u{0397}',
    '\u{0313}',
    '\u{0300}',
    '\u{0397}',
    '\u{0314}',
    '\u{0300}',
    '\u{0397}',
    '\u{0313}',
    '\u{0301}',
    '\u{0397}',
    '\u{0314}',
    '\u{0301}',
    '\u{0397}',
    '\u{0313}',
    '\u{0342}',
    '\u{0397}',
    '\u{0314}',
    '\u{0342}',
    '\u{03B9}',
    '\u{0313}',
    '\u{03B9}',
    '\u{0314}',
    '\u{03B9}',
    '\u{0313}',
    '\u{0300}',
    '\u{03B9}',
    '\u{0314}',
    '\u{0300}',
    '\u{03B9}',
    '\u{0313}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0314}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0313}',
    '\u{0342}',
    '\u{03B9}',
    '\u{0314}',
    '\u{0342}',
    '\u{0399}',
    '\u{0313}',
    '\u{0399}',
    '\u{0314}',
    '\u{0399}',
    '\u{0313}',
    '\u{0300}',
    '\u{0399}',
    '\u{0314}',
    '\u{0300}',
    '\u{0399}',
    '\u{0313}',
    '\u{0301}',
    '\u{0399}',
    '\u{0314}',
    '\u{0301}',
    '\u{0399}',
    '\u{0313}',
    '\u{0342}',
    '\u{0399}',
    '\u{0314}',
    '\u{0342}',
    '\u{03BF}',
    '\u{0313}',
    '\u{03BF}',
    '\u{0314}',
    '\u{03BF}',
    '\u{0313}',
    '\u{0300}',
    '\u{03BF}',
    '\u{0314}',
    '\u{0300}',
    '\u{03BF}',
    '\u{0313}',
    '\u{0301}',
    '\u{03BF}',
    '\u{0314}',
    '\u{0301}',
    '\u{039F}',
    '\u{0313}',
    '\u{039F}',
    '\u{0314}',
    '\u{039F}',
    '\u{0313}',
    '\u{0300}',
    '\u{039F}',
    '\u{0314}',
    '\u{0300}',
    '\u{039F}',
    '\u{0313}',
    '\u{0301}',
    '\u{039F}',
    '\u{0314}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0313}',
    '\u{03C5}',
    '\u{0314}',
    '\u{03C5}',
    '\u{0313}',
    '\u{0300}',
    '\u{03C5}',
    '\u{0314}',
    '\u{0300}',
    '\u{03C5}',
    '\u{0313}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0314}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0313}',
    '\u{0342}',
    '\u{03C5}',
    '\u{0314}',
    '\u{0342}',
    '\u{03A5}',
    '\u{0314}',
    '\u{03A5}',
    '\u{0314}',
    '\u{0300}',
    '\u{03A5}',
    '\u{0314}',
    '\u{0301}',
    '\u{03A5}',
    '\u{0314}',
    '\u{0342}',
    '\u{03C9}',
    '\u{0313}',
    '\u{03C9}',
    '\u{0314}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0300}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0300}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0301}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0301}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0342}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0342}',
    '\u{03A9}',
    '\u{0313}',
    '\u{03A9}',
    '\u{0314}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0300}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0300}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0301}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0301}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0342}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0342}',
    '\u{03B1}',
    '\u{0300}',
    '\u{03B1}',
    '\u{0301}',
    '\u{03B5}',
    '\u{0300}',
    '\u{03B5}',
    '\u{0301}',
    '\u{03B7}',
    '\u{0300}',
    '\u{03B7}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0300}',
    '\u{03B9}',
    '\u{0301}',
    '\u{03BF}',
    '\u{0300}',
    '\u{03BF}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0300}',
    '\u{03C5}',
    '\u{0301}',
    '\u{03C9}',
    '\u{0300}',
    '\u{03C9}',
    '\u{0301}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{0391}',
    '\u{0313}',
    '\u{0345}',
    '\u{0391}',
    '\u{0314}',
    '\u{0345}',
    '\u{0391}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{0391}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{0391}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{0391}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{0391}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{0391}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{0397}',
    '\u{0313}',
    '\u{0345}',
    '\u{0397}',
    '\u{0314}',
    '\u{0345}',
    '\u{0397}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{0397}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{0397}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{0397}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{0397}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{0397}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0306}',
    '\u{03B1}',
    '\u{0304}',
    '\u{03B1}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0342}',
    '\u{03B1}',
    '\u{0342}',
    '\u{0345}',
    '\u{0391}',
    '\u{0306}',
    '\u{0391}',
    '\u{0304}',
    '\u{0391}',
    '\u{0300}',
    '\u{0391}',
    '\u{0301}',
    '\u{0391}',
    '\u{0345}',
    '\u{03B9}',
    '\u{00A8}',
    '\u{0342}',
    '\u{03B7}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0342}',
    '\u{03B7}',
    '\u{0342}',
    '\u{0345}',
    '\u{0395}',
    '\u{0300}',
    '\u{0395}',
    '\u{0301}',
    '\u{0397}',
    '\u{0300}',
    '\u{0397}',
    '\u{0301}',
    '\u{0397}',
    '\u{0345}',
    '\u{1FBF}',
    '\u{0300}',
    '\u{1FBF}',
    '\u{0301}',
    '\u{1FBF}',
    '\u{0342}',
    '\u{03B9}',
    '\u{0306}',
    '\u{03B9}',
    '\u{0304}',
    '\u{03B9}',
    '\u{0308}',
    '\u{0300}',
    '\u{03B9}',
    '\u{0308}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0342}',
    '\u{03B9}',
    '\u{0308}',
    '\u{0342}',
    '\u{0399}',
    '\u{0306}',
    '\u{0399}',
    '\u{0304}',
    '\u{0399}',
    '\u{0300}',
    '\u{0399}',
    '\u{0301}',
    '\u{1FFE}',
    '\u{0300}',
    '\u{1FFE}',
    '\u{0301}',
    '\u{1FFE}',
    '\u{0342}',
    '\u{03C5}',
    '\u{0306}',
    '\u{03C5}',
    '\u{0304}',
    '\u{03C5}',
    '\u{0308}',
    '\u{0300}',
    '\u{03C5}',
    '\u{0308}',
    '\u{0301}',
    '\u{03C1}',
    '\u{0313}',
    '\u{03C1}',
    '\u{0314}',
    '\u{03C5}',
    '\u{0342}',
    '\u{03C5}',
    '\u{0308}',
    '\u{0342}',
    '\u{03A5}',
    '\u{0306}',
    '\u{03A5}',
    '\u{0304}',
    '\u{03A5}',
    '\u{0300}',
    '\u{03A5}',
    '\u{0301}',
    '\u{03A1}',
    '\u{0314}',
    '\u{00A8}',
    '\u{0300}',
    '\u{00A8}',
    '\u{0301}',
    '\u{0060}',
    '\u{03C9}',
    '\u{0300}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0301}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0342}',
    '\u{03C9}',
    '\u{0342}',
    '\u{0345}',
    '\u{039F}',
    '\u{0300}',
    '\u{039F}',
    '\u{0301}',
    '\u{03A9}',
    '\u{0300}',
    '\u{03A9}',
    '\u{0301}',
    '\u{03A9}',
    '\u{0345}',
    '\u{00B4}',
    '\u{2002}',
    '\u{2003}',
    '\u{03A9}',
    '\u{004B}',
    '\u{0041}',
    '\u{030A}',
    '\u{2190}',
    '\u{0338}',
    '\u{2192}',
    '\u{0338}',
    '\u{2194}',
    '\u{0338}',
    '\u{21D0}',
    '\u{0338}',
    '\u{21D4}',
    '\u{0338}',
    '\u{21D2}',
    '\u{0338}',
    '\u{2203}',
    '\u{0338}',
    '\u{2208}',
    '\u{0338}',
    '\u{220B}',
    '\u{0338}',
    '\u{2223}',
    '\u{0338}',
    '\u{2225}',
    '\u{0338}',
    '\u{223C}',
    '\u{0338}',
    '\u{2243}',
    '\u{0338}',
    '\u{2245}',
    '\u{0338}',
    '\u{2248}',
    '\u{0338}',
    '\u{003D}',
    '\u{0338}',
    '\u{2261}',
    '\u{0338}',
    '\u{224D}',
    '\u{0338}',
    '\u{003C}',
    '\u{0338}',
    '\u{003E}',
    '\u{0338}',
    '\u{2264}',
    '\u{0338}',
    '\u{2265}',
    '\u{0338}',
    '\u{2272}',
    '\u{0338}',
    '\u{2273}',
    '\u{0338}',
    '\u{2276}',
    '\u{0338}',
    '\u{2277}',
    '\u{0338}',
    '\u{227A}',
    '\u{0338}',
    '\u{227B}',
    '\u{0338}',
    '\u{2282}',
    '\u{0338}',
    '\u{2283}',
    '\u{0338}',
    '\u{2286}',
    '\u{0338}',
    '\u{2287}',
    '\u{0338}',
    '\u{22A2}',
    '\u{0338}',
    '\u{22A8}',
    '\u{0338}',
    '\u{22A9}',
    '\u{0338}',
    '\u{22AB}',
    '\u{0338}',
    '\u{227C}',
    '\u{0338}',
    '\u{227D}',
    '\u{0338}',
    '\u{2291}',
    '\u{0338}',
    '\u{2292}',
    '\u{0338}',
    '\u{22B2}',
    '\u{0338}',
    '\u{22B3}',
    '\u{0338}',
    '\u{22B4}',
    '\u{0338}',
    '\u{22B5}',
    '\u{0338}',
    '\u{3008}',
    '\u{3009}',
    '\u{2ADD}',
    '\u{0338}',
    '\u{304B}',
    '\u{3099}',
    '\u{304D}',
    '\u{3099}',
    '\u{304F}',
    '\u{3099}',
    '\u{3051}',
    '\u{3099}',
    '\u{3053}',
    '\u{3099}',
    '\u{3055}',
    '\u{3099}',
    '\u{3057}',
    '\u{3099}',
    '\u{3059}',
    '\u{3099}',
    '\u{305B}',
    '\u{3099}',
    '\u{305D}',
    '\u{3099}',
    '\u{305F}',
    '\u{3099}',
    '\u{3061}',
    '\u{3099}',
    '\u{3064}',
    '\u{3099}',
    '\u{3066}',
    '\u{3099}',
    '\u{3068}',
    '\u{3099}',
    '\u{306F}',
    '\u{3099}',
    '\u{306F}',
    '\u{309A}',
    '\u{3072}',
    '\u{3099}',
    '\u{3072}',
    '\u{309A}',
    '\u{3075}',
    '\u{3099}',
    '\u{3075}',
    '\u{309A}',
    '\u{3078}',
    '\u{3099}',
    '\u{3078}',
    '\u{309A}',
    '\u{307B}',
    '\u{3099}',
    '\u{307B}',
    '\u{309A}',
    '\u{3046}',
    '\u{3099}',
    '\u{309D}',
    '\u{3099}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30AD}',
    '\u{3099}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30B1}',
    '\u{3099}',
    '\u{30B3}',
    '\u{3099}',
    '\u{30B5}',
    '\u{3099}',
    '\u{30B7}',
    '\u{3099}',
    '\u{30B9}',
    '\u{3099}',
    '\u{30BB}',
    '\u{3099}',
    '\u{30BD}',
    '\u{3099}',
    '\u{30BF}',
    '\u{3099}',
    '\u{30C1}',
    '\u{3099}',
    '\u{30C4}',
    '\u{3099}',
    '\u{30C6}',
    '\u{3099}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30CF}',
    '\u{3099}',
    '\u{30CF}',
    '\u{309A}',
    '\u{30D2}',
    '\u{3099}',
    '\u{30D2}',
    '\u{309A}',
    '\u{30D5}',
    '\u{3099}',
    '\u{30D5}',
    '\u{309A}',
    '\u{30D8}',
    '\u{3099}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30DB}',
    '\u{3099}',
    '\u{30DB}',
    '\u{309A}',
    '\u{30A6}',
    '\u{3099}',
    '\u{30EF}',
    '\u{3099}',
    '\u{30F0}',
    '\u{3099}',
    '\u{30F1}',
    '\u{3099}',
    '\u{30F2}',
    '\u{3099}',
    '\u{30FD}',
    '\u{3099}',
    '\u{8C48}',
    '\u{66F4}',
    '\u{8ECA}',
    '\u{8CC8}',
    '\u{6ED1}',
    '\u{4E32}',
    '\u{53E5}',
    '\u{9F9C}',
    '\u{9F9C}',
    '\u{5951}',
    '\u{91D1}',
    '\u{5587}',
    '\u{5948}',
    '\u{61F6}',
    '\u{7669}',
    '\u{7F85}',
    '\u{863F}',
    '\u{87BA}',
    '\u{88F8}',
    '\u{908F}',
    '\u{6A02}',
    '\u{6D1B}',
    '\u{70D9}',
    '\u{73DE}',
    '\u{843D}',
    '\u{916A}',
    '\u{99F1}',
    '\u{4E82}',
    '\u{5375}',
    '\u{6B04}',
    '\u{721B}',
    '\u{862D}',
    '\u{9E1E}',
    '\u{5D50}',
    '\u{6FEB}',
    '\u{85CD}',
    '\u{8964}',
    '\u{62C9}',
    '\u{81D8}',
    '\u{881F}',
    '\u{5ECA}',
    '\u{6717}',
    '\u{6D6A}',
    '\u{72FC}',
    '\u{90CE}',
    '\u{4F86}',
    '\u{51B7}',
    '\u{52DE}',
    '\u{64C4}',
    '\u{6AD3}',
    '\u{7210}',
    '\u{76E7}',
    '\u{8001}',
    '\u{8606}',
    '\u{865C}',
    '\u{8DEF}',
    '\u{9732}',
    '\u{9B6F}',
    '\u{9DFA}',
    '\u{788C}',
    '\u{797F}',
    '\u{7DA0}',
    '\u{83C9}',
    '\u{9304}',
    '\u{9E7F}',
    '\u{8AD6}',
    '\u{58DF}',
    '\u{5F04}',
    '\u{7C60}',
    '\u{807E}',
    '\u{7262}',
    '\u{78CA}',
    '\u{8CC2}',
    '\u{96F7}',
    '\u{58D8}',
    '\u{5C62}',
    '\u{6A13}',
    '\u{6DDA}',
    '\u{6F0F}',
    '\u{7D2F}',
    '\u{7E37}',
    '\u{964B}',
    '\u{52D2}',
    '\u{808B}',
    '\u{51DC}',
    '\u{51CC}',
    '\u{7A1C}',
    '\u{7DBE}',
    '\u{83F1}',
    '\u{9675}',
    '\u{8B80}',
    '\u{62CF}',
    '\u{6A02}',
    '\u{8AFE}',
    '\u{4E39}',
    '\u{5BE7}',
    '\u{6012}',
    '\u{7387}',
    '\u{7570}',
    '\u{5317}',
    '\u{78FB}',
    '\u{4FBF}',
    '\u{5FA9}',
    '\u{4E0D}',
    '\u{6CCC}',
    '\u{6578}',
    '\u{7D22}',
    '\u{53C3}',
    '\u{585E}',
    '\u{7701}',
    '\u{8449}',
    '\u{8AAA}',
    '\u{6BBA}',
    '\u{8FB0}',
    '\u{6C88}',
    '\u{62FE}',
    '\u{82E5}',
    '\u{63A0}',
    '\u{7565}',
    '\u{4EAE}',
    '\u{5169}',
    '\u{51C9}',
    '\u{6881}',
    '\u{7CE7}',
    '\u{826F}',
    '\u{8AD2}',
    '\u{91CF}',
    '\u{52F5}',
    '\u{5442}',
    '\u{5973}',
    '\u{5EEC}',
    '\u{65C5}',
    '\u{6FFE}',
    '\u{792A}',
    '\u{95AD}',
    '\u{9A6A}',
    '\u{9E97}',
    '\u{9ECE}',
    '\u{529B}',
    '\u{66C6}',
    '\u{6B77}',
    '\u{8F62}',
    '\u{5E74}',
    '\u{6190}',
    '\u{6200}',
    '\u{649A}',
    '\u{6F23}',
    '\u{7149}',
    '\u{7489}',
    '\u{79CA}',
    '\u{7DF4}',
    '\u{806F}',
    '\u{8F26}',
    '\u{84EE}',
    '\u{9023}',
    '\u{934A}',
    '\u{5217}',
    '\u{52A3}',
    '\u{54BD}',
    '\u{70C8}',
    '\u{88C2}',
    '\u{8AAA}',
    '\u{5EC9}',
    '\u{5FF5}',
    '\u{637B}',
    '\u{6BAE}',
    '\u{7C3E}',
    '\u{7375}',
    '\u{4EE4}',
    '\u{56F9}',
    '\u{5BE7}',
    '\u{5DBA}',
    '\u{601C}',
    '\u{73B2}',
    '\u{7469}',
    '\u{7F9A}',
    '\u{8046}',
    '\u{9234}',
    '\u{96F6}',
    '\u{9748}',
    '\u{9818}',
    '\u{4F8B}',
    '\u{79AE}',
    '\u{91B4}',
    '\u{96B8}',
    '\u{60E1}',
    '\u{4E86}',
    '\u{50DA}',
    '\u{5BEE}',
    '\u{5C3F}',
    '\u{6599}',
    '\u{6A02}',
    '\u{71CE}',
    '\u{7642}',
    '\u{84FC}',
    '\u{907C}',
    '\u{9F8D}',
    '\u{6688}',
    '\u{962E}',
    '\u{5289}',
    '\u{677B}',
    '\u{67F3}',
    '\u{6D41}',
    '\u{6E9C}',
    '\u{7409}',
    '\u{7559}',
    '\u{786B}',
    '\u{7D10}',
    '\u{985E}',
    '\u{516D}',
    '\u{622E}',
    '\u{9678}',
    '\u{502B}',
    '\u{5D19}',
    '\u{6DEA}',
    '\u{8F2A}',
    '\u{5F8B}',
    '\u{6144}',
    '\u{6817}',
    '\u{7387}',
    '\u{9686}',
    '\u{5229}',
    '\u{540F}',
    '\u{5C65}',
    '\u{6613}',
    '\u{674E}',
    '\u{68A8}',
    '\u{6CE5}',
    '\u{7406}',
    '\u{75E2}',
    '\u{7F79}',
    '\u{88CF}',
    '\u{88E1}',
    '\u{91CC}',
    '\u{96E2}',
    '\u{533F}',
    '\u{6EBA}',
    '\u{541D}',
    '\u{71D0}',
    '\u{7498}',
    '\u{85FA}',
    '\u{96A3}',
    '\u{9C57}',
    '\u{9E9F}',
    '\u{6797}',
    '\u{6DCB}',
    '\u{81E8}',
    '\u{7ACB}',
    '\u{7B20}',
    '\u{7C92}',
    '\u{72C0}',
    '\u{7099}',
    '\u{8B58}',
    '\u{4EC0}',
    '\u{8336}',
    '\u{523A}',
    '\u{5207}',
    '\u{5EA6}',
    '\u{62D3}',
    '\u{7CD6}',
    '\u{5B85}',
    '\u{6D1E}',
    '\u{66B4}',
    '\u{8F3B}',
    '\u{884C}',
    '\u{964D}',
    '\u{898B}',
    '\u{5ED3}',
    '\u{5140}',
    '\u{55C0}',
    '\u{585A}',
    '\u{6674}',
    '\u{51DE}',
    '\u{732A}',
    '\u{76CA}',
    '\u{793C}',
    '\u{795E}',
    '\u{7965}',
    '\u{798F}',
    '\u{9756}',
    '\u{7CBE}',
    '\u{7FBD}',
    '\u{8612}',
    '\u{8AF8}',
    '\u{9038}',
    '\u{90FD}',
    '\u{98EF}',
    '\u{98FC}',
    '\u{9928}',
    '\u{9DB4}',
    '\u{90DE}',
    '\u{96B7}',
    '\u{4FAE}',
    '\u{50E7}',
    '\u{514D}',
    '\u{52C9}',
    '\u{52E4}',
    '\u{5351}',
    '\u{559D}',
    '\u{5606}',
    '\u{5668}',
    '\u{5840}',
    '\u{58A8}',
    '\u{5C64}',
    '\u{5C6E}',
    '\u{6094}',
    '\u{6168}',
    '\u{618E}',
    '\u{61F2}',
    '\u{654F}',
    '\u{65E2}',
    '\u{6691}',
    '\u{6885}',
    '\u{6D77}',
    '\u{6E1A}',
    '\u{6F22}',
    '\u{716E}',
    '\u{722B}',
    '\u{7422}',
    '\u{7891}',
    '\u{793E}',
    '\u{7949}',
    '\u{7948}',
    '\u{7950}',
    '\u{7956}',
    '\u{795D}',
    '\u{798D}',
    '\u{798E}',
    '\u{7A40}',
    '\u{7A81}',
    '\u{7BC0}',
    '\u{7DF4}',
    '\u{7E09}',
    '\u{7E41}',
    '\u{7F72}',
    '\u{8005}',
    '\u{81ED}',
    '\u{8279}',
    '\u{8279}',
    '\u{8457}',
    '\u{8910}',
    '\u{8996}',
    '\u{8B01}',
    '\u{8B39}',
    '\u{8CD3}',
    '\u{8D08}',
    '\u{8FB6}',
    '\u{9038}',
    '\u{96E3}',
    '\u{97FF}',
    '\u{983B}',
    '\u{6075}',
    '\u{242EE}',
    '\u{8218}',
    '\u{4E26}',
    '\u{51B5}',
    '\u{5168}',
    '\u{4F80}',
    '\u{5145}',
    '\u{5180}',
    '\u{52C7}',
    '\u{52FA}',
    '\u{559D}',
    '\u{5555}',
    '\u{5599}',
    '\u{55E2}',
    '\u{585A}',
    '\u{58B3}',
    '\u{5944}',
    '\u{5954}',
    '\u{5A62}',
    '\u{5B28}',
    '\u{5ED2}',
    '\u{5ED9}',
    '\u{5F69}',
    '\u{5FAD}',
    '\u{60D8}',
    '\u{614E}',
    '\u{6108}',
    '\u{618E}',
    '\u{6160}',
    '\u{61F2}',
    '\u{6234}',
    '\u{63C4}',
    '\u{641C}',
    '\u{6452}',
    '\u{6556}',
    '\u{6674}',
    '\u{6717}',
    '\u{671B}',
    '\u{6756}',
    '\u{6B79}',
    '\u{6BBA}',
    '\u{6D41}',
    '\u{6EDB}',
    '\u{6ECB}',
    '\u{6F22}',
    '\u{701E}',
    '\u{716E}',
    '\u{77A7}',
    '\u{7235}',
    '\u{72AF}',
    '\u{732A}',
    '\u{7471}',
    '\u{7506}',
    '\u{753B}',
    '\u{761D}',
    '\u{761F}',
    '\u{76CA}',
    '\u{76DB}',
    '\u{76F4}',
    '\u{774A}',
    '\u{7740}',
    '\u{78CC}',
    '\u{7AB1}',
    '\u{7BC0}',
    '\u{7C7B}',
    '\u{7D5B}',
    '\u{7DF4}',
    '\u{7F3E}',
    '\u{8005}',
    '\u{8352}',
    '\u{83EF}',
    '\u{8779}',
    '\u{8941}',
    '\u{8986}',
    '\u{8996}',
    '\u{8ABF}',
    '\u{8AF8}',
    '\u{8ACB}',
    '\u{8B01}',
    '\u{8AFE}',
    '\u{8AED}',
    '\u{8B39}',
    '\u{8B8A}',
    '\u{8D08}',
    '\u{8F38}',
    '\u{9072}',
    '\u{9199}',
    '\u{9276}',
    '\u{967C}',
    '\u{96E3}',
    '\u{9756}',
    '\u{97DB}',
    '\u{97FF}',
    '\u{980B}',
    '\u{983B}',
    '\u{9B12}',
    '\u{9F9C}',
    '\u{2284A}',
    '\u{22844}',
    '\u{233D5}',
    '\u{3B9D}',
    '\u{4018}',
    '\u{4039}',
    '\u{25249}',
    '\u{25CD0}',
    '\u{27ED3}',
    '\u{9F43}',
    '\u{9F8E}',
    '\u{05D9}',
    '\u{05B4}',
    '\u{05F2}',
    '\u{05B7}',
    '\u{05E9}',
    '\u{05C1}',
    '\u{05E9}',
    '\u{05C2}',
    '\u{05E9}',
    '\u{05BC}',
    '\u{05C1}',
    '\u{05E9}',
    '\u{05BC}',
    '\u{05C2}',
    '\u{05D0}',
    '\u{05B7}',
    '\u{05D0}',
    '\u{05B8}',
    '\u{05D0}',
    '\u{05BC}',
    '\u{05D1}',
    '\u{05BC}',
    '\u{05D2}',
    '\u{05BC}',
    '\u{05D3}',
    '\u{05BC}',
    '\u{05D4}',
    '\u{05BC}',
    '\u{05D5}',
    '\u{05BC}',
    '\u{05D6}',
    '\u{05BC}',
    '\u{05D8}',
    '\u{05BC}',
    '\u{05D9}',
    '\u{05BC}',
    '\u{05DA}',
    '\u{05BC}',
    '\u{05DB}',
    '\u{05BC}',
    '\u{05DC}',
    '\u{05BC}',
    '\u{05DE}',
    '\u{05BC}',
    '\u{05E0}',
    '\u{05BC}',
    '\u{05E1}',
    '\u{05BC}',
    '\u{05E3}',
    '\u{05BC}',
    '\u{05E4}',
    '\u{05BC}',
    '\u{05E6}',
    '\u{05BC}',
    '\u{05E7}',
    '\u{05BC}',
    '\u{05E8}',
    '\u{05BC}',
    '\u{05E9}',
    '\u{05BC}',
    '\u{05EA}',
    '\u{05BC}',
    '\u{05D5}',
    '\u{05B9}',
    '\u{05D1}',
    '\u{05BF}',
    '\u{05DB}',
    '\u{05BF}',
    '\u{05E4}',
    '\u{05BF}',
    '\u{11099}',
    '\u{110BA}',
    '\u{1109B}',
    '\u{110BA}',
    '\u{110A5}',
    '\u{110BA}',
    '\u{11131}',
    '\u{11127}',
    '\u{11132}',
    '\u{11127}',
    '\u{11347}',
    '\u{1133E}',
    '\u{11347}',
    '\u{11357}',
    '\u{114B9}',
    '\u{114BA}',
    '\u{114B9}',
    '\u{114B0}',
    '\u{114B9}',
    '\u{114BD}',
    '\u{115B8}',
    '\u{115AF}',
    '\u{115B9}',
    '\u{115AF}',
    '\u{11935}',
    '\u{11930}',
    '\u{1D157}',
    '\u{1D165}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D16E}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D16F}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D170}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D171}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D172}',
    '\u{1D1B9}',
    '\u{1D165}',
    '\u{1D1BA}',
    '\u{1D165}',
    '\u{1D1B9}',
    '\u{1D165}',
    '\u{1D16E}',
    '\u{1D1BA}',
    '\u{1D165}',
    '\u{1D16E}',
    '\u{1D1B9}',
    '\u{1D165}',
    '\u{1D16F}',
    '\u{1D1BA}',
    '\u{1D165}',
    '\u{1D16F}',
    '\u{4E3D}',
    '\u{4E38}',
    '\u{4E41}',
    '\u{20122}',
    '\u{4F60}',
    '\u{4FAE}',
    '\u{4FBB}',
    '\u{5002}',
    '\u{507A}',
    '\u{5099}',
    '\u{50E7}',
    '\u{50CF}',
    '\u{349E}',
    '\u{2063A}',
    '\u{514D}',
    '\u{5154}',
    '\u{5164}',
    '\u{5177}',
    '\u{2051C}',
    '\u{34B9}',
    '\u{5167}',
    '\u{518D}',
    '\u{2054B}',
    '\u{5197}',
    '\u{51A4}',
    '\u{4ECC}',
    '\u{51AC}',
    '\u{51B5}',
    '\u{291DF}',
    '\u{51F5}',
    '\u{5203}',
    '\u{34DF}',
    '\u{523B}',
    '\u{5246}',
    '\u{5272}',
    '\u{5277}',
    '\u{3515}',
    '\u{52C7}',
    '\u{52C9}',
    '\u{52E4}',
    '\u{52FA}',
    '\u{5305}',
    '\u{5306}',
    '\u{5317}',
    '\u{5349}',
    '\u{5351}',
    '\u{535A}',
    '\u{5373}',
    '\u{537D}',
    '\u{537F}',
    '\u{537F}',
    '\u{537F}',
    '\u{20A2C}',
    '\u{7070}',
    '\u{53CA}',
    '\u{53DF}',
    '\u{20B63}',
    '\u{53EB}',
    '\u{53F1}',
    '\u{5406}',
    '\u{549E}',
    '\u{5438}',
    '\u{5448}',
    '\u{5468}',
    '\u{54A2}',
    '\u{54F6}',
    '\u{5510}',
    '\u{5553}',
    '\u{5563}',
    '\u{5584}',
    '\u{5584}',
    '\u{5599}',
    '\u{55AB}',
    '\u{55B3}',
    '\u{55C2}',
    '\u{5716}',
    '\u{5606}',
    '\u{5717}',
    '\u{5651}',
    '\u{5674}',
    '\u{5207}',
    '\u{58EE}',
    '\u{57CE}',
    '\u{57F4}',
    '\u{580D}',
    '\u{578B}',
    '\u{5832}',
    '\u{5831}',
    '\u{58AC}',
    '\u{214E4}',
    '\u{58F2}',
    '\u{58F7}',
    '\u{5906}',
    '\u{591A}',
    '\u{5922}',
    '\u{5962}',
    '\u{216A8}',
    '\u{216EA}',
    '\u{59EC}',
    '\u{5A1B}',
    '\u{5A27}',
    '\u{59D8}',
    '\u{5A66}',
    '\u{36EE}',
    '\u{36FC}',
    '\u{5B08}',
    '\u{5B3E}',
    '\u{5B3E}',
    '\u{219C8}',
    '\u{5BC3}',
    '\u{5BD8}',
    '\u{5BE7}',
    '\u{5BF3}',
    '\u{21B18}',
    '\u{5BFF}',
    '\u{5C06}',
    '\u{5F53}',
    '\u{5C22}',
    '\u{3781}',
    '\u{5C60}',
    '\u{5C6E}',
    '\u{5CC0}',
    '\u{5C8D}',
    '\u{21DE4}',
    '\u{5D43}',
    '\u{21DE6}',
    '\u{5D6E}',
    '\u{5D6B}',
    '\u{5D7C}',
    '\u{5DE1}',
    '\u{5DE2}',
    '\u{382F}',
    '\u{5DFD}',
    '\u{5E28}',
    '\u{5E3D}',
    '\u{5E69}',
    '\u{3862}',
    '\u{22183}',
    '\u{387C}',
    '\u{5EB0}',
    '\u{5EB3}',
    '\u{5EB6}',
    '\u{5ECA}',
    '\u{2A392}',
    '\u{5EFE}',
    '\u{22331}',
    '\u{22331}',
    '\u{8201}',
    '\u{5F22}',
    '\u{5F22}',
    '\u{38C7}',
    '\u{232B8}',
    '\u{261DA}',
    '\u{5F62}',
    '\u{5F6B}',
    '\u{38E3}',
    '\u{5F9A}',
    '\u{5FCD}',
    '\u{5FD7}',
    '\u{5FF9}',
    '\u{6081}',
    '\u{393A}',
    '\u{391C}',
    '\u{6094}',
    '\u{226D4}',
    '\u{60C7}',
    '\u{6148}',
    '\u{614C}',
    '\u{614E}',
    '\u{614C}',
    '\u{617A}',
    '\u{618E}',
    '\u{61B2}',
    '\u{61A4}',
    '\u{61AF}',
    '\u{61DE}',
    '\u{61F2}',
    '\u{61F6}',
    '\u{6210}',
    '\u{621B}',
    '\u{625D}',
    '\u{62B1}',
    '\u{62D4}',
    '\u{6350}',
    '\u{22B0C}',
    '\u{633D}',
    '\u{62FC}',
    '\u{6368}',
    '\u{6383}',
    '\u{63E4}',
    '\u{22BF1}',
    '\u{6422}',
    '\u{63C5}',
    '\u{63A9}',
    '\u{3A2E}',
    '\u{6469}',
    '\u{647E}',
    '\u{649D}',
    '\u{6477}',
    '\u{3A6C}',
    '\u{654F}',
    '\u{656C}',
    '\u{2300A}',
    '\u{65E3}',
    '\u{66F8}',
    '\u{6649}',
    '\u{3B19}',
    '\u{6691}',
    '\u{3B08}',
    '\u{3AE4}',
    '\u{5192}',
    '\u{5195}',
    '\u{6700}',
    '\u{669C}',
    '\u{80AD}',
    '\u{43D9}',
    '\u{6717}',
    '\u{671B}',
    '\u{6721}',
    '\u{675E}',
    '\u{6753}',
    '\u{233C3}',
    '\u{3B49}',
    '\u{67FA}',
    '\u{6785}',
    '\u{6852}',
    '\u{6885}',
    '\u{2346D}',
    '\u{688E}',
    '\u{681F}',
    '\u{6914}',
    '\u{3B9D}',
    '\u{6942}',
    '\u{69A3}',
    '\u{69EA}',
    '\u{6AA8}',
    '\u{236A3}',
    '\u{6ADB}',
    '\u{3C18}',
    '\u{6B21}',
    '\u{238A7}',
    '\u{6B54}',
    '\u{3C4E}',
    '\u{6B72}',
    '\u{6B9F}',
    '\u{6BBA}',
    '\u{6BBB}',
    '\u{23A8D}',
    '\u{21D0B}',
    '\u{23AFA}',
    '\u{6C4E}',
    '\u{23CBC}',
    '\u{6CBF}',
    '\u{6CCD}',
    '\u{6C67}',
    '\u{6D16}',
    '\u{6D3E}',
    '\u{6D77}',
    '\u{6D41}',
    '\u{6D69}',
    '\u{6D78}',
    '\u{6D85}',
    '\u{23D1E}',
    '\u{6D34}',
    '\u{6E2F}',
    '\u{6E6E}',
    '\u{3D33}',
    '\u{6ECB}',
    '\u{6EC7}',
    '\u{23ED1}',
    '\u{6DF9}',
    '\u{6F6E}',
    '\u{23F5E}',
    '\u{23F8E}',
    '\u{6FC6}',
    '\u{7039}',
    '\u{701E}',
    '\u{701B}',
    '\u{3D96}',
    '\u{704A}',
    '\u{707D}',
    '\u{7077}',
    '\u{70AD}',
    '\u{20525}',
    '\u{7145}',
    '\u{24263}',
    '\u{719C}',
    '\u{243AB}',
    '\u{7228}',
    '\u{7235}',
    '\u{7250}',
    '\u{24608}',
    '\u{7280}',
    '\u{7295}',
    '\u{24735}',
    '\u{24814}',
    '\u{737A}',
    '\u{738B}',
    '\u{3EAC}',
    '\u{73A5}',
    '\u{3EB8}',
    '\u{3EB8}',
    '\u{7447}',
    '\u{745C}',
    '\u{7471}',
    '\u{7485}',
    '\u{74CA}',
    '\u{3F1B}',
    '\u{7524}',
    '\u{24C36}',
    '\u{753E}',
    '\u{24C92}',
    '\u{7570}',
    '\u{2219F}',
    '\u{7610}',
    '\u{24FA1}',
    '\u{24FB8}',
    '\u{25044}',
    '\u{3FFC}',
    '\u{4008}',
    '\u{76F4}',
    '\u{250F3}',
    '\u{250F2}',
    '\u{25119}',
    '\u{25133}',
    '\u{771E}',
    '\u{771F}',
    '\u{771F}',
    '\u{774A}',
    '\u{4039}',
    '\u{778B}',
    '\u{4046}',
    '\u{4096}',
    '\u{2541D}',
    '\u{784E}',
    '\u{788C}',
    '\u{78CC}',
    '\u{40E3}',
    '\u{25626}',
    '\u{7956}',
    '\u{2569A}',
    '\u{256C5}',
    '\u{798F}',
    '\u{79EB}',
    '\u{412F}',
    '\u{7A40}',
    '\u{7A4A}',
    '\u{7A4F}',
    '\u{2597C}',
    '\u{25AA7}',
    '\u{25AA7}',
    '\u{7AEE}',
    '\u{4202}',
    '\u{25BAB}',
    '\u{7BC6}',
    '\u{7BC9}',
    '\u{4227}',
    '\u{25C80}',
    '\u{7CD2}',
    '\u{42A0}',
    '\u{7CE8}',
    '\u{7CE3}',
    '\u{7D00}',
    '\u{25F86}',
    '\u{7D63}',
    '\u{4301}',
    '\u{7DC7}',
    '\u{7E02}',
    '\u{7E45}',
    '\u{4334}',
    '\u{26228}',
    '\u{26247}',
    '\u{4359}',
    '\u{262D9}',
    '\u{7F7A}',
    '\u{2633E}',
    '\u{7F95}',
    '\u{7FFA}',
    '\u{8005}',
    '\u{264DA}',
    '\u{26523}',
    '\u{8060}',
    '\u{265A8}',
    '\u{8070}',
    '\u{2335F}',
    '\u{43D5}',
    '\u{80B2}',
    '\u{8103}',
    '\u{440B}',
    '\u{813E}',
    '\u{5AB5}',
    '\u{267A7}',
    '\u{267B5}',
    '\u{23393}',
    '\u{2339C}',
    '\u{8201}',
    '\u{8204}',
    '\u{8F9E}',
    '\u{446B}',
    '\u{8291}',
    '\u{828B}',
    '\u{829D}',
    '\u{52B3}',
    '\u{82B1}',
    '\u{82B3}',
    '\u{82BD}',
    '\u{82E6}',
    '\u{26B3C}',
    '\u{82E5}',
    '\u{831D}',
    '\u{8363}',
    '\u{83AD}',
    '\u{8323}',
    '\u{83BD}',
    '\u{83E7}',
    '\u{8457}',
    '\u{8353}',
    '\u{83CA}',
    '\u{83CC}',
    '\u{83DC}',
    '\u{26C36}',
    '\u{26D6B}',
    '\u{26CD5}',
    '\u{452B}',
    '\u{84F1}',
    '\u{84F3}',
    '\u{8516}',
    '\u{273CA}',
    '\u{8564}',
    '\u{26F2C}',
    '\u{455D}',
    '\u{4561}',
    '\u{26FB1}',
    '\u{270D2}',
    '\u{456B}',
    '\u{8650}',
    '\u{865C}',
    '\u{8667}',
    '\u{8669}',
    '\u{86A9}',
    '\u{8688}',
    '\u{870E}',
    '\u{86E2}',
    '\u{8779}',
    '\u{8728}',
    '\u{876B}',
    '\u{8786}',
    '\u{45D7}',
    '\u{87E1}',
    '\u{8801}',
    '\u{45F9}',
    '\u{8860}',
    '\u{8863}',
    '\u{27667}',
    '\u{88D7}',
    '\u{88DE}',
    '\u{4635}',
    '\u{88FA}',
    '\u{34BB}',
    '\u{278AE}',
    '\u{27966}',
    '\u{46BE}',
    '\u{46C7}',
    '\u{8AA0}',
    '\u{8AED}',
    '\u{8B8A}',
    '\u{8C55}',
    '\u{27CA8}',
    '\u{8CAB}',
    '\u{8CC1}',
    '\u{8D1B}',
    '\u{8D77}',
    '\u{27F2F}',
    '\u{20804}',
    '\u{8DCB}',
    '\u{8DBC}',
    '\u{8DF0}',
    '\u{208DE}',
    '\u{8ED4}',
    '\u{8F38}',
    '\u{285D2}',
    '\u{285ED}',
    '\u{9094}',
    '\u{90F1}',
    '\u{9111}',
    '\u{2872E}',
    '\u{911B}',
    '\u{9238}',
    '\u{92D7}',
    '\u{92D8}',
    '\u{927C}',
    '\u{93F9}',
    '\u{9415}',
    '\u{28BFA}',
    '\u{958B}',
    '\u{4995}',
    '\u{95B7}',
    '\u{28D77}',
    '\u{49E6}',
    '\u{96C3}',
    '\u{5DB2}',
    '\u{9723}',
    '\u{29145}',
    '\u{2921A}',
    '\u{4A6E}',
    '\u{4A76}',
    '\u{97E0}',
    '\u{2940A}',
    '\u{4AB2}',
    '\u{29496}',
    '\u{980B}',
    '\u{980B}',
    '\u{9829}',
    '\u{295B6}',
    '\u{98E2}',
    '\u{4B33}',
    '\u{9929}',
    '\u{99A7}',
    '\u{99C2}',
    '\u{99FE}',
    '\u{4BCE}',
    '\u{29B30}',
    '\u{9B12}',
    '\u{9C40}',
    '\u{9CFD}',
    '\u{4CCE}',
    '\u{4CED}',
    '\u{9D67}',
    '\u{2A0CE}',
    '\u{4CF8}',
    '\u{2A105}',
    '\u{2A20E}',
    '\u{2A291}',
    '\u{9EBB}',
    '\u{4D56}',
    '\u{9EF9}',
    '\u{9EFE}',
    '\u{9F05}',
    '\u{9F0F}',
    '\u{9F16}',
    '\u{9F3B}',
    '\u{2A600}',
];
pub(crate) const CANONICAL_DECOMPOSED_SALT: &[u16] = &[
    0xcae,
    0xe,
    0x0,
    0x0,
    0x45a,
    0x23f,
    0x0,
    0x1e8,
    0x28,
    0x280,
    0x0,
    0x6,
    0x14c,
    0x201,
    0x6,
    0x20,
    0x3,
    0x0,
    0x71,
    0x18b,
    0xd,
    0x14d,
    0xd3,
    0x0,
    0x2,
    0x85,
    0x45,
    0xa,
    0x4,
    0xe9,
    0x21,
    0x0,
    0x0,
    0xaa,
    0x2,
    0x105,
    0x0,
    0x1b5,
    0xd,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x6,
    0x67,
    0x8,
    0x0,
    0x2,
    0x0,
    0x0,
    0x47,
    0x32,
    0x0,
    0x0,
    0x3c,
    0x45,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x10,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0xce,
    0x2c,
    0x0,
    0x1d,
    0x0,
    0x12,
    0x0,
    0x0,
    0x11,
    0x3,
    0x1c,
    0x7,
    0x0,
    0x1,
    0x6a,
    0x1,
    0x16,
    0x0,
    0x6f,
    0x0,
    0x1,
    0x25,
    0x0,
    0x27,
    0x10,
    0x0,
    0x22,
    0x0,
    0xbc,
    0x0,
    0x9,
    0x0,
    0x0,
    0x15,
    0x0,
    0x0,
    0x13,
    0x0,
    0x87,
    0x0,
    0x3a,
    0x27,
    0x0,
    0x5,
    0x16,
    0x5,
    0x14,
    0x12,
    0x21,
    0x5,
    0x2,
    0x1,
    0x0,
    0x15,
    0x26,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x17,
    0x19,
    0x0,
    0x4,
    0x0,
    0x3,
    0x0,
    0x10,
    0x1,
    0x1,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x22,
    0x0,
    0x2,
    0x4,
    0x13,
    0x0,
    0x11,
    0x5a,
    0x5,
    0x13,
    0xd,
    0x4e,
    0x8,
    0x4,
    0x18,
    0x9,
    0x64,
    0x26,
    0x0,
    0x11,
    0x0,
    0x5,
    0x30,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x3e,
    0x46,
    0x5,
    0x0,
    0x1,
    0x0,
    0x1,
    0x37,
    0x0,
    0x0,
    0x5,
    0x3,
    0x0,
    0x13,
    0x2,
    0x0,
    0x1,
    0x0,
    0x6,
    0x0,
    0xb,
    0x1c,
    0x1,
    0x0,
    0x5,
    0x2f,
    0x1,
    0x0,
    0x8,
    0x1d,
    0x30,
    0x0,
    0x25,
    0x2,
    0x12,
    0x0,
    0x0,
    0x23,
    0x2,
    0x0,
    0x0,
    0xb,
    0x18,
    0xe,
    0x0,
    0x11,
    0xc,
    0x15,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x8,
    0x8,
    0x8,
    0x0,
    0x0,
    0x9,
    0xe,
    0x0,
    0x1,
    0x9,
    0x2c,
    0x3,
    0x1,
    0x16,
    0x11,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x18,
    0x1,
    0x30,
    0x4,
    0xc,
    0xe,
    0x9,
    0x0,
    0x3,
    0xb,
    0x0,
    0x2,
    0x5,
    0x0,
    0x10,
    0x3,
    0x2,
    0x6,
    0xb,
    0x8,
    0xa,
    0x0,
    0x8,
    0x3,
    0x1,
    0x25,
    0x3,
    0x1b,
    0x2,
    0x12,
    0x5,
    0x7,
    0x12,
    0x0,
    0x10,
    0x0,
    0x11,
    0x0,
    0x9,
    0x0,
    0x9,
    0x0,
    0xc,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x8,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x17,
    0x0,
    0x0,
    0x3,
    0xc,
    0x0,
    0x0,
    0x2,
    0x1,
    0x43,
    0x0,
    0x0,
    0xb,
    0x5,
    0x9,
    0x0,
    0x0,
    0x22,
    0x2,
    0x4,
    0x2,
    0x2,
    0x1,
    0x1,
    0x14,
    0x1,
    0x31,
    0x0,
    0x4,
    0x20,
    0x9,
    0x7,
    0x1,
    0x21,
    0x16,
    0x1,
    0x2,
    0x0,
    0x6,
    0x0,
    0xe,
    0x0,
    0x5,
    0x12,
    0xe,
    0x4,
    0x0,
    0x0,
    0x1d,
    0x0,
    0x0,
    0x6,
    0x0,
    0xa,
    0x0,
    0x0,
    0x0,
    0x16,
    0x0,
    0x0,
    0x0,
    0x0,
    0x8,
    0x0,
    0x1,
    0x0,
    0xb,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x16,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1d,
    0x7,
    0x0,
    0x1,
    0x6,
    0x4,
    0x1,
    0x3,
    0xe,
    0x9,
    0x10,
    0x8,
    0x2,
    0x1,
    0x0,
    0x0,
    0x3,
    0x2,
    0x2,
    0x22,
    0x0,
    0x0,
    0x4,
    0x13,
    0x11,
    0x0,
    0x2,
    0xd,
    0x0,
    0x1,
    0x4,
    0xc,
    0x1,
    0x16,
    0xe,
    0x2,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x15,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0xc,
    0x0,
    0x5,
    0x4,
    0x0,
    0x0,
    0x11,
    0xd,
    0x11,
    0x0,
    0x4,
    0x0,
    0x3,
    0x2,
    0x1,
    0x3,
    0x1,
    0x2,
    0x2,
    0x2,
    0x1,
    0x1,
    0x3,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0x2,
    0x1,
    0xd,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x6,
    0xd,
    0x1,
    0x1,
    0x4,
    0xc,
    0x2,
    0x6,
    0x0,
    0x4,
    0x27,
    0x1c,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xa,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xf,
    0x7,
    0x8,
    0x0,
    0x3,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x0,
    0xf,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0x16,
    0xb,
    0x5,
    0x0,
    0x0,
    0x2,
    0x8,
    0x4,
    0x0,
    0x8,
    0x0,
    0x0,
    0x0,
    0x3,
    0x4,
    0x0,
    0x1,
    0xb,
    0x1,
    0x0,
    0x0,
    0x18,
    0x9,
    0x4,
    0x7,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1e,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x3,
    0xa,
    0x2,
    0x3,
    0x1,
    0x0,
    0x4,
    0x0,
    0x4,
    0x1f,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x24,
    0x7,
    0x5,
    0x2,
    0x2,
    0xa,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0xc,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0xb,
    0x0,
    0x0,
    0x1,
    0x3,
    0x6,
    0x2,
    0xc,
    0xe,
    0x1e,
    0x0,
    0x0,
    0x10,
    0x0,
    0x1,
    0x2,
    0xd,
    0x3,
    0x0,
    0x6,
    0x0,
    0x2,
    0xa,
    0x4,
    0x0,
    0xf,
    0x10,
    0x2,
    0x1,
    0x2,
    0x6,
    0x0,
    0x0,
    0xb,
    0x0,
    0x5,
    0xd,
    0x2,
    0x0,
    0x3,
    0x7,
    0x0,
    0x5,
    0x4,
    0x0,
    0x0,
    0x6,
    0x1,
    0x0,
    0x0,
    0xf,
    0x3,
    0x0,
    0x0,
    0xc,
    0x0,
    0x17,
    0x2,
    0x9,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x7,
    0x1,
    0x3,
    0xd,
    0x0,
    0x5,
    0x7,
    0x4,
    0x8,
    0x0,
    0xb,
    0x8,
    0x9,
    0x1,
    0x0,
    0x0,
    0x9,
    0x5,
    0x0,
    0x8,
    0x1,
    0x0,
    0x6,
    0x0,
    0x8,
    0x0,
    0x7,
    0x0,
    0x2,
    0x2,
    0x5,
    0x4,
    0x5,
    0x0,
    0x0,
    0x1,
    0x13,
    0x8,
    0x0,
    0x0,
    0x1,
    0x0,
    0xa,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0xc,
    0x2,
    0x4,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x4,
    0x0,
    0x3,
    0x2,
    0x7,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x2,
    0x7,
    0x0,
    0x4,
    0x0,
    0x1,
    0x1,
    0x1,
    0x9,
    0x2,
    0x2,
    0x6,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x6,
    0x5,
    0x2,
    0x0,
    0x0,
    0x4,
    0x1,
    0x2,
    0x11,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x5,
    0x0,
    0x1,
    0x0,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0xe,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x10,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x2,
    0x6,
    0x0,
    0x9,
    0x0,
    0x6,
    0x0,
    0x1,
    0x6,
    0x5,
    0x1,
    0x1,
    0x2,
    0x8,
    0x2,
    0x3,
    0x1,
    0x4,
    0x1,
    0x0,
    0x0,
    0xd,
    0x2,
    0x0,
    0x0,
    0x1,
    0x2f,
    0x1,
    0x2,
    0x1,
    0x6,
    0x15,
    0x0,
    0x0,
    0x0,
    0xc,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1a,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x7,
    0x0,
    0x9,
    0x2,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x0,
    0xa,
    0x0,
    0x0,
    0x1,
    0x0,
    0xe,
    0x2,
    0x2,
    0x9,
    0x2,
    0xb,
    0x2,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0xa,
    0x3,
    0x1,
    0x1,
    0x2,
    0x2,
    0x2,
    0x0,
    0x2,
    0x9,
    0x0,
    0x0,
    0x1,
    0x6,
    0x1,
    0x0,
    0x7,
    0x18,
    0x1,
    0x0,
    0x7,
    0x1,
    0x1,
    0x0,
    0x19,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0xb,
    0x1,
    0x5,
    0x0,
    0x0,
    0x0,
    0x3,
    0x2,
    0x6,
    0x2,
    0x1,
    0x5,
    0x1,
    0x6,
    0x3,
    0x1,
    0x2,
    0x1,
    0x1,
    0x1c,
    0x6,
    0x2,
    0x2,
    0x3,
    0x1,
    0x8,
    0x0,
    0x2,
    0x0,
    0x1,
    0x3,
    0x1,
    0x16,
    0x6,
    0xb,
    0x0,
    0x4,
    0x4,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x16,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x9,
    0xf,
    0x5,
    0x0,
    0x1,
    0x1,
    0x8,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x8,
    0x1,
    0x2,
    0x1,
    0x3,
    0x2,
    0x0,
    0x2,
    0x4,
    0x1,
    0x1,
    0x4,
    0x0,
    0xf,
    0x0,
    0x0,
    0x0,
    0x2,
    0x9,
    0x1,
    0x0,
    0x2,
    0x0,
    0x2,
    0x4,
    0x1,
    0x0,
    0x7,
    0x5,
    0x3,
    0x2,
    0xa,
    0x2,
    0x3,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x6,
    0x2,
    0xa,
    0x0,
    0x1,
    0x6,
    0x5,
    0x0,
    0x2,
    0x3,
    0x1,
    0x8,
    0x2,
    0x0,
    0x1,
    0x0,
    0x14,
    0x0,
    0x1,
    0x2,
    0x5,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x2,
    0x9,
    0x0,
    0x3,
    0x1,
    0x0,
    0xd,
    0x1,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0xe,
    0x0,
    0x2,
    0x17,
    0x5,
    0x0,
    0x0,
    0x1,
    0x2,
    0x8,
    0x0,
    0x1,
    0x9,
    0x3,
    0x0,
    0x1,
    0x7,
    0x0,
    0x4,
    0x1,
    0x8,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x5,
    0x0,
    0x5,
    0x4,
    0x1,
    0x0,
    0x3,
    0x0,
    0x2,
    0x2,
    0x3,
    0x1,
    0xf,
    0x1,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0x2,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x8,
    0x6,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0xa,
    0x4,
    0x5,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x9,
    0x1,
    0x1,
    0x0,
    0x6,
    0x0,
    0x0,
    0x10,
    0x1,
    0x2,
    0x5,
    0x1,
    0x1,
    0x0,
    0x0,
    0x4,
    0x0,
    0x2,
    0x2,
    0x2,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x3,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x6,
    0x4,
    0x1,
    0x1,
    0x2,
    0x8,
    0x3,
    0x3,
    0x0,
    0x0,
    0x4,
    0x2,
    0x1,
    0xe,
    0x20,
    0x0,
    0x1,
    0x1,
    0xc,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x4,
    0xa,
    0x2,
    0x1,
    0x4,
    0x6,
    0x0,
    0x0,
    0x0,
    0x6,
    0x6,
    0x0,
    0x3,
    0x0,
    0x4,
    0x1,
    0x7,
    0x1,
    0x6,
    0x8,
    0x1,
    0x7,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x3,
    0x0,
    0x6,
    0x0,
    0x0,
    0x1,
    0x8,
    0x0,
    0x3,
    0x1,
    0x1,
    0x6,
    0x2,
    0x0,
    0x2,
    0x4,
    0x6,
    0x1,
    0x4,
    0x3,
    0x6,
    0x1,
    0x3,
    0x2,
    0x4,
    0x2,
    0x0,
    0x6,
    0x2,
    0x0,
    0x5,
    0x1,
    0x1,
    0x2,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x2,
    0x2,
    0x7,
    0x3,
    0x3,
    0x0,
    0x1,
    0x7,
    0x1,
    0xe,
    0x0,
    0x1,
    0x0,
    0xb,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x3,
    0x6,
    0x3,
    0x2,
    0x6,
    0x0,
    0x1,
    0x3,
    0x1,
    0x2,
    0x1,
    0x2,
    0x3,
    0x0,
    0x3,
    0x1,
    0x2,
    0x4,
    0x3,
    0x0,
    0x0,
    0x10,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x3,
    0x1,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x5,
    0x5,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x4,
    0x2,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x7,
    0xb,
    0x3,
    0x1,
    0x2,
    0x1,
    0x2,
    0x1,
    0x7,
    0x1,
    0x4,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x3,
    0x1,
    0x2,
    0x2,
    0x5,
    0x1,
    0x1,
    0x9,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0x3,
    0x1,
    0x0,
    0x0,
    0x8,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x5,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x1,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x4,
    0x9,
    0x6,
    0x0,
    0x9,
    0x6,
    0x2,
    0x1,
    0x3,
    0x1,
    0x1,
    0x2,
    0x4,
    0x2,
    0x3,
    0x2,
    0x0,
    0x6,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x5,
    0xa,
    0x1,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xd,
    0x0,
    0x0,
    0x3,
    0x3,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x4,
    0x2,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x3,
    0x5,
    0x5,
    0x0,
    0x0,
    0x5,
    0x1,
    0x1,
    0x10,
    0x1,
    0x3,
    0x2,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x6,
    0x5,
    0x1,
    0x2,
    0x1,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x7,
    0x1,
    0x2,
    0x3,
    0x0,
    0x6,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x3,
    0x1,
    0x1,
    0x3,
    0x0,
    0x2,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0x2,
    0x0,
    0x2,
    0x1,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x5,
    0x2,
    0x2,
    0x2,
    0x0,
    0x2,
    0x7,
    0x5,
    0x3,
    0x1,
    0x0,
    0xa,
    0x1,
    0x1,
    0x4,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0x3,
    0x1,
    0x1,
    0x1,
    0x3,
    0x3,
    0x1,
    0x4,
    0x1,
    0x0,
    0x1,
    0x1,
    0x1,
    0x3,
    0x1,
    0x5,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x4,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x4,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x2,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0xa,
    0x1,
    0x2,
    0x2,
    0x1,
    0x3,
    0x0,
    0x6,
    0x1,
    0x3,
    0x6,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x5,
    0x4,
    0x1,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x2,
    0x4,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x1,
    0x4,
    0xa,
    0x0,
    0x3,
    0x4,
    0x5,
    0x5,
    0x7,
    0x3,
    0x3,
    0x2,
    0x0,
    0x1,
    0x2,
    0x2,
    0x4,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x9,
    0x3,
    0x10,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x4,
    0x0,
    0x5,
    0x2,
    0x0,
    0x5,
    0x0,
    0x1,
    0x1,
    0x4,
    0x0,
    0x7,
    0x6,
    0x4,
    0x0,
    0x0,
    0x1,
    0x7,
    0x0,
    0x2,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x5,
    0x2,
    0x6,
    0x1,
    0x2,
    0x5,
    0x6,
    0x2,
    0x4,
    0x0,
    0x3,
    0x1,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x3,
    0x6,
    0x1,
    0x1,
    0x1,
    0x3,
    0x7,
    0x0,
    0x0,
    0x0,
    0x2,
    0x4,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x5,
    0x2,
    0x5,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x0,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x2,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x1,
    0x4,
    0x2,
    0xb,
    0x1,
    0x0,
    0x0,
    0x1,
    0x4,
    0x2,
    0x0,
    0x1,
    0x4,
    0x1,
    0x2,
    0x2,
    0x1,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x5,
    0x2,
    0x2,
    0x0,
    0x0,
    0x4,
    0x4,
    0x5,
    0x2,
    0x0,
    0x0,
    0xd,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x6,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x2,
    0x9,
    0x3,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0x2,
    0x3,
    0x1,
    0x4,
    0x0,
    0x2,
    0x7,
    0x1,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0x5,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x5,
    0x0,
    0x1,
    0x0,
    0x7,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x4,
    0x0,
    0x0,
    0x1,
    0x2,
    0x6,
    0x0,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x2,
    0x2,
    0x2,
    0x6,
    0x1,
    0x1,
    0x7,
    0x0,
    0x1,
    0x2,
    0x5,
    0x1,
    0x2,
    0x1,
    0x1,
    0x1,
    0x3,
    0x2,
    0x2,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0x4,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x3,
    0x0,
    0x1,
    0x2,
];
pub(crate) const CANONICAL_DECOMPOSED_KV: &[(u32, (u16, u16))] = &[
    (0x4ee, (666, 2)),
    (0x2f869, (2969, 1)),
    (0x30b2, (2217, 2)),
    (0x1f2e, (1546, 3)),
    (0x120, (166, 2)),
    (0xf905, (2278, 1)),
    (0xf9e8, (2505, 1)),
    (0x1e3a, (978, 2)),
    (0xf965, (2374, 1)),
    (0x1ebd, (1270, 2)),
    (0x2f83a, (2922, 1)),
    (0x101, (108, 2)),
    (0xf986, (2407, 1)),
    (0xfa57, (2604, 1)),
    (0x1f91, (1796, 3)),
    (0x4df, (644, 2)),
    (0x1e2, (382, 2)),
    (0x229, (498, 2)),
    (0x1af, (326, 2)),
    (0xfa66, (2619, 1)),
    (0x1f39, (1576, 2)),
    (0x1e7a, (1124, 3)),
    (0x1f6c, (1693, 3)),
    (0xfaa8, (2683, 1)),
    (0x2f8ce, (3070, 1)),
    (0x128, (178, 2)),
    (0xfa4b, (2592, 1)),
    (0x2f818, (2888, 1)),
    (0x2f988, (3256, 1)),
    (0xf974, (2389, 1)),
    (0x1ea9, (1215, 3)),
    (0x1f51, (1630, 2)),
    (0x2f833, (2915, 1)),
    (0x2f8fc, (3116, 1)),
    (0x38f, (548, 2)),
    (0xfa3e, (2579, 1)),
    (0xfa5e, (2611, 1)),
    (0xfa1e, (2554, 1)),
    (0x2f9f7, (3367, 1)),
    (0x15f, (262, 2)),
    (0x1e35, (966, 2)),
    (0xfb47, (2787, 2)),
    (0x2f962, (3218, 1)),
    (0xfa86, (2649, 1)),
    (0xf92f, (2320, 1)),
    (0x2f8dd, (3085, 1)),
    (0xf73, (804, 2)),
    (0x1e15, (895, 3)),
    (0x1ed0, (1318, 3)),
    (0xf9ca, (2475, 1)),
    (0x4e6, (654, 2)),
    (0x1fa2, (1859, 4)),
    (0x2f999, (3273, 1)),
    (0x1fc2, (1943, 3)),
    (0x2f8c7, (3063, 1)),
    (0xfabc, (2703, 1)),
    (0x30b4, (2219, 2)),
    (0x2f9b9, (3305, 1)),
    (0x1e73, (1108, 2)),
    (0xf95b, (2364, 1)),
    (0x2f952, (3202, 1)),
    (0xfa5f, (2612, 1)),
    (0x1b08, (830, 2)),
    (0x2204, (2077, 2)),
    (0x1ea2, (1196, 2)),
    (0x1ea, (394, 2)),
    (0x129, (180, 2)),
    (0xf920, (2305, 1)),
    (0x1f85, (1751, 4)),
    (0x1e93, (1176, 2)),
    (0x2f9b2, (3298, 1)),
    (0x2f821, (2897, 1)),
    (0x2f9d6, (3334, 1)),
    (0xfa65, (2618, 1)),
    (0xf971, (2386, 1)),
    (0x230, (516, 3)),
    (0x16d, (286, 2)),
    (0x21b, (486, 2)),
    (0x2f9d4, (3332, 1)),
    (0x1d161, (2836, 3)),
    (0xfa94, (2663, 1)),
    (0x403, (586, 2)),
    (0x16a, (280, 2)),
    (0x958, (708, 2)),
    (0x2f922, (3154, 1)),
    (0xf93d, (2334, 1)),
    (0x1e39, (975, 3)),
    (0x2f870, (2976, 1)),
    (0x1eae, (1230, 3)),
    (0x1f35, (1565, 3)),
    (0xfa2f, (2564, 1)),
    (0x15e, (260, 2)),
    (0x1e43, (996, 2)),
    (0x2f842, (2930, 1)),
    (0xf9b1, (2450, 1)),
    (0xfa5d, (2610, 1)),
    (0xf9d2, (2483, 1)),
    (0x1ed8, (1342, 3)),
    (0xfaca, (2717, 1)),
    (0x1edc, (1354, 3)),
    (0x2f9fd, (3373, 1)),
    (0x2f90b, (3131, 1)),
    (0x1ec9, (1304, 2)),
    (0x2329, (2153, 1)),
    (0x1e96, (1182, 2)),
    (0x2f9a0, (3280, 1)),
    (0xf9d0, (2481, 1)),
    (0x4ed, (664, 2)),
    (0xc2, (4, 2)),
    (0x1e79, (1121, 3)),
    (0x4f1, (672, 2)),
    (0x1fd0, (1972, 2)),
    (0x1ef5, (1422, 2)),
    (0x125, (176, 2)),
    (0xfb2c, (2741, 3)),
    (0x387, (537, 1)),
    (0xf9ef, (2512, 1)),
    (0x2f9f5, (3365, 1)),
    (0x170, (292, 2)),
    (0x2270, (2105, 2)),
    (0x2f9cc, (3324, 1)),
    (0xfa6d, (2626, 1)),
    (0xf980, (2401, 1)),
    (0xf907, (2280, 1)),
    (0x2f857, (2951, 1)),
    (0x1eb9, (1262, 2)),
    (0x2f8d5, (3077, 1)),
    (0xf9f9, (2522, 1)),
    (0x2f8a2, (3026, 1)),
    (0xf94b, (2348, 1)),
    (0x2f87e, (2990, 1)),
    (0xf91f, (2304, 1)),
    (0xf9ec, (2509, 1)),
    (0x4f4, (678, 2)),
    (0x451, (602, 2)),
    (0x22ad, (2131, 2)),
    (0x2f917, (3143, 1)),
    (0x2f861, (2961, 1)),
    (0xf91d, (2302, 1)),
    (0xfa96, (2665, 1)),
    (0xf6, (92, 2)),
    (0x1e27, (936, 2)),
    (0x1f48, (1612, 2)),
    (0x1feb, (2026, 2)),
    (0x1ee5, (1380, 2)),
    (0x2f99f, (3279, 1)),
    (0x2f8e8, (3096, 1)),
    (0xf9df, (2496, 1)),
    (0x1eaf, (1233, 3)),
    (0xf92a, (2315, 1)),
    (0xfa78, (2635, 1)),
    (0xfa6c, (2625, 1)),
    (0x1e22, (926, 2)),
    (0x1eea, (1392, 3)),
    (0x2f850, (2944, 1)),
    (0x2f9c9, (3321, 1)),
    (0xf91c, (2301, 1)),
    (0xa33, (734, 2)),
    (0xe7, (64, 2)),
    (0x2f80b, (2875, 1)),
    (0xfa91, (2660, 1)),
    (0x9dd, (730, 2)),
    (0x2f848, (2936, 1)),
    (0xf966, (2375, 1)),
    (0xfb36, (2763, 2)),
    (0xf957, (2360, 1)),
    (0x2f88a, (3002, 1)),
    (0x305c, (2173, 2)),
    (0x2f982, (3250, 1)),
    (0x122, (170, 2)),
    (0xf95d, (2366, 1)),
    (0x2f8cc, (3068, 1)),
    (0x2f86a, (2970, 1)),
    (0x1f81, (1736, 3)),
    (0x212a, (2062, 1)),
    (0x17e, (320, 2)),
    (0xf9a9, (2442, 1)),
    (0xfabd, (2704, 1)),
    (0x2f91e, (3150, 1)),
    (0xf9eb, (2508, 1)),
    (0x2f937, (3175, 1)),
    (0x2f8a6, (3030, 1)),
    (0x1e42, (994, 2)),
    (0x1112f, (2811, 2)),
    (0x1fa8, (1883, 3)),
    (0xc0, (0, 2)),
    (0x2f8da, (3082, 1)),
    (0x2f9b5, (3301, 1)),
    (0x2f8c1, (3057, 1)),
    (0xf9b4, (2453, 1)),
    (0x171, (294, 2)),
    (0xf952, (2355, 1)),
    (0xfa08, (2537, 1)),
    (0x1fac, (1897, 4)),
    (0x1fb, (421, 3)),
    (0xf912, (2291, 1)),
    (0x1f11, (1478, 2)),
    (0x201, (434, 2)),
    (0x2f8b9, (3049, 1)),
    (0x2fa1c, (3404, 1)),
    (0x2f8b5, (3045, 1)),
    (0x1e88, (1154, 2)),
    (0xfab8, (2699, 1)),
    (0xfa43, (2584, 1)),
    (0x144, (218, 2)),
    (0x1e8b, (1160, 2)),
    (0x2f9e1, (3345, 1)),
    (0xf97c, (2397, 1)),
    (0xf985, (2406, 1)),
    (0x1f06, (1448, 3)),
    (0x1fb2, (1917, 3)),
    (0x2f9db, (3339, 1)),
    (0x1fe4, (2011, 2)),
    (0xfac3, (2710, 1)),
    (0x177, (306, 2)),
    (0x2f948, (3192, 1)),
    (0xcb, (20, 2)),
    (0x1f9f, (1849, 4)),
    (0xfa99, (2668, 1)),
    (0x2f942, (3186, 1)),
    (0x2f976, (3238, 1)),
    (0xf988, (2409, 1)),
    (0x1fe6, (2015, 2)),
    (0x156, (244, 2)),
    (0x1e8e, (1166, 2)),
    (0x2f8fe, (3118, 1)),
    (0x1e46, (1002, 2)),
    (0x2f81e, (2894, 1)),
    (0x45d, (610, 2)),
    (0x1fcf, (1970, 2)),
    (0x1ecf, (1316, 2)),
    (0x1e48, (1006, 2)),
    (0xf9cb, (2476, 1)),
    (0x2f946, (3190, 1)),
    (0xfacf, (2722, 1)),
    (0x109, (124, 2)),
    (0x22e3, (2143, 2)),
    (0xf52, (796, 2)),
    (0x304c, (2157, 2)),
    (0xf9b2, (2451, 1)),
    (0x12c, (186, 2)),
    (0x2f969, (3225, 1)),
    (0x2f9a5, (3285, 1)),
    (0x307a, (2201, 2)),
    (0x2f9be, (3310, 1)),
    (0x1f1b, (1499, 3)),
    (0x1f5d, (1655, 3)),
    (0x2f9ab, (3291, 1)),
    (0x2f8f1, (3105, 1)),
    (0xf9be, (2463, 1)),
    (0xf9b8, (2457, 1)),
    (0x1fb4, (1922, 3)),
    (0x1edf, (1363, 3)),
    (0x22f, (514, 2)),
    (0x934, (706, 2)),
    (0x2f98a, (3258, 1)),
    (0x1fe8, (2020, 2)),
    (0xfaab, (2686, 1)),
    (0xfa5b, (2608, 1)),
    (0x4d3, (628, 2)),
    (0x2226, (2085, 2)),
    (0x2fa03, (3379, 1)),
    (0xfa12, (2544, 1)),
    (0x1ee4, (1378, 2)),
    (0x1fd6, (1982, 2)),
    (0xf931, (2322, 1)),
    (0xfaa1, (2676, 1)),
    (0x2f936, (3174, 1)),
    (0x1fe9, (2022, 2)),
    (0x1ff4, (2040, 3)),
    (0x2f86c, (2972, 1)),
    (0x2f911, (3137, 1)),
    (0x95f, (722, 2)),
    (0xcd, (24, 2)),
    (0x2f95e, (3214, 1)),
    (0xf98f, (2416, 1)),
    (0x1e08, (866, 3)),
    (0x30fa, (2269, 2)),
    (0x4da, (634, 2)),
    (0xf9c5, (2470, 1)),
    (0x1d8, (355, 3)),
    (0x1ec, (398, 3)),
    (0xf95e, (2367, 1)),
    (0xfb4e, (2801, 2)),
    (0xc5, (10, 2)),
    (0x2f87d, (2989, 1)),
    (0x1b0c, (834, 2)),
    (0x2f9c6, (3318, 1)),
    (0x2f879, (2985, 1)),
    (0x2f9f2, (3362, 1)),
    (0x1ece, (1314, 2)),
    (0xdda, (783, 2)),
    (0x1f80, (1733, 3)),
    (0x3074, (2193, 2)),
    (0x2289, (2127, 2)),
    (0x1d0, (336, 2)),
    (0x1eac, (1224, 3)),
    (0x2f851, (2945, 1)),
    (0x22c, (506, 3)),
    (0x1f9e, (1845, 4)),
    (0x2f9d2, (3330, 1)),
    (0xfa05, (2534, 1)),
    (0x2f88c, (3004, 1)),
    (0x1ffd, (2058, 1)),
    (0x1f0b, (1461, 3)),
    (0xfaba, (2701, 1)),
    (0x1e82, (1142, 2)),
    (0x2f8c2, (3058, 1)),
    (0x1f30, (1552, 2)),
    (0x1f87, (1759, 4)),
    (0xfa61, (2614, 1)),
    (0x1b06, (828, 2)),
    (0x2f9e8, (3352, 1)),
    (0x2f80e, (2878, 1)),
    (0x1f00, (1432, 2)),
    (0xfa03, (2532, 1)),
    (0x202, (436, 2)),
    (0x1ce, (332, 2)),
    (0x2fa12, (3394, 1)),
    (0x2f84f, (2943, 1)),
    (0x4c1, (618, 2)),
    (0xfa81, (2644, 1)),
    (0xfac7, (2714, 1)),
    (0xf9bb, (2460, 1)),
    (0x16f, (290, 2)),
    (0x114, (142, 2)),
    (0xcc7, (768, 2)),
    (0x1b0e, (836, 2)),
    (0x2f9d1, (3329, 1)),
    (0x139, (204, 2)),
    (0x2f836, (2918, 1)),
    (0xb48, (746, 2)),
    (0x30f9, (2267, 2)),
    (0xfa79, (2636, 1)),
    (0x3058, (2169, 2)),
    (0x2f971, (3233, 1)),
    (0x2f928, (3160, 1)),
    (0x1fc, (424, 2)),
    (0x2224, (2083, 2)),
    (0xfab3, (2694, 1)),
    (0x2f8e7, (3095, 1)),
    (0x1fde, (1997, 2)),
    (0x1e7, (388, 2)),
    (0x1e13, (890, 2)),
    (0xfa5a, (2607, 1)),
    (0x1fce, (1968, 2)),
    (0x1e58, (1046, 2)),
    (0x2f964, (3220, 1)),
    (0xfabe, (2705, 1)),
    (0x1e0f, (882, 2)),
    (0x2f938, (3176, 1)),
    (0x11d, (160, 2)),
    (0xf994, (2421, 1)),
    (0xf947, (2344, 1)),
    (0x3aa, (553, 2)),
    (0xf981, (2402, 1)),
    (0x1e30, (956, 2)),
    (0x1f14, (1486, 3)),
    (0xf9f1, (2514, 1)),
    (0x1fa9, (1886, 3)),
    (0x1e62, (1068, 2)),
    (0x2f85d, (2957, 1)),
    (0xfa4e, (2595, 1)),
    (0x1f22, (1512, 3)),
    (0x2f838, (2920, 1)),
    (0x2f9a6, (3286, 1)),
    (0xf93f, (2336, 1)),
    (0x2f9f3, (3363, 1)),
    (0xfaad, (2688, 1)),
    (0x2f87a, (2986, 1)),
    (0x2f830, (2912, 1)),
    (0x2f8c8, (3064, 1)),
    (0x10a, (126, 2)),
    (0x20b, (454, 2)),
    (0x1f77, (1719, 2)),
    (0xfab4, (2695, 1)),
    (0x2f985, (3253, 1)),
    (0xf9f7, (2520, 1)),
    (0x2f94f, (3199, 1)),
    (0xfa40, (2581, 1)),
    (0x2f968, (3224, 1)),
    (0xfa8c, (2655, 1)),
    (0xce, (26, 2)),
    (0xfac0, (2707, 1)),
    (0x3062, (2179, 2)),
    (0xf9, (94, 2)),
    (0x1fb0, (1913, 2)),
    (0xb94, (756, 2)),
    (0x2f926, (3158, 1)),
    (0x1f84, (1747, 4)),
    (0x4ef, (668, 2)),
    (0xf9d, (816, 2)),
    (0x226d, (2099, 2)),
    (0x1f28, (1530, 2)),
    (0x2f955, (3205, 1)),
    (0x2279, (2115, 2)),
    (0xfab6, (2697, 1)),
    (0xf935, (2326, 1)),
    (0x439, (598, 2)),
    (0x11938, (2827, 2)),
    (0xee, (78, 2)),
    (0x17b, (314, 2)),
    (0x1e0c, (876, 2)),
    (0x1e6a, (1090, 2)),
    (0x214, (472, 2)),
    (0xf57, (798, 2)),
    (0x2f825, (2901, 1)),
    (0x114bb, (2817, 2)),
    (0x100, (106, 2)),
    (0x1e6, (386, 2)),
    (0x2f951, (3201, 1)),
    (0x2f9ce, (3326, 1)),
    (0x2f984, (3252, 1)),
    (0x22eb, (2147, 2)),
    (0x1f6b, (1690, 3)),
    (0x13b, (208, 2)),
    (0x2f9e9, (3353, 1)),
    (0x2f8be, (3054, 1)),
    (0x2f823, (2899, 1)),
    (0x2f9d3, (3331, 1)),
    (0x2f97c, (3244, 1)),
    (0xfa49, (2590, 1)),
    (0x1eb1, (1239, 3)),
    (0x2f998, (3272, 1)),
    (0x304e, (2159, 2)),
    (0x1f0d, (1467, 3)),
    (0xd4a, (777, 2)),
    (0xfb39, (2767, 2)),
    (0x305a, (2171, 2)),
    (0xf9b0, (2449, 1)),
    (0x2f8ff, (3119, 1)),
    (0x30ae, (2213, 2)),
    (0x2f977, (3239, 1)),
    (0x1fa, (418, 3)),
    (0x1e20, (922, 2)),
    (0xf917, (2296, 1)),
    (0xf989, (2410, 1)),
    (0xf90e, (2287, 1)),
    (0xfb34, (2759, 2)),
    (0x2f889, (3001, 1)),
    (0x2f866, (2966, 1)),
    (0x2f865, (2965, 1)),
    (0x12f, (192, 2)),
    (0x2fa0e, (3390, 1)),
    (0x1e61, (1066, 2)),
    (0x1fd, (426, 2)),
    (0x2f803, (2867, 1)),
    (0x1fe3, (2008, 3)),
    (0xfa44, (2585, 1)),
    (0x1fa6, (1875, 4)),
    (0x20f, (462, 2)),
    (0x1fa4, (1867, 4)),
    (0xccb, (774, 3)),
    (0xfa4f, (2596, 1)),
    (0x2f997, (3271, 1)),
    (0x1e4b, (1012, 2)),
    (0xfaa2, (2677, 1)),
    (0x2f839, (2921, 1)),
    (0x1f55, (1641, 3)),
    (0x1e32, (960, 2)),
    (0xf9f0, (2513, 1)),
    (0xea, (70, 2)),
    (0x2f8d4, (3076, 1)),
    (0xf969, (2378, 1)),
    (0xfa, (96, 2)),
    (0x1e33, (962, 2)),
    (0x1e6f, (1100, 2)),
    (0xf9aa, (2443, 1)),
    (0xf938, (2329, 1)),
    (0x2f826, (2902, 1)),
    (0xf93c, (2333, 1)),
    (0x4e2, (646, 2)),
    (0x1e5f, (1062, 2)),
    (0x4c2, (620, 2)),
    (0x4dd, (640, 2)),
    (0x390, (550, 3)),
    (0x2f923, (3155, 1)),
    (0x419, (596, 2)),
    (0x2f8e9, (3097, 1)),
    (0x1b3b, (840, 2)),
    (0x2f860, (2960, 1)),
    (0x1ec0, (1278, 3)),
    (0x124, (174, 2)),
    (0x2f935, (3173, 1)),
    (0x21cd, (2071, 2)),
    (0x2f81f, (2895, 1)),
    (0x1f95, (1811, 4)),
    (0xfa59, (2606, 1)),
    (0xfb4a, (2793, 2)),
    (0x137, (202, 2)),
    (0x2fa19, (3401, 1)),
    (0x1e8c, (1162, 2)),
    (0x2fa11, (3393, 1)),
    (0xf992, (2419, 1)),
    (0xf99b, (2428, 1)),
    (0x226f, (2103, 2)),
    (0x2f908, (3128, 1)),
    (0x1ea1, (1194, 2)),
    (0x30c7, (2237, 2)),
    (0xf5c, (800, 2)),
    (0x114bc, (2819, 2)),
    (0xf91a, (2299, 1)),
    (0xfb49, (2791, 2)),
    (0x2f892, (3010, 1)),
    (0x1d1bb, (2848, 2)),
    (0x40e, (594, 2)),
    (0x1e7e, (1134, 2)),
    (0x1fd3, (1979, 3)),
    (0x1fb6, (1925, 2)),
    (0x164, (272, 2)),
    (0x2f92b, (3163, 1)),
    (0x1f3d, (1587, 3)),
    (0x386, (535, 2)),
    (0x1f24, (1518, 3)),
    (0xfacd, (2720, 1)),
    (0xfa17, (2547, 1)),
    (0x1e17, (901, 3)),
    (0xfa0b, (2540, 1)),
    (0x2f980, (3248, 1)),
    (0xfa2d, (2562, 1)),
    (0x2f88e, (3006, 1)),
    (0xfb2e, (2747, 2)),
    (0xfa31, (2566, 1)),
    (0x1f09, (1456, 2)),
    (0x2f815, (2885, 1)),
    (0x2f9ca, (3322, 1)),
    (0xfa55, (2602, 1)),
    (0x2f9f9, (3369, 1)),
    (0x1f62, (1665, 3)),
    (0x106, (118, 2)),
    (0x1ebf, (1275, 3)),
    (0x1f38, (1574, 2)),
    (0x1f20, (1508, 2)),
    (0x2f965, (3221, 1)),
    (0x2f829, (2905, 1)),
    (0x1ffb, (2054, 2)),
    (0xc9, (16, 2)),
    (0x147, (224, 2)),
    (0x2f9c3, (3315, 1)),
    (0x213, (470, 2)),
    (0x1f9d, (1841, 4)),
    (0x1f25, (1521, 3)),
    (0x2f9af, (3295, 1)),
    (0xfa77, (2634, 1)),
    (0x2209, (2079, 2)),
    (0xf76, (808, 2)),
    (0xf956, (2359, 1)),
    (0x1fcc, (1964, 2)),
    (0x1fa0, (1853, 3)),
    (0x13c, (210, 2)),
    (0x1eb3, (1245, 3)),
    (0x1e5a, (1050, 2)),
    (0xfb35, (2761, 2)),
    (0xf9b5, (2454, 1)),
    (0xfa0a, (2539, 1)),
    (0x1fa5, (1871, 4)),
    (0x22e, (512, 2)),
    (0x1eee, (1404, 3)),
    (0x1d5, (346, 3)),
    (0x15c, (256, 2)),
    (0xe3, (58, 2)),
    (0xfa8b, (2654, 1)),
    (0x3079, (2199, 2)),
    (0xfb38, (2765, 2)),
    (0x2f855, (2949, 1)),
    (0xfa9e, (2673, 1)),
    (0x14e, (232, 2)),
    (0x1e75, (1112, 2)),
    (0xfa46, (2587, 1)),
    (0x2fa0a, (3386, 1)),
    (0x211, (466, 2)),
    (0x2f8a9, (3033, 1)),
    (0x115, (144, 2)),
    (0x30d1, (2243, 2)),
    (0x1e47, (1004, 2)),
    (0x2f8e0, (3088, 1)),
    (0xfa7e, (2641, 1)),
    (0x1fd8, (1987, 2)),
    (0x1e92, (1174, 2)),
    (0x2f867, (2967, 1)),
    (0xfb1d, (2733, 2)),
    (0xf97d, (2398, 1)),
    (0xfab9, (2700, 1)),
    (0x2f846, (2934, 1)),
    (0x1e7d, (1132, 2)),
    (0xfac8, (2715, 1)),
    (0x104, (114, 2)),
    (0x4f5, (680, 2)),
    (0x2fa10, (3392, 1)),
    (0xf975, (2390, 1)),
    (0xf96a, (2379, 1)),
    (0xfa2b, (2560, 1)),
    (0x1f73, (1711, 2)),
    (0x2f957, (3207, 1)),
    (0x1edd, (1357, 3)),
    (0x3ad, (559, 2)),
    (0x2f924, (3156, 1)),
    (0xfad4, (2727, 1)),
    (0x2f97b, (3243, 1)),
    (0x2f853, (2947, 1)),
    (0xfa3f, (2580, 1)),
    (0xfa8a, (2653, 1)),
    (0xfb4c, (2797, 2)),
    (0x1f3b, (1581, 3)),
    (0xc4, (8, 2)),
    (0x1109a, (2803, 2)),
    (0x341, (527, 1)),
    (0x1e0d, (878, 2)),
    (0x4dc, (638, 2)),
    (0xfa10, (2543, 1)),
    (0x1ef1, (1413, 3)),
    (0x2f903, (3123, 1)),
    (0x1fed, (2030, 2)),
    (0x1fef, (2034, 1)),
    (0x1ea4, (1200, 3)),
    (0x21f, (490, 2)),
    (0xfa92, (2661, 1)),
    (0x2f8a4, (3028, 1)),
    (0xf9c8, (2473, 1)),
    (0xf9a0, (2433, 1)),
    (0x1e31, (958, 2)),
    (0xf903, (2276, 1)),
    (0x3d4, (580, 2)),
    (0x2f809, (2873, 1)),
    (0x1e07, (864, 2)),
    (0x1fb1, (1915, 2)),
    (0x2f8d1, (3073, 1)),
    (0x1e11, (886, 2)),
    (0x1fd2, (1976, 3)),
    (0x1d15e, (2829, 2)),
    (0x2f941, (3185, 1)),
    (0xf962, (2371, 1)),
    (0x1ef0, (1410, 3)),
    (0x1ee0, (1366, 3)),
    (0x3052, (2163, 2)),
    (0x148, (226, 2)),
    (0x1f44, (1606, 3)),
    (0x2f930, (3168, 1)),
    (0x1e0b, (874, 2)),
    (0x2f83e, (2926, 1)),
    (0x3094, (2207, 2)),
    (0x1e5b, (1052, 2)),
    (0xfa54, (2601, 1)),
    (0xf9fc, (2525, 1)),
    (0x1de, (370, 3)),
    (0x1e02, (854, 2)),
    (0x2f9e4, (3348, 1)),
    (0xf97f, (2400, 1)),
    (0x1fe1, (2003, 2)),
    (0x1ecb, (1308, 2)),
    (0x2f947, (3191, 1)),
    (0x2f82d, (2909, 1)),
    (0x1f6d, (1696, 3)),
    (0x1e4c, (1014, 3)),
    (0x1e00, (850, 2)),
    (0x2f93c, (3180, 1)),
    (0x2f9c4, (3316, 1)),
    (0x1f2d, (1543, 3)),
    (0x38c, (544, 2)),
    (0x115bb, (2825, 2)),
    (0xfa0c, (2541, 1)),
    (0x2f986, (3254, 1)),
    (0x1f0a, (1458, 3)),
    (0x1f83, (1743, 4)),
    (0x1ee3, (1375, 3)),
    (0x2f93e, (3182, 1)),
    (0x2f8ed, (3101, 1)),
    (0x2f981, (3249, 1)),
    (0x1f54, (1638, 3)),
    (0x1e16, (898, 3)),
    (0xfa6a, (2623, 1)),
    (0x179, (310, 2)),
    (0xfb2d, (2744, 3)),
    (0xf90b, (2284, 1)),
    (0xfb3e, (2775, 2)),
    (0x2f9b0, (3296, 1)),
    (0xf932, (2323, 1)),
    (0x1ee6, (1382, 2)),
    (0x2f85e, (2958, 1)),
    (0x2f8d7, (3079, 1)),
    (0x1e40, (990, 2)),
    (0x22ed, (2151, 2)),
    (0x1f43, (1603, 3)),
    (0x4e5, (652, 2)),
    (0xfaa5, (2680, 1)),
    (0x1fa3, (1863, 4)),
    (0x2f967, (3223, 1)),
    (0xf993, (2420, 1)),
    (0x2f88d, (3005, 1)),
    (0xed, (76, 2)),
    (0x2f906, (3126, 1)),
    (0xfa98, (2667, 1)),
    (0x2f901, (3121, 1)),
    (0x1ff7, (2045, 3)),
    (0x95c, (716, 2)),
    (0xfa60, (2613, 1)),
    (0x3ca, (568, 2)),
    (0xfa62, (2615, 1)),
    (0x2f8c3, (3059, 1)),
    (0x1eca, (1306, 2)),
    (0xf950, (2353, 1)),
    (0x173, (298, 2)),
    (0x2f99a, (3274, 1)),
    (0x2f970, (3232, 1)),
    (0x2f85a, (2954, 1)),
    (0x2fa13, (3395, 1)),
    (0xf98b, (2412, 1)),
    (0x2f913, (3139, 1)),
    (0xfb9, (824, 2)),
    (0xf919, (2298, 1)),
    (0x1eba, (1264, 2)),
    (0x2f890, (3008, 1)),
    (0xf953, (2356, 1)),
    (0x1eb2, (1242, 3)),
    (0xf904, (2277, 1)),
    (0x1dc, (367, 3)),
    (0x3ab, (555, 2)),
    (0xf94e, (2351, 1)),
    (0x2f8df, (3087, 1)),
    (0x1f19, (1494, 2)),
    (0x30bc, (2227, 2)),
    (0x305e, (2175, 2)),
    (0x1e87, (1152, 2)),
    (0xf9fa, (2523, 1)),
    (0x2f82b, (2907, 1)),
    (0x2f81d, (2893, 1)),
    (0x2f8a3, (3027, 1)),
    (0x2fa04, (3380, 1)),
    (0xfa3a, (2575, 1)),
    (0x4e4, (650, 2)),
    (0x2f9d5, (3333, 1)),
    (0x2f90d, (3133, 1)),
    (0xf967, (2376, 1)),
    (0xfad3, (2726, 1)),
    (0x1ff2, (2035, 3)),
    (0x1e86, (1150, 2)),
    (0xf92d, (2318, 1)),
    (0x1ef7, (1426, 2)),
    (0xfa89, (2652, 1)),
    (0x2f874, (2980, 1)),
    (0x2f852, (2946, 1)),
    (0xf9cd, (2478, 1)),
    (0x2f854, (2948, 1)),
    (0x1e25, (932, 2)),
    (0x1ec1, (1281, 3)),
    (0x1edb, (1351, 3)),
    (0x205, (442, 2)),
    (0x2f843, (2931, 1)),
    (0x2f8b1, (3041, 1)),
    (0x1fb8, (1930, 2)),
    (0xbcb, (760, 2)),
    (0x2f84c, (2940, 1)),
    (0xfa30, (2565, 1)),
    (0x9cb, (724, 2)),
    (0x2f858, (2952, 1)),
    (0x1f5b, (1652, 3)),
    (0x6c2, (698, 2)),
    (0x2f950, (3200, 1)),
    (0xb5c, (752, 2)),
    (0xfa4d, (2594, 1)),
    (0x1f93, (1803, 4)),
    (0xfa74, (2631, 1)),
    (0x1f59, (1650, 2)),
    (0x2fa1d, (3405, 1)),
    (0xfa70, (2627, 1)),
    (0xfa18, (2548, 1)),
    (0x2f888, (3000, 1)),
    (0x2f8b7, (3047, 1)),
    (0xf99d, (2430, 1)),
    (0xf9db, (2492, 1)),
    (0xf940, (2337, 1)),
    (0x1f8d, (1781, 4)),
    (0x1f97, (1819, 4)),
    (0x1e10, (884, 2)),
    (0xf997, (2424, 1)),
    (0x2f956, (3206, 1)),
    (0x2f9aa, (3290, 1)),
    (0x1e41, (992, 2)),
    (0x2f90c, (3132, 1)),
    (0x2f862, (2962, 1)),
    (0x1e66, (1078, 3)),
    (0x1ef8, (1428, 2)),
    (0x2f849, (2937, 1)),
    (0x2f894, (3012, 1)),
    (0x1e7f, (1136, 2)),
    (0x1f29, (1532, 2)),
    (0xfa1c, (2552, 1)),
    (0x1eb0, (1236, 3)),
    (0x1f74, (1713, 2)),
    (0x1ee9, (1389, 3)),
    (0x1fbb, (1936, 2)),
    (0x162, (268, 2)),
    (0xd2, (32, 2)),
    (0xfa97, (2666, 1)),
    (0x2f824, (2900, 1)),
    (0x233, (524, 2)),
    (0x22af, (2135, 2)),
    (0x1fec, (2028, 2)),
    (0xfa7f, (2642, 1)),
    (0x2f94a, (3194, 1)),
    (0x2f887, (2999, 1)),
    (0x2fa17, (3399, 1)),
    (0x931, (704, 2)),
    (0x130, (194, 2)),
    (0x135, (198, 2)),
    (0x3076, (2195, 2)),
    (0xfa2, (818, 2)),
    (0x4f8, (682, 2)),
    (0x1f27, (1527, 3)),
    (0xf963, (2372, 1)),
    (0xf94d, (2350, 1)),
    (0x340, (526, 1)),
    (0x2f9cd, (3325, 1)),
    (0x1e01, (852, 2)),
    (0x1ed3, (1327, 3)),
    (0x103, (112, 2)),
    (0x200, (432, 2)),
    (0x17c, (316, 2)),
    (0xf92c, (2317, 1)),
    (0x1e12, (888, 2)),
    (0xfb33, (2757, 2)),
    (0xfa93, (2662, 1)),
    (0xf5, (90, 2)),
    (0x30f8, (2265, 2)),
    (0x210, (464, 2)),
    (0xf3, (86, 2)),
    (0x2f804, (2868, 1)),
    (0x2f8c0, (3056, 1)),
    (0x21a, (484, 2)),
    (0x1e1c, (912, 3)),
    (0x11e, (162, 2)),
    (0x1f8f, (1789, 4)),
    (0xfa4c, (2593, 1)),
    (0x95b, (714, 2)),
    (0xfa45, (2586, 1)),
    (0xfad5, (2728, 1)),
    (0x2f82e, (2910, 1)),
    (0xfa5c, (2609, 1)),
    (0xf9b7, (2456, 1)),
    (0x206, (444, 2)),
    (0x1fc7, (1953, 3)),
    (0x3cb, (570, 2)),
    (0xf9dc, (2493, 1)),
    (0x22b, (503, 3)),
    (0xf92e, (2319, 1)),
    (0x1ee2, (1372, 3)),
    (0x2f88f, (3007, 1)),
    (0x2f94c, (3196, 1)),
    (0xfa84, (2647, 1)),
    (0x2f9e3, (3347, 1)),
    (0xf9d6, (2487, 1)),
    (0x15d, (258, 2)),
    (0x1e24, (930, 2)),
    (0x2f95c, (3212, 1)),
    (0x1ea6, (1206, 3)),
    (0x1ea8, (1212, 3)),
    (0x30f7, (2263, 2)),
    (0xf977, (2392, 1)),
    (0xfac4, (2711, 1)),
    (0xfa3b, (2576, 1)),
    (0x2f904, (3124, 1)),
    (0xf9ab, (2444, 1)),
    (0x4eb, (660, 2)),
    (0xfa20, (2555, 1)),
    (0x2f907, (3127, 1)),
    (0x1ec6, (1296, 3)),
    (0x2fa05, (3381, 1)),
    (0x110ab, (2807, 2)),
    (0x1e3f, (988, 2)),
    (0x2285, (2123, 2)),
    (0x343, (528, 1)),
    (0xf9da, (2491, 1)),
    (0x2fa07, (3383, 1)),
    (0x2fa15, (3397, 1)),
    (0x4f3, (676, 2)),
    (0x113, (140, 2)),
    (0x1f7b, (1727, 2)),
    (0x21cf, (2075, 2)),
    (0x1f7a, (1725, 2)),
    (0xe5, (62, 2)),
    (0x307d, (2205, 2)),
    (0x2fa14, (3396, 1)),
    (0x2f891, (3009, 1)),
    (0x2f9e5, (3349, 1)),
    (0x2f983, (3251, 1)),
    (0x1f90, (1793, 3)),
    (0x1e85, (1148, 2)),
    (0xd4, (36, 2)),
    (0x22e0, (2137, 2)),
    (0x3ae, (561, 2)),
    (0x2f8ae, (3038, 1)),
    (0xf9fb, (2524, 1)),
    (0xf99c, (2429, 1)),
    (0x217, (478, 2)),
    (0x1eb7, (1257, 3)),
    (0x2f8aa, (3034, 1)),
    (0x385, (533, 2)),
    (0xfa16, (2546, 1)),
    (0x2f9e2, (3346, 1)),
    (0x1e1, (379, 3)),
    (0x2fa00, (3376, 1)),
    (0x154, (240, 2)),
    (0x1fb7, (1927, 3)),
    (0x1eef, (1407, 3)),
    (0xfa02, (2531, 1)),
    (0x2f990, (3264, 1)),
    (0x1e52, (1032, 3)),
    (0x624, (690, 2)),
    (0x2f99d, (3277, 1)),
    (0x2f883, (2995, 1)),
    (0x1fd7, (1984, 3)),
    (0xf9cc, (2477, 1)),
    (0xf926, (2311, 1)),
    (0x1e56, (1042, 2)),
    (0xfa06, (2535, 1)),
    (0xfa51, (2598, 1)),
    (0x1ef4, (1420, 2)),
    (0x2f9da, (3338, 1)),
    (0x1e36, (968, 2)),
    (0x6d3, (700, 2)),
    (0x2f9ff, (3375, 1)),
    (0x2f8e2, (3090, 1)),
    (0x1eaa, (1218, 3)),
    (0x2f8ad, (3037, 1)),
    (0xfa07, (2536, 1)),
    (0x2f97a, (3242, 1)),
    (0x2f966, (3222, 1)),
    (0x1e80, (1138, 2)),
    (0x1d2, (340, 2)),
    (0x1f63, (1668, 3)),
    (0x1fad, (1901, 4)),
    (0xf91e, (2303, 1)),
    (0xfaa0, (2675, 1)),
    (0x2f863, (2963, 1)),
    (0x30dd, (2259, 2)),
    (0x45e, (612, 2)),
    (0x2f91a, (3146, 1)),
    (0x1e05, (860, 2)),
    (0x11a, (154, 2)),
    (0x1f61, (1663, 2)),
    (0x2fa1b, (3403, 1)),
    (0x2f9e0, (3344, 1)),
    (0x13d, (212, 2)),
    (0xfb32, (2755, 2)),
    (0x1ea5, (1203, 3)),
    (0xddd, (787, 3)),
    (0x118, (150, 2)),
    (0x207, (446, 2)),
    (0x1ffa, (2052, 2)),
    (0x2f93f, (3183, 1)),
    (0x2f886, (2998, 1)),
    (0xf9e0, (2497, 1)),
    (0xf970, (2385, 1)),
    (0x2f97e, (3246, 1)),
    (0xf972, (2387, 1)),
    (0x136, (200, 2)),
    (0x1b0a, (832, 2)),
    (0x3073, (2191, 2)),
    (0xf916, (2295, 1)),
    (0x22e2, (2141, 2)),
    (0x2f921, (3153, 1)),
    (0x2260, (2095, 2)),
    (0x1f66, (1677, 3)),
    (0x2f80f, (2879, 1)),
    (0x2001, (2060, 1)),
    (0x1f88, (1763, 3)),
    (0xfaa6, (2681, 1)),
    (0x1fae, (1905, 4)),
    (0xfaa4, (2679, 1)),
    (0x1f3a, (1578, 3)),
    (0xfac1, (2708, 1)),
    (0xfa8f, (2658, 1)),
    (0x95d, (718, 2)),
    (0xf9d1, (2482, 1)),
    (0x1b41, (846, 2)),
    (0xf948, (2345, 1)),
    (0x1e3c, (982, 2)),
    (0xfad9, (2732, 1)),
    (0x400, (582, 2)),
    (0xf96d, (2382, 1)),
    (0x1e7c, (1130, 2)),
    (0x3d3, (578, 2)),
    (0x172, (296, 2)),
    (0x1e1f, (920, 2)),
    (0xfa9f, (2674, 1)),
    (0x226e, (2101, 2)),
    (0x2f822, (2898, 1)),
    (0xf75, (806, 2)),
    (0x2f871, (2977, 1)),
    (0x2f812, (2882, 1)),
    (0x2275, (2111, 2)),
    (0x1f3f, (1593, 3)),
    (0x30d7, (2251, 2)),
    (0xd9, (42, 2)),
    (0x2f8ab, (3035, 1)),
    (0xfa7a, (2637, 1)),
    (0xf915, (2294, 1)),
    (0x1e1d, (915, 3)),
    (0x1eb, (396, 2)),
    (0x2f808, (2872, 1)),
    (0x2f98e, (3262, 1)),
    (0xfa53, (2600, 1)),
    (0xf9a6, (2439, 1)),
    (0x2f80c, (2876, 1)),
    (0x2f8f5, (3109, 1)),
    (0x2fa02, (3378, 1)),
    (0x1e81, (1140, 2)),
    (0xf930, (2321, 1)),
    (0x3060, (2177, 2)),
    (0x1fea, (2024, 2)),
    (0x38a, (542, 2)),
    (0x2f85c, (2956, 1)),
    (0x1fc9, (1958, 2)),
    (0x2f86f, (2975, 1)),
    (0x2f90a, (3130, 1)),
    (0x2f902, (3122, 1)),
    (0x2f835, (2917, 1)),
    (0x14d, (230, 2)),
    (0x1d162, (2839, 3)),
    (0xf923, (2308, 1)),
    (0x2f896, (3014, 1)),
    (0x22d, (509, 3)),
    (0xf9f2, (2515, 1)),
    (0x30c2, (2233, 2)),
    (0x30d4, (2247, 2)),
    (0xf97e, (2399, 1)),
    (0x1fe2, (2005, 3)),
    (0xec, (74, 2)),
    (0x1f49, (1614, 2)),
    (0xfa8d, (2656, 1)),
    (0x2f898, (3016, 1)),
    (0x1eb5, (1251, 3)),
    (0x2f994, (3268, 1)),
    (0x12b, (184, 2)),
    (0x20e, (460, 2)),
    (0x168, (276, 2)),
    (0x1f56, (1644, 3)),
    (0x2f8a0, (3024, 1)),
    (0xfa52, (2599, 1)),
    (0x2f93d, (3181, 1)),
    (0xda, (44, 2)),
    (0x1ec4, (1290, 3)),
    (0x1e95, (1180, 2)),
    (0x1f67, (1680, 3)),
    (0x2f9c1, (3313, 1)),
    (0xf9de, (2495, 1)),
    (0x2f83d, (2925, 1)),
    (0xf9ed, (2510, 1)),
    (0xfabf, (2706, 1)),
    (0x457, (606, 2)),
    (0xfa0d, (2542, 1)),
    (0xfab1, (2692, 1)),
    (0x2f8fa, (3114, 1)),
    (0x1e49, (1008, 2)),
    (0xf91b, (2300, 1)),
    (0x1e50, (1026, 3)),
    (0xf94a, (2347, 1)),
    (0xfa90, (2659, 1)),
    (0x2284, (2121, 2)),
    (0x1ea0, (1192, 2)),
    (0x169, (278, 2)),
    (0xf900, (2273, 1)),
    (0x1eeb, (1395, 3)),
    (0xf9e5, (2502, 1)),
    (0x2f9ea, (3354, 1)),
    (0x2f8ac, (3036, 1)),
    (0x2f8f8, (3112, 1)),
    (0xcc8, (770, 2)),
    (0x2f8f6, (3110, 1)),
    (0xf968, (2377, 1)),
    (0x1e6c, (1094, 2)),
    (0x2f8d8, (3080, 1)),
    (0x1eb6, (1254, 3)),
    (0x2f899, (3017, 1)),
    (0xc3, (6, 2)),
    (0x1b0, (328, 2)),
    (0x1f13, (1483, 3)),
    (0x1e63, (1070, 2)),
    (0x112, (138, 2)),
    (0x2f920, (3152, 1)),
    (0xfa04, (2533, 1)),
    (0x2f8d9, (3081, 1)),
    (0x1e38, (972, 3)),
    (0x1f94, (1807, 4)),
    (0x2f940, (3184, 1)),
    (0x2f97d, (3245, 1)),
    (0x2f84e, (2942, 1)),
    (0xf9a5, (2438, 1)),
    (0x9dc, (728, 2)),
    (0xfc, (100, 2)),
    (0x1eec, (1398, 3)),
    (0x1a0, (322, 2)),
    (0x2f9b4, (3300, 1)),
    (0xbca, (758, 2)),
    (0x2f834, (2916, 1)),
    (0x2fa0b, (3387, 1)),
    (0xfad8, (2731, 1)),
    (0x30c5, (2235, 2)),
    (0xf9f5, (2518, 1)),
    (0x2f84b, (2939, 1)),
    (0x1e5e, (1060, 2)),
    (0x2f8c6, (3062, 1)),
    (0x2f93b, (3179, 1)),
    (0x151, (238, 2)),
    (0x1ffc, (2056, 2)),
    (0xfa39, (2574, 1)),
    (0x1e09, (869, 3)),
    (0xf999, (2426, 1)),
    (0x2f8e6, (3094, 1)),
    (0x2f8ba, (3050, 1)),
    (0x2f876, (2982, 1)),
    (0x123, (172, 2)),
    (0xfb3c, (2773, 2)),
    (0xf996, (2423, 1)),
    (0x1e8d, (1164, 2)),
    (0x10c, (130, 2)),
    (0x2f8ee, (3102, 1)),
    (0xf909, (2282, 1)),
    (0xfa4a, (2591, 1)),
    (0x2f9a9, (3289, 1)),
    (0x2f806, (2870, 1)),
    (0x30d0, (2241, 2)),
    (0x2f9bb, (3307, 1)),
    (0x2f975, (3237, 1)),
    (0x2fa18, (3400, 1)),
    (0x2f989, (3257, 1)),
    (0xf987, (2408, 1)),
    (0x2f80a, (2874, 1)),
    (0xf998, (2425, 1)),
    (0xf979, (2394, 1)),
    (0xf90d, (2286, 1)),
    (0xf922, (2307, 1)),
    (0x1f8c, (1777, 4)),
    (0x1f37, (1571, 3)),
    (0xfb48, (2789, 2)),
    (0x3067, (2183, 2)),
    (0x2f932, (3170, 1)),
    (0x1ed2, (1324, 3)),
    (0xd1, (30, 2)),
    (0x1e28, (938, 2)),
    (0x178, (308, 2)),
    (0x2f9ac, (3292, 1)),
    (0x161, (266, 2)),
    (0xfad0, (2723, 1)),
    (0x401, (584, 2)),
    (0x2241, (2087, 2)),
    (0xf9bd, (2462, 1)),
    (0x2f8f0, (3104, 1)),
    (0x1e45, (1000, 2)),
    (0xf9d9, (2490, 1)),
    (0xfaa9, (2684, 1)),
    (0xfa35, (2570, 1)),
    (0x4d2, (626, 2)),
    (0x1e34, (964, 2)),
    (0xf927, (2312, 1)),
    (0x1ec3, (1287, 3)),
    (0x2f8de, (3086, 1)),
    (0x2f9a2, (3282, 1)),
    (0xf943, (2340, 1)),
    (0x1e8f, (1168, 2)),
    (0xf9d5, (2486, 1)),
    (0xf982, (2403, 1)),
    (0x1f50, (1628, 2)),
    (0x1f92, (1799, 4)),
    (0xf81, (812, 2)),
    (0xfa87, (2650, 1)),
    (0x2f94e, (3198, 1)),
    (0x1fab, (1893, 4)),
    (0xfa3d, (2578, 1)),
    (0x1d9, (358, 3)),
    (0x2f996, (3270, 1)),
    (0x1e8a, (1158, 2)),
    (0xfa58, (2605, 1)),
    (0x1fc1, (1941, 2)),
    (0x2f961, (3217, 1)),
    (0x344, (529, 2)),
    (0x1f34, (1562, 3)),
    (0xf9a8, (2441, 1)),
    (0x163, (270, 2)),
    (0xfb4b, (2795, 2)),
    (0x9cc, (726, 2)),
    (0x1e71, (1104, 2)),
    (0xe2, (56, 2)),
    (0xf9f3, (2516, 1)),
    (0x2f89e, (3022, 1)),
    (0x2f8b3, (3043, 1)),
    (0x1f4d, (1625, 3)),
    (0x1ef9, (1430, 2)),
    (0x2f82f, (2911, 1)),
    (0xfa2e, (2563, 1)),
    (0x2f814, (2884, 1)),
    (0xfad1, (2724, 1)),
    (0x1ec5, (1293, 3)),
    (0x9df, (732, 2)),
    (0x2f8a1, (3025, 1)),
    (0xf939, (2330, 1)),
    (0x228, (496, 2)),
    (0x2f8d2, (3074, 1)),
    (0x1d1bd, (2852, 3)),
    (0x1f86, (1755, 4)),
    (0x2f868, (2968, 1)),
    (0x22a, (500, 3)),
    (0x2f8e3, (3091, 1)),
    (0xa5a, (740, 2)),
    (0x1fc8, (1956, 2)),
    (0xfa22, (2556, 1)),
    (0x1ed, (401, 3)),
    (0xf99f, (2432, 1)),
    (0x2f9b8, (3304, 1)),
    (0x2f9e7, (3351, 1)),
    (0xfabb, (2702, 1)),
    (0x1d6, (349, 3)),
    (0xfb31, (2753, 2)),
    (0x146, (222, 2)),
    (0x1ef2, (1416, 2)),
    (0x1fa1, (1856, 3)),
    (0x1e18, (904, 2)),
    (0xfa9b, (2670, 1)),
    (0xfa80, (2643, 1)),
    (0xfacc, (2719, 1)),
    (0x17a, (312, 2)),
    (0x1e3b, (980, 2)),
    (0x1e74, (1110, 2)),
    (0x2f86b, (2971, 1)),
    (0x1e23, (928, 2)),
    (0x175, (302, 2)),
    (0x1e3e, (986, 2)),
    (0x4db, (636, 2)),
    (0x219b, (2067, 2)),
    (0x1e84, (1146, 2)),
    (0xf9cf, (2480, 1)),
    (0x1e44, (998, 2)),
    (0x1e1a, (908, 2)),
    (0x1f65, (1674, 3)),
    (0xf929, (2314, 1)),
    (0x2247, (2091, 2)),
    (0x4f2, (674, 2)),
    (0x2f87c, (2988, 1)),
    (0x1e2f, (953, 3)),
    (0x2f84a, (2938, 1)),
    (0x2f98c, (3260, 1)),
    (0x2f9a1, (3281, 1)),
    (0x1ec8, (1302, 2)),
    (0x157, (246, 2)),
    (0x2f8bf, (3055, 1)),
    (0xfb41, (2779, 2)),
    (0x4f9, (684, 2)),
    (0x2f995, (3269, 1)),
    (0x12e, (190, 2)),
    (0xf9b6, (2455, 1)),
    (0x1ebc, (1268, 2)),
    (0x1e21, (924, 2)),
    (0x2f841, (2929, 1)),
    (0x116, (146, 2)),
    (0x453, (604, 2)),
    (0x2f992, (3266, 1)),
    (0x1d164, (2845, 3)),
    (0x2f8e1, (3089, 1)),
    (0xfa75, (2632, 1)),
    (0xf902, (2275, 1)),
    (0xf908, (2281, 1)),
    (0x2f817, (2887, 1)),
    (0xf95f, (2368, 1)),
    (0x2f83b, (2923, 1)),
    (0x10f, (136, 2)),
    (0xd3, (34, 2)),
    (0x3069, (2185, 2)),
    (0x1e65, (1075, 3)),
    (0xfb43, (2781, 2)),
    (0x30ba, (2225, 2)),
    (0x1f9b, (1833, 4)),
    (0x16c, (284, 2)),
    (0xc7, (12, 2)),
    (0x2f96b, (3227, 1)),
    (0xf9f8, (2521, 1)),
    (0x158, (248, 2)),
    (0x1d163, (2842, 3)),
    (0x1ea7, (1209, 3)),
    (0x2288, (2125, 2)),
    (0xfacb, (2718, 1)),
    (0xf901, (2274, 1)),
    (0x1f8e, (1785, 4)),
    (0x2fa09, (3385, 1)),
    (0x2f9c8, (3320, 1)),
    (0x1e0e, (880, 2)),
    (0xf949, (2346, 1)),
    (0xe8, (66, 2)),
    (0xfa3c, (2577, 1)),
    (0x2f8ec, (3100, 1)),
    (0x2f8db, (3083, 1)),
    (0x218, (480, 2)),
    (0x3065, (2181, 2)),
    (0xfa7c, (2639, 1)),
    (0x1f82, (1739, 4)),
    (0x1e9b, (1190, 2)),
    (0x209, (450, 2)),
    (0x1fd1, (1974, 2)),
    (0x2f9fa, (3370, 1)),
    (0x30f4, (2261, 2)),
    (0x1f1a, (1496, 3)),
    (0x1e5c, (1054, 3)),
    (0xfa6b, (2624, 1)),
    (0x2f9de, (3342, 1)),
    (0xf9c6, (2471, 1)),
    (0x1da, (361, 3)),
    (0x1f0e, (1470, 3)),
    (0xf97b, (2396, 1)),
    (0xf9c3, (2468, 1)),
    (0x117, (148, 2)),
    (0xf945, (2342, 1)),
    (0x2f9fe, (3374, 1)),
    (0x1ed6, (1336, 3)),
    (0x625, (692, 2)),
    (0x2f9bc, (3308, 1)),
    (0x2249, (2093, 2)),
    (0x1d4, (344, 2)),
    (0x2f9f0, (3360, 1)),
    (0x2f931, (3169, 1)),
    (0x2f92a, (3162, 1)),
    (0x1fdb, (1993, 2)),
    (0xfa7b, (2638, 1)),
    (0x2f882, (2994, 1)),
    (0x2f8ef, (3103, 1)),
    (0xf94f, (2352, 1)),
    (0xf93, (814, 2)),
    (0x2f945, (3189, 1)),
    (0x3056, (2167, 2)),
    (0x959, (710, 2)),
    (0x22ac, (2129, 2)),
    (0x1ff6, (2043, 2)),
    (0x2f801, (2865, 1)),
    (0xf921, (2306, 1)),
    (0xfa41, (2582, 1)),
    (0xf9fe, (2527, 1)),
    (0xfaa3, (2678, 1)),
    (0x2f8b4, (3044, 1)),
    (0x20c, (456, 2)),
    (0xf9c1, (2466, 1)),
    (0x2000, (2059, 1)),
    (0x2f905, (3125, 1)),
    (0x40d, (592, 2)),
    (0x1f79, (1723, 2)),
    (0x2f95b, (3211, 1)),
    (0x1e72, (1106, 2)),
    (0x2f91b, (3147, 1)),
    (0xf9e1, (2498, 1)),
    (0x2f9cb, (3323, 1)),
    (0x2f84d, (2941, 1)),
    (0x2f8a7, (3031, 1)),
    (0x1f05, (1445, 3)),
    (0xfb30, (2751, 2)),
    (0xfa01, (2530, 1)),
    (0xef, (80, 2)),
    (0x1d1c0, (2861, 3)),
    (0x2f819, (2889, 1)),
    (0xca, (18, 2)),
    (0x21ae, (2069, 2)),
    (0x1e2e, (950, 3)),
    (0x30da, (2255, 2)),
    (0x2f880, (2992, 1)),
    (0x2f832, (2914, 1)),
    (0x1db, (364, 3)),
    (0x4e7, (656, 2)),
    (0x2f85b, (2955, 1)),
    (0x1f0, (408, 2)),
    (0x2f9c7, (3319, 1)),
    (0x1e68, (1084, 3)),
    (0xf90c, (2285, 1)),
    (0xfb4d, (2799, 2)),
    (0x2f8f4, (3108, 1)),
    (0x3b0, (565, 3)),
    (0xf90f, (2288, 1)),
    (0x2f89f, (3023, 1)),
    (0x1f9a, (1829, 4)),
    (0xfa88, (2651, 1)),
    (0x1d1bf, (2858, 3)),
    (0x3071, (2189, 2)),
    (0xfa69, (2622, 1)),
    (0x1026, (826, 2)),
    (0xfa1a, (2550, 1)),
    (0x1e03, (856, 2)),
    (0xf928, (2313, 1)),
    (0x2f974, (3236, 1)),
    (0xb4b, (748, 2)),
    (0x1f1d, (1505, 3)),
    (0x165, (274, 2)),
    (0xfad2, (2725, 1)),
    (0xfac9, (2716, 1)),
    (0x2f897, (3015, 1)),
    (0x2fa0f, (3391, 1)),
    (0x2f9ae, (3294, 1)),
    (0xc8, (14, 2)),
    (0x2f8bc, (3052, 1)),
    (0x2f96a, (3226, 1)),
    (0x2f9fb, (3371, 1)),
    (0x2f8cd, (3069, 1)),
    (0xfb1f, (2735, 2)),
    (0x2f94b, (3195, 1)),
    (0x2f811, (2881, 1)),
    (0x95a, (712, 2)),
    (0x30dc, (2257, 2)),
    (0xf78, (810, 2)),
    (0x2f909, (3129, 1)),
    (0x22ae, (2133, 2)),
    (0xf9d8, (2489, 1)),
    (0xfa8e, (2657, 1)),
    (0x1e2a, (942, 2)),
    (0x108, (122, 2)),
    (0x2f9cf, (3327, 1)),
    (0x1e7b, (1127, 3)),
    (0x2f8cb, (3067, 1)),
    (0xfac2, (2709, 1)),
    (0x1d15f, (2831, 2)),
    (0xf924, (2309, 1)),
    (0xf96f, (2384, 1)),
    (0x1ede, (1360, 3)),
    (0x2f987, (3255, 1)),
    (0x1f72, (1709, 2)),
    (0x1ed4, (1330, 3)),
    (0x2f8b2, (3042, 1)),
    (0xfa42, (2583, 1)),
    (0x626, (694, 2)),
    (0xfa9d, (2672, 1)),
    (0x2f9b3, (3299, 1)),
    (0x2f919, (3145, 1)),
    (0xf9d3, (2484, 1)),
    (0xfa71, (2628, 1)),
    (0x1f2f, (1549, 3)),
    (0x1ed9, (1345, 3)),
    (0xfb2f, (2749, 2)),
    (0x2f8dc, (3084, 1)),
    (0x1eb4, (1248, 3)),
    (0xfa25, (2557, 1)),
    (0x2f86d, (2973, 1)),
    (0x4ea, (658, 2)),
    (0x1ecd, (1312, 2)),
    (0x1f01, (1434, 2)),
    (0x2f8d0, (3072, 1)),
    (0x2f93a, (3178, 1)),
    (0x40c, (590, 2)),
    (0xf93a, (2331, 1)),
    (0xf9ff, (2528, 1)),
    (0x1e26, (934, 2)),
    (0x1f08, (1454, 2)),
    (0x1f03, (1439, 3)),
    (0xfad7, (2730, 1)),
    (0x2f884, (2996, 1)),
    (0x2f845, (2933, 1)),
    (0x38e, (546, 2)),
    (0x4d0, (622, 2)),
    (0x30be, (2229, 2)),
    (0x1f32, (1556, 3)),
    (0x2fa08, (3384, 1)),
    (0x17d, (318, 2)),
    (0x1e3d, (984, 2)),
    (0xfa2c, (2561, 1)),
    (0x2f95f, (3215, 1)),
    (0x2f99c, (3276, 1)),
    (0x1f6f, (1702, 3)),
    (0xf937, (2328, 1)),
    (0xfa34, (2569, 1)),
    (0x1f2a, (1534, 3)),
    (0xf69, (802, 2)),
    (0xe0, (52, 2)),
    (0x2f978, (3240, 1)),
    (0x2f97f, (3247, 1)),
    (0x1ef, (406, 2)),
    (0x1b43, (848, 2)),
    (0x155, (242, 2)),
    (0x1fc6, (1951, 2)),
    (0x20a, (452, 2)),
    (0x3077, (2197, 2)),
    (0x1e1b, (910, 2)),
    (0x2f885, (2997, 1)),
    (0x20d, (458, 2)),
    (0xf9c4, (2469, 1)),
    (0xf9a7, (2440, 1)),
    (0xf98e, (2415, 1)),
    (0xf4d, (794, 2)),
    (0x2f805, (2869, 1)),
    (0x159, (250, 2)),
    (0xf4, (88, 2)),
    (0x1f40, (1596, 2)),
    (0xfa00, (2529, 1)),
    (0x2f9f6, (3366, 1)),
    (0xfaae, (2689, 1)),
    (0xfa15, (2545, 1)),
    (0x212b, (2063, 2)),
    (0x2fa06, (3382, 1)),
    (0xd5, (38, 2)),
    (0x1e2d, (948, 2)),
    (0x1f0f, (1473, 3)),
    (0x2271, (2107, 2)),
    (0x1f71, (1707, 2)),
    (0xfa47, (2588, 1)),
    (0xd4b, (779, 2)),
    (0x2f81c, (2892, 1)),
    (0x1fb9, (1932, 2)),
    (0xfa26, (2558, 1)),
    (0x1ff9, (2050, 2)),
    (0x134, (196, 2)),
    (0xf991, (2418, 1)),
    (0x1d160, (2833, 3)),
    (0xf9ac, (2445, 1)),
    (0x2f828, (2904, 1)),
    (0x1fd9, (1989, 2)),
    (0x2f8eb, (3099, 1)),
    (0x2f88b, (3003, 1)),
    (0x2f9b1, (3297, 1)),
    (0xf9bc, (2461, 1)),
    (0xfa2a, (2559, 1)),
    (0x307c, (2203, 2)),
    (0x1f5, (412, 2)),
    (0x1f78, (1721, 2)),
    (0xfa72, (2629, 1)),
    (0x2280, (2117, 2)),
    (0x2f918, (3144, 1)),
    (0xe4, (60, 2)),
    (0x2f802, (2866, 1)),
    (0x2f8d6, (3078, 1)),
    (0x388, (538, 2)),
    (0xfac5, (2712, 1)),
    (0x10d, (132, 2)),
    (0xf958, (2361, 1)),
    (0x1ebe, (1272, 3)),
    (0xf90a, (2283, 1)),
    (0x1f9, (416, 2)),
    (0xb4c, (750, 2)),
    (0x1f57, (1647, 3)),
    (0x1e06, (862, 2)),
    (0x1ed1, (1321, 3)),
    (0x1ff3, (2038, 2)),
    (0x1e2b, (944, 2)),
    (0x1eb8, (1260, 2)),
    (0x2f875, (2981, 1)),
    (0xf942, (2339, 1)),
    (0x1f6a, (1687, 3)),
    (0x1e0, (376, 3)),
    (0x2f94d, (3197, 1)),
    (0xc48, (764, 2)),
    (0x2f810, (2880, 1)),
    (0x1f36, (1568, 3)),
    (0x2f8f3, (3107, 1)),
    (0xfd, (102, 2)),
    (0xf961, (2370, 1)),
    (0x2f873, (2979, 1)),
    (0x37e, (532, 1)),
    (0xf911, (2290, 1)),
    (0xfac6, (2713, 1)),
    (0x2f89d, (3021, 1)),
    (0x2f960, (3216, 1)),
    (0xfa82, (2645, 1)),
    (0x2f96f, (3231, 1)),
    (0x1f33, (1559, 3)),
    (0x1f5f, (1658, 3)),
    (0x1e67, (1081, 3)),
    (0x30d9, (2253, 2)),
    (0xf99a, (2427, 1)),
    (0x22ec, (2149, 2)),
    (0x204, (440, 2)),
    (0xdc, (48, 2)),
    (0x2f925, (3157, 1)),
    (0xfa68, (2621, 1)),
    (0x2f840, (2928, 1)),
    (0x3cd, (574, 2)),
    (0x1e90, (1170, 2)),
    (0x1f75, (1715, 2)),
    (0xddc, (785, 2)),
    (0x2f83f, (2927, 1)),
    (0xf976, (2391, 1)),
    (0x2f86e, (2974, 1)),
    (0x150, (236, 2)),
    (0x1e99, (1188, 2)),
    (0x1d1, (338, 2)),
    (0x2f916, (3142, 1)),
    (0x2f929, (3161, 1)),
    (0x1f04, (1442, 3)),
    (0x1fa7, (1879, 4)),
    (0x1df, (373, 3)),
    (0xfb44, (2783, 2)),
    (0x11c, (158, 2)),
    (0x13a, (206, 2)),
    (0x1f10, (1476, 2)),
    (0x2f8c4, (3060, 1)),
    (0x1e97, (1184, 2)),
    (0xf954, (2357, 1)),
    (0x2f900, (3120, 1)),
    (0x30fe, (2271, 2)),
    (0x30b6, (2221, 2)),
    (0x1f69, (1685, 2)),
    (0xf9ad, (2446, 1)),
    (0x1e77, (1116, 2)),
    (0xfa37, (2572, 1)),
    (0xf934, (2325, 1)),
    (0xfab0, (2691, 1)),
    (0x22ea, (2145, 2)),
    (0x2f89c, (3020, 1)),
    (0x227, (494, 2)),
    (0x1f2b, (1537, 3)),
    (0x2f979, (3241, 1)),
    (0x2f954, (3204, 1)),
    (0x1e1e, (918, 2)),
    (0xf9ae, (2447, 1)),
    (0x2f8e5, (3093, 1)),
    (0x3af, (563, 2)),
    (0x1f4c, (1622, 3)),
    (0xf941, (2338, 1)),
    (0x2f934, (3172, 1)),
    (0xf9a3, (2436, 1)),
    (0x929, (702, 2)),
    (0x2f89b, (3019, 1)),
    (0x2f8b0, (3040, 1)),
    (0x1e83, (1144, 2)),
    (0x2f9ec, (3356, 1)),
    (0x1f60, (1661, 2)),
    (0x623, (688, 2)),
    (0x1e6e, (1098, 2)),
    (0x1112e, (2809, 2)),
    (0xb5d, (754, 2)),
    (0x215, (474, 2)),
    (0x2f9bd, (3309, 1)),
    (0x176, (304, 2)),
    (0x1eab, (1221, 3)),
    (0x2f9e6, (3350, 1)),
    (0x2f864, (2964, 1)),
    (0x1f31, (1554, 2)),
    (0x2f92f, (3167, 1)),
    (0x2f820, (2896, 1)),
    (0x1fda, (1991, 2)),
    (0x2f82c, (2908, 1)),
    (0x1f45, (1609, 3)),
    (0x1f7c, (1729, 2)),
    (0x1e53, (1035, 3)),
    (0x2f972, (3234, 1)),
    (0x2fa1a, (3402, 1)),
    (0xf960, (2369, 1)),
    (0x1d7, (352, 3)),
    (0x1ee8, (1386, 3)),
    (0xcca, (772, 2)),
    (0x1f42, (1600, 3)),
    (0x2f95d, (3213, 1)),
    (0x1ee, (404, 2)),
    (0x2f8d3, (3075, 1)),
    (0x1e4d, (1017, 3)),
    (0xd6, (40, 2)),
    (0x1f96, (1815, 4)),
    (0xf918, (2297, 1)),
    (0xf9af, (2448, 1)),
    (0x2f8fb, (3115, 1)),
    (0x1e60, (1064, 2)),
    (0x1b12, (838, 2)),
    (0xf9fd, (2526, 1)),
    (0x2f9eb, (3355, 1)),
    (0x1e64, (1072, 3)),
    (0xfb2b, (2739, 2)),
    (0x1fe0, (2001, 2)),
    (0x2f915, (3141, 1)),
    (0x2f81b, (2891, 1)),
    (0x1fdd, (1995, 2)),
    (0x2f8b6, (3046, 1)),
    (0x1e89, (1156, 2)),
    (0xf9b9, (2458, 1)),
    (0x1fb3, (1920, 2)),
    (0x1e3, (384, 2)),
    (0x4e3, (648, 2)),
    (0xcf, (28, 2)),
    (0xf1, (82, 2)),
    (0x2f9bf, (3311, 1)),
    (0x2f8c9, (3065, 1)),
    (0x2f8a8, (3032, 1)),
    (0x2f95a, (3210, 1)),
    (0x2f9a8, (3288, 1)),
    (0x1a1, (324, 2)),
    (0xf99e, (2431, 1)),
    (0xfb46, (2785, 2)),
    (0xf9c7, (2472, 1)),
    (0x476, (614, 2)),
    (0x1cd, (330, 2)),
    (0xf9bf, (2464, 1)),
    (0x1ead, (1227, 3)),
    (0x105, (116, 2)),
    (0x2f9a4, (3284, 1)),
    (0x15b, (254, 2)),
    (0xf9c9, (2474, 1)),
    (0x119, (152, 2)),
    (0xf946, (2343, 1)),
    (0x3054, (2165, 2)),
    (0x2fa0c, (3388, 1)),
    (0x1cf, (334, 2)),
    (0xfa7d, (2640, 1)),
    (0xf944, (2341, 1)),
    (0xfa1d, (2553, 1)),
    (0x2f9c2, (3314, 1)),
    (0xf964, (2373, 1)),
    (0x219, (482, 2)),
    (0xf9dd, (2494, 1)),
    (0x1f8b, (1773, 4)),
    (0x2262, (2097, 2)),
    (0xf9b3, (2452, 1)),
    (0xf9a2, (2435, 1)),
    (0x3050, (2161, 2)),
    (0x1e8, (390, 2)),
    (0x30d3, (2245, 2)),
    (0x30c9, (2239, 2)),
    (0xf95a, (2363, 1)),
    (0xf98a, (2411, 1)),
    (0xfa76, (2633, 1)),
    (0x2f816, (2886, 1)),
    (0x1b40, (844, 2)),
    (0x212, (468, 2)),
    (0x1e91, (1172, 2)),
    (0xf9e4, (2501, 1)),
    (0x1f98, (1823, 3)),
    (0xf910, (2289, 1)),
    (0x2f9d8, (3336, 1)),
    (0x2f91d, (3149, 1)),
    (0x1f9c, (1837, 4)),
    (0xdb, (46, 2)),
    (0x232, (522, 2)),
    (0xf995, (2422, 1)),
    (0xf9e2, (2499, 1)),
    (0x1f23, (1515, 3)),
    (0xdde, (790, 2)),
    (0xf9ce, (2479, 1)),
    (0x1eed, (1401, 3)),
    (0x1f0c, (1464, 3)),
    (0x2f91c, (3148, 1)),
    (0x30b0, (2215, 2)),
    (0xf990, (2417, 1)),
    (0x1f68, (1683, 2)),
    (0x1fbc, (1938, 2)),
    (0x2f9b7, (3303, 1)),
    (0xf96b, (2380, 1)),
    (0xfa09, (2538, 1)),
    (0x1ff, (430, 2)),
    (0x2f910, (3136, 1)),
    (0x2f9f4, (3364, 1)),
    (0x2f87f, (2991, 1)),
    (0x1e59, (1048, 2)),
    (0x114be, (2821, 2)),
    (0xf96c, (2381, 1)),
    (0xfac, (822, 2)),
    (0xf913, (2292, 1)),
    (0x2f80d, (2877, 1)),
    (0x2f927, (3159, 1)),
    (0x2f837, (2919, 1)),
    (0x30ac, (2211, 2)),
    (0x1fee, (2032, 2)),
    (0xf9a1, (2434, 1)),
    (0x1e54, (1038, 2)),
    (0x1f6e, (1699, 3)),
    (0xfab7, (2698, 1)),
    (0xfb3b, (2771, 2)),
    (0x2f9f1, (3361, 1)),
    (0xa36, (736, 2)),
    (0x1f89, (1766, 3)),
    (0x1ecc, (1310, 2)),
    (0x2f958, (3208, 1)),
    (0x16b, (282, 2)),
    (0x2f944, (3188, 1)),
    (0x2f8f9, (3113, 1)),
    (0x407, (588, 2)),
    (0x1ef6, (1424, 2)),
    (0x2f9a3, (3283, 1)),
    (0x2f881, (2993, 1)),
    (0x1134c, (2815, 2)),
    (0x2f81a, (2890, 1)),
    (0x2f9dd, (3341, 1)),
    (0xfa64, (2617, 1)),
    (0x2f8af, (3039, 1)),
    (0x2f9ed, (3357, 1)),
    (0xf9ea, (2507, 1)),
    (0x1109c, (2805, 2)),
    (0x14f, (234, 2)),
    (0xf97a, (2395, 1)),
    (0x2f949, (3193, 1)),
    (0xa5b, (742, 2)),
    (0xf936, (2327, 1)),
    (0xa5e, (744, 2)),
    (0x2f89a, (3018, 1)),
    (0x1f4b, (1619, 3)),
    (0xf984, (2405, 1)),
    (0x1e6d, (1096, 2)),
    (0x2f90e, (3134, 1)),
    (0x232a, (2154, 1)),
    (0x2fa0d, (3389, 1)),
    (0xfab2, (2693, 1)),
    (0x450, (600, 2)),
    (0x1f02, (1436, 3)),
    (0xfa32, (2567, 1)),
    (0x1f76, (1717, 2)),
    (0x2f96d, (3229, 1)),
    (0x2f9a7, (3287, 1)),
    (0x1ea3, (1198, 2)),
    (0xf9ba, (2459, 1)),
    (0x1f15, (1489, 3)),
    (0x1faf, (1909, 4)),
    (0x160, (264, 2)),
    (0x2f963, (3219, 1)),
    (0xf925, (2310, 1)),
    (0xf9f6, (2519, 1)),
    (0x30c0, (2231, 2)),
    (0x21e, (488, 2)),
    (0xfa9c, (2671, 1)),
    (0xfb3a, (2769, 2)),
    (0x1fba, (1934, 2)),
    (0x374, (531, 1)),
    (0x2adc, (2155, 2)),
    (0x2f91f, (3151, 1)),
    (0xcc0, (766, 2)),
    (0x1ef3, (1418, 2)),
    (0x1fc3, (1946, 2)),
    (0x2f8bd, (3053, 1)),
    (0x11f, (164, 2)),
    (0xfa7, (820, 2)),
    (0xf9f4, (2517, 1)),
    (0xbcc, (762, 2)),
    (0x2f847, (2935, 1)),
    (0x1f4a, (1616, 3)),
    (0x2f98f, (3263, 1)),
    (0xf96e, (2383, 1)),
    (0xf9e6, (2503, 1)),
    (0xf9e3, (2500, 1)),
    (0x2f844, (2932, 1)),
    (0x2f813, (2883, 1)),
    (0xfab5, (2696, 1)),
    (0x1faa, (1889, 4)),
    (0xc1, (2, 2)),
    (0x1e6b, (1092, 2)),
    (0x1fe5, (2013, 2)),
    (0x2f807, (2871, 1)),
    (0x2f85f, (2959, 1)),
    (0xf93b, (2332, 1)),
    (0x1f8, (414, 2)),
    (0x1e69, (1087, 3)),
    (0x1fe7, (2017, 3)),
    (0x1e57, (1044, 2)),
    (0xcc, (22, 2)),
    (0x2f99b, (3275, 1)),
    (0x4f0, (670, 2)),
    (0x2f8fd, (3117, 1)),
    (0x121, (168, 2)),
    (0xf2, (84, 2)),
    (0xfa9a, (2669, 1)),
    (0x2f9ef, (3359, 1)),
    (0x2f878, (2984, 1)),
    (0xf959, (2362, 1)),
    (0x1134b, (2813, 2)),
    (0x1fbe, (1940, 1)),
    (0xfa56, (2603, 1)),
    (0x1d1be, (2855, 3)),
    (0x2f8bb, (3051, 1)),
    (0x2f8e4, (3092, 1)),
    (0x1e19, (906, 2)),
    (0x2f92d, (3165, 1)),
    (0x1f2c, (1540, 3)),
    (0xe1, (54, 2)),
    (0x2f9b6, (3302, 1)),
    (0xf98d, (2414, 1)),
    (0xf914, (2293, 1)),
    (0xfa19, (2549, 1)),
    (0xface, (2721, 1)),
    (0x15a, (252, 2)),
    (0x2274, (2109, 2)),
    (0xf94c, (2349, 1)),
    (0x1fc4, (1948, 3)),
    (0x115ba, (2823, 2)),
    (0x2f8b8, (3048, 1)),
    (0x2fa01, (3377, 1)),
    (0x2f8ea, (3098, 1)),
    (0x1e98, (1186, 2)),
    (0x2f98b, (3259, 1)),
    (0x2f9dc, (3340, 1)),
    (0x1f99, (1826, 3)),
    (0x1f8a, (1769, 4)),
    (0x1f1c, (1502, 3)),
    (0xfa38, (2573, 1)),
    (0x2f953, (3203, 1)),
    (0x2f8f7, (3111, 1)),
    (0x1f41, (1598, 2)),
    (0x1ec7, (1299, 3)),
    (0x2fa16, (3398, 1)),
    (0x2f859, (2953, 1)),
    (0x2f959, (3209, 1)),
    (0x2f8cf, (3071, 1)),
    (0x14c, (228, 2)),
    (0x2f993, (3267, 1)),
    (0x13e, (214, 2)),
    (0x12a, (182, 2)),
    (0x2f991, (3265, 1)),
    (0x1fca, (1960, 2)),
    (0x389, (540, 2)),
    (0xfa73, (2630, 1)),
    (0x2f9d9, (3337, 1)),
    (0x143, (216, 2)),
    (0x2f893, (3011, 1)),
    (0x2f827, (2903, 1)),
    (0xfa63, (2616, 1)),
    (0x3ac, (557, 2)),
    (0x1f07, (1451, 3)),
    (0x1ebb, (1266, 2)),
    (0x2f943, (3187, 1)),
    (0xfa67, (2620, 1)),
    (0x4d6, (630, 2)),
    (0x1f12, (1480, 3)),
    (0x1f4, (410, 2)),
    (0x1e37, (970, 2)),
    (0x2f90f, (3135, 1)),
    (0x1f18, (1492, 2)),
    (0x477, (616, 2)),
    (0x102, (110, 2)),
    (0x2f800, (2864, 1)),
    (0xfaaf, (2690, 1)),
    (0x6c0, (696, 2)),
    (0xeb, (72, 2)),
    (0x1eda, (1348, 3)),
    (0x1f7d, (1731, 2)),
    (0xa59, (738, 2)),
    (0x2f8f2, (3106, 1)),
    (0x309e, (2209, 2)),
    (0x30d6, (2249, 2)),
    (0x2f92e, (3166, 1)),
    (0xf933, (2324, 1)),
    (0x2f96e, (3230, 1)),
    (0x1e55, (1040, 2)),
    (0x2281, (2119, 2)),
    (0x1e4e, (1020, 3)),
    (0x2f872, (2978, 1)),
    (0x2f9fc, (3372, 1)),
    (0x1d1bc, (2850, 2)),
    (0xfa50, (2597, 1)),
    (0x2f92c, (3164, 1)),
    (0x3070, (2187, 2)),
    (0xf9e9, (2506, 1)),
    (0x2f83c, (2924, 1)),
    (0x2f9f8, (3368, 1)),
    (0x1f52, (1632, 3)),
    (0xfaac, (2687, 1)),
    (0x1e94, (1178, 2)),
    (0xfad6, (2729, 1)),
    (0x1fcb, (1962, 2)),
    (0xfa33, (2568, 1)),
    (0xfa1b, (2551, 1)),
    (0xf9ee, (2511, 1)),
    (0x1e2c, (946, 2)),
    (0x203, (438, 2)),
    (0x2f877, (2983, 1)),
    (0x1ff8, (2048, 2)),
    (0x1e9, (392, 2)),
    (0x1fe, (428, 2)),
    (0x2f96c, (3228, 1)),
    (0x1e51, (1029, 3)),
    (0x4de, (642, 2)),
    (0xf9a4, (2437, 1)),
    (0xfb40, (2777, 2)),
    (0x622, (686, 2)),
    (0x3cc, (572, 2)),
    (0x2f99e, (3278, 1)),
    (0xf92b, (2316, 1)),
    (0x22e1, (2139, 2)),
    (0x174, (300, 2)),
    (0x1e4a, (1010, 2)),
    (0x2f939, (3177, 1)),
    (0x3ce, (576, 2)),
    (0xfaa7, (2682, 1)),
    (0xfa85, (2648, 1)),
    (0xf9e7, (2504, 1)),
    (0x107, (120, 2)),
    (0xfa95, (2664, 1)),
    (0xf973, (2388, 1)),
    (0x2f933, (3171, 1)),
    (0xf9c2, (2467, 1)),
    (0x1ee1, (1369, 3)),
    (0x1d3, (342, 2)),
    (0x2f9d0, (3328, 1)),
    (0xfb2a, (2737, 2)),
    (0xfb, (98, 2)),
    (0x1e4f, (1023, 3)),
    (0x1f26, (1524, 3)),
    (0xdd, (50, 2)),
    (0x226, (492, 2)),
    (0x2f831, (2913, 1)),
    (0x2f9ee, (3358, 1)),
    (0xf955, (2358, 1)),
    (0x16e, (288, 2)),
    (0x2f8a5, (3029, 1)),
    (0x11b, (156, 2)),
    (0x1e76, (1114, 2)),
    (0xd4c, (781, 2)),
    (0x1f3c, (1584, 3)),
    (0x1e0a, (872, 2)),
    (0x1e78, (1118, 3)),
    (0x2f82a, (2906, 1)),
    (0x12d, (188, 2)),
    (0x2f8c5, (3061, 1)),
    (0x1f3e, (1590, 3)),
    (0xf95c, (2365, 1)),
    (0x1f21, (1510, 2)),
    (0x2f9d7, (3335, 1)),
    (0x1f70, (1705, 2)),
    (0x2f914, (3140, 1)),
    (0xfa83, (2646, 1)),
    (0x1ed5, (1333, 3)),
    (0x1ee7, (1384, 2)),
    (0x2278, (2113, 2)),
    (0xf9c0, (2465, 1)),
    (0x1ed7, (1339, 3)),
    (0x2f8ca, (3066, 1)),
    (0x1b3d, (842, 2)),
    (0x2f9ad, (3293, 1)),
    (0x95e, (720, 2)),
    (0x220c, (2081, 2)),
    (0x1fdf, (1999, 2)),
    (0xfa48, (2589, 1)),
    (0x1e04, (858, 2)),
    (0x4d7, (632, 2)),
    (0x216, (476, 2)),
    (0x1e70, (1102, 2)),
    (0x2f856, (2950, 1)),
    (0xe9, (68, 2)),
    (0xf951, (2354, 1)),
    (0x231, (519, 3)),
    (0x1f53, (1635, 3)),
    (0x1e14, (892, 3)),
    (0xf983, (2404, 1)),
    (0xf9d4, (2485, 1)),
    (0x2f973, (3235, 1)),
    (0x2f9df, (3343, 1)),
    (0xf98c, (2413, 1)),
    (0x208, (448, 2)),
    (0x2f895, (3013, 1)),
    (0xfaaa, (2685, 1)),
    (0x45c, (608, 2)),
    (0x30b8, (2223, 2)),
    (0x2244, (2089, 2)),
    (0xff, (104, 2)),
    (0x4d1, (624, 2)),
    (0x2126, (2061, 1)),
    (0x10b, (128, 2)),
    (0x145, (220, 2)),
    (0xf978, (2393, 1)),
    (0x1fcd, (1966, 2)),
    (0x2f912, (3138, 1)),
    (0xfa36, (2571, 1)),
    (0x2f9c0, (3312, 1)),
    (0x4ec, (662, 2)),
    (0x10e, (134, 2)),
    (0x2f98d, (3261, 1)),
    (0x1e5d, (1057, 3)),
    (0xf43, (792, 2)),
    (0x1e29, (940, 2)),
    (0xf93e, (2335, 1)),
    (0x2f9c5, (3317, 1)),
    (0x21ce, (2073, 2)),
    (0x2f87b, (2987, 1)),
    (0x2f9ba, (3306, 1)),
    (0x1ec2, (1284, 3)),
    (0x219a, (2065, 2)),
    (0x1f64, (1671, 3)),
    (0xf906, (2279, 1)),
    (0xf9d7, (2488, 1)),
];

pub(crate) const COMPATIBILITY_DECOMPOSED_CHARS: &[char] = &[
    '\u{0020}',
    '\u{0020}',
    '\u{0308}',
    '\u{0061}',
    '\u{0020}',
    '\u{0304}',
    '\u{0032}',
    '\u{0033}',
    '\u{0020}',
    '\u{0301}',
    '\u{03BC}',
    '\u{0020}',
    '\u{0327}',
    '\u{0031}',
    '\u{006F}',
    '\u{0031}',
    '\u{2044}',
    '\u{0034}',
    '\u{0031}',
    '\u{2044}',
    '\u{0032}',
    '\u{0033}',
    '\u{2044}',
    '\u{0034}',
    '\u{0049}',
    '\u{004A}',
    '\u{0069}',
    '\u{006A}',
    '\u{004C}',
    '\u{00B7}',
    '\u{006C}',
    '\u{00B7}',
    '\u{02BC}',
    '\u{006E}',
    '\u{0073}',
    '\u{0044}',
    '\u{005A}',
    '\u{030C}',
    '\u{0044}',
    '\u{007A}',
    '\u{030C}',
    '\u{0064}',
    '\u{007A}',
    '\u{030C}',
    '\u{004C}',
    '\u{004A}',
    '\u{004C}',
    '\u{006A}',
    '\u{006C}',
    '\u{006A}',
    '\u{004E}',
    '\u{004A}',
    '\u{004E}',
    '\u{006A}',
    '\u{006E}',
    '\u{006A}',
    '\u{0044}',
    '\u{005A}',
    '\u{0044}',
    '\u{007A}',
    '\u{0064}',
    '\u{007A}',
    '\u{0068}',
    '\u{0266}',
    '\u{006A}',
    '\u{0072}',
    '\u{0279}',
    '\u{027B}',
    '\u{0281}',
    '\u{0077}',
    '\u{0079}',
    '\u{0020}',
    '\u{0306}',
    '\u{0020}',
    '\u{0307}',
    '\u{0020}',
    '\u{030A}',
    '\u{0020}',
    '\u{0328}',
    '\u{0020}',
    '\u{0303}',
    '\u{0020}',
    '\u{030B}',
    '\u{0263}',
    '\u{006C}',
    '\u{0073}',
    '\u{0078}',
    '\u{0295}',
    '\u{0020}',
    '\u{0345}',
    '\u{0020}',
    '\u{0301}',
    '\u{0020}',
    '\u{0308}',
    '\u{0301}',
    '\u{03B2}',
    '\u{03B8}',
    '\u{03A5}',
    '\u{03A5}',
    '\u{0301}',
    '\u{03A5}',
    '\u{0308}',
    '\u{03C6}',
    '\u{03C0}',
    '\u{03BA}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{0398}',
    '\u{03B5}',
    '\u{03A3}',
    '\u{0565}',
    '\u{0582}',
    '\u{0627}',
    '\u{0674}',
    '\u{0648}',
    '\u{0674}',
    '\u{06C7}',
    '\u{0674}',
    '\u{064A}',
    '\u{0674}',
    '\u{0E4D}',
    '\u{0E32}',
    '\u{0ECD}',
    '\u{0EB2}',
    '\u{0EAB}',
    '\u{0E99}',
    '\u{0EAB}',
    '\u{0EA1}',
    '\u{0F0B}',
    '\u{0FB2}',
    '\u{0F71}',
    '\u{0F80}',
    '\u{0FB3}',
    '\u{0F71}',
    '\u{0F80}',
    '\u{10DC}',
    '\u{0041}',
    '\u{00C6}',
    '\u{0042}',
    '\u{0044}',
    '\u{0045}',
    '\u{018E}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0222}',
    '\u{0050}',
    '\u{0052}',
    '\u{0054}',
    '\u{0055}',
    '\u{0057}',
    '\u{0061}',
    '\u{0250}',
    '\u{0251}',
    '\u{1D02}',
    '\u{0062}',
    '\u{0064}',
    '\u{0065}',
    '\u{0259}',
    '\u{025B}',
    '\u{025C}',
    '\u{0067}',
    '\u{006B}',
    '\u{006D}',
    '\u{014B}',
    '\u{006F}',
    '\u{0254}',
    '\u{1D16}',
    '\u{1D17}',
    '\u{0070}',
    '\u{0074}',
    '\u{0075}',
    '\u{1D1D}',
    '\u{026F}',
    '\u{0076}',
    '\u{1D25}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{0069}',
    '\u{0072}',
    '\u{0075}',
    '\u{0076}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03C1}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{043D}',
    '\u{0252}',
    '\u{0063}',
    '\u{0255}',
    '\u{00F0}',
    '\u{025C}',
    '\u{0066}',
    '\u{025F}',
    '\u{0261}',
    '\u{0265}',
    '\u{0268}',
    '\u{0269}',
    '\u{026A}',
    '\u{1D7B}',
    '\u{029D}',
    '\u{026D}',
    '\u{1D85}',
    '\u{029F}',
    '\u{0271}',
    '\u{0270}',
    '\u{0272}',
    '\u{0273}',
    '\u{0274}',
    '\u{0275}',
    '\u{0278}',
    '\u{0282}',
    '\u{0283}',
    '\u{01AB}',
    '\u{0289}',
    '\u{028A}',
    '\u{1D1C}',
    '\u{028B}',
    '\u{028C}',
    '\u{007A}',
    '\u{0290}',
    '\u{0291}',
    '\u{0292}',
    '\u{03B8}',
    '\u{0061}',
    '\u{02BE}',
    '\u{0073}',
    '\u{0307}',
    '\u{0020}',
    '\u{0313}',
    '\u{0020}',
    '\u{0313}',
    '\u{0020}',
    '\u{0342}',
    '\u{0020}',
    '\u{0308}',
    '\u{0342}',
    '\u{0020}',
    '\u{0313}',
    '\u{0300}',
    '\u{0020}',
    '\u{0313}',
    '\u{0301}',
    '\u{0020}',
    '\u{0313}',
    '\u{0342}',
    '\u{0020}',
    '\u{0314}',
    '\u{0300}',
    '\u{0020}',
    '\u{0314}',
    '\u{0301}',
    '\u{0020}',
    '\u{0314}',
    '\u{0342}',
    '\u{0020}',
    '\u{0308}',
    '\u{0300}',
    '\u{0020}',
    '\u{0308}',
    '\u{0301}',
    '\u{0020}',
    '\u{0301}',
    '\u{0020}',
    '\u{0314}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{2010}',
    '\u{0020}',
    '\u{0333}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{0020}',
    '\u{2032}',
    '\u{2032}',
    '\u{2032}',
    '\u{2032}',
    '\u{2032}',
    '\u{2035}',
    '\u{2035}',
    '\u{2035}',
    '\u{2035}',
    '\u{2035}',
    '\u{0021}',
    '\u{0021}',
    '\u{0020}',
    '\u{0305}',
    '\u{003F}',
    '\u{003F}',
    '\u{003F}',
    '\u{0021}',
    '\u{0021}',
    '\u{003F}',
    '\u{2032}',
    '\u{2032}',
    '\u{2032}',
    '\u{2032}',
    '\u{0020}',
    '\u{0030}',
    '\u{0069}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{002B}',
    '\u{2212}',
    '\u{003D}',
    '\u{0028}',
    '\u{0029}',
    '\u{006E}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{002B}',
    '\u{2212}',
    '\u{003D}',
    '\u{0028}',
    '\u{0029}',
    '\u{0061}',
    '\u{0065}',
    '\u{006F}',
    '\u{0078}',
    '\u{0259}',
    '\u{0068}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{0070}',
    '\u{0073}',
    '\u{0074}',
    '\u{0052}',
    '\u{0073}',
    '\u{0061}',
    '\u{002F}',
    '\u{0063}',
    '\u{0061}',
    '\u{002F}',
    '\u{0073}',
    '\u{0043}',
    '\u{00B0}',
    '\u{0043}',
    '\u{0063}',
    '\u{002F}',
    '\u{006F}',
    '\u{0063}',
    '\u{002F}',
    '\u{0075}',
    '\u{0190}',
    '\u{00B0}',
    '\u{0046}',
    '\u{0067}',
    '\u{0048}',
    '\u{0048}',
    '\u{0048}',
    '\u{0068}',
    '\u{0127}',
    '\u{0049}',
    '\u{0049}',
    '\u{004C}',
    '\u{006C}',
    '\u{004E}',
    '\u{004E}',
    '\u{006F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0052}',
    '\u{0052}',
    '\u{0053}',
    '\u{004D}',
    '\u{0054}',
    '\u{0045}',
    '\u{004C}',
    '\u{0054}',
    '\u{004D}',
    '\u{005A}',
    '\u{005A}',
    '\u{0042}',
    '\u{0043}',
    '\u{0065}',
    '\u{0045}',
    '\u{0046}',
    '\u{004D}',
    '\u{006F}',
    '\u{05D0}',
    '\u{05D1}',
    '\u{05D2}',
    '\u{05D3}',
    '\u{0069}',
    '\u{0046}',
    '\u{0041}',
    '\u{0058}',
    '\u{03C0}',
    '\u{03B3}',
    '\u{0393}',
    '\u{03A0}',
    '\u{2211}',
    '\u{0044}',
    '\u{0064}',
    '\u{0065}',
    '\u{0069}',
    '\u{006A}',
    '\u{0031}',
    '\u{2044}',
    '\u{0037}',
    '\u{0031}',
    '\u{2044}',
    '\u{0039}',
    '\u{0031}',
    '\u{2044}',
    '\u{0031}',
    '\u{0030}',
    '\u{0031}',
    '\u{2044}',
    '\u{0033}',
    '\u{0032}',
    '\u{2044}',
    '\u{0033}',
    '\u{0031}',
    '\u{2044}',
    '\u{0035}',
    '\u{0032}',
    '\u{2044}',
    '\u{0035}',
    '\u{0033}',
    '\u{2044}',
    '\u{0035}',
    '\u{0034}',
    '\u{2044}',
    '\u{0035}',
    '\u{0031}',
    '\u{2044}',
    '\u{0036}',
    '\u{0035}',
    '\u{2044}',
    '\u{0036}',
    '\u{0031}',
    '\u{2044}',
    '\u{0038}',
    '\u{0033}',
    '\u{2044}',
    '\u{0038}',
    '\u{0035}',
    '\u{2044}',
    '\u{0038}',
    '\u{0037}',
    '\u{2044}',
    '\u{0038}',
    '\u{0031}',
    '\u{2044}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0056}',
    '\u{0056}',
    '\u{0056}',
    '\u{0049}',
    '\u{0056}',
    '\u{0049}',
    '\u{0049}',
    '\u{0056}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0058}',
    '\u{0058}',
    '\u{0058}',
    '\u{0049}',
    '\u{0058}',
    '\u{0049}',
    '\u{0049}',
    '\u{004C}',
    '\u{0043}',
    '\u{0044}',
    '\u{004D}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0076}',
    '\u{0076}',
    '\u{0076}',
    '\u{0069}',
    '\u{0076}',
    '\u{0069}',
    '\u{0069}',
    '\u{0076}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0078}',
    '\u{0078}',
    '\u{0078}',
    '\u{0069}',
    '\u{0078}',
    '\u{0069}',
    '\u{0069}',
    '\u{006C}',
    '\u{0063}',
    '\u{0064}',
    '\u{006D}',
    '\u{0030}',
    '\u{2044}',
    '\u{0033}',
    '\u{222B}',
    '\u{222B}',
    '\u{222B}',
    '\u{222B}',
    '\u{222B}',
    '\u{222E}',
    '\u{222E}',
    '\u{222E}',
    '\u{222E}',
    '\u{222E}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0031}',
    '\u{0030}',
    '\u{0031}',
    '\u{0031}',
    '\u{0031}',
    '\u{0032}',
    '\u{0031}',
    '\u{0033}',
    '\u{0031}',
    '\u{0034}',
    '\u{0031}',
    '\u{0035}',
    '\u{0031}',
    '\u{0036}',
    '\u{0031}',
    '\u{0037}',
    '\u{0031}',
    '\u{0038}',
    '\u{0031}',
    '\u{0039}',
    '\u{0032}',
    '\u{0030}',
    '\u{0028}',
    '\u{0031}',
    '\u{0029}',
    '\u{0028}',
    '\u{0032}',
    '\u{0029}',
    '\u{0028}',
    '\u{0033}',
    '\u{0029}',
    '\u{0028}',
    '\u{0034}',
    '\u{0029}',
    '\u{0028}',
    '\u{0035}',
    '\u{0029}',
    '\u{0028}',
    '\u{0036}',
    '\u{0029}',
    '\u{0028}',
    '\u{0037}',
    '\u{0029}',
    '\u{0028}',
    '\u{0038}',
    '\u{0029}',
    '\u{0028}',
    '\u{0039}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0030}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0031}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0032}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0033}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0034}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0035}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0036}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0037}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0038}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0039}',
    '\u{0029}',
    '\u{0028}',
    '\u{0032}',
    '\u{0030}',
    '\u{0029}',
    '\u{0031}',
    '\u{002E}',
    '\u{0032}',
    '\u{002E}',
    '\u{0033}',
    '\u{002E}',
    '\u{0034}',
    '\u{002E}',
    '\u{0035}',
    '\u{002E}',
    '\u{0036}',
    '\u{002E}',
    '\u{0037}',
    '\u{002E}',
    '\u{0038}',
    '\u{002E}',
    '\u{0039}',
    '\u{002E}',
    '\u{0031}',
    '\u{0030}',
    '\u{002E}',
    '\u{0031}',
    '\u{0031}',
    '\u{002E}',
    '\u{0031}',
    '\u{0032}',
    '\u{002E}',
    '\u{0031}',
    '\u{0033}',
    '\u{002E}',
    '\u{0031}',
    '\u{0034}',
    '\u{002E}',
    '\u{0031}',
    '\u{0035}',
    '\u{002E}',
    '\u{0031}',
    '\u{0036}',
    '\u{002E}',
    '\u{0031}',
    '\u{0037}',
    '\u{002E}',
    '\u{0031}',
    '\u{0038}',
    '\u{002E}',
    '\u{0031}',
    '\u{0039}',
    '\u{002E}',
    '\u{0032}',
    '\u{0030}',
    '\u{002E}',
    '\u{0028}',
    '\u{0061}',
    '\u{0029}',
    '\u{0028}',
    '\u{0062}',
    '\u{0029}',
    '\u{0028}',
    '\u{0063}',
    '\u{0029}',
    '\u{0028}',
    '\u{0064}',
    '\u{0029}',
    '\u{0028}',
    '\u{0065}',
    '\u{0029}',
    '\u{0028}',
    '\u{0066}',
    '\u{0029}',
    '\u{0028}',
    '\u{0067}',
    '\u{0029}',
    '\u{0028}',
    '\u{0068}',
    '\u{0029}',
    '\u{0028}',
    '\u{0069}',
    '\u{0029}',
    '\u{0028}',
    '\u{006A}',
    '\u{0029}',
    '\u{0028}',
    '\u{006B}',
    '\u{0029}',
    '\u{0028}',
    '\u{006C}',
    '\u{0029}',
    '\u{0028}',
    '\u{006D}',
    '\u{0029}',
    '\u{0028}',
    '\u{006E}',
    '\u{0029}',
    '\u{0028}',
    '\u{006F}',
    '\u{0029}',
    '\u{0028}',
    '\u{0070}',
    '\u{0029}',
    '\u{0028}',
    '\u{0071}',
    '\u{0029}',
    '\u{0028}',
    '\u{0072}',
    '\u{0029}',
    '\u{0028}',
    '\u{0073}',
    '\u{0029}',
    '\u{0028}',
    '\u{0074}',
    '\u{0029}',
    '\u{0028}',
    '\u{0075}',
    '\u{0029}',
    '\u{0028}',
    '\u{0076}',
    '\u{0029}',
    '\u{0028}',
    '\u{0077}',
    '\u{0029}',
    '\u{0028}',
    '\u{0078}',
    '\u{0029}',
    '\u{0028}',
    '\u{0079}',
    '\u{0029}',
    '\u{0028}',
    '\u{007A}',
    '\u{0029}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0030}',
    '\u{222B}',
    '\u{222B}',
    '\u{222B}',
    '\u{222B}',
    '\u{003A}',
    '\u{003A}',
    '\u{003D}',
    '\u{003D}',
    '\u{003D}',
    '\u{003D}',
    '\u{003D}',
    '\u{003D}',
    '\u{006A}',
    '\u{0056}',
    '\u{2D61}',
    '\u{6BCD}',
    '\u{9F9F}',
    '\u{4E00}',
    '\u{4E28}',
    '\u{4E36}',
    '\u{4E3F}',
    '\u{4E59}',
    '\u{4E85}',
    '\u{4E8C}',
    '\u{4EA0}',
    '\u{4EBA}',
    '\u{513F}',
    '\u{5165}',
    '\u{516B}',
    '\u{5182}',
    '\u{5196}',
    '\u{51AB}',
    '\u{51E0}',
    '\u{51F5}',
    '\u{5200}',
    '\u{529B}',
    '\u{52F9}',
    '\u{5315}',
    '\u{531A}',
    '\u{5338}',
    '\u{5341}',
    '\u{535C}',
    '\u{5369}',
    '\u{5382}',
    '\u{53B6}',
    '\u{53C8}',
    '\u{53E3}',
    '\u{56D7}',
    '\u{571F}',
    '\u{58EB}',
    '\u{5902}',
    '\u{590A}',
    '\u{5915}',
    '\u{5927}',
    '\u{5973}',
    '\u{5B50}',
    '\u{5B80}',
    '\u{5BF8}',
    '\u{5C0F}',
    '\u{5C22}',
    '\u{5C38}',
    '\u{5C6E}',
    '\u{5C71}',
    '\u{5DDB}',
    '\u{5DE5}',
    '\u{5DF1}',
    '\u{5DFE}',
    '\u{5E72}',
    '\u{5E7A}',
    '\u{5E7F}',
    '\u{5EF4}',
    '\u{5EFE}',
    '\u{5F0B}',
    '\u{5F13}',
    '\u{5F50}',
    '\u{5F61}',
    '\u{5F73}',
    '\u{5FC3}',
    '\u{6208}',
    '\u{6236}',
    '\u{624B}',
    '\u{652F}',
    '\u{6534}',
    '\u{6587}',
    '\u{6597}',
    '\u{65A4}',
    '\u{65B9}',
    '\u{65E0}',
    '\u{65E5}',
    '\u{66F0}',
    '\u{6708}',
    '\u{6728}',
    '\u{6B20}',
    '\u{6B62}',
    '\u{6B79}',
    '\u{6BB3}',
    '\u{6BCB}',
    '\u{6BD4}',
    '\u{6BDB}',
    '\u{6C0F}',
    '\u{6C14}',
    '\u{6C34}',
    '\u{706B}',
    '\u{722A}',
    '\u{7236}',
    '\u{723B}',
    '\u{723F}',
    '\u{7247}',
    '\u{7259}',
    '\u{725B}',
    '\u{72AC}',
    '\u{7384}',
    '\u{7389}',
    '\u{74DC}',
    '\u{74E6}',
    '\u{7518}',
    '\u{751F}',
    '\u{7528}',
    '\u{7530}',
    '\u{758B}',
    '\u{7592}',
    '\u{7676}',
    '\u{767D}',
    '\u{76AE}',
    '\u{76BF}',
    '\u{76EE}',
    '\u{77DB}',
    '\u{77E2}',
    '\u{77F3}',
    '\u{793A}',
    '\u{79B8}',
    '\u{79BE}',
    '\u{7A74}',
    '\u{7ACB}',
    '\u{7AF9}',
    '\u{7C73}',
    '\u{7CF8}',
    '\u{7F36}',
    '\u{7F51}',
    '\u{7F8A}',
    '\u{7FBD}',
    '\u{8001}',
    '\u{800C}',
    '\u{8012}',
    '\u{8033}',
    '\u{807F}',
    '\u{8089}',
    '\u{81E3}',
    '\u{81EA}',
    '\u{81F3}',
    '\u{81FC}',
    '\u{820C}',
    '\u{821B}',
    '\u{821F}',
    '\u{826E}',
    '\u{8272}',
    '\u{8278}',
    '\u{864D}',
    '\u{866B}',
    '\u{8840}',
    '\u{884C}',
    '\u{8863}',
    '\u{897E}',
    '\u{898B}',
    '\u{89D2}',
    '\u{8A00}',
    '\u{8C37}',
    '\u{8C46}',
    '\u{8C55}',
    '\u{8C78}',
    '\u{8C9D}',
    '\u{8D64}',
    '\u{8D70}',
    '\u{8DB3}',
    '\u{8EAB}',
    '\u{8ECA}',
    '\u{8F9B}',
    '\u{8FB0}',
    '\u{8FB5}',
    '\u{9091}',
    '\u{9149}',
    '\u{91C6}',
    '\u{91CC}',
    '\u{91D1}',
    '\u{9577}',
    '\u{9580}',
    '\u{961C}',
    '\u{96B6}',
    '\u{96B9}',
    '\u{96E8}',
    '\u{9751}',
    '\u{975E}',
    '\u{9762}',
    '\u{9769}',
    '\u{97CB}',
    '\u{97ED}',
    '\u{97F3}',
    '\u{9801}',
    '\u{98A8}',
    '\u{98DB}',
    '\u{98DF}',
    '\u{9996}',
    '\u{9999}',
    '\u{99AC}',
    '\u{9AA8}',
    '\u{9AD8}',
    '\u{9ADF}',
    '\u{9B25}',
    '\u{9B2F}',
    '\u{9B32}',
    '\u{9B3C}',
    '\u{9B5A}',
    '\u{9CE5}',
    '\u{9E75}',
    '\u{9E7F}',
    '\u{9EA5}',
    '\u{9EBB}',
    '\u{9EC3}',
    '\u{9ECD}',
    '\u{9ED1}',
    '\u{9EF9}',
    '\u{9EFD}',
    '\u{9F0E}',
    '\u{9F13}',
    '\u{9F20}',
    '\u{9F3B}',
    '\u{9F4A}',
    '\u{9F52}',
    '\u{9F8D}',
    '\u{9F9C}',
    '\u{9FA0}',
    '\u{0020}',
    '\u{3012}',
    '\u{5341}',
    '\u{5344}',
    '\u{5345}',
    '\u{0020}',
    '\u{3099}',
    '\u{0020}',
    '\u{309A}',
    '\u{3088}',
    '\u{308A}',
    '\u{30B3}',
    '\u{30C8}',
    '\u{1100}',
    '\u{1101}',
    '\u{11AA}',
    '\u{1102}',
    '\u{11AC}',
    '\u{11AD}',
    '\u{1103}',
    '\u{1104}',
    '\u{1105}',
    '\u{11B0}',
    '\u{11B1}',
    '\u{11B2}',
    '\u{11B3}',
    '\u{11B4}',
    '\u{11B5}',
    '\u{111A}',
    '\u{1106}',
    '\u{1107}',
    '\u{1108}',
    '\u{1121}',
    '\u{1109}',
    '\u{110A}',
    '\u{110B}',
    '\u{110C}',
    '\u{110D}',
    '\u{110E}',
    '\u{110F}',
    '\u{1110}',
    '\u{1111}',
    '\u{1112}',
    '\u{1161}',
    '\u{1162}',
    '\u{1163}',
    '\u{1164}',
    '\u{1165}',
    '\u{1166}',
    '\u{1167}',
    '\u{1168}',
    '\u{1169}',
    '\u{116A}',
    '\u{116B}',
    '\u{116C}',
    '\u{116D}',
    '\u{116E}',
    '\u{116F}',
    '\u{1170}',
    '\u{1171}',
    '\u{1172}',
    '\u{1173}',
    '\u{1174}',
    '\u{1175}',
    '\u{1160}',
    '\u{1114}',
    '\u{1115}',
    '\u{11C7}',
    '\u{11C8}',
    '\u{11CC}',
    '\u{11CE}',
    '\u{11D3}',
    '\u{11D7}',
    '\u{11D9}',
    '\u{111C}',
    '\u{11DD}',
    '\u{11DF}',
    '\u{111D}',
    '\u{111E}',
    '\u{1120}',
    '\u{1122}',
    '\u{1123}',
    '\u{1127}',
    '\u{1129}',
    '\u{112B}',
    '\u{112C}',
    '\u{112D}',
    '\u{112E}',
    '\u{112F}',
    '\u{1132}',
    '\u{1136}',
    '\u{1140}',
    '\u{1147}',
    '\u{114C}',
    '\u{11F1}',
    '\u{11F2}',
    '\u{1157}',
    '\u{1158}',
    '\u{1159}',
    '\u{1184}',
    '\u{1185}',
    '\u{1188}',
    '\u{1191}',
    '\u{1192}',
    '\u{1194}',
    '\u{119E}',
    '\u{11A1}',
    '\u{4E00}',
    '\u{4E8C}',
    '\u{4E09}',
    '\u{56DB}',
    '\u{4E0A}',
    '\u{4E2D}',
    '\u{4E0B}',
    '\u{7532}',
    '\u{4E59}',
    '\u{4E19}',
    '\u{4E01}',
    '\u{5929}',
    '\u{5730}',
    '\u{4EBA}',
    '\u{0028}',
    '\u{1100}',
    '\u{0029}',
    '\u{0028}',
    '\u{1102}',
    '\u{0029}',
    '\u{0028}',
    '\u{1103}',
    '\u{0029}',
    '\u{0028}',
    '\u{1105}',
    '\u{0029}',
    '\u{0028}',
    '\u{1106}',
    '\u{0029}',
    '\u{0028}',
    '\u{1107}',
    '\u{0029}',
    '\u{0028}',
    '\u{1109}',
    '\u{0029}',
    '\u{0028}',
    '\u{110B}',
    '\u{0029}',
    '\u{0028}',
    '\u{110C}',
    '\u{0029}',
    '\u{0028}',
    '\u{110E}',
    '\u{0029}',
    '\u{0028}',
    '\u{110F}',
    '\u{0029}',
    '\u{0028}',
    '\u{1110}',
    '\u{0029}',
    '\u{0028}',
    '\u{1111}',
    '\u{0029}',
    '\u{0028}',
    '\u{1112}',
    '\u{0029}',
    '\u{0028}',
    '\u{1100}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1102}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1103}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1105}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1106}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1107}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1109}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{110B}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{110C}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{110E}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{110F}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1110}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1111}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1112}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{110C}',
    '\u{116E}',
    '\u{0029}',
    '\u{0028}',
    '\u{110B}',
    '\u{1169}',
    '\u{110C}',
    '\u{1165}',
    '\u{11AB}',
    '\u{0029}',
    '\u{0028}',
    '\u{110B}',
    '\u{1169}',
    '\u{1112}',
    '\u{116E}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E00}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E8C}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E09}',
    '\u{0029}',
    '\u{0028}',
    '\u{56DB}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E94}',
    '\u{0029}',
    '\u{0028}',
    '\u{516D}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E03}',
    '\u{0029}',
    '\u{0028}',
    '\u{516B}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E5D}',
    '\u{0029}',
    '\u{0028}',
    '\u{5341}',
    '\u{0029}',
    '\u{0028}',
    '\u{6708}',
    '\u{0029}',
    '\u{0028}',
    '\u{706B}',
    '\u{0029}',
    '\u{0028}',
    '\u{6C34}',
    '\u{0029}',
    '\u{0028}',
    '\u{6728}',
    '\u{0029}',
    '\u{0028}',
    '\u{91D1}',
    '\u{0029}',
    '\u{0028}',
    '\u{571F}',
    '\u{0029}',
    '\u{0028}',
    '\u{65E5}',
    '\u{0029}',
    '\u{0028}',
    '\u{682A}',
    '\u{0029}',
    '\u{0028}',
    '\u{6709}',
    '\u{0029}',
    '\u{0028}',
    '\u{793E}',
    '\u{0029}',
    '\u{0028}',
    '\u{540D}',
    '\u{0029}',
    '\u{0028}',
    '\u{7279}',
    '\u{0029}',
    '\u{0028}',
    '\u{8CA1}',
    '\u{0029}',
    '\u{0028}',
    '\u{795D}',
    '\u{0029}',
    '\u{0028}',
    '\u{52B4}',
    '\u{0029}',
    '\u{0028}',
    '\u{4EE3}',
    '\u{0029}',
    '\u{0028}',
    '\u{547C}',
    '\u{0029}',
    '\u{0028}',
    '\u{5B66}',
    '\u{0029}',
    '\u{0028}',
    '\u{76E3}',
    '\u{0029}',
    '\u{0028}',
    '\u{4F01}',
    '\u{0029}',
    '\u{0028}',
    '\u{8CC7}',
    '\u{0029}',
    '\u{0028}',
    '\u{5354}',
    '\u{0029}',
    '\u{0028}',
    '\u{796D}',
    '\u{0029}',
    '\u{0028}',
    '\u{4F11}',
    '\u{0029}',
    '\u{0028}',
    '\u{81EA}',
    '\u{0029}',
    '\u{0028}',
    '\u{81F3}',
    '\u{0029}',
    '\u{554F}',
    '\u{5E7C}',
    '\u{6587}',
    '\u{7B8F}',
    '\u{0050}',
    '\u{0054}',
    '\u{0045}',
    '\u{0032}',
    '\u{0031}',
    '\u{0032}',
    '\u{0032}',
    '\u{0032}',
    '\u{0033}',
    '\u{0032}',
    '\u{0034}',
    '\u{0032}',
    '\u{0035}',
    '\u{0032}',
    '\u{0036}',
    '\u{0032}',
    '\u{0037}',
    '\u{0032}',
    '\u{0038}',
    '\u{0032}',
    '\u{0039}',
    '\u{0033}',
    '\u{0030}',
    '\u{0033}',
    '\u{0031}',
    '\u{0033}',
    '\u{0032}',
    '\u{0033}',
    '\u{0033}',
    '\u{0033}',
    '\u{0034}',
    '\u{0033}',
    '\u{0035}',
    '\u{1100}',
    '\u{1102}',
    '\u{1103}',
    '\u{1105}',
    '\u{1106}',
    '\u{1107}',
    '\u{1109}',
    '\u{110B}',
    '\u{110C}',
    '\u{110E}',
    '\u{110F}',
    '\u{1110}',
    '\u{1111}',
    '\u{1112}',
    '\u{1100}',
    '\u{1161}',
    '\u{1102}',
    '\u{1161}',
    '\u{1103}',
    '\u{1161}',
    '\u{1105}',
    '\u{1161}',
    '\u{1106}',
    '\u{1161}',
    '\u{1107}',
    '\u{1161}',
    '\u{1109}',
    '\u{1161}',
    '\u{110B}',
    '\u{1161}',
    '\u{110C}',
    '\u{1161}',
    '\u{110E}',
    '\u{1161}',
    '\u{110F}',
    '\u{1161}',
    '\u{1110}',
    '\u{1161}',
    '\u{1111}',
    '\u{1161}',
    '\u{1112}',
    '\u{1161}',
    '\u{110E}',
    '\u{1161}',
    '\u{11B7}',
    '\u{1100}',
    '\u{1169}',
    '\u{110C}',
    '\u{116E}',
    '\u{110B}',
    '\u{1174}',
    '\u{110B}',
    '\u{116E}',
    '\u{4E00}',
    '\u{4E8C}',
    '\u{4E09}',
    '\u{56DB}',
    '\u{4E94}',
    '\u{516D}',
    '\u{4E03}',
    '\u{516B}',
    '\u{4E5D}',
    '\u{5341}',
    '\u{6708}',
    '\u{706B}',
    '\u{6C34}',
    '\u{6728}',
    '\u{91D1}',
    '\u{571F}',
    '\u{65E5}',
    '\u{682A}',
    '\u{6709}',
    '\u{793E}',
    '\u{540D}',
    '\u{7279}',
    '\u{8CA1}',
    '\u{795D}',
    '\u{52B4}',
    '\u{79D8}',
    '\u{7537}',
    '\u{5973}',
    '\u{9069}',
    '\u{512A}',
    '\u{5370}',
    '\u{6CE8}',
    '\u{9805}',
    '\u{4F11}',
    '\u{5199}',
    '\u{6B63}',
    '\u{4E0A}',
    '\u{4E2D}',
    '\u{4E0B}',
    '\u{5DE6}',
    '\u{53F3}',
    '\u{533B}',
    '\u{5B97}',
    '\u{5B66}',
    '\u{76E3}',
    '\u{4F01}',
    '\u{8CC7}',
    '\u{5354}',
    '\u{591C}',
    '\u{0033}',
    '\u{0036}',
    '\u{0033}',
    '\u{0037}',
    '\u{0033}',
    '\u{0038}',
    '\u{0033}',
    '\u{0039}',
    '\u{0034}',
    '\u{0030}',
    '\u{0034}',
    '\u{0031}',
    '\u{0034}',
    '\u{0032}',
    '\u{0034}',
    '\u{0033}',
    '\u{0034}',
    '\u{0034}',
    '\u{0034}',
    '\u{0035}',
    '\u{0034}',
    '\u{0036}',
    '\u{0034}',
    '\u{0037}',
    '\u{0034}',
    '\u{0038}',
    '\u{0034}',
    '\u{0039}',
    '\u{0035}',
    '\u{0030}',
    '\u{0031}',
    '\u{6708}',
    '\u{0032}',
    '\u{6708}',
    '\u{0033}',
    '\u{6708}',
    '\u{0034}',
    '\u{6708}',
    '\u{0035}',
    '\u{6708}',
    '\u{0036}',
    '\u{6708}',
    '\u{0037}',
    '\u{6708}',
    '\u{0038}',
    '\u{6708}',
    '\u{0039}',
    '\u{6708}',
    '\u{0031}',
    '\u{0030}',
    '\u{6708}',
    '\u{0031}',
    '\u{0031}',
    '\u{6708}',
    '\u{0031}',
    '\u{0032}',
    '\u{6708}',
    '\u{0048}',
    '\u{0067}',
    '\u{0065}',
    '\u{0072}',
    '\u{0067}',
    '\u{0065}',
    '\u{0056}',
    '\u{004C}',
    '\u{0054}',
    '\u{0044}',
    '\u{30A2}',
    '\u{30A4}',
    '\u{30A6}',
    '\u{30A8}',
    '\u{30AA}',
    '\u{30AB}',
    '\u{30AD}',
    '\u{30AF}',
    '\u{30B1}',
    '\u{30B3}',
    '\u{30B5}',
    '\u{30B7}',
    '\u{30B9}',
    '\u{30BB}',
    '\u{30BD}',
    '\u{30BF}',
    '\u{30C1}',
    '\u{30C4}',
    '\u{30C6}',
    '\u{30C8}',
    '\u{30CA}',
    '\u{30CB}',
    '\u{30CC}',
    '\u{30CD}',
    '\u{30CE}',
    '\u{30CF}',
    '\u{30D2}',
    '\u{30D5}',
    '\u{30D8}',
    '\u{30DB}',
    '\u{30DE}',
    '\u{30DF}',
    '\u{30E0}',
    '\u{30E1}',
    '\u{30E2}',
    '\u{30E4}',
    '\u{30E6}',
    '\u{30E8}',
    '\u{30E9}',
    '\u{30EA}',
    '\u{30EB}',
    '\u{30EC}',
    '\u{30ED}',
    '\u{30EF}',
    '\u{30F0}',
    '\u{30F1}',
    '\u{30F2}',
    '\u{4EE4}',
    '\u{548C}',
    '\u{30A2}',
    '\u{30CF}',
    '\u{309A}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{30A2}',
    '\u{30EB}',
    '\u{30D5}',
    '\u{30A1}',
    '\u{30A2}',
    '\u{30F3}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30A2}',
    '\u{30A2}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30A4}',
    '\u{30CB}',
    '\u{30F3}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30A4}',
    '\u{30F3}',
    '\u{30C1}',
    '\u{30A6}',
    '\u{30A9}',
    '\u{30F3}',
    '\u{30A8}',
    '\u{30B9}',
    '\u{30AF}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30A8}',
    '\u{30FC}',
    '\u{30AB}',
    '\u{30FC}',
    '\u{30AA}',
    '\u{30F3}',
    '\u{30B9}',
    '\u{30AA}',
    '\u{30FC}',
    '\u{30E0}',
    '\u{30AB}',
    '\u{30A4}',
    '\u{30EA}',
    '\u{30AB}',
    '\u{30E9}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{30AB}',
    '\u{30ED}',
    '\u{30EA}',
    '\u{30FC}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30ED}',
    '\u{30F3}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30F3}',
    '\u{30DE}',
    '\u{30AD}',
    '\u{3099}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30AD}',
    '\u{3099}',
    '\u{30CB}',
    '\u{30FC}',
    '\u{30AD}',
    '\u{30E5}',
    '\u{30EA}',
    '\u{30FC}',
    '\u{30AD}',
    '\u{3099}',
    '\u{30EB}',
    '\u{30BF}',
    '\u{3099}',
    '\u{30FC}',
    '\u{30AD}',
    '\u{30ED}',
    '\u{30AD}',
    '\u{30ED}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30E9}',
    '\u{30E0}',
    '\u{30AD}',
    '\u{30ED}',
    '\u{30E1}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{30EB}',
    '\u{30AD}',
    '\u{30ED}',
    '\u{30EF}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30E9}',
    '\u{30E0}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30E9}',
    '\u{30E0}',
    '\u{30C8}',
    '\u{30F3}',
    '\u{30AF}',
    '\u{30EB}',
    '\u{30BB}',
    '\u{3099}',
    '\u{30A4}',
    '\u{30ED}',
    '\u{30AF}',
    '\u{30ED}',
    '\u{30FC}',
    '\u{30CD}',
    '\u{30B1}',
    '\u{30FC}',
    '\u{30B9}',
    '\u{30B3}',
    '\u{30EB}',
    '\u{30CA}',
    '\u{30B3}',
    '\u{30FC}',
    '\u{30DB}',
    '\u{309A}',
    '\u{30B5}',
    '\u{30A4}',
    '\u{30AF}',
    '\u{30EB}',
    '\u{30B5}',
    '\u{30F3}',
    '\u{30C1}',
    '\u{30FC}',
    '\u{30E0}',
    '\u{30B7}',
    '\u{30EA}',
    '\u{30F3}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30BB}',
    '\u{30F3}',
    '\u{30C1}',
    '\u{30BB}',
    '\u{30F3}',
    '\u{30C8}',
    '\u{30BF}',
    '\u{3099}',
    '\u{30FC}',
    '\u{30B9}',
    '\u{30C6}',
    '\u{3099}',
    '\u{30B7}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30EB}',
    '\u{30C8}',
    '\u{30F3}',
    '\u{30CA}',
    '\u{30CE}',
    '\u{30CE}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{30CF}',
    '\u{30A4}',
    '\u{30C4}',
    '\u{30CF}',
    '\u{309A}',
    '\u{30FC}',
    '\u{30BB}',
    '\u{30F3}',
    '\u{30C8}',
    '\u{30CF}',
    '\u{309A}',
    '\u{30FC}',
    '\u{30C4}',
    '\u{30CF}',
    '\u{3099}',
    '\u{30FC}',
    '\u{30EC}',
    '\u{30EB}',
    '\u{30D2}',
    '\u{309A}',
    '\u{30A2}',
    '\u{30B9}',
    '\u{30C8}',
    '\u{30EB}',
    '\u{30D2}',
    '\u{309A}',
    '\u{30AF}',
    '\u{30EB}',
    '\u{30D2}',
    '\u{309A}',
    '\u{30B3}',
    '\u{30D2}',
    '\u{3099}',
    '\u{30EB}',
    '\u{30D5}',
    '\u{30A1}',
    '\u{30E9}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30D5}',
    '\u{30A3}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{30D5}',
    '\u{3099}',
    '\u{30C3}',
    '\u{30B7}',
    '\u{30A7}',
    '\u{30EB}',
    '\u{30D5}',
    '\u{30E9}',
    '\u{30F3}',
    '\u{30D8}',
    '\u{30AF}',
    '\u{30BF}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30BD}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30CB}',
    '\u{30D2}',
    '\u{30D8}',
    '\u{30EB}',
    '\u{30C4}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30F3}',
    '\u{30B9}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30FC}',
    '\u{30B7}',
    '\u{3099}',
    '\u{30D8}',
    '\u{3099}',
    '\u{30FC}',
    '\u{30BF}',
    '\u{30DB}',
    '\u{309A}',
    '\u{30A4}',
    '\u{30F3}',
    '\u{30C8}',
    '\u{30DB}',
    '\u{3099}',
    '\u{30EB}',
    '\u{30C8}',
    '\u{30DB}',
    '\u{30F3}',
    '\u{30DB}',
    '\u{309A}',
    '\u{30F3}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30DB}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30DB}',
    '\u{30FC}',
    '\u{30F3}',
    '\u{30DE}',
    '\u{30A4}',
    '\u{30AF}',
    '\u{30ED}',
    '\u{30DE}',
    '\u{30A4}',
    '\u{30EB}',
    '\u{30DE}',
    '\u{30C3}',
    '\u{30CF}',
    '\u{30DE}',
    '\u{30EB}',
    '\u{30AF}',
    '\u{30DE}',
    '\u{30F3}',
    '\u{30B7}',
    '\u{30E7}',
    '\u{30F3}',
    '\u{30DF}',
    '\u{30AF}',
    '\u{30ED}',
    '\u{30F3}',
    '\u{30DF}',
    '\u{30EA}',
    '\u{30DF}',
    '\u{30EA}',
    '\u{30CF}',
    '\u{3099}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30E1}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30E1}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30C8}',
    '\u{30F3}',
    '\u{30E1}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{30EB}',
    '\u{30E4}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30E4}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30E6}',
    '\u{30A2}',
    '\u{30F3}',
    '\u{30EA}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{30EB}',
    '\u{30EA}',
    '\u{30E9}',
    '\u{30EB}',
    '\u{30D2}',
    '\u{309A}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30FC}',
    '\u{30D5}',
    '\u{3099}',
    '\u{30EB}',
    '\u{30EC}',
    '\u{30E0}',
    '\u{30EC}',
    '\u{30F3}',
    '\u{30C8}',
    '\u{30B1}',
    '\u{3099}',
    '\u{30F3}',
    '\u{30EF}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{0030}',
    '\u{70B9}',
    '\u{0031}',
    '\u{70B9}',
    '\u{0032}',
    '\u{70B9}',
    '\u{0033}',
    '\u{70B9}',
    '\u{0034}',
    '\u{70B9}',
    '\u{0035}',
    '\u{70B9}',
    '\u{0036}',
    '\u{70B9}',
    '\u{0037}',
    '\u{70B9}',
    '\u{0038}',
    '\u{70B9}',
    '\u{0039}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0030}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0031}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0032}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0033}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0034}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0035}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0036}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0037}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0038}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0039}',
    '\u{70B9}',
    '\u{0032}',
    '\u{0030}',
    '\u{70B9}',
    '\u{0032}',
    '\u{0031}',
    '\u{70B9}',
    '\u{0032}',
    '\u{0032}',
    '\u{70B9}',
    '\u{0032}',
    '\u{0033}',
    '\u{70B9}',
    '\u{0032}',
    '\u{0034}',
    '\u{70B9}',
    '\u{0068}',
    '\u{0050}',
    '\u{0061}',
    '\u{0064}',
    '\u{0061}',
    '\u{0041}',
    '\u{0055}',
    '\u{0062}',
    '\u{0061}',
    '\u{0072}',
    '\u{006F}',
    '\u{0056}',
    '\u{0070}',
    '\u{0063}',
    '\u{0064}',
    '\u{006D}',
    '\u{0064}',
    '\u{006D}',
    '\u{0032}',
    '\u{0064}',
    '\u{006D}',
    '\u{0033}',
    '\u{0049}',
    '\u{0055}',
    '\u{5E73}',
    '\u{6210}',
    '\u{662D}',
    '\u{548C}',
    '\u{5927}',
    '\u{6B63}',
    '\u{660E}',
    '\u{6CBB}',
    '\u{682A}',
    '\u{5F0F}',
    '\u{4F1A}',
    '\u{793E}',
    '\u{0070}',
    '\u{0041}',
    '\u{006E}',
    '\u{0041}',
    '\u{03BC}',
    '\u{0041}',
    '\u{006D}',
    '\u{0041}',
    '\u{006B}',
    '\u{0041}',
    '\u{004B}',
    '\u{0042}',
    '\u{004D}',
    '\u{0042}',
    '\u{0047}',
    '\u{0042}',
    '\u{0063}',
    '\u{0061}',
    '\u{006C}',
    '\u{006B}',
    '\u{0063}',
    '\u{0061}',
    '\u{006C}',
    '\u{0070}',
    '\u{0046}',
    '\u{006E}',
    '\u{0046}',
    '\u{03BC}',
    '\u{0046}',
    '\u{03BC}',
    '\u{0067}',
    '\u{006D}',
    '\u{0067}',
    '\u{006B}',
    '\u{0067}',
    '\u{0048}',
    '\u{007A}',
    '\u{006B}',
    '\u{0048}',
    '\u{007A}',
    '\u{004D}',
    '\u{0048}',
    '\u{007A}',
    '\u{0047}',
    '\u{0048}',
    '\u{007A}',
    '\u{0054}',
    '\u{0048}',
    '\u{007A}',
    '\u{03BC}',
    '\u{006C}',
    '\u{006D}',
    '\u{006C}',
    '\u{0064}',
    '\u{006C}',
    '\u{006B}',
    '\u{006C}',
    '\u{0066}',
    '\u{006D}',
    '\u{006E}',
    '\u{006D}',
    '\u{03BC}',
    '\u{006D}',
    '\u{006D}',
    '\u{006D}',
    '\u{0063}',
    '\u{006D}',
    '\u{006B}',
    '\u{006D}',
    '\u{006D}',
    '\u{006D}',
    '\u{0032}',
    '\u{0063}',
    '\u{006D}',
    '\u{0032}',
    '\u{006D}',
    '\u{0032}',
    '\u{006B}',
    '\u{006D}',
    '\u{0032}',
    '\u{006D}',
    '\u{006D}',
    '\u{0033}',
    '\u{0063}',
    '\u{006D}',
    '\u{0033}',
    '\u{006D}',
    '\u{0033}',
    '\u{006B}',
    '\u{006D}',
    '\u{0033}',
    '\u{006D}',
    '\u{2215}',
    '\u{0073}',
    '\u{006D}',
    '\u{2215}',
    '\u{0073}',
    '\u{0032}',
    '\u{0050}',
    '\u{0061}',
    '\u{006B}',
    '\u{0050}',
    '\u{0061}',
    '\u{004D}',
    '\u{0050}',
    '\u{0061}',
    '\u{0047}',
    '\u{0050}',
    '\u{0061}',
    '\u{0072}',
    '\u{0061}',
    '\u{0064}',
    '\u{0072}',
    '\u{0061}',
    '\u{0064}',
    '\u{2215}',
    '\u{0073}',
    '\u{0072}',
    '\u{0061}',
    '\u{0064}',
    '\u{2215}',
    '\u{0073}',
    '\u{0032}',
    '\u{0070}',
    '\u{0073}',
    '\u{006E}',
    '\u{0073}',
    '\u{03BC}',
    '\u{0073}',
    '\u{006D}',
    '\u{0073}',
    '\u{0070}',
    '\u{0056}',
    '\u{006E}',
    '\u{0056}',
    '\u{03BC}',
    '\u{0056}',
    '\u{006D}',
    '\u{0056}',
    '\u{006B}',
    '\u{0056}',
    '\u{004D}',
    '\u{0056}',
    '\u{0070}',
    '\u{0057}',
    '\u{006E}',
    '\u{0057}',
    '\u{03BC}',
    '\u{0057}',
    '\u{006D}',
    '\u{0057}',
    '\u{006B}',
    '\u{0057}',
    '\u{004D}',
    '\u{0057}',
    '\u{006B}',
    '\u{03A9}',
    '\u{004D}',
    '\u{03A9}',
    '\u{0061}',
    '\u{002E}',
    '\u{006D}',
    '\u{002E}',
    '\u{0042}',
    '\u{0071}',
    '\u{0063}',
    '\u{0063}',
    '\u{0063}',
    '\u{0064}',
    '\u{0043}',
    '\u{2215}',
    '\u{006B}',
    '\u{0067}',
    '\u{0043}',
    '\u{006F}',
    '\u{002E}',
    '\u{0064}',
    '\u{0042}',
    '\u{0047}',
    '\u{0079}',
    '\u{0068}',
    '\u{0061}',
    '\u{0048}',
    '\u{0050}',
    '\u{0069}',
    '\u{006E}',
    '\u{004B}',
    '\u{004B}',
    '\u{004B}',
    '\u{004D}',
    '\u{006B}',
    '\u{0074}',
    '\u{006C}',
    '\u{006D}',
    '\u{006C}',
    '\u{006E}',
    '\u{006C}',
    '\u{006F}',
    '\u{0067}',
    '\u{006C}',
    '\u{0078}',
    '\u{006D}',
    '\u{0062}',
    '\u{006D}',
    '\u{0069}',
    '\u{006C}',
    '\u{006D}',
    '\u{006F}',
    '\u{006C}',
    '\u{0050}',
    '\u{0048}',
    '\u{0070}',
    '\u{002E}',
    '\u{006D}',
    '\u{002E}',
    '\u{0050}',
    '\u{0050}',
    '\u{004D}',
    '\u{0050}',
    '\u{0052}',
    '\u{0073}',
    '\u{0072}',
    '\u{0053}',
    '\u{0076}',
    '\u{0057}',
    '\u{0062}',
    '\u{0056}',
    '\u{2215}',
    '\u{006D}',
    '\u{0041}',
    '\u{2215}',
    '\u{006D}',
    '\u{0031}',
    '\u{65E5}',
    '\u{0032}',
    '\u{65E5}',
    '\u{0033}',
    '\u{65E5}',
    '\u{0034}',
    '\u{65E5}',
    '\u{0035}',
    '\u{65E5}',
    '\u{0036}',
    '\u{65E5}',
    '\u{0037}',
    '\u{65E5}',
    '\u{0038}',
    '\u{65E5}',
    '\u{0039}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0030}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0031}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0032}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0033}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0034}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0035}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0036}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0037}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0038}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0039}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0030}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0031}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0032}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0033}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0034}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0035}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0036}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0037}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0038}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0039}',
    '\u{65E5}',
    '\u{0033}',
    '\u{0030}',
    '\u{65E5}',
    '\u{0033}',
    '\u{0031}',
    '\u{65E5}',
    '\u{0067}',
    '\u{0061}',
    '\u{006C}',
    '\u{044A}',
    '\u{044C}',
    '\u{A76F}',
    '\u{0043}',
    '\u{0046}',
    '\u{0051}',
    '\u{0126}',
    '\u{0153}',
    '\u{A727}',
    '\u{AB37}',
    '\u{026B}',
    '\u{AB52}',
    '\u{028D}',
    '\u{0066}',
    '\u{0066}',
    '\u{0066}',
    '\u{0069}',
    '\u{0066}',
    '\u{006C}',
    '\u{0066}',
    '\u{0066}',
    '\u{0069}',
    '\u{0066}',
    '\u{0066}',
    '\u{006C}',
    '\u{0073}',
    '\u{0074}',
    '\u{0073}',
    '\u{0074}',
    '\u{0574}',
    '\u{0576}',
    '\u{0574}',
    '\u{0565}',
    '\u{0574}',
    '\u{056B}',
    '\u{057E}',
    '\u{0576}',
    '\u{0574}',
    '\u{056D}',
    '\u{05E2}',
    '\u{05D0}',
    '\u{05D3}',
    '\u{05D4}',
    '\u{05DB}',
    '\u{05DC}',
    '\u{05DD}',
    '\u{05E8}',
    '\u{05EA}',
    '\u{002B}',
    '\u{05D0}',
    '\u{05DC}',
    '\u{0671}',
    '\u{0671}',
    '\u{067B}',
    '\u{067B}',
    '\u{067B}',
    '\u{067B}',
    '\u{067E}',
    '\u{067E}',
    '\u{067E}',
    '\u{067E}',
    '\u{0680}',
    '\u{0680}',
    '\u{0680}',
    '\u{0680}',
    '\u{067A}',
    '\u{067A}',
    '\u{067A}',
    '\u{067A}',
    '\u{067F}',
    '\u{067F}',
    '\u{067F}',
    '\u{067F}',
    '\u{0679}',
    '\u{0679}',
    '\u{0679}',
    '\u{0679}',
    '\u{06A4}',
    '\u{06A4}',
    '\u{06A4}',
    '\u{06A4}',
    '\u{06A6}',
    '\u{06A6}',
    '\u{06A6}',
    '\u{06A6}',
    '\u{0684}',
    '\u{0684}',
    '\u{0684}',
    '\u{0684}',
    '\u{0683}',
    '\u{0683}',
    '\u{0683}',
    '\u{0683}',
    '\u{0686}',
    '\u{0686}',
    '\u{0686}',
    '\u{0686}',
    '\u{0687}',
    '\u{0687}',
    '\u{0687}',
    '\u{0687}',
    '\u{068D}',
    '\u{068D}',
    '\u{068C}',
    '\u{068C}',
    '\u{068E}',
    '\u{068E}',
    '\u{0688}',
    '\u{0688}',
    '\u{0698}',
    '\u{0698}',
    '\u{0691}',
    '\u{0691}',
    '\u{06A9}',
    '\u{06A9}',
    '\u{06A9}',
    '\u{06A9}',
    '\u{06AF}',
    '\u{06AF}',
    '\u{06AF}',
    '\u{06AF}',
    '\u{06B3}',
    '\u{06B3}',
    '\u{06B3}',
    '\u{06B3}',
    '\u{06B1}',
    '\u{06B1}',
    '\u{06B1}',
    '\u{06B1}',
    '\u{06BA}',
    '\u{06BA}',
    '\u{06BB}',
    '\u{06BB}',
    '\u{06BB}',
    '\u{06BB}',
    '\u{06D5}',
    '\u{0654}',
    '\u{06D5}',
    '\u{0654}',
    '\u{06C1}',
    '\u{06C1}',
    '\u{06C1}',
    '\u{06C1}',
    '\u{06BE}',
    '\u{06BE}',
    '\u{06BE}',
    '\u{06BE}',
    '\u{06D2}',
    '\u{06D2}',
    '\u{06D2}',
    '\u{0654}',
    '\u{06D2}',
    '\u{0654}',
    '\u{06AD}',
    '\u{06AD}',
    '\u{06AD}',
    '\u{06AD}',
    '\u{06C7}',
    '\u{06C7}',
    '\u{06C6}',
    '\u{06C6}',
    '\u{06C8}',
    '\u{06C8}',
    '\u{06C7}',
    '\u{0674}',
    '\u{06CB}',
    '\u{06CB}',
    '\u{06C5}',
    '\u{06C5}',
    '\u{06C9}',
    '\u{06C9}',
    '\u{06D0}',
    '\u{06D0}',
    '\u{06D0}',
    '\u{06D0}',
    '\u{0649}',
    '\u{0649}',
    '\u{064A}',
    '\u{0654}',
    '\u{0627}',
    '\u{064A}',
    '\u{0654}',
    '\u{0627}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D5}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D5}',
    '\u{064A}',
    '\u{0654}',
    '\u{0648}',
    '\u{064A}',
    '\u{0654}',
    '\u{0648}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C7}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C7}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C6}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C6}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C8}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C8}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D0}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D0}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D0}',
    '\u{064A}',
    '\u{0654}',
    '\u{0649}',
    '\u{064A}',
    '\u{0654}',
    '\u{0649}',
    '\u{064A}',
    '\u{0654}',
    '\u{0649}',
    '\u{06CC}',
    '\u{06CC}',
    '\u{06CC}',
    '\u{06CC}',
    '\u{064A}',
    '\u{0654}',
    '\u{062C}',
    '\u{064A}',
    '\u{0654}',
    '\u{062D}',
    '\u{064A}',
    '\u{0654}',
    '\u{0645}',
    '\u{064A}',
    '\u{0654}',
    '\u{0649}',
    '\u{064A}',
    '\u{0654}',
    '\u{064A}',
    '\u{0628}',
    '\u{062C}',
    '\u{0628}',
    '\u{062D}',
    '\u{0628}',
    '\u{062E}',
    '\u{0628}',
    '\u{0645}',
    '\u{0628}',
    '\u{0649}',
    '\u{0628}',
    '\u{064A}',
    '\u{062A}',
    '\u{062C}',
    '\u{062A}',
    '\u{062D}',
    '\u{062A}',
    '\u{062E}',
    '\u{062A}',
    '\u{0645}',
    '\u{062A}',
    '\u{0649}',
    '\u{062A}',
    '\u{064A}',
    '\u{062B}',
    '\u{062C}',
    '\u{062B}',
    '\u{0645}',
    '\u{062B}',
    '\u{0649}',
    '\u{062B}',
    '\u{064A}',
    '\u{062C}',
    '\u{062D}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{062C}',
    '\u{062D}',
    '\u{0645}',
    '\u{062E}',
    '\u{062C}',
    '\u{062E}',
    '\u{062D}',
    '\u{062E}',
    '\u{0645}',
    '\u{0633}',
    '\u{062C}',
    '\u{0633}',
    '\u{062D}',
    '\u{0633}',
    '\u{062E}',
    '\u{0633}',
    '\u{0645}',
    '\u{0635}',
    '\u{062D}',
    '\u{0635}',
    '\u{0645}',
    '\u{0636}',
    '\u{062C}',
    '\u{0636}',
    '\u{062D}',
    '\u{0636}',
    '\u{062E}',
    '\u{0636}',
    '\u{0645}',
    '\u{0637}',
    '\u{062D}',
    '\u{0637}',
    '\u{0645}',
    '\u{0638}',
    '\u{0645}',
    '\u{0639}',
    '\u{062C}',
    '\u{0639}',
    '\u{0645}',
    '\u{063A}',
    '\u{062C}',
    '\u{063A}',
    '\u{0645}',
    '\u{0641}',
    '\u{062C}',
    '\u{0641}',
    '\u{062D}',
    '\u{0641}',
    '\u{062E}',
    '\u{0641}',
    '\u{0645}',
    '\u{0641}',
    '\u{0649}',
    '\u{0641}',
    '\u{064A}',
    '\u{0642}',
    '\u{062D}',
    '\u{0642}',
    '\u{0645}',
    '\u{0642}',
    '\u{0649}',
    '\u{0642}',
    '\u{064A}',
    '\u{0643}',
    '\u{0627}',
    '\u{0643}',
    '\u{062C}',
    '\u{0643}',
    '\u{062D}',
    '\u{0643}',
    '\u{062E}',
    '\u{0643}',
    '\u{0644}',
    '\u{0643}',
    '\u{0645}',
    '\u{0643}',
    '\u{0649}',
    '\u{0643}',
    '\u{064A}',
    '\u{0644}',
    '\u{062C}',
    '\u{0644}',
    '\u{062D}',
    '\u{0644}',
    '\u{062E}',
    '\u{0644}',
    '\u{0645}',
    '\u{0644}',
    '\u{0649}',
    '\u{0644}',
    '\u{064A}',
    '\u{0645}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{0645}',
    '\u{062E}',
    '\u{0645}',
    '\u{0645}',
    '\u{0645}',
    '\u{0649}',
    '\u{0645}',
    '\u{064A}',
    '\u{0646}',
    '\u{062C}',
    '\u{0646}',
    '\u{062D}',
    '\u{0646}',
    '\u{062E}',
    '\u{0646}',
    '\u{0645}',
    '\u{0646}',
    '\u{0649}',
    '\u{0646}',
    '\u{064A}',
    '\u{0647}',
    '\u{062C}',
    '\u{0647}',
    '\u{0645}',
    '\u{0647}',
    '\u{0649}',
    '\u{0647}',
    '\u{064A}',
    '\u{064A}',
    '\u{062C}',
    '\u{064A}',
    '\u{062D}',
    '\u{064A}',
    '\u{062E}',
    '\u{064A}',
    '\u{0645}',
    '\u{064A}',
    '\u{0649}',
    '\u{064A}',
    '\u{064A}',
    '\u{0630}',
    '\u{0670}',
    '\u{0631}',
    '\u{0670}',
    '\u{0649}',
    '\u{0670}',
    '\u{0020}',
    '\u{064C}',
    '\u{0651}',
    '\u{0020}',
    '\u{064D}',
    '\u{0651}',
    '\u{0020}',
    '\u{064E}',
    '\u{0651}',
    '\u{0020}',
    '\u{064F}',
    '\u{0651}',
    '\u{0020}',
    '\u{0650}',
    '\u{0651}',
    '\u{0020}',
    '\u{0651}',
    '\u{0670}',
    '\u{064A}',
    '\u{0654}',
    '\u{0631}',
    '\u{064A}',
    '\u{0654}',
    '\u{0632}',
    '\u{064A}',
    '\u{0654}',
    '\u{0645}',
    '\u{064A}',
    '\u{0654}',
    '\u{0646}',
    '\u{064A}',
    '\u{0654}',
    '\u{0649}',
    '\u{064A}',
    '\u{0654}',
    '\u{064A}',
    '\u{0628}',
    '\u{0631}',
    '\u{0628}',
    '\u{0632}',
    '\u{0628}',
    '\u{0645}',
    '\u{0628}',
    '\u{0646}',
    '\u{0628}',
    '\u{0649}',
    '\u{0628}',
    '\u{064A}',
    '\u{062A}',
    '\u{0631}',
    '\u{062A}',
    '\u{0632}',
    '\u{062A}',
    '\u{0645}',
    '\u{062A}',
    '\u{0646}',
    '\u{062A}',
    '\u{0649}',
    '\u{062A}',
    '\u{064A}',
    '\u{062B}',
    '\u{0631}',
    '\u{062B}',
    '\u{0632}',
    '\u{062B}',
    '\u{0645}',
    '\u{062B}',
    '\u{0646}',
    '\u{062B}',
    '\u{0649}',
    '\u{062B}',
    '\u{064A}',
    '\u{0641}',
    '\u{0649}',
    '\u{0641}',
    '\u{064A}',
    '\u{0642}',
    '\u{0649}',
    '\u{0642}',
    '\u{064A}',
    '\u{0643}',
    '\u{0627}',
    '\u{0643}',
    '\u{0644}',
    '\u{0643}',
    '\u{0645}',
    '\u{0643}',
    '\u{0649}',
    '\u{0643}',
    '\u{064A}',
    '\u{0644}',
    '\u{0645}',
    '\u{0644}',
    '\u{0649}',
    '\u{0644}',
    '\u{064A}',
    '\u{0645}',
    '\u{0627}',
    '\u{0645}',
    '\u{0645}',
    '\u{0646}',
    '\u{0631}',
    '\u{0646}',
    '\u{0632}',
    '\u{0646}',
    '\u{0645}',
    '\u{0646}',
    '\u{0646}',
    '\u{0646}',
    '\u{0649}',
    '\u{0646}',
    '\u{064A}',
    '\u{0649}',
    '\u{0670}',
    '\u{064A}',
    '\u{0631}',
    '\u{064A}',
    '\u{0632}',
    '\u{064A}',
    '\u{0645}',
    '\u{064A}',
    '\u{0646}',
    '\u{064A}',
    '\u{0649}',
    '\u{064A}',
    '\u{064A}',
    '\u{064A}',
    '\u{0654}',
    '\u{062C}',
    '\u{064A}',
    '\u{0654}',
    '\u{062D}',
    '\u{064A}',
    '\u{0654}',
    '\u{062E}',
    '\u{064A}',
    '\u{0654}',
    '\u{0645}',
    '\u{064A}',
    '\u{0654}',
    '\u{0647}',
    '\u{0628}',
    '\u{062C}',
    '\u{0628}',
    '\u{062D}',
    '\u{0628}',
    '\u{062E}',
    '\u{0628}',
    '\u{0645}',
    '\u{0628}',
    '\u{0647}',
    '\u{062A}',
    '\u{062C}',
    '\u{062A}',
    '\u{062D}',
    '\u{062A}',
    '\u{062E}',
    '\u{062A}',
    '\u{0645}',
    '\u{062A}',
    '\u{0647}',
    '\u{062B}',
    '\u{0645}',
    '\u{062C}',
    '\u{062D}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{062C}',
    '\u{062D}',
    '\u{0645}',
    '\u{062E}',
    '\u{062C}',
    '\u{062E}',
    '\u{0645}',
    '\u{0633}',
    '\u{062C}',
    '\u{0633}',
    '\u{062D}',
    '\u{0633}',
    '\u{062E}',
    '\u{0633}',
    '\u{0645}',
    '\u{0635}',
    '\u{062D}',
    '\u{0635}',
    '\u{062E}',
    '\u{0635}',
    '\u{0645}',
    '\u{0636}',
    '\u{062C}',
    '\u{0636}',
    '\u{062D}',
    '\u{0636}',
    '\u{062E}',
    '\u{0636}',
    '\u{0645}',
    '\u{0637}',
    '\u{062D}',
    '\u{0638}',
    '\u{0645}',
    '\u{0639}',
    '\u{062C}',
    '\u{0639}',
    '\u{0645}',
    '\u{063A}',
    '\u{062C}',
    '\u{063A}',
    '\u{0645}',
    '\u{0641}',
    '\u{062C}',
    '\u{0641}',
    '\u{062D}',
    '\u{0641}',
    '\u{062E}',
    '\u{0641}',
    '\u{0645}',
    '\u{0642}',
    '\u{062D}',
    '\u{0642}',
    '\u{0645}',
    '\u{0643}',
    '\u{062C}',
    '\u{0643}',
    '\u{062D}',
    '\u{0643}',
    '\u{062E}',
    '\u{0643}',
    '\u{0644}',
    '\u{0643}',
    '\u{0645}',
    '\u{0644}',
    '\u{062C}',
    '\u{0644}',
    '\u{062D}',
    '\u{0644}',
    '\u{062E}',
    '\u{0644}',
    '\u{0645}',
    '\u{0644}',
    '\u{0647}',
    '\u{0645}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{0645}',
    '\u{062E}',
    '\u{0645}',
    '\u{0645}',
    '\u{0646}',
    '\u{062C}',
    '\u{0646}',
    '\u{062D}',
    '\u{0646}',
    '\u{062E}',
    '\u{0646}',
    '\u{0645}',
    '\u{0646}',
    '\u{0647}',
    '\u{0647}',
    '\u{062C}',
    '\u{0647}',
    '\u{0645}',
    '\u{0647}',
    '\u{0670}',
    '\u{064A}',
    '\u{062C}',
    '\u{064A}',
    '\u{062D}',
    '\u{064A}',
    '\u{062E}',
    '\u{064A}',
    '\u{0645}',
    '\u{064A}',
    '\u{0647}',
    '\u{064A}',
    '\u{0654}',
    '\u{0645}',
    '\u{064A}',
    '\u{0654}',
    '\u{0647}',
    '\u{0628}',
    '\u{0645}',
    '\u{0628}',
    '\u{0647}',
    '\u{062A}',
    '\u{0645}',
    '\u{062A}',
    '\u{0647}',
    '\u{062B}',
    '\u{0645}',
    '\u{062B}',
    '\u{0647}',
    '\u{0633}',
    '\u{0645}',
    '\u{0633}',
    '\u{0647}',
    '\u{0634}',
    '\u{0645}',
    '\u{0634}',
    '\u{0647}',
    '\u{0643}',
    '\u{0644}',
    '\u{0643}',
    '\u{0645}',
    '\u{0644}',
    '\u{0645}',
    '\u{0646}',
    '\u{0645}',
    '\u{0646}',
    '\u{0647}',
    '\u{064A}',
    '\u{0645}',
    '\u{064A}',
    '\u{0647}',
    '\u{0640}',
    '\u{064E}',
    '\u{0651}',
    '\u{0640}',
    '\u{064F}',
    '\u{0651}',
    '\u{0640}',
    '\u{0650}',
    '\u{0651}',
    '\u{0637}',
    '\u{0649}',
    '\u{0637}',
    '\u{064A}',
    '\u{0639}',
    '\u{0649}',
    '\u{0639}',
    '\u{064A}',
    '\u{063A}',
    '\u{0649}',
    '\u{063A}',
    '\u{064A}',
    '\u{0633}',
    '\u{0649}',
    '\u{0633}',
    '\u{064A}',
    '\u{0634}',
    '\u{0649}',
    '\u{0634}',
    '\u{064A}',
    '\u{062D}',
    '\u{0649}',
    '\u{062D}',
    '\u{064A}',
    '\u{062C}',
    '\u{0649}',
    '\u{062C}',
    '\u{064A}',
    '\u{062E}',
    '\u{0649}',
    '\u{062E}',
    '\u{064A}',
    '\u{0635}',
    '\u{0649}',
    '\u{0635}',
    '\u{064A}',
    '\u{0636}',
    '\u{0649}',
    '\u{0636}',
    '\u{064A}',
    '\u{0634}',
    '\u{062C}',
    '\u{0634}',
    '\u{062D}',
    '\u{0634}',
    '\u{062E}',
    '\u{0634}',
    '\u{0645}',
    '\u{0634}',
    '\u{0631}',
    '\u{0633}',
    '\u{0631}',
    '\u{0635}',
    '\u{0631}',
    '\u{0636}',
    '\u{0631}',
    '\u{0637}',
    '\u{0649}',
    '\u{0637}',
    '\u{064A}',
    '\u{0639}',
    '\u{0649}',
    '\u{0639}',
    '\u{064A}',
    '\u{063A}',
    '\u{0649}',
    '\u{063A}',
    '\u{064A}',
    '\u{0633}',
    '\u{0649}',
    '\u{0633}',
    '\u{064A}',
    '\u{0634}',
    '\u{0649}',
    '\u{0634}',
    '\u{064A}',
    '\u{062D}',
    '\u{0649}',
    '\u{062D}',
    '\u{064A}',
    '\u{062C}',
    '\u{0649}',
    '\u{062C}',
    '\u{064A}',
    '\u{062E}',
    '\u{0649}',
    '\u{062E}',
    '\u{064A}',
    '\u{0635}',
    '\u{0649}',
    '\u{0635}',
    '\u{064A}',
    '\u{0636}',
    '\u{0649}',
    '\u{0636}',
    '\u{064A}',
    '\u{0634}',
    '\u{062C}',
    '\u{0634}',
    '\u{062D}',
    '\u{0634}',
    '\u{062E}',
    '\u{0634}',
    '\u{0645}',
    '\u{0634}',
    '\u{0631}',
    '\u{0633}',
    '\u{0631}',
    '\u{0635}',
    '\u{0631}',
    '\u{0636}',
    '\u{0631}',
    '\u{0634}',
    '\u{062C}',
    '\u{0634}',
    '\u{062D}',
    '\u{0634}',
    '\u{062E}',
    '\u{0634}',
    '\u{0645}',
    '\u{0633}',
    '\u{0647}',
    '\u{0634}',
    '\u{0647}',
    '\u{0637}',
    '\u{0645}',
    '\u{0633}',
    '\u{062C}',
    '\u{0633}',
    '\u{062D}',
    '\u{0633}',
    '\u{062E}',
    '\u{0634}',
    '\u{062C}',
    '\u{0634}',
    '\u{062D}',
    '\u{0634}',
    '\u{062E}',
    '\u{0637}',
    '\u{0645}',
    '\u{0638}',
    '\u{0645}',
    '\u{0627}',
    '\u{064B}',
    '\u{0627}',
    '\u{064B}',
    '\u{062A}',
    '\u{062C}',
    '\u{0645}',
    '\u{062A}',
    '\u{062D}',
    '\u{062C}',
    '\u{062A}',
    '\u{062D}',
    '\u{062C}',
    '\u{062A}',
    '\u{062D}',
    '\u{0645}',
    '\u{062A}',
    '\u{062E}',
    '\u{0645}',
    '\u{062A}',
    '\u{0645}',
    '\u{062C}',
    '\u{062A}',
    '\u{0645}',
    '\u{062D}',
    '\u{062A}',
    '\u{0645}',
    '\u{062E}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{062D}',
    '\u{0645}',
    '\u{064A}',
    '\u{062D}',
    '\u{0645}',
    '\u{0649}',
    '\u{0633}',
    '\u{062D}',
    '\u{062C}',
    '\u{0633}',
    '\u{062C}',
    '\u{062D}',
    '\u{0633}',
    '\u{062C}',
    '\u{0649}',
    '\u{0633}',
    '\u{0645}',
    '\u{062D}',
    '\u{0633}',
    '\u{0645}',
    '\u{062D}',
    '\u{0633}',
    '\u{0645}',
    '\u{062C}',
    '\u{0633}',
    '\u{0645}',
    '\u{0645}',
    '\u{0633}',
    '\u{0645}',
    '\u{0645}',
    '\u{0635}',
    '\u{062D}',
    '\u{062D}',
    '\u{0635}',
    '\u{062D}',
    '\u{062D}',
    '\u{0635}',
    '\u{0645}',
    '\u{0645}',
    '\u{0634}',
    '\u{062D}',
    '\u{0645}',
    '\u{0634}',
    '\u{062D}',
    '\u{0645}',
    '\u{0634}',
    '\u{062C}',
    '\u{064A}',
    '\u{0634}',
    '\u{0645}',
    '\u{062E}',
    '\u{0634}',
    '\u{0645}',
    '\u{062E}',
    '\u{0634}',
    '\u{0645}',
    '\u{0645}',
    '\u{0634}',
    '\u{0645}',
    '\u{0645}',
    '\u{0636}',
    '\u{062D}',
    '\u{0649}',
    '\u{0636}',
    '\u{062E}',
    '\u{0645}',
    '\u{0636}',
    '\u{062E}',
    '\u{0645}',
    '\u{0637}',
    '\u{0645}',
    '\u{062D}',
    '\u{0637}',
    '\u{0645}',
    '\u{062D}',
    '\u{0637}',
    '\u{0645}',
    '\u{0645}',
    '\u{0637}',
    '\u{0645}',
    '\u{064A}',
    '\u{0639}',
    '\u{062C}',
    '\u{0645}',
    '\u{0639}',
    '\u{0645}',
    '\u{0645}',
    '\u{0639}',
    '\u{0645}',
    '\u{0645}',
    '\u{0639}',
    '\u{0645}',
    '\u{0649}',
    '\u{063A}',
    '\u{0645}',
    '\u{0645}',
    '\u{063A}',
    '\u{0645}',
    '\u{064A}',
    '\u{063A}',
    '\u{0645}',
    '\u{0649}',
    '\u{0641}',
    '\u{062E}',
    '\u{0645}',
    '\u{0641}',
    '\u{062E}',
    '\u{0645}',
    '\u{0642}',
    '\u{0645}',
    '\u{062D}',
    '\u{0642}',
    '\u{0645}',
    '\u{0645}',
    '\u{0644}',
    '\u{062D}',
    '\u{0645}',
    '\u{0644}',
    '\u{062D}',
    '\u{064A}',
    '\u{0644}',
    '\u{062D}',
    '\u{0649}',
    '\u{0644}',
    '\u{062C}',
    '\u{062C}',
    '\u{0644}',
    '\u{062C}',
    '\u{062C}',
    '\u{0644}',
    '\u{062E}',
    '\u{0645}',
    '\u{0644}',
    '\u{062E}',
    '\u{0645}',
    '\u{0644}',
    '\u{0645}',
    '\u{062D}',
    '\u{0644}',
    '\u{0645}',
    '\u{062D}',
    '\u{0645}',
    '\u{062D}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{0645}',
    '\u{0645}',
    '\u{062D}',
    '\u{064A}',
    '\u{0645}',
    '\u{062C}',
    '\u{062D}',
    '\u{0645}',
    '\u{062C}',
    '\u{0645}',
    '\u{0645}',
    '\u{062E}',
    '\u{062C}',
    '\u{0645}',
    '\u{062E}',
    '\u{0645}',
    '\u{0645}',
    '\u{062C}',
    '\u{062E}',
    '\u{0647}',
    '\u{0645}',
    '\u{062C}',
    '\u{0647}',
    '\u{0645}',
    '\u{0645}',
    '\u{0646}',
    '\u{062D}',
    '\u{0645}',
    '\u{0646}',
    '\u{062D}',
    '\u{0649}',
    '\u{0646}',
    '\u{062C}',
    '\u{0645}',
    '\u{0646}',
    '\u{062C}',
    '\u{0645}',
    '\u{0646}',
    '\u{062C}',
    '\u{0649}',
    '\u{0646}',
    '\u{0645}',
    '\u{064A}',
    '\u{0646}',
    '\u{0645}',
    '\u{0649}',
    '\u{064A}',
    '\u{0645}',
    '\u{0645}',
    '\u{064A}',
    '\u{0645}',
    '\u{0645}',
    '\u{0628}',
    '\u{062E}',
    '\u{064A}',
    '\u{062A}',
    '\u{062C}',
    '\u{064A}',
    '\u{062A}',
    '\u{062C}',
    '\u{0649}',
    '\u{062A}',
    '\u{062E}',
    '\u{064A}',
    '\u{062A}',
    '\u{062E}',
    '\u{0649}',
    '\u{062A}',
    '\u{0645}',
    '\u{064A}',
    '\u{062A}',
    '\u{0645}',
    '\u{0649}',
    '\u{062C}',
    '\u{0645}',
    '\u{064A}',
    '\u{062C}',
    '\u{062D}',
    '\u{0649}',
    '\u{062C}',
    '\u{0645}',
    '\u{0649}',
    '\u{0633}',
    '\u{062E}',
    '\u{0649}',
    '\u{0635}',
    '\u{062D}',
    '\u{064A}',
    '\u{0634}',
    '\u{062D}',
    '\u{064A}',
    '\u{0636}',
    '\u{062D}',
    '\u{064A}',
    '\u{0644}',
    '\u{062C}',
    '\u{064A}',
    '\u{0644}',
    '\u{0645}',
    '\u{064A}',
    '\u{064A}',
    '\u{062D}',
    '\u{064A}',
    '\u{064A}',
    '\u{062C}',
    '\u{064A}',
    '\u{064A}',
    '\u{0645}',
    '\u{064A}',
    '\u{0645}',
    '\u{0645}',
    '\u{064A}',
    '\u{0642}',
    '\u{0645}',
    '\u{064A}',
    '\u{0646}',
    '\u{062D}',
    '\u{064A}',
    '\u{0642}',
    '\u{0645}',
    '\u{062D}',
    '\u{0644}',
    '\u{062D}',
    '\u{0645}',
    '\u{0639}',
    '\u{0645}',
    '\u{064A}',
    '\u{0643}',
    '\u{0645}',
    '\u{064A}',
    '\u{0646}',
    '\u{062C}',
    '\u{062D}',
    '\u{0645}',
    '\u{062E}',
    '\u{064A}',
    '\u{0644}',
    '\u{062C}',
    '\u{0645}',
    '\u{0643}',
    '\u{0645}',
    '\u{0645}',
    '\u{0644}',
    '\u{062C}',
    '\u{0645}',
    '\u{0646}',
    '\u{062C}',
    '\u{062D}',
    '\u{062C}',
    '\u{062D}',
    '\u{064A}',
    '\u{062D}',
    '\u{062C}',
    '\u{064A}',
    '\u{0645}',
    '\u{062C}',
    '\u{064A}',
    '\u{0641}',
    '\u{0645}',
    '\u{064A}',
    '\u{0628}',
    '\u{062D}',
    '\u{064A}',
    '\u{0643}',
    '\u{0645}',
    '\u{0645}',
    '\u{0639}',
    '\u{062C}',
    '\u{0645}',
    '\u{0635}',
    '\u{0645}',
    '\u{0645}',
    '\u{0633}',
    '\u{062E}',
    '\u{064A}',
    '\u{0646}',
    '\u{062C}',
    '\u{064A}',
    '\u{0635}',
    '\u{0644}',
    '\u{06D2}',
    '\u{0642}',
    '\u{0644}',
    '\u{06D2}',
    '\u{0627}',
    '\u{0644}',
    '\u{0644}',
    '\u{0647}',
    '\u{0627}',
    '\u{0643}',
    '\u{0628}',
    '\u{0631}',
    '\u{0645}',
    '\u{062D}',
    '\u{0645}',
    '\u{062F}',
    '\u{0635}',
    '\u{0644}',
    '\u{0639}',
    '\u{0645}',
    '\u{0631}',
    '\u{0633}',
    '\u{0648}',
    '\u{0644}',
    '\u{0639}',
    '\u{0644}',
    '\u{064A}',
    '\u{0647}',
    '\u{0648}',
    '\u{0633}',
    '\u{0644}',
    '\u{0645}',
    '\u{0635}',
    '\u{0644}',
    '\u{0649}',
    '\u{0635}',
    '\u{0644}',
    '\u{0649}',
    '\u{0020}',
    '\u{0627}',
    '\u{0644}',
    '\u{0644}',
    '\u{0647}',
    '\u{0020}',
    '\u{0639}',
    '\u{0644}',
    '\u{064A}',
    '\u{0647}',
    '\u{0020}',
    '\u{0648}',
    '\u{0633}',
    '\u{0644}',
    '\u{0645}',
    '\u{062C}',
    '\u{0644}',
    '\u{0020}',
    '\u{062C}',
    '\u{0644}',
    '\u{0627}',
    '\u{0644}',
    '\u{0647}',
    '\u{0631}',
    '\u{06CC}',
    '\u{0627}',
    '\u{0644}',
    '\u{002C}',
    '\u{3001}',
    '\u{3002}',
    '\u{003A}',
    '\u{003B}',
    '\u{0021}',
    '\u{003F}',
    '\u{3016}',
    '\u{3017}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{2014}',
    '\u{2013}',
    '\u{005F}',
    '\u{005F}',
    '\u{0028}',
    '\u{0029}',
    '\u{007B}',
    '\u{007D}',
    '\u{3014}',
    '\u{3015}',
    '\u{3010}',
    '\u{3011}',
    '\u{300A}',
    '\u{300B}',
    '\u{3008}',
    '\u{3009}',
    '\u{300C}',
    '\u{300D}',
    '\u{300E}',
    '\u{300F}',
    '\u{005B}',
    '\u{005D}',
    '\u{0020}',
    '\u{0305}',
    '\u{0020}',
    '\u{0305}',
    '\u{0020}',
    '\u{0305}',
    '\u{0020}',
    '\u{0305}',
    '\u{005F}',
    '\u{005F}',
    '\u{005F}',
    '\u{002C}',
    '\u{3001}',
    '\u{002E}',
    '\u{003B}',
    '\u{003A}',
    '\u{003F}',
    '\u{0021}',
    '\u{2014}',
    '\u{0028}',
    '\u{0029}',
    '\u{007B}',
    '\u{007D}',
    '\u{3014}',
    '\u{3015}',
    '\u{0023}',
    '\u{0026}',
    '\u{002A}',
    '\u{002B}',
    '\u{002D}',
    '\u{003C}',
    '\u{003E}',
    '\u{003D}',
    '\u{005C}',
    '\u{0024}',
    '\u{0025}',
    '\u{0040}',
    '\u{0020}',
    '\u{064B}',
    '\u{0640}',
    '\u{064B}',
    '\u{0020}',
    '\u{064C}',
    '\u{0020}',
    '\u{064D}',
    '\u{0020}',
    '\u{064E}',
    '\u{0640}',
    '\u{064E}',
    '\u{0020}',
    '\u{064F}',
    '\u{0640}',
    '\u{064F}',
    '\u{0020}',
    '\u{0650}',
    '\u{0640}',
    '\u{0650}',
    '\u{0020}',
    '\u{0651}',
    '\u{0640}',
    '\u{0651}',
    '\u{0020}',
    '\u{0652}',
    '\u{0640}',
    '\u{0652}',
    '\u{0621}',
    '\u{0627}',
    '\u{0653}',
    '\u{0627}',
    '\u{0653}',
    '\u{0627}',
    '\u{0654}',
    '\u{0627}',
    '\u{0654}',
    '\u{0648}',
    '\u{0654}',
    '\u{0648}',
    '\u{0654}',
    '\u{0627}',
    '\u{0655}',
    '\u{0627}',
    '\u{0655}',
    '\u{064A}',
    '\u{0654}',
    '\u{064A}',
    '\u{0654}',
    '\u{064A}',
    '\u{0654}',
    '\u{064A}',
    '\u{0654}',
    '\u{0627}',
    '\u{0627}',
    '\u{0628}',
    '\u{0628}',
    '\u{0628}',
    '\u{0628}',
    '\u{0629}',
    '\u{0629}',
    '\u{062A}',
    '\u{062A}',
    '\u{062A}',
    '\u{062A}',
    '\u{062B}',
    '\u{062B}',
    '\u{062B}',
    '\u{062B}',
    '\u{062C}',
    '\u{062C}',
    '\u{062C}',
    '\u{062C}',
    '\u{062D}',
    '\u{062D}',
    '\u{062D}',
    '\u{062D}',
    '\u{062E}',
    '\u{062E}',
    '\u{062E}',
    '\u{062E}',
    '\u{062F}',
    '\u{062F}',
    '\u{0630}',
    '\u{0630}',
    '\u{0631}',
    '\u{0631}',
    '\u{0632}',
    '\u{0632}',
    '\u{0633}',
    '\u{0633}',
    '\u{0633}',
    '\u{0633}',
    '\u{0634}',
    '\u{0634}',
    '\u{0634}',
    '\u{0634}',
    '\u{0635}',
    '\u{0635}',
    '\u{0635}',
    '\u{0635}',
    '\u{0636}',
    '\u{0636}',
    '\u{0636}',
    '\u{0636}',
    '\u{0637}',
    '\u{0637}',
    '\u{0637}',
    '\u{0637}',
    '\u{0638}',
    '\u{0638}',
    '\u{0638}',
    '\u{0638}',
    '\u{0639}',
    '\u{0639}',
    '\u{0639}',
    '\u{0639}',
    '\u{063A}',
    '\u{063A}',
    '\u{063A}',
    '\u{063A}',
    '\u{0641}',
    '\u{0641}',
    '\u{0641}',
    '\u{0641}',
    '\u{0642}',
    '\u{0642}',
    '\u{0642}',
    '\u{0642}',
    '\u{0643}',
    '\u{0643}',
    '\u{0643}',
    '\u{0643}',
    '\u{0644}',
    '\u{0644}',
    '\u{0644}',
    '\u{0644}',
    '\u{0645}',
    '\u{0645}',
    '\u{0645}',
    '\u{0645}',
    '\u{0646}',
    '\u{0646}',
    '\u{0646}',
    '\u{0646}',
    '\u{0647}',
    '\u{0647}',
    '\u{0647}',
    '\u{0647}',
    '\u{0648}',
    '\u{0648}',
    '\u{0649}',
    '\u{0649}',
    '\u{064A}',
    '\u{064A}',
    '\u{064A}',
    '\u{064A}',
    '\u{0644}',
    '\u{0627}',
    '\u{0653}',
    '\u{0644}',
    '\u{0627}',
    '\u{0653}',
    '\u{0644}',
    '\u{0627}',
    '\u{0654}',
    '\u{0644}',
    '\u{0627}',
    '\u{0654}',
    '\u{0644}',
    '\u{0627}',
    '\u{0655}',
    '\u{0644}',
    '\u{0627}',
    '\u{0655}',
    '\u{0644}',
    '\u{0627}',
    '\u{0644}',
    '\u{0627}',
    '\u{0021}',
    '\u{0022}',
    '\u{0023}',
    '\u{0024}',
    '\u{0025}',
    '\u{0026}',
    '\u{0027}',
    '\u{0028}',
    '\u{0029}',
    '\u{002A}',
    '\u{002B}',
    '\u{002C}',
    '\u{002D}',
    '\u{002E}',
    '\u{002F}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{003A}',
    '\u{003B}',
    '\u{003C}',
    '\u{003D}',
    '\u{003E}',
    '\u{003F}',
    '\u{0040}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{005B}',
    '\u{005C}',
    '\u{005D}',
    '\u{005E}',
    '\u{005F}',
    '\u{0060}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{007B}',
    '\u{007C}',
    '\u{007D}',
    '\u{007E}',
    '\u{2985}',
    '\u{2986}',
    '\u{3002}',
    '\u{300C}',
    '\u{300D}',
    '\u{3001}',
    '\u{30FB}',
    '\u{30F2}',
    '\u{30A1}',
    '\u{30A3}',
    '\u{30A5}',
    '\u{30A7}',
    '\u{30A9}',
    '\u{30E3}',
    '\u{30E5}',
    '\u{30E7}',
    '\u{30C3}',
    '\u{30FC}',
    '\u{30A2}',
    '\u{30A4}',
    '\u{30A6}',
    '\u{30A8}',
    '\u{30AA}',
    '\u{30AB}',
    '\u{30AD}',
    '\u{30AF}',
    '\u{30B1}',
    '\u{30B3}',
    '\u{30B5}',
    '\u{30B7}',
    '\u{30B9}',
    '\u{30BB}',
    '\u{30BD}',
    '\u{30BF}',
    '\u{30C1}',
    '\u{30C4}',
    '\u{30C6}',
    '\u{30C8}',
    '\u{30CA}',
    '\u{30CB}',
    '\u{30CC}',
    '\u{30CD}',
    '\u{30CE}',
    '\u{30CF}',
    '\u{30D2}',
    '\u{30D5}',
    '\u{30D8}',
    '\u{30DB}',
    '\u{30DE}',
    '\u{30DF}',
    '\u{30E0}',
    '\u{30E1}',
    '\u{30E2}',
    '\u{30E4}',
    '\u{30E6}',
    '\u{30E8}',
    '\u{30E9}',
    '\u{30EA}',
    '\u{30EB}',
    '\u{30EC}',
    '\u{30ED}',
    '\u{30EF}',
    '\u{30F3}',
    '\u{3099}',
    '\u{309A}',
    '\u{1160}',
    '\u{1100}',
    '\u{1101}',
    '\u{11AA}',
    '\u{1102}',
    '\u{11AC}',
    '\u{11AD}',
    '\u{1103}',
    '\u{1104}',
    '\u{1105}',
    '\u{11B0}',
    '\u{11B1}',
    '\u{11B2}',
    '\u{11B3}',
    '\u{11B4}',
    '\u{11B5}',
    '\u{111A}',
    '\u{1106}',
    '\u{1107}',
    '\u{1108}',
    '\u{1121}',
    '\u{1109}',
    '\u{110A}',
    '\u{110B}',
    '\u{110C}',
    '\u{110D}',
    '\u{110E}',
    '\u{110F}',
    '\u{1110}',
    '\u{1111}',
    '\u{1112}',
    '\u{1161}',
    '\u{1162}',
    '\u{1163}',
    '\u{1164}',
    '\u{1165}',
    '\u{1166}',
    '\u{1167}',
    '\u{1168}',
    '\u{1169}',
    '\u{116A}',
    '\u{116B}',
    '\u{116C}',
    '\u{116D}',
    '\u{116E}',
    '\u{116F}',
    '\u{1170}',
    '\u{1171}',
    '\u{1172}',
    '\u{1173}',
    '\u{1174}',
    '\u{1175}',
    '\u{00A2}',
    '\u{00A3}',
    '\u{00AC}',
    '\u{0020}',
    '\u{0304}',
    '\u{00A6}',
    '\u{00A5}',
    '\u{20A9}',
    '\u{2502}',
    '\u{2190}',
    '\u{2191}',
    '\u{2192}',
    '\u{2193}',
    '\u{25A0}',
    '\u{25CB}',
    '\u{02D0}',
    '\u{02D1}',
    '\u{00E6}',
    '\u{0299}',
    '\u{0253}',
    '\u{02A3}',
    '\u{AB66}',
    '\u{02A5}',
    '\u{02A4}',
    '\u{0256}',
    '\u{0257}',
    '\u{1D91}',
    '\u{0258}',
    '\u{025E}',
    '\u{02A9}',
    '\u{0264}',
    '\u{0262}',
    '\u{0260}',
    '\u{029B}',
    '\u{0127}',
    '\u{029C}',
    '\u{0267}',
    '\u{0284}',
    '\u{02AA}',
    '\u{02AB}',
    '\u{026C}',
    '\u{1DF04}',
    '\u{A78E}',
    '\u{026E}',
    '\u{1DF05}',
    '\u{028E}',
    '\u{1DF06}',
    '\u{00F8}',
    '\u{0276}',
    '\u{0277}',
    '\u{0071}',
    '\u{027A}',
    '\u{1DF08}',
    '\u{027D}',
    '\u{027E}',
    '\u{0280}',
    '\u{02A8}',
    '\u{02A6}',
    '\u{AB67}',
    '\u{02A7}',
    '\u{0288}',
    '\u{2C71}',
    '\u{028F}',
    '\u{02A1}',
    '\u{02A2}',
    '\u{0298}',
    '\u{01C0}',
    '\u{01C1}',
    '\u{01C2}',
    '\u{1DF0A}',
    '\u{1DF1E}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0043}',
    '\u{0044}',
    '\u{0047}',
    '\u{004A}',
    '\u{004B}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0066}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004F}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0131}',
    '\u{0237}',
    '\u{0391}',
    '\u{0392}',
    '\u{0393}',
    '\u{0394}',
    '\u{0395}',
    '\u{0396}',
    '\u{0397}',
    '\u{0398}',
    '\u{0399}',
    '\u{039A}',
    '\u{039B}',
    '\u{039C}',
    '\u{039D}',
    '\u{039E}',
    '\u{039F}',
    '\u{03A0}',
    '\u{03A1}',
    '\u{0398}',
    '\u{03A3}',
    '\u{03A4}',
    '\u{03A5}',
    '\u{03A6}',
    '\u{03A7}',
    '\u{03A8}',
    '\u{03A9}',
    '\u{2207}',
    '\u{03B1}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03B5}',
    '\u{03B6}',
    '\u{03B7}',
    '\u{03B8}',
    '\u{03B9}',
    '\u{03BA}',
    '\u{03BB}',
    '\u{03BC}',
    '\u{03BD}',
    '\u{03BE}',
    '\u{03BF}',
    '\u{03C0}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{03C3}',
    '\u{03C4}',
    '\u{03C5}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{03C8}',
    '\u{03C9}',
    '\u{2202}',
    '\u{03B5}',
    '\u{03B8}',
    '\u{03BA}',
    '\u{03C6}',
    '\u{03C1}',
    '\u{03C0}',
    '\u{0391}',
    '\u{0392}',
    '\u{0393}',
    '\u{0394}',
    '\u{0395}',
    '\u{0396}',
    '\u{0397}',
    '\u{0398}',
    '\u{0399}',
    '\u{039A}',
    '\u{039B}',
    '\u{039C}',
    '\u{039D}',
    '\u{039E}',
    '\u{039F}',
    '\u{03A0}',
    '\u{03A1}',
    '\u{0398}',
    '\u{03A3}',
    '\u{03A4}',
    '\u{03A5}',
    '\u{03A6}',
    '\u{03A7}',
    '\u{03A8}',
    '\u{03A9}',
    '\u{2207}',
    '\u{03B1}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03B5}',
    '\u{03B6}',
    '\u{03B7}',
    '\u{03B8}',
    '\u{03B9}',
    '\u{03BA}',
    '\u{03BB}',
    '\u{03BC}',
    '\u{03BD}',
    '\u{03BE}',
    '\u{03BF}',
    '\u{03C0}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{03C3}',
    '\u{03C4}',
    '\u{03C5}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{03C8}',
    '\u{03C9}',
    '\u{2202}',
    '\u{03B5}',
    '\u{03B8}',
    '\u{03BA}',
    '\u{03C6}',
    '\u{03C1}',
    '\u{03C0}',
    '\u{0391}',
    '\u{0392}',
    '\u{0393}',
    '\u{0394}',
    '\u{0395}',
    '\u{0396}',
    '\u{0397}',
    '\u{0398}',
    '\u{0399}',
    '\u{039A}',
    '\u{039B}',
    '\u{039C}',
    '\u{039D}',
    '\u{039E}',
    '\u{039F}',
    '\u{03A0}',
    '\u{03A1}',
    '\u{0398}',
    '\u{03A3}',
    '\u{03A4}',
    '\u{03A5}',
    '\u{03A6}',
    '\u{03A7}',
    '\u{03A8}',
    '\u{03A9}',
    '\u{2207}',
    '\u{03B1}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03B5}',
    '\u{03B6}',
    '\u{03B7}',
    '\u{03B8}',
    '\u{03B9}',
    '\u{03BA}',
    '\u{03BB}',
    '\u{03BC}',
    '\u{03BD}',
    '\u{03BE}',
    '\u{03BF}',
    '\u{03C0}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{03C3}',
    '\u{03C4}',
    '\u{03C5}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{03C8}',
    '\u{03C9}',
    '\u{2202}',
    '\u{03B5}',
    '\u{03B8}',
    '\u{03BA}',
    '\u{03C6}',
    '\u{03C1}',
    '\u{03C0}',
    '\u{0391}',
    '\u{0392}',
    '\u{0393}',
    '\u{0394}',
    '\u{0395}',
    '\u{0396}',
    '\u{0397}',
    '\u{0398}',
    '\u{0399}',
    '\u{039A}',
    '\u{039B}',
    '\u{039C}',
    '\u{039D}',
    '\u{039E}',
    '\u{039F}',
    '\u{03A0}',
    '\u{03A1}',
    '\u{0398}',
    '\u{03A3}',
    '\u{03A4}',
    '\u{03A5}',
    '\u{03A6}',
    '\u{03A7}',
    '\u{03A8}',
    '\u{03A9}',
    '\u{2207}',
    '\u{03B1}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03B5}',
    '\u{03B6}',
    '\u{03B7}',
    '\u{03B8}',
    '\u{03B9}',
    '\u{03BA}',
    '\u{03BB}',
    '\u{03BC}',
    '\u{03BD}',
    '\u{03BE}',
    '\u{03BF}',
    '\u{03C0}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{03C3}',
    '\u{03C4}',
    '\u{03C5}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{03C8}',
    '\u{03C9}',
    '\u{2202}',
    '\u{03B5}',
    '\u{03B8}',
    '\u{03BA}',
    '\u{03C6}',
    '\u{03C1}',
    '\u{03C0}',
    '\u{0391}',
    '\u{0392}',
    '\u{0393}',
    '\u{0394}',
    '\u{0395}',
    '\u{0396}',
    '\u{0397}',
    '\u{0398}',
    '\u{0399}',
    '\u{039A}',
    '\u{039B}',
    '\u{039C}',
    '\u{039D}',
    '\u{039E}',
    '\u{039F}',
    '\u{03A0}',
    '\u{03A1}',
    '\u{0398}',
    '\u{03A3}',
    '\u{03A4}',
    '\u{03A5}',
    '\u{03A6}',
    '\u{03A7}',
    '\u{03A8}',
    '\u{03A9}',
    '\u{2207}',
    '\u{03B1}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03B5}',
    '\u{03B6}',
    '\u{03B7}',
    '\u{03B8}',
    '\u{03B9}',
    '\u{03BA}',
    '\u{03BB}',
    '\u{03BC}',
    '\u{03BD}',
    '\u{03BE}',
    '\u{03BF}',
    '\u{03C0}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{03C3}',
    '\u{03C4}',
    '\u{03C5}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{03C8}',
    '\u{03C9}',
    '\u{2202}',
    '\u{03B5}',
    '\u{03B8}',
    '\u{03BA}',
    '\u{03C6}',
    '\u{03C1}',
    '\u{03C0}',
    '\u{03DC}',
    '\u{03DD}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0430}',
    '\u{0431}',
    '\u{0432}',
    '\u{0433}',
    '\u{0434}',
    '\u{0435}',
    '\u{0436}',
    '\u{0437}',
    '\u{0438}',
    '\u{043A}',
    '\u{043B}',
    '\u{043C}',
    '\u{043E}',
    '\u{043F}',
    '\u{0440}',
    '\u{0441}',
    '\u{0442}',
    '\u{0443}',
    '\u{0444}',
    '\u{0445}',
    '\u{0446}',
    '\u{0447}',
    '\u{0448}',
    '\u{044B}',
    '\u{044D}',
    '\u{044E}',
    '\u{A689}',
    '\u{04D9}',
    '\u{0456}',
    '\u{0458}',
    '\u{04E9}',
    '\u{04AF}',
    '\u{04CF}',
    '\u{0430}',
    '\u{0431}',
    '\u{0432}',
    '\u{0433}',
    '\u{0434}',
    '\u{0435}',
    '\u{0436}',
    '\u{0437}',
    '\u{0438}',
    '\u{043A}',
    '\u{043B}',
    '\u{043E}',
    '\u{043F}',
    '\u{0441}',
    '\u{0443}',
    '\u{0444}',
    '\u{0445}',
    '\u{0446}',
    '\u{0447}',
    '\u{0448}',
    '\u{044A}',
    '\u{044B}',
    '\u{0491}',
    '\u{0456}',
    '\u{0455}',
    '\u{045F}',
    '\u{04AB}',
    '\u{A651}',
    '\u{04B1}',
    '\u{0627}',
    '\u{0628}',
    '\u{062C}',
    '\u{062F}',
    '\u{0648}',
    '\u{0632}',
    '\u{062D}',
    '\u{0637}',
    '\u{064A}',
    '\u{0643}',
    '\u{0644}',
    '\u{0645}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0641}',
    '\u{0635}',
    '\u{0642}',
    '\u{0631}',
    '\u{0634}',
    '\u{062A}',
    '\u{062B}',
    '\u{062E}',
    '\u{0630}',
    '\u{0636}',
    '\u{0638}',
    '\u{063A}',
    '\u{066E}',
    '\u{06BA}',
    '\u{06A1}',
    '\u{066F}',
    '\u{0628}',
    '\u{062C}',
    '\u{0647}',
    '\u{062D}',
    '\u{064A}',
    '\u{0643}',
    '\u{0644}',
    '\u{0645}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0641}',
    '\u{0635}',
    '\u{0642}',
    '\u{0634}',
    '\u{062A}',
    '\u{062B}',
    '\u{062E}',
    '\u{0636}',
    '\u{063A}',
    '\u{062C}',
    '\u{062D}',
    '\u{064A}',
    '\u{0644}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0635}',
    '\u{0642}',
    '\u{0634}',
    '\u{062E}',
    '\u{0636}',
    '\u{063A}',
    '\u{06BA}',
    '\u{066F}',
    '\u{0628}',
    '\u{062C}',
    '\u{0647}',
    '\u{062D}',
    '\u{0637}',
    '\u{064A}',
    '\u{0643}',
    '\u{0645}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0641}',
    '\u{0635}',
    '\u{0642}',
    '\u{0634}',
    '\u{062A}',
    '\u{062B}',
    '\u{062E}',
    '\u{0636}',
    '\u{0638}',
    '\u{063A}',
    '\u{066E}',
    '\u{06A1}',
    '\u{0627}',
    '\u{0628}',
    '\u{062C}',
    '\u{062F}',
    '\u{0647}',
    '\u{0648}',
    '\u{0632}',
    '\u{062D}',
    '\u{0637}',
    '\u{064A}',
    '\u{0644}',
    '\u{0645}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0641}',
    '\u{0635}',
    '\u{0642}',
    '\u{0631}',
    '\u{0634}',
    '\u{062A}',
    '\u{062B}',
    '\u{062E}',
    '\u{0630}',
    '\u{0636}',
    '\u{0638}',
    '\u{063A}',
    '\u{0628}',
    '\u{062C}',
    '\u{062F}',
    '\u{0648}',
    '\u{0632}',
    '\u{062D}',
    '\u{0637}',
    '\u{064A}',
    '\u{0644}',
    '\u{0645}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0641}',
    '\u{0635}',
    '\u{0642}',
    '\u{0631}',
    '\u{0634}',
    '\u{062A}',
    '\u{062B}',
    '\u{062E}',
    '\u{0630}',
    '\u{0636}',
    '\u{0638}',
    '\u{063A}',
    '\u{0030}',
    '\u{002E}',
    '\u{0030}',
    '\u{002C}',
    '\u{0031}',
    '\u{002C}',
    '\u{0032}',
    '\u{002C}',
    '\u{0033}',
    '\u{002C}',
    '\u{0034}',
    '\u{002C}',
    '\u{0035}',
    '\u{002C}',
    '\u{0036}',
    '\u{002C}',
    '\u{0037}',
    '\u{002C}',
    '\u{0038}',
    '\u{002C}',
    '\u{0039}',
    '\u{002C}',
    '\u{0028}',
    '\u{0041}',
    '\u{0029}',
    '\u{0028}',
    '\u{0042}',
    '\u{0029}',
    '\u{0028}',
    '\u{0043}',
    '\u{0029}',
    '\u{0028}',
    '\u{0044}',
    '\u{0029}',
    '\u{0028}',
    '\u{0045}',
    '\u{0029}',
    '\u{0028}',
    '\u{0046}',
    '\u{0029}',
    '\u{0028}',
    '\u{0047}',
    '\u{0029}',
    '\u{0028}',
    '\u{0048}',
    '\u{0029}',
    '\u{0028}',
    '\u{0049}',
    '\u{0029}',
    '\u{0028}',
    '\u{004A}',
    '\u{0029}',
    '\u{0028}',
    '\u{004B}',
    '\u{0029}',
    '\u{0028}',
    '\u{004C}',
    '\u{0029}',
    '\u{0028}',
    '\u{004D}',
    '\u{0029}',
    '\u{0028}',
    '\u{004E}',
    '\u{0029}',
    '\u{0028}',
    '\u{004F}',
    '\u{0029}',
    '\u{0028}',
    '\u{0050}',
    '\u{0029}',
    '\u{0028}',
    '\u{0051}',
    '\u{0029}',
    '\u{0028}',
    '\u{0052}',
    '\u{0029}',
    '\u{0028}',
    '\u{0053}',
    '\u{0029}',
    '\u{0028}',
    '\u{0054}',
    '\u{0029}',
    '\u{0028}',
    '\u{0055}',
    '\u{0029}',
    '\u{0028}',
    '\u{0056}',
    '\u{0029}',
    '\u{0028}',
    '\u{0057}',
    '\u{0029}',
    '\u{0028}',
    '\u{0058}',
    '\u{0029}',
    '\u{0028}',
    '\u{0059}',
    '\u{0029}',
    '\u{0028}',
    '\u{005A}',
    '\u{0029}',
    '\u{3014}',
    '\u{0053}',
    '\u{3015}',
    '\u{0043}',
    '\u{0052}',
    '\u{0043}',
    '\u{0044}',
    '\u{0057}',
    '\u{005A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0048}',
    '\u{0056}',
    '\u{004D}',
    '\u{0056}',
    '\u{0053}',
    '\u{0044}',
    '\u{0053}',
    '\u{0053}',
    '\u{0050}',
    '\u{0050}',
    '\u{0056}',
    '\u{0057}',
    '\u{0043}',
    '\u{004D}',
    '\u{0043}',
    '\u{004D}',
    '\u{0044}',
    '\u{004D}',
    '\u{0052}',
    '\u{0044}',
    '\u{004A}',
    '\u{307B}',
    '\u{304B}',
    '\u{30B3}',
    '\u{30B3}',
    '\u{30B5}',
    '\u{624B}',
    '\u{5B57}',
    '\u{53CC}',
    '\u{30C6}',
    '\u{3099}',
    '\u{4E8C}',
    '\u{591A}',
    '\u{89E3}',
    '\u{5929}',
    '\u{4EA4}',
    '\u{6620}',
    '\u{7121}',
    '\u{6599}',
    '\u{524D}',
    '\u{5F8C}',
    '\u{518D}',
    '\u{65B0}',
    '\u{521D}',
    '\u{7D42}',
    '\u{751F}',
    '\u{8CA9}',
    '\u{58F0}',
    '\u{5439}',
    '\u{6F14}',
    '\u{6295}',
    '\u{6355}',
    '\u{4E00}',
    '\u{4E09}',
    '\u{904A}',
    '\u{5DE6}',
    '\u{4E2D}',
    '\u{53F3}',
    '\u{6307}',
    '\u{8D70}',
    '\u{6253}',
    '\u{7981}',
    '\u{7A7A}',
    '\u{5408}',
    '\u{6E80}',
    '\u{6709}',
    '\u{6708}',
    '\u{7533}',
    '\u{5272}',
    '\u{55B6}',
    '\u{914D}',
    '\u{3014}',
    '\u{672C}',
    '\u{3015}',
    '\u{3014}',
    '\u{4E09}',
    '\u{3015}',
    '\u{3014}',
    '\u{4E8C}',
    '\u{3015}',
    '\u{3014}',
    '\u{5B89}',
    '\u{3015}',
    '\u{3014}',
    '\u{70B9}',
    '\u{3015}',
    '\u{3014}',
    '\u{6253}',
    '\u{3015}',
    '\u{3014}',
    '\u{76D7}',
    '\u{3015}',
    '\u{3014}',
    '\u{52DD}',
    '\u{3015}',
    '\u{3014}',
    '\u{6557}',
    '\u{3015}',
    '\u{5F97}',
    '\u{53EF}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
];
pub(crate) const COMPATIBILITY_DECOMPOSED_SALT: &[u16] = &[
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x16c,
    0xe,
    0x4ef,
    0x2,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x3,
    0x97,
    0x165,
    0x0,
    0x0,
    0x185,
    0x0,
    0x1,
    0x0,
    0x3f4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x91,
    0x0,
    0xdd,
    0x1,
    0x26c,
    0x0,
    0xb,
    0x0,
    0xe0,
    0xbc,
    0x3,
    0x213,
    0x1,
    0x0,
    0xc8,
    0x3,
    0x1c,
    0xfc,
    0x0,
    0x0,
    0x11,
    0x132,
    0x0,
    0x0,
    0x10b,
    0x90,
    0x474,
    0xd6,
    0x0,
    0x0,
    0x3,
    0xd,
    0x5,
    0x0,
    0x6,
    0x19,
    0x54,
    0x132,
    0x4c,
    0x17,
    0x6,
    0x48,
    0x3,
    0x0,
    0x0,
    0x6,
    0xc,
    0x3,
    0x0,
    0xb1,
    0x1,
    0x8c,
    0x0,
    0x1b,
    0xc0,
    0x7,
    0x2,
    0x0,
    0x12,
    0x0,
    0x0,
    0x6,
    0x1,
    0x1be,
    0xc8,
    0x0,
    0x7d,
    0x0,
    0xa,
    0x0,
    0x0,
    0xb4,
    0x2,
    0x8,
    0x5,
    0x144,
    0xdb,
    0x1,
    0x6,
    0x0,
    0x0,
    0xd,
    0x14,
    0x0,
    0x4f,
    0x2,
    0x0,
    0x3,
    0x32,
    0x0,
    0x5,
    0xe,
    0x7c,
    0x2c,
    0x6,
    0x0,
    0x0,
    0x7,
    0x0,
    0x5f,
    0x5,
    0xf,
    0x67,
    0x0,
    0x1,
    0x34,
    0x0,
    0x0,
    0x0,
    0x90,
    0x12,
    0x0,
    0x0,
    0x1e,
    0x4c,
    0x89,
    0xa8,
    0x0,
    0x4,
    0x1f,
    0x0,
    0x0,
    0x1,
    0x99,
    0x18,
    0xd,
    0x3,
    0x7,
    0x5,
    0x19,
    0x2,
    0x0,
    0x4,
    0x1,
    0x3,
    0x90,
    0xb,
    0x29,
    0x55,
    0x0,
    0x51,
    0x0,
    0x2,
    0xd0,
    0x7a,
    0x66,
    0x0,
    0x95,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x8d,
    0xf,
    0x21,
    0x56,
    0xa,
    0x1b,
    0x0,
    0x0,
    0x8,
    0x7,
    0x7c,
    0x5,
    0x0,
    0x62,
    0x2,
    0x13,
    0x6,
    0x0,
    0x4f,
    0x0,
    0x0,
    0x32,
    0x2f,
    0x4,
    0xd,
    0xa0,
    0x4,
    0x8,
    0x24,
    0x1f,
    0x0,
    0x0,
    0x82,
    0x45,
    0x0,
    0x61,
    0x0,
    0x1d,
    0x1,
    0x0,
    0x1,
    0x0,
    0x7,
    0x17,
    0xb,
    0x0,
    0x0,
    0x0,
    0xb,
    0x8,
    0x8,
    0x0,
    0x0,
    0x3d,
    0x0,
    0x96,
    0x0,
    0x0,
    0x0,
    0x8,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x3,
    0x7,
    0x2c,
    0x0,
    0x0,
    0x14,
    0x24,
    0x2,
    0x2,
    0x0,
    0x2,
    0x0,
    0x12,
    0x1,
    0x0,
    0x2,
    0x0,
    0x25,
    0xa,
    0x1,
    0x66,
    0xb,
    0x8,
    0x0,
    0xc,
    0x10,
    0x2,
    0x3,
    0x8,
    0x4,
    0x6,
    0x1,
    0x4,
    0xe3,
    0x23,
    0x20,
    0x7,
    0x0,
    0xf,
    0x1e,
    0x23,
    0x3d,
    0x4,
    0x0,
    0x1,
    0x0,
    0x3,
    0x25,
    0x0,
    0x1,
    0x31,
    0x9d,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x8,
    0x0,
    0x0,
    0x26,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1b,
    0x0,
    0x2,
    0x0,
    0x1,
    0xa,
    0x3,
    0x1,
    0x2,
    0xc,
    0xc,
    0x1,
    0x1,
    0x0,
    0x11,
    0x4,
    0x3d,
    0x2,
    0x1b,
    0x2,
    0x0,
    0xc,
    0x6,
    0x6,
    0x0,
    0x0,
    0x3,
    0x0,
    0x9,
    0x2c,
    0x0,
    0x9,
    0x37,
    0x2d,
    0x0,
    0x12,
    0x23,
    0x0,
    0x0,
    0x1c,
    0x0,
    0x26,
    0x10,
    0x15,
    0x2,
    0x0,
    0xb,
    0x0,
    0x4,
    0x14,
    0x5,
    0x13,
    0x7,
    0x1c,
    0x3,
    0x36,
    0x0,
    0x8,
    0x1,
    0x19,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x4,
    0x1,
    0x8,
    0x2,
    0xa,
    0x6,
    0x13,
    0x0,
    0x0,
    0x0,
    0x2f,
    0x1,
    0x0,
    0x16,
    0x5,
    0xc,
    0xc,
    0x1,
    0x10,
    0x3,
    0xe,
    0x0,
    0x1,
    0xd,
    0x28,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x4,
    0x10,
    0x21,
    0x0,
    0x1,
    0x3,
    0x0,
    0x23,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0xd,
    0x1,
    0x0,
    0x0,
    0x6,
    0x6b,
    0x0,
    0x14,
    0x0,
    0x0,
    0x6,
    0x12,
    0x0,
    0x2,
    0x0,
    0x2a,
    0x1,
    0xb,
    0x1,
    0x6,
    0x9,
    0x8,
    0x1,
    0x0,
    0x2b,
    0x0,
    0x8,
    0x7,
    0x0,
    0xf,
    0x16,
    0x0,
    0x0,
    0x44,
    0x0,
    0x1,
    0x0,
    0x0,
    0xc,
    0x19,
    0x25,
    0x2,
    0x1f,
    0xf,
    0xc,
    0x1,
    0x1f,
    0xa,
    0x0,
    0x38,
    0xe,
    0xf,
    0xc,
    0x25,
    0x0,
    0x6,
    0xe,
    0x0,
    0x8,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x9,
    0x1,
    0x16,
    0x0,
    0x0,
    0x0,
    0x3,
    0x15,
    0x62,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x3d,
    0x0,
    0x3,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x29,
    0x4,
    0x2c,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x22,
    0x0,
    0x14,
    0x28,
    0x0,
    0x7,
    0x4,
    0x3,
    0x6,
    0x0,
    0x1,
    0xd,
    0x2a,
    0x0,
    0x0,
    0x44,
    0x0,
    0x8,
    0x0,
    0x2,
    0x1,
    0xb,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x3,
    0x1c,
    0x5,
    0x0,
    0x6,
    0x2,
    0x0,
    0x11,
    0x6,
    0x7,
    0x0,
    0x2,
    0x28,
    0x7,
    0x1d,
    0xb,
    0x5,
    0x2e,
    0x11,
    0x0,
    0x1,
    0xc,
    0x0,
    0x7,
    0x2f,
    0x0,
    0x0,
    0x5,
    0xa,
    0x0,
    0x8,
    0x6,
    0x0,
    0x0,
    0x7,
    0x1,
    0x8,
    0x20,
    0xc,
    0x0,
    0x1a,
    0x5,
    0x0,
    0x26,
    0x26,
    0x2,
    0xb,
    0x8,
    0x0,
    0x4,
    0x5,
    0x2,
    0x0,
    0x5,
    0x12,
    0x0,
    0x5,
    0x0,
    0x1,
    0x6,
    0x9,
    0x1,
    0x3,
    0x15,
    0x3,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x16,
    0x0,
    0x10,
    0x3,
    0x0,
    0x1b,
    0x2,
    0x0,
    0x9,
    0x0,
    0x9,
    0x0,
    0x9,
    0x0,
    0x0,
    0x1,
    0x1,
    0xc,
    0x26,
    0x1,
    0x0,
    0x0,
    0x4,
    0x0,
    0xc,
    0x1e,
    0x0,
    0x1,
    0x36,
    0x6,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x8,
    0xc,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x4,
    0x2,
    0x7,
    0x1,
    0x2,
    0x7,
    0xd,
    0x2,
    0x0,
    0x0,
    0x0,
    0x2,
    0x5,
    0x0,
    0x8,
    0x5,
    0x0,
    0x0,
    0x3,
    0x6,
    0x0,
    0x0,
    0x8,
    0x1,
    0x5,
    0x1,
    0x3,
    0x3,
    0x10,
    0xb,
    0x7,
    0x0,
    0xf,
    0x11,
    0x0,
    0x18,
    0x0,
    0x0,
    0xf,
    0x2,
    0x7,
    0x1,
    0x0,
    0x0,
    0x0,
    0xc,
    0x18,
    0x0,
    0x17,
    0x0,
    0x1,
    0x0,
    0x26,
    0x3,
    0x0,
    0x1b,
    0x0,
    0x8,
    0x3,
    0x3,
    0x0,
    0x0,
    0x2,
    0x6,
    0x0,
    0xb,
    0x1b,
    0x9,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x5,
    0x0,
    0x6,
    0x0,
    0x4,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x9,
    0x9,
    0x0,
    0x2,
    0x7,
    0xe,
    0x23,
    0x3,
    0x1,
    0x0,
    0x0,
    0xf,
    0x0,
    0x8,
    0x22,
    0xe,
    0x10,
    0x7,
    0x3,
    0xc,
    0x19,
    0x1,
    0xa,
    0x2,
    0x0,
    0x3,
    0x18,
    0x1,
    0x16,
    0xa,
    0x0,
    0x2,
    0x8,
    0x0,
    0x23,
    0x0,
    0x0,
    0x6,
    0x2,
    0x0,
    0x4,
    0xd,
    0x1b,
    0x0,
    0x4,
    0x38,
    0x0,
    0x0,
    0x11,
    0xe,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x21,
    0x13,
    0x2,
    0x18,
    0x4,
    0x1,
    0x10,
    0x0,
    0x2,
    0x0,
    0x6,
    0x14,
    0xa,
    0x0,
    0x0,
    0x4,
    0xe,
    0x0,
    0x0,
    0x5,
    0x4,
    0x0,
    0x20,
    0x1d,
    0x1,
    0x0,
    0x9,
    0x0,
    0x1,
    0x1,
    0x4,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x24,
    0x1,
    0x0,
    0x9,
    0x8,
    0x0,
    0x1,
    0xa,
    0x1,
    0x0,
    0x4,
    0x0,
    0x13,
    0x5,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x4,
    0x0,
    0x0,
    0x5,
    0x1,
    0x9,
    0x2,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xa,
    0x0,
    0x0,
    0x10,
    0x1,
    0x4,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x1,
    0x2,
    0x4,
    0x3,
    0x0,
    0x4,
    0x14,
    0x7,
    0xa,
    0x2,
    0x6,
    0x0,
    0x2,
    0x1,
    0x8,
    0x7,
    0x0,
    0x0,
    0x0,
    0x14,
    0x1,
    0x10,
    0x0,
    0x0,
    0x5,
    0x1,
    0x6,
    0x5,
    0x3,
    0x0,
    0x9,
    0x2,
    0x4,
    0x2,
    0x0,
    0x0,
    0xc,
    0x19,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0xf,
    0x8,
    0xd,
    0x0,
    0x3,
    0x1,
    0x0,
    0x9,
    0x14,
    0x17,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x5,
    0x15,
    0x1,
    0x19,
    0x1,
    0x1,
    0x1,
    0x1,
    0x3,
    0x0,
    0x6,
    0x3,
    0x0,
    0x11,
    0x5,
    0x0,
    0x4,
    0xc,
    0x3,
    0x0,
    0x7,
    0x0,
    0x0,
    0x3,
    0x4,
    0x3,
    0xb,
    0x0,
    0x0,
    0x6,
    0x8,
    0x3,
    0x1,
    0x0,
    0x0,
    0x1,
    0xd,
    0x3,
    0x0,
    0x7,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x9,
    0x1,
    0x0,
    0x2,
    0x1,
    0x9,
    0xa,
    0x8,
    0x1,
    0x7,
    0x3,
    0x0,
    0x3,
    0x0,
    0x0,
    0x4,
    0x0,
    0x4,
    0x1,
    0xb,
    0x0,
    0x13,
    0x6,
    0x7,
    0x0,
    0x0,
    0x8,
    0x7,
    0x7,
    0x0,
    0x3,
    0x0,
    0x2,
    0x3,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1b,
    0x3,
    0x2,
    0x9,
    0x2,
    0x1,
    0x2,
    0x0,
    0x4,
    0x1,
    0x0,
    0x6,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0xf,
    0x1,
    0x6,
    0x8,
    0x4,
    0x0,
    0x0,
    0x3,
    0xb,
    0x2,
    0x5,
    0x1,
    0x2,
    0x13,
    0x13,
    0x0,
    0x9,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x2,
    0x21,
    0x0,
    0x6,
    0x3,
    0x1,
    0x1,
    0x5,
    0x3,
    0x0,
    0x10,
    0x22,
    0xb,
    0x0,
    0x8,
    0x0,
    0x0,
    0x3,
    0x4,
    0x1,
    0x1a,
    0x2,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x12,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x21,
    0x0,
    0x2,
    0xd,
    0x1,
    0x3,
    0x5,
    0x1,
    0xc,
    0x10,
    0x0,
    0x24,
    0x0,
    0x0,
    0x6,
    0x6,
    0x1b,
    0x1,
    0xd,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x7,
    0x2,
    0x0,
    0x5,
    0x24,
    0x6,
    0x1,
    0xe,
    0x0,
    0xb,
    0xe,
    0x7,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x18,
    0x3,
    0x3,
    0x1,
    0x0,
    0x0,
    0x4,
    0x4,
    0x0,
    0x1,
    0x0,
    0x14,
    0x6,
    0xb,
    0x0,
    0x2,
    0x1,
    0x2,
    0x6,
    0x6,
    0x0,
    0x6,
    0x0,
    0x0,
    0x1,
    0x2,
    0x2,
    0x1,
    0x2,
    0x0,
    0x1,
    0x8,
    0x1,
    0xc,
    0x0,
    0x7,
    0x2,
    0x3,
    0x1,
    0x0,
    0x6,
    0x1,
    0x7,
    0x11,
    0x3,
    0x0,
    0x1,
    0xa,
    0x2,
    0x2,
    0x8,
    0x6,
    0x8,
    0x0,
    0x0,
    0x4,
    0x8,
    0x1,
    0x7,
    0x2,
    0x2,
    0x6,
    0x0,
    0x6,
    0x0,
    0x0,
    0x7,
    0x1,
    0xe,
    0x2,
    0x2,
    0x32,
    0x7,
    0xb,
    0x4,
    0x4,
    0x0,
    0x6,
    0x0,
    0x8,
    0x0,
    0x0,
    0x0,
    0x9,
    0x2,
    0x1b,
    0x0,
    0x0,
    0x0,
    0x1,
    0xc,
    0x2,
    0x1,
    0x2,
    0xf,
    0x0,
    0x0,
    0x0,
    0x3,
    0xc,
    0x5,
    0x0,
    0x0,
    0x0,
    0xb,
    0x0,
    0x2,
    0x1,
    0x3,
    0x0,
    0x1,
    0x6,
    0xa,
    0x1,
    0x0,
    0x8,
    0x0,
    0x4,
    0x1,
    0x0,
    0x1,
    0x0,
    0xe,
    0x2,
    0x1,
    0x1,
    0x1,
    0x7,
    0x1,
    0x3,
    0x1,
    0x2,
    0x1,
    0x3,
    0x2,
    0x0,
    0x11,
    0x3,
    0x2,
    0x3,
    0x0,
    0x0,
    0x3,
    0x4,
    0x0,
    0x0,
    0x1,
    0x20,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x7,
    0x2,
    0x0,
    0x12,
    0x0,
    0xa,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x4,
    0xf,
    0x0,
    0x7,
    0x4,
    0x2,
    0x12,
    0x0,
    0x1,
    0x4,
    0x2,
    0x3,
    0x0,
    0x1,
    0x17,
    0x1,
    0x1,
    0x5,
    0x0,
    0x1,
    0x0,
    0x0,
    0xb,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x9,
    0x0,
    0x4,
    0x0,
    0x0,
    0x4,
    0xa,
    0x0,
    0x0,
    0x6,
    0x7,
    0x2,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0xb,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0xc,
    0x8,
    0x1,
    0xd,
    0xb,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x5,
    0x1,
    0x0,
    0x0,
    0x2,
    0x3,
    0x3,
    0x0,
    0x0,
    0x8,
    0x0,
    0x1,
    0x9,
    0x11,
    0x1,
    0xc,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x17,
    0x1,
    0x0,
    0x5,
    0xb,
    0x1,
    0x4,
    0x1,
    0x6,
    0x1d,
    0x0,
    0x1,
    0x4,
    0x2,
    0x9,
    0x2,
    0xf,
    0x14,
    0x2,
    0x1,
    0x7,
    0x1,
    0x1,
    0x7,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x13,
    0x2,
    0x1,
    0x1,
    0x3,
    0x0,
    0x2,
    0x2,
    0x0,
    0x3,
    0x1,
    0x0,
    0x5,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0xa,
    0x6,
    0x1,
    0x6,
    0x7,
    0x1,
    0x0,
    0x0,
    0x2,
    0x7,
    0x4,
    0x0,
    0x0,
    0xc,
    0x2,
    0x0,
    0xa,
    0x1,
    0x0,
    0x0,
    0xa,
    0x0,
    0x6,
    0x3,
    0x1,
    0x0,
    0xd,
    0x3,
    0x5,
    0x0,
    0x2,
    0xa,
    0x0,
    0xb,
    0x1,
    0x6,
    0x22,
    0x0,
    0x5,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x12,
    0x4,
    0x2,
    0x0,
    0x0,
    0xc,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x4,
    0x2,
    0x1,
    0x8,
    0x4,
    0x6,
    0x1,
    0x0,
    0x3,
    0xa,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x6,
    0x0,
    0x0,
    0x3,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0xe,
    0x1,
    0x1,
    0x0,
    0x6,
    0x0,
    0x8,
    0x0,
    0x0,
    0xa,
    0x1,
    0x0,
    0x4,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x17,
    0x4,
    0x0,
    0xb,
    0x3,
    0x5,
    0x4,
    0x0,
    0x3,
    0xf,
    0x6,
    0x1,
    0x1,
    0x7,
    0x4,
    0x3,
    0x1,
    0x3,
    0x4,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x5,
    0x0,
    0x2,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x5,
    0x0,
    0xd,
    0x6,
    0x1,
    0x0,
    0x0,
    0x7,
    0x0,
    0x0,
    0xa,
    0x3,
    0x2,
    0xa,
    0x1,
    0x7,
    0x1,
    0x0,
    0x1,
    0x0,
    0x5,
    0x3,
    0x0,
    0x5,
    0x2,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x4,
    0x9,
    0x5,
    0x1,
    0x1,
    0x6,
    0x0,
    0x9,
    0x1,
    0xa,
    0x2,
    0x2,
    0x0,
    0x0,
    0x2,
    0x2,
    0x7,
    0x9,
    0x0,
    0x10,
    0x1c,
    0x4,
    0x0,
    0x0,
    0x3,
    0x3,
    0xd,
    0x1,
    0x3,
    0x0,
    0x0,
    0xc,
    0x7,
    0x1,
    0x3,
    0x7,
    0x8,
    0x3,
    0x6,
    0x0,
    0x3,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x4,
    0xa,
    0x5,
    0x0,
    0x1,
    0x13,
    0x2,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0xe,
    0x1,
    0xc,
    0x1,
    0x1,
    0x9,
    0x0,
    0x0,
    0x1,
    0xc,
    0x0,
    0x1,
    0x0,
    0x2,
    0x4,
    0x3,
    0x1,
    0xc,
    0xc,
    0x3,
    0x0,
    0xc,
    0xb,
    0x0,
    0x1,
    0x1,
    0xa,
    0x1,
    0xb,
    0x0,
    0x0,
    0x1c,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x8,
    0x3,
    0x0,
    0x5,
    0x0,
    0x3,
    0x3,
    0x0,
    0x4,
    0x0,
    0x2,
    0x6,
    0xf,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x11,
    0xb,
    0x4,
    0x5,
    0x4,
    0x0,
    0xd,
    0x4,
    0x4,
    0x3,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0xa,
    0x1,
    0x13,
    0x6,
    0x0,
    0x7,
    0x7,
    0x1,
    0x1,
    0x4,
    0x4,
    0x0,
    0x0,
    0x3,
    0x0,
    0x7,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x3,
    0x4,
    0x5,
    0x10,
    0x0,
    0x7,
    0x0,
    0xa,
    0x11,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0xb,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0xa,
    0x0,
    0x3,
    0x0,
    0x7,
    0x6,
    0x1,
    0x0,
    0x4,
    0x2,
    0x2,
    0x0,
    0x1,
    0x2,
    0x3,
    0x4,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x2,
    0x10,
    0x5,
    0x0,
    0x0,
    0x1,
    0x0,
    0xa,
    0x4,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x6,
    0xb,
    0xb,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x2,
    0x4,
    0x0,
    0x5,
    0x2,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x4,
    0x6,
    0x1,
    0x4,
    0x1,
    0x0,
    0x1,
    0x7,
    0x0,
    0x6,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x6,
    0x5,
    0x8,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x4,
    0x7,
    0x0,
    0x1,
    0x7,
    0x0,
    0x2,
    0x2,
    0xb,
    0x1,
    0x2,
    0x6,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x4,
    0x0,
    0x0,
    0x3,
    0x1,
    0x7,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0xb,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x1,
    0x0,
    0x4,
    0xc,
    0x2,
    0x0,
    0x1,
    0x1,
    0x2,
    0x4,
    0xe,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x4,
    0x3,
    0x18,
    0x0,
    0x1,
    0x0,
    0x2,
    0x5,
    0x1,
    0x2,
    0x0,
    0x1,
    0x3,
    0x4,
    0x0,
    0x0,
    0x5,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x14,
    0x4,
    0xb,
    0x12,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0xb,
    0x3,
    0x0,
    0x1,
    0x2,
    0x0,
    0x10,
    0xd,
    0x1,
    0x1,
    0x7,
    0x6,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x8,
    0x4,
    0x2,
    0x6,
    0x9,
    0x5,
    0x0,
    0x16,
    0x1,
    0x4,
    0x0,
    0x3,
    0x3,
    0x4,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x2,
    0xd,
    0x2,
    0x0,
    0xb,
    0x6,
    0xa,
    0x3,
    0x0,
    0x5,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x5,
    0x1,
    0x0,
    0xa,
    0x0,
    0x2,
    0x0,
    0x2,
    0x2,
    0x5,
    0x1,
    0x2,
    0x0,
    0x2,
    0x2,
    0x5,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x19,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x1,
    0x5,
    0x4,
    0x1,
    0x4,
    0x0,
    0x1,
    0x3,
    0x4,
    0x6,
    0x1,
    0x1,
    0x4,
    0x3,
    0x4,
    0x0,
    0x4,
    0x5,
    0x9,
    0x0,
    0x1,
    0x9,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0xc,
    0x1,
    0x0,
    0x0,
    0x3,
    0x2,
    0x3,
    0x2,
    0x1,
    0x0,
    0x4,
    0x0,
    0x4,
    0x7,
    0x3,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x5,
    0x6,
    0x9,
    0x0,
    0x2,
    0x1b,
    0x2,
    0x0,
    0x9,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x6,
    0x2,
    0x1,
    0x6,
    0x1,
    0xb,
    0x3,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x3,
    0x3,
    0x5,
    0xb,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0xb,
    0x3,
    0x2,
    0x13,
    0x1,
    0x1,
    0x8,
    0x3,
    0x2,
    0x5,
    0x1,
    0x0,
    0x1,
    0x1,
    0x5,
    0x0,
    0x1,
    0x3,
    0x4,
    0x5,
    0x0,
    0x2,
    0x0,
    0xe,
    0x1,
    0x0,
    0x0,
    0x5,
    0x3,
    0x5,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x8,
    0x0,
    0x1,
    0x2,
    0x0,
    0x9,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x3,
    0x3,
    0x9,
    0x7,
    0x0,
    0x8,
    0x0,
    0x1,
    0x3,
    0x0,
    0x3,
    0x5,
    0x4,
    0x1,
    0x2,
    0x2,
    0x0,
    0x4,
    0x3,
    0x0,
    0x7,
    0x5,
    0x3,
    0x1,
    0x0,
    0x4,
    0x1,
    0x0,
    0x3,
    0x0,
    0x8,
    0x2,
    0x4,
    0x4,
    0x0,
    0x9,
    0x1,
    0x4,
    0x0,
    0x6,
    0x4,
    0x0,
    0x0,
    0x0,
    0xa,
    0x1,
    0x0,
    0x1,
    0x6,
    0x0,
    0x1,
    0x6,
    0x3,
    0x2,
    0x2,
    0x0,
    0x1,
    0x1,
    0x3,
    0x5,
    0x0,
    0x0,
    0x2,
    0x4,
    0x1,
    0x0,
    0x0,
    0x1,
    0x6,
    0x0,
    0x5,
    0x4,
    0x4,
    0x1,
    0x1,
    0x4,
    0x1,
    0x2,
    0x0,
    0x2,
    0x2,
    0x5,
    0xd,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x7,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x9,
    0x2,
    0x4,
    0x0,
    0x0,
    0x1,
    0x0,
    0x3,
    0x0,
    0xa,
    0x0,
    0x3,
    0x1,
    0x5,
    0x1,
    0x0,
    0x0,
    0x5,
    0xa,
    0x1,
    0x2,
    0x0,
    0x2,
    0x4,
    0x9,
    0x1,
    0x4,
    0x5,
    0x0,
    0x0,
    0x1,
    0x3,
    0x9,
    0x2,
    0x4,
    0x8,
    0x2,
    0x0,
    0x0,
    0x3,
    0x8,
    0x0,
    0x0,
    0x2,
    0x1,
    0x3,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x4,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x9,
    0x1,
    0x1,
    0x5,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x2,
    0x0,
    0x4,
    0x2,
    0x4,
    0x2,
    0x2,
    0x0,
    0x1,
    0xa,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x3,
    0x2,
    0x5,
    0x1,
    0x2,
    0x1,
    0x2,
    0x0,
    0x4,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x5,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x7,
    0x1,
    0x1,
    0x3,
    0x0,
    0x3,
    0x1,
    0x1,
    0x0,
    0x9,
    0x2,
    0x0,
    0x1,
    0x1,
    0x7,
    0x6,
    0x2,
    0x0,
    0x6,
    0x0,
    0x4,
    0x0,
    0x2,
    0x7,
    0x4,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x4,
    0x3,
    0x0,
    0xa,
    0x0,
    0x0,
    0x2,
    0x2,
    0x1,
    0x1,
    0x3,
    0x2,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x6,
    0x1,
    0x3,
    0xb,
    0xb,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x2,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x5,
    0x3,
    0x2,
    0x3,
    0x8,
    0x1,
    0x6,
    0x1,
    0x2,
    0x0,
    0x1,
    0x4,
    0x5,
    0x2,
    0x0,
    0x6,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x2,
    0x2,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x2,
    0x0,
    0x5,
    0x2,
    0x2,
    0x6,
    0x1,
    0x5,
    0x3,
    0x2,
    0x5,
    0x2,
    0x1,
    0x1,
    0x0,
    0x4,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x15,
    0x2,
    0x0,
    0x0,
    0x1,
    0x2,
    0x7,
    0x3,
    0x3,
    0x3,
    0x1,
    0x1,
    0x2,
    0x6,
    0x1,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x5,
    0x0,
    0x1,
    0x5,
    0x4,
    0x8,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x1,
    0x1,
    0x0,
    0x0,
    0x4,
    0x3,
    0x1,
    0x4,
    0x0,
    0x4,
    0x0,
    0x2,
    0x2,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0x2,
    0x4,
    0x2,
    0x1,
    0x6,
    0x0,
    0x1,
    0xf,
    0x0,
    0x2,
    0x5,
    0x0,
    0x2,
    0x0,
    0x3,
    0x4,
    0x2,
    0x4,
    0x3,
    0x5,
    0x1,
    0x1,
    0x1,
    0x7,
    0x0,
    0x7,
    0x2,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x3,
    0x0,
    0x1,
    0x2,
    0x7,
    0x1,
    0x7,
    0x3,
    0x1,
    0x0,
    0x2,
    0x2,
    0x0,
    0x5,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x2,
    0x2,
    0x2,
    0x0,
    0x1,
    0x4,
    0x2,
    0x1,
    0x2,
    0x3,
    0x0,
    0x2,
    0x2,
    0x4,
    0x2,
    0x1,
    0x2,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x7,
    0x1,
    0x0,
    0x1,
    0x4,
    0x3,
    0x3,
    0x1,
    0x5,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x6,
    0x1,
    0x0,
    0x2,
    0xd,
    0x1,
    0x0,
    0x0,
    0x4,
    0x0,
    0xf,
    0x2,
    0x0,
    0xa,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x4,
    0x2,
    0x0,
    0x3,
    0x0,
    0x2,
    0x0,
    0x7,
    0x2,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x4,
    0x0,
    0x0,
    0xb,
    0x0,
    0x0,
    0xa,
    0x5,
    0x9,
    0x1,
    0x0,
    0x3,
    0x1,
    0x0,
    0xc,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x1,
    0x3,
    0x2,
    0x0,
    0x7,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x6,
    0x2,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x4,
    0x2,
    0x1,
    0x1,
    0x0,
    0x7,
    0x2,
    0x4,
    0x1,
    0x5,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x2,
    0x3,
    0x8,
    0x1,
    0x6,
    0x2,
    0x1,
    0x1,
    0x0,
    0x3,
    0x5,
    0x0,
    0x2,
    0x1,
    0x1,
    0x3,
    0x0,
    0x3,
    0x7,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1,
    0x6,
    0x5,
    0x0,
    0x5,
    0x4,
    0x0,
    0x0,
    0x3,
    0x1,
    0x2,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x2,
    0x0,
    0x2,
    0x0,
    0x4,
    0x1,
    0x0,
    0x2,
    0x0,
    0x4,
    0x1,
    0x1,
    0x4,
    0x2,
    0x1,
    0x0,
    0x1,
    0x2,
    0x1,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0xb,
    0x2,
    0x0,
    0x0,
    0x3,
    0x3,
    0x5,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x8,
    0x1,
    0x4,
    0x3,
    0x0,
    0x7,
    0x1,
    0x3,
    0x1,
    0x0,
    0x2,
    0x3,
    0x3,
    0x1,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x1,
    0x4,
    0x2,
    0x5,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x1,
    0x2,
    0x1,
    0x3,
    0x1,
    0x0,
    0x5,
    0x2,
    0x4,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x3,
    0x7,
    0x0,
    0x6,
    0x4,
    0x0,
    0x1,
    0x2,
    0x2,
    0x3,
    0x5,
    0x0,
    0x8,
    0x3,
    0x3,
    0x2,
    0x1,
    0x7,
    0x2,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x8,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x6,
    0x7,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x4,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x5,
    0x2,
    0x3,
    0x1,
    0x2,
    0x0,
    0x6,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x3,
    0x0,
    0x2,
    0x7,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x4,
    0x2,
    0x0,
    0x11,
    0x5,
    0x4,
    0x0,
    0x4,
    0x0,
    0x0,
    0x2,
    0x0,
    0x7,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x5,
    0x1,
    0x2,
    0x2,
    0xe,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x1,
    0x2,
    0x1,
    0x0,
    0xa,
    0x1,
    0x4,
    0x0,
    0x5,
    0x1,
    0x1,
    0x1,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x8,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x1,
    0xf,
    0x1,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x5,
    0x7,
    0x2,
    0x2,
    0x6,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x4,
    0x0,
    0x2,
    0x1,
    0x3,
    0x2,
    0x2,
    0x1,
    0x0,
    0x3,
    0x2,
    0x4,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x3,
    0x0,
    0x1,
    0x0,
    0x2,
    0x6,
    0x5,
    0x1,
    0x9,
    0x0,
    0x3,
    0x1,
    0x0,
    0x6,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x2,
    0x2,
    0x0,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x8,
    0x1,
    0x2,
    0x1,
    0x0,
    0x2,
    0x4,
    0x1,
    0x2,
    0x1,
    0x5,
    0x0,
    0x1,
    0x2,
    0x2,
    0x1,
    0x0,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x2,
    0x3,
    0x1,
    0x1,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x5,
    0x0,
    0x2,
    0x6,
    0x1,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xb,
    0x4,
    0x0,
    0x1,
    0x0,
    0x1,
    0x5,
    0x0,
    0x1,
    0x1,
    0x0,
    0x5,
    0x1,
    0x0,
    0x2,
    0x4,
    0x1,
    0x1,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x2,
    0x3,
    0x0,
    0x1,
    0x2,
    0x3,
    0x0,
    0x0,
    0x3,
    0x2,
    0x4,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x3,
    0x0,
    0xd,
    0x2,
    0x0,
    0x3,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x0,
    0x1,
    0x0,
    0x4,
    0xd,
    0x4,
    0x1,
    0x6,
    0x2,
    0x3,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x1,
    0x3,
    0x1,
    0x2,
    0x0,
    0x1,
    0x2,
    0x0,
    0x3,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x1,
    0x3,
    0x2,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x3,
    0x4,
    0x1,
    0x2,
    0x3,
    0x0,
    0x2,
    0x3,
    0x2,
    0x1,
    0x1,
    0x7,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x5,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x2,
    0x0,
    0x1,
    0x3,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x5,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0x3,
    0x5,
    0x5,
    0x0,
    0x1,
    0x3,
    0x1,
    0x2,
    0x0,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x6,
    0x0,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x1,
    0x4,
    0x1,
    0x2,
    0x1,
    0x8,
    0x1,
    0x1,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x1,
    0x7,
    0x1,
    0x0,
    0x6,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x6,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x1,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x3,
    0x8,
    0x7,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x2,
    0x3,
    0x1,
    0x1,
    0x0,
    0x2,
    0x7,
    0x4,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x1,
    0x3,
    0x1,
    0x2,
    0x0,
    0x1,
    0x4,
    0x2,
    0x2,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x6,
    0x8,
    0x5,
    0x1,
    0x0,
    0x8,
    0x0,
    0x6,
    0x1,
    0x0,
    0xc,
    0x3,
    0x5,
    0x0,
    0x2,
    0x1,
    0x5,
    0x1,
    0x1,
    0x4,
    0x3,
    0x1,
    0x1,
    0x5,
    0x6,
    0x1,
    0x2,
    0x7,
    0x3,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x2,
    0x0,
    0x2,
    0x3,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x5,
    0x5,
    0x2,
    0x0,
    0x0,
    0x1,
    0x2,
    0x4,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0x8,
    0x1,
    0x6,
    0x0,
    0x0,
    0x3,
    0x1,
    0x1,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x5,
    0x0,
    0x1,
    0x0,
    0x5,
    0x1,
    0x4,
    0x1,
    0x8,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x1,
    0x0,
    0x1,
    0x2,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x5,
    0x3,
    0x1,
    0x2,
    0x3,
    0x1,
    0xc,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x5,
    0x3,
    0x2,
    0x1,
    0x0,
    0x3,
    0x2,
    0x0,
];
pub(crate) const COMPATIBILITY_DECOMPOSED_KV: &[(u32, (u16, u16))] = &[
    (0x1d5e5, (4752, 1)),
    (0x1d430, (4339, 1)),
    (0xfca0, (3015, 2)),
    (0x1d769, (5138, 1)),
    (0xfe55, (3808, 1)),
    (0xfd72, (3438, 3)),
    (0xb2, (6, 1)),
    (0x333b, (1909, 5)),
    (0xfbae, (2585, 1)),
    (0x1d727, (5072, 1)),
    (0x246d, (573, 2)),
    (0x332c, (1846, 4)),
    (0x1d79a, (5187, 1)),
    (0xfd81, (3483, 3)),
    (0xff07, (4015, 1)),
    (0x1d76b, (5140, 1)),
    (0x2fb1, (1034, 1)),
    (0x1d4ef, (4518, 1)),
    (0x3193, (1179, 1)),
    (0xfbec, (2621, 3)),
    (0x1d410, (4307, 1)),
    (0x2177, (527, 4)),
    (0xfcfa, (3200, 2)),
    (0x1ee8e, (5451, 1)),
    (0xfed8, (3958, 1)),
    (0x32b8, (1568, 2)),
    (0xfb7f, (2536, 1)),
    (0x1d5f4, (4767, 1)),
    (0x33e0, (2351, 2)),
    (0x1e055, (5324, 1)),
    (0xffac, (4180, 1)),
    (0x1e9a, (234, 2)),
    (0xfdf7, (3716, 4)),
    (0x1d493, (4437, 1)),
    (0x2085, (340, 1)),
    (0x2148, (433, 1)),
    (0x1d4e9, (4512, 1)),
    (0x1d73c, (5093, 1)),
    (0x1da8, (210, 1)),
    (0xfeba, (3928, 1)),
    (0x1d48e, (4432, 1)),
    (0x1ee6c, (5422, 1)),
    (0x1d628, (4819, 1)),
    (0x1d6d1, (4986, 1)),
    (0x2130, (413, 1)),
    (0xff6c, (4116, 1)),
    (0x1d7b4, (5213, 1)),
    (0x1da4, (206, 1)),
    (0x1e061, (5336, 1)),
    (0x3224, (1319, 3)),
    (0x3229, (1334, 3)),
    (0x1d7ff, (5286, 1)),
    (0x1d657, (4866, 1)),
    (0xfee9, (3975, 1)),
    (0x32f6, (1659, 1)),
    (0xfc13, (2716, 2)),
    (0x1d46e, (4400, 1)),
    (0x2472, (583, 2)),
    (0x1d6ba, (4963, 1)),
    (0xfd05, (3222, 2)),
    (0x33d7, (2328, 2)),
    (0xfc17, (2724, 2)),
    (0x2170, (513, 1)),
    (0xfd1c, (3268, 2)),
    (0x3382, (2123, 2)),
    (0x1d764, (5133, 1)),
    (0x1ee95, (5458, 1)),
    (0x2f24, (893, 1)),
    (0x32e5, (1642, 1)),
    (0x1d409, (4300, 1)),
    (0x1d43, (157, 1)),
    (0x1d597, (4674, 1)),
    (0x2f81, (986, 1)),
    (0xfc4a, (2826, 2)),
    (0x1d713, (5052, 1)),
    (0x1d7a1, (5194, 1)),
    (0xff74, (4124, 1)),
    (0xff7d, (4133, 1)),
    (0x2483, (638, 4)),
    (0x3323, (1817, 3)),
    (0x1e059, (5328, 1)),
    (0x1d558, (4611, 1)),
    (0xfc37, (2788, 2)),
    (0x2f64, (957, 1)),
    (0xfe58, (3811, 1)),
    (0x32ee, (1651, 1)),
    (0xfc6a, (2902, 2)),
    (0x1d466, (4392, 1)),
    (0x207e, (333, 1)),
    (0x1e050, (5319, 1)),
    (0x1d5ed, (4760, 1)),
    (0xfc97, (2992, 3)),
    (0x1d791, (5178, 1)),
    (0x1d7bd, (5222, 1)),
    (0x314d, (1112, 1)),
    (0x33aa, (2219, 3)),
    (0xfc0c, (2702, 2)),
    (0x2f47, (928, 1)),
    (0x3230, (1355, 3)),
    (0xfdc6, (3684, 3)),
    (0x1d614, (4799, 1)),
    (0x3291, (1522, 1)),
    (0xfe31, (3771, 1)),
    (0x1d706, (5039, 1)),
    (0xfe78, (3842, 2)),
    (0x325a, (1440, 2)),
    (0x2f84, (989, 1)),
    (0xfca1, (3017, 2)),
    (0x24bb, (792, 1)),
    (0x2094, (354, 1)),
    (0x1d4f8, (4527, 1)),
    (0xfcfe, (3208, 2)),
    (0x1d487, (4425, 1)),
    (0x1d6fd, (5030, 1)),
    (0x1d559, (4612, 1)),
    (0x2074, (323, 1)),
    (0x2112, (391, 1)),
    (0xfcd5, (3121, 2)),
    (0x2f06, (863, 1)),
    (0x107ba, (4290, 1)),
    (0xa7f4, (2443, 1)),
    (0x24bf, (796, 1)),
    (0x1d49c, (4446, 1)),
    (0x1d63c, (4839, 1)),
    (0x32a2, (1539, 1)),
    (0x1f220, (5668, 1)),
    (0x1d60f, (4794, 1)),
    (0x32d5, (1626, 1)),
    (0xfcec, (3169, 2)),
    (0xfc49, (2824, 2)),
    (0xfe70, (3830, 2)),
    (0x2f45, (926, 1)),
    (0x33b8, (2258, 2)),
    (0x2e2, (85, 1)),
    (0x2fba, (1043, 1)),
    (0x32c6, (1596, 2)),
    (0x1ee87, (5445, 1)),
    (0xffb3, (4187, 1)),
    (0xfb71, (2522, 1)),
    (0xff0b, (4019, 1)),
    (0xfd26, (3288, 2)),
    (0xfc63, (2881, 3)),
    (0x3131, (1084, 1)),
    (0xff6f, (4119, 1)),
    (0x24b9, (790, 1)),
    (0x32b1, (1554, 2)),
    (0xfda0, (3570, 3)),
    (0x1d72e, (5079, 1)),
    (0x1d64d, (4856, 1)),
    (0xfb8f, (2552, 1)),
    (0x1e03c, (5299, 1)),
    (0xfd39, (3326, 2)),
    (0xfd8b, (3513, 3)),
    (0x1079a, (4259, 1)),
    (0xfb95, (2558, 1)),
    (0x107af, (4280, 1)),
    (0x1f16c, (5642, 2)),
    (0x1d793, (5180, 1)),
    (0x1d437, (4346, 1)),
    (0x3282, (1507, 1)),
    (0xbe, (21, 3)),
    (0x2c7d, (853, 1)),
    (0xfec8, (3942, 1)),
    (0xfc99, (2998, 3)),
    (0x337d, (2111, 2)),
    (0x3290, (1521, 1)),
    (0x2f0d, (870, 1)),
    (0x1d6be, (4967, 1)),
    (0x1d5c6, (4721, 1)),
    (0xff38, (4064, 1)),
    (0xfda9, (3597, 3)),
    (0x1d690, (4923, 1)),
    (0x1d42d, (4336, 1)),
    (0x1d524, (4566, 1)),
    (0x3f5, (108, 1)),
    (0x1d68f, (4922, 1)),
    (0x1d5af, (4698, 1)),
    (0xfd5e, (3378, 3)),
    (0xfef7, (3993, 3)),
    (0x33e8, (2367, 2)),
    (0x1d4cc, (4483, 1)),
    (0x1d42f, (4338, 1)),
    (0xfe10, (3757, 1)),
    (0x1d57e, (4649, 1)),
    (0x107b7, (4287, 1)),
    (0x1d499, (4443, 1)),
    (0x1ee0f, (5363, 1)),
    (0xfc96, (2990, 2)),
    (0x1d4d2, (4489, 1)),
    (0xffe9, (4229, 1)),
    (0xffa5, (4173, 1)),
    (0x3299, (1530, 1)),
    (0x1d5c4, (4719, 1)),
    (0xfe5c, (3815, 1)),
    (0x17f, (34, 1)),
    (0x1d7ea, (5265, 1)),
    (0x1d4b0, (4458, 1)),
    (0x1d5be, (4713, 1)),
    (0x33d9, (2334, 3)),
    (0x32e7, (1644, 1)),
    (0x1d6e2, (5003, 1)),
    (0xffad, (4181, 1)),
    (0xfcae, (3043, 2)),
    (0xfcda, (3131, 2)),
    (0xfc1b, (2732, 2)),
    (0x2f62, (955, 1)),
    (0x320a, (1222, 3)),
    (0x3f9, (109, 1)),
    (0xfdc1, (3669, 3)),
    (0x2f72, (971, 1)),
    (0x316d, (1144, 1)),
    (0x322b, (1340, 3)),
    (0x2157, (457, 3)),
    (0x1d659, (4868, 1)),
    (0x1d3c, (150, 1)),
    (0x333e, (1923, 4)),
    (0x217e, (541, 1)),
    (0x1f11b, (5545, 3)),
    (0x1ee74, (5429, 1)),
    (0x1d458, (4378, 1)),
    (0xfbfa, (2663, 3)),
    (0xfeb3, (3921, 1)),
    (0xfb5f, (2504, 1)),
    (0x2fc9, (1058, 1)),
    (0x315a, (1125, 1)),
    (0x1d4a9, (4452, 1)),
    (0xfd31, (3310, 2)),
    (0x3139, (1092, 1)),
    (0x1db0, (218, 1)),
    (0x1d4f3, (4522, 1)),
    (0xfccf, (3109, 2)),
    (0xfb80, (2537, 1)),
    (0xfc6e, (2910, 2)),
    (0x1d768, (5137, 1)),
    (0x2b6, (68, 1)),
    (0x333a, (1905, 4)),
    (0x1d7c9, (5234, 1)),
    (0x1f13c, (5611, 1)),
    (0x1d6a2, (4941, 1)),
    (0x2006, (281, 1)),
    (0x1d445, (4360, 1)),
    (0x1d763, (5132, 1)),
    (0x1d5fa, (4773, 1)),
    (0x3241, (1406, 3)),
    (0xfe4a, (3795, 2)),
    (0x326d, (1465, 1)),
    (0x1d6c2, (4971, 1)),
    (0xfd7d, (3471, 3)),
    (0x3370, (2080, 3)),
    (0x1d6bb, (4964, 1)),
    (0x1d78f, (5176, 1)),
    (0x1d4e6, (4509, 1)),
    (0xff12, (4026, 1)),
    (0xfb05, (2463, 2)),
    (0x1ee1b, (5375, 1)),
    (0x1d609, (4788, 1)),
    (0xfe79, (3844, 2)),
    (0xfbf6, (2651, 3)),
    (0x1d780, (5161, 1)),
    (0xfd38, (3324, 2)),
    (0x1d4de, (4501, 1)),
    (0x3182, (1165, 1)),
    (0xfe48, (3792, 1)),
    (0xfe5e, (3817, 1)),
    (0x1ee1c, (5376, 1)),
    (0x3319, (1774, 6)),
    (0x323f, (1400, 3)),
    (0x2f03, (860, 1)),
    (0x1d566, (4625, 1)),
    (0xfcf3, (3184, 3)),
    (0x1d581, (4652, 1)),
    (0x1d6eb, (5012, 1)),
    (0x1e047, (5310, 1)),
    (0x3301, (1675, 4)),
    (0x2fa8, (1025, 1)),
    (0x249b, (706, 3)),
    (0xff70, (4120, 1)),
    (0x1f219, (5661, 1)),
    (0x1d441, (4356, 1)),
    (0xfce9, (3163, 2)),
    (0x32cd, (1613, 3)),
    (0x1d70d, (5046, 1)),
    (0xff61, (4105, 1)),
    (0x2496, (691, 3)),
    (0x1d416, (4313, 1)),
    (0x3390, (2154, 2)),
    (0x1d756, (5119, 1)),
    (0x1e04a, (5313, 1)),
    (0xfc6b, (2904, 2)),
    (0xfc50, (2838, 2)),
    (0x1d572, (4637, 1)),
    (0xffce, (4209, 1)),
    (0x2f12, (875, 1)),
    (0xff95, (4157, 1)),
    (0xfb99, (2562, 1)),
    (0xff46, (4078, 1)),
    (0xfdb7, (3639, 3)),
    (0x2156, (454, 3)),
    (0xff52, (4090, 1)),
    (0x1f241, (5699, 3)),
    (0x1d40f, (4306, 1)),
    (0x1d440, (4355, 1)),
    (0x3f1, (105, 1)),
    (0x2078, (327, 1)),
    (0x1d66c, (4887, 1)),
    (0x1f13e, (5613, 1)),
    (0xfc24, (2750, 2)),
    (0xfe96, (3892, 1)),
    (0x1d460, (4386, 1)),
    (0x1d6c9, (4978, 1)),
    (0x3330, (1865, 3)),
    (0x2f95, (1006, 1)),
    (0x1d71e, (5063, 1)),
    (0x1d51e, (4560, 1)),
    (0x10782, (4236, 1)),
    (0xfc26, (2754, 2)),
    (0xfd1e, (3272, 2)),
    (0x2145, (430, 1)),
    (0x327b, (1492, 2)),
    (0xfcbc, (3071, 2)),
    (0xff39, (4065, 1)),
    (0xfc9c, (3007, 2)),
    (0xfe62, (3821, 1)),
    (0x1d41c, (4319, 1)),
    (0x1d691, (4924, 1)),
    (0x1d488, (4426, 1)),
    (0x1ee4f, (5406, 1)),
    (0x1d5e4, (4751, 1)),
    (0x1e03d, (5300, 1)),
    (0xfd55, (3351, 3)),
    (0xfcbd, (3073, 2)),
    (0x3297, (1528, 1)),
    (0x1d5e0, (4747, 1)),
    (0x3192, (1178, 1)),
    (0x32d2, (1623, 1)),
    (0x2f9e, (1015, 1)),
    (0xfd1a, (3264, 2)),
    (0x32e6, (1643, 1)),
    (0x1eeaf, (5477, 1)),
    (0x24d6, (819, 1)),
    (0xfef4, (3986, 1)),
    (0x1ee72, (5428, 1)),
    (0x1d5d3, (4734, 1)),
    (0xfd0c, (3236, 2)),
    (0x1d66b, (4886, 1)),
    (0xff5a, (4098, 1)),
    (0xfe57, (3810, 1)),
    (0xfb6a, (2515, 1)),
    (0x1d44c, (4367, 1)),
    (0x2474, (587, 3)),
    (0xfdb3, (3627, 3)),
    (0xfb92, (2555, 1)),
    (0x2098, (358, 1)),
    (0x1d5a9, (4692, 1)),
    (0x24b6, (787, 1)),
    (0x1d626, (4817, 1)),
    (0xab69, (2450, 1)),
    (0x1d630, (4827, 1)),
    (0xfb6c, (2517, 1)),
    (0x1d76f, (5144, 1)),
    (0x3155, (1120, 1)),
    (0xfe97, (3893, 1)),
    (0x1dbb, (229, 1)),
    (0x33bd, (2268, 2)),
    (0x1d54c, (4600, 1)),
    (0x2124, (408, 1)),
    (0x33d2, (2315, 3)),
    (0x3236, (1373, 3)),
    (0x1f112, (5518, 3)),
    (0x1d37, (146, 1)),
    (0x132, (24, 2)),
    (0x329e, (1535, 1)),
    (0x1d65a, (4869, 1)),
    (0xfdf8, (3720, 4)),
    (0x385, (92, 3)),
    (0x2f71, (970, 1)),
    (0x1ee61, (5415, 1)),
    (0xfe3d, (3783, 1)),
    (0x3153, (1118, 1)),
    (0xfccc, (3103, 2)),
    (0x3203, (1201, 3)),
    (0xfe3f, (3785, 1)),
    (0x1d550, (4604, 1)),
    (0x1d6e9, (5010, 1)),
    (0x1d675, (4896, 1)),
    (0x3f4, (107, 1)),
    (0x1d53e, (4591, 1)),
    (0x315c, (1127, 1)),
    (0x32ac, (1549, 1)),
    (0x24cd, (810, 1)),
    (0xffe6, (4227, 1)),
    (0x3166, (1137, 1)),
    (0x1ee6d, (5423, 1)),
    (0x24d3, (816, 1)),
    (0xffee, (4234, 1)),
    (0x1d777, (5152, 1)),
    (0xff55, (4093, 1)),
    (0x1d5de, (4745, 1)),
    (0x1d593, (4670, 1)),
    (0x1ee2b, (5386, 1)),
    (0x1d486, (4424, 1)),
    (0xfd71, (3435, 3)),
    (0xfef9, (3999, 3)),
    (0x326a, (1462, 1)),
    (0x33d6, (2325, 3)),
    (0x3345, (1947, 3)),
    (0x2d9, (73, 2)),
    (0xfbe4, (2609, 1)),
    (0x3149, (1108, 1)),
    (0x1d40d, (4304, 1)),
    (0x1f235, (5689, 1)),
    (0x1d6de, (4999, 1)),
    (0x677, (116, 2)),
    (0x1d656, (4865, 1)),
    (0x1d3d, (151, 1)),
    (0x1d6f0, (5017, 1)),
    (0xfe34, (3774, 1)),
    (0x1d69c, (4935, 1)),
    (0xfe76, (3838, 2)),
    (0x1daf, (217, 1)),
    (0x1c5, (38, 3)),
    (0x1d739, (5090, 1)),
    (0x33e4, (2359, 2)),
    (0x1d6ed, (5014, 1)),
    (0x1d6d8, (4993, 1)),
    (0xfc81, (2948, 2)),
    (0xfecd, (3947, 1)),
    (0x1d726, (5071, 1)),
    (0x1e051, (5320, 1)),
    (0xfc2c, (2766, 2)),
    (0x1d6f3, (5020, 1)),
    (0xfc3b, (2796, 2)),
    (0xfce7, (3159, 2)),
    (0x33b1, (2244, 2)),
    (0x2161, (484, 2)),
    (0xfe89, (3875, 2)),
    (0x1d63f, (4842, 1)),
    (0x1d5c9, (4724, 1)),
    (0x3266, (1458, 1)),
    (0xfd00, (3212, 2)),
    (0x1d4c, (166, 1)),
    (0x1d7e3, (5258, 1)),
    (0x1d62b, (4822, 1)),
    (0xfdae, (3612, 3)),
    (0x339c, (2182, 2)),
    (0xfc8c, (2970, 2)),
    (0x1d449, (4364, 1)),
    (0xffe2, (4222, 1)),
    (0x222f, (551, 2)),
    (0xfc62, (2878, 3)),
    (0x1d70a, (5043, 1)),
    (0x2fb3, (1036, 1)),
    (0x1f239, (5693, 1)),
    (0x32dc, (1633, 1)),
    (0x1d7ad, (5206, 1)),
    (0x3303, (1684, 3)),
    (0x248b, (664, 2)),
    (0x3168, (1139, 1)),
    (0xfdf0, (3690, 3)),
    (0xff8b, (4147, 1)),
    (0x1d5c1, (4716, 1)),
    (0x320f, (1238, 4)),
    (0x1f145, (5620, 1)),
    (0x1f118, (5536, 3)),
    (0xffa0, (4168, 1)),
    (0x335a, (2022, 2)),
    (0x1d632, (4829, 1)),
    (0x33eb, (2375, 3)),
    (0x2120, (401, 2)),
    (0x24da, (823, 1)),
    (0xff28, (4048, 1)),
    (0xfeaa, (3912, 1)),
    (0x2fad, (1030, 1)),
    (0x20a8, (363, 2)),
    (0x33f3, (2399, 3)),
    (0x32e2, (1639, 1)),
    (0x3318, (1770, 4)),
    (0x1ee35, (5395, 1)),
    (0x1d5cd, (4728, 1)),
    (0x325f, (1450, 2)),
    (0x3365, (2047, 3)),
    (0x1d4f, (168, 1)),
    (0x24e7, (836, 1)),
    (0xfc76, (2926, 2)),
    (0xfedd, (3963, 1)),
    (0xfcca, (3099, 2)),
    (0x208b, (346, 1)),
    (0x1f14e, (5633, 3)),
    (0x1ee89, (5447, 1)),
    (0x217d, (540, 1)),
    (0x1d770, (5145, 1)),
    (0x1d4b8, (4466, 1)),
    (0xfca5, (3025, 2)),
    (0x1d701, (5034, 1)),
    (0x3253, (1426, 2)),
    (0xfe8e, (3884, 1)),
    (0xfc56, (2850, 2)),
    (0x1d469, (4395, 1)),
    (0x3394, (2165, 3)),
    (0xfbe2, (2607, 1)),
    (0x2048, (312, 2)),
    (0xfcf9, (3198, 2)),
    (0xeb3, (122, 2)),
    (0x2fc7, (1056, 1)),
    (0x3376, (2095, 2)),
    (0x10784, (4238, 1)),
    (0x1d6ad, (4950, 1)),
    (0xff80, (4136, 1)),
    (0x1d498, (4442, 1)),
    (0x1f141, (5616, 1)),
    (0x33a5, (2205, 2)),
    (0x1d683, (4910, 1)),
    (0xfdba, (3648, 3)),
    (0x2110, (389, 1)),
    (0x1d6dc, (4997, 1)),
    (0x1d4bf, (4471, 1)),
    (0x1d7d6, (5245, 1)),
    (0x1f226, (5674, 1)),
    (0x1d60d, (4792, 1)),
    (0x2025, (290, 2)),
    (0x1f247, (5717, 3)),
    (0xfe90, (3886, 1)),
    (0x330d, (1721, 4)),
    (0xfb5a, (2499, 1)),
    (0x2fa7, (1024, 1)),
    (0x33bb, (2264, 2)),
    (0x1d70b, (5044, 1)),
    (0x2dd, (81, 2)),
    (0x1d795, (5182, 1)),
    (0x2488, (658, 2)),
    (0xfc4c, (2830, 2)),
    (0x1d599, (4676, 1)),
    (0xfce3, (3151, 2)),
    (0x1d5bb, (4710, 1)),
    (0x2f8c, (997, 1)),
    (0x1d7fe, (5285, 1)),
    (0x1d42c, (4335, 1)),
    (0xff78, (4128, 1)),
    (0x1d67a, (4901, 1)),
    (0x1d72c, (5077, 1)),
    (0xff68, (4112, 1)),
    (0x317a, (1157, 1)),
    (0x1d70f, (5048, 1)),
    (0x32c9, (1602, 3)),
    (0xedd, (126, 2)),
    (0x1d5f1, (4764, 1)),
    (0x1d4c2, (4474, 1)),
    (0xff24, (4044, 1)),
    (0xff9a, (4162, 1)),
    (0x1d671, (4892, 1)),
    (0xffcf, (4210, 1)),
    (0x2f0b, (868, 1)),
    (0x32cc, (1611, 2)),
    (0x1d6fa, (5027, 1)),
    (0x1d616, (4801, 1)),
    (0xfb15, (2471, 2)),
    (0xfee7, (3973, 1)),
    (0xff96, (4158, 1)),
    (0x3d2, (97, 1)),
    (0x1d5d9, (4740, 1)),
    (0x1ffd, (271, 2)),
    (0xfbb1, (2589, 2)),
    (0xfca3, (3021, 2)),
    (0x2f7f, (984, 1)),
    (0x2f42, (923, 1)),
    (0xfc27, (2756, 2)),
    (0x1eea7, (5470, 1)),
    (0x212d, (411, 1)),
    (0x1d35, (144, 1)),
    (0x1e05c, (5331, 1)),
    (0xfcb2, (3051, 2)),
    (0xfc7e, (2942, 2)),
    (0x2f9d, (1014, 1)),
    (0x33f9, (2417, 3)),
    (0x1d606, (4785, 1)),
    (0x1d55b, (4614, 1)),
    (0x1d62f, (4826, 1)),
    (0x2f9f, (1016, 1)),
    (0x1dbc, (230, 1)),
    (0xff3b, (4067, 1)),
    (0x32d8, (1629, 1)),
    (0x1d568, (4627, 1)),
    (0x33e5, (2361, 2)),
    (0x2f82, (987, 1)),
    (0xfea7, (3909, 1)),
    (0x1d55d, (4616, 1)),
    (0x1d4ac, (4455, 1)),
    (0x24b2, (775, 3)),
    (0xfd37, (3322, 2)),
    (0x2f80, (985, 1)),
    (0x1d4df, (4502, 1)),
    (0xfb73, (2524, 1)),
    (0xfdc7, (3687, 3)),
    (0x1d48, (162, 1)),
    (0xfbb0, (2587, 2)),
    (0x1d704, (5037, 1)),
    (0x1d481, (4419, 1)),
    (0x2f5b, (948, 1)),
    (0x1e034, (5291, 1)),
    (0x2b2, (64, 1)),
    (0x1d41d, (4320, 1)),
    (0xfcce, (3107, 2)),
    (0x33a8, (2213, 4)),
    (0x1d6e4, (5005, 1)),
    (0x1d7c7, (5232, 1)),
    (0x32b6, (1564, 2)),
    (0x3218, (1274, 4)),
    (0xfdf9, (3724, 3)),
    (0xfd07, (3226, 2)),
    (0xff69, (4113, 1)),
    (0x3196, (1182, 1)),
    (0x1d7ec, (5267, 1)),
    (0xfcde, (3139, 2)),
    (0x3274, (1478, 2)),
    (0xfd11, (3246, 2)),
    (0xfdb9, (3645, 3)),
    (0xfccd, (3105, 2)),
    (0x2fa2, (1019, 1)),
    (0xfb21, (2478, 1)),
    (0x1d401, (4292, 1)),
    (0x1ee0d, (5361, 1)),
    (0x338d, (2148, 2)),
    (0xfd36, (3320, 2)),
    (0xfc44, (2814, 2)),
    (0x1d573, (4638, 1)),
    (0x327c, (1494, 5)),
    (0x1d787, (5168, 1)),
    (0x2f1d, (886, 1)),
    (0x1d4ca, (4481, 1)),
    (0x2f32, (907, 1)),
    (0x1d443, (4358, 1)),
    (0xfec5, (3939, 1)),
    (0x1f237, (5691, 1)),
    (0xfb9f, (2568, 1)),
    (0x332e, (1855, 6)),
    (0x24cc, (809, 1)),
    (0x2162, (486, 3)),
    (0xffb6, (4190, 1)),
    (0xfb9b, (2564, 1)),
    (0x1fce, (250, 3)),
    (0x318e, (1177, 1)),
    (0x32fa, (1663, 1)),
    (0x32db, (1632, 1)),
    (0xfee5, (3971, 1)),
    (0xfe41, (3787, 1)),
    (0x1d5df, (4746, 1)),
    (0x33f6, (2408, 3)),
    (0x1d585, (4656, 1)),
    (0xfd92, (3528, 3)),
    (0x1d5b, (180, 1)),
    (0x1078a, (4243, 1)),
    (0x337a, (2105, 2)),
    (0xfdc3, (3675, 3)),
    (0x1078e, (4247, 1)),
    (0xff63, (4107, 1)),
    (0xfedf, (3965, 1)),
    (0xfd5c, (3372, 3)),
    (0x1e043, (5306, 1)),
    (0x1d47b, (4413, 1)),
    (0xfe18, (3765, 1)),
    (0x1d7c5, (5230, 1)),
    (0xfbda, (2598, 1)),
    (0x1d59d, (4680, 1)),
    (0x1e058, (5327, 1)),
    (0x216a, (504, 2)),
    (0x1d798, (5185, 1)),
    (0x1ee37, (5397, 1)),
    (0xfc22, (2746, 2)),
    (0x3171, (1148, 1)),
    (0xfd66, (3402, 3)),
    (0x1eea2, (5466, 1)),
    (0xfb88, (2545, 1)),
    (0x1d6b4, (4957, 1)),
    (0x32e3, (1640, 1)),
    (0x208e, (349, 1)),
    (0x3223, (1316, 3)),
    (0x3137, (1090, 1)),
    (0x222c, (546, 2)),
    (0x2f8b, (996, 1)),
    (0x1f11a, (5542, 3)),
    (0xfc4f, (2836, 2)),
    (0x1d52b, (4573, 1)),
    (0xfba5, (2575, 2)),
    (0x1d465, (4391, 1)),
    (0xff50, (4088, 1)),
    (0xff2b, (4051, 1)),
    (0xfc60, (2872, 3)),
    (0x326e, (1466, 2)),
    (0xfb78, (2529, 1)),
    (0x2080, (335, 1)),
    (0xfe37, (3777, 1)),
    (0x1f243, (5705, 3)),
    (0xfb01, (2453, 2)),
    (0x32a1, (1538, 1)),
    (0x1d6d9, (4994, 1)),
    (0x2007, (282, 1)),
    (0x321a, (1282, 4)),
    (0x1d730, (5081, 1)),
    (0xfb7a, (2531, 1)),
    (0x3175, (1152, 1)),
    (0x2136, (418, 1)),
    (0x3355, (2007, 2)),
    (0x32b5, (1562, 2)),
    (0xfe3b, (3781, 1)),
    (0xfd2a, (3296, 2)),
    (0x24ad, (760, 3)),
    (0x1d471, (4403, 1)),
    (0x3272, (1474, 2)),
    (0x1d77b, (5156, 1)),
    (0xfd68, (3408, 3)),
    (0x1d65d, (4872, 1)),
    (0x1f138, (5607, 1)),
    (0x1e066, (5341, 1)),
    (0x217c, (539, 1)),
    (0x1d586, (4657, 1)),
    (0x1d785, (5166, 1)),
    (0x1d73d, (5094, 1)),
    (0xfd53, (3345, 3)),
    (0x208c, (347, 1)),
    (0x3326, (1827, 3)),
    (0x1d517, (4554, 1)),
    (0x1ee6f, (5425, 1)),
    (0xfcb0, (3047, 2)),
    (0xfe19, (3766, 3)),
    (0xfb25, (2482, 1)),
    (0xff3c, (4068, 1)),
    (0xfc7f, (2944, 2)),
    (0x1d680, (4907, 1)),
    (0xff47, (4079, 1)),
    (0x3361, (2036, 2)),
    (0x1d5e7, (4754, 1)),
    (0x1e031, (5288, 1)),
    (0x10791, (4250, 1)),
    (0x1f125, (5575, 3)),
    (0x1d716, (5055, 1)),
    (0xfe11, (3758, 1)),
    (0x1d7cb, (5236, 1)),
    (0x316a, (1141, 1)),
    (0x1f16a, (5638, 2)),
    (0x1d7af, (5208, 1)),
    (0xfc2b, (2764, 2)),
    (0xff1e, (4038, 1)),
    (0x2fa6, (1023, 1)),
    (0xfd6c, (3420, 3)),
    (0x2116, (394, 2)),
    (0x3327, (1830, 2)),
    (0xfc21, (2744, 2)),
    (0x1d30, (139, 1)),
    (0x1d6fe, (5031, 1)),
    (0xfc3c, (2798, 2)),
    (0xfbf7, (2654, 3)),
    (0x1d66e, (4889, 1)),
    (0xfe36, (3776, 1)),
    (0x1d600, (4779, 1)),
    (0x32c4, (1592, 2)),
    (0xfcee, (3173, 2)),
    (0xfea8, (3910, 1)),
    (0x1d7cf, (5238, 1)),
    (0x1e05d, (5332, 1)),
    (0x1d682, (4909, 1)),
    (0x2498, (697, 3)),
    (0xfedc, (3962, 1)),
    (0x1d6ec, (5013, 1)),
    (0x2f1e, (887, 1)),
    (0x1d69d, (4936, 1)),
    (0xfc55, (2848, 2)),
    (0x1ee97, (5460, 1)),
    (0x1d5bf, (4714, 1)),
    (0x207f, (334, 1)),
    (0x1eeb4, (5482, 1)),
    (0xfc38, (2790, 2)),
    (0x1da7, (209, 1)),
    (0x1d705, (5038, 1)),
    (0x1d720, (5065, 1)),
    (0x215b, (469, 3)),
    (0x1d4fc, (4531, 1)),
    (0x1e03f, (5302, 1)),
    (0x1d59a, (4677, 1)),
    (0xfcfd, (3206, 2)),
    (0x10781, (4235, 1)),
    (0x2f9c, (1013, 1)),
    (0x1d5b3, (4702, 1)),
    (0x1d7a4, (5197, 1)),
    (0x107a7, (4272, 1)),
    (0xfb90, (2553, 1)),
    (0x1d490, (4434, 1)),
    (0x1d543, (4595, 1)),
    (0x2f6a, (963, 1)),
    (0x3366, (2050, 3)),
    (0x1d414, (4311, 1)),
    (0x1d633, (4830, 1)),
    (0x335f, (2032, 2)),
    (0x32a8, (1545, 1)),
    (0x33cf, (2309, 2)),
    (0xfefc, (4007, 2)),
    (0x1d6a3, (4942, 1)),
    (0xffba, (4194, 1)),
    (0x1078d, (4246, 1)),
    (0x1d6c4, (4973, 1)),
    (0x1e044, (5307, 1)),
    (0x1d4aa, (4453, 1)),
    (0x1d595, (4672, 1)),
    (0x3331, (1868, 3)),
    (0x1d7f7, (5278, 1)),
    (0x1d6fb, (5028, 1)),
    (0x1d49, (163, 1)),
    (0x1d49e, (4447, 1)),
    (0x1d411, (4308, 1)),
    (0x2107, (380, 1)),
    (0x205f, (320, 1)),
    (0x1e038, (5295, 1)),
    (0xfb4f, (2487, 2)),
    (0x1ee9a, (5463, 1)),
    (0x1d43c, (4351, 1)),
    (0x32ad, (1550, 1)),
    (0x1d468, (4394, 1)),
    (0x3184, (1167, 1)),
    (0x3162, (1133, 1)),
    (0x2f69, (962, 1)),
    (0xfe81, (3859, 2)),
    (0x1ee05, (5353, 1)),
    (0xfea5, (3907, 1)),
    (0x32ba, (1572, 2)),
    (0x32f0, (1653, 1)),
    (0x1d7d9, (5248, 1)),
    (0x1d4c0, (4472, 1)),
    (0xfea3, (3905, 1)),
    (0x321d, (1294, 7)),
    (0x1d6c7, (4976, 1)),
    (0x1fcf, (253, 3)),
    (0x33bf, (2272, 2)),
    (0x1d718, (5057, 1)),
    (0x10790, (4249, 1)),
    (0x1d501, (4536, 1)),
    (0x1d610, (4795, 1)),
    (0x32e0, (1637, 1)),
    (0xfd21, (3278, 2)),
    (0x1d6db, (4996, 1)),
    (0x1f13d, (5612, 1)),
    (0x3038, (1073, 1)),
    (0x33a7, (2210, 3)),
    (0xfd25, (3286, 2)),
    (0x1d7e1, (5256, 1)),
    (0xffbd, (4197, 1)),
    (0x1ee8c, (5449, 1)),
    (0x1ee08, (5356, 1)),
    (0x33c3, (2282, 2)),
    (0x1d51a, (4557, 1)),
    (0x32bf, (1582, 2)),
    (0x249e, (715, 3)),
    (0x33c8, (2295, 2)),
    (0x1f210, (5651, 1)),
    (0x2179, (533, 1)),
    (0x3222, (1313, 3)),
    (0x1d782, (5163, 1)),
    (0x10789, (4242, 1)),
    (0x3305, (1692, 3)),
    (0xfe3a, (3780, 1)),
    (0x1d631, (4828, 1)),
    (0x3199, (1185, 1)),
    (0xffd4, (4213, 1)),
    (0x209c, (362, 1)),
    (0x3247, (1418, 1)),
    (0xfc88, (2962, 2)),
    (0xffb9, (4193, 1)),
    (0x1d46c, (4398, 1)),
    (0x1d636, (4833, 1)),
    (0x315f, (1130, 1)),
    (0xfb8b, (2548, 1)),
    (0xb5, (10, 1)),
    (0x1d419, (4316, 1)),
    (0xfed5, (3955, 1)),
    (0x1d6ca, (4979, 1)),
    (0x339e, (2186, 2)),
    (0x1d641, (4844, 1)),
    (0x1d6af, (4952, 1)),
    (0x3288, (1513, 1)),
    (0x2154, (448, 3)),
    (0xfe8d, (3883, 1)),
    (0x1d40b, (4302, 1)),
    (0x1d607, (4786, 1)),
    (0xff26, (4046, 1)),
    (0x1d758, (5121, 1)),
    (0xfc4e, (2834, 2)),
    (0x3364, (2044, 3)),
    (0x1d4f5, (4524, 1)),
    (0x2fc6, (1055, 1)),
    (0x1d5dc, (4743, 1)),
    (0xfc5e, (2866, 3)),
    (0xff36, (4062, 1)),
    (0x24c5, (802, 1)),
    (0x1d587, (4658, 1)),
    (0x2091, (351, 1)),
    (0x1d750, (5113, 1)),
    (0x24b0, (769, 3)),
    (0x1f122, (5566, 3)),
    (0x3339, (1902, 3)),
    (0x1e054, (5323, 1)),
    (0x1d511, (4549, 1)),
    (0x3335, (1887, 3)),
    (0xffaa, (4178, 1)),
    (0x1f240, (5696, 3)),
    (0x1d612, (4797, 1)),
    (0x1d553, (4606, 1)),
    (0x1d5aa, (4693, 1)),
    (0xaa, (3, 1)),
    (0xff62, (4106, 1)),
    (0x24de, (827, 1)),
    (0x1d7e2, (5257, 1)),
    (0xfe6a, (3828, 1)),
    (0x2f6f, (968, 1)),
    (0xfd59, (3363, 3)),
    (0x1f1, (56, 2)),
    (0x1d33, (142, 1)),
    (0x1078f, (4248, 1)),
    (0x1d536, (4584, 1)),
    (0x2f0a, (867, 1)),
    (0x3244, (1415, 1)),
    (0x246e, (575, 2)),
    (0xfc85, (2956, 2)),
    (0x32f3, (1656, 1)),
    (0x1fbf4, (5729, 1)),
    (0x1d643, (4846, 1)),
    (0xfba0, (2569, 1)),
    (0x1db1, (219, 1)),
    (0x1d457, (4377, 1)),
    (0x1d7d7, (5246, 1)),
    (0x3172, (1149, 1)),
    (0x33b2, (2246, 2)),
    (0x107aa, (4275, 1)),
    (0x2f16, (879, 1)),
    (0x1d731, (5082, 1)),
    (0x1d725, (5070, 1)),
    (0xfbf4, (2645, 3)),
    (0x33f5, (2405, 3)),
    (0x339d, (2184, 2)),
    (0xfcc4, (3087, 2)),
    (0xfc1c, (2734, 2)),
    (0xff11, (4025, 1)),
    (0x1d76d, (5142, 1)),
    (0x1d61c, (4807, 1)),
    (0x1d733, (5084, 1)),
    (0x1d5c7, (4722, 1)),
    (0xff81, (4137, 1)),
    (0x2122, (406, 2)),
    (0x1d4ae, (4456, 1)),
    (0x1f21d, (5665, 1)),
    (0x1d47f, (4417, 1)),
    (0x1d757, (5120, 1)),
    (0xbc, (15, 3)),
    (0x1d621, (4812, 1)),
    (0xffe4, (4225, 1)),
    (0xfec9, (3943, 1)),
    (0x1ee84, (5442, 1)),
    (0xfd98, (3546, 3)),
    (0x3161, (1132, 1)),
    (0x213f, (428, 1)),
    (0x1d9e, (200, 1)),
    (0x1d619, (4804, 1)),
    (0x1d4d6, (4493, 1)),
    (0x1d5c0, (4715, 1)),
    (0x2f7b, (980, 1)),
    (0x1ee0b, (5359, 1)),
    (0x1d746, (5103, 1)),
    (0xfceb, (3167, 2)),
    (0xfef3, (3985, 1)),
    (0xfcf4, (3187, 3)),
    (0xfe7a, (3846, 2)),
    (0x215c, (472, 3)),
    (0x1d4fd, (4532, 1)),
    (0xfba7, (2578, 1)),
    (0xfd3c, (3332, 2)),
    (0x1d46a, (4396, 1)),
    (0x2163, (489, 2)),
    (0x1ee64, (5417, 1)),
    (0x1d692, (4925, 1)),
    (0x1d648, (4851, 1)),
    (0x1d482, (4420, 1)),
    (0x1d576, (4641, 1)),
    (0x1d717, (5056, 1)),
    (0xfe30, (3769, 2)),
    (0x1f232, (5686, 1)),
    (0xfc77, (2928, 2)),
    (0x1d668, (4883, 1)),
    (0x2146, (431, 1)),
    (0xa8, (1, 2)),
    (0xfb93, (2556, 1)),
    (0x1d5ef, (4762, 1)),
    (0xfbfd, (2670, 1)),
    (0x107ab, (4276, 1)),
    (0x1e063, (5338, 1)),
    (0x1d470, (4402, 1)),
    (0x3356, (2009, 6)),
    (0x1d4c5, (4476, 1)),
    (0xfbe7, (2612, 1)),
    (0x24ea, (839, 1)),
    (0x1d519, (4556, 1)),
    (0x1d654, (4863, 1)),
    (0x2f6d, (966, 1)),
    (0x1d518, (4555, 1)),
    (0x1d639, (4836, 1)),
    (0xfd52, (3342, 3)),
    (0x1d79f, (5192, 1)),
    (0x1d775, (5150, 1)),
    (0x3371, (2083, 3)),
    (0x1e048, (5311, 1)),
    (0x1d7ce, (5237, 1)),
    (0xff65, (4109, 1)),
    (0x33a0, (2191, 3)),
    (0x313e, (1097, 1)),
    (0x1d60a, (4789, 1)),
    (0x1d591, (4668, 1)),
    (0x1e04d, (5316, 1)),
    (0x1d5c5, (4720, 1)),
    (0x327a, (1490, 2)),
    (0x1d68, (193, 1)),
    (0xff71, (4121, 1)),
    (0x1d42e, (4337, 1)),
    (0x1d77a, (5155, 1)),
    (0xfe44, (3790, 1)),
    (0x1f132, (5601, 1)),
    (0x1d5f6, (4769, 1)),
    (0x1d77c, (5157, 1)),
    (0x1d66f, (4890, 1)),
    (0x1d7f5, (5276, 1)),
    (0xfcd7, (3125, 2)),
    (0x3188, (1171, 1)),
    (0x1d7a0, (5193, 1)),
    (0xfbe5, (2610, 1)),
    (0xff8d, (4149, 1)),
    (0x107a1, (4266, 1)),
    (0x1d44e, (4369, 1)),
    (0x1d528, (4570, 1)),
    (0x2fc4, (1053, 1)),
    (0x2024, (289, 1)),
    (0x10fc, (135, 1)),
    (0xfdb0, (3618, 3)),
    (0xfcb4, (3055, 2)),
    (0x330c, (1717, 4)),
    (0x316b, (1142, 1)),
    (0x1f111, (5515, 3)),
    (0x2fb8, (1041, 1)),
    (0x3385, (2129, 2)),
    (0x1da9, (211, 1)),
    (0x1d73a, (5091, 1)),
    (0x3293, (1524, 1)),
    (0x1d4cf, (4486, 1)),
    (0x32d6, (1627, 1)),
    (0x338b, (2144, 2)),
    (0x314a, (1109, 1)),
    (0x1f14d, (5631, 2)),
    (0x1e9b, (236, 2)),
    (0x1d64a, (4853, 1)),
    (0x1d7da, (5249, 1)),
    (0xfb17, (2475, 2)),
    (0x1d761, (5130, 1)),
    (0x2097, (357, 1)),
    (0x1fc0, (242, 2)),
    (0x33e3, (2357, 2)),
    (0x1d6b3, (4956, 1)),
    (0x1d5b4, (4703, 1)),
    (0xfd17, (3258, 2)),
    (0xfc2a, (2762, 2)),
    (0x1d76a, (5139, 1)),
    (0x1d68a, (4917, 1)),
    (0x1e039, (5296, 1)),
    (0xfbe9, (2614, 1)),
    (0x1f107, (5504, 2)),
    (0x107a4, (4269, 1)),
    (0x216d, (510, 1)),
    (0x2092, (352, 1)),
    (0xff3d, (4069, 1)),
    (0x107b3, (4283, 1)),
    (0x2f51, (938, 1)),
    (0xfc59, (2856, 2)),
    (0x1d529, (4571, 1)),
    (0x3237, (1376, 3)),
    (0x3215, (1262, 4)),
    (0x2465, (561, 1)),
    (0x1d735, (5086, 1)),
    (0x107b9, (4289, 1)),
    (0xfed3, (3953, 1)),
    (0x203c, (306, 2)),
    (0x2f9b, (1012, 1)),
    (0x2f66, (959, 1)),
    (0xfd75, (3447, 3)),
    (0x1d634, (4831, 1)),
    (0xe33, (120, 2)),
    (0x1dba, (228, 1)),
    (0xfd5a, (3366, 3)),
    (0x2494, (685, 3)),
    (0x315d, (1128, 1)),
    (0x1d509, (4543, 1)),
    (0x1d797, (5184, 1)),
    (0x334f, (1986, 3)),
    (0x1d7fb, (5282, 1)),
    (0x2463, (559, 1)),
    (0xff02, (4010, 1)),
    (0xfb61, (2506, 1)),
    (0x33ec, (2378, 3)),
    (0x1d5f7, (4770, 1)),
    (0x33ae, (2231, 5)),
    (0xfc89, (2964, 2)),
    (0x1d738, (5089, 1)),
    (0x1e030, (5287, 1)),
    (0x1f22a, (5678, 1)),
    (0x2f4b, (932, 1)),
    (0x3302, (1679, 5)),
    (0x1d4d, (167, 1)),
    (0x1d4d7, (4494, 1)),
    (0xfc4d, (2832, 2)),
    (0x1d4e5, (4508, 1)),
    (0x1d542, (4594, 1)),
    (0x3336, (1890, 5)),
    (0x2fb6, (1039, 1)),
    (0x2fa1, (1018, 1)),
    (0x1d71a, (5059, 1)),
    (0xfca4, (3023, 2)),
    (0x1d618, (4803, 1)),
    (0xfcc2, (3083, 2)),
    (0x1dac, (214, 1)),
    (0xfcb8, (3063, 2)),
    (0xfb7c, (2533, 1)),
    (0x317f, (1162, 1)),
    (0x1d7e0, (5255, 1)),
    (0xffc6, (4203, 1)),
    (0x3150, (1115, 1)),
    (0x3276, (1482, 2)),
    (0x328d, (1518, 1)),
    (0x32bc, (1576, 2)),
    (0x133, (26, 2)),
    (0x1f245, (5711, 3)),
    (0x213e, (427, 1)),
    (0xfb66, (2511, 1)),
    (0x2f89, (994, 1)),
    (0x1f12e, (5597, 2)),
    (0x1d4f1, (4520, 1)),
    (0xfc91, (2980, 2)),
    (0xff53, (4091, 1)),
    (0x3306, (1695, 3)),
    (0x2473, (585, 2)),
    (0x1dae, (216, 1)),
    (0xfbac, (2583, 1)),
    (0x33b4, (2250, 2)),
    (0x3214, (1258, 4)),
    (0x32c2, (1588, 2)),
    (0x24ca, (807, 1)),
    (0x1d533, (4581, 1)),
    (0x33f8, (2414, 3)),
    (0xff44, (4076, 1)),
    (0x1d4f7, (4526, 1)),
    (0x1078c, (4245, 1)),
    (0xffca, (4205, 1)),
    (0xfe17, (3764, 1)),
    (0xfbe1, (2606, 1)),
    (0xfc32, (2778, 2)),
    (0x1d625, (4816, 1)),
    (0x140, (30, 2)),
    (0xfeab, (3913, 1)),
    (0x1d6d3, (4988, 1)),
    (0x1d7a8, (5201, 1)),
    (0xfb5d, (2502, 1)),
    (0x3220, (1307, 3)),
    (0x24a5, (736, 3)),
    (0x1d4b3, (4461, 1)),
    (0x107ad, (4278, 1)),
    (0x3399, (2176, 2)),
    (0x2f36, (911, 1)),
    (0xfc74, (2922, 2)),
    (0x1d5a5, (4688, 1)),
    (0x2fc3, (1052, 1)),
    (0x1e06c, (5347, 1)),
    (0x32d9, (1630, 1)),
    (0x1d544, (4596, 1)),
    (0x3221, (1310, 3)),
    (0x1d512, (4550, 1)),
    (0xfece, (3948, 1)),
    (0xfcf7, (3194, 2)),
    (0xfb82, (2539, 1)),
    (0x1d6b8, (4961, 1)),
    (0x3194, (1180, 1)),
    (0xffe5, (4226, 1)),
    (0x32e8, (1645, 1)),
    (0x24af, (766, 3)),
    (0x1fbf1, (5726, 1)),
    (0xfbfc, (2669, 1)),
    (0xb3, (7, 1)),
    (0x24c6, (803, 1)),
    (0x1d749, (5106, 1)),
    (0xfd9a, (3552, 3)),
    (0x1d4b5, (4463, 1)),
    (0xfede, (3964, 1)),
    (0x1d6e7, (5008, 1)),
    (0x2f48, (929, 1)),
    (0x1d4e3, (4506, 1)),
    (0x1eea6, (5469, 1)),
    (0x2f97, (1008, 1)),
    (0x24a8, (745, 3)),
    (0x1d562, (4621, 1)),
    (0x2102, (371, 1)),
    (0x1d61b, (4806, 1)),
    (0x3176, (1153, 1)),
    (0x1d60, (185, 1)),
    (0x1d698, (4931, 1)),
    (0xfed9, (3959, 1)),
    (0x1d61f, (4810, 1)),
    (0x1ee6a, (5421, 1)),
    (0xfd09, (3230, 2)),
    (0x1d561, (4620, 1)),
    (0x1d4e1, (4504, 1)),
    (0x1d7f4, (5275, 1)),
    (0x2f68, (961, 1)),
    (0x1eeb3, (5481, 1)),
    (0x1e062, (5337, 1)),
    (0x2fbe, (1047, 1)),
    (0x2047, (310, 2)),
    (0xff23, (4043, 1)),
    (0xfe77, (3840, 2)),
    (0x1d75b, (5124, 1)),
    (0x1d4b9, (4467, 1)),
    (0x33ba, (2262, 2)),
    (0x2482, (634, 4)),
    (0xffb0, (4184, 1)),
    (0x3164, (1135, 1)),
    (0x24d1, (814, 1)),
    (0x24db, (824, 1)),
    (0x1d5bc, (4711, 1)),
    (0x3396, (2170, 2)),
    (0x1d590, (4667, 1)),
    (0x1d5da, (4741, 1)),
    (0x1d454, (4375, 1)),
    (0x1ee24, (5382, 1)),
    (0x2134, (416, 1)),
    (0x1d7a5, (5198, 1)),
    (0x1e056, (5325, 1)),
    (0x32f7, (1660, 1)),
    (0xfe72, (3834, 2)),
    (0x1e04c, (5315, 1)),
    (0xfef0, (3982, 1)),
    (0x2f0f, (872, 1)),
    (0x2f88, (993, 1)),
    (0x1d4cd, (4484, 1)),
    (0x1d54b, (4599, 1)),
    (0x1d7ba, (5219, 1)),
    (0x1fbf, (240, 2)),
    (0xffeb, (4231, 1)),
    (0x1d5ee, (4761, 1)),
    (0xff72, (4122, 1)),
    (0x1f218, (5660, 1)),
    (0x3234, (1367, 3)),
    (0x1d7ef, (5270, 1)),
    (0x1d425, (4328, 1)),
    (0x1d6ce, (4983, 1)),
    (0x1ee83, (5441, 1)),
    (0x1e04f, (5318, 1)),
    (0x1d483, (4421, 1)),
    (0xff73, (4123, 1)),
    (0xff1c, (4036, 1)),
    (0x33f2, (2396, 3)),
    (0x217b, (536, 3)),
    (0x2004, (279, 1)),
    (0x1d6a4, (4943, 1)),
    (0x326f, (1468, 2)),
    (0xfc57, (2852, 2)),
    (0x32f2, (1655, 1)),
    (0x1d646, (4849, 1)),
    (0x1d412, (4309, 1)),
    (0x249a, (703, 3)),
    (0x1f127, (5581, 3)),
    (0x330b, (1714, 3)),
    (0xfc5c, (2862, 2)),
    (0x2f46, (927, 1)),
    (0x1d40a, (4301, 1)),
    (0x24d8, (821, 1)),
    (0x1d77e, (5159, 1)),
    (0xfd3a, (3328, 2)),
    (0x1d64, (189, 1)),
    (0x315e, (1129, 1)),
    (0x319d, (1189, 1)),
    (0x1ee3b, (5399, 1)),
    (0xfb26, (2483, 1)),
    (0x1d4fe, (4533, 1)),
    (0x2480, (626, 4)),
    (0x216e, (511, 1)),
    (0x1e03b, (5298, 1)),
    (0x1d6b6, (4959, 1)),
    (0xbd, (18, 3)),
    (0x1d42, (156, 1)),
    (0x24a1, (724, 3)),
    (0x33df, (2348, 3)),
    (0xffb5, (4189, 1)),
    (0x1e042, (5305, 1)),
    (0xfc9a, (3001, 3)),
    (0x1d5eb, (4758, 1)),
    (0xfcbf, (3077, 2)),
    (0xfd58, (3360, 3)),
    (0x2464, (560, 1)),
    (0xfe3c, (3782, 1)),
    (0x3246, (1417, 1)),
    (0x2a0c, (840, 4)),
    (0xfdb4, (3630, 3)),
    (0xfd96, (3540, 3)),
    (0x1d407, (4298, 1)),
    (0x3257, (1434, 2)),
    (0x207a, (329, 1)),
    (0x3d5, (102, 1)),
    (0x336b, (2065, 3)),
    (0x32d0, (1621, 1)),
    (0x1eeae, (5476, 1)),
    (0x1d5d5, (4736, 1)),
    (0x1eead, (5475, 1)),
    (0x2f1a, (883, 1)),
    (0xfee0, (3966, 1)),
    (0x2fa3, (1020, 1)),
    (0x1eeb2, (5480, 1)),
    (0xfbf5, (2648, 3)),
    (0x1e067, (5342, 1)),
    (0x3174, (1151, 1)),
    (0xfbe0, (2605, 1)),
    (0x1ee51, (5407, 1)),
    (0xff3f, (4071, 1)),
    (0x3165, (1136, 1)),
    (0x323d, (1394, 3)),
    (0x1d72d, (5078, 1)),
    (0x1d79b, (5188, 1)),
    (0x1d4b6, (4464, 1)),
    (0xfc54, (2846, 2)),
    (0x2fb0, (1033, 1)),
    (0x3228, (1331, 3)),
    (0x1d3a, (149, 1)),
    (0x3213, (1254, 4)),
    (0x1e065, (5340, 1)),
    (0x1d4ff, (4534, 1)),
    (0x1d734, (5085, 1)),
    (0x1d78b, (5172, 1)),
    (0xa69d, (2439, 1)),
    (0x2f96, (1007, 1)),
    (0xfc39, (2792, 2)),
    (0x1f14c, (5629, 2)),
    (0xfedb, (3961, 1)),
    (0x2495, (688, 3)),
    (0x1f124, (5572, 3)),
    (0x1d7dc, (5251, 1)),
    (0x1e053, (5322, 1)),
    (0x2f9a, (1011, 1)),
    (0xfd61, (3387, 3)),
    (0xfd02, (3216, 2)),
    (0x1eeab, (5473, 1)),
    (0x1079f, (4264, 1)),
    (0x1ee86, (5444, 1)),
    (0xfd9b, (3555, 3)),
    (0x1d50f, (4547, 1)),
    (0xfc8e, (2974, 2)),
    (0x1d513, (4551, 1)),
    (0x1d54f, (4603, 1)),
    (0x2173, (519, 2)),
    (0x2f5a, (947, 1)),
    (0x1d78c, (5173, 1)),
    (0x1d767, (5136, 1)),
    (0xfdab, (3603, 3)),
    (0x2f01, (858, 1)),
    (0xfc3f, (2804, 2)),
    (0x33c6, (2288, 4)),
    (0x1d6c0, (4969, 1)),
    (0xfb98, (2561, 1)),
    (0x3151, (1116, 1)),
    (0x1ee09, (5357, 1)),
    (0xfd8a, (3510, 3)),
    (0xff4d, (4085, 1)),
    (0x1d729, (5074, 1)),
    (0xfeb4, (3922, 1)),
    (0xfba4, (2573, 2)),
    (0x1d6b9, (4962, 1)),
    (0x1d6d0, (4985, 1)),
    (0x318d, (1176, 1)),
    (0x1f10a, (5510, 2)),
    (0x2017, (287, 2)),
    (0x1f121, (5563, 3)),
    (0x1d41f, (4322, 1)),
    (0x1d415, (4312, 1)),
    (0x319b, (1187, 1)),
    (0x1d6dd, (4998, 1)),
    (0x337f, (2115, 4)),
    (0x3260, (1452, 1)),
    (0x1fbf6, (5731, 1)),
    (0xfb7b, (2532, 1)),
    (0x1d752, (5115, 1)),
    (0x2f50, (937, 1)),
    (0xfebf, (3933, 1)),
    (0x1d658, (4867, 1)),
    (0xfdfa, (3727, 18)),
    (0x336e, (2074, 3)),
    (0xff51, (4089, 1)),
    (0xfc16, (2722, 2)),
    (0x1d5d, (182, 1)),
    (0x24b8, (789, 1)),
    (0xab5d, (2447, 1)),
    (0x1d41b, (4318, 1)),
    (0xfb68, (2513, 1)),
    (0x1f103, (5496, 2)),
    (0x2f53, (940, 1)),
    (0x3352, (1996, 2)),
    (0x1d5f9, (4772, 1)),
    (0x1d494, (4438, 1)),
    (0x1d52c, (4574, 1)),
    (0x24e6, (835, 1)),
    (0x2faf, (1032, 1)),
    (0x32c1, (1586, 2)),
    (0x2b3, (65, 1)),
    (0xfec1, (3935, 1)),
    (0x1f147, (5622, 1)),
    (0x384, (90, 2)),
    (0x24ba, (791, 1)),
    (0xff87, (4143, 1)),
    (0x1d669, (4884, 1)),
    (0xff35, (4061, 1)),
    (0xfefb, (4005, 2)),
    (0x1d7fa, (5281, 1)),
    (0x1d50, (169, 1)),
    (0xfef2, (3984, 1)),
    (0x3245, (1416, 1)),
    (0x1d78a, (5171, 1)),
    (0xfb75, (2526, 1)),
    (0x1ee91, (5454, 1)),
    (0x33e9, (2369, 3)),
    (0x2139, (421, 1)),
    (0x3258, (1436, 2)),
    (0x3287, (1512, 1)),
    (0x317d, (1160, 1)),
    (0x24ae, (763, 3)),
    (0xff98, (4160, 1)),
    (0x1d596, (4673, 1)),
    (0x1d6b0, (4953, 1)),
    (0x1e069, (5344, 1)),
    (0x1f22c, (5680, 1)),
    (0xff42, (4074, 1)),
    (0xffbb, (4195, 1)),
    (0xff1d, (4037, 1)),
    (0x1d503, (4538, 1)),
    (0x1d6e1, (5002, 1)),
    (0xfcc7, (3093, 2)),
    (0xff60, (4104, 1)),
    (0x1ee5d, (5413, 1)),
    (0x1f115, (5527, 3)),
    (0x1d4c9, (4480, 1)),
    (0x1d567, (4626, 1)),
    (0x1d67e, (4905, 1)),
    (0x33ed, (2381, 3)),
    (0x1e068, (5343, 1)),
    (0xfda6, (3588, 3)),
    (0x33ca, (2299, 2)),
    (0x1d7f8, (5279, 1)),
    (0x33ef, (2387, 3)),
    (0xfd50, (3336, 3)),
    (0x248e, (670, 2)),
    (0xfcd4, (3119, 2)),
    (0xfe98, (3894, 1)),
    (0x32a7, (1544, 1)),
    (0xffa9, (4177, 1)),
    (0x2172, (516, 3)),
    (0x1d5a, (179, 1)),
    (0xff27, (4047, 1)),
    (0x1dad, (215, 1)),
    (0x1d766, (5135, 1)),
    (0x24df, (828, 1)),
    (0xfeae, (3916, 1)),
    (0xfe35, (3775, 1)),
    (0x1d5a3, (4686, 1)),
    (0x1d650, (4859, 1)),
    (0x1d62a, (4821, 1)),
    (0x1d4dd, (4500, 1)),
    (0xff5b, (4099, 1)),
    (0x1d464, (4390, 1)),
    (0xfc34, (2782, 2)),
    (0x1d6bc, (4965, 1)),
    (0x1d71c, (5061, 1)),
    (0x2128, (409, 1)),
    (0xfb74, (2525, 1)),
    (0xfced, (3171, 2)),
    (0xa69c, (2438, 1)),
    (0x2a74, (844, 3)),
    (0xfef8, (3996, 3)),
    (0x1d63a, (4837, 1)),
    (0xfcb5, (3057, 2)),
    (0x1d435, (4344, 1)),
    (0x1ee69, (5420, 1)),
    (0x2036, (301, 2)),
    (0x1fbd, (238, 2)),
    (0x1d5fb, (4774, 1)),
    (0x1d5b9, (4708, 1)),
    (0xfd57, (3357, 3)),
    (0x318b, (1174, 1)),
    (0xfdf5, (3708, 4)),
    (0xfe7c, (3850, 2)),
    (0xfc9b, (3004, 3)),
    (0xfd14, (3252, 2)),
    (0x1d51b, (4558, 1)),
    (0x1ee67, (5418, 1)),
    (0x338a, (2142, 2)),
    (0xff40, (4072, 1)),
    (0xfb50, (2489, 1)),
    (0x1d4c7, (4478, 1)),
    (0x1079c, (4261, 1)),
    (0x1ee17, (5371, 1)),
    (0x1f190, (5644, 2)),
    (0x1d5f0, (4763, 1)),
    (0x32b3, (1558, 2)),
    (0x1d7d5, (5244, 1)),
    (0xfe64, (3823, 1)),
    (0xfb8e, (2551, 1)),
    (0xfc07, (2692, 2)),
    (0xfb58, (2497, 1)),
    (0x1d75c, (5125, 1)),
    (0x2168, (501, 2)),
    (0x1d745, (5102, 1)),
    (0x1ee4e, (5405, 1)),
    (0x2fcc, (1061, 1)),
    (0x1d781, (5162, 1)),
    (0x313c, (1095, 1)),
    (0x1fde, (259, 3)),
    (0x2fbd, (1046, 1)),
    (0x1d5d4, (4735, 1)),
    (0x1d500, (4535, 1)),
    (0xfc80, (2946, 2)),
    (0x33a3, (2199, 3)),
    (0x1d502, (4537, 1)),
    (0x32d1, (1622, 1)),
    (0xfd97, (3543, 3)),
    (0x1d489, (4427, 1)),
    (0xffd6, (4215, 1)),
    (0xfcc3, (3085, 2)),
    (0x2493, (682, 3)),
    (0x1d6c6, (4975, 1)),
    (0x208d, (348, 1)),
    (0xfb06, (2465, 2)),
    (0x319c, (1188, 1)),
    (0x1da1, (203, 1)),
    (0xff1b, (4035, 1)),
    (0xfee1, (3967, 1)),
    (0xfc65, (2887, 3)),
    (0xfc14, (2718, 2)),
    (0xfea2, (3904, 1)),
    (0xfb91, (2554, 1)),
    (0x3350, (1989, 3)),
    (0x1d6c8, (4977, 1)),
    (0x1d677, (4898, 1)),
    (0x10783, (4237, 1)),
    (0x1da3, (205, 1)),
    (0x1d51, (170, 1)),
    (0x3261, (1453, 1)),
    (0xfc78, (2930, 2)),
    (0x3363, (2041, 3)),
    (0x2f3c, (917, 1)),
    (0x2f27, (896, 1)),
    (0x32a3, (1540, 1)),
    (0x1fbf5, (5730, 1)),
    (0x2b4, (66, 1)),
    (0x3286, (1511, 1)),
    (0x2f17, (880, 1)),
    (0x1d5cc, (4727, 1)),
    (0x1f230, (5684, 1)),
    (0xfb03, (2457, 3)),
    (0x24ce, (811, 1)),
    (0x2f30, (905, 1)),
    (0xfd60, (3384, 3)),
    (0x1f123, (5569, 3)),
    (0x1d532, (4580, 1)),
    (0x1f21e, (5666, 1)),
    (0x3353, (1998, 4)),
    (0x1d9b, (197, 1)),
    (0x1f104, (5498, 2)),
    (0x1f21b, (5663, 1)),
    (0xfe52, (3806, 1)),
    (0xfd3b, (3330, 2)),
    (0x2f61, (954, 1)),
    (0xfc00, (2673, 3)),
    (0x1ee71, (5427, 1)),
    (0x3f0, (104, 1)),
    (0x1d7e4, (5259, 1)),
    (0xfc5d, (2864, 2)),
    (0x1d670, (4891, 1)),
    (0xfe33, (3773, 1)),
    (0x1d57d, (4648, 1)),
    (0xfe6b, (3829, 1)),
    (0x3233, (1364, 3)),
    (0x2f21, (890, 1)),
    (0xfc15, (2720, 2)),
    (0x1d55f, (4618, 1)),
    (0xfd64, (3396, 3)),
    (0x1d49a, (4444, 1)),
    (0xfe7b, (3848, 2)),
    (0x1d762, (5131, 1)),
    (0x1d6e0, (5001, 1)),
    (0xfeb5, (3923, 1)),
    (0x1d46b, (4397, 1)),
    (0x1db6, (224, 1)),
    (0x3141, (1100, 1)),
    (0xfe9c, (3898, 1)),
    (0x1d484, (4422, 1)),
    (0x329d, (1534, 1)),
    (0x1d530, (4578, 1)),
    (0xfd32, (3312, 2)),
    (0xfc5f, (2869, 3)),
    (0x1ee7b, (5435, 1)),
    (0xf0c, (128, 1)),
    (0x1d56f, (4634, 1)),
    (0x1d6aa, (4947, 1)),
    (0x33dc, (2341, 2)),
    (0x24e3, (832, 1)),
    (0x1f22e, (5682, 1)),
    (0x1d4b7, (4465, 1)),
    (0x1d5d1, (4732, 1)),
    (0x1d7a6, (5199, 1)),
    (0x2f4e, (935, 1)),
    (0x1d6ae, (4951, 1)),
    (0x3f2, (106, 1)),
    (0x3280, (1505, 1)),
    (0x1d3e, (152, 1)),
    (0xfbef, (2630, 3)),
    (0x1f102, (5494, 2)),
    (0xfe54, (3807, 1)),
    (0x3263, (1455, 1)),
    (0xff9b, (4163, 1)),
    (0x1d584, (4655, 1)),
    (0x3351, (1992, 4)),
    (0x3156, (1121, 1)),
    (0xfbf2, (2639, 3)),
    (0xfb02, (2455, 2)),
    (0x317b, (1158, 1)),
    (0x314c, (1111, 1)),
    (0x1c6, (41, 3)),
    (0x1d73f, (5096, 1)),
    (0x1ee4d, (5404, 1)),
    (0x1d53, (172, 1)),
    (0x33d1, (2313, 2)),
    (0x1d58a, (4661, 1)),
    (0xfd83, (3489, 3)),
    (0x2178, (531, 2)),
    (0x1d751, (5114, 1)),
    (0xfd77, (3453, 3)),
    (0x1d479, (4411, 1)),
    (0x215d, (475, 3)),
    (0xfd87, (3501, 3)),
    (0x318a, (1173, 1)),
    (0x1d43f, (4354, 1)),
    (0x2fcd, (1062, 1)),
    (0x1d4f0, (4519, 1)),
    (0x1d59, (178, 1)),
    (0x1d65f, (4874, 1)),
    (0x3393, (2162, 3)),
    (0x1ee92, (5455, 1)),
    (0xa770, (2440, 1)),
    (0xfd0b, (3234, 2)),
    (0x208a, (345, 1)),
    (0xfe80, (3858, 1)),
    (0x1d7f3, (5274, 1)),
    (0xfd0d, (3238, 2)),
    (0x1d54a, (4598, 1)),
    (0x1d699, (4932, 1)),
    (0xfe92, (3888, 1)),
    (0xfe4c, (3799, 2)),
    (0x1d653, (4862, 1)),
    (0x1e04b, (5314, 1)),
    (0x1d5b8, (4707, 1)),
    (0x1d45a, (4380, 1)),
    (0x335b, (2024, 2)),
    (0x1d789, (5170, 1)),
    (0xa7f2, (2441, 1)),
    (0x1eea3, (5467, 1)),
    (0xff7c, (4132, 1)),
    (0x2176, (524, 3)),
    (0xffa6, (4174, 1)),
    (0xff57, (4095, 1)),
    (0x1ee79, (5433, 1)),
    (0x1d5ae, (4697, 1)),
    (0x1d46f, (4401, 1)),
    (0x2da, (75, 2)),
    (0x2f4d, (934, 1)),
    (0xfdc5, (3681, 3)),
    (0x3384, (2127, 2)),
    (0x24c0, (797, 1)),
    (0x1d57c, (4647, 1)),
    (0x1d7b0, (5209, 1)),
    (0x1d5cb, (4726, 1)),
    (0x1d783, (5164, 1)),
    (0x1d4e8, (4511, 1)),
    (0x1d58e, (4665, 1)),
    (0xff0d, (4021, 1)),
    (0x1d644, (4847, 1)),
    (0x24c4, (801, 1)),
    (0x2f52, (939, 1)),
    (0x1d68e, (4921, 1)),
    (0x1d50d, (4545, 1)),
    (0xfb6b, (2516, 1)),
    (0x2fcb, (1060, 1)),
    (0xff32, (4058, 1)),
    (0xffab, (4179, 1)),
    (0x316c, (1143, 1)),
    (0x2070, (321, 1)),
    (0xfd8d, (3519, 3)),
    (0xfe74, (3836, 2)),
    (0x2131, (414, 1)),
    (0xff64, (4108, 1)),
    (0x339b, (2180, 2)),
    (0x1e06a, (5345, 1)),
    (0x1f224, (5672, 1)),
    (0x1d405, (4296, 1)),
    (0xff49, (4081, 1)),
    (0xff37, (4063, 1)),
    (0x2075, (324, 1)),
    (0xfebe, (3932, 1)),
    (0xfee8, (3974, 1)),
    (0xa7f8, (2444, 1)),
    (0x1d7be, (5223, 1)),
    (0x1d9d, (199, 1)),
    (0x107b6, (4286, 1)),
    (0x2f79, (978, 1)),
    (0x1f212, (5653, 1)),
    (0xfcdf, (3141, 3)),
    (0x1d5a1, (4684, 1)),
    (0xfcc9, (3097, 2)),
    (0x1ee11, (5365, 1)),
    (0x339f, (2188, 3)),
    (0xfb83, (2540, 1)),
    (0x1f131, (5600, 1)),
    (0xff08, (4016, 1)),
    (0xfe9e, (3900, 1)),
    (0xfe39, (3779, 1)),
    (0x3386, (2131, 2)),
    (0xfd6f, (3429, 3)),
    (0x1d58b, (4662, 1)),
    (0x1d5f3, (4766, 1)),
    (0x1d5f, (184, 1)),
    (0xfc30, (2774, 2)),
    (0x33fa, (2420, 3)),
    (0x1ee5b, (5412, 1)),
    (0x2478, (599, 3)),
    (0x1d747, (5104, 1)),
    (0xfcf8, (3196, 2)),
    (0x1d667, (4882, 1)),
    (0x1d796, (5183, 1)),
    (0x2011, (286, 1)),
    (0x1f144, (5619, 1)),
    (0xfd3d, (3334, 2)),
    (0x3270, (1470, 2)),
    (0x326c, (1464, 1)),
    (0x1d5c8, (4723, 1)),
    (0x1d68c, (4919, 1)),
    (0xfdfb, (3745, 8)),
    (0xfdb6, (3636, 3)),
    (0x2095, (355, 1)),
    (0x3219, (1278, 4)),
    (0x2499, (700, 3)),
    (0x1ee52, (5408, 1)),
    (0x2dc, (79, 2)),
    (0x210e, (387, 1)),
    (0x1d5ce, (4729, 1)),
    (0x1d687, (4914, 1)),
    (0x1d702, (5035, 1)),
    (0x2093, (353, 1)),
    (0x1d615, (4800, 1)),
    (0x2f0c, (869, 1)),
    (0x3185, (1168, 1)),
    (0x1d42a, (4333, 1)),
    (0x247b, (608, 3)),
    (0xfeee, (3980, 1)),
    (0x10785, (4239, 1)),
    (0x209a, (360, 1)),
    (0xfb72, (2523, 1)),
    (0x33e2, (2355, 2)),
    (0xfc75, (2924, 2)),
    (0x24d2, (815, 1)),
    (0x1e05b, (5330, 1)),
    (0x212c, (410, 1)),
    (0x247f, (622, 4)),
    (0x1d45e, (4384, 1)),
    (0xfee3, (3969, 1)),
    (0x2f19, (882, 1)),
    (0x321e, (1301, 6)),
    (0x2f05, (862, 1)),
    (0xfb16, (2473, 2)),
    (0x3142, (1101, 1)),
    (0x107a5, (4270, 1)),
    (0x2001, (276, 1)),
    (0xfc84, (2954, 2)),
    (0x1d55c, (4615, 1)),
    (0x1d7c4, (5229, 1)),
    (0x2fa0, (1017, 1)),
    (0x1f143, (5618, 1)),
    (0x2f8f, (1000, 1)),
    (0x24c9, (806, 1)),
    (0x32c5, (1594, 2)),
    (0x248f, (672, 2)),
    (0xff84, (4140, 1)),
    (0x3324, (1820, 4)),
    (0xfcb7, (3061, 2)),
    (0x1e041, (5304, 1)),
    (0x24d9, (822, 1)),
    (0xfd16, (3256, 2)),
    (0x3251, (1422, 2)),
    (0xfc92, (2982, 2)),
    (0xfe8f, (3885, 1)),
    (0xfdc4, (3678, 3)),
    (0x2f1c, (885, 1)),
    (0x1f22b, (5679, 1)),
    (0x1d5db, (4742, 1)),
    (0x2f41, (922, 1)),
    (0xfd1b, (3266, 2)),
    (0x3217, (1270, 4)),
    (0x1f250, (5723, 1)),
    (0x3321, (1809, 5)),
    (0x2f40, (921, 1)),
    (0x2fca, (1059, 1)),
    (0x107a6, (4271, 1)),
    (0x1d589, (4660, 1)),
    (0x3136, (1089, 1)),
    (0xfc7d, (2940, 2)),
    (0xfb87, (2544, 1)),
    (0xfc0e, (2706, 2)),
    (0x1f106, (5502, 2)),
    (0x2f65, (958, 1)),
    (0xfe56, (3809, 1)),
    (0xfb9c, (2565, 1)),
    (0xfee4, (3970, 1)),
    (0x1ee06, (5354, 1)),
    (0x1d6d2, (4987, 1)),
    (0x1d45d, (4383, 1)),
    (0x1d660, (4875, 1)),
    (0x1f216, (5658, 1)),
    (0x1d400, (4291, 1)),
    (0xfb13, (2467, 2)),
    (0xfc6f, (2912, 2)),
    (0xfca7, (3029, 2)),
    (0xfe13, (3760, 1)),
    (0xfe4b, (3797, 2)),
    (0x1d78d, (5174, 1)),
    (0xff2e, (4054, 1)),
    (0x2f6b, (964, 1)),
    (0xfbe6, (2611, 1)),
    (0x1d4f6, (4525, 1)),
    (0x107a8, (4273, 1)),
    (0x328b, (1516, 1)),
    (0x1d5c, (181, 1)),
    (0x246a, (567, 2)),
    (0xfcb9, (3065, 2)),
    (0xfbd6, (2594, 1)),
    (0x33f7, (2411, 3)),
    (0xfd08, (3228, 2)),
    (0x32c7, (1598, 2)),
    (0x1d684, (4911, 1)),
    (0x1eea1, (5465, 1)),
    (0xfd78, (3456, 3)),
    (0x1ee80, (5438, 1)),
    (0x1f225, (5673, 1)),
    (0x1eeb6, (5484, 1)),
    (0x1ee0c, (5360, 1)),
    (0xab5c, (2446, 1)),
    (0xfb5c, (2501, 1)),
    (0x322e, (1349, 3)),
    (0xfc4b, (2828, 2)),
    (0x24c7, (804, 1)),
    (0x3360, (2034, 2)),
    (0x1d737, (5088, 1)),
    (0x33d0, (2311, 2)),
    (0xfc90, (2978, 2)),
    (0x1eeb0, (5478, 1)),
    (0xfda1, (3573, 3)),
    (0x3375, (2093, 2)),
    (0x2f00, (857, 1)),
    (0xfb9a, (2563, 1)),
    (0x322a, (1337, 3)),
    (0x32a9, (1546, 1)),
    (0x1d472, (4404, 1)),
    (0x1d4d4, (4491, 1)),
    (0x1f221, (5669, 1)),
    (0xff7b, (4131, 1)),
    (0x1d46, (160, 1)),
    (0xffb1, (4185, 1)),
    (0x1d436, (4345, 1)),
    (0x3298, (1529, 1)),
    (0xfc43, (2812, 2)),
    (0xfc31, (2776, 2)),
    (0x1d679, (4900, 1)),
    (0x315b, (1126, 1)),
    (0x1d712, (5051, 1)),
    (0xfe99, (3895, 1)),
    (0xfed1, (3951, 1)),
    (0x339a, (2178, 2)),
    (0x1d4a6, (4451, 1)),
    (0xfbd5, (2593, 1)),
    (0x210a, (383, 1)),
    (0xfb96, (2559, 1)),
    (0x2f8e, (999, 1)),
    (0x1d7a9, (5202, 1)),
    (0xfb5e, (2503, 1)),
    (0x10793, (4252, 1)),
    (0x2f56, (943, 1)),
    (0x207d, (332, 1)),
    (0x1f227, (5675, 1)),
    (0xfc94, (2986, 2)),
    (0x1d4d3, (4490, 1)),
    (0xfd67, (3405, 3)),
    (0xff09, (4017, 1)),
    (0x1d5a4, (4687, 1)),
    (0x1e06d, (5348, 1)),
    (0x1d39, (148, 1)),
    (0x3210, (1242, 4)),
    (0x1d721, (5066, 1)),
    (0xff91, (4153, 1)),
    (0x1d62d, (4824, 1)),
    (0x1d7c0, (5225, 1)),
    (0x1f213, (5654, 2)),
    (0x1f130, (5599, 1)),
    (0x1d4d5, (4492, 1)),
    (0x1db2, (220, 1)),
    (0x2f98, (1009, 1)),
    (0x1d56a, (4629, 1)),
    (0x2477, (596, 3)),
    (0x1d526, (4568, 1)),
    (0x2475, (590, 3)),
    (0x107b8, (4288, 1)),
    (0x1f242, (5702, 3)),
    (0x587, (110, 2)),
    (0x1d7b3, (5212, 1)),
    (0x2076, (325, 1)),
    (0x1d6f2, (5019, 1)),
    (0xfdbc, (3654, 3)),
    (0x24a6, (739, 3)),
    (0x33d4, (2320, 2)),
    (0x1d4d8, (4495, 1)),
    (0x320c, (1228, 3)),
    (0x1d57b, (4646, 1)),
    (0x1ee15, (5369, 1)),
    (0x24a4, (733, 3)),
    (0x2149, (434, 1)),
    (0xfbf8, (2657, 3)),
    (0x2f04, (861, 1)),
    (0x1d5ca, (4725, 1)),
    (0x1d57, (176, 1)),
    (0xff22, (4042, 1)),
    (0x1d68b, (4918, 1)),
    (0x1d7b5, (5214, 1)),
    (0x1d4c8, (4479, 1)),
    (0x2088, (343, 1)),
    (0x3340, (1929, 5)),
    (0x1d507, (4541, 1)),
    (0x325d, (1446, 2)),
    (0x1d5fe, (4777, 1)),
    (0x317c, (1159, 1)),
    (0x1ee47, (5401, 1)),
    (0x33b0, (2242, 2)),
    (0x1d786, (5167, 1)),
    (0xfc83, (2952, 2)),
    (0x1d444, (4359, 1)),
    (0x32f1, (1654, 1)),
    (0x3152, (1117, 1)),
    (0xff13, (4027, 1)),
    (0xfe38, (3778, 1)),
    (0x1d4ec, (4515, 1)),
    (0xfd7e, (3474, 3)),
    (0x336f, (2077, 3)),
    (0x3d0, (95, 1)),
    (0x1d7f1, (5272, 1)),
    (0x1f251, (5724, 1)),
    (0x1db3, (221, 1)),
    (0x1d514, (4552, 1)),
    (0x33fb, (2423, 3)),
    (0xfbf1, (2636, 3)),
    (0xfd84, (3492, 3)),
    (0x1fbf3, (5728, 1)),
    (0x328a, (1515, 1)),
    (0x24ab, (754, 3)),
    (0x1d7e7, (5262, 1)),
    (0x335c, (2026, 2)),
    (0xff85, (4141, 1)),
    (0x1d4bd, (4469, 1)),
    (0xfdb5, (3633, 3)),
    (0xfdf2, (3696, 4)),
    (0xfe83, (3863, 2)),
    (0x1fdd, (256, 3)),
    (0xfc7b, (2936, 2)),
    (0x319a, (1186, 1)),
    (0x3275, (1480, 2)),
    (0xfd20, (3276, 2)),
    (0x1d402, (4293, 1)),
    (0xff67, (4111, 1)),
    (0x1d7dd, (5252, 1)),
    (0xfc2e, (2770, 2)),
    (0xff04, (4012, 1)),
    (0x1eeb1, (5479, 1)),
    (0x3317, (1765, 5)),
    (0x3367, (2053, 3)),
    (0x1d652, (4861, 1)),
    (0x337e, (2113, 2)),
    (0x1d9c, (198, 1)),
    (0x1079e, (4263, 1)),
    (0x2f5f, (952, 1)),
    (0xfea6, (3908, 1)),
    (0x1d66, (191, 1)),
    (0x1ee90, (5453, 1)),
    (0x1d723, (5068, 1)),
    (0x247e, (618, 4)),
    (0x216b, (506, 3)),
    (0x1d74c, (5109, 1)),
    (0x1d68d, (4920, 1)),
    (0x3211, (1246, 4)),
    (0x1d77f, (5160, 1)),
    (0xff86, (4142, 1)),
    (0x2f18, (881, 1)),
    (0x3347, (1953, 5)),
    (0xfc72, (2918, 2)),
    (0x1d496, (4440, 1)),
    (0x1f129, (5587, 3)),
    (0x210d, (386, 1)),
    (0x1d40e, (4305, 1)),
    (0x1d4e0, (4503, 1)),
    (0x1d571, (4636, 1)),
    (0x200a, (285, 1)),
    (0x1d53d, (4590, 1)),
    (0x2099, (359, 1)),
    (0x2a75, (847, 2)),
    (0xfe40, (3786, 1)),
    (0xfebd, (3931, 1)),
    (0x1d44b, (4366, 1)),
    (0x32d3, (1624, 1)),
    (0x1d666, (4881, 1)),
    (0xfbaa, (2581, 1)),
    (0x2f7e, (983, 1)),
    (0xff77, (4127, 1)),
    (0xff25, (4045, 1)),
    (0x1d693, (4926, 1)),
    (0xfeb6, (3924, 1)),
    (0x1d695, (4928, 1)),
    (0xffd5, (4214, 1)),
    (0x1d491, (4435, 1)),
    (0x3359, (2020, 2)),
    (0x1d57f, (4650, 1)),
    (0xffd7, (4216, 1)),
    (0x1ee32, (5393, 1)),
    (0x3267, (1459, 1)),
    (0xfd30, (3308, 2)),
    (0xfbed, (2624, 3)),
    (0xfd94, (3534, 3)),
    (0x3278, (1486, 2)),
    (0xff97, (4159, 1)),
    (0x1d686, (4913, 1)),
    (0x1f108, (5506, 2)),
    (0x2f2c, (901, 1)),
    (0xfcd1, (3113, 2)),
    (0x2468, (564, 1)),
    (0xfe3e, (3784, 1)),
    (0xff66, (4110, 1)),
    (0xff14, (4028, 1)),
    (0x1d74d, (5110, 1)),
    (0x32f5, (1658, 1)),
    (0x33cd, (2305, 2)),
    (0x2469, (565, 2)),
    (0x32b4, (1560, 2)),
    (0x1d65b, (4870, 1)),
    (0x1f113, (5521, 3)),
    (0x2155, (451, 3)),
    (0x1daa, (212, 1)),
    (0xfed6, (3956, 1)),
    (0x1d5bd, (4712, 1)),
    (0x1e045, (5308, 1)),
    (0xfdf3, (3700, 4)),
    (0xfb8c, (2549, 1)),
    (0x1d7d4, (5243, 1)),
    (0x2b8, (70, 1)),
    (0x1d565, (4624, 1)),
    (0x2fd5, (1070, 1)),
    (0x1d4af, (4457, 1)),
    (0xfcf2, (3181, 3)),
    (0x1f142, (5617, 1)),
    (0x3195, (1181, 1)),
    (0x1d56c, (4631, 1)),
    (0xfd0e, (3240, 2)),
    (0x1eeb7, (5485, 1)),
    (0xff54, (4092, 1)),
    (0x678, (118, 2)),
    (0xfbee, (2627, 3)),
    (0x1d540, (4592, 1)),
    (0x33be, (2270, 2)),
    (0xfead, (3915, 1)),
    (0x1d40c, (4303, 1)),
    (0xfb23, (2480, 1)),
    (0xfee6, (3972, 1)),
    (0xffa1, (4169, 1)),
    (0x1d674, (4895, 1)),
    (0x1d36, (145, 1)),
    (0x2106, (377, 3)),
    (0x3231, (1358, 3)),
    (0x1ee59, (5411, 1)),
    (0x3338, (1898, 4)),
    (0x1d7c3, (5228, 1)),
    (0x107b5, (4285, 1)),
    (0x2b0, (62, 1)),
    (0xfc36, (2786, 2)),
    (0x1f234, (5688, 1)),
    (0x1d473, (4405, 1)),
    (0x313f, (1098, 1)),
    (0xfd7b, (3465, 3)),
    (0x3154, (1119, 1)),
    (0x1ee31, (5392, 1)),
    (0xffae, (4182, 1)),
    (0x1d4b, (165, 1)),
    (0x1ee4b, (5403, 1)),
    (0x1d672, (4893, 1)),
    (0x313b, (1094, 1)),
    (0x1d7ae, (5207, 1)),
    (0xfd35, (3318, 2)),
    (0x3200, (1192, 3)),
    (0xff19, (4033, 1)),
    (0x1d538, (4586, 1)),
    (0x1f105, (5500, 2)),
    (0x2f3a, (915, 1)),
    (0xff2d, (4053, 1)),
    (0x1ee03, (5352, 1)),
    (0x2fc5, (1054, 1)),
    (0xfc19, (2728, 2)),
    (0xfb27, (2484, 1)),
    (0x2f31, (906, 1)),
    (0x2a76, (849, 3)),
    (0x1d655, (4864, 1)),
    (0x1d47e, (4416, 1)),
    (0x246f, (577, 2)),
    (0x2f13, (876, 1)),
    (0x1f233, (5687, 1)),
    (0x1d59f, (4682, 1)),
    (0x2497, (694, 3)),
    (0x2e9f, (855, 1)),
    (0x32dd, (1634, 1)),
    (0xfd28, (3292, 2)),
    (0x1d7bb, (5220, 1)),
    (0x1d7d2, (5241, 1)),
    (0x32e1, (1638, 1)),
    (0x1d69b, (4934, 1)),
    (0x107ac, (4277, 1)),
    (0xfc93, (2984, 2)),
    (0x2f34, (909, 1)),
    (0x2490, (674, 2)),
    (0xfb6e, (2519, 1)),
    (0x1f12d, (5595, 2)),
    (0xfba1, (2570, 1)),
    (0x1d48d, (4431, 1)),
    (0x1f228, (5676, 1)),
    (0x2471, (581, 2)),
    (0xfb59, (2498, 1)),
    (0xfec3, (3937, 1)),
    (0x329a, (1531, 1)),
    (0x33c9, (2297, 2)),
    (0x1dbd, (231, 1)),
    (0x1d474, (4406, 1)),
    (0x1d673, (4894, 1)),
    (0xffe1, (4221, 1)),
    (0x1d4c3, (4475, 1)),
    (0x1d649, (4852, 1)),
    (0xfed2, (3952, 1)),
    (0x3205, (1207, 3)),
    (0x1d537, (4585, 1)),
    (0xfcd9, (3129, 2)),
    (0x3140, (1099, 1)),
    (0x309f, (1080, 2)),
    (0xff58, (4096, 1)),
    (0x1d707, (5040, 1)),
    (0x1d5d8, (4739, 1)),
    (0x2f5e, (951, 1)),
    (0x329c, (1533, 1)),
    (0x1ee8f, (5452, 1)),
    (0x1f21a, (5662, 1)),
    (0x1fc1, (244, 3)),
    (0x1d71b, (5060, 1)),
    (0x1ee29, (5384, 1)),
    (0x2f5d, (950, 1)),
    (0x3346, (1950, 3)),
    (0x33cc, (2303, 2)),
    (0x1d676, (4897, 1)),
    (0x2fc1, (1050, 1)),
    (0x1d604, (4783, 1)),
    (0x1d4ed, (4516, 1)),
    (0x1d508, (4542, 1)),
    (0xfd5d, (3375, 3)),
    (0x1d5a7, (4690, 1)),
    (0x1e033, (5290, 1)),
    (0xb8, (11, 2)),
    (0xffda, (4217, 1)),
    (0x3273, (1476, 2)),
    (0xff21, (4041, 1)),
    (0x24cf, (812, 1)),
    (0x3332, (1871, 6)),
    (0x1d413, (4310, 1)),
    (0x249c, (709, 3)),
    (0xff30, (4056, 1)),
    (0x1ee68, (5419, 1)),
    (0x1d5b0, (4699, 1)),
    (0xfbd7, (2595, 1)),
    (0x3133, (1086, 1)),
    (0xfd33, (3314, 2)),
    (0xfc12, (2714, 2)),
    (0x334a, (1964, 6)),
    (0x1d48f, (4433, 1)),
    (0xff17, (4031, 1)),
    (0x13f, (28, 2)),
    (0x32c8, (1600, 2)),
    (0xfe63, (3822, 1)),
    (0x1d6f7, (5024, 1)),
    (0x33e6, (2363, 2)),
    (0x1d689, (4916, 1)),
    (0x1d7fc, (5283, 1)),
    (0x2167, (497, 4)),
    (0x1da2, (204, 1)),
    (0x1eea8, (5471, 1)),
    (0x3169, (1140, 1)),
    (0xaf, (4, 2)),
    (0xfcb6, (3059, 2)),
    (0xfbeb, (2618, 3)),
    (0xfe61, (3820, 1)),
    (0x1d6f5, (5022, 1)),
    (0x3277, (1484, 2)),
    (0x321b, (1286, 4)),
    (0xfc28, (2758, 2)),
    (0x1d51c, (4559, 1)),
    (0xff92, (4154, 1)),
    (0x3395, (2168, 2)),
    (0x1d5fd, (4776, 1)),
    (0x1d722, (5067, 1)),
    (0x2f99, (1010, 1)),
    (0x33a4, (2202, 3)),
    (0x3d6, (103, 1)),
    (0x24e8, (837, 1)),
    (0x212f, (412, 1)),
    (0x1f201, (5648, 2)),
    (0xfec0, (3934, 1)),
    (0x1d67d, (4904, 1)),
    (0x33a1, (2194, 2)),
    (0xfca6, (3027, 2)),
    (0x2f85, (990, 1)),
    (0x37a, (88, 2)),
    (0x32cf, (1618, 3)),
    (0x1f200, (5646, 2)),
    (0x2e4, (87, 1)),
    (0x1d75e, (5127, 1)),
    (0x1d4a5, (4450, 1)),
    (0xfed0, (3950, 1)),
    (0x3269, (1461, 1)),
    (0x1d55e, (4617, 1)),
    (0x1d439, (4348, 1)),
    (0x1d5b5, (4704, 1)),
    (0xfc64, (2884, 3)),
    (0xfeb0, (3918, 1)),
    (0xfbd8, (2596, 1)),
    (0x3147, (1106, 1)),
    (0xfbe3, (2608, 1)),
    (0x2113, (392, 1)),
    (0x1e05f, (5334, 1)),
    (0x3368, (2056, 3)),
    (0xff4e, (4086, 1)),
    (0x1d6a9, (4946, 1)),
    (0xfb6d, (2518, 1)),
    (0x332b, (1840, 6)),
    (0x334c, (1973, 5)),
    (0xfb52, (2491, 1)),
    (0x1d426, (4329, 1)),
    (0xab5f, (2449, 1)),
    (0xfe5d, (3816, 1)),
    (0x1d6bf, (4968, 1)),
    (0x1d6b5, (4958, 1)),
    (0xfba6, (2577, 1)),
    (0x1ffe, (273, 2)),
    (0xfbd4, (2592, 1)),
    (0xfc6d, (2908, 2)),
    (0xff20, (4040, 1)),
    (0x1d5ab, (4694, 1)),
    (0x1d5f2, (4765, 1)),
    (0x325c, (1444, 2)),
    (0xfe42, (3788, 1)),
    (0x3383, (2125, 2)),
    (0xfb22, (2479, 1)),
    (0x1d5ec, (4759, 1)),
    (0x1d63e, (4841, 1)),
    (0xfc7a, (2934, 2)),
    (0x1d4cb, (4482, 1)),
    (0xfd9f, (3567, 3)),
    (0x319f, (1191, 1)),
    (0x1d521, (4563, 1)),
    (0x217f, (542, 1)),
    (0x3238, (1379, 3)),
    (0x1d438, (4347, 1)),
    (0xffa4, (4172, 1)),
    (0x24aa, (751, 3)),
    (0xba, (14, 1)),
    (0xfc79, (2932, 2)),
    (0xfe5b, (3814, 1)),
    (0x1ee02, (5351, 1)),
    (0x32fb, (1664, 1)),
    (0x2d8, (71, 2)),
    (0x32da, (1631, 1)),
    (0x338c, (2146, 2)),
    (0xfd2b, (3298, 2)),
    (0xfd06, (3224, 2)),
    (0x32b0, (1553, 1)),
    (0x1e03e, (5301, 1)),
    (0x2fab, (1028, 1)),
    (0x210c, (385, 1)),
    (0xfcd6, (3123, 2)),
    (0x2164, (491, 1)),
    (0xff83, (4139, 1)),
    (0x24b4, (781, 3)),
    (0x2f94, (1005, 1)),
    (0x32ed, (1650, 1)),
    (0x3232, (1361, 3)),
    (0x2f59, (946, 1)),
    (0xff33, (4059, 1)),
    (0x3262, (1454, 1)),
    (0x330e, (1725, 4)),
    (0x2489, (660, 2)),
    (0x2fb5, (1038, 1)),
    (0xfeea, (3976, 1)),
    (0x2fc8, (1057, 1)),
    (0x215e, (478, 3)),
    (0xff05, (4013, 1)),
    (0x2f8a, (995, 1)),
    (0x1ee1d, (5377, 1)),
    (0xfebb, (3929, 1)),
    (0x1d67f, (4906, 1)),
    (0xfe93, (3889, 1)),
    (0xfecf, (3949, 1)),
    (0xfbfb, (2666, 3)),
    (0x1d6d6, (4991, 1)),
    (0x2152, (441, 4)),
    (0x1db7, (225, 1)),
    (0x1f14a, (5625, 2)),
    (0xfbdc, (2600, 1)),
    (0x1d694, (4927, 1)),
    (0x2158, (460, 3)),
    (0x1d63d, (4840, 1)),
    (0x2101, (368, 3)),
    (0x2137, (419, 1)),
    (0xfdc0, (3666, 3)),
    (0x1d7a3, (5196, 1)),
    (0x1d54, (173, 1)),
    (0x10797, (4256, 1)),
    (0x3268, (1460, 1)),
    (0x10795, (4254, 1)),
    (0x33b9, (2260, 2)),
    (0xfc02, (2679, 3)),
    (0x332f, (1861, 4)),
    (0x213d, (426, 1)),
    (0x3283, (1508, 1)),
    (0x2f15, (878, 1)),
    (0x1d453, (4374, 1)),
    (0x107b0, (4281, 1)),
    (0x2f33, (908, 1)),
    (0xfe7f, (3856, 2)),
    (0x1d7eb, (5266, 1)),
    (0x32ca, (1605, 3)),
    (0xedc, (124, 2)),
    (0xffed, (4233, 1)),
    (0x1d7ca, (5235, 1)),
    (0x3265, (1457, 1)),
    (0x3389, (2138, 4)),
    (0xfcaf, (3045, 2)),
    (0xfd69, (3411, 3)),
    (0x32a4, (1541, 1)),
    (0x2f75, (974, 1)),
    (0x2c7c, (852, 1)),
    (0x2fae, (1031, 1)),
    (0xff2c, (4052, 1)),
    (0xfdf1, (3693, 3)),
    (0x1d613, (4798, 1)),
    (0xfc73, (2920, 2)),
    (0x1d495, (4439, 1)),
    (0x1d4ea, (4513, 1)),
    (0xa7f3, (2442, 1)),
    (0x1d7e5, (5260, 1)),
    (0xfe85, (3867, 2)),
    (0x1d4f2, (4521, 1)),
    (0x1d65e, (4873, 1)),
    (0x1d7c6, (5231, 1)),
    (0x2103, (372, 2)),
    (0x2083, (338, 1)),
    (0xfc33, (2780, 2)),
    (0x333d, (1918, 5)),
    (0xfcef, (3175, 2)),
    (0xfeb8, (3926, 1)),
    (0x32fd, (1666, 1)),
    (0x1d74b, (5108, 1)),
    (0x247c, (611, 3)),
    (0x1079d, (4262, 1)),
    (0x1e052, (5321, 1)),
    (0x1ee10, (5364, 1)),
    (0x2f7d, (982, 1)),
    (0xfda4, (3582, 3)),
    (0x323a, (1385, 3)),
    (0x3157, (1122, 1)),
    (0x33c0, (2274, 2)),
    (0x1f3, (60, 2)),
    (0xfc51, (2840, 2)),
    (0xfe15, (3762, 1)),
    (0x3204, (1204, 3)),
    (0x3397, (2172, 2)),
    (0x1d4e2, (4505, 1)),
    (0x32ce, (1616, 2)),
    (0xfb69, (2514, 1)),
    (0x1d6fc, (5029, 1)),
    (0x32a5, (1542, 1)),
    (0xfe9a, (3896, 1)),
    (0x1dbe, (232, 1)),
    (0x2090, (350, 1)),
    (0xfbd9, (2597, 1)),
    (0x1d778, (5153, 1)),
    (0x1d6d7, (4992, 1)),
    (0x1d7bf, (5224, 1)),
    (0xfda8, (3594, 3)),
    (0x3391, (2156, 3)),
    (0xfc5b, (2860, 2)),
    (0x2467, (563, 1)),
    (0x1d7f0, (5271, 1)),
    (0x3186, (1169, 1)),
    (0x2f10, (873, 1)),
    (0x1d5e3, (4750, 1)),
    (0xfce5, (3155, 2)),
    (0x1d75a, (5123, 1)),
    (0xa7f9, (2445, 1)),
    (0x1d580, (4651, 1)),
    (0x1d49b, (4445, 1)),
    (0x2151, (438, 3)),
    (0x1f23b, (5695, 1)),
    (0xfcad, (3041, 2)),
    (0x32b7, (1566, 2)),
    (0x1d5cf, (4730, 1)),
    (0x1d790, (5177, 1)),
    (0x1d6cd, (4982, 1)),
    (0xffcc, (4207, 1)),
    (0x3307, (1698, 6)),
    (0x1d7df, (5254, 1)),
    (0x2f07, (864, 1)),
    (0x24d5, (818, 1)),
    (0x1d5a0, (4683, 1)),
    (0xfb85, (2542, 1)),
    (0x1d520, (4562, 1)),
    (0x1d4d1, (4488, 1)),
    (0x2461, (557, 1)),
    (0x1d452, (4373, 1)),
    (0xfb70, (2521, 1)),
    (0x1d69f, (4938, 1)),
    (0x1d594, (4671, 1)),
    (0x3271, (1472, 2)),
    (0x1e057, (5326, 1)),
    (0x1d40, (154, 1)),
    (0x1ee27, (5383, 1)),
    (0xfd34, (3316, 2)),
    (0x209b, (361, 1)),
    (0x1d578, (4643, 1)),
    (0xff56, (4094, 1)),
    (0x2121, (403, 3)),
    (0x3148, (1107, 1)),
    (0x2f3d, (918, 1)),
    (0x1d724, (5069, 1)),
    (0x2166, (494, 3)),
    (0x2f1b, (884, 1)),
    (0x1d5ea, (4757, 1)),
    (0xfc05, (2688, 2)),
    (0x336a, (2062, 3)),
    (0x24a3, (730, 3)),
    (0x3320, (1804, 5)),
    (0x1ee82, (5440, 1)),
    (0x3344, (1944, 3)),
    (0x210b, (384, 1)),
    (0x1d560, (4619, 1)),
    (0x1ee30, (5391, 1)),
    (0x24e5, (834, 1)),
    (0xffea, (4230, 1)),
    (0x1f236, (5690, 1)),
    (0x2037, (303, 3)),
    (0x1e05a, (5329, 1)),
    (0x2000, (275, 1)),
    (0x1d7e6, (5261, 1)),
    (0xff6d, (4117, 1)),
    (0x3036, (1072, 1)),
    (0x1d6f4, (5021, 1)),
    (0x1ee18, (5372, 1)),
    (0x1ee00, (5349, 1)),
    (0xffb4, (4188, 1)),
    (0x1d6a8, (4945, 1)),
    (0x3362, (2038, 3)),
    (0xfec2, (3936, 1)),
    (0x2f26, (895, 1)),
    (0x33fe, (2432, 3)),
    (0x2034, (298, 3)),
    (0x1cc, (54, 2)),
    (0x33e1, (2353, 2)),
    (0xfcc0, (3079, 2)),
    (0x33de, (2345, 3)),
    (0x1d5ba, (4709, 1)),
    (0x1d47d, (4415, 1)),
    (0xff76, (4126, 1)),
    (0xfce2, (3149, 2)),
    (0x217a, (534, 2)),
    (0xfc29, (2760, 2)),
    (0x1d6e6, (5007, 1)),
    (0x1f139, (5608, 1)),
    (0xff2f, (4055, 1)),
    (0x1d7a2, (5195, 1)),
    (0x3000, (1071, 1)),
    (0x1d6b2, (4955, 1)),
    (0x107a9, (4274, 1)),
    (0xfecb, (3945, 1)),
    (0x2f09, (866, 1)),
    (0xfe16, (3763, 1)),
    (0x2100, (365, 3)),
    (0x3369, (2059, 3)),
    (0x3322, (1814, 3)),
    (0xfca8, (3031, 2)),
    (0x2e0, (83, 1)),
    (0x1d6c3, (4972, 1)),
    (0x2147, (432, 1)),
    (0x1d57a, (4645, 1)),
    (0x1d6ff, (5032, 1)),
    (0x1d5d7, (4738, 1)),
    (0xff0f, (4023, 1)),
    (0x3259, (1438, 2)),
    (0x1d45, (159, 1)),
    (0xfef5, (3987, 3)),
    (0x1ee94, (5457, 1)),
    (0x1d76c, (5141, 1)),
    (0x316f, (1146, 1)),
    (0x2f11, (874, 1)),
    (0xff1f, (4039, 1)),
    (0x3212, (1250, 4)),
    (0x32c0, (1584, 2)),
    (0xffb8, (4192, 1)),
    (0xfc0b, (2700, 2)),
    (0xfc04, (2685, 3)),
    (0x1d651, (4860, 1)),
    (0x1f215, (5657, 1)),
    (0x3325, (1824, 3)),
    (0x1d753, (5116, 1)),
    (0x2fbf, (1048, 1)),
    (0x1d73e, (5095, 1)),
    (0xff06, (4014, 1)),
    (0xfb67, (2512, 1)),
    (0x3242, (1409, 3)),
    (0x1d6c1, (4970, 1)),
    (0xfe14, (3761, 1)),
    (0x1d743, (5100, 1)),
    (0xfeca, (3944, 1)),
    (0xfe43, (3789, 1)),
    (0x1d7d1, (5240, 1)),
    (0x1d563, (4622, 1)),
    (0x1f21f, (5667, 1)),
    (0xfc0d, (2704, 2)),
    (0x2f7c, (981, 1)),
    (0xff82, (4138, 1)),
    (0x3250, (1419, 3)),
    (0x1d6df, (5000, 1)),
    (0x1d7c1, (5226, 1)),
    (0xfcfb, (3202, 2)),
    (0xfd51, (3339, 3)),
    (0x3159, (1124, 1)),
    (0x1d422, (4325, 1)),
    (0xfb04, (2460, 3)),
    (0x313a, (1093, 1)),
    (0x1d638, (4835, 1)),
    (0x33cb, (2301, 2)),
    (0x107a0, (4265, 1)),
    (0x1d492, (4436, 1)),
    (0x2460, (556, 1)),
    (0x1d510, (4548, 1)),
    (0x3374, (2090, 3)),
    (0x1e032, (5289, 1)),
    (0xfb29, (2486, 1)),
    (0x1ee01, (5350, 1)),
    (0x1d623, (4814, 1)),
    (0x331d, (1793, 3)),
    (0xffe8, (4228, 1)),
    (0x1d531, (4579, 1)),
    (0x1ee2a, (5385, 1)),
    (0x2fb9, (1042, 1)),
    (0x24e9, (838, 1)),
    (0xfcf0, (3177, 2)),
    (0x1d4e7, (4510, 1)),
    (0x2fd3, (1068, 1)),
    (0xfd62, (3390, 3)),
    (0x1d7de, (5253, 1)),
    (0x1ee1e, (5378, 1)),
    (0xfdb2, (3624, 3)),
    (0x2fb4, (1037, 1)),
    (0xffc2, (4199, 1)),
    (0x322c, (1343, 3)),
    (0xfe8c, (3881, 2)),
    (0x1d6ef, (5016, 1)),
    (0x329f, (1536, 1)),
    (0x10796, (4255, 1)),
    (0x1d38, (147, 1)),
    (0x331e, (1796, 4)),
    (0x1d65c, (4871, 1)),
    (0xfb76, (2527, 1)),
    (0x1f11d, (5551, 3)),
    (0xfc95, (2988, 2)),
    (0x1f12c, (5594, 1)),
    (0x1d588, (4659, 1)),
    (0x33ee, (2384, 3)),
    (0x24a9, (748, 3)),
    (0x3209, (1219, 3)),
    (0x3202, (1198, 3)),
    (0x1d72a, (5075, 1)),
    (0x2230, (553, 3)),
    (0x1ee21, (5380, 1)),
    (0x3177, (1154, 1)),
    (0x335e, (2030, 2)),
    (0xfeed, (3979, 1)),
    (0x3312, (1741, 4)),
    (0x3392, (2159, 3)),
    (0x1d41e, (4321, 1)),
    (0x1d5a8, (4691, 1)),
    (0xff6b, (4115, 1)),
    (0xfef1, (3983, 1)),
    (0x329b, (1532, 1)),
    (0xfb9d, (2566, 1)),
    (0x1d69a, (4933, 1)),
    (0x32c3, (1590, 2)),
    (0x32b2, (1556, 2)),
    (0xfc8f, (2976, 2)),
    (0x216c, (509, 1)),
    (0x1ee99, (5462, 1)),
    (0xfdbe, (3660, 3)),
    (0x2fb7, (1040, 1)),
    (0x1d760, (5129, 1)),
    (0x33c4, (2284, 2)),
    (0xfc8a, (2966, 2)),
    (0x1d7f9, (5280, 1)),
    (0x1d53c, (4589, 1)),
    (0x32cb, (1608, 3)),
    (0xfd29, (3294, 2)),
    (0x1f128, (5584, 3)),
    (0x1da0, (202, 1)),
    (0xfe9f, (3901, 1)),
    (0x2171, (514, 2)),
    (0x1d56b, (4630, 1)),
    (0x1d64e, (4857, 1)),
    (0x1d432, (4341, 1)),
    (0x3315, (1753, 6)),
    (0xfb64, (2509, 1)),
    (0x3284, (1509, 1)),
    (0x3357, (2015, 3)),
    (0xfc35, (2784, 2)),
    (0x2f92, (1003, 1)),
    (0x216f, (512, 1)),
    (0x33ab, (2222, 3)),
    (0x1d434, (4343, 1)),
    (0x1d4c1, (4473, 1)),
    (0xfdbd, (3657, 3)),
    (0x1d6bd, (4966, 1)),
    (0x1ee34, (5394, 1)),
    (0x1d6cc, (4981, 1)),
    (0x1f135, (5604, 1)),
    (0xfc9f, (3013, 2)),
    (0x1d556, (4609, 1)),
    (0x33c7, (2292, 3)),
    (0xfb00, (2451, 2)),
    (0x1d765, (5134, 1)),
    (0x1d748, (5105, 1)),
    (0x2084, (339, 1)),
    (0x1d44a, (4365, 1)),
    (0x1d62, (187, 1)),
    (0x318c, (1175, 1)),
    (0x2049, (314, 2)),
    (0x32e4, (1641, 1)),
    (0x1d552, (4605, 1)),
    (0x1d546, (4597, 1)),
    (0x1d624, (4815, 1)),
    (0x1eeb9, (5487, 1)),
    (0x1d4da, (4497, 1)),
    (0x1ca, (50, 2)),
    (0x3240, (1403, 3)),
    (0xfba8, (2579, 1)),
    (0xffdc, (4219, 1)),
    (0x3225, (1322, 3)),
    (0x1d799, (5186, 1)),
    (0x1d622, (4813, 1)),
    (0xfb28, (2485, 1)),
    (0x303a, (1075, 1)),
    (0xffb2, (4186, 1)),
    (0x1d592, (4669, 1)),
    (0x207b, (330, 1)),
    (0x1f12a, (5590, 3)),
    (0xfd1f, (3274, 2)),
    (0x1f217, (5659, 1)),
    (0x1d575, (4640, 1)),
    (0xfcf1, (3179, 2)),
    (0xfd6e, (3426, 3)),
    (0x24dd, (826, 1)),
    (0x1d605, (4784, 1)),
    (0x1ee2f, (5390, 1)),
    (0xfd27, (3290, 2)),
    (0x1d52e, (4576, 1)),
    (0x1d428, (4331, 1)),
    (0x1ee36, (5396, 1)),
    (0x32eb, (1648, 1)),
    (0x1d678, (4899, 1)),
    (0xfb14, (2469, 2)),
    (0xff10, (4024, 1)),
    (0x1d60e, (4793, 1)),
    (0xfbad, (2584, 1)),
    (0x1d570, (4635, 1)),
    (0x2f38, (913, 1)),
    (0x2f4a, (931, 1)),
    (0xff3a, (4066, 1)),
    (0x1d741, (5098, 1)),
    (0x1d788, (5169, 1)),
    (0x320d, (1231, 3)),
    (0x1d64b, (4854, 1)),
    (0x2b1, (63, 1)),
    (0x33a6, (2207, 3)),
    (0x1d774, (5149, 1)),
    (0xfd2c, (3300, 2)),
    (0x2109, (381, 2)),
    (0x1f100, (5490, 2)),
    (0xfc03, (2682, 3)),
    (0x1d61, (186, 1)),
    (0x1d7f2, (5273, 1)),
    (0xfbab, (2582, 1)),
    (0xffa7, (4175, 1)),
    (0x1d664, (4879, 1)),
    (0xfcdd, (3137, 2)),
    (0x1d4be, (4470, 1)),
    (0x33da, (2337, 2)),
    (0x1d67, (192, 1)),
    (0x2f60, (953, 1)),
    (0x24a0, (721, 3)),
    (0xfb56, (2495, 1)),
    (0x24bd, (794, 1)),
    (0xfbdf, (2604, 1)),
    (0xffb7, (4191, 1)),
    (0x1d77d, (5158, 1)),
    (0x3296, (1527, 1)),
    (0x1d5b7, (4706, 1)),
    (0x1f23a, (5694, 1)),
    (0x316e, (1145, 1)),
    (0x336d, (2071, 3)),
    (0xff7e, (4134, 1)),
    (0x1d534, (4582, 1)),
    (0x32a6, (1543, 1)),
    (0x1ee7c, (5436, 1)),
    (0x1ee2d, (5388, 1)),
    (0xfd5b, (3369, 3)),
    (0x331a, (1780, 6)),
    (0x32f4, (1657, 1)),
    (0x32bb, (1574, 2)),
    (0x3343, (1940, 4)),
    (0x2fd4, (1069, 1)),
    (0xfcd2, (3115, 2)),
    (0x2189, (543, 3)),
    (0x107ae, (4279, 1)),
    (0xffd3, (4212, 1)),
    (0x2f2d, (902, 1)),
    (0xfd56, (3354, 3)),
    (0x2105, (374, 3)),
    (0xfbff, (2672, 1)),
    (0xfbea, (2615, 3)),
    (0x1d71d, (5062, 1)),
    (0x1ee42, (5400, 1)),
    (0xfdfc, (3753, 4)),
    (0x33d8, (2330, 4)),
    (0x675, (112, 2)),
    (0x1cb, (52, 2)),
    (0xfd6b, (3417, 3)),
    (0x332a, (1837, 3)),
    (0x1d7a7, (5200, 1)),
    (0xfb51, (2490, 1)),
    (0x33fd, (2429, 3)),
    (0x1ee57, (5410, 1)),
    (0xa0, (0, 1)),
    (0x2f2b, (900, 1)),
    (0x1d404, (4295, 1)),
    (0x2081, (336, 1)),
    (0xf79, (132, 3)),
    (0xfeec, (3978, 1)),
    (0xfc2f, (2772, 2)),
    (0x1d52, (171, 1)),
    (0xff41, (4073, 1)),
    (0x1d5ad, (4696, 1)),
    (0x2133, (415, 1)),
    (0x1d7ab, (5204, 1)),
    (0x1d463, (4389, 1)),
    (0xfe71, (3832, 2)),
    (0xfbaf, (2586, 1)),
    (0x1d736, (5087, 1)),
    (0x1d5e, (183, 1)),
    (0x2e3, (86, 1)),
    (0xfea4, (3906, 1)),
    (0x1e035, (5292, 1)),
    (0x3354, (2002, 5)),
    (0x211a, (397, 1)),
    (0xfe8b, (3879, 2)),
    (0x1ee5f, (5414, 1)),
    (0x1d74f, (5112, 1)),
    (0x1d78, (196, 1)),
    (0x1f13f, (5614, 1)),
    (0xffc7, (4204, 1)),
    (0x314b, (1110, 1)),
    (0x1d5a6, (4689, 1)),
    (0xfd0a, (3232, 2)),
    (0x2476, (593, 3)),
    (0x1e037, (5294, 1)),
    (0x1d63, (188, 1)),
    (0xfb62, (2507, 1)),
    (0xfdf6, (3712, 4)),
    (0xfd7a, (3462, 3)),
    (0xffa2, (4170, 1)),
    (0x1c4, (35, 3)),
    (0x1d4f4, (4523, 1)),
    (0x3388, (2135, 3)),
    (0x1d5a2, (4685, 1)),
    (0x2f90, (1001, 1)),
    (0x3281, (1506, 1)),
    (0x1d4b2, (4460, 1)),
    (0x1d61a, (4805, 1)),
    (0xfcc8, (3095, 2)),
    (0x1d61e, (4809, 1)),
    (0xfcb3, (3053, 2)),
    (0xfd86, (3498, 3)),
    (0x2096, (356, 1)),
    (0x1d714, (5053, 1)),
    (0xfed7, (3957, 1)),
    (0xff8c, (4148, 1)),
    (0x2f77, (976, 1)),
    (0x107b4, (4284, 1)),
    (0x2089, (344, 1)),
    (0x3207, (1213, 3)),
    (0xfd15, (3254, 2)),
    (0x1d6b7, (4960, 1)),
    (0x1f134, (5603, 1)),
    (0xfe59, (3812, 1)),
    (0x1d6d4, (4989, 1)),
    (0x1d708, (5041, 1)),
    (0x1d7f6, (5277, 1)),
    (0x1d74e, (5111, 1)),
    (0x1d7db, (5250, 1)),
    (0xfcbe, (3075, 2)),
    (0x2f86, (991, 1)),
    (0x2f35, (910, 1)),
    (0xfb81, (2538, 1)),
    (0x1d569, (4628, 1)),
    (0x3189, (1172, 1)),
    (0xfc71, (2916, 2)),
    (0x1d45b, (4381, 1)),
    (0xff4b, (4083, 1)),
    (0xfbdb, (2599, 1)),
    (0x3243, (1412, 3)),
    (0x2b5, (67, 1)),
    (0x1d564, (4623, 1)),
    (0x3170, (1147, 1)),
    (0xfbdd, (2601, 2)),
    (0x2fce, (1063, 1)),
    (0x215a, (466, 3)),
    (0x2175, (522, 2)),
    (0xfd7f, (3477, 3)),
    (0x3380, (2119, 2)),
    (0xff4c, (4084, 1)),
    (0x1d6cb, (4980, 1)),
    (0xfee2, (3968, 1)),
    (0xffc5, (4202, 1)),
    (0x32ae, (1551, 1)),
    (0xfe69, (3827, 1)),
    (0x3235, (1370, 3)),
    (0x24bc, (793, 1)),
    (0x2fbb, (1044, 1)),
    (0xffa3, (4171, 1)),
    (0x3316, (1759, 6)),
    (0x1f12b, (5593, 1)),
    (0xfc11, (2712, 2)),
    (0x2f44, (925, 1)),
    (0xfbd3, (2591, 1)),
    (0x1d63b, (4838, 1)),
    (0xfd0f, (3242, 2)),
    (0x1f146, (5621, 1)),
    (0x328e, (1519, 1)),
    (0x309c, (1078, 2)),
    (0x1da6, (208, 1)),
    (0x32bd, (1578, 2)),
    (0xfba2, (2571, 1)),
    (0x1d527, (4569, 1)),
    (0xfcc5, (3089, 2)),
    (0x332d, (1850, 5)),
    (0xfe5a, (3813, 1)),
    (0x1d60c, (4791, 1)),
    (0x2481, (630, 4)),
    (0xfe4e, (3802, 1)),
    (0xff45, (4077, 1)),
    (0x32ef, (1652, 1)),
    (0x1d2d, (137, 1)),
    (0x3135, (1088, 1)),
    (0x3342, (1937, 3)),
    (0x1f117, (5533, 3)),
    (0x1d72b, (5076, 1)),
    (0x1d41, (155, 1)),
    (0xff5d, (4101, 1)),
    (0xfd03, (3218, 2)),
    (0xfecc, (3946, 1)),
    (0x1d52f, (4577, 1)),
    (0xfc23, (2748, 2)),
    (0x1d522, (4564, 1)),
    (0x32f8, (1661, 1)),
    (0x3143, (1102, 1)),
    (0x1d450, (4371, 1)),
    (0x2db, (77, 2)),
    (0xfccb, (3101, 2)),
    (0x24b1, (772, 3)),
    (0x1d7ee, (5269, 1)),
    (0x1d52d, (4575, 1)),
    (0x1d792, (5179, 1)),
    (0x2fa9, (1026, 1)),
    (0x3206, (1210, 3)),
    (0x2f22, (891, 1)),
    (0x2f14, (877, 1)),
    (0x309b, (1076, 2)),
    (0x1eea9, (5472, 1)),
    (0xfd74, (3444, 3)),
    (0x1d6a, (195, 1)),
    (0x1e05e, (5333, 1)),
    (0x1d5d6, (4737, 1)),
    (0x1d504, (4539, 1)),
    (0xfc9e, (3011, 2)),
    (0x2153, (445, 3)),
    (0x1d421, (4324, 1)),
    (0x1eea5, (5468, 1)),
    (0x2f67, (960, 1)),
    (0x3d4, (100, 2)),
    (0xfc82, (2950, 2)),
    (0x1ee98, (5461, 1)),
    (0x2f1f, (888, 1)),
    (0x1d7d3, (5242, 1)),
    (0x3313, (1745, 6)),
    (0x325e, (1448, 2)),
    (0x2f74, (973, 1)),
    (0x336c, (2068, 3)),
    (0x2484, (642, 4)),
    (0xfe66, (3825, 1)),
    (0x1078b, (4244, 1)),
    (0xfef6, (3990, 3)),
    (0xfd85, (3495, 3)),
    (0x1d48b, (4429, 1)),
    (0x2487, (654, 4)),
    (0x1d64f, (4858, 1)),
    (0xfe7d, (3852, 2)),
    (0xfd7c, (3468, 3)),
    (0xfcc1, (3081, 2)),
    (0x1d4a2, (4449, 1)),
    (0x203e, (308, 2)),
    (0x1d598, (4675, 1)),
    (0x323c, (1391, 3)),
    (0x247a, (605, 3)),
    (0xfd12, (3248, 2)),
    (0x1d429, (4332, 1)),
    (0x1ee13, (5367, 1)),
    (0xfc8d, (2972, 2)),
    (0x2f29, (898, 1)),
    (0x1d6a1, (4940, 1)),
    (0x1f110, (5512, 3)),
    (0x1d2c, (136, 1)),
    (0x1d7b8, (5217, 1)),
    (0x32ec, (1649, 1)),
    (0x3145, (1104, 1)),
    (0xfdbf, (3663, 3)),
    (0x1d54d, (4601, 1)),
    (0x3181, (1164, 1)),
    (0xfc67, (2893, 3)),
    (0xff34, (4060, 1)),
    (0x1d6e3, (5004, 1)),
    (0xfd70, (3432, 3)),
    (0x1d608, (4787, 1)),
    (0x1d711, (5050, 1)),
    (0xff9d, (4165, 1)),
    (0x1d51f, (4561, 1)),
    (0x1d773, (5148, 1)),
    (0xfd95, (3537, 3)),
    (0xff5f, (4103, 1)),
    (0x2174, (521, 1)),
    (0xfec4, (3938, 1)),
    (0x1d523, (4565, 1)),
    (0x207c, (331, 1)),
    (0x2faa, (1027, 1)),
    (0x1d69e, (4937, 1)),
    (0x2f55, (942, 1)),
    (0x1d582, (4653, 1)),
    (0x1d601, (4780, 1)),
    (0x1d7aa, (5203, 1)),
    (0x215f, (481, 2)),
    (0xff4a, (4082, 1)),
    (0x1d477, (4409, 1)),
    (0x1d525, (4567, 1)),
    (0xfda2, (3576, 3)),
    (0xff94, (4156, 1)),
    (0xff8e, (4150, 1)),
    (0x1d43b, (4350, 1)),
    (0x1d709, (5042, 1)),
    (0x1d56d, (4632, 1)),
    (0x33ea, (2372, 3)),
    (0x1ee77, (5432, 1)),
    (0x1eeac, (5474, 1)),
    (0x334d, (1978, 4)),
    (0x1d6a5, (4944, 1)),
    (0x33c2, (2278, 4)),
    (0x1d661, (4876, 1)),
    (0xfd01, (3214, 2)),
    (0x1d5d2, (4733, 1)),
    (0x2008, (283, 1)),
    (0xfd8f, (3525, 3)),
    (0x3227, (1328, 3)),
    (0x1d447, (4362, 1)),
    (0x249d, (712, 3)),
    (0x1f14b, (5627, 2)),
    (0x1d5fc, (4775, 1)),
    (0x1d50a, (4544, 1)),
    (0xfb86, (2543, 1)),
    (0x1d719, (5058, 1)),
    (0x330f, (1729, 4)),
    (0xfd6a, (3414, 3)),
    (0xfc9d, (3009, 2)),
    (0xfc3e, (2802, 2)),
    (0x1e064, (5339, 1)),
    (0x3d1, (96, 1)),
    (0xffaf, (4183, 1)),
    (0x1d433, (4342, 1)),
    (0xfbfe, (2671, 1)),
    (0x1d4dc, (4499, 1)),
    (0xfbf0, (2633, 3)),
    (0x33dd, (2343, 2)),
    (0xfcf5, (3190, 2)),
    (0xfce6, (3157, 2)),
    (0x1d554, (4607, 1)),
    (0x1fdf, (262, 3)),
    (0x2082, (337, 1)),
    (0xfeaf, (3917, 1)),
    (0x1d43d, (4352, 1)),
    (0x1c9, (48, 2)),
    (0x1e060, (5335, 1)),
    (0xff29, (4049, 1)),
    (0x33b6, (2254, 2)),
    (0xfb57, (2496, 1)),
    (0xfeb2, (3920, 1)),
    (0x1d703, (5036, 1)),
    (0x1d5e9, (4756, 1)),
    (0x24e1, (830, 1)),
    (0x10794, (4253, 1)),
    (0x328f, (1520, 1)),
    (0x1e049, (5312, 1)),
    (0x1d58c, (4663, 1)),
    (0x335d, (2028, 2)),
    (0x3039, (1074, 1)),
    (0x1d46d, (4399, 1)),
    (0x2f49, (930, 1)),
    (0x1f222, (5670, 1)),
    (0x32fe, (1667, 1)),
    (0x1d79c, (5189, 1)),
    (0x3179, (1156, 1)),
    (0x1d697, (4930, 1)),
    (0x1c8, (46, 2)),
    (0x2138, (420, 1)),
    (0x1d6ac, (4949, 1)),
    (0xfc20, (2742, 2)),
    (0x327e, (1503, 2)),
    (0xfd24, (3284, 2)),
    (0x32df, (1636, 1)),
    (0xfc53, (2844, 2)),
    (0xfeb9, (3927, 1)),
    (0x1d76e, (5143, 1)),
    (0x3378, (2099, 3)),
    (0xff9f, (4167, 1)),
    (0x1ee19, (5373, 1)),
    (0x1f119, (5539, 3)),
    (0x1d480, (4418, 1)),
    (0xfc1d, (2736, 2)),
    (0x30ff, (1082, 2)),
    (0xfb63, (2508, 1)),
    (0x1f13a, (5609, 1)),
    (0x333c, (1914, 4)),
    (0xfc87, (2960, 2)),
    (0x1d45c, (4382, 1)),
    (0xfea9, (3911, 1)),
    (0x1d41a, (4317, 1)),
    (0x1eebb, (5489, 1)),
    (0x1d54e, (4602, 1)),
    (0xffc4, (4201, 1)),
    (0x1d423, (4326, 1)),
    (0xfcdc, (3135, 2)),
    (0x1d58f, (4666, 1)),
    (0x1d456, (4376, 1)),
    (0xfd8c, (3516, 3)),
    (0x1d5c2, (4717, 1)),
    (0xfdbb, (3651, 3)),
    (0x1d67c, (4903, 1)),
    (0x1d4ab, (4454, 1)),
    (0x1d557, (4610, 1)),
    (0xfce4, (3153, 2)),
    (0x322f, (1352, 3)),
    (0x33bc, (2266, 2)),
    (0xfe7e, (3854, 2)),
    (0x1d44f, (4370, 1)),
    (0x1d74a, (5107, 1)),
    (0x3167, (1138, 1)),
    (0xfb9e, (2567, 1)),
    (0xff6e, (4118, 1)),
    (0xff90, (4152, 1)),
    (0x1d700, (5033, 1)),
    (0x1d431, (4340, 1)),
    (0x1d459, (4379, 1)),
    (0x213b, (422, 3)),
    (0x1d779, (5154, 1)),
    (0xfc46, (2818, 2)),
    (0x334b, (1970, 3)),
    (0xfc41, (2808, 2)),
    (0x3279, (1488, 2)),
    (0x3294, (1525, 1)),
    (0x1d4eb, (4514, 1)),
    (0x1d71f, (5064, 1)),
    (0x2f28, (897, 1)),
    (0xfbe8, (2613, 1)),
    (0x24a2, (727, 3)),
    (0x1d759, (5122, 1)),
    (0xfcba, (3067, 2)),
    (0x1d2e, (138, 1)),
    (0xfb97, (2560, 1)),
    (0x248c, (666, 2)),
    (0x1da5, (207, 1)),
    (0x33d3, (2318, 2)),
    (0xfdf4, (3704, 4)),
    (0x107a3, (4268, 1)),
    (0x2f8d, (998, 1)),
    (0x1fbf7, (5732, 1)),
    (0x1ee7e, (5437, 1)),
    (0xff31, (4057, 1)),
    (0xfd04, (3220, 2)),
    (0x323e, (1397, 3)),
    (0x246c, (571, 2)),
    (0x1d7e9, (5264, 1)),
    (0xfd76, (3450, 3)),
    (0x3328, (1832, 2)),
    (0x1d602, (4781, 1)),
    (0xfe60, (3819, 1)),
    (0x1d58, (177, 1)),
    (0xfd8e, (3522, 3)),
    (0x320b, (1225, 3)),
    (0x2fa4, (1021, 1)),
    (0xfcd8, (3127, 2)),
    (0xfcd3, (3117, 2)),
    (0x1d446, (4361, 1)),
    (0x3310, (1733, 4)),
    (0x1d66a, (4885, 1)),
    (0x33ce, (2307, 2)),
    (0xf77, (129, 3)),
    (0x1d7b7, (5216, 1)),
    (0xfb8a, (2547, 1)),
    (0x2f2f, (904, 1)),
    (0x3372, (2086, 2)),
    (0x2479, (602, 3)),
    (0x24c8, (805, 1)),
    (0x1d485, (4423, 1)),
    (0x1d476, (4408, 1)),
    (0x33c1, (2276, 2)),
    (0x2f7a, (979, 1)),
    (0x1d6f9, (5026, 1)),
    (0x1d42b, (4334, 1)),
    (0x1d475, (4407, 1)),
    (0xfe51, (3805, 1)),
    (0x1dbf, (233, 1)),
    (0x3180, (1163, 1)),
    (0x1d427, (4330, 1)),
    (0x2f08, (865, 1)),
    (0x1e03a, (5297, 1)),
    (0x3381, (2121, 2)),
    (0xff5e, (4102, 1)),
    (0x1d75f, (5128, 1)),
    (0x1f2, (58, 2)),
    (0x1d539, (4587, 1)),
    (0x1d4f9, (4528, 1)),
    (0x2f43, (924, 1)),
    (0xfd1d, (3270, 2)),
    (0xfc1f, (2740, 2)),
    (0x247d, (614, 4)),
    (0xff3e, (4070, 1)),
    (0x1d776, (5151, 1)),
    (0x1d9f, (201, 1)),
    (0x1ee16, (5370, 1)),
    (0x3256, (1432, 2)),
    (0xff7a, (4130, 1)),
    (0x1d629, (4820, 1)),
    (0x1ee54, (5409, 1)),
    (0xff59, (4097, 1)),
    (0x1d6cf, (4984, 1)),
    (0x1d6f6, (5023, 1)),
    (0x33b5, (2252, 2)),
    (0x1d7b9, (5218, 1)),
    (0xffd2, (4211, 1)),
    (0x3358, (2018, 2)),
    (0x2f2a, (899, 1)),
    (0x2e1, (84, 1)),
    (0xfc68, (2896, 3)),
    (0x3329, (1834, 3)),
    (0xfce1, (3147, 2)),
    (0x1d732, (5083, 1)),
    (0xfb54, (2493, 1)),
    (0x1d4e4, (4507, 1)),
    (0x222d, (548, 3)),
    (0xfdb1, (3621, 3)),
    (0x1d794, (5181, 1)),
    (0xfe88, (3873, 2)),
    (0x1d7c8, (5233, 1)),
    (0xff43, (4075, 1)),
    (0x1d420, (4323, 1)),
    (0xfc3d, (2800, 2)),
    (0xfd18, (3260, 2)),
    (0xfe87, (3871, 2)),
    (0x2fd0, (1065, 1)),
    (0xfbf9, (2660, 3)),
    (0x323b, (1388, 3)),
    (0x1d685, (4912, 1)),
    (0x2087, (342, 1)),
    (0x1d75d, (5126, 1)),
    (0x1d47, (161, 1)),
    (0xfc42, (2810, 2)),
    (0x2f3f, (920, 1)),
    (0xfe82, (3861, 2)),
    (0x1d6c5, (4974, 1)),
    (0x1ee88, (5446, 1)),
    (0x32e9, (1646, 1)),
    (0x1d44d, (4368, 1)),
    (0xfc52, (2842, 2)),
    (0x321c, (1290, 4)),
    (0x1fee, (268, 3)),
    (0x1d448, (4363, 1)),
    (0x3349, (1962, 2)),
    (0x1d5e2, (4749, 1)),
    (0x1f214, (5656, 1)),
    (0x3239, (1382, 3)),
    (0x2005, (280, 1)),
    (0x1f11e, (5554, 3)),
    (0x1f238, (5692, 1)),
    (0x2f3b, (916, 1)),
    (0xfdaf, (3615, 3)),
    (0x1d6da, (4995, 1)),
    (0xffec, (4232, 1)),
    (0x1d62c, (4823, 1)),
    (0x3226, (1325, 3)),
    (0xff93, (4155, 1)),
    (0x3314, (1751, 2)),
    (0x2079, (328, 1)),
    (0xff8f, (4151, 1)),
    (0x3173, (1150, 1)),
    (0x1d583, (4654, 1)),
    (0x1fbf9, (5734, 1)),
    (0xb4, (8, 2)),
    (0xfdc2, (3672, 3)),
    (0x1d32, (141, 1)),
    (0x1d418, (4315, 1)),
    (0xff7f, (4135, 1)),
    (0x1f133, (5602, 1)),
    (0x32a0, (1537, 1)),
    (0xfd63, (3393, 3)),
    (0x1d771, (5146, 1)),
    (0x33ad, (2228, 3)),
    (0x2b7, (69, 1)),
    (0x1f211, (5652, 1)),
    (0x1f16b, (5640, 2)),
    (0xfb77, (2528, 1)),
    (0xfefa, (4002, 3)),
    (0x1d461, (4387, 1)),
    (0x32ea, (1647, 1)),
    (0x1d555, (4608, 1)),
    (0x1dab, (213, 1)),
    (0xfebc, (3930, 1)),
    (0x1d6b1, (4954, 1)),
    (0x317e, (1161, 1)),
    (0x1d5b1, (4700, 1)),
    (0xfe95, (3891, 1)),
    (0x331f, (1800, 4)),
    (0x1d70c, (5045, 1)),
    (0x1d662, (4877, 1)),
    (0x1d70e, (5047, 1)),
    (0x1d417, (4314, 1)),
    (0xfc10, (2710, 2)),
    (0xfc1a, (2730, 2)),
    (0x1d755, (5118, 1)),
    (0x3134, (1087, 1)),
    (0x3308, (1704, 4)),
    (0x1d541, (4593, 1)),
    (0x10787, (4240, 1)),
    (0xfeac, (3914, 1)),
    (0x1f229, (5677, 1)),
    (0x1e046, (5309, 1)),
    (0x24c3, (800, 1)),
    (0x2026, (292, 3)),
    (0x149, (32, 2)),
    (0x33e7, (2365, 2)),
    (0x211c, (399, 1)),
    (0x2f58, (945, 1)),
    (0x1d5ff, (4778, 1)),
    (0xfe9b, (3897, 1)),
    (0xfd2f, (3306, 2)),
    (0x1d710, (5049, 1)),
    (0x1d65, (190, 1)),
    (0xfc1e, (2738, 2)),
    (0xfd9d, (3561, 3)),
    (0x2077, (326, 1)),
    (0x24cb, (808, 1)),
    (0x1eeba, (5488, 1)),
    (0xff0e, (4022, 1)),
    (0xfb7e, (2535, 1)),
    (0x3337, (1895, 3)),
    (0x248d, (668, 2)),
    (0xfd99, (3549, 3)),
    (0xfd65, (3399, 3)),
    (0x1d7ac, (5205, 1)),
    (0x1f11c, (5548, 3)),
    (0x32ff, (1668, 2)),
    (0x1ee7a, (5434, 1)),
    (0x1e06b, (5346, 1)),
    (0xfe47, (3791, 1)),
    (0x1d637, (4834, 1)),
    (0x3264, (1456, 1)),
    (0xfc58, (2854, 2)),
    (0x1d603, (4782, 1)),
    (0x1d478, (4410, 1)),
    (0xff0a, (4018, 1)),
    (0xfda3, (3579, 3)),
    (0x1d44, (158, 1)),
    (0x24d0, (813, 1)),
    (0xab5e, (2448, 1)),
    (0xfcfc, (3204, 2)),
    (0xffe0, (4220, 1)),
    (0x1ee0a, (5358, 1)),
    (0x313d, (1096, 1)),
    (0x3398, (2174, 2)),
    (0xfcd0, (3111, 2)),
    (0x2f6e, (967, 1)),
    (0x202f, (295, 1)),
    (0xfcaa, (3035, 2)),
    (0x1d43a, (4349, 1)),
    (0xfd23, (3282, 2)),
    (0x2ef3, (856, 1)),
    (0xfe5f, (3818, 1)),
    (0x2f93, (1004, 1)),
    (0x2086, (341, 1)),
    (0xfd6d, (3423, 3)),
    (0x249f, (718, 3)),
    (0x1d424, (4327, 1)),
    (0x1fbf8, (5733, 1)),
    (0x1d462, (4388, 1)),
    (0xfe4d, (3801, 1)),
    (0x1d53b, (4588, 1)),
    (0xfe49, (3793, 2)),
    (0x1d6ab, (4948, 1)),
    (0x3132, (1085, 1)),
    (0x1d7c2, (5227, 1)),
    (0xfd9c, (3558, 3)),
    (0x2fc2, (1051, 1)),
    (0x33f4, (2402, 3)),
    (0x213c, (425, 1)),
    (0x1d7e8, (5263, 1)),
    (0xff88, (4144, 1)),
    (0x1d79d, (5190, 1)),
    (0x24c1, (798, 1)),
    (0x24e0, (829, 1)),
    (0x1eeb8, (5486, 1)),
    (0xfc70, (2914, 2)),
    (0xfc6c, (2906, 2)),
    (0x2fac, (1029, 1)),
    (0x1f202, (5650, 1)),
    (0xfbf3, (2642, 3)),
    (0x2f78, (977, 1)),
    (0x3255, (1430, 2)),
    (0x2f2e, (903, 1)),
    (0xfb24, (2481, 1)),
    (0x32af, (1552, 1)),
    (0x1d4a, (164, 1)),
    (0x2f25, (894, 1)),
    (0x1ee6e, (5424, 1)),
    (0xfd2d, (3302, 2)),
    (0xff6a, (4114, 1)),
    (0x2466, (562, 1)),
    (0x1d579, (4644, 1)),
    (0x1f231, (5685, 1)),
    (0xfc61, (2875, 3)),
    (0x1d7fd, (5284, 1)),
    (0xfd5f, (3381, 3)),
    (0x1ee1a, (5374, 1)),
    (0x3348, (1958, 4)),
    (0xfba9, (2580, 1)),
    (0x1d45f, (4385, 1)),
    (0x1d66d, (4888, 1)),
    (0xfce8, (3161, 2)),
    (0xfb5b, (2500, 1)),
    (0x1ee62, (5416, 1)),
    (0x3146, (1105, 1)),
    (0x33ac, (2225, 3)),
    (0x1f149, (5624, 1)),
    (0x3295, (1526, 1)),
    (0x3333, (1877, 4)),
    (0xfc0f, (2708, 2)),
    (0xff8a, (4146, 1)),
    (0x3387, (2133, 2)),
    (0x676, (114, 2)),
    (0xffcd, (4208, 1)),
    (0xfe86, (3869, 2)),
    (0x1d6e8, (5009, 1)),
    (0xfc40, (2806, 2)),
    (0xfc0a, (2698, 2)),
    (0x10788, (4241, 1)),
    (0x2fc0, (1049, 1)),
    (0x1d5b6, (4705, 1)),
    (0xffa8, (4176, 1)),
    (0x3289, (1514, 1)),
    (0xfd79, (3459, 3)),
    (0x3300, (1670, 5)),
    (0x1d55, (174, 1)),
    (0x24b5, (784, 3)),
    (0x2f4c, (933, 1)),
    (0x3163, (1134, 1)),
    (0x2002, (277, 1)),
    (0x2f57, (944, 1)),
    (0xfcdb, (3133, 2)),
    (0x1d49f, (4448, 1)),
    (0x1d688, (4915, 1)),
    (0xff18, (4032, 1)),
    (0x2f54, (941, 1)),
    (0x1ee85, (5443, 1)),
    (0x2fd1, (1066, 1)),
    (0x33c5, (2286, 2)),
    (0xfb53, (2492, 1)),
    (0x3197, (1183, 1)),
    (0x2fcf, (1064, 1)),
    (0x1d516, (4553, 1)),
    (0x3201, (1195, 3)),
    (0xfd82, (3486, 3)),
    (0xff16, (4030, 1)),
    (0x2150, (435, 3)),
    (0x1f109, (5508, 2)),
    (0xfe9d, (3899, 1)),
    (0x210f, (388, 1)),
    (0x320e, (1234, 4)),
    (0x1e040, (5303, 1)),
    (0x330a, (1711, 3)),
    (0x1ee0e, (5362, 1)),
    (0xfc45, (2816, 2)),
    (0xff48, (4080, 1)),
    (0xfc47, (2820, 2)),
    (0x1d505, (4540, 1)),
    (0x2169, (503, 1)),
    (0x24dc, (825, 1)),
    (0x1d7d8, (5247, 1)),
    (0xfb55, (2494, 1)),
    (0xfe84, (3865, 2)),
    (0x1ee22, (5381, 1)),
    (0x1d772, (5147, 1)),
    (0x33f0, (2390, 3)),
    (0x1d4b1, (4459, 1)),
    (0xff99, (4161, 1)),
    (0xfd2e, (3304, 2)),
    (0x2159, (463, 3)),
    (0x1d58d, (4664, 1)),
    (0x1d627, (4818, 1)),
    (0xfeeb, (3977, 1)),
    (0x3334, (1881, 6)),
    (0x1f126, (5578, 3)),
    (0x3144, (1103, 1)),
    (0x1e036, (5293, 1)),
    (0x1db9, (227, 1)),
    (0x1d6ea, (5011, 1)),
    (0x1d6ee, (5015, 1)),
    (0xfec6, (3940, 1)),
    (0x1d64c, (4855, 1)),
    (0xfcbb, (3069, 2)),
    (0x2033, (296, 2)),
    (0x2009, (284, 1)),
    (0x3377, (2097, 2)),
    (0x3160, (1131, 1)),
    (0x1d48c, (4430, 1)),
    (0x24b3, (778, 3)),
    (0x1d4d0, (4487, 1)),
    (0xffcb, (4206, 1)),
    (0xfdad, (3609, 3)),
    (0x1ee8b, (5448, 1)),
    (0xfeb1, (3919, 1)),
    (0xfcea, (3165, 2)),
    (0x2f76, (975, 1)),
    (0x32be, (1580, 2)),
    (0x1d7b1, (5210, 1)),
    (0x1d5f8, (4771, 1)),
    (0xfd73, (3441, 3)),
    (0xff1a, (4034, 1)),
    (0xfca2, (3019, 2)),
    (0x211b, (398, 1)),
    (0x1d5b2, (4701, 1)),
    (0xfb60, (2505, 1)),
    (0x1ee2e, (5389, 1)),
    (0x2071, (322, 1)),
    (0x1d4bb, (4468, 1)),
    (0x33fc, (2426, 3)),
    (0xfeef, (3981, 1)),
    (0x1d4fb, (4530, 1)),
    (0x1d728, (5073, 1)),
    (0xfcff, (3210, 2)),
    (0x1d6f8, (5025, 1)),
    (0x1d535, (4583, 1)),
    (0x1d34, (143, 1)),
    (0x2165, (492, 2)),
    (0x1ee2c, (5387, 1)),
    (0x1d5dd, (4744, 1)),
    (0x2140, (429, 1)),
    (0x322d, (1346, 3)),
    (0x1ee96, (5459, 1)),
    (0xffbe, (4198, 1)),
    (0x1eeb5, (5483, 1)),
    (0x3311, (1737, 4)),
    (0xfd89, (3507, 3)),
    (0x32d7, (1628, 1)),
    (0x2f91, (1002, 1)),
    (0x10798, (4257, 1)),
    (0x246b, (569, 2)),
    (0x24c2, (799, 1)),
    (0x1d50e, (4546, 1)),
    (0xffbc, (4196, 1)),
    (0xfd9e, (3564, 3)),
    (0x2115, (393, 1)),
    (0x1d715, (5054, 1)),
    (0xfcac, (3039, 2)),
    (0xfc98, (2995, 3)),
    (0xfc66, (2890, 3)),
    (0x2d6f, (854, 1)),
    (0x1d59c, (4679, 1)),
    (0xfc01, (2676, 3)),
    (0x1ee49, (5402, 1)),
    (0x2119, (396, 1)),
    (0x24d7, (820, 1)),
    (0x1d642, (4845, 1)),
    (0x3304, (1687, 5)),
    (0x3198, (1184, 1)),
    (0xfed4, (3954, 1)),
    (0x2f6c, (965, 1)),
    (0x1d406, (4297, 1)),
    (0x1d61d, (4808, 1)),
    (0x33d5, (2322, 3)),
    (0x1ee07, (5355, 1)),
    (0x1d4ce, (4485, 1)),
    (0x1f101, (5492, 2)),
    (0x10792, (4251, 1)),
    (0x24be, (795, 1)),
    (0x2fbc, (1045, 1)),
    (0x1f14f, (5636, 2)),
    (0xfe12, (3759, 1)),
    (0xfec7, (3941, 1)),
    (0xfc2d, (2768, 2)),
    (0x248a, (662, 2)),
    (0x1fed, (265, 3)),
    (0x1d6d5, (4990, 1)),
    (0x2fb2, (1035, 1)),
    (0xfc8b, (2968, 2)),
    (0x3158, (1123, 1)),
    (0xffe3, (4223, 2)),
    (0xfb84, (2541, 1)),
    (0xfb65, (2510, 1)),
    (0x1ee93, (5456, 1)),
    (0x3208, (1216, 3)),
    (0x32fc, (1665, 1)),
    (0xfe94, (3890, 1)),
    (0x2f4f, (936, 1)),
    (0x2f87, (992, 1)),
    (0x1ee75, (5430, 1)),
    (0x2057, (316, 4)),
    (0x1d617, (4802, 1)),
    (0x1d5e1, (4748, 1)),
    (0xfdac, (3606, 3)),
    (0x2f0e, (871, 1)),
    (0x211d, (400, 1)),
    (0x331c, (1790, 3)),
    (0x2f83, (988, 1)),
    (0x1d5c3, (4718, 1)),
    (0x3373, (2088, 2)),
    (0x1f13b, (5610, 1)),
    (0x2486, (650, 4)),
    (0x1d665, (4880, 1)),
    (0xfce0, (3144, 3)),
    (0x3d3, (98, 2)),
    (0x1d403, (4294, 1)),
    (0x1d640, (4843, 1)),
    (0x24ac, (757, 3)),
    (0x2f39, (914, 1)),
    (0x1f140, (5615, 1)),
    (0xfb6f, (2520, 1)),
    (0xfd13, (3250, 2)),
    (0x1d4c6, (4477, 1)),
    (0x1f248, (5720, 3)),
    (0x3183, (1166, 1)),
    (0x1d62e, (4825, 1)),
    (0x1f148, (5623, 1)),
    (0xfb89, (2546, 1)),
    (0x1ee81, (5439, 1)),
    (0xfc25, (2752, 2)),
    (0x1f223, (5671, 1)),
    (0x334e, (1982, 4)),
    (0x2fd2, (1067, 1)),
    (0xfd54, (3348, 3)),
    (0xff01, (4009, 1)),
    (0x1d740, (5097, 1)),
    (0x1d7bc, (5221, 1)),
    (0x1db4, (222, 1)),
    (0x1d43e, (4353, 1)),
    (0xfca9, (3033, 2)),
    (0xfd22, (3280, 2)),
    (0x2f23, (892, 1)),
    (0x314e, (1113, 1)),
    (0xfe8a, (3877, 2)),
    (0xff03, (4011, 1)),
    (0x3292, (1523, 1)),
    (0xfcf6, (3192, 2)),
    (0x1d3f, (153, 1)),
    (0x1db8, (226, 1)),
    (0xfe68, (3826, 1)),
    (0x1d69, (194, 1)),
    (0x1079b, (4260, 1)),
    (0x331b, (1786, 4)),
    (0xfda7, (3591, 3)),
    (0xffdb, (4218, 1)),
    (0xfc7c, (2938, 2)),
    (0xfda5, (3585, 3)),
    (0x3341, (1934, 3)),
    (0x24a7, (742, 3)),
    (0x3216, (1266, 4)),
    (0x2f3e, (919, 1)),
    (0xff9c, (4164, 1)),
    (0xfb20, (2477, 1)),
    (0x1f116, (5530, 3)),
    (0x325b, (1442, 2)),
    (0x1d5e6, (4753, 1)),
    (0x1d79e, (5191, 1)),
    (0x1ee14, (5368, 1)),
    (0x333f, (1927, 2)),
    (0x32d4, (1625, 1)),
    (0x1f22d, (5681, 1)),
    (0xfd88, (3504, 3)),
    (0x1d4d9, (4496, 1)),
    (0xfdaa, (3600, 3)),
    (0xfcc6, (3091, 2)),
    (0x1d56e, (4633, 1)),
    (0x1ee39, (5398, 1)),
    (0x1d48a, (4428, 1)),
    (0x1d7d0, (5239, 1)),
    (0xb9, (13, 1)),
    (0x1f120, (5560, 3)),
    (0x1d60b, (4790, 1)),
    (0x2f70, (969, 1)),
    (0x1d4fa, (4529, 1)),
    (0x2f5c, (949, 1)),
    (0x32ab, (1548, 1)),
    (0xfba3, (2572, 1)),
    (0x2f02, (859, 1)),
    (0x1f11f, (5557, 3)),
    (0xfc69, (2899, 3)),
    (0x24d4, (817, 1)),
    (0x2491, (676, 3)),
    (0x326b, (1463, 1)),
    (0xfc08, (2694, 2)),
    (0x1d7b2, (5211, 1)),
    (0x33ff, (2435, 3)),
    (0xfb8d, (2550, 1)),
    (0x1fbf0, (5725, 1)),
    (0x3252, (1424, 2)),
    (0x1d6e5, (5006, 1)),
    (0x1d5ac, (4695, 1)),
    (0xfb94, (2557, 1)),
    (0x2f63, (956, 1)),
    (0x107a2, (4267, 1)),
    (0xfc06, (2690, 2)),
    (0xfc5a, (2858, 2)),
    (0xff75, (4125, 1)),
    (0xfeda, (3960, 1)),
    (0xff79, (4129, 1)),
    (0x2462, (558, 1)),
    (0xfc09, (2696, 2)),
    (0x2111, (390, 1)),
    (0x319e, (1190, 1)),
    (0x1d451, (4372, 1)),
    (0x2f20, (889, 1)),
    (0x1d6a0, (4939, 1)),
    (0x1d577, (4642, 1)),
    (0x1d7b6, (5215, 1)),
    (0xff15, (4029, 1)),
    (0x1d744, (5101, 1)),
    (0x1f21c, (5664, 1)),
    (0x1fbf2, (5727, 1)),
    (0xfc3a, (2794, 2)),
    (0x337b, (2107, 2)),
    (0xfdb8, (3642, 3)),
    (0xffc3, (4200, 1)),
    (0x33db, (2339, 2)),
    (0xff0c, (4020, 1)),
    (0x1d52a, (4572, 1)),
    (0x1ee9b, (5464, 1)),
    (0x24e2, (831, 1)),
    (0xff9e, (4166, 1)),
    (0x32de, (1635, 1)),
    (0x1d574, (4639, 1)),
    (0x1ee76, (5431, 1)),
    (0x1d59e, (4681, 1)),
    (0x1f244, (5708, 3)),
    (0x1f137, (5606, 1)),
    (0xfea0, (3902, 1)),
    (0xff2a, (4050, 1)),
    (0x314f, (1114, 1)),
    (0x1d47c, (4414, 1)),
    (0x1d467, (4393, 1)),
    (0xff4f, (4087, 1)),
    (0xfea1, (3903, 1)),
    (0x33a9, (2217, 2)),
    (0x10799, (4258, 1)),
    (0x1ee12, (5366, 1)),
    (0x2492, (679, 3)),
    (0x1d696, (4929, 1)),
    (0xfcab, (3037, 2)),
    (0xfd19, (3262, 2)),
    (0x1d5e8, (4755, 1)),
    (0x1ee1f, (5379, 1)),
    (0xfe91, (3887, 1)),
    (0x1c7, (44, 2)),
    (0x1d681, (4908, 1)),
    (0x24b7, (788, 1)),
    (0x1d784, (5165, 1)),
    (0x1d742, (5099, 1)),
    (0x33a2, (2196, 3)),
    (0x1d645, (4848, 1)),
    (0x1ee70, (5426, 1)),
    (0x1d611, (4796, 1)),
    (0x337c, (2109, 2)),
    (0x1d442, (4357, 1)),
    (0xfe32, (3772, 1)),
    (0x1d31, (140, 1)),
    (0x3138, (1091, 1)),
    (0x2485, (646, 4)),
    (0x1f114, (5524, 3)),
    (0x1d5d0, (4731, 1)),
    (0x1d635, (4832, 1)),
    (0x3309, (1708, 3)),
    (0x1d408, (4299, 1)),
    (0xfe50, (3804, 1)),
    (0x1ee8d, (5450, 1)),
    (0xfd93, (3531, 3)),
    (0x1d67b, (4902, 1)),
    (0x1d4db, (4498, 1)),
    (0x1f136, (5605, 1)),
    (0x1f22f, (5683, 1)),
    (0x1d7ed, (5268, 1)),
    (0x32f9, (1662, 1)),
    (0x32aa, (1547, 1)),
    (0x33af, (2236, 6)),
    (0x24e4, (833, 1)),
    (0x2003, (278, 1)),
    (0xfd80, (3480, 3)),
    (0x1e04e, (5317, 1)),
    (0x1d59b, (4678, 1)),
    (0x3285, (1510, 1)),
    (0x1d78e, (5175, 1)),
    (0x3379, (2102, 3)),
    (0x107b2, (4282, 1)),
    (0xfeb7, (3925, 1)),
    (0x2470, (579, 2)),
    (0x1d620, (4811, 1)),
    (0x1d4b4, (4462, 1)),
    (0x1d754, (5117, 1)),
    (0x1f246, (5714, 3)),
    (0x2160, (483, 1)),
    (0x1d72f, (5080, 1)),
    (0xfe4f, (3803, 1)),
    (0x1d47a, (4412, 1)),
    (0x1fcd, (247, 3)),
    (0x327d, (1499, 4)),
    (0x338e, (2150, 2)),
    (0x33b3, (2248, 2)),
    (0xfd10, (3244, 2)),
    (0x2f37, (912, 1)),
    (0x3187, (1170, 1)),
    (0xff5c, (4100, 1)),
    (0x2135, (417, 1)),
    (0x1d73b, (5092, 1)),
    (0x3178, (1155, 1)),
    (0xfc86, (2958, 2)),
    (0x2fa5, (1022, 1)),
    (0x1d6f1, (5018, 1)),
    (0x1db5, (223, 1)),
    (0xfb7d, (2534, 1)),
    (0xfc48, (2822, 2)),
    (0x1d56, (175, 1)),
    (0x1d647, (4850, 1)),
    (0xfe65, (3824, 1)),
    (0xfc18, (2726, 2)),
    (0x33f1, (2393, 3)),
    (0x328c, (1517, 1)),
    (0x32b9, (1570, 2)),
    (0xfb79, (2530, 1)),
    (0x1d4ee, (4517, 1)),
    (0x338f, (2152, 2)),
    (0x1d663, (4878, 1)),
    (0x33b7, (2256, 2)),
    (0x1d55a, (4613, 1)),
    (0xfcb1, (3049, 2)),
    (0x3254, (1428, 2)),
    (0xfbde, (2603, 1)),
    (0x2f73, (972, 1)),
    (0x1d497, (4441, 1)),
    (0xff89, (4145, 1)),
    (0x1d5f5, (4768, 1)),
];

pub(crate) const CJK_COMPAT_VARIANTS_DECOMPOSED_CHARS: &[char] = &[
    '\u{349E}',
    '\u{FE00}',
    '\u{34B9}',
    '\u{FE00}',
    '\u{34BB}',
    '\u{FE00}',
    '\u{34DF}',
    '\u{FE00}',
    '\u{3515}',
    '\u{FE00}',
    '\u{36EE}',
    '\u{FE00}',
    '\u{36FC}',
    '\u{FE00}',
    '\u{3781}',
    '\u{FE00}',
    '\u{382F}',
    '\u{FE00}',
    '\u{3862}',
    '\u{FE00}',
    '\u{387C}',
    '\u{FE00}',
    '\u{38C7}',
    '\u{FE00}',
    '\u{38E3}',
    '\u{FE00}',
    '\u{391C}',
    '\u{FE00}',
    '\u{393A}',
    '\u{FE00}',
    '\u{3A2E}',
    '\u{FE00}',
    '\u{3A6C}',
    '\u{FE00}',
    '\u{3AE4}',
    '\u{FE00}',
    '\u{3B08}',
    '\u{FE00}',
    '\u{3B19}',
    '\u{FE00}',
    '\u{3B49}',
    '\u{FE00}',
    '\u{3B9D}',
    '\u{FE00}',
    '\u{3B9D}',
    '\u{FE01}',
    '\u{3C18}',
    '\u{FE00}',
    '\u{3C4E}',
    '\u{FE00}',
    '\u{3D33}',
    '\u{FE00}',
    '\u{3D96}',
    '\u{FE00}',
    '\u{3EAC}',
    '\u{FE00}',
    '\u{3EB8}',
    '\u{FE00}',
    '\u{3EB8}',
    '\u{FE01}',
    '\u{3F1B}',
    '\u{FE00}',
    '\u{3FFC}',
    '\u{FE00}',
    '\u{4008}',
    '\u{FE00}',
    '\u{4018}',
    '\u{FE00}',
    '\u{4039}',
    '\u{FE00}',
    '\u{4039}',
    '\u{FE01}',
    '\u{4046}',
    '\u{FE00}',
    '\u{4096}',
    '\u{FE00}',
    '\u{40E3}',
    '\u{FE00}',
    '\u{412F}',
    '\u{FE00}',
    '\u{4202}',
    '\u{FE00}',
    '\u{4227}',
    '\u{FE00}',
    '\u{42A0}',
    '\u{FE00}',
    '\u{4301}',
    '\u{FE00}',
    '\u{4334}',
    '\u{FE00}',
    '\u{4359}',
    '\u{FE00}',
    '\u{43D5}',
    '\u{FE00}',
    '\u{43D9}',
    '\u{FE00}',
    '\u{440B}',
    '\u{FE00}',
    '\u{446B}',
    '\u{FE00}',
    '\u{452B}',
    '\u{FE00}',
    '\u{455D}',
    '\u{FE00}',
    '\u{4561}',
    '\u{FE00}',
    '\u{456B}',
    '\u{FE00}',
    '\u{45D7}',
    '\u{FE00}',
    '\u{45F9}',
    '\u{FE00}',
    '\u{4635}',
    '\u{FE00}',
    '\u{46BE}',
    '\u{FE00}',
    '\u{46C7}',
    '\u{FE00}',
    '\u{4995}',
    '\u{FE00}',
    '\u{49E6}',
    '\u{FE00}',
    '\u{4A6E}',
    '\u{FE00}',
    '\u{4A76}',
    '\u{FE00}',
    '\u{4AB2}',
    '\u{FE00}',
    '\u{4B33}',
    '\u{FE00}',
    '\u{4BCE}',
    '\u{FE00}',
    '\u{4CCE}',
    '\u{FE00}',
    '\u{4CED}',
    '\u{FE00}',
    '\u{4CF8}',
    '\u{FE00}',
    '\u{4D56}',
    '\u{FE00}',
    '\u{4E0D}',
    '\u{FE00}',
    '\u{4E26}',
    '\u{FE00}',
    '\u{4E32}',
    '\u{FE00}',
    '\u{4E38}',
    '\u{FE00}',
    '\u{4E39}',
    '\u{FE00}',
    '\u{4E3D}',
    '\u{FE00}',
    '\u{4E41}',
    '\u{FE00}',
    '\u{4E82}',
    '\u{FE00}',
    '\u{4E86}',
    '\u{FE00}',
    '\u{4EAE}',
    '\u{FE00}',
    '\u{4EC0}',
    '\u{FE00}',
    '\u{4ECC}',
    '\u{FE00}',
    '\u{4EE4}',
    '\u{FE00}',
    '\u{4F60}',
    '\u{FE00}',
    '\u{4F80}',
    '\u{FE00}',
    '\u{4F86}',
    '\u{FE00}',
    '\u{4F8B}',
    '\u{FE00}',
    '\u{4FAE}',
    '\u{FE00}',
    '\u{4FAE}',
    '\u{FE01}',
    '\u{4FBB}',
    '\u{FE00}',
    '\u{4FBF}',
    '\u{FE00}',
    '\u{5002}',
    '\u{FE00}',
    '\u{502B}',
    '\u{FE00}',
    '\u{507A}',
    '\u{FE00}',
    '\u{5099}',
    '\u{FE00}',
    '\u{50CF}',
    '\u{FE00}',
    '\u{50DA}',
    '\u{FE00}',
    '\u{50E7}',
    '\u{FE00}',
    '\u{50E7}',
    '\u{FE01}',
    '\u{5140}',
    '\u{FE00}',
    '\u{5145}',
    '\u{FE00}',
    '\u{514D}',
    '\u{FE00}',
    '\u{514D}',
    '\u{FE01}',
    '\u{5154}',
    '\u{FE00}',
    '\u{5164}',
    '\u{FE00}',
    '\u{5167}',
    '\u{FE00}',
    '\u{5168}',
    '\u{FE00}',
    '\u{5169}',
    '\u{FE00}',
    '\u{516D}',
    '\u{FE00}',
    '\u{5177}',
    '\u{FE00}',
    '\u{5180}',
    '\u{FE00}',
    '\u{518D}',
    '\u{FE00}',
    '\u{5192}',
    '\u{FE00}',
    '\u{5195}',
    '\u{FE00}',
    '\u{5197}',
    '\u{FE00}',
    '\u{51A4}',
    '\u{FE00}',
    '\u{51AC}',
    '\u{FE00}',
    '\u{51B5}',
    '\u{FE00}',
    '\u{51B5}',
    '\u{FE01}',
    '\u{51B7}',
    '\u{FE00}',
    '\u{51C9}',
    '\u{FE00}',
    '\u{51CC}',
    '\u{FE00}',
    '\u{51DC}',
    '\u{FE00}',
    '\u{51DE}',
    '\u{FE00}',
    '\u{51F5}',
    '\u{FE00}',
    '\u{5203}',
    '\u{FE00}',
    '\u{5207}',
    '\u{FE00}',
    '\u{5207}',
    '\u{FE01}',
    '\u{5217}',
    '\u{FE00}',
    '\u{5229}',
    '\u{FE00}',
    '\u{523A}',
    '\u{FE00}',
    '\u{523B}',
    '\u{FE00}',
    '\u{5246}',
    '\u{FE00}',
    '\u{5272}',
    '\u{FE00}',
    '\u{5277}',
    '\u{FE00}',
    '\u{5289}',
    '\u{FE00}',
    '\u{529B}',
    '\u{FE00}',
    '\u{52A3}',
    '\u{FE00}',
    '\u{52B3}',
    '\u{FE00}',
    '\u{52C7}',
    '\u{FE00}',
    '\u{52C7}',
    '\u{FE01}',
    '\u{52C9}',
    '\u{FE00}',
    '\u{52C9}',
    '\u{FE01}',
    '\u{52D2}',
    '\u{FE00}',
    '\u{52DE}',
    '\u{FE00}',
    '\u{52E4}',
    '\u{FE00}',
    '\u{52E4}',
    '\u{FE01}',
    '\u{52F5}',
    '\u{FE00}',
    '\u{52FA}',
    '\u{FE00}',
    '\u{52FA}',
    '\u{FE01}',
    '\u{5305}',
    '\u{FE00}',
    '\u{5306}',
    '\u{FE00}',
    '\u{5317}',
    '\u{FE00}',
    '\u{5317}',
    '\u{FE01}',
    '\u{533F}',
    '\u{FE00}',
    '\u{5349}',
    '\u{FE00}',
    '\u{5351}',
    '\u{FE00}',
    '\u{5351}',
    '\u{FE01}',
    '\u{535A}',
    '\u{FE00}',
    '\u{5373}',
    '\u{FE00}',
    '\u{5375}',
    '\u{FE00}',
    '\u{537D}',
    '\u{FE00}',
    '\u{537F}',
    '\u{FE00}',
    '\u{537F}',
    '\u{FE01}',
    '\u{537F}',
    '\u{FE02}',
    '\u{53C3}',
    '\u{FE00}',
    '\u{53CA}',
    '\u{FE00}',
    '\u{53DF}',
    '\u{FE00}',
    '\u{53E5}',
    '\u{FE00}',
    '\u{53EB}',
    '\u{FE00}',
    '\u{53F1}',
    '\u{FE00}',
    '\u{5406}',
    '\u{FE00}',
    '\u{540F}',
    '\u{FE00}',
    '\u{541D}',
    '\u{FE00}',
    '\u{5438}',
    '\u{FE00}',
    '\u{5442}',
    '\u{FE00}',
    '\u{5448}',
    '\u{FE00}',
    '\u{5468}',
    '\u{FE00}',
    '\u{549E}',
    '\u{FE00}',
    '\u{54A2}',
    '\u{FE00}',
    '\u{54BD}',
    '\u{FE00}',
    '\u{54F6}',
    '\u{FE00}',
    '\u{5510}',
    '\u{FE00}',
    '\u{5553}',
    '\u{FE00}',
    '\u{5555}',
    '\u{FE00}',
    '\u{5563}',
    '\u{FE00}',
    '\u{5584}',
    '\u{FE00}',
    '\u{5584}',
    '\u{FE01}',
    '\u{5587}',
    '\u{FE00}',
    '\u{5599}',
    '\u{FE00}',
    '\u{5599}',
    '\u{FE01}',
    '\u{559D}',
    '\u{FE00}',
    '\u{559D}',
    '\u{FE01}',
    '\u{55AB}',
    '\u{FE00}',
    '\u{55B3}',
    '\u{FE00}',
    '\u{55C0}',
    '\u{FE00}',
    '\u{55C2}',
    '\u{FE00}',
    '\u{55E2}',
    '\u{FE00}',
    '\u{5606}',
    '\u{FE00}',
    '\u{5606}',
    '\u{FE01}',
    '\u{5651}',
    '\u{FE00}',
    '\u{5668}',
    '\u{FE00}',
    '\u{5674}',
    '\u{FE00}',
    '\u{56F9}',
    '\u{FE00}',
    '\u{5716}',
    '\u{FE00}',
    '\u{5717}',
    '\u{FE00}',
    '\u{578B}',
    '\u{FE00}',
    '\u{57CE}',
    '\u{FE00}',
    '\u{57F4}',
    '\u{FE00}',
    '\u{580D}',
    '\u{FE00}',
    '\u{5831}',
    '\u{FE00}',
    '\u{5832}',
    '\u{FE00}',
    '\u{5840}',
    '\u{FE00}',
    '\u{585A}',
    '\u{FE00}',
    '\u{585A}',
    '\u{FE01}',
    '\u{585E}',
    '\u{FE00}',
    '\u{58A8}',
    '\u{FE00}',
    '\u{58AC}',
    '\u{FE00}',
    '\u{58B3}',
    '\u{FE00}',
    '\u{58D8}',
    '\u{FE00}',
    '\u{58DF}',
    '\u{FE00}',
    '\u{58EE}',
    '\u{FE00}',
    '\u{58F2}',
    '\u{FE00}',
    '\u{58F7}',
    '\u{FE00}',
    '\u{5906}',
    '\u{FE00}',
    '\u{591A}',
    '\u{FE00}',
    '\u{5922}',
    '\u{FE00}',
    '\u{5944}',
    '\u{FE00}',
    '\u{5948}',
    '\u{FE00}',
    '\u{5951}',
    '\u{FE00}',
    '\u{5954}',
    '\u{FE00}',
    '\u{5962}',
    '\u{FE00}',
    '\u{5973}',
    '\u{FE00}',
    '\u{59D8}',
    '\u{FE00}',
    '\u{59EC}',
    '\u{FE00}',
    '\u{5A1B}',
    '\u{FE00}',
    '\u{5A27}',
    '\u{FE00}',
    '\u{5A62}',
    '\u{FE00}',
    '\u{5A66}',
    '\u{FE00}',
    '\u{5AB5}',
    '\u{FE00}',
    '\u{5B08}',
    '\u{FE00}',
    '\u{5B28}',
    '\u{FE00}',
    '\u{5B3E}',
    '\u{FE00}',
    '\u{5B3E}',
    '\u{FE01}',
    '\u{5B85}',
    '\u{FE00}',
    '\u{5BC3}',
    '\u{FE00}',
    '\u{5BD8}',
    '\u{FE00}',
    '\u{5BE7}',
    '\u{FE00}',
    '\u{5BE7}',
    '\u{FE01}',
    '\u{5BE7}',
    '\u{FE02}',
    '\u{5BEE}',
    '\u{FE00}',
    '\u{5BF3}',
    '\u{FE00}',
    '\u{5BFF}',
    '\u{FE00}',
    '\u{5C06}',
    '\u{FE00}',
    '\u{5C22}',
    '\u{FE00}',
    '\u{5C3F}',
    '\u{FE00}',
    '\u{5C60}',
    '\u{FE00}',
    '\u{5C62}',
    '\u{FE00}',
    '\u{5C64}',
    '\u{FE00}',
    '\u{5C65}',
    '\u{FE00}',
    '\u{5C6E}',
    '\u{FE00}',
    '\u{5C6E}',
    '\u{FE01}',
    '\u{5C8D}',
    '\u{FE00}',
    '\u{5CC0}',
    '\u{FE00}',
    '\u{5D19}',
    '\u{FE00}',
    '\u{5D43}',
    '\u{FE00}',
    '\u{5D50}',
    '\u{FE00}',
    '\u{5D6B}',
    '\u{FE00}',
    '\u{5D6E}',
    '\u{FE00}',
    '\u{5D7C}',
    '\u{FE00}',
    '\u{5DB2}',
    '\u{FE00}',
    '\u{5DBA}',
    '\u{FE00}',
    '\u{5DE1}',
    '\u{FE00}',
    '\u{5DE2}',
    '\u{FE00}',
    '\u{5DFD}',
    '\u{FE00}',
    '\u{5E28}',
    '\u{FE00}',
    '\u{5E3D}',
    '\u{FE00}',
    '\u{5E69}',
    '\u{FE00}',
    '\u{5E74}',
    '\u{FE00}',
    '\u{5EA6}',
    '\u{FE00}',
    '\u{5EB0}',
    '\u{FE00}',
    '\u{5EB3}',
    '\u{FE00}',
    '\u{5EB6}',
    '\u{FE00}',
    '\u{5EC9}',
    '\u{FE00}',
    '\u{5ECA}',
    '\u{FE00}',
    '\u{5ECA}',
    '\u{FE01}',
    '\u{5ED2}',
    '\u{FE00}',
    '\u{5ED3}',
    '\u{FE00}',
    '\u{5ED9}',
    '\u{FE00}',
    '\u{5EEC}',
    '\u{FE00}',
    '\u{5EFE}',
    '\u{FE00}',
    '\u{5F04}',
    '\u{FE00}',
    '\u{5F22}',
    '\u{FE00}',
    '\u{5F22}',
    '\u{FE01}',
    '\u{5F53}',
    '\u{FE00}',
    '\u{5F62}',
    '\u{FE00}',
    '\u{5F69}',
    '\u{FE00}',
    '\u{5F6B}',
    '\u{FE00}',
    '\u{5F8B}',
    '\u{FE00}',
    '\u{5F9A}',
    '\u{FE00}',
    '\u{5FA9}',
    '\u{FE00}',
    '\u{5FAD}',
    '\u{FE00}',
    '\u{5FCD}',
    '\u{FE00}',
    '\u{5FD7}',
    '\u{FE00}',
    '\u{5FF5}',
    '\u{FE00}',
    '\u{5FF9}',
    '\u{FE00}',
    '\u{6012}',
    '\u{FE00}',
    '\u{601C}',
    '\u{FE00}',
    '\u{6075}',
    '\u{FE00}',
    '\u{6081}',
    '\u{FE00}',
    '\u{6094}',
    '\u{FE00}',
    '\u{6094}',
    '\u{FE01}',
    '\u{60C7}',
    '\u{FE00}',
    '\u{60D8}',
    '\u{FE00}',
    '\u{60E1}',
    '\u{FE00}',
    '\u{6108}',
    '\u{FE00}',
    '\u{6144}',
    '\u{FE00}',
    '\u{6148}',
    '\u{FE00}',
    '\u{614C}',
    '\u{FE00}',
    '\u{614C}',
    '\u{FE01}',
    '\u{614E}',
    '\u{FE00}',
    '\u{614E}',
    '\u{FE01}',
    '\u{6160}',
    '\u{FE00}',
    '\u{6168}',
    '\u{FE00}',
    '\u{617A}',
    '\u{FE00}',
    '\u{618E}',
    '\u{FE00}',
    '\u{618E}',
    '\u{FE01}',
    '\u{618E}',
    '\u{FE02}',
    '\u{6190}',
    '\u{FE00}',
    '\u{61A4}',
    '\u{FE00}',
    '\u{61AF}',
    '\u{FE00}',
    '\u{61B2}',
    '\u{FE00}',
    '\u{61DE}',
    '\u{FE00}',
    '\u{61F2}',
    '\u{FE00}',
    '\u{61F2}',
    '\u{FE01}',
    '\u{61F2}',
    '\u{FE02}',
    '\u{61F6}',
    '\u{FE00}',
    '\u{61F6}',
    '\u{FE01}',
    '\u{6200}',
    '\u{FE00}',
    '\u{6210}',
    '\u{FE00}',
    '\u{621B}',
    '\u{FE00}',
    '\u{622E}',
    '\u{FE00}',
    '\u{6234}',
    '\u{FE00}',
    '\u{625D}',
    '\u{FE00}',
    '\u{62B1}',
    '\u{FE00}',
    '\u{62C9}',
    '\u{FE00}',
    '\u{62CF}',
    '\u{FE00}',
    '\u{62D3}',
    '\u{FE00}',
    '\u{62D4}',
    '\u{FE00}',
    '\u{62FC}',
    '\u{FE00}',
    '\u{62FE}',
    '\u{FE00}',
    '\u{633D}',
    '\u{FE00}',
    '\u{6350}',
    '\u{FE00}',
    '\u{6368}',
    '\u{FE00}',
    '\u{637B}',
    '\u{FE00}',
    '\u{6383}',
    '\u{FE00}',
    '\u{63A0}',
    '\u{FE00}',
    '\u{63A9}',
    '\u{FE00}',
    '\u{63C4}',
    '\u{FE00}',
    '\u{63C5}',
    '\u{FE00}',
    '\u{63E4}',
    '\u{FE00}',
    '\u{641C}',
    '\u{FE00}',
    '\u{6422}',
    '\u{FE00}',
    '\u{6452}',
    '\u{FE00}',
    '\u{6469}',
    '\u{FE00}',
    '\u{6477}',
    '\u{FE00}',
    '\u{647E}',
    '\u{FE00}',
    '\u{649A}',
    '\u{FE00}',
    '\u{649D}',
    '\u{FE00}',
    '\u{64C4}',
    '\u{FE00}',
    '\u{654F}',
    '\u{FE00}',
    '\u{654F}',
    '\u{FE01}',
    '\u{6556}',
    '\u{FE00}',
    '\u{656C}',
    '\u{FE00}',
    '\u{6578}',
    '\u{FE00}',
    '\u{6599}',
    '\u{FE00}',
    '\u{65C5}',
    '\u{FE00}',
    '\u{65E2}',
    '\u{FE00}',
    '\u{65E3}',
    '\u{FE00}',
    '\u{6613}',
    '\u{FE00}',
    '\u{6649}',
    '\u{FE00}',
    '\u{6674}',
    '\u{FE00}',
    '\u{6674}',
    '\u{FE01}',
    '\u{6688}',
    '\u{FE00}',
    '\u{6691}',
    '\u{FE00}',
    '\u{6691}',
    '\u{FE01}',
    '\u{669C}',
    '\u{FE00}',
    '\u{66B4}',
    '\u{FE00}',
    '\u{66C6}',
    '\u{FE00}',
    '\u{66F4}',
    '\u{FE00}',
    '\u{66F8}',
    '\u{FE00}',
    '\u{6700}',
    '\u{FE00}',
    '\u{6717}',
    '\u{FE00}',
    '\u{6717}',
    '\u{FE01}',
    '\u{6717}',
    '\u{FE02}',
    '\u{671B}',
    '\u{FE00}',
    '\u{671B}',
    '\u{FE01}',
    '\u{6721}',
    '\u{FE00}',
    '\u{674E}',
    '\u{FE00}',
    '\u{6753}',
    '\u{FE00}',
    '\u{6756}',
    '\u{FE00}',
    '\u{675E}',
    '\u{FE00}',
    '\u{677B}',
    '\u{FE00}',
    '\u{6785}',
    '\u{FE00}',
    '\u{6797}',
    '\u{FE00}',
    '\u{67F3}',
    '\u{FE00}',
    '\u{67FA}',
    '\u{FE00}',
    '\u{6817}',
    '\u{FE00}',
    '\u{681F}',
    '\u{FE00}',
    '\u{6852}',
    '\u{FE00}',
    '\u{6881}',
    '\u{FE00}',
    '\u{6885}',
    '\u{FE00}',
    '\u{6885}',
    '\u{FE01}',
    '\u{688E}',
    '\u{FE00}',
    '\u{68A8}',
    '\u{FE00}',
    '\u{6914}',
    '\u{FE00}',
    '\u{6942}',
    '\u{FE00}',
    '\u{69A3}',
    '\u{FE00}',
    '\u{69EA}',
    '\u{FE00}',
    '\u{6A02}',
    '\u{FE00}',
    '\u{6A02}',
    '\u{FE01}',
    '\u{6A02}',
    '\u{FE02}',
    '\u{6A13}',
    '\u{FE00}',
    '\u{6AA8}',
    '\u{FE00}',
    '\u{6AD3}',
    '\u{FE00}',
    '\u{6ADB}',
    '\u{FE00}',
    '\u{6B04}',
    '\u{FE00}',
    '\u{6B21}',
    '\u{FE00}',
    '\u{6B54}',
    '\u{FE00}',
    '\u{6B72}',
    '\u{FE00}',
    '\u{6B77}',
    '\u{FE00}',
    '\u{6B79}',
    '\u{FE00}',
    '\u{6B9F}',
    '\u{FE00}',
    '\u{6BAE}',
    '\u{FE00}',
    '\u{6BBA}',
    '\u{FE00}',
    '\u{6BBA}',
    '\u{FE01}',
    '\u{6BBA}',
    '\u{FE02}',
    '\u{6BBB}',
    '\u{FE00}',
    '\u{6C4E}',
    '\u{FE00}',
    '\u{6C67}',
    '\u{FE00}',
    '\u{6C88}',
    '\u{FE00}',
    '\u{6CBF}',
    '\u{FE00}',
    '\u{6CCC}',
    '\u{FE00}',
    '\u{6CCD}',
    '\u{FE00}',
    '\u{6CE5}',
    '\u{FE00}',
    '\u{6D16}',
    '\u{FE00}',
    '\u{6D1B}',
    '\u{FE00}',
    '\u{6D1E}',
    '\u{FE00}',
    '\u{6D34}',
    '\u{FE00}',
    '\u{6D3E}',
    '\u{FE00}',
    '\u{6D41}',
    '\u{FE00}',
    '\u{6D41}',
    '\u{FE01}',
    '\u{6D41}',
    '\u{FE02}',
    '\u{6D69}',
    '\u{FE00}',
    '\u{6D6A}',
    '\u{FE00}',
    '\u{6D77}',
    '\u{FE00}',
    '\u{6D77}',
    '\u{FE01}',
    '\u{6D78}',
    '\u{FE00}',
    '\u{6D85}',
    '\u{FE00}',
    '\u{6DCB}',
    '\u{FE00}',
    '\u{6DDA}',
    '\u{FE00}',
    '\u{6DEA}',
    '\u{FE00}',
    '\u{6DF9}',
    '\u{FE00}',
    '\u{6E1A}',
    '\u{FE00}',
    '\u{6E2F}',
    '\u{FE00}',
    '\u{6E6E}',
    '\u{FE00}',
    '\u{6E9C}',
    '\u{FE00}',
    '\u{6EBA}',
    '\u{FE00}',
    '\u{6EC7}',
    '\u{FE00}',
    '\u{6ECB}',
    '\u{FE00}',
    '\u{6ECB}',
    '\u{FE01}',
    '\u{6ED1}',
    '\u{FE00}',
    '\u{6EDB}',
    '\u{FE00}',
    '\u{6F0F}',
    '\u{FE00}',
    '\u{6F22}',
    '\u{FE00}',
    '\u{6F22}',
    '\u{FE01}',
    '\u{6F23}',
    '\u{FE00}',
    '\u{6F6E}',
    '\u{FE00}',
    '\u{6FC6}',
    '\u{FE00}',
    '\u{6FEB}',
    '\u{FE00}',
    '\u{6FFE}',
    '\u{FE00}',
    '\u{701B}',
    '\u{FE00}',
    '\u{701E}',
    '\u{FE00}',
    '\u{701E}',
    '\u{FE01}',
    '\u{7039}',
    '\u{FE00}',
    '\u{704A}',
    '\u{FE00}',
    '\u{7070}',
    '\u{FE00}',
    '\u{7077}',
    '\u{FE00}',
    '\u{707D}',
    '\u{FE00}',
    '\u{7099}',
    '\u{FE00}',
    '\u{70AD}',
    '\u{FE00}',
    '\u{70C8}',
    '\u{FE00}',
    '\u{70D9}',
    '\u{FE00}',
    '\u{7145}',
    '\u{FE00}',
    '\u{7149}',
    '\u{FE00}',
    '\u{716E}',
    '\u{FE00}',
    '\u{716E}',
    '\u{FE01}',
    '\u{719C}',
    '\u{FE00}',
    '\u{71CE}',
    '\u{FE00}',
    '\u{71D0}',
    '\u{FE00}',
    '\u{7210}',
    '\u{FE00}',
    '\u{721B}',
    '\u{FE00}',
    '\u{7228}',
    '\u{FE00}',
    '\u{722B}',
    '\u{FE00}',
    '\u{7235}',
    '\u{FE00}',
    '\u{7235}',
    '\u{FE01}',
    '\u{7250}',
    '\u{FE00}',
    '\u{7262}',
    '\u{FE00}',
    '\u{7280}',
    '\u{FE00}',
    '\u{7295}',
    '\u{FE00}',
    '\u{72AF}',
    '\u{FE00}',
    '\u{72C0}',
    '\u{FE00}',
    '\u{72FC}',
    '\u{FE00}',
    '\u{732A}',
    '\u{FE00}',
    '\u{732A}',
    '\u{FE01}',
    '\u{7375}',
    '\u{FE00}',
    '\u{737A}',
    '\u{FE00}',
    '\u{7387}',
    '\u{FE00}',
    '\u{7387}',
    '\u{FE01}',
    '\u{738B}',
    '\u{FE00}',
    '\u{73A5}',
    '\u{FE00}',
    '\u{73B2}',
    '\u{FE00}',
    '\u{73DE}',
    '\u{FE00}',
    '\u{7406}',
    '\u{FE00}',
    '\u{7409}',
    '\u{FE00}',
    '\u{7422}',
    '\u{FE00}',
    '\u{7447}',
    '\u{FE00}',
    '\u{745C}',
    '\u{FE00}',
    '\u{7469}',
    '\u{FE00}',
    '\u{7471}',
    '\u{FE00}',
    '\u{7471}',
    '\u{FE01}',
    '\u{7485}',
    '\u{FE00}',
    '\u{7489}',
    '\u{FE00}',
    '\u{7498}',
    '\u{FE00}',
    '\u{74CA}',
    '\u{FE00}',
    '\u{7506}',
    '\u{FE00}',
    '\u{7524}',
    '\u{FE00}',
    '\u{753B}',
    '\u{FE00}',
    '\u{753E}',
    '\u{FE00}',
    '\u{7559}',
    '\u{FE00}',
    '\u{7565}',
    '\u{FE00}',
    '\u{7570}',
    '\u{FE00}',
    '\u{7570}',
    '\u{FE01}',
    '\u{75E2}',
    '\u{FE00}',
    '\u{7610}',
    '\u{FE00}',
    '\u{761D}',
    '\u{FE00}',
    '\u{761F}',
    '\u{FE00}',
    '\u{7642}',
    '\u{FE00}',
    '\u{7669}',
    '\u{FE00}',
    '\u{76CA}',
    '\u{FE00}',
    '\u{76CA}',
    '\u{FE01}',
    '\u{76DB}',
    '\u{FE00}',
    '\u{76E7}',
    '\u{FE00}',
    '\u{76F4}',
    '\u{FE00}',
    '\u{76F4}',
    '\u{FE01}',
    '\u{7701}',
    '\u{FE00}',
    '\u{771E}',
    '\u{FE00}',
    '\u{771F}',
    '\u{FE00}',
    '\u{771F}',
    '\u{FE01}',
    '\u{7740}',
    '\u{FE00}',
    '\u{774A}',
    '\u{FE00}',
    '\u{774A}',
    '\u{FE01}',
    '\u{778B}',
    '\u{FE00}',
    '\u{77A7}',
    '\u{FE00}',
    '\u{784E}',
    '\u{FE00}',
    '\u{786B}',
    '\u{FE00}',
    '\u{788C}',
    '\u{FE00}',
    '\u{788C}',
    '\u{FE01}',
    '\u{7891}',
    '\u{FE00}',
    '\u{78CA}',
    '\u{FE00}',
    '\u{78CC}',
    '\u{FE00}',
    '\u{78CC}',
    '\u{FE01}',
    '\u{78FB}',
    '\u{FE00}',
    '\u{792A}',
    '\u{FE00}',
    '\u{793C}',
    '\u{FE00}',
    '\u{793E}',
    '\u{FE00}',
    '\u{7948}',
    '\u{FE00}',
    '\u{7949}',
    '\u{FE00}',
    '\u{7950}',
    '\u{FE00}',
    '\u{7956}',
    '\u{FE00}',
    '\u{7956}',
    '\u{FE01}',
    '\u{795D}',
    '\u{FE00}',
    '\u{795E}',
    '\u{FE00}',
    '\u{7965}',
    '\u{FE00}',
    '\u{797F}',
    '\u{FE00}',
    '\u{798D}',
    '\u{FE00}',
    '\u{798E}',
    '\u{FE00}',
    '\u{798F}',
    '\u{FE00}',
    '\u{798F}',
    '\u{FE01}',
    '\u{79AE}',
    '\u{FE00}',
    '\u{79CA}',
    '\u{FE00}',
    '\u{79EB}',
    '\u{FE00}',
    '\u{7A1C}',
    '\u{FE00}',
    '\u{7A40}',
    '\u{FE00}',
    '\u{7A40}',
    '\u{FE01}',
    '\u{7A4A}',
    '\u{FE00}',
    '\u{7A4F}',
    '\u{FE00}',
    '\u{7A81}',
    '\u{FE00}',
    '\u{7AB1}',
    '\u{FE00}',
    '\u{7ACB}',
    '\u{FE00}',
    '\u{7AEE}',
    '\u{FE00}',
    '\u{7B20}',
    '\u{FE00}',
    '\u{7BC0}',
    '\u{FE00}',
    '\u{7BC0}',
    '\u{FE01}',
    '\u{7BC6}',
    '\u{FE00}',
    '\u{7BC9}',
    '\u{FE00}',
    '\u{7C3E}',
    '\u{FE00}',
    '\u{7C60}',
    '\u{FE00}',
    '\u{7C7B}',
    '\u{FE00}',
    '\u{7C92}',
    '\u{FE00}',
    '\u{7CBE}',
    '\u{FE00}',
    '\u{7CD2}',
    '\u{FE00}',
    '\u{7CD6}',
    '\u{FE00}',
    '\u{7CE3}',
    '\u{FE00}',
    '\u{7CE7}',
    '\u{FE00}',
    '\u{7CE8}',
    '\u{FE00}',
    '\u{7D00}',
    '\u{FE00}',
    '\u{7D10}',
    '\u{FE00}',
    '\u{7D22}',
    '\u{FE00}',
    '\u{7D2F}',
    '\u{FE00}',
    '\u{7D5B}',
    '\u{FE00}',
    '\u{7D63}',
    '\u{FE00}',
    '\u{7DA0}',
    '\u{FE00}',
    '\u{7DBE}',
    '\u{FE00}',
    '\u{7DC7}',
    '\u{FE00}',
    '\u{7DF4}',
    '\u{FE00}',
    '\u{7DF4}',
    '\u{FE01}',
    '\u{7DF4}',
    '\u{FE02}',
    '\u{7E02}',
    '\u{FE00}',
    '\u{7E09}',
    '\u{FE00}',
    '\u{7E37}',
    '\u{FE00}',
    '\u{7E41}',
    '\u{FE00}',
    '\u{7E45}',
    '\u{FE00}',
    '\u{7F3E}',
    '\u{FE00}',
    '\u{7F72}',
    '\u{FE00}',
    '\u{7F79}',
    '\u{FE00}',
    '\u{7F7A}',
    '\u{FE00}',
    '\u{7F85}',
    '\u{FE00}',
    '\u{7F95}',
    '\u{FE00}',
    '\u{7F9A}',
    '\u{FE00}',
    '\u{7FBD}',
    '\u{FE00}',
    '\u{7FFA}',
    '\u{FE00}',
    '\u{8001}',
    '\u{FE00}',
    '\u{8005}',
    '\u{FE00}',
    '\u{8005}',
    '\u{FE01}',
    '\u{8005}',
    '\u{FE02}',
    '\u{8046}',
    '\u{FE00}',
    '\u{8060}',
    '\u{FE00}',
    '\u{806F}',
    '\u{FE00}',
    '\u{8070}',
    '\u{FE00}',
    '\u{807E}',
    '\u{FE00}',
    '\u{808B}',
    '\u{FE00}',
    '\u{80AD}',
    '\u{FE00}',
    '\u{80B2}',
    '\u{FE00}',
    '\u{8103}',
    '\u{FE00}',
    '\u{813E}',
    '\u{FE00}',
    '\u{81D8}',
    '\u{FE00}',
    '\u{81E8}',
    '\u{FE00}',
    '\u{81ED}',
    '\u{FE00}',
    '\u{8201}',
    '\u{FE00}',
    '\u{8201}',
    '\u{FE01}',
    '\u{8204}',
    '\u{FE00}',
    '\u{8218}',
    '\u{FE00}',
    '\u{826F}',
    '\u{FE00}',
    '\u{8279}',
    '\u{FE00}',
    '\u{8279}',
    '\u{FE01}',
    '\u{828B}',
    '\u{FE00}',
    '\u{8291}',
    '\u{FE00}',
    '\u{829D}',
    '\u{FE00}',
    '\u{82B1}',
    '\u{FE00}',
    '\u{82B3}',
    '\u{FE00}',
    '\u{82BD}',
    '\u{FE00}',
    '\u{82E5}',
    '\u{FE00}',
    '\u{82E5}',
    '\u{FE01}',
    '\u{82E6}',
    '\u{FE00}',
    '\u{831D}',
    '\u{FE00}',
    '\u{8323}',
    '\u{FE00}',
    '\u{8336}',
    '\u{FE00}',
    '\u{8352}',
    '\u{FE00}',
    '\u{8353}',
    '\u{FE00}',
    '\u{8363}',
    '\u{FE00}',
    '\u{83AD}',
    '\u{FE00}',
    '\u{83BD}',
    '\u{FE00}',
    '\u{83C9}',
    '\u{FE00}',
    '\u{83CA}',
    '\u{FE00}',
    '\u{83CC}',
    '\u{FE00}',
    '\u{83DC}',
    '\u{FE00}',
    '\u{83E7}',
    '\u{FE00}',
    '\u{83EF}',
    '\u{FE00}',
    '\u{83F1}',
    '\u{FE00}',
    '\u{843D}',
    '\u{FE00}',
    '\u{8449}',
    '\u{FE00}',
    '\u{8457}',
    '\u{FE00}',
    '\u{8457}',
    '\u{FE01}',
    '\u{84EE}',
    '\u{FE00}',
    '\u{84F1}',
    '\u{FE00}',
    '\u{84F3}',
    '\u{FE00}',
    '\u{84FC}',
    '\u{FE00}',
    '\u{8516}',
    '\u{FE00}',
    '\u{8564}',
    '\u{FE00}',
    '\u{85CD}',
    '\u{FE00}',
    '\u{85FA}',
    '\u{FE00}',
    '\u{8606}',
    '\u{FE00}',
    '\u{8612}',
    '\u{FE00}',
    '\u{862D}',
    '\u{FE00}',
    '\u{863F}',
    '\u{FE00}',
    '\u{8650}',
    '\u{FE00}',
    '\u{865C}',
    '\u{FE00}',
    '\u{865C}',
    '\u{FE01}',
    '\u{8667}',
    '\u{FE00}',
    '\u{8669}',
    '\u{FE00}',
    '\u{8688}',
    '\u{FE00}',
    '\u{86A9}',
    '\u{FE00}',
    '\u{86E2}',
    '\u{FE00}',
    '\u{870E}',
    '\u{FE00}',
    '\u{8728}',
    '\u{FE00}',
    '\u{876B}',
    '\u{FE00}',
    '\u{8779}',
    '\u{FE00}',
    '\u{8779}',
    '\u{FE01}',
    '\u{8786}',
    '\u{FE00}',
    '\u{87BA}',
    '\u{FE00}',
    '\u{87E1}',
    '\u{FE00}',
    '\u{8801}',
    '\u{FE00}',
    '\u{881F}',
    '\u{FE00}',
    '\u{884C}',
    '\u{FE00}',
    '\u{8860}',
    '\u{FE00}',
    '\u{8863}',
    '\u{FE00}',
    '\u{88C2}',
    '\u{FE00}',
    '\u{88CF}',
    '\u{FE00}',
    '\u{88D7}',
    '\u{FE00}',
    '\u{88DE}',
    '\u{FE00}',
    '\u{88E1}',
    '\u{FE00}',
    '\u{88F8}',
    '\u{FE00}',
    '\u{88FA}',
    '\u{FE00}',
    '\u{8910}',
    '\u{FE00}',
    '\u{8941}',
    '\u{FE00}',
    '\u{8964}',
    '\u{FE00}',
    '\u{8986}',
    '\u{FE00}',
    '\u{898B}',
    '\u{FE00}',
    '\u{8996}',
    '\u{FE00}',
    '\u{8996}',
    '\u{FE01}',
    '\u{8AA0}',
    '\u{FE00}',
    '\u{8AAA}',
    '\u{FE00}',
    '\u{8AAA}',
    '\u{FE01}',
    '\u{8ABF}',
    '\u{FE00}',
    '\u{8ACB}',
    '\u{FE00}',
    '\u{8AD2}',
    '\u{FE00}',
    '\u{8AD6}',
    '\u{FE00}',
    '\u{8AED}',
    '\u{FE00}',
    '\u{8AED}',
    '\u{FE01}',
    '\u{8AF8}',
    '\u{FE00}',
    '\u{8AF8}',
    '\u{FE01}',
    '\u{8AFE}',
    '\u{FE00}',
    '\u{8AFE}',
    '\u{FE01}',
    '\u{8B01}',
    '\u{FE00}',
    '\u{8B01}',
    '\u{FE01}',
    '\u{8B39}',
    '\u{FE00}',
    '\u{8B39}',
    '\u{FE01}',
    '\u{8B58}',
    '\u{FE00}',
    '\u{8B80}',
    '\u{FE00}',
    '\u{8B8A}',
    '\u{FE00}',
    '\u{8B8A}',
    '\u{FE01}',
    '\u{8C48}',
    '\u{FE00}',
    '\u{8C55}',
    '\u{FE00}',
    '\u{8CAB}',
    '\u{FE00}',
    '\u{8CC1}',
    '\u{FE00}',
    '\u{8CC2}',
    '\u{FE00}',
    '\u{8CC8}',
    '\u{FE00}',
    '\u{8CD3}',
    '\u{FE00}',
    '\u{8D08}',
    '\u{FE00}',
    '\u{8D08}',
    '\u{FE01}',
    '\u{8D1B}',
    '\u{FE00}',
    '\u{8D77}',
    '\u{FE00}',
    '\u{8DBC}',
    '\u{FE00}',
    '\u{8DCB}',
    '\u{FE00}',
    '\u{8DEF}',
    '\u{FE00}',
    '\u{8DF0}',
    '\u{FE00}',
    '\u{8ECA}',
    '\u{FE00}',
    '\u{8ED4}',
    '\u{FE00}',
    '\u{8F26}',
    '\u{FE00}',
    '\u{8F2A}',
    '\u{FE00}',
    '\u{8F38}',
    '\u{FE00}',
    '\u{8F38}',
    '\u{FE01}',
    '\u{8F3B}',
    '\u{FE00}',
    '\u{8F62}',
    '\u{FE00}',
    '\u{8F9E}',
    '\u{FE00}',
    '\u{8FB0}',
    '\u{FE00}',
    '\u{8FB6}',
    '\u{FE00}',
    '\u{9023}',
    '\u{FE00}',
    '\u{9038}',
    '\u{FE00}',
    '\u{9038}',
    '\u{FE01}',
    '\u{9072}',
    '\u{FE00}',
    '\u{907C}',
    '\u{FE00}',
    '\u{908F}',
    '\u{FE00}',
    '\u{9094}',
    '\u{FE00}',
    '\u{90CE}',
    '\u{FE00}',
    '\u{90DE}',
    '\u{FE00}',
    '\u{90F1}',
    '\u{FE00}',
    '\u{90FD}',
    '\u{FE00}',
    '\u{9111}',
    '\u{FE00}',
    '\u{911B}',
    '\u{FE00}',
    '\u{916A}',
    '\u{FE00}',
    '\u{9199}',
    '\u{FE00}',
    '\u{91B4}',
    '\u{FE00}',
    '\u{91CC}',
    '\u{FE00}',
    '\u{91CF}',
    '\u{FE00}',
    '\u{91D1}',
    '\u{FE00}',
    '\u{9234}',
    '\u{FE00}',
    '\u{9238}',
    '\u{FE00}',
    '\u{9276}',
    '\u{FE00}',
    '\u{927C}',
    '\u{FE00}',
    '\u{92D7}',
    '\u{FE00}',
    '\u{92D8}',
    '\u{FE00}',
    '\u{9304}',
    '\u{FE00}',
    '\u{934A}',
    '\u{FE00}',
    '\u{93F9}',
    '\u{FE00}',
    '\u{9415}',
    '\u{FE00}',
    '\u{958B}',
    '\u{FE00}',
    '\u{95AD}',
    '\u{FE00}',
    '\u{95B7}',
    '\u{FE00}',
    '\u{962E}',
    '\u{FE00}',
    '\u{964B}',
    '\u{FE00}',
    '\u{964D}',
    '\u{FE00}',
    '\u{9675}',
    '\u{FE00}',
    '\u{9678}',
    '\u{FE00}',
    '\u{967C}',
    '\u{FE00}',
    '\u{9686}',
    '\u{FE00}',
    '\u{96A3}',
    '\u{FE00}',
    '\u{96B7}',
    '\u{FE00}',
    '\u{96B8}',
    '\u{FE00}',
    '\u{96C3}',
    '\u{FE00}',
    '\u{96E2}',
    '\u{FE00}',
    '\u{96E3}',
    '\u{FE00}',
    '\u{96E3}',
    '\u{FE01}',
    '\u{96F6}',
    '\u{FE00}',
    '\u{96F7}',
    '\u{FE00}',
    '\u{9723}',
    '\u{FE00}',
    '\u{9732}',
    '\u{FE00}',
    '\u{9748}',
    '\u{FE00}',
    '\u{9756}',
    '\u{FE00}',
    '\u{9756}',
    '\u{FE01}',
    '\u{97DB}',
    '\u{FE00}',
    '\u{97E0}',
    '\u{FE00}',
    '\u{97FF}',
    '\u{FE00}',
    '\u{97FF}',
    '\u{FE01}',
    '\u{980B}',
    '\u{FE00}',
    '\u{980B}',
    '\u{FE01}',
    '\u{980B}',
    '\u{FE02}',
    '\u{9818}',
    '\u{FE00}',
    '\u{9829}',
    '\u{FE00}',
    '\u{983B}',
    '\u{FE00}',
    '\u{983B}',
    '\u{FE01}',
    '\u{985E}',
    '\u{FE00}',
    '\u{98E2}',
    '\u{FE00}',
    '\u{98EF}',
    '\u{FE00}',
    '\u{98FC}',
    '\u{FE00}',
    '\u{9928}',
    '\u{FE00}',
    '\u{9929}',
    '\u{FE00}',
    '\u{99A7}',
    '\u{FE00}',
    '\u{99C2}',
    '\u{FE00}',
    '\u{99F1}',
    '\u{FE00}',
    '\u{99FE}',
    '\u{FE00}',
    '\u{9A6A}',
    '\u{FE00}',
    '\u{9B12}',
    '\u{FE00}',
    '\u{9B12}',
    '\u{FE01}',
    '\u{9B6F}',
    '\u{FE00}',
    '\u{9C40}',
    '\u{FE00}',
    '\u{9C57}',
    '\u{FE00}',
    '\u{9CFD}',
    '\u{FE00}',
    '\u{9D67}',
    '\u{FE00}',
    '\u{9DB4}',
    '\u{FE00}',
    '\u{9DFA}',
    '\u{FE00}',
    '\u{9E1E}',
    '\u{FE00}',
    '\u{9E7F}',
    '\u{FE00}',
    '\u{9E97}',
    '\u{FE00}',
    '\u{9E9F}',
    '\u{FE00}',
    '\u{9EBB}',
    '\u{FE00}',
    '\u{9ECE}',
    '\u{FE00}',
    '\u{9EF9}',
    '\u{FE00}',
    '\u{9EFE}',
    '\u{FE00}',
    '\u{9F05}',
    '\u{FE00}',
    '\u{9F0F}',
    '\u{FE00}',
    '\u{9F16}',
    '\u{FE00}',
    '\u{9F3B}',
    '\u{FE00}',
    '\u{9F43}',
    '\u{FE00}',
    '\u{9F8D}',
    '\u{FE00}',
    '\u{9F8E}',
    '\u{FE00}',
    '\u{9F9C}',
    '\u{FE00}',
    '\u{9F9C}',
    '\u{FE01}',
    '\u{9F9C}',
    '\u{FE02}',
    '\u{20122}',
    '\u{FE00}',
    '\u{2051C}',
    '\u{FE00}',
    '\u{20525}',
    '\u{FE00}',
    '\u{2054B}',
    '\u{FE00}',
    '\u{2063A}',
    '\u{FE00}',
    '\u{20804}',
    '\u{FE00}',
    '\u{208DE}',
    '\u{FE00}',
    '\u{20A2C}',
    '\u{FE00}',
    '\u{20B63}',
    '\u{FE00}',
    '\u{214E4}',
    '\u{FE00}',
    '\u{216A8}',
    '\u{FE00}',
    '\u{216EA}',
    '\u{FE00}',
    '\u{219C8}',
    '\u{FE00}',
    '\u{21B18}',
    '\u{FE00}',
    '\u{21D0B}',
    '\u{FE00}',
    '\u{21DE4}',
    '\u{FE00}',
    '\u{21DE6}',
    '\u{FE00}',
    '\u{22183}',
    '\u{FE00}',
    '\u{2219F}',
    '\u{FE00}',
    '\u{22331}',
    '\u{FE00}',
    '\u{22331}',
    '\u{FE01}',
    '\u{226D4}',
    '\u{FE00}',
    '\u{22844}',
    '\u{FE00}',
    '\u{2284A}',
    '\u{FE00}',
    '\u{22B0C}',
    '\u{FE00}',
    '\u{22BF1}',
    '\u{FE00}',
    '\u{2300A}',
    '\u{FE00}',
    '\u{232B8}',
    '\u{FE00}',
    '\u{2335F}',
    '\u{FE00}',
    '\u{23393}',
    '\u{FE00}',
    '\u{2339C}',
    '\u{FE00}',
    '\u{233C3}',
    '\u{FE00}',
    '\u{233D5}',
    '\u{FE00}',
    '\u{2346D}',
    '\u{FE00}',
    '\u{236A3}',
    '\u{FE00}',
    '\u{238A7}',
    '\u{FE00}',
    '\u{23A8D}',
    '\u{FE00}',
    '\u{23AFA}',
    '\u{FE00}',
    '\u{23CBC}',
    '\u{FE00}',
    '\u{23D1E}',
    '\u{FE00}',
    '\u{23ED1}',
    '\u{FE00}',
    '\u{23F5E}',
    '\u{FE00}',
    '\u{23F8E}',
    '\u{FE00}',
    '\u{24263}',
    '\u{FE00}',
    '\u{242EE}',
    '\u{FE00}',
    '\u{243AB}',
    '\u{FE00}',
    '\u{24608}',
    '\u{FE00}',
    '\u{24735}',
    '\u{FE00}',
    '\u{24814}',
    '\u{FE00}',
    '\u{24C36}',
    '\u{FE00}',
    '\u{24C92}',
    '\u{FE00}',
    '\u{24FA1}',
    '\u{FE00}',
    '\u{24FB8}',
    '\u{FE00}',
    '\u{25044}',
    '\u{FE00}',
    '\u{250F2}',
    '\u{FE00}',
    '\u{250F3}',
    '\u{FE00}',
    '\u{25119}',
    '\u{FE00}',
    '\u{25133}',
    '\u{FE00}',
    '\u{25249}',
    '\u{FE00}',
    '\u{2541D}',
    '\u{FE00}',
    '\u{25626}',
    '\u{FE00}',
    '\u{2569A}',
    '\u{FE00}',
    '\u{256C5}',
    '\u{FE00}',
    '\u{2597C}',
    '\u{FE00}',
    '\u{25AA7}',
    '\u{FE00}',
    '\u{25AA7}',
    '\u{FE01}',
    '\u{25BAB}',
    '\u{FE00}',
    '\u{25C80}',
    '\u{FE00}',
    '\u{25CD0}',
    '\u{FE00}',
    '\u{25F86}',
    '\u{FE00}',
    '\u{261DA}',
    '\u{FE00}',
    '\u{26228}',
    '\u{FE00}',
    '\u{26247}',
    '\u{FE00}',
    '\u{262D9}',
    '\u{FE00}',
    '\u{2633E}',
    '\u{FE00}',
    '\u{264DA}',
    '\u{FE00}',
    '\u{26523}',
    '\u{FE00}',
    '\u{265A8}',
    '\u{FE00}',
    '\u{267A7}',
    '\u{FE00}',
    '\u{267B5}',
    '\u{FE00}',
    '\u{26B3C}',
    '\u{FE00}',
    '\u{26C36}',
    '\u{FE00}',
    '\u{26CD5}',
    '\u{FE00}',
    '\u{26D6B}',
    '\u{FE00}',
    '\u{26F2C}',
    '\u{FE00}',
    '\u{26FB1}',
    '\u{FE00}',
    '\u{270D2}',
    '\u{FE00}',
    '\u{273CA}',
    '\u{FE00}',
    '\u{27667}',
    '\u{FE00}',
    '\u{278AE}',
    '\u{FE00}',
    '\u{27966}',
    '\u{FE00}',
    '\u{27CA8}',
    '\u{FE00}',
    '\u{27ED3}',
    '\u{FE00}',
    '\u{27F2F}',
    '\u{FE00}',
    '\u{285D2}',
    '\u{FE00}',
    '\u{285ED}',
    '\u{FE00}',
    '\u{2872E}',
    '\u{FE00}',
    '\u{28BFA}',
    '\u{FE00}',
    '\u{28D77}',
    '\u{FE00}',
    '\u{29145}',
    '\u{FE00}',
    '\u{291DF}',
    '\u{FE00}',
    '\u{2921A}',
    '\u{FE00}',
    '\u{2940A}',
    '\u{FE00}',
    '\u{29496}',
    '\u{FE00}',
    '\u{295B6}',
    '\u{FE00}',
    '\u{29B30}',
    '\u{FE00}',
    '\u{2A0CE}',
    '\u{FE00}',
    '\u{2A105}',
    '\u{FE00}',
    '\u{2A20E}',
    '\u{FE00}',
    '\u{2A291}',
    '\u{FE00}',
    '\u{2A392}',
    '\u{FE00}',
    '\u{2A600}',
    '\u{FE00}',
];
pub(crate) const CJK_COMPAT_VARIANTS_DECOMPOSED_SALT: &[u16] = &[
    0x5,
    0x0,
    0x0,
    0x0,
    0x162,
    0x14,
    0xb6,
    0x0,
    0x183,
    0xd,
    0x0,
    0x0,
    0x35,
    0x11,
    0x7,
    0x0,
    0x1c,
    0x0,
    0x1,
    0x0,
    0xd3,
    0xb,
    0xa,
    0xe1,
    0x0,
    0x0,
    0x0,
    0x48,
    0x72,
    0xc7,
    0x2,
    0x21,
    0x15,
    0x2c,
    0x0,
    0x0,
    0x0,
    0x5,
    0x1f,
    0x8,
    0x7,
    0x0,
    0x4,
    0x0,
    0x7,
    0x10,
    0x0,
    0x0,
    0x0,
    0x4e,
    0x0,
    0x6,
    0x0,
    0x11,
    0x14,
    0x4,
    0x1a,
    0x2,
    0x58,
    0x0,
    0x17,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x4,
    0x6,
    0x16,
    0x20,
    0x4,
    0x0,
    0x1e,
    0x30,
    0x0,
    0x24,
    0x1a,
    0x17,
    0x0,
    0xa0,
    0x29,
    0x34,
    0x2,
    0x0,
    0x4,
    0x0,
    0x23,
    0x29,
    0x21,
    0x0,
    0x0,
    0xb,
    0x0,
    0x20,
    0x1,
    0x7,
    0x8,
    0x9,
    0x8,
    0x0,
    0x1,
    0x0,
    0x1,
    0x4,
    0x3,
    0x1d,
    0x0,
    0x0,
    0x0,
    0x1,
    0x29,
    0xd,
    0x7,
    0x0,
    0x0,
    0x2,
    0xe,
    0x9,
    0x4,
    0xc,
    0x1,
    0x13,
    0x5,
    0x6,
    0x5,
    0x1,
    0x9,
    0x1,
    0xa,
    0x2,
    0x0,
    0x8,
    0x29,
    0x0,
    0x8,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xd,
    0x0,
    0x9,
    0x10,
    0xf,
    0x0,
    0x11,
    0xf,
    0x0,
    0x8,
    0x1,
    0x1,
    0x5,
    0x0,
    0x1,
    0x26,
    0x5,
    0x39,
    0x8,
    0x1,
    0x17,
    0xd,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xe,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x2,
    0x4,
    0x3,
    0x35,
    0x1,
    0x2,
    0x1,
    0x7,
    0x0,
    0x0,
    0x3,
    0x2,
    0x11,
    0x0,
    0xd,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x5,
    0x0,
    0xe,
    0x0,
    0x0,
    0x3,
    0x6,
    0x2,
    0xb,
    0x2,
    0x1,
    0x3,
    0x12,
    0xb,
    0x0,
    0x0,
    0x0,
    0x2,
    0xb,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2f,
    0x1,
    0x13,
    0xb,
    0x4,
    0x2,
    0x4,
    0x4,
    0x0,
    0xb,
    0x4,
    0x0,
    0xb,
    0x4,
    0xd,
    0xc,
    0x0,
    0x1e,
    0x0,
    0x21,
    0xd,
    0x2,
    0x7,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x20,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1f,
    0x1,
    0x2,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x4,
    0x0,
    0x11,
    0x2,
    0x8,
    0x7,
    0x0,
    0x0,
    0xc,
    0x3,
    0x0,
    0x4,
    0xe,
    0x23,
    0x4,
    0x1,
    0x0,
    0x2,
    0x0,
    0x4,
    0x8,
    0x10,
    0x2,
    0x0,
    0x13,
    0xd,
    0x0,
    0xb,
    0x9,
    0x6,
    0x0,
    0x0,
    0x9,
    0xc,
    0xa,
    0x4,
    0x1a,
    0x3,
    0x1,
    0x3,
    0x0,
    0x1,
    0x0,
    0x6,
    0x3,
    0xa,
    0x0,
    0xa,
    0x6,
    0x8,
    0x8,
    0x3,
    0x19,
    0x0,
    0x0,
    0x0,
    0x0,
    0xc,
    0x5,
    0x0,
    0x5,
    0x1,
    0x0,
    0x2,
    0x0,
    0x8,
    0x0,
    0xc,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x2,
    0x15,
    0x0,
    0x4,
    0x1,
    0x12,
    0x4,
    0x3,
    0xc,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x5,
    0x2,
    0x0,
    0x1,
    0x2,
    0x1,
    0x10,
    0x4,
    0x0,
    0x5,
    0x2,
    0x1,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0xa,
    0x8,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x4,
    0xc,
    0x2,
    0x0,
    0x6,
    0x3,
    0x3,
    0xf,
    0x0,
    0x3,
    0x5,
    0x1,
    0x0,
    0x0,
    0x8,
    0x0,
    0x2,
    0x4,
    0x2,
    0x13,
    0x0,
    0x0,
    0x0,
    0xa,
    0x6,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xa,
    0x0,
    0x5,
    0x0,
    0x5,
    0x0,
    0x6,
    0x0,
    0x1,
    0x1,
    0x5,
    0x1,
    0xa,
    0x9,
    0x5,
    0x1,
    0x0,
    0x7,
    0x1,
    0x1,
    0x7,
    0x1,
    0x1f,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x11,
    0x5,
    0x3,
    0x5,
    0x3,
    0x1,
    0x1,
    0x0,
    0x4,
    0x1,
    0x4,
    0x1,
    0x8,
    0x0,
    0x19,
    0x0,
    0x4,
    0x3,
    0x5,
    0x6,
    0x0,
    0x11,
    0xe,
    0x5,
    0x1,
    0x0,
    0x1a,
    0x4,
    0x0,
    0x3,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x1,
    0x17,
    0x0,
    0x6,
    0x3,
    0xf,
    0x1,
    0x6,
    0x9,
    0x0,
    0x5,
    0x0,
    0x3,
    0x1,
    0x17,
    0x7,
    0x0,
    0x2,
    0x5,
    0x3,
    0x2,
    0x0,
    0x7,
    0x1,
    0x0,
    0x4,
    0x0,
    0x0,
    0x5,
    0x15,
    0x4,
    0x0,
    0x3,
    0x1,
    0x3,
    0x7,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x8,
    0x0,
    0x2,
    0x2,
    0x3,
    0x5,
    0x0,
    0x0,
    0x0,
    0x8,
    0x3,
    0x2,
    0x0,
    0x9,
    0x4,
    0x0,
    0x6,
    0xf,
    0x1,
    0x0,
    0x0,
    0x4,
    0x2,
    0x2,
    0x4,
    0x4,
    0xd,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x5,
    0x0,
    0x0,
    0xc,
    0x4,
    0x9,
    0x2,
    0x8,
    0x1,
    0x0,
    0x5,
    0x4,
    0x1,
    0x2,
    0x1,
    0x5,
    0x2,
    0xb,
    0x4,
    0xd,
    0x4,
    0x0,
    0x1,
    0x18,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0xa,
    0x2,
    0x4,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0xc,
    0x1,
    0xc,
    0x1,
    0x9,
    0xb,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x7,
    0x2,
    0x0,
    0x6,
    0x4,
    0xa,
    0x1,
    0x1,
    0x5,
    0x2,
    0x6,
    0x4,
    0x3,
    0xd,
    0x2,
    0x2,
    0x0,
    0x1,
    0x2,
    0x3,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x2,
    0x0,
    0x5,
    0x2,
    0x5,
    0x2,
    0x1,
    0x4,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x7,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x4,
    0x8,
    0x0,
    0x3,
    0x2,
    0x2,
    0x2,
    0x2,
    0x4,
    0x1,
    0x4,
    0x2,
    0x0,
    0x1,
    0x4,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0xc,
    0x0,
    0x1,
    0x2,
    0x0,
    0x6,
    0x2,
    0x0,
    0x0,
    0x8,
    0x1,
    0x9,
    0x1,
    0x3,
    0x0,
    0x4,
    0x1,
    0x0,
    0x6,
    0x0,
    0x3,
    0x7,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x3,
    0x2,
    0x0,
    0x2,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x3,
    0x1,
    0x3,
    0x0,
    0x5,
    0x0,
    0x1,
    0x0,
    0x3,
    0x1,
    0x1,
    0x2,
    0x3,
    0x0,
    0x2,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x3,
    0x2,
    0x4,
    0x3,
    0x5,
    0x2,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x0,
    0x0,
    0x4,
    0x3,
    0x0,
    0x1,
    0x6,
    0x1,
    0x4,
    0x0,
    0x2,
    0x2,
    0x1,
    0x0,
    0xd,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x3,
    0x8,
    0x5,
    0x7,
    0x6,
    0x0,
    0x1,
    0x6,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x2,
    0x4,
    0x2,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x5,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x2,
    0x0,
    0x1,
    0x3,
    0x3,
    0x1,
    0x0,
    0x4,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x4,
    0x0,
    0x0,
    0x3,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x1,
    0x2,
    0x1,
    0x9,
    0x1,
    0x0,
    0x1,
    0x3,
    0x4,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x4,
    0x1,
    0x1,
    0x1,
    0x2,
    0x1,
    0x6,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x5,
    0x1,
];
pub(crate) const CJK_COMPAT_VARIANTS_DECOMPOSED_KV: &[(u32, (u16, u16))] = &[
    (0xfa08, (1448, 2)),
    (0x2f825, (280, 2)),
    (0x2f838, (1796, 2)),
    (0x2f95b, (1192, 2)),
    (0x2f8fb, (1856, 2)),
    (0x2f83a, (340, 2)),
    (0x2f8a7, (636, 2)),
    (0x2f856, (422, 2)),
    (0x2f810, (208, 2)),
    (0xfa8b, (668, 2)),
    (0xfa7a, (378, 2)),
    (0x2f9ef, (118, 2)),
    (0x2f959, (1188, 2)),
    (0xf9c8, (804, 2)),
    (0xf9c4, (1770, 2)),
    (0x2f833, (328, 2)),
    (0xf96c, (430, 2)),
    (0xf9a1, (1486, 2)),
    (0xf906, (336, 2)),
    (0x2fa01, (1988, 2)),
    (0xf94c, (844, 2)),
    (0xf90f, (1274, 2)),
    (0x2f8dd, (1842, 2)),
    (0xfa55, (1194, 2)),
    (0x2f860, (1800, 2)),
    (0x2f999, (1350, 2)),
    (0xfabc, (1510, 2)),
    (0x2f9b9, (1428, 2)),
    (0xf943, (582, 2)),
    (0x2f952, (1900, 2)),
    (0x2f8f1, (856, 2)),
    (0xf99c, (256, 2)),
    (0xf969, (748, 2)),
    (0xf98d, (1568, 2)),
    (0xfa7f, (460, 2)),
    (0x2f9d6, (1542, 2)),
    (0x2f81b, (236, 2)),
    (0xfa9d, (1126, 2)),
    (0x2f8e4, (826, 2)),
    (0xfa94, (800, 2)),
    (0x2f890, (580, 2)),
    (0xf93d, (1244, 2)),
    (0x2f924, (1016, 2)),
    (0x2f983, (1308, 2)),
    (0xfa2f, (1656, 2)),
    (0x2f891, (1818, 2)),
    (0x2f934, (1072, 2)),
    (0x2f835, (972, 2)),
    (0x2f899, (590, 2)),
    (0x2f8ae, (660, 2)),
    (0xf9d6, (922, 2)),
    (0x2f9a0, (1358, 2)),
    (0xfac2, (1562, 2)),
    (0x2f851, (442, 2)),
    (0x2f804, (166, 2)),
    (0x2f90d, (1860, 2)),
    (0xf95e, (148, 2)),
    (0x2f8da, (794, 2)),
    (0x2f885, (550, 2)),
    (0x2f96a, (1232, 2)),
    (0xf907, (1774, 2)),
    (0xf9f9, (1218, 2)),
    (0xf94b, (514, 2)),
    (0x2f915, (962, 2)),
    (0xf9f1, (1654, 2)),
    (0x2f86d, (490, 2)),
    (0x2f921, (1010, 2)),
    (0xfa96, (870, 2)),
    (0xf9e0, (758, 2)),
    (0xf921, (532, 2)),
    (0x2f99f, (1386, 2)),
    (0x2f8b2, (678, 2)),
    (0xfab1, (1266, 2)),
    (0xfa6c, (1868, 2)),
    (0x2f819, (162, 2)),
    (0x2f910, (1862, 2)),
    (0x2f8dc, (798, 2)),
    (0x2f9d3, (1962, 2)),
    (0x2f8a3, (622, 2)),
    (0xf915, (892, 2)),
    (0x2f88a, (20, 2)),
    (0xf9f6, (1314, 2)),
    (0x2f9f1, (1976, 2)),
    (0xf98e, (556, 2)),
    (0xfad5, (1896, 2)),
    (0xf93b, (1132, 2)),
    (0x2f91e, (994, 2)),
    (0xf9eb, (308, 2)),
    (0xfa42, (754, 2)),
    (0x2f958, (78, 2)),
    (0xfa19, (1164, 2)),
    (0xfaaa, (1118, 2)),
    (0x2f949, (70, 2)),
    (0x2f978, (1276, 2)),
    (0x2f8a9, (638, 2)),
    (0x2f90a, (50, 2)),
    (0x2f89a, (594, 2)),
    (0x2f8b5, (688, 2)),
    (0x2f94c, (74, 2)),
    (0xfa43, (768, 2)),
    (0xf997, (1296, 2)),
    (0x2f8ba, (698, 2)),
    (0xfa00, (252, 2)),
    (0xfac3, (1582, 2)),
    (0x2f948, (1122, 2)),
    (0x2f9f4, (540, 2)),
    (0xfa99, (938, 2)),
    (0x2f976, (1272, 2)),
    (0xf978, (214, 2)),
    (0x2f8fe, (878, 2)),
    (0x2f8e3, (1846, 2)),
    (0xf919, (1602, 2)),
    (0x2f8ef, (854, 2)),
    (0xf939, (1730, 2)),
    (0x2f8c9, (746, 2)),
    (0x2f844, (370, 2)),
    (0xfabb, (1490, 2)),
    (0x2f9c4, (1452, 2)),
    (0x2f984, (96, 2)),
    (0x2f802, (152, 2)),
    (0xfa15, (246, 2)),
    (0xf9be, (750, 2)),
    (0xf942, (440, 2)),
    (0x2f852, (414, 2)),
    (0xfaae, (1216, 2)),
    (0x2fa17, (1756, 2)),
    (0x2f92d, (58, 2)),
    (0x2f83f, (354, 2)),
    (0xf90c, (456, 2)),
    (0xf931, (848, 2)),
    (0xf9c1, (1094, 2)),
    (0x2f873, (506, 2)),
    (0x2f965, (1914, 2)),
    (0xf902, (1554, 2)),
    (0x2f805, (176, 2)),
    (0x2f8ca, (1832, 2)),
    (0xf9c7, (270, 2)),
    (0x2f8f4, (864, 2)),
    (0xfa0d, (390, 2)),
    (0xfa5c, (1316, 2)),
    (0xfa4c, (1150, 2)),
    (0x2f865, (466, 2)),
    (0x2f876, (14, 2)),
    (0x2f9d7, (1544, 2)),
    (0xf975, (712, 2)),
    (0x2f9bb, (1436, 2)),
    (0x2f9d2, (1526, 2)),
    (0xf9ed, (346, 2)),
    (0x2f9b4, (1416, 2)),
    (0xfa6d, (1324, 2)),
    (0xf9e5, (1086, 2)),
    (0x2f8d8, (788, 2)),
    (0x2f93d, (1886, 2)),
    (0xfa03, (1224, 2)),
    (0xf9a0, (1454, 2)),
    (0x2fa12, (1994, 2)),
    (0xfa63, (1512, 2)),
    (0xf920, (1744, 2)),
    (0xf91f, (1408, 2)),
    (0x2f97d, (1294, 2)),
    (0xf990, (676, 2)),
    (0xfa57, (1252, 2)),
    (0x2f975, (1926, 2)),
    (0xfad8, (1768, 2)),
    (0xfab3, (1356, 2)),
    (0x2f9f3, (1660, 2)),
    (0xf9fb, (978, 2)),
    (0xf918, (1380, 2)),
    (0x2f8c3, (728, 2)),
    (0xf9ca, (900, 2)),
    (0xf952, (286, 2)),
    (0x2fa0b, (1732, 2)),
    (0x2f941, (1890, 2)),
    (0x2f862, (468, 2)),
    (0x2f8ff, (890, 2)),
    (0x2f85d, (450, 2)),
    (0xf9d9, (632, 2)),
    (0x2f855, (412, 2)),
    (0x2f98f, (1334, 2)),
    (0xf9d4, (184, 2)),
    (0xf99e, (360, 2)),
    (0x2f850, (254, 2)),
    (0xfa22, (1500, 2)),
    (0x2f94f, (1134, 2)),
    (0xfaa9, (1120, 2)),
    (0xfa71, (234, 2)),
    (0xf95d, (1504, 2)),
    (0x2f8bd, (720, 2)),
    (0x2fa02, (1706, 2)),
    (0x2f93f, (64, 2)),
    (0x2f808, (186, 2)),
    (0x2f950, (1142, 2)),
    (0x2f933, (60, 2)),
    (0x2f853, (416, 2)),
    (0x2f8f0, (1850, 2)),
    (0xf967, (140, 2)),
    (0xfa16, (1026, 2)),
    (0xfaa6, (1100, 2)),
    (0x2f8b3, (680, 2)),
    (0x2f9f7, (1982, 2)),
    (0xf986, (1636, 2)),
    (0x2f99d, (1364, 2)),
    (0x2f9b8, (1422, 2)),
    (0xf998, (1558, 2)),
    (0x2f82b, (306, 2)),
    (0x2f872, (504, 2)),
    (0xfab9, (1488, 2)),
    (0xfa9b, (964, 2)),
    (0xf9b0, (1292, 2)),
    (0xf98b, (776, 2)),
    (0xfad1, (1844, 2)),
    (0xf917, (1044, 2)),
    (0x2f989, (1838, 2)),
    (0x2f866, (476, 2)),
    (0xf932, (1000, 2)),
    (0x2fa0e, (134, 2)),
    (0xfa07, (1566, 2)),
    (0xf9bd, (510, 2)),
    (0x2f88c, (562, 2)),
    (0xfa56, (1204, 2)),
    (0xfa64, (1536, 2)),
    (0xfa04, (488, 2)),
    (0xfa9e, (1008, 2)),
    (0x2f9e0, (1968, 2)),
    (0x2f89d, (604, 2)),
    (0x2f9ee, (1634, 2)),
    (0xf9db, (1036, 2)),
    (0xf923, (1400, 2)),
    (0x2f841, (362, 2)),
    (0x2f81a, (232, 2)),
    (0xf911, (1440, 2)),
    (0xfaad, (1206, 2)),
    (0xfac1, (1540, 2)),
    (0x2f928, (1032, 2)),
    (0x2f935, (1878, 2)),
    (0x2f8d5, (772, 2)),
    (0xf92e, (238, 2)),
    (0xfa59, (1262, 2)),
    (0x2f96b, (1918, 2)),
    (0x2f8b9, (702, 2)),
    (0x2f877, (512, 2)),
    (0x2fa00, (1698, 2)),
    (0xfa05, (894, 2)),
    (0xf9e8, (1462, 2)),
    (0x2f8c6, (730, 2)),
    (0xf97a, (820, 2)),
    (0x2f9ea, (1620, 2)),
    (0xf944, (1214, 2)),
    (0x2f8c4, (732, 2)),
    (0x2f9cd, (114, 2)),
    (0x2f8e5, (816, 2)),
    (0x2f9d9, (1790, 2)),
    (0x2f980, (1836, 2)),
    (0x2f9a8, (1390, 2)),
    (0x2f92f, (1054, 2)),
    (0x2f951, (76, 2)),
    (0x2f9f9, (124, 2)),
    (0xfab4, (1376, 2)),
    (0xf985, (1146, 2)),
    (0x2f829, (300, 2)),
    (0x2f8a2, (26, 2)),
    (0x2f9c3, (1450, 2)),
    (0x2f936, (1076, 2)),
    (0x2f9af, (104, 2)),
    (0xfa77, (296, 2)),
    (0xf956, (1184, 2)),
    (0xfa5f, (1384, 2)),
    (0x2f93b, (1882, 2)),
    (0xf914, (838, 2)),
    (0x2f994, (1340, 2)),
    (0x2f91b, (1784, 2)),
    (0x2f880, (538, 2)),
    (0x2f956, (1176, 2)),
    (0xf958, (1378, 2)),
    (0x2f99b, (1362, 2)),
    (0x2fa06, (1718, 2)),
    (0xfabf, (1514, 2)),
    (0x2f8b6, (696, 2)),
    (0x2f8a0, (618, 2)),
    (0xfa87, (640, 2)),
    (0x2f8ea, (836, 2)),
    (0x2f867, (10, 2)),
    (0xf97d, (1492, 2)),
    (0xf968, (884, 2)),
    (0xfa5a, (1268, 2)),
    (0xf97b, (1228, 2)),
    (0x2fa10, (1992, 2)),
    (0xfa2b, (1710, 2)),
    (0xfa75, (220, 2)),
    (0xf94d, (920, 2)),
    (0xfad4, (68, 2)),
    (0x2f8cc, (780, 2)),
    (0xfa8a, (644, 2)),
    (0xf9f4, (808, 2)),
    (0xfac6, (1650, 2)),
    (0xfa9c, (992, 2)),
    (0xfa10, (426, 2)),
    (0xf9e2, (828, 2)),
    (0xf947, (1138, 2)),
    (0xf941, (1494, 2)),
    (0xfa4e, (1152, 2)),
    (0x2f9da, (1548, 2)),
    (0x2f893, (1318, 2)),
    (0xf96f, (1484, 2)),
    (0xf983, (752, 2)),
    (0xf9f5, (918, 2)),
    (0xf962, (1082, 2)),
    (0x2f968, (1230, 2)),
    (0x2f923, (1872, 2)),
    (0x2fa18, (1758, 2)),
    (0x2f930, (1060, 2)),
    (0xfa90, (744, 2)),
    (0xfa54, (1186, 2)),
    (0xf9d8, (596, 2)),
    (0x2f9e4, (1598, 2)),
    (0x2fa05, (1716, 2)),
    (0x2f964, (82, 2)),
    (0xf99f, (982, 2)),
    (0x2f94b, (72, 2)),
    (0x2f9a9, (1392, 2)),
    (0xfa0c, (198, 2)),
    (0x2f986, (478, 2)),
    (0xfa85, (602, 2)),
    (0x2f95f, (1200, 2)),
    (0xf9f8, (1202, 2)),
    (0xf9b4, (1696, 2)),
    (0x2f82e, (316, 2)),
    (0xfad9, (1772, 2)),
    (0x2f937, (1880, 2)),
    (0xf9cf, (1234, 2)),
    (0xfaa1, (1058, 2)),
    (0x2f917, (970, 2)),
    (0xfaa5, (1092, 2)),
    (0xfa3b, (516, 2)),
    (0x2f88d, (564, 2)),
    (0x2f906, (1858, 2)),
    (0x2f901, (912, 2)),
    (0x2f97a, (1290, 2)),
    (0xfa60, (1468, 2)),
    (0x2f92c, (56, 2)),
    (0x2f80a, (196, 2)),
    (0x2f99a, (1360, 2)),
    (0x2fa13, (1996, 2)),
    (0x2f938, (1084, 2)),
    (0x2f813, (2, 2)),
    (0x2f831, (324, 2)),
    (0xfa1c, (1678, 2)),
    (0xfacc, (1702, 2)),
    (0xfa5e, (1330, 2)),
    (0x2f995, (1342, 2)),
    (0x2f8d3, (226, 2)),
    (0xfacd, (1726, 2)),
    (0x2f81d, (248, 2)),
    (0x2f97b, (1930, 2)),
    (0xfa3a, (432, 2)),
    (0xf9c6, (1640, 2)),
    (0xfabd, (1506, 2)),
    (0xf92d, (170, 2)),
    (0xf99b, (1628, 2)),
    (0xf91d, (852, 2)),
    (0x2f84d, (410, 2)),
    (0x2f8ad, (658, 2)),
    (0xf9d3, (1648, 2)),
    (0x2f843, (366, 2)),
    (0xf97c, (1326, 2)),
    (0xfa30, (174, 2)),
    (0x2f858, (434, 2)),
    (0x2f8a5, (624, 2)),
    (0x2f988, (1938, 2)),
    (0x2f9e1, (1970, 2)),
    (0xfa74, (200, 2)),
    (0x2f882, (546, 2)),
    (0x2f879, (526, 2)),
    (0x2f8b7, (704, 2)),
    (0xf940, (1746, 2)),
    (0x2f9e5, (1972, 2)),
    (0x2f9cf, (1482, 2)),
    (0xfa8e, (722, 2)),
    (0x2f90c, (936, 2)),
    (0x2f985, (1310, 2)),
    (0x2f849, (388, 2)),
    (0x2f960, (80, 2)),
    (0x2f8c2, (30, 2)),
    (0x2f85f, (462, 2)),
    (0x2f916, (52, 2)),
    (0xf9fa, (1022, 2)),
    (0x2f824, (8, 2)),
    (0xf936, (1414, 2)),
    (0x2f94a, (1124, 2)),
    (0x2f80e, (204, 2)),
    (0x2f913, (968, 2)),
    (0x2f94d, (1898, 2)),
    (0xf999, (1388, 2)),
    (0x2f979, (1282, 2)),
    (0x2f926, (1874, 2)),
    (0xf9ea, (1662, 2)),
    (0xfa3f, (650, 2)),
    (0x2f83b, (342, 2)),
    (0xfa5b, (1286, 2)),
    (0xfa93, (790, 2)),
    (0xf913, (1586, 2)),
    (0xf98c, (860, 2)),
    (0x2f8c0, (718, 2)),
    (0xfad7, (1964, 2)),
    (0xf98a, (272, 2)),
    (0xfa26, (1596, 2)),
    (0xfabe, (1496, 2)),
    (0x2f977, (1928, 2)),
    (0xf954, (244, 2)),
    (0xf91a, (1720, 2)),
    (0x2f8cd, (760, 2)),
    (0x2f8a4, (1822, 2)),
    (0xfa84, (592, 2)),
    (0x2f85e, (452, 2)),
    (0xfa9f, (1020, 2)),
    (0xf9b1, (1614, 2)),
    (0x2f9ca, (4, 2)),
    (0xfac4, (1604, 2)),
    (0xf927, (1446, 2)),
    (0xfa01, (558, 2)),
    (0xf929, (784, 2)),
    (0xf9f3, (1750, 2)),
    (0x2f9e6, (1600, 2)),
    (0xfa70, (142, 2)),
    (0x2f820, (262, 2)),
    (0xf9a9, (406, 2)),
    (0x2f9bf, (108, 2)),
    (0x2f922, (1012, 2)),
    (0x2f9de, (1556, 2)),
    (0x2f8ec, (1848, 2)),
    (0xf9b5, (172, 2)),
    (0x2f9b7, (1424, 2)),
    (0x2f981, (92, 2)),
    (0xfa31, (194, 2)),
    (0x2f9c1, (1444, 2)),
    (0x2f874, (588, 2)),
    (0xf9d0, (1704, 2)),
    (0xf94a, (438, 2)),
    (0x2f998, (1346, 2)),
    (0x2f91c, (986, 2)),
    (0x2f9df, (1564, 2)),
    (0x2f859, (1798, 2)),
    (0x2f883, (16, 2)),
    (0xf9cc, (1048, 2)),
    (0x2f9b5, (1418, 2)),
    (0x2f970, (1264, 2)),
    (0x2f814, (210, 2)),
    (0x2f9ff, (1694, 2)),
    (0x2f84c, (398, 2)),
    (0x2f9a4, (1942, 2)),
    (0x2f966, (1222, 2)),
    (0xfa1e, (1280, 2)),
    (0x2fa0c, (1736, 2)),
    (0x2f863, (470, 2)),
    (0xfaa2, (1070, 2)),
    (0x2f91a, (980, 2)),
    (0x2f8f8, (1808, 2)),
    (0x2f8a6, (634, 2)),
    (0x2f895, (586, 2)),
    (0xf90b, (376, 2)),
    (0x2f993, (1338, 2)),
    (0x2f8be, (1830, 2)),
    (0xf948, (1532, 2)),
    (0x2f80d, (1788, 2)),
    (0x2f81f, (6, 2)),
    (0xf9e4, (1046, 2)),
    (0x2f823, (268, 2)),
    (0x2f9fa, (1684, 2)),
    (0x2f8fa, (876, 2)),
    (0xfa6a, (1700, 2)),
    (0x2f9f0, (1638, 2)),
    (0x2f967, (84, 2)),
    (0xfa8f, (726, 2)),
    (0xfa06, (774, 2)),
    (0xf982, (578, 2)),
    (0xf989, (1754, 2)),
    (0x2f990, (1332, 2)),
    (0xfac9, (1682, 2)),
    (0x2f8ed, (850, 2)),
    (0x2f822, (266, 2)),
    (0xf9cb, (932, 2)),
    (0xfa4d, (1154, 2)),
    (0x2f944, (1894, 2)),
    (0x2f9e8, (1622, 2)),
    (0x2f8d2, (224, 2)),
    (0x2f97c, (1932, 2)),
    (0xfa68, (1664, 2)),
    (0xfa53, (1172, 2)),
    (0x2f8f5, (872, 2)),
    (0x2f945, (1112, 2)),
    (0xfa95, (862, 2)),
    (0xfa2e, (1592, 2)),
    (0xf91b, (154, 2)),
    (0x2f837, (334, 2)),
    (0x2f894, (584, 2)),
    (0x2fa09, (1990, 2)),
    (0x2f974, (90, 2)),
    (0xf9ba, (156, 2)),
    (0x2f80b, (190, 2)),
    (0xfaca, (1688, 2)),
    (0x2f969, (1226, 2)),
    (0x2f8b1, (674, 2)),
    (0x2f8d1, (34, 2)),
    (0x2f91d, (1866, 2)),
    (0x2f9d4, (1528, 2)),
    (0x2fa15, (1752, 2)),
    (0x2f954, (1902, 2)),
    (0xfa81, (482, 2)),
    (0x2f9a5, (1946, 2)),
    (0x2f90f, (954, 2)),
    (0xf92a, (908, 2)),
    (0x2fa19, (1760, 2)),
    (0x2f943, (1892, 2)),
    (0x2f947, (1116, 2)),
    (0x2fa0a, (1728, 2)),
    (0x2f963, (1210, 2)),
    (0xf9bb, (192, 2)),
    (0x2f8ac, (662, 2)),
    (0xf9c5, (766, 2)),
    (0x2f97e, (1934, 2)),
    (0x2f889, (1814, 2)),
    (0x2f8e9, (834, 2)),
    (0xf9da, (814, 2)),
    (0xface, (1778, 2)),
    (0x2f920, (1004, 2)),
    (0xf951, (1642, 2)),
    (0xf9bc, (500, 2)),
    (0x2f940, (1108, 2)),
    (0x2f84e, (400, 2)),
    (0xfa48, (990, 2)),
    (0x2fa08, (130, 2)),
    (0xf9e6, (1270, 2)),
    (0x2f8c8, (742, 2)),
    (0xf912, (1464, 2)),
    (0x2f8f7, (1852, 2)),
    (0x2f904, (914, 2)),
    (0xfa76, (278, 2)),
    (0x2f8e8, (832, 2)),
    (0x2f9e2, (1588, 2)),
    (0xf903, (1534, 2)),
    (0xfa9a, (950, 2)),
    (0xf996, (1250, 2)),
    (0x2f8db, (802, 2)),
    (0xfa4a, (1050, 2)),
    (0xfa6b, (616, 2)),
    (0x2f8fd, (886, 2)),
    (0xfa79, (368, 2)),
    (0xf987, (1724, 2)),
    (0x2f8f2, (48, 2)),
    (0xf90d, (672, 2)),
    (0xf922, (958, 2)),
    (0xfa88, (630, 2)),
    (0xf91c, (320, 2)),
    (0x2f870, (502, 2)),
    (0x2f9ac, (1398, 2)),
    (0x2f839, (338, 2)),
    (0x2fa03, (128, 2)),
    (0x2f854, (418, 2)),
    (0x2f92a, (54, 2)),
    (0xfa35, (312, 2)),
    (0x2f9e7, (1616, 2)),
    (0x2f9a6, (1944, 2)),
    (0xfaaf, (1240, 2)),
    (0x2f911, (1864, 2)),
    (0x2f95d, (1908, 2)),
    (0x2f89c, (598, 2)),
    (0xfa45, (910, 2)),
    (0xfa1b, (1174, 2)),
    (0xfa3d, (620, 2)),
    (0xf980, (350, 2)),
    (0xfa8c, (684, 2)),
    (0x2f9e9, (1624, 2)),
    (0x2f9f8, (122, 2)),
    (0x2f902, (904, 2)),
    (0x2fa1d, (2002, 2)),
    (0xfab6, (1470, 2)),
    (0xf995, (1180, 2)),
    (0x2f832, (326, 2)),
    (0x2f955, (1904, 2)),
    (0x2f8fc, (882, 2)),
    (0x2f875, (508, 2)),
    (0x2f82a, (302, 2)),
    (0x2f811, (218, 2)),
    (0x2f868, (12, 2)),
    (0x2f925, (1018, 2)),
    (0xfa20, (1406, 2)),
    (0x2f83e, (352, 2)),
    (0xf9af, (1278, 2)),
    (0x2f997, (1940, 2)),
    (0x2f9ec, (1632, 2)),
    (0xf9ab, (542, 2)),
    (0xf935, (1404, 2)),
    (0xfa80, (474, 2)),
    (0x2f95c, (1906, 2)),
    (0xfa92, (786, 2)),
    (0xf95b, (692, 2)),
    (0xf93e, (1366, 2)),
    (0xf9de, (344, 2)),
    (0xf9f0, (1402, 2)),
    (0x2f847, (380, 2)),
    (0xfa98, (944, 2)),
    (0xf90e, (1096, 2)),
    (0xfa4f, (1156, 2)),
    (0xfaa4, (1090, 2)),
    (0x2f9c0, (1442, 2)),
    (0x2f8bf, (724, 2)),
    (0xfa62, (1508, 2)),
    (0xf9b6, (1178, 2)),
    (0x2f826, (284, 2)),
    (0xf9c9, (810, 2)),
    (0x2f992, (276, 2)),
    (0x2f8e1, (818, 2)),
    (0xf959, (1646, 2)),
    (0x2f892, (1820, 2)),
    (0xfa18, (1148, 2)),
    (0x2f87d, (1812, 2)),
    (0xf970, (868, 2)),
    (0x2f92b, (1040, 2)),
    (0x2fa04, (1714, 2)),
    (0xfa89, (652, 2)),
    (0x2f9e3, (1594, 2)),
    (0x2f9c2, (110, 2)),
    (0xfacb, (1690, 2)),
    (0x2f9c8, (112, 2)),
    (0x2f908, (928, 2)),
    (0x2f86f, (498, 2)),
    (0x2f98a, (1840, 2)),
    (0xf9a8, (164, 2)),
    (0x2f8c7, (32, 2)),
    (0x2fa16, (138, 2)),
    (0xfa4b, (1136, 2)),
    (0x2f878, (522, 2)),
    (0x2f8bb, (706, 2)),
    (0x2f816, (1786, 2)),
    (0x2f86a, (484, 2)),
    (0xf9c3, (1584, 2)),
    (0xf945, (1300, 2)),
    (0x2f9fe, (1692, 2)),
    (0xfa86, (626, 2)),
    (0x2f82c, (310, 2)),
    (0xf988, (1748, 2)),
    (0xfac5, (1618, 2)),
    (0xfa66, (1574, 2)),
    (0x2f840, (358, 2)),
    (0xf9ee, (998, 2)),
    (0x2f830, (322, 2)),
    (0x2f914, (966, 2)),
    (0x2f942, (1888, 2)),
    (0xfaa3, (1074, 2)),
    (0xf974, (1344, 2)),
    (0x2f807, (182, 2)),
    (0x2f905, (916, 2)),
    (0x2f9b2, (106, 2)),
    (0x2f887, (554, 2)),
    (0x2f912, (956, 2)),
    (0xf9ae, (1056, 2)),
    (0xf96a, (1236, 2)),
    (0xf9b7, (1606, 2)),
    (0x2f932, (1068, 2)),
    (0x2f98d, (1570, 2)),
    (0xfa25, (1578, 2)),
    (0xf993, (988, 2)),
    (0x2f9f5, (1672, 2)),
    (0xf9df, (518, 2)),
    (0x2f9c7, (1460, 2)),
    (0x2f996, (1348, 2)),
    (0x2f842, (364, 2)),
    (0x2f869, (480, 2)),
    (0x2f861, (1802, 2)),
    (0x2f8af, (664, 2)),
    (0x2f8c5, (736, 2)),
    (0x2f962, (1208, 2)),
    (0x2f98b, (1320, 2)),
    (0x2f9a1, (1368, 2)),
    (0xfad2, (42, 2)),
    (0x2f9ae, (102, 2)),
    (0x2f8bc, (710, 2)),
    (0xf9b3, (1676, 2)),
    (0x2f88f, (2000, 2)),
    (0xf965, (180, 2)),
    (0x2f953, (1160, 2)),
    (0x2f84b, (408, 2)),
    (0x2f90b, (940, 2)),
    (0x2f834, (1794, 2)),
    (0xfa2d, (1740, 2)),
    (0x2f8e6, (830, 2)),
    (0xf971, (1572, 2)),
    (0x2fa1c, (1766, 2)),
    (0xfa61, (1478, 2)),
    (0x2f98e, (98, 2)),
    (0x2f9c9, (1466, 2)),
    (0xfa0b, (574, 2)),
    (0x2f86b, (486, 2)),
    (0xf949, (1670, 2)),
    (0xfac7, (1666, 2)),
    (0xf96e, (1382, 2)),
    (0xf966, (600, 2)),
    (0xf955, (242, 2)),
    (0x2f8d0, (36, 2)),
    (0x2f93a, (1088, 2)),
    (0xf9ff, (260, 2)),
    (0xfac8, (1680, 2)),
    (0xf93c, (1168, 2)),
    (0x2f845, (372, 2)),
    (0x2f9ce, (116, 2)),
    (0xfad6, (1916, 2)),
    (0x2f95a, (1190, 2)),
    (0xf9e9, (1608, 2)),
    (0x2f91f, (1870, 2)),
    (0xf950, (1260, 2)),
    (0x2f8c1, (714, 2)),
    (0x2f9ad, (1948, 2)),
    (0x2f97f, (1298, 2)),
    (0xfa83, (576, 2)),
    (0x2f82d, (314, 2)),
    (0x2f8df, (812, 2)),
    (0x2f87c, (530, 2)),
    (0xfa58, (1258, 2)),
    (0x2f846, (374, 2)),
    (0xfa37, (396, 2)),
    (0xfa78, (384, 2)),
    (0x2f9f6, (1978, 2)),
    (0x2f99e, (1374, 2)),
    (0xfad3, (66, 2)),
    (0xfad0, (1824, 2)),
    (0xf9d5, (528, 2)),
    (0xfab7, (1474, 2)),
    (0xfa09, (1644, 2)),
    (0x2f8ce, (38, 2)),
    (0xf957, (1246, 2)),
    (0xf991, (734, 2)),
    (0xfab8, (1480, 2)),
    (0x2f8eb, (846, 2)),
    (0x2f9b1, (1952, 2)),
    (0xfa2a, (1708, 2)),
    (0x2f93c, (1884, 2)),
    (0xfa72, (212, 2)),
    (0x2f96f, (1256, 2)),
    (0x2f8d6, (1304, 2)),
    (0x2f886, (552, 2)),
    (0xf9fd, (160, 2)),
    (0xf9c0, (996, 2)),
    (0x2f9be, (1438, 2)),
    (0xf9b8, (1658, 2)),
    (0x2f81e, (250, 2)),
    (0xf900, (1524, 2)),
    (0x2f98c, (1322, 2)),
    (0x2f93e, (62, 2)),
    (0xfaa0, (1028, 2)),
    (0x2f8f3, (858, 2)),
    (0xf961, (1034, 2)),
    (0x2f83d, (348, 2)),
    (0x2f8f6, (874, 2)),
    (0xf9d2, (682, 2)),
    (0x2f84a, (392, 2)),
    (0xf9e1, (796, 2)),
    (0xfa7c, (428, 2)),
    (0x2f9aa, (1396, 2)),
    (0xfa51, (1162, 2)),
    (0x2f8b8, (1828, 2)),
    (0x2f931, (1062, 2)),
    (0xfa7e, (454, 2)),
    (0xf9a6, (1212, 2)),
    (0xf976, (1080, 2)),
    (0xfa97, (902, 2)),
    (0x2f8e7, (44, 2)),
    (0x2f88b, (560, 2)),
    (0x2f9c6, (1458, 2)),
    (0x2f8d9, (792, 2)),
    (0xfa52, (1170, 2)),
    (0x2fa0d, (132, 2)),
    (0x2f900, (898, 2)),
    (0x2f836, (332, 2)),
    (0xf9ad, (1042, 2)),
    (0xf934, (1284, 2)),
    (0xfab0, (1254, 2)),
    (0x2f809, (188, 2)),
    (0x2f9f2, (120, 2)),
    (0x2f86c, (1804, 2)),
    (0xf9fc, (1516, 2)),
    (0x2f95e, (1910, 2)),
    (0xf9a3, (608, 2)),
    (0x2f971, (88, 2)),
    (0x2f89b, (24, 2)),
    (0xf977, (158, 2)),
    (0xfa1a, (1166, 2)),
    (0xfa3c, (520, 2)),
    (0x2f9bd, (1432, 2)),
    (0xf928, (568, 2)),
    (0x2f864, (472, 2)),
    (0x2f9d1, (1522, 2)),
    (0x2f982, (1306, 2)),
    (0xf9dc, (1652, 2)),
    (0x2f972, (1922, 2)),
    (0x2f8cb, (756, 2)),
    (0xf960, (612, 2)),
    (0xf992, (952, 2)),
    (0x2f8b4, (686, 2)),
    (0x2f803, (1780, 2)),
    (0x2f818, (230, 2)),
    (0xf9f7, (1198, 2)),
    (0x2f827, (292, 2)),
    (0x2f9fb, (1984, 2)),
    (0x2f987, (1936, 2)),
    (0xfaab, (1140, 2)),
    (0xfa39, (424, 2)),
    (0x2fa07, (1722, 2)),
    (0xf9b9, (628, 2)),
    (0x2f86e, (492, 2)),
    (0x2f8e0, (806, 2)),
    (0xfaa7, (1102, 2)),
    (0x2f8a8, (642, 2)),
    (0xfa0a, (1476, 2)),
    (0x2fa14, (1998, 2)),
    (0x2f888, (18, 2)),
    (0x2f9a2, (1370, 2)),
    (0x2f848, (386, 2)),
    (0xfaa8, (1106, 2)),
    (0xfa67, (1580, 2)),
    (0xf946, (1014, 2)),
    (0x2f946, (1114, 2)),
    (0xfa7d, (436, 2)),
    (0xfa1d, (1220, 2)),
    (0x2fa11, (136, 2)),
    (0xfa2c, (1712, 2)),
    (0xf924, (1472, 2)),
    (0x2f96e, (1248, 2)),
    (0xf96d, (1110, 2)),
    (0xf95a, (1518, 2)),
    (0x2f85c, (448, 2)),
    (0xf92b, (1024, 2)),
    (0xfac0, (1520, 2)),
    (0xfa8d, (716, 2)),
    (0x2f9d8, (1966, 2)),
    (0xf938, (1674, 2)),
    (0x2f821, (264, 2)),
    (0xf9aa, (496, 2)),
    (0xf9ce, (1130, 2)),
    (0xfa47, (948, 2)),
    (0x2f8aa, (648, 2)),
    (0x2f918, (976, 2)),
    (0x2f8ee, (46, 2)),
    (0xf96b, (330, 2)),
    (0xf909, (458, 2)),
    (0x2f87f, (534, 2)),
    (0xf908, (1776, 2)),
    (0xfa5d, (1328, 2)),
    (0xf9ac, (614, 2)),
    (0x2f896, (22, 2)),
    (0x2f9b0, (1950, 2)),
    (0xf9a7, (1030, 2)),
    (0xf99d, (274, 2)),
    (0x2f957, (1182, 2)),
    (0xf905, (144, 2)),
    (0x2f9bc, (1430, 2)),
    (0x2f8f9, (1854, 2)),
    (0x2f8b0, (670, 2)),
    (0x2f881, (544, 2)),
    (0x2fa1b, (1764, 2)),
    (0x2f9dd, (1792, 2)),
    (0x2f9ed, (1974, 2)),
    (0x2f871, (1806, 2)),
    (0x2f8ab, (654, 2)),
    (0x2f812, (1782, 2)),
    (0xf933, (1104, 2)),
    (0xf9f2, (1734, 2)),
    (0xf984, (960, 2)),
    (0x2f90e, (924, 2)),
    (0xfab2, (1288, 2)),
    (0xfa32, (202, 2)),
    (0x2f96d, (86, 2)),
    (0x2f9a7, (100, 2)),
    (0xf94f, (1238, 2)),
    (0x2fa0f, (1738, 2)),
    (0xf925, (690, 2)),
    (0xfa91, (764, 2)),
    (0xf972, (880, 2)),
    (0xf90a, (1612, 2)),
    (0xfa02, (694, 2)),
    (0xf92f, (288, 2)),
    (0xf9dd, (258, 2)),
    (0xfa17, (1098, 2)),
    (0xf93f, (1626, 2)),
    (0x2f898, (1920, 2)),
    (0x2f907, (896, 2)),
    (0xf9ec, (934, 2)),
    (0xf9e3, (888, 2)),
    (0xfab5, (1434, 2)),
    (0xfa40, (666, 2)),
    (0x2f815, (222, 2)),
    (0x2f9db, (1546, 2)),
    (0xf91e, (1002, 2)),
    (0xf92c, (1590, 2)),
    (0x2f884, (548, 2)),
    (0xfa46, (926, 2)),
    (0x2f9b3, (1412, 2)),
    (0x2f85b, (446, 2)),
    (0xf9cd, (1078, 2)),
    (0xf93a, (1742, 2)),
    (0xf97e, (1610, 2)),
    (0xfa3e, (646, 2)),
    (0x2f9eb, (1630, 2)),
    (0x2f8e2, (824, 2)),
    (0x2f9b6, (1420, 2)),
    (0xf916, (984, 2)),
    (0x2f8de, (40, 2)),
    (0xf98f, (656, 2)),
    (0xfa12, (762, 2)),
    (0xfa44, (822, 2)),
    (0xf981, (464, 2)),
    (0x2f9dc, (1552, 2)),
    (0xf95c, (840, 2)),
    (0xf937, (1550, 2)),
    (0x2f87a, (524, 2)),
    (0x2f903, (906, 2)),
    (0x2f9c5, (1956, 2)),
    (0x2f8cf, (770, 2)),
    (0x2f909, (930, 2)),
    (0x2f991, (1336, 2)),
    (0xfa65, (1538, 2)),
    (0xfa73, (168, 2)),
    (0x2f88e, (570, 2)),
    (0xf9ef, (1066, 2)),
    (0x2f9cb, (1958, 2)),
    (0x2f9a3, (1372, 2)),
    (0x2f99c, (1352, 2)),
    (0x2f919, (974, 2)),
    (0x2f857, (420, 2)),
    (0x2f96c, (1242, 2)),
    (0x2f800, (150, 2)),
    (0x2fa1a, (1762, 2)),
    (0xf97f, (294, 2)),
    (0xfaba, (1502, 2)),
    (0xfa82, (572, 2)),
    (0x2f92e, (1052, 2)),
    (0xf9fe, (1354, 2)),
    (0xf994, (1064, 2)),
    (0x2f83c, (356, 2)),
    (0xfa50, (1158, 2)),
    (0x2f817, (228, 2)),
    (0xfa38, (402, 2)),
    (0xfa69, (1686, 2)),
    (0xfaac, (1196, 2)),
    (0xf901, (778, 2)),
    (0xfa33, (282, 2)),
    (0xf9bf, (842, 2)),
    (0xf9d1, (216, 2)),
    (0xf95f, (494, 2)),
    (0x2f82f, (318, 2)),
    (0xf9a4, (708, 2)),
    (0x2f89e, (606, 2)),
    (0x2f801, (146, 2)),
    (0x2f84f, (404, 2)),
    (0x2f961, (1912, 2)),
    (0x2f87e, (536, 2)),
    (0x2f9d5, (1530, 2)),
    (0xf9e7, (1456, 2)),
    (0xf973, (700, 2)),
    (0xf9c2, (1394, 2)),
    (0x2f9d0, (1498, 2)),
    (0xf9a5, (866, 2)),
    (0x2f80c, (0, 2)),
    (0xf930, (738, 2)),
    (0x2f8a1, (28, 2)),
    (0x2f828, (298, 2)),
    (0x2f89f, (610, 2)),
    (0xf964, (1144, 2)),
    (0xf94e, (946, 2)),
    (0x2f8d7, (94, 2)),
    (0x2f806, (178, 2)),
    (0x2f9cc, (1960, 2)),
    (0x2f94e, (1128, 2)),
    (0x2f929, (1038, 2)),
    (0xfa34, (290, 2)),
    (0x2f939, (1816, 2)),
    (0xf910, (1410, 2)),
    (0xf926, (1312, 2)),
    (0xf9a2, (566, 2)),
    (0xfa49, (1006, 2)),
    (0xf953, (1302, 2)),
    (0x2f80f, (206, 2)),
    (0xf963, (304, 2)),
    (0x2f8d4, (782, 2)),
    (0xf9b2, (1668, 2)),
    (0x2f973, (1924, 2)),
    (0x2f897, (1834, 2)),
    (0x2f9fc, (126, 2)),
    (0xf99a, (1576, 2)),
    (0x2f85a, (444, 2)),
    (0xfacf, (1826, 2)),
    (0x2f9ab, (1954, 2)),
    (0x2f927, (1876, 2)),
    (0x2f9fd, (1986, 2)),
    (0xfa36, (382, 2)),
    (0xf904, (942, 2)),
    (0x2f81c, (1980, 2)),
    (0xfa7b, (394, 2)),
    (0xfa41, (740, 2)),
    (0x2f87b, (1810, 2)),
    (0x2f9ba, (1426, 2)),
    (0xf979, (240, 2)),
    (0xf9d7, (1560, 2)),
];

pub(crate) const COMBINING_MARK_SALT: &[u16] = &[
    0x0,
    0x0,
    0xd,
    0x4,
    0xc,
    0x5,
    0x689,
    0x7,
    0x0,
    0x2,
    0x0,
    0x2,
    0x3,
    0x0,
    0x0,
    0xab,
    0x0,
    0x158,
    0x0,
    0x5a,
    0x1c6,
    0x143,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x6,
    0x4,
    0x0,
    0x92,
    0x0,
    0x0,
    0x24d,
    0x0,
    0x7,
    0x0,
    0x7f,
    0xc,
    0x0,
    0xc7,
    0x0,
    0x16d,
    0x0,
    0x0,
    0x0,
    0xda,
    0x4,
    0x19,
    0x5,
    0x0,
    0x93,
    0x6,
    0x7c,
    0x13,
    0x11b,
    0x0,
    0x1,
    0x8,
    0x58,
    0x0,
    0x5c,
    0xa5,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0xb4,
    0x1,
    0x1,
    0x0,
    0x1,
    0x8,
    0x0,
    0x79,
    0x7,
    0x0,
    0xa0,
    0x37,
    0x0,
    0x7,
    0x36,
    0x5,
    0x39,
    0x0,
    0x0,
    0x2,
    0x9,
    0x0,
    0x0,
    0x73,
    0x1,
    0x5,
    0x0,
    0x0,
    0x0,
    0x3d,
    0x1,
    0x0,
    0x4,
    0x0,
    0x54,
    0x1,
    0x0,
    0x27,
    0x4d,
    0xfa,
    0x4d,
    0x3,
    0x1c,
    0xdd,
    0x6,
    0x1,
    0x24,
    0x41,
    0x0,
    0x0,
    0x0,
    0xb,
    0x0,
    0x5,
    0x3,
    0xb6,
    0x0,
    0xf,
    0x0,
    0x1,
    0x16,
    0x0,
    0x0,
    0x9e,
    0x1,
    0x0,
    0x21,
    0x0,
    0x25,
    0x4,
    0x10,
    0x4,
    0x15,
    0x2,
    0x1,
    0x23,
    0x5,
    0x84,
    0x0,
    0x0,
    0xf,
    0xa,
    0x2,
    0x37,
    0x1,
    0x0,
    0x46,
    0xd,
    0x12,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x24,
    0xc,
    0x4a,
    0x2,
    0x4,
    0x0,
    0x42,
    0x0,
    0x4,
    0x13,
    0x2,
    0x13,
    0x7b,
    0x3e,
    0x0,
    0x11,
    0x2,
    0x7,
    0x1,
    0x0,
    0x31,
    0x3,
    0x0,
    0x12,
    0x0,
    0x0,
    0x0,
    0x35,
    0x6,
    0xe,
    0x1e,
    0xc1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x2,
    0x1c,
    0x0,
    0x8,
    0x0,
    0x9,
    0x3,
    0x8d,
    0x70,
    0x54,
    0x23,
    0x11,
    0x1f,
    0x5,
    0x17,
    0x4,
    0x2,
    0x0,
    0x47,
    0x17,
    0xc,
    0x2a,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x5,
    0x38,
    0x11,
    0x15,
    0x39,
    0x6,
    0x0,
    0x3,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x53,
    0x4,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0xf,
    0x6,
    0x0,
    0x0,
    0x0,
    0x4,
    0x28,
    0x4,
    0x0,
    0x0,
    0x11,
    0x2e,
    0x6,
    0x4,
    0x1,
    0x1,
    0x12,
    0x0,
    0x0,
    0x0,
    0x2,
    0x5,
    0x0,
    0x15,
    0x2e,
    0x0,
    0x1,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0xd,
    0x3,
    0x0,
    0x0,
    0x3f,
    0x8,
    0x0,
    0x8,
    0x0,
    0x0,
    0x1a,
    0x2,
    0x0,
    0x7,
    0x0,
    0xa,
    0x0,
    0x3,
    0xc,
    0x0,
    0x14,
    0x0,
    0x6,
    0x0,
    0x19,
    0x1,
    0x3,
    0x3,
    0x6,
    0x10,
    0x12,
    0x1,
    0x16,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x2,
    0x21,
    0x1,
    0x3,
    0x13,
    0x16,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0xe,
    0x0,
    0x0,
    0x38,
    0x2,
    0x20,
    0x3,
    0x0,
    0xa,
    0xe,
    0x1,
    0x3,
    0x0,
    0x0,
    0xa,
    0x6,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x4,
    0x18,
    0x1,
    0x0,
    0x2,
    0x0,
    0xc,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0xb,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1b,
    0x6,
    0x0,
    0x4,
    0x0,
    0x0,
    0x5,
    0x20,
    0x0,
    0x9,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x3,
    0x0,
    0xc,
    0x0,
    0x16,
    0x0,
    0x0,
    0x3,
    0x0,
    0x7,
    0x0,
    0x8,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1f,
    0xa,
    0x28,
    0x0,
    0x1,
    0x0,
    0x0,
    0x8,
    0xd,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x3a,
    0x4,
    0x8,
    0xb,
    0x0,
    0x17,
    0x0,
    0x2,
    0x0,
    0x0,
    0x22,
    0x0,
    0x4,
    0x0,
    0x1,
    0x2,
    0x6,
    0x17,
    0x7,
    0x9,
    0x27,
    0x0,
    0x1,
    0x11,
    0x7,
    0x23,
    0x1,
    0x1,
    0x0,
    0x0,
    0x9,
    0x8,
    0x2,
    0x27,
    0x8,
    0x0,
    0x17,
    0xc,
    0x3b,
    0x6,
    0x0,
    0x0,
    0xc,
    0x0,
    0x4,
    0x0,
    0x2e,
    0x5,
    0x7,
    0x7,
    0x0,
    0x3,
    0xf,
    0x1,
    0x0,
    0x2,
    0x0,
    0x6,
    0x2,
    0x2,
    0x4,
    0x0,
    0x3,
    0xf,
    0x0,
    0x1,
    0x12,
    0x24,
    0x0,
    0x0,
    0x0,
    0xb,
    0x1f,
    0x15,
    0xd,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x8,
    0x0,
    0x0,
    0xc,
    0x1,
    0xe,
    0x0,
    0x4,
    0x4,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x0,
    0x2e,
    0x0,
    0x11,
    0x0,
    0x1b,
    0xa,
    0x13,
    0x12,
    0x2,
    0x9,
    0x1,
    0xd,
    0x0,
    0x1,
    0x2,
    0x0,
    0xd,
    0x0,
    0xb,
    0x6,
    0x0,
    0x0,
    0xb,
    0x1,
    0x0,
    0x0,
    0x2,
    0x13,
    0x16,
    0xd,
    0xe,
    0x4,
    0xf,
    0xb,
    0x2,
    0x0,
    0x0,
    0xa,
    0x0,
    0x3,
    0x0,
    0xd,
    0x2,
    0xb,
    0x0,
    0x1d,
    0x0,
    0x2,
    0x7,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x7,
    0x6,
    0xe,
    0x4,
    0x0,
    0x1,
    0x8,
    0x14,
    0x0,
    0x0,
    0x15,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x10,
    0x0,
    0x0,
    0x6,
    0x17,
    0x0,
    0x1,
    0x0,
    0x10,
    0x0,
    0x0,
    0x0,
    0xa,
    0x0,
    0x0,
    0x1,
    0x6,
    0x4,
    0x0,
    0x4,
    0x1,
    0x1,
    0x2,
    0x2,
    0x0,
    0x1,
    0x7,
    0x0,
    0x0,
    0x2,
    0x2,
    0x7,
    0x2,
    0x1f,
    0x9,
    0x0,
    0x4,
    0x7,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x4,
    0x3,
    0x4,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x9,
    0x17,
    0x6,
    0xf,
    0xc,
    0x0,
    0x0,
    0x0,
    0x10,
    0x0,
    0x2,
    0x2,
    0x0,
    0x6,
    0x2,
    0x0,
    0x3,
    0x2,
    0x9,
    0x3,
    0x2,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x12,
    0x4,
    0x0,
    0x8,
    0x0,
    0x3,
    0x18,
    0x0,
    0x3,
    0xc,
    0x0,
    0x2,
    0x26,
    0x0,
    0x0,
    0x2,
    0x6,
    0x2,
    0x0,
    0x1,
    0x9,
    0x8,
    0x16,
    0x1,
    0x3,
    0x11,
    0x0,
    0x13,
    0x0,
    0x2,
    0x7,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0xc,
    0x1a,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x2,
    0x9,
    0x4,
    0x12,
    0x0,
    0x0,
    0x11,
    0x8,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x3,
    0x6,
    0xf,
    0x4,
    0x1,
    0x3,
    0x0,
    0x7,
    0x4,
    0x9,
    0x4,
    0x1,
    0x0,
    0x5,
    0x4,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x2,
    0x15,
    0x2,
    0x0,
    0x8,
    0x0,
    0x2,
    0x0,
    0x3,
    0x11,
    0x6,
    0x6,
    0xd,
    0x1,
    0x0,
    0x1,
    0x3,
    0x6,
    0x20,
    0x4,
    0x1,
    0x2,
    0xb,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x11,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x7,
    0x4,
    0x5,
    0x3,
    0x0,
    0x0,
    0x0,
    0x5,
    0x0,
    0x2,
    0x3,
    0x0,
    0x3,
    0x0,
    0x4,
    0x4,
    0x2,
    0x0,
    0x2,
    0x19,
    0x4,
    0x1,
    0x13,
    0x1,
    0x2,
    0x9,
    0xb,
    0x6,
    0x4,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1a,
    0x0,
    0x2,
    0x5,
    0x0,
    0xf,
    0x0,
    0x8,
    0x0,
    0x0,
    0x2,
    0x4,
    0x10,
    0x1,
    0x1,
    0x2,
    0x12,
    0x0,
    0x0,
    0x9,
    0x0,
    0x13,
    0x1,
    0x2,
    0x4,
    0x6,
    0x4,
    0x4,
    0x0,
    0x6,
    0x2,
    0x15,
    0x0,
    0x1,
    0x9,
    0xe,
    0x2,
    0x3,
    0x3,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x5,
    0xe,
    0x0,
    0x7,
    0x0,
    0x2,
    0x0,
    0xb,
    0x2,
    0x0,
    0x1,
    0x4,
    0x9,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x4,
    0x1,
    0xd,
    0x3,
    0x0,
    0x1,
    0x0,
    0x4,
    0x3,
    0x1,
    0x2,
    0x0,
    0x2,
    0x5,
    0x0,
    0x3,
    0x2c,
    0xa,
    0x3,
    0x0,
    0x9,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x27,
    0x2,
    0x0,
    0x0,
    0x0,
    0x15,
    0x1,
    0x2,
    0x4,
    0x0,
    0x2,
    0x0,
    0x3,
    0x3,
    0x1,
    0x0,
    0x2,
    0x5,
    0xa,
    0x9,
    0x1,
    0x2,
    0x3,
    0x1,
    0x5,
    0x1,
    0x8,
    0x1,
    0x1,
    0xf,
    0x0,
    0x3,
    0xa,
    0x3,
    0x4,
    0xd,
    0x3,
    0x1,
    0x0,
    0xc,
    0x1e,
    0x1,
    0x1,
    0xa,
    0x1,
    0x3,
    0x0,
    0x1,
    0x0,
    0x6,
    0x0,
    0x3,
    0x2,
    0x7,
    0x3,
    0xe,
    0x3,
    0x4,
    0xf,
    0x4,
    0x2,
    0x3,
    0x8,
    0x0,
    0x2,
    0x3,
    0x1,
    0x10,
    0x2,
    0x2,
    0x2,
    0x0,
    0x0,
    0x5,
    0x2,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x7,
    0x8,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0xb,
    0x7,
    0x0,
    0x3,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0xa,
    0xa,
    0x5,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x9,
    0x0,
    0x2,
    0xb,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x8,
    0x1,
    0xc,
    0xc,
    0x4,
    0x0,
    0x1,
    0x4,
    0x3,
    0x4,
    0x3,
    0x1,
    0x7,
    0x5,
    0x2,
    0x4,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x8,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0x2,
    0x0,
    0xc,
    0x5,
    0x1,
    0x0,
    0x2,
    0x2,
    0x6,
    0x0,
    0x1,
    0x2,
    0x2,
    0x0,
    0x0,
    0x6,
    0x2,
    0x7,
    0x1,
    0x0,
    0x0,
    0x5,
    0x1,
    0xa,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0xc,
    0x0,
    0x3,
    0x2,
    0x9,
    0x0,
    0x2,
    0x3,
    0x0,
    0x1,
    0x1,
    0x5,
    0x4,
    0x7,
    0x1,
    0x1,
    0x1,
    0x2,
    0x1,
    0x3,
    0x3,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x2,
    0x0,
    0x1,
    0x6,
    0x1,
    0xa,
    0x0,
    0x0,
    0x8,
    0x0,
    0x5,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x7,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x10,
    0x7,
    0x1,
    0x5,
    0xe,
    0x0,
    0x0,
    0x0,
    0x5,
    0x7,
    0x5,
    0x1,
    0x0,
    0x4,
    0x0,
    0x5,
    0x3,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x9,
    0x0,
    0x4,
    0x2,
    0x3,
    0x6,
    0x5,
    0x0,
    0x1,
    0x1,
    0x1,
    0x3,
    0x2,
    0x4,
    0x2,
    0x2,
    0x2,
    0x0,
    0x3,
    0x6,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x14,
    0x0,
    0x0,
    0x7,
    0x5,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x6,
    0xb,
    0x5,
    0x0,
    0xf,
    0x1,
    0x0,
    0x6,
    0x9,
    0x1,
    0x7,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x5,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0x6,
    0x0,
    0x7,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x8,
    0x0,
    0x0,
    0x1,
    0x1,
    0x6,
    0xb,
    0x7,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x8,
    0x1,
    0x1,
    0x5,
    0x2,
    0x1,
    0x2,
    0xa,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x6,
    0x2,
    0x0,
    0x2,
    0x1,
    0x4,
    0x1,
    0x2,
    0x2,
    0x0,
    0x0,
    0x1,
    0x4,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0x4,
    0x3,
    0x2,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x4,
    0x0,
    0x3,
    0x3,
    0x0,
    0x5,
    0x5,
    0x1,
    0x3,
    0x6,
    0x0,
    0x1,
    0x2,
    0x0,
    0xa,
    0x3,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x2,
    0x4,
    0x3,
    0x2,
    0x0,
    0x2,
    0x5,
    0x1,
    0x0,
    0xb,
    0xa,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x3,
    0x8,
    0x2,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x8,
    0x2,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x5,
    0x3,
    0x6,
    0x2,
    0x14,
    0x0,
    0x1,
    0x0,
    0x2,
    0x3,
    0x3,
    0x1,
    0x3,
    0x6,
    0x8,
    0x1,
    0x1,
    0x1,
    0x1,
    0x3,
    0x8,
    0x0,
    0x0,
    0x4,
    0x6,
    0x3,
    0x0,
    0x3,
    0x0,
    0x0,
    0x9,
    0xa,
    0x3,
    0x3,
    0x2,
    0x5,
    0x7,
    0x2,
    0x0,
    0xa,
    0x1,
    0x2,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0x0,
    0x1,
    0x6,
    0x1,
    0x0,
    0x0,
    0xb,
    0x3,
    0x2,
    0x3,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x2,
    0x12,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0xf,
    0x3,
    0x2,
    0xe,
    0x9,
    0x0,
    0x1,
    0x6,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x7,
    0x5,
    0x0,
    0x3,
    0x0,
    0x0,
    0xc,
    0x0,
    0x3,
    0x0,
    0x4,
    0x6,
    0x5,
    0x1,
    0x0,
    0x3,
    0x0,
    0x1,
    0x4,
    0x3,
    0x0,
    0x3,
    0x4,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x6,
    0x0,
    0x6,
    0x0,
    0x2,
    0x0,
    0x2,
    0x3,
    0x3,
    0x5,
    0x1,
    0x0,
    0x5,
    0x5,
    0x3,
    0x1,
    0x1,
    0x1,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0x4,
    0x1,
    0x1,
    0x2,
    0x0,
    0x1,
    0x7,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x1,
    0x1,
    0x3,
    0x0,
    0x0,
    0x4,
    0x2,
    0x5,
    0x1,
    0x2,
    0x3,
    0x0,
    0x3,
    0x1,
    0x0,
    0x0,
    0x1,
    0x6,
    0x1,
    0x1,
    0x0,
    0x0,
    0x3,
    0x5,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x11,
    0x0,
    0x2,
    0x5,
    0x1,
    0x9,
    0x1,
    0x0,
    0x5,
    0x3,
    0x2,
    0x1,
    0x0,
    0x0,
    0x6,
    0x0,
    0x4,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x8,
    0x0,
    0x0,
    0x1,
    0x0,
    0x7,
    0x1,
    0x0,
    0x1,
    0x5,
    0x0,
    0x1,
    0x6,
    0x2,
    0x3,
    0x5,
    0x4,
    0x2,
    0x1,
    0x1,
    0x7,
    0x3,
    0x2,
    0x3,
    0x1,
    0x0,
    0x2,
    0x8,
    0x4,
    0x1,
    0x0,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0xb,
    0x2,
    0x2,
    0xf,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x5,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x6,
    0x2,
    0x2,
    0x3,
    0x1,
    0xc,
    0x0,
    0x1,
    0x6,
    0x2,
    0x3,
    0x2,
    0x1,
    0x2,
    0x1,
    0x3,
    0x2,
    0x3,
    0x1,
    0x2,
    0x1,
    0x0,
    0x4,
    0x5,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x3,
    0x4,
    0x2,
    0xb,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x4,
    0x2,
    0x5,
    0x2,
    0x7,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x6,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x5,
    0x6,
    0x1,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x4,
    0x2,
    0x3,
    0x1,
    0x0,
    0xa,
    0x3,
    0xa,
    0x2,
    0x2,
    0x1,
    0x1,
    0x2,
    0x2,
    0x3,
    0x4,
    0x2,
    0x1,
    0x0,
    0x2,
    0x1,
    0x7,
    0x0,
    0x3,
    0x1,
    0x1,
    0x0,
    0x2,
    0x4,
    0x1,
    0x0,
    0x0,
    0x2,
    0x6,
    0x3,
    0x0,
    0x1,
    0x0,
    0x3,
    0xa,
    0x1,
    0x6,
    0x2,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x6,
    0x3,
    0x0,
    0x2,
    0x6,
    0x3,
    0x4,
    0x0,
    0xa,
    0x0,
    0x2,
    0x0,
    0x4,
    0x0,
    0x0,
    0x4,
    0x3,
    0x2,
    0x2,
    0x0,
    0x8,
    0x1,
    0x4,
    0x4,
    0x1,
    0x1,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x5,
    0x1,
    0x0,
    0xa,
    0x6,
    0x1,
    0x2,
    0x4,
    0x2,
    0x1,
    0x1,
    0x0,
    0x5,
    0x1,
    0x3,
    0x3,
    0x0,
    0x0,
    0x1,
    0x6,
    0x5,
    0xc,
    0x0,
    0x0,
    0xa,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x4,
    0x1,
    0x2,
    0x3,
    0x2,
    0x4,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x2,
    0x7,
    0x1,
    0x4,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x5,
    0x2,
    0x1,
    0x0,
    0x1,
    0xa,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x2,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x4,
    0x4,
    0x1,
    0x4,
    0x4,
    0x0,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x4,
    0x3,
    0x1,
    0x0,
    0x6,
    0x1,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x3,
    0x0,
    0x0,
    0x3,
    0x3,
    0x0,
    0x1,
    0x2,
    0x2,
    0x1,
    0x3,
    0x0,
    0x1,
    0x0,
    0xb,
    0x7,
    0x0,
    0x1,
    0x5,
    0x1,
    0x0,
    0x0,
    0x9,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0xe,
    0x2,
    0x0,
    0x4,
    0x3,
    0x1,
    0x6,
    0x0,
    0x0,
    0x4,
    0x0,
    0x5,
    0x3,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x0,
    0x1,
    0x5,
    0x1,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x1,
    0x7,
    0x1,
    0x1,
    0x2,
    0x6,
    0x4,
    0x2,
    0x3,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x1,
    0x3,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x6,
    0x2,
    0x2,
    0x1,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x2,
    0x4,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x0,
    0x4,
    0x1,
    0x4,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x5,
    0x3,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x0,
    0x7,
    0x4,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x5,
    0x1,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x2,
    0x2,
    0x2,
    0x1,
    0x2,
    0x5,
    0x2,
    0x1,
    0x1,
    0x3,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x3,
    0x6,
    0x0,
    0x3,
    0x2,
    0x0,
    0x5,
    0x0,
    0x4,
    0x4,
    0x3,
    0x1,
    0x0,
    0x2,
    0x8,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x2,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x1,
    0x4,
    0x1,
    0x2,
    0x2,
    0x2,
    0x2,
    0x0,
    0x2,
    0x4,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x2,
    0x4,
    0x4,
    0x1,
    0x2,
    0x0,
    0x1,
    0x2,
    0x1,
    0x4,
    0x2,
    0x3,
    0x6,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x4,
    0x0,
    0x0,
    0x0,
    0x4,
    0x3,
    0x1,
    0x1,
    0x9,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x1,
    0x0,
    0x2,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x5,
    0x2,
    0x4,
    0x1,
    0x0,
    0x2,
    0x0,
    0x8,
    0x0,
    0x3,
    0x1,
    0x3,
    0x1,
    0x2,
    0x1,
    0x1,
    0x2,
    0x1,
    0x1,
    0x3,
    0x3,
    0x1,
    0x0,
    0x3,
    0x1,
    0x2,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x1,
    0x0,
    0x1,
    0x3,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x5,
    0x2,
    0x0,
    0x0,
    0x1,
    0x2,
    0x8,
    0x0,
    0x0,
    0x1,
    0x0,
    0x11,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x6,
    0x3,
    0x0,
    0x2,
    0x2,
    0x1,
    0x1,
    0x5,
    0x3,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x4,
    0x1,
    0x2,
    0x2,
    0x0,
    0x1,
    0x2,
    0x2,
    0x1,
    0x1,
    0xa,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0x1,
    0x4,
    0x6,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x4,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0xb,
    0x1,
    0x8,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x5,
    0x0,
    0x3,
    0xf,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x2,
    0x8,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x3,
    0x0,
];
pub(crate) const COMBINING_MARK_KV: &[u32] = &[
    0xe01cb,
    0x115dd,
    0x0e3a,
    0x11441,
    0xe0134,
    0x11cb1,
    0x115bd,
    0x0faf,
    0xe01dc,
    0x11181,
    0x11934,
    0x11374,
    0x0823,
    0xa67c,
    0x0a4d,
    0xa952,
    0x1e003,
    0x0e49,
    0x17b5,
    0x1074,
    0x2dfe,
    0xa8be,
    0x101fd,
    0x102e0,
    0x0fb1,
    0xa9ba,
    0x0c00,
    0x1daa6,
    0x05a2,
    0xfe26,
    0x0a41,
    0x07a6,
    0x0898,
    0x0b82,
    0x0afb,
    0x0fbb,
    0x1a7a,
    0x1cf1a,
    0x16f6b,
    0xa675,
    0x1cf45,
    0xe012f,
    0xe014f,
    0x11c3b,
    0x2df7,
    0xa9bf,
    0xa8eb,
    0x1bc9e,
    0x1a74,
    0x0eb8,
    0x302c,
    0x0c4d,
    0x064f,
    0x105e,
    0x0741,
    0x1da44,
    0x0b44,
    0x1924,
    0x1da1d,
    0x09c0,
    0xfe2d,
    0x0330,
    0xe01c3,
    0x109d,
    0x0322,
    0x1cf18,
    0x0c02,
    0xe0128,
    0x17cb,
    0x1acb,
    0xe01e3,
    0xa802,
    0x16f72,
    0x11001,
    0x11634,
    0x1da9b,
    0x08ce,
    0x0eb7,
    0x11041,
    0x1a7b,
    0x1057,
    0xe0150,
    0x1b6d,
    0x0ce2,
    0xa8e6,
    0x1103e,
    0x0619,
    0x11081,
    0x0fa3,
    0x114c3,
    0x11a90,
    0x082c,
    0x11173,
    0x1a66,
    0x1e8d4,
    0x1d16e,
    0x111b8,
    0x1934,
    0x1cf0c,
    0xe01ce,
    0x1cf39,
    0x111be,
    0xe01d2,
    0x1da08,
    0xe0141,
    0x11236,
    0x110c2,
    0xfe25,
    0x16b36,
    0x0657,
    0x0749,
    0x0311,
    0xe01c4,
    0x20d3,
    0x1da21,
    0x1be9,
    0x1cf0e,
    0x16f5d,
    0x1d182,
    0x1cf41,
    0x08fe,
    0xfe05,
    0x11a59,
    0x1de6,
    0x1ac6,
    0xe0120,
    0x11a38,
    0x110b7,
    0x1dec,
    0x0351,
    0x0309,
    0x1dcd,
    0x115bc,
    0x114b5,
    0x16f80,
    0x11182,
    0x16f6e,
    0x11caa,
    0xe0198,
    0x0dd8,
    0xa80b,
    0x0eca,
    0x1df0,
    0xa8c5,
    0x0fbc,
    0x1136c,
    0x1064,
    0x1c29,
    0x114c0,
    0x1030,
    0x1abd,
    0x0e4c,
    0x0a02,
    0x1143d,
    0x1e4ed,
    0x20d8,
    0x11a04,
    0x1cf26,
    0xe0116,
    0x0acc,
    0x10f4d,
    0xaaed,
    0x07aa,
    0x0902,
    0x11442,
    0xe012c,
    0x0ac7,
    0xaabe,
    0x1921,
    0x11c9c,
    0x11f3e,
    0x11102,
    0x0953,
    0x1da5b,
    0xa8e9,
    0x11044,
    0x16b33,
    0x08e3,
    0xe0158,
    0xa826,
    0x11f41,
    0x0f19,
    0x1058,
    0xe01ef,
    0xe011d,
    0x17bb,
    0x1171f,
    0x11232,
    0x1cd7,
    0x0364,
    0x1c35,
    0x0a3f,
    0x1a5a,
    0x13453,
    0x11a55,
    0x1def,
    0x0342,
    0x0b4c,
    0xe01ea,
    0x1cf32,
    0x1082,
    0x0b63,
    0x1ac5,
    0x11635,
    0x1a69,
    0x0487,
    0xe0164,
    0x1da33,
    0xe0107,
    0x0bc0,
    0x11c3e,
    0xe01c1,
    0x1daae,
    0x0fa1,
    0x11c95,
    0xa671,
    0x1c36,
    0x1b71,
    0x1b80,
    0x033c,
    0x20d5,
    0x116ae,
    0x1da54,
    0x0819,
    0x1e01f,
    0x0301,
    0x119dc,
    0x11726,
    0x031c,
    0x17b8,
    0xe015b,
    0x1dd0,
    0x0f9e,
    0x0f94,
    0x0f7f,
    0x11d32,
    0x11a8b,
    0x1dda,
    0xe017a,
    0x116b6,
    0x11c9b,
    0x0f8e,
    0x11720,
    0xaa7d,
    0x10f82,
    0xa9b6,
    0x0744,
    0x11f01,
    0x16f73,
    0x11632,
    0x0e38,
    0x0bcc,
    0x11f37,
    0x07f1,
    0x0340,
    0x116b3,
    0x11002,
    0x1e946,
    0x1cf1d,
    0x1da49,
    0x1da2e,
    0x1b3e,
    0xe010a,
    0x09e2,
    0x1cf2d,
    0x0b03,
    0x094f,
    0x11373,
    0x13449,
    0x11838,
    0xaa36,
    0x0ccc,
    0xe01b0,
    0x07ad,
    0x1df1,
    0x17cd,
    0x13455,
    0x0ae2,
    0x1cf3c,
    0x1cf27,
    0x16f85,
    0x1e00a,
    0x11c9f,
    0x1d168,
    0x119de,
    0x11932,
    0x1dc0,
    0x110b0,
    0x1e948,
    0x1da27,
    0x10378,
    0x0310,
    0x0df2,
    0x11038,
    0x114b4,
    0x093a,
    0x1ce0,
    0x094c,
    0x16f64,
    0xa8ec,
    0x111bf,
    0x11133,
    0x1bec,
    0x1da35,
    0xa94d,
    0x1cf00,
    0x032f,
    0xa928,
    0x05c7,
    0x1a19,
    0x0354,
    0x11942,
    0x1cf34,
    0x07b0,
    0x0afa,
    0x1c32,
    0x1da0d,
    0x1cf25,
    0x11d8b,
    0x116b4,
    0x1ac7,
    0xa9bc,
    0x1d18a,
    0xfe21,
    0xe0183,
    0x07ac,
    0x13450,
    0xe012d,
    0x119d6,
    0x1de1,
    0x0cbe,
    0x065b,
    0x0316,
    0x1a59,
    0x1e004,
    0xa670,
    0x1da4b,
    0x17dd,
    0x1e008,
    0xe0191,
    0x0f18,
    0x1143f,
    0xe0190,
    0xabe3,
    0x1da4d,
    0x0cd5,
    0x0dda,
    0x0d63,
    0x0e35,
    0x1cf1e,
    0x1da1e,
    0xe01e8,
    0x114bf,
    0x0746,
    0x1cd1,
    0x1da75,
    0x1e2ec,
    0x0596,
    0x1dfa,
    0x0334,
    0x16f77,
    0x09e3,
    0xe019f,
    0x17ba,
    0x0ac1,
    0x1de3,
    0x1e130,
    0x1ba1,
    0xe01a8,
    0x1ac3,
    0x11c38,
    0x111b3,
    0x0357,
    0xe012a,
    0x116ac,
    0x0f76,
    0x119e0,
    0x1a72,
    0x0fa2,
    0x1772,
    0x05b3,
    0x1df7,
    0x11cb6,
    0x1da63,
    0x16f70,
    0x1cf8,
    0x0747,
    0x112e4,
    0x1e8d3,
    0xaa31,
    0x0cc3,
    0xfe0d,
    0x11a37,
    0x1dcb,
    0x0317,
    0x1dc8,
    0x1c2b,
    0x0eba,
    0x085a,
    0x11835,
    0x036c,
    0x05af,
    0x1143b,
    0x1da10,
    0x11c9e,
    0xa8e1,
    0x035c,
    0x1b03,
    0x0366,
    0x05c4,
    0x1cf0d,
    0x11a8a,
    0xe01c8,
    0xe01a9,
    0x06e1,
    0xfe24,
    0xa926,
    0xa824,
    0xa92d,
    0x111bc,
    0xabea,
    0x0afc,
    0x1ded,
    0x065a,
    0x0952,
    0x1da5d,
    0x0956,
    0x1ce1,
    0x11933,
    0x1d167,
    0xa69f,
    0x0d3e,
    0x110b5,
    0x116b2,
    0x1e017,
    0xe013e,
    0x1d180,
    0x1da67,
    0xaaeb,
    0x1dd1,
    0xaab8,
    0x1cf22,
    0x2cf1,
    0x06d7,
    0x1930,
    0x1da34,
    0x0326,
    0x1032,
    0x1be7,
    0x09c4,
    0x1da57,
    0x1136a,
    0x1daa1,
    0xe0179,
    0x0cc1,
    0x11129,
    0x10f83,
    0x1034,
    0x0a82,
    0xa951,
    0x1344b,
    0x2d7f,
    0x09c7,
    0x11f39,
    0x11f34,
    0x16f5b,
    0x0bbe,
    0x031a,
    0x11d8e,
    0x1e949,
    0x1ab6,
    0x1b40,
    0x1d16d,
    0x0d82,
    0x1134c,
    0x033f,
    0x11d3f,
    0x0dd6,
    0x11445,
    0x1a58,
    0x08de,
    0x1ac2,
    0x1b34,
    0x11ef4,
    0x11d35,
    0xe0195,
    0x1c37,
    0xa9e5,
    0xa980,
    0xe0185,
    0xe018e,
    0xa8ba,
    0x193b,
    0x1da3b,
    0x094b,
    0x10f48,
    0x0d3c,
    0x1dc9,
    0x11046,
    0x1926,
    0x05b0,
    0x0c55,
    0x11c3c,
    0x08e6,
    0x0617,
    0xe0109,
    0x1e134,
    0xfe2c,
    0xabe6,
    0xfe0f,
    0x1df6,
    0x1ac9,
    0x103c,
    0x093c,
    0xe0154,
    0x0ddb,
    0x1cf13,
    0x114c2,
    0x20ea,
    0xe01de,
    0x06ec,
    0x105f,
    0x1d16f,
    0xfe27,
    0xe01c5,
    0xe0182,
    0x05b5,
    0xe0104,
    0xa9be,
    0x1e002,
    0x0cbf,
    0x1886,
    0x1b82,
    0x0fc6,
    0x032a,
    0x0670,
    0x0981,
    0x0595,
    0x08df,
    0x08ca,
    0x1715,
    0x0b41,
    0x0658,
    0x1dc2,
    0x065c,
    0xe0130,
    0x1bac,
    0x1c24,
    0x20de,
    0x111bd,
    0xa8b4,
    0x0486,
    0x0302,
    0xe0102,
    0x1145e,
    0x1da3d,
    0x1cf11,
    0xe0151,
    0xe01b4,
    0x05b7,
    0x1ab4,
    0x1ba2,
    0x1d1ad,
    0x1182d,
    0x1d18b,
    0x17bd,
    0x1cf1f,
    0x0ac9,
    0x11ca7,
    0x1deb,
    0x1d17b,
    0x1da68,
    0x0ecc,
    0x1c30,
    0x116b5,
    0xa8e7,
    0x1112a,
    0x11a3d,
    0x1136b,
    0x05c5,
    0x11363,
    0x08f6,
    0x1ab0,
    0x1163d,
    0x0c82,
    0x1cf40,
    0x0f3f,
    0xe0100,
    0x0dd3,
    0x1035,
    0x1a76,
    0x1daa4,
    0x0314,
    0x10f46,
    0x16f79,
    0xe0159,
    0x0f9c,
    0xe013c,
    0x1183a,
    0x1e000,
    0x1da41,
    0x11a47,
    0x0733,
    0x1da60,
    0x11440,
    0x1b72,
    0x07af,
    0x0f73,
    0xa827,
    0xe01e9,
    0x11a96,
    0x1e012,
    0x11830,
    0x1da46,
    0x2de6,
    0x1cdb,
    0x0616,
    0xfe01,
    0x11300,
    0x0951,
    0x0abc,
    0xaa29,
    0x1931,
    0x1da17,
    0x1a6d,
    0x11723,
    0x10f4a,
    0xe011e,
    0x06e4,
    0x0343,
    0x1cd2,
    0x20d9,
    0x1163e,
    0x05a8,
    0x1122e,
    0x1de0,
    0x103e,
    0x102d,
    0x1da0b,
    0xaac1,
    0x16f7c,
    0x20da,
    0xa948,
    0xa67a,
    0x1cf23,
    0xaa35,
    0xa8bc,
    0x1da55,
    0xe01b3,
    0x16f57,
    0x10a05,
    0x1172a,
    0x1a77,
    0x116b1,
    0x1dc1,
    0x1cf06,
    0x0a75,
    0x16f75,
    0x11d45,
    0x1b3c,
    0x1037,
    0xe01be,
    0xe01a5,
    0x11833,
    0x0954,
    0xfe0b,
    0x16f6f,
    0x10eff,
    0x064e,
    0x0320,
    0x1dcf,
    0xfe29,
    0x09be,
    0x0f35,
    0x0cd6,
    0x0489,
    0x0d4a,
    0x17b7,
    0x1dfc,
    0xabe8,
    0x1dce,
    0x1b6c,
    0x0ddf,
    0x16f90,
    0x11633,
    0x11a94,
    0xa94f,
    0x11837,
    0x0d00,
    0x1d171,
    0x108b,
    0x0732,
    0x11a99,
    0x1d186,
    0x0303,
    0x10377,
    0x114b3,
    0x1e015,
    0x0f9f,
    0x0acd,
    0xa8c1,
    0x1daa3,
    0x11c98,
    0x115ba,
    0xe017b,
    0x0bc7,
    0x11368,
    0x08e7,
    0x0ae3,
    0x0c4c,
    0x1cf37,
    0x1cf3d,
    0x112e3,
    0x1bf1,
    0x112e2,
    0x1d170,
    0xa9b3,
    0x0362,
    0x0f84,
    0xe013f,
    0x0483,
    0x05b2,
    0xe0160,
    0x11cae,
    0x10f4f,
    0x16f61,
    0xaaef,
    0xe01d8,
    0x11a06,
    0x0339,
    0x11636,
    0x114b2,
    0x11c2f,
    0x0b3e,
    0x1163a,
    0x10f49,
    0xa8ea,
    0x0c41,
    0x0655,
    0x11234,
    0x032c,
    0xe01af,
    0x1d17f,
    0x0d3b,
    0x1da23,
    0xfb1e,
    0x0ac2,
    0x1bad,
    0x1163c,
    0x0f95,
    0xa8bf,
    0x1cf28,
    0xe0139,
    0x10f85,
    0x1abb,
    0x1da29,
    0x1cf4,
    0x06e8,
    0x1e8d1,
    0x0b3c,
    0xe011c,
    0x1e013,
    0x1ace,
    0x05ab,
    0x10ae6,
    0x20e1,
    0x1cf3f,
    0x1dfb,
    0x08cd,
    0x11c36,
    0x073b,
    0x082a,
    0x17b6,
    0x0e48,
    0x20ee,
    0x11937,
    0x1cdf,
    0xe0162,
    0x1cf3a,
    0x08d9,
    0x11637,
    0x2dfb,
    0xe018c,
    0x1df9,
    0x11073,
    0x135f,
    0x08d7,
    0x1773,
    0x08e0,
    0x16af3,
    0x0610,
    0xe019c,
    0x0901,
    0x1e018,
    0x1e027,
    0x1da2c,
    0x0b43,
    0x180c,
    0x1753,
    0x114b1,
    0x115b2,
    0xabe7,
    0x031d,
    0x0c01,
    0x111b4,
    0xe01e2,
    0x08f5,
    0x11cb5,
    0x0cbc,
    0x1a1a,
    0x1da14,
    0x1dc7,
    0x1a18,
    0x0d62,
    0x0742,
    0x1da58,
    0x111b9,
    0x11a35,
    0x115b9,
    0x0369,
    0x05a6,
    0xa8f0,
    0xe0169,
    0x116ab,
    0x0ecb,
    0x0599,
    0x1da59,
    0x2dec,
    0x11c99,
    0x0358,
    0x11128,
    0xa8b5,
    0x1cf17,
    0x16af2,
    0x1133c,
    0x0711,
    0x11369,
    0x1a70,
    0x1062,
    0xa94e,
    0x1da11,
    0x059c,
    0x0fb9,
    0x11d42,
    0xa92a,
    0x11d91,
    0x1aba,
    0x1a6b,
    0x1122c,
    0xe0136,
    0x1086,
    0x1067,
    0xe01a2,
    0x0afd,
    0x1da15,
    0x16f83,
    0x1da2a,
    0x1cf29,
    0x1da28,
    0x1b70,
    0x17b4,
    0x0ebb,
    0x0947,
    0x11371,
    0x1a1b,
    0x0361,
    0x11d34,
    0x1cd4,
    0x1cf3e,
    0x11935,
    0x11130,
    0x1a5b,
    0x11134,
    0xe0149,
    0x11446,
    0x0363,
    0xe0180,
    0xfe0c,
    0x11c35,
    0x0eb6,
    0x0fa4,
    0x0fa0,
    0x08ff,
    0x114ba,
    0x11439,
    0xe0170,
    0x0d40,
    0xe015f,
    0x06dc,
    0x111c9,
    0x0c48,
    0x1734,
    0x1da43,
    0xaa2c,
    0x0ecd,
    0xe01b1,
    0x1e023,
    0x16f60,
    0x089d,
    0x0e4d,
    0x07ee,
    0x0312,
    0xa8c4,
    0x034c,
    0x1103c,
    0x0829,
    0x1cf42,
    0x1daa2,
    0x11729,
    0x0957,
    0x119d1,
    0x1dc6,
    0x1cf08,
    0x1abf,
    0x059e,
    0x0d81,
    0xe01d3,
    0x1da09,
    0x1d17d,
    0x112e5,
    0x11d90,
    0x1e01e,
    0x1e135,
    0x030f,
    0x110b2,
    0x111ce,
    0x17c6,
    0xa8e3,
    0x16f66,
    0x0a3e,
    0x1e132,
    0xe0155,
    0x1e4ee,
    0x07ab,
    0x20ed,
    0x0963,
    0xe01d0,
    0xe01bf,
    0x08d3,
    0x1cde,
    0x1ba4,
    0x0ce3,
    0x11437,
    0x0b02,
    0x0c40,
    0x08f4,
    0x11f38,
    0x1088,
    0xa950,
    0x1bee,
    0xa881,
    0xe01a0,
    0x0900,
    0x1e8d6,
    0x1171e,
    0xe01b5,
    0x05ac,
    0xe0125,
    0x20ef,
    0x05b6,
    0xe01a7,
    0x11d8d,
    0xe017c,
    0x0ccb,
    0x1b3f,
    0x20eb,
    0x0a3c,
    0xe0157,
    0x1a57,
    0x1d1ac,
    0xa8ef,
    0x0598,
    0x112e0,
    0xe012b,
    0x0f80,
    0x1ddc,
    0x034b,
    0x1a68,
    0xa6f0,
    0x059b,
    0x1b81,
    0x16b32,
    0x0faa,
    0x109c,
    0x034d,
    0xe010c,
    0x0319,
    0x1925,
    0x11a3b,
    0x031b,
    0x1a64,
    0x08d4,
    0xa677,
    0x0b62,
    0x11045,
    0x0acb,
    0x1112f,
    0xe01d4,
    0x1da0a,
    0x115af,
    0x0613,
    0xaaf5,
    0x08f1,
    0x11a56,
    0x0bbf,
    0xaa4c,
    0x1037a,
    0x1dff,
    0x0abe,
    0x302e,
    0x1b39,
    0x1da9d,
    0x1a6a,
    0x11ef6,
    0xe01aa,
    0x112ea,
    0x1e01c,
    0x1039,
    0x05b8,
    0x11c34,
    0x20db,
    0x11230,
    0x0c83,
    0x1036,
    0x0948,
    0x119db,
    0xe01ed,
    0x1c31,
    0x10a3f,
    0x1ab5,
    0x11d94,
    0xa983,
    0x0ccd,
    0x17c4,
    0x11931,
    0x11f42,
    0x1c28,
    0x1da32,
    0x11145,
    0x302a,
    0xe0135,
    0x0ac8,
    0x0cc7,
    0xe01ad,
    0x1da00,
    0x1b37,
    0x036f,
    0x11d43,
    0x116ad,
    0x11ef5,
    0xa8ff,
    0x1da19,
    0x030a,
    0x09cc,
    0x10eac,
    0x11d8c,
    0x11a0a,
    0xaab4,
    0xfe2f,
    0x0ac0,
    0xe0194,
    0x065f,
    0x11a07,
    0xe015a,
    0xe0173,
    0x1c27,
    0x17c8,
    0x0820,
    0x065d,
    0x0bcb,
    0xe01dd,
    0x11343,
    0x1e009,
    0x0941,
    0x1752,
    0x1ce4,
    0x0329,
    0x1713,
    0xe0118,
    0x119da,
    0x1da6a,
    0x08f2,
    0x0f71,
    0x16f51,
    0x089e,
    0x2df8,
    0x10a0e,
    0x2de4,
    0xaa2a,
    0xe0192,
    0x0dd2,
    0x0c81,
    0xe01c7,
    0x10a38,
    0xe0176,
    0x20e9,
    0xe019d,
    0x20e7,
    0x032e,
    0x1e01d,
    0x1cf24,
    0x0731,
    0x0ac4,
    0xe017d,
    0x16f7b,
    0x1c34,
    0x115b5,
    0x0306,
    0x16f76,
    0x0bc8,
    0x061a,
    0xa949,
    0x08f0,
    0x11cb2,
    0x1133f,
    0x111b5,
    0x11344,
    0x082d,
    0x1dd3,
    0x1d172,
    0xe010b,
    0x2df6,
    0x06e0,
    0x1107f,
    0x16f74,
    0x11d47,
    0x11943,
    0x16b30,
    0x11a01,
    0x0d4b,
    0xaa7b,
    0x1da22,
    0xe01ec,
    0x13447,
    0x1cf0b,
    0x11c9a,
    0x2dfa,
    0xe01c2,
    0x11724,
    0x0485,
    0x11a52,
    0xe01cd,
    0x1da03,
    0xa8bb,
    0x11722,
    0x11930,
    0x06ed,
    0x0615,
    0x1daa8,
    0xe0132,
    0x1cf33,
    0x11042,
    0x1cd8,
    0x1a17,
    0xe0171,
    0x089f,
    0x119dd,
    0x1da5e,
    0x1d1aa,
    0x1da24,
    0x0b01,
    0x1a5e,
    0x11d3d,
    0xe0165,
    0x0367,
    0x110b6,
    0x11074,
    0x1cf38,
    0x11237,
    0x1df3,
    0x1de5,
    0xe0140,
    0xa672,
    0x074a,
    0x10376,
    0x180d,
    0xe01c9,
    0x0c63,
    0x064c,
    0x1ba8,
    0x0f7c,
    0x16f55,
    0xe010d,
    0x0484,
    0x11caf,
    0xe0106,
    0x0318,
    0x119e4,
    0x032b,
    0xe016e,
    0x11438,
    0x116af,
    0x17cf,
    0x1344d,
    0x1e4ef,
    0x11f03,
    0x1da47,
    0x106d,
    0x1ddf,
    0x0d47,
    0x0c4a,
    0x0a4c,
    0x1cda,
    0x0591,
    0x0b56,
    0x1d187,
    0x0a47,
    0x10a0c,
    0x0a81,
    0xa8b6,
    0x11d95,
    0x0cc0,
    0x0a83,
    0x1927,
    0x06d8,
    0xe011b,
    0x06d6,
    0x2dea,
    0x1a61,
    0xe0117,
    0x20e4,
    0xa9b8,
    0x10f84,
    0x08dd,
    0xe01bb,
    0x1dd2,
    0x1da05,
    0x0f87,
    0x1bea,
    0x17d1,
    0x11728,
    0x1dc3,
    0x114b0,
    0xa8b9,
    0x073c,
    0x0a48,
    0x094e,
    0xa94b,
    0x0fb6,
    0x17c1,
    0x05a7,
    0x1df2,
    0x0bd7,
    0x0d83,
    0x1cf3b,
    0x16fe4,
    0x10efd,
    0x0365,
    0x089a,
    0x0fa6,
    0x1da3c,
    0x11c9d,
    0xe0114,
    0x1ab7,
    0x081f,
    0xa8e8,
    0x1193b,
    0x0eb1,
    0x032d,
    0x1cf2c,
    0xa8e4,
    0xe01d7,
    0x059d,
    0xabed,
    0x16f78,
    0x1b04,
    0x08f3,
    0x11101,
    0x115be,
    0x11d31,
    0x1c33,
    0x1cf07,
    0x0307,
    0x0651,
    0x1ce5,
    0x1dd9,
    0x115b8,
    0xe01ac,
    0x033e,
    0x1920,
    0x08e9,
    0x2df9,
    0x16f58,
    0xe01d5,
    0x16f6d,
    0xe014a,
    0x0d4d,
    0x11ca0,
    0x1cf0a,
    0x1ce8,
    0x1060,
    0x11c96,
    0x035e,
    0xe0186,
    0x115bb,
    0x119d7,
    0x16af4,
    0x1daa9,
    0x0982,
    0x11cb3,
    0x1cf2a,
    0x11ca4,
    0x033b,
    0x135d,
    0x11435,
    0x114b8,
    0x09bc,
    0x1e005,
    0x11082,
    0x1d1ab,
    0x10a03,
    0xa8f1,
    0x0e4a,
    0x11ca2,
    0xabec,
    0x081c,
    0x1ce2,
    0x1da0e,
    0x06df,
    0xfe22,
    0x1ce6,
    0x1087,
    0x0f8f,
    0x11a8f,
    0x09c2,
    0x1da4e,
    0x1e006,
    0x08d0,
    0x1dd8,
    0x1714,
    0x0a40,
    0xe0126,
    0x11a53,
    0x13451,
    0x1059,
    0x1da61,
    0x1e2ed,
    0x1d17c,
    0xa678,
    0x3099,
    0x16f65,
    0xe0131,
    0x0826,
    0x11c3d,
    0x0df3,
    0x180f,
    0x1a56,
    0x11d8a,
    0x1cd9,
    0xa8e0,
    0xe0129,
    0x1938,
    0x11f00,
    0x0345,
    0x1b02,
    0xa9bd,
    0x11443,
    0xa806,
    0xa9b9,
    0x1da0c,
    0xe01d6,
    0x1e00f,
    0x1932,
    0x13454,
    0x1134b,
    0x192a,
    0x0f79,
    0x1a60,
    0x0659,
    0x11f3a,
    0x1e8d5,
    0x0d01,
    0x0734,
    0x11146,
    0xe0108,
    0xe0153,
    0x06eb,
    0xe013b,
    0x1a73,
    0xe0167,
    0x11a98,
    0x0f72,
    0x11831,
    0x1dcc,
    0x0f81,
    0x119d5,
    0x16f68,
    0x0f90,
    0x114bb,
    0x2dfd,
    0xfe00,
    0x08f7,
    0x1da56,
    0xe0187,
    0xa9c0,
    0x0f93,
    0xa67b,
    0x0344,
    0x20e2,
    0x08fa,
    0x082b,
    0x05a1,
    0x1ba3,
    0x1da42,
    0x0313,
    0x11366,
    0x1a6c,
    0xe01db,
    0xa929,
    0xe01e5,
    0x1da1b,
    0x116b0,
    0x0324,
    0x17be,
    0x17c0,
    0x20dd,
    0x11836,
    0x10f50,
    0x073d,
    0xe01bd,
    0x0dd1,
    0x1933,
    0x1cf1b,
    0x081b,
    0xaa43,
    0xe01ee,
    0x115dc,
    0x1de4,
    0x0349,
    0x11c32,
    0xe0184,
    0xa953,
    0x20ec,
    0xe0147,
    0x1cf31,
    0xaa2d,
    0x0b47,
    0x08cf,
    0xa92c,
    0x1e024,
    0x1e01b,
    0x1acd,
    0xe0181,
    0xe0124,
    0x1a62,
    0x09bf,
    0x059a,
    0x0d4c,
    0x11727,
    0x109b,
    0x115c0,
    0x2def,
    0xe010e,
    0x1ced,
    0xaa30,
    0x1baa,
    0xaabf,
    0x1da18,
    0x1daaf,
    0x1da1a,
    0x1d181,
    0x1ba6,
    0x1cf02,
    0x11ca9,
    0xe01ba,
    0x0903,
    0x1cf05,
    0x0abf,
    0x108c,
    0x115bf,
    0x0d46,
    0xe0111,
    0x05a0,
    0x11c3a,
    0x11725,
    0x0c04,
    0x08d5,
    0x10379,
    0x0308,
    0x1e020,
    0x0f9a,
    0x17c3,
    0xfe06,
    0x1a55,
    0x115b0,
    0x111b7,
    0x20d4,
    0x16f87,
    0x0a03,
    0xe0163,
    0x102b,
    0x06e2,
    0xa9bb,
    0x07a9,
    0xaa4d,
    0x10f4c,
    0x11d97,
    0x114bc,
    0x2cf0,
    0x1ab8,
    0x1a67,
    0x106b,
    0x0f75,
    0x11348,
    0x1cf9,
    0x11070,
    0x065e,
    0xe0199,
    0x0f7b,
    0xa679,
    0x11a05,
    0x1ab2,
    0x034a,
    0xa82c,
    0x1e136,
    0x10f4b,
    0x20d2,
    0x1cf46,
    0x1da9e,
    0x08db,
    0x0f39,
    0x111bb,
    0x1da26,
    0x10d26,
    0x1e00c,
    0x102c,
    0x16f86,
    0xe012e,
    0x1e944,
    0x0fb7,
    0x1b36,
    0x0c47,
    0x180b,
    0x0654,
    0x11cad,
    0x08ec,
    0x16f6c,
    0x1b44,
    0x0ece,
    0x0ddc,
    0xe01e7,
    0xe0177,
    0x1dd7,
    0xe015e,
    0x0b55,
    0x0aff,
    0x0cca,
    0x1163b,
    0x1b01,
    0x112e7,
    0x10a01,
    0x0f99,
    0x11a3e,
    0x1da01,
    0x1143c,
    0x11a97,
    0xe019e,
    0xe019a,
    0x135e,
    0xe018b,
    0x034f,
    0x1193d,
    0x0368,
    0xaaee,
    0xaa2b,
    0x10f47,
    0x10f4e,
    0x0f91,
    0xe0112,
    0x11640,
    0x08ee,
    0x11080,
    0x11c33,
    0x16f7f,
    0x1dde,
    0x1daab,
    0xe017e,
    0x0945,
    0x0593,
    0x1da5a,
    0x05bb,
    0x0942,
    0x1da30,
    0xaaf6,
    0x1da50,
    0x16ff0,
    0xa8b7,
    0x11940,
    0x0360,
    0x2df5,
    0x073f,
    0x1a78,
    0x09fe,
    0x08e5,
    0x17ce,
    0x16f52,
    0xfe2e,
    0x1c2f,
    0x1182e,
    0xe017f,
    0x2df4,
    0xe01a3,
    0x11631,
    0x07f0,
    0x11ef3,
    0x05bd,
    0x1dfe,
    0x1133e,
    0x11a02,
    0xe0110,
    0x0afe,
    0x2dee,
    0x05a5,
    0x0594,
    0x1da04,
    0x08ef,
    0xe0145,
    0x030e,
    0x0347,
    0x0c62,
    0xfe09,
    0x1133b,
    0x114bd,
    0x111b6,
    0x1cf10,
    0x1da3e,
    0xe01b9,
    0x1da48,
    0x0b4d,
    0x1dc5,
    0x0dd4,
    0x1e945,
    0x0618,
    0x0f74,
    0x11043,
    0x1a7f,
    0x08d6,
    0x1e08f,
    0x11c30,
    0x11a8c,
    0xe01ca,
    0x0332,
    0x16af0,
    0x0dde,
    0x16f7a,
    0x10a0f,
    0x20d0,
    0x11362,
    0x1e00d,
    0x1112b,
    0x05a3,
    0x0a70,
    0x1da65,
    0x11a5b,
    0xa9b7,
    0x11ca3,
    0x0fb8,
    0x1033,
    0x111cf,
    0xe011a,
    0x0822,
    0x05c2,
    0x1733,
    0xe0175,
    0x1ab9,
    0xe014e,
    0x1e02a,
    0x0f3e,
    0x106c,
    0x093b,
    0x2de5,
    0x17cc,
    0x20e3,
    0x1da9f,
    0x11938,
    0x0736,
    0x1e029,
    0x0d03,
    0x0bcd,
    0x11cab,
    0x11039,
    0x1e4ec,
    0x1cf03,
    0x030d,
    0x1089,
    0x302b,
    0x11301,
    0x11131,
    0xa92b,
    0x1d17e,
    0x111ca,
    0x1e8d0,
    0x0650,
    0x2df3,
    0x08dc,
    0x102e,
    0xa94c,
    0x0c03,
    0xaab2,
    0x0eb5,
    0xa8e2,
    0x0f77,
    0xe0138,
    0x1bed,
    0xe01cf,
    0x112e9,
    0xe0144,
    0x11d33,
    0x1ac0,
    0xe01b6,
    0x17c2,
    0x0ac5,
    0x11d44,
    0x0739,
    0x11839,
    0x1885,
    0x11100,
    0x064b,
    0x1ba5,
    0x110b3,
    0x0e47,
    0x08d2,
    0x07ef,
    0x0335,
    0x0f86,
    0x1a5d,
    0x030c,
    0xa67d,
    0x1d165,
    0x11cb0,
    0x033d,
    0x1beb,
    0x16f8f,
    0x11a5a,
    0x10ae5,
    0x1da13,
    0x103d,
    0x1cf12,
    0x0e36,
    0x11630,
    0x0944,
    0xaab7,
    0x10a3a,
    0x1da31,
    0x1cf30,
    0x07f2,
    0x1cf09,
    0xe014c,
    0x1cf15,
    0x0d42,
    0x0946,
    0x1da40,
    0x0cc6,
    0x09c1,
    0x06e7,
    0x0fa9,
    0x1ba7,
    0x0cf3,
    0x0341,
    0x05ba,
    0x1acc,
    0x0bc6,
    0x1ddb,
    0x0327,
    0x1da2d,
    0xe0178,
    0x2dff,
    0x16b34,
    0x0bca,
    0x1939,
    0x1be6,
    0x0fad,
    0x119d3,
    0xa9b4,
    0x11d3a,
    0x0488,
    0x20e0,
    0x1cf36,
    0x0337,
    0x1abe,
    0x1031,
    0x1dd4,
    0x09d7,
    0x1163f,
    0x1cf21,
    0x1dc4,
    0xfe04,
    0xe0189,
    0x036a,
    0x1ddd,
    0x114b6,
    0x11180,
    0xe016a,
    0x16f6a,
    0x16ff1,
    0xe0127,
    0x11231,
    0x11241,
    0x0656,
    0xe0161,
    0x0346,
    0x1143a,
    0x1cd6,
    0x0949,
    0x1c26,
    0x110b1,
    0x11436,
    0x11a03,
    0x11367,
    0x1e2ae,
    0xfe0a,
    0x1e00e,
    0x0325,
    0x1da9c,
    0x1a65,
    0x0983,
    0x11a08,
    0x17b9,
    0x0c4b,
    0xe0174,
    0x1d244,
    0x1344f,
    0x2de7,
    0x1b38,
    0xe013a,
    0x20dc,
    0xe011f,
    0x1cf19,
    0x08d1,
    0x1e010,
    0x0955,
    0x16f69,
    0x10eab,
    0x17c7,
    0x11340,
    0x081d,
    0x0328,
    0x1e028,
    0x17bc,
    0xaab3,
    0xe01b7,
    0x0e4e,
    0x1abc,
    0x1da66,
    0x1732,
    0xe01ae,
    0x1cf43,
    0x1d243,
    0x1712,
    0x0c42,
    0x0b3f,
    0x302d,
    0xe01e6,
    0x1da1c,
    0x2ded,
    0x1b41,
    0x11cb4,
    0xe0148,
    0xe0123,
    0x11d93,
    0x1072,
    0x1936,
    0x1063,
    0x0c56,
    0x11a39,
    0x1e2ef,
    0xe01ab,
    0x17d0,
    0x1d242,
    0x0359,
    0x1123e,
    0x11639,
    0x1b73,
    0xe0152,
    0x11a8d,
    0x16af1,
    0x035b,
    0x0bc2,
    0x1da12,
    0xe01da,
    0x11c93,
    0x094a,
    0x073e,
    0x11372,
    0x0d48,
    0x1de9,
    0x114c1,
    0x07ae,
    0x11a54,
    0x10a39,
    0x11638,
    0x2deb,
    0x073a,
    0x1cf0f,
    0x0fab,
    0x1aca,
    0xa8c3,
    0xa981,
    0x1ac4,
    0x1e133,
    0xabe5,
    0x1da52,
    0x0e37,
    0xe0105,
    0x11357,
    0x0336,
    0x0c3e,
    0xe010f,
    0xe0188,
    0x111cb,
    0x11444,
    0x0940,
    0x11cac,
    0xa8ed,
    0x114b7,
    0x11832,
    0x0743,
    0x08d8,
    0x1e026,
    0x1da53,
    0x11c3f,
    0x1da06,
    0xe019b,
    0x119d2,
    0xaa34,
    0x1b00,
    0x0730,
    0x13440,
    0x0cc4,
    0xe0146,
    0x1c25,
    0x030b,
    0x11a95,
    0x0323,
    0x1e00b,
    0x0943,
    0x0f8d,
    0x0dca,
    0x10d25,
    0x2de9,
    0x1bab,
    0x115b1,
    0x1da2b,
    0x0ebc,
    0x1e131,
    0xe018a,
    0x1923,
    0x05c1,
    0x20df,
    0x1103d,
    0xa927,
    0x1c2e,
    0x07ec,
    0x16f82,
    0xe01e4,
    0x1da25,
    0x0f7a,
    0x1cf20,
    0x1171d,
    0x11347,
    0x112e6,
    0x1d188,
    0x11d41,
    0x1068,
    0x089c,
    0x11f36,
    0x11341,
    0xaa2f,
    0x0356,
    0xe0137,
    0x1344c,
    0x0fb0,
    0xe016b,
    0x1df4,
    0x1112d,
    0x1de2,
    0x1103b,
    0x08f9,
    0xe01c0,
    0x11f40,
    0x119df,
    0x1083,
    0xaa33,
    0x13448,
    0x0fb4,
    0x0ac3,
    0xabe4,
    0x11a3c,
    0x1134d,
    0x114b9,
    0x103a,
    0x1da20,
    0x08da,
    0x16f56,
    0x309a,
    0x11127,
    0x11a93,
    0x192b,
    0x0f97,
    0x1cd5,
    0x1da5f,
    0x1084,
    0x0eb4,
    0x11370,
    0x10efe,
    0x1069,
    0x111c0,
    0x11834,
    0x119d4,
    0x1193c,
    0x1cf1c,
    0x1928,
    0x17bf,
    0x1da6c,
    0xe0156,
    0x1bf2,
    0x0304,
    0x11ca1,
    0x11233,
    0x0859,
    0x0a42,
    0x1c2d,
    0x0738,
    0x0592,
    0x1b6f,
    0x0355,
    0x0ddd,
    0x1a71,
    0x0bc1,
    0x112df,
    0x1344e,
    0x1daac,
    0x1e014,
    0x0d44,
    0x1df8,
    0x16f4f,
    0xe01e0,
    0x1da16,
    0x11721,
    0x0d02,
    0x20e5,
    0x115b4,
    0x1b42,
    0x1b43,
    0x0b40,
    0xe016c,
    0x08ed,
    0x109a,
    0x11303,
    0x1cf35,
    0x1344a,
    0x17c5,
    0x11c39,
    0xa66f,
    0x093f,
    0x20d7,
    0x05ae,
    0x1cf14,
    0x1e016,
    0x08eb,
    0x16f53,
    0x0745,
    0x0353,
    0x0c3c,
    0x0315,
    0x16f54,
    0x0eb9,
    0x114be,
    0x08cb,
    0x16f81,
    0x06db,
    0x07a7,
    0x0a4b,
    0x20e6,
    0x1df5,
    0xe01a4,
    0xfe23,
    0x1172b,
    0x0dd9,
    0x1929,
    0x302f,
    0x064d,
    0x0a01,
    0x09c8,
    0x20d1,
    0xe018f,
    0xa8e5,
    0xa8c2,
    0x16b31,
    0xa6f1,
    0x0f92,
    0x07fd,
    0x094d,
    0x0e4b,
    0x1193e,
    0xe0115,
    0x093e,
    0x0821,
    0x1cd0,
    0x1c2a,
    0x0735,
    0xa823,
    0x05a4,
    0xe0121,
    0xe015c,
    0x1a79,
    0x0f83,
    0x112e1,
    0xa947,
    0x16f5e,
    0x10a06,
    0x17d3,
    0x1d185,
    0x0d57,
    0x16f62,
    0x0f96,
    0x115b3,
    0x11f35,
    0xe0119,
    0x16f7d,
    0xfe02,
    0x0c46,
    0x1cf44,
    0x2de0,
    0xaa2e,
    0x111ba,
    0x110b4,
    0x1e8d2,
    0x11c92,
    0x1d169,
    0x035f,
    0x0740,
    0x1cdc,
    0x1122d,
    0x2de8,
    0x0748,
    0x0ec9,
    0x1a63,
    0x1da5c,
    0x1b35,
    0x0cc2,
    0x1112c,
    0xe0113,
    0x06da,
    0x1922,
    0x2de3,
    0x18a9,
    0x1ba9,
    0x08cc,
    0x11a57,
    0x102f,
    0x0737,
    0x0652,
    0x10a0d,
    0x05b4,
    0x11000,
    0x0fa7,
    0x06e3,
    0x1bf3,
    0xe01a6,
    0x0352,
    0x0305,
    0x0f82,
    0xe0172,
    0x11235,
    0x0d43,
    0x106a,
    0x20e8,
    0x11c94,
    0x1b6e,
    0x05b1,
    0x0614,
    0x08fb,
    0x11132,
    0x103b,
    0x110b9,
    0x112e8,
    0x1b6b,
    0x1da6b,
    0x1c2c,
    0x1b3a,
    0xe01bc,
    0x1da64,
    0x1085,
    0x1da45,
    0x11d36,
    0x20f0,
    0x1da0f,
    0x0899,
    0xe01d9,
    0x031e,
    0x0fa5,
    0x1182c,
    0xe01a1,
    0xe01c6,
    0x0350,
    0x13452,
    0x1ce3,
    0x2de1,
    0x2dfc,
    0x1da4a,
    0x1cf04,
    0x16f63,
    0x1d189,
    0xe0101,
    0xe014d,
    0x11a92,
    0x0817,
    0x11c31,
    0x11040,
    0xe01df,
    0x1e021,
    0x11302,
    0xe01e1,
    0xe0166,
    0x11a34,
    0x111cc,
    0xaaec,
    0x0962,
    0xfe07,
    0x1cf16,
    0x1bef,
    0x08ea,
    0x1e011,
    0x0f7e,
    0x1daa7,
    0x1937,
    0xe016d,
    0x1dee,
    0xfe28,
    0x085b,
    0xa94a,
    0x1dd5,
    0x1dea,
    0x1a6f,
    0xfe03,
    0x1a75,
    0x06ea,
    0x16f7e,
    0x0f37,
    0x1182f,
    0x059f,
    0x1da69,
    0x0fac,
    0x0c3f,
    0x0d41,
    0x16f84,
    0x0fae,
    0xe0168,
    0x0c44,
    0x034e,
    0x08fc,
    0x05bf,
    0x0dd0,
    0x1bf0,
    0x2cef,
    0x1ab3,
    0x0d3f,
    0x1cf2b,
    0xa8c0,
    0x1a5c,
    0x16f67,
    0x1daaa,
    0xe016f,
    0x1da84,
    0x2df2,
    0x05a9,
    0xe013d,
    0x0c43,
    0x1da36,
    0xe0103,
    0x08fd,
    0x0fba,
    0x0ec8,
    0x1da1f,
    0xa9b5,
    0x1be8,
    0xfe2b,
    0x108d,
    0x06d9,
    0x1cdd,
    0x0816,
    0xa676,
    0x0818,
    0x16f5f,
    0x0fa8,
    0x0f9b,
    0x0f9d,
    0x0e31,
    0x11a91,
    0x0611,
    0x0b4b,
    0x0b57,
    0xe015d,
    0x108f,
    0x1e001,
    0x17ca,
    0x08e1,
    0x1bc9d,
    0x2df1,
    0x0b42,
    0x081e,
    0x16f59,
    0xfe20,
    0x0597,
    0x1cf01,
    0x1038,
    0x035a,
    0xe0196,
    0x1a6e,
    0x1daa5,
    0x0321,
    0x1da51,
    0x17d2,
    0x1daad,
    0x033a,
    0x1056,
    0x1ab1,
    0x0dcf,
    0x1e947,
    0x0300,
    0x10d24,
    0x10a02,
    0x11342,
    0x1ce7,
    0x031f,
    0x1073,
    0x0653,
    0x0fb2,
    0x11a33,
    0xe01cc,
    0x1da02,
    0xe0133,
    0x2de2,
    0x0333,
    0x0a71,
    0xe01eb,
    0x11d96,
    0x0612,
    0xa8b8,
    0x08e8,
    0x11ca6,
    0x1de8,
    0x1da4f,
    0x07a8,
    0x0e39,
    0xa982,
    0x036e,
    0x193a,
    0x16f91,
    0x10d27,
    0x0f78,
    0x035d,
    0x1da2f,
    0x11a36,
    0xaab0,
    0xfe0e,
    0x05ad,
    0x1dd6,
    0xe0142,
    0x1dfd,
    0x1122f,
    0x08e4,
    0xaa7c,
    0x1b3b,
    0x0b48,
    0x05bc,
    0xa8ee,
    0x11c97,
    0x110b8,
    0xe01b2,
    0xe0122,
    0x11a8e,
    0x11a58,
    0x036b,
    0x0331,
    0x16f71,
    0x1143e,
    0x110ba,
    0x1112e,
    0x089b,
    0x1ac1,
    0xe0143,
    0x07ed,
    0xa674,
    0x2df0,
    0x1da62,
    0xa8bd,
    0x1b3d,
    0x11d3c,
    0xe014b,
    0xaa32,
    0x11a51,
    0x16f92,
    0x1d166,
    0x0cc8,
    0x1dca,
    0xe01b8,
    0x1ac8,
    0x17c9,
    0xfe08,
    0x0338,
    0x1de7,
    0xe018d,
    0xa69e,
    0x1da4c,
    0x07f3,
    0x16b35,
    0x0a51,
    0xa825,
    0x1071,
    0x11f3f,
    0x0348,
    0x116b7,
    0x09c3,
    0x1e2ee,
    0x0e34,
    0x036d,
    0xabe9,
    0x1cf7,
    0x1935,
    0x05aa,
    0x1103f,
    0x11a09,
    0x1da3f,
    0x108a,
    0x16f5c,
    0x20d6,
    0x07eb,
    0xfe2a,
    0xe0193,
    0x11d40,
    0x05b9,
    0x0f7d,
    0x16f5a,
    0xe0197,
    0x09cd,
    0x0fb5,
    0x1da07,
    0xe01d1,
    0xa880,
    0x1a7c,
    0x11ca5,
    0x09cb,
    0x0fb3,
    0x0825,
    0x1103a,
    0x0827,
    0x1e94a,
    0x08f8,
];


#[inline]
pub fn is_public_assigned(c: char) -> bool {
    match c {
        '\u{0000}'..='\u{0377}'
        | '\u{037A}'..='\u{037F}'
        | '\u{0384}'..='\u{038A}'
        | '\u{038C}'
        | '\u{038E}'..='\u{03A1}'
        | '\u{03A3}'..='\u{052F}'
        | '\u{0531}'..='\u{0556}'
        | '\u{0559}'..='\u{058A}'
        | '\u{058D}'..='\u{058F}'
        | '\u{0591}'..='\u{05C7}'
        | '\u{05D0}'..='\u{05EA}'
        | '\u{05EF}'..='\u{05F4}'
        | '\u{0600}'..='\u{070D}'
        | '\u{070F}'..='\u{074A}'
        | '\u{074D}'..='\u{07B1}'
        | '\u{07C0}'..='\u{07FA}'
        | '\u{07FD}'..='\u{082D}'
        | '\u{0830}'..='\u{083E}'
        | '\u{0840}'..='\u{085B}'
        | '\u{085E}'
        | '\u{0860}'..='\u{086A}'
        | '\u{0870}'..='\u{088E}'
        | '\u{0890}'..='\u{0891}'
        | '\u{0898}'..='\u{0983}'
        | '\u{0985}'..='\u{098C}'
        | '\u{098F}'..='\u{0990}'
        | '\u{0993}'..='\u{09A8}'
        | '\u{09AA}'..='\u{09B0}'
        | '\u{09B2}'
        | '\u{09B6}'..='\u{09B9}'
        | '\u{09BC}'..='\u{09C4}'
        | '\u{09C7}'..='\u{09C8}'
        | '\u{09CB}'..='\u{09CE}'
        | '\u{09D7}'
        | '\u{09DC}'..='\u{09DD}'
        | '\u{09DF}'..='\u{09E3}'
        | '\u{09E6}'..='\u{09FE}'
        | '\u{0A01}'..='\u{0A03}'
        | '\u{0A05}'..='\u{0A0A}'
        | '\u{0A0F}'..='\u{0A10}'
        | '\u{0A13}'..='\u{0A28}'
        | '\u{0A2A}'..='\u{0A30}'
        | '\u{0A32}'..='\u{0A33}'
        | '\u{0A35}'..='\u{0A36}'
        | '\u{0A38}'..='\u{0A39}'
        | '\u{0A3C}'
        | '\u{0A3E}'..='\u{0A42}'
        | '\u{0A47}'..='\u{0A48}'
        | '\u{0A4B}'..='\u{0A4D}'
        | '\u{0A51}'
        | '\u{0A59}'..='\u{0A5C}'
        | '\u{0A5E}'
        | '\u{0A66}'..='\u{0A76}'
        | '\u{0A81}'..='\u{0A83}'
        | '\u{0A85}'..='\u{0A8D}'
        | '\u{0A8F}'..='\u{0A91}'
        | '\u{0A93}'..='\u{0AA8}'
        | '\u{0AAA}'..='\u{0AB0}'
        | '\u{0AB2}'..='\u{0AB3}'
        | '\u{0AB5}'..='\u{0AB9}'
        | '\u{0ABC}'..='\u{0AC5}'
        | '\u{0AC7}'..='\u{0AC9}'
        | '\u{0ACB}'..='\u{0ACD}'
        | '\u{0AD0}'
        | '\u{0AE0}'..='\u{0AE3}'
        | '\u{0AE6}'..='\u{0AF1}'
        | '\u{0AF9}'..='\u{0AFF}'
        | '\u{0B01}'..='\u{0B03}'
        | '\u{0B05}'..='\u{0B0C}'
        | '\u{0B0F}'..='\u{0B10}'
        | '\u{0B13}'..='\u{0B28}'
        | '\u{0B2A}'..='\u{0B30}'
        | '\u{0B32}'..='\u{0B33}'
        | '\u{0B35}'..='\u{0B39}'
        | '\u{0B3C}'..='\u{0B44}'
        | '\u{0B47}'..='\u{0B48}'
        | '\u{0B4B}'..='\u{0B4D}'
        | '\u{0B55}'..='\u{0B57}'
        | '\u{0B5C}'..='\u{0B5D}'
        | '\u{0B5F}'..='\u{0B63}'
        | '\u{0B66}'..='\u{0B77}'
        | '\u{0B82}'..='\u{0B83}'
        | '\u{0B85}'..='\u{0B8A}'
        | '\u{0B8E}'..='\u{0B90}'
        | '\u{0B92}'..='\u{0B95}'
        | '\u{0B99}'..='\u{0B9A}'
        | '\u{0B9C}'
        | '\u{0B9E}'..='\u{0B9F}'
        | '\u{0BA3}'..='\u{0BA4}'
        | '\u{0BA8}'..='\u{0BAA}'
        | '\u{0BAE}'..='\u{0BB9}'
        | '\u{0BBE}'..='\u{0BC2}'
        | '\u{0BC6}'..='\u{0BC8}'
        | '\u{0BCA}'..='\u{0BCD}'
        | '\u{0BD0}'
        | '\u{0BD7}'
        | '\u{0BE6}'..='\u{0BFA}'
        | '\u{0C00}'..='\u{0C0C}'
        | '\u{0C0E}'..='\u{0C10}'
        | '\u{0C12}'..='\u{0C28}'
        | '\u{0C2A}'..='\u{0C39}'
        | '\u{0C3C}'..='\u{0C44}'
        | '\u{0C46}'..='\u{0C48}'
        | '\u{0C4A}'..='\u{0C4D}'
        | '\u{0C55}'..='\u{0C56}'
        | '\u{0C58}'..='\u{0C5A}'
        | '\u{0C5D}'
        | '\u{0C60}'..='\u{0C63}'
        | '\u{0C66}'..='\u{0C6F}'
        | '\u{0C77}'..='\u{0C8C}'
        | '\u{0C8E}'..='\u{0C90}'
        | '\u{0C92}'..='\u{0CA8}'
        | '\u{0CAA}'..='\u{0CB3}'
        | '\u{0CB5}'..='\u{0CB9}'
        | '\u{0CBC}'..='\u{0CC4}'
        | '\u{0CC6}'..='\u{0CC8}'
        | '\u{0CCA}'..='\u{0CCD}'
        | '\u{0CD5}'..='\u{0CD6}'
        | '\u{0CDD}'..='\u{0CDE}'
        | '\u{0CE0}'..='\u{0CE3}'
        | '\u{0CE6}'..='\u{0CEF}'
        | '\u{0CF1}'..='\u{0CF3}'
        | '\u{0D00}'..='\u{0D0C}'
        | '\u{0D0E}'..='\u{0D10}'
        | '\u{0D12}'..='\u{0D44}'
        | '\u{0D46}'..='\u{0D48}'
        | '\u{0D4A}'..='\u{0D4F}'
        | '\u{0D54}'..='\u{0D63}'
        | '\u{0D66}'..='\u{0D7F}'
        | '\u{0D81}'..='\u{0D83}'
        | '\u{0D85}'..='\u{0D96}'
        | '\u{0D9A}'..='\u{0DB1}'
        | '\u{0DB3}'..='\u{0DBB}'
        | '\u{0DBD}'
        | '\u{0DC0}'..='\u{0DC6}'
        | '\u{0DCA}'
        | '\u{0DCF}'..='\u{0DD4}'
        | '\u{0DD6}'
        | '\u{0DD8}'..='\u{0DDF}'
        | '\u{0DE6}'..='\u{0DEF}'
        | '\u{0DF2}'..='\u{0DF4}'
        | '\u{0E01}'..='\u{0E3A}'
        | '\u{0E3F}'..='\u{0E5B}'
        | '\u{0E81}'..='\u{0E82}'
        | '\u{0E84}'
        | '\u{0E86}'..='\u{0E8A}'
        | '\u{0E8C}'..='\u{0EA3}'
        | '\u{0EA5}'
        | '\u{0EA7}'..='\u{0EBD}'
        | '\u{0EC0}'..='\u{0EC4}'
        | '\u{0EC6}'
        | '\u{0EC8}'..='\u{0ECE}'
        | '\u{0ED0}'..='\u{0ED9}'
        | '\u{0EDC}'..='\u{0EDF}'
        | '\u{0F00}'..='\u{0F47}'
        | '\u{0F49}'..='\u{0F6C}'
        | '\u{0F71}'..='\u{0F97}'
        | '\u{0F99}'..='\u{0FBC}'
        | '\u{0FBE}'..='\u{0FCC}'
        | '\u{0FCE}'..='\u{0FDA}'
        | '\u{1000}'..='\u{10C5}'
        | '\u{10C7}'
        | '\u{10CD}'
        | '\u{10D0}'..='\u{1248}'
        | '\u{124A}'..='\u{124D}'
        | '\u{1250}'..='\u{1256}'
        | '\u{1258}'
        | '\u{125A}'..='\u{125D}'
        | '\u{1260}'..='\u{1288}'
        | '\u{128A}'..='\u{128D}'
        | '\u{1290}'..='\u{12B0}'
        | '\u{12B2}'..='\u{12B5}'
        | '\u{12B8}'..='\u{12BE}'
        | '\u{12C0}'
        | '\u{12C2}'..='\u{12C5}'
        | '\u{12C8}'..='\u{12D6}'
        | '\u{12D8}'..='\u{1310}'
        | '\u{1312}'..='\u{1315}'
        | '\u{1318}'..='\u{135A}'
        | '\u{135D}'..='\u{137C}'
        | '\u{1380}'..='\u{1399}'
        | '\u{13A0}'..='\u{13F5}'
        | '\u{13F8}'..='\u{13FD}'
        | '\u{1400}'..='\u{169C}'
        | '\u{16A0}'..='\u{16F8}'
        | '\u{1700}'..='\u{1715}'
        | '\u{171F}'..='\u{1736}'
        | '\u{1740}'..='\u{1753}'
        | '\u{1760}'..='\u{176C}'
        | '\u{176E}'..='\u{1770}'
        | '\u{1772}'..='\u{1773}'
        | '\u{1780}'..='\u{17DD}'
        | '\u{17E0}'..='\u{17E9}'
        | '\u{17F0}'..='\u{17F9}'
        | '\u{1800}'..='\u{1819}'
        | '\u{1820}'..='\u{1878}'
        | '\u{1880}'..='\u{18AA}'
        | '\u{18B0}'..='\u{18F5}'
        | '\u{1900}'..='\u{191E}'
        | '\u{1920}'..='\u{192B}'
        | '\u{1930}'..='\u{193B}'
        | '\u{1940}'
        | '\u{1944}'..='\u{196D}'
        | '\u{1970}'..='\u{1974}'
        | '\u{1980}'..='\u{19AB}'
        | '\u{19B0}'..='\u{19C9}'
        | '\u{19D0}'..='\u{19DA}'
        | '\u{19DE}'..='\u{1A1B}'
        | '\u{1A1E}'..='\u{1A5E}'
        | '\u{1A60}'..='\u{1A7C}'
        | '\u{1A7F}'..='\u{1A89}'
        | '\u{1A90}'..='\u{1A99}'
        | '\u{1AA0}'..='\u{1AAD}'
        | '\u{1AB0}'..='\u{1ACE}'
        | '\u{1B00}'..='\u{1B4C}'
        | '\u{1B50}'..='\u{1B7E}'
        | '\u{1B80}'..='\u{1BF3}'
        | '\u{1BFC}'..='\u{1C37}'
        | '\u{1C3B}'..='\u{1C49}'
        | '\u{1C4D}'..='\u{1C88}'
        | '\u{1C90}'..='\u{1CBA}'
        | '\u{1CBD}'..='\u{1CC7}'
        | '\u{1CD0}'..='\u{1CFA}'
        | '\u{1D00}'..='\u{1F15}'
        | '\u{1F18}'..='\u{1F1D}'
        | '\u{1F20}'..='\u{1F45}'
        | '\u{1F48}'..='\u{1F4D}'
        | '\u{1F50}'..='\u{1F57}'
        | '\u{1F59}'
        | '\u{1F5B}'
        | '\u{1F5D}'
        | '\u{1F5F}'..='\u{1F7D}'
        | '\u{1F80}'..='\u{1FB4}'
        | '\u{1FB6}'..='\u{1FC4}'
        | '\u{1FC6}'..='\u{1FD3}'
        | '\u{1FD6}'..='\u{1FDB}'
        | '\u{1FDD}'..='\u{1FEF}'
        | '\u{1FF2}'..='\u{1FF4}'
        | '\u{1FF6}'..='\u{1FFE}'
        | '\u{2000}'..='\u{2064}'
        | '\u{2066}'..='\u{2071}'
        | '\u{2074}'..='\u{208E}'
        | '\u{2090}'..='\u{209C}'
        | '\u{20A0}'..='\u{20C0}'
        | '\u{20D0}'..='\u{20F0}'
        | '\u{2100}'..='\u{218B}'
        | '\u{2190}'..='\u{2426}'
        | '\u{2440}'..='\u{244A}'
        | '\u{2460}'..='\u{2B73}'
        | '\u{2B76}'..='\u{2B95}'
        | '\u{2B97}'..='\u{2CF3}'
        | '\u{2CF9}'..='\u{2D25}'
        | '\u{2D27}'
        | '\u{2D2D}'
        | '\u{2D30}'..='\u{2D67}'
        | '\u{2D6F}'..='\u{2D70}'
        | '\u{2D7F}'..='\u{2D96}'
        | '\u{2DA0}'..='\u{2DA6}'
        | '\u{2DA8}'..='\u{2DAE}'
        | '\u{2DB0}'..='\u{2DB6}'
        | '\u{2DB8}'..='\u{2DBE}'
        | '\u{2DC0}'..='\u{2DC6}'
        | '\u{2DC8}'..='\u{2DCE}'
        | '\u{2DD0}'..='\u{2DD6}'
        | '\u{2DD8}'..='\u{2DDE}'
        | '\u{2DE0}'..='\u{2E5D}'
        | '\u{2E80}'..='\u{2E99}'
        | '\u{2E9B}'..='\u{2EF3}'
        | '\u{2F00}'..='\u{2FD5}'
        | '\u{2FF0}'..='\u{2FFB}'
        | '\u{3000}'..='\u{303F}'
        | '\u{3041}'..='\u{3096}'
        | '\u{3099}'..='\u{30FF}'
        | '\u{3105}'..='\u{312F}'
        | '\u{3131}'..='\u{318E}'
        | '\u{3190}'..='\u{31E3}'
        | '\u{31F0}'..='\u{321E}'
        | '\u{3220}'..='\u{A48C}'
        | '\u{A490}'..='\u{A4C6}'
        | '\u{A4D0}'..='\u{A62B}'
        | '\u{A640}'..='\u{A6F7}'
        | '\u{A700}'..='\u{A7CA}'
        | '\u{A7D0}'..='\u{A7D1}'
        | '\u{A7D3}'
        | '\u{A7D5}'..='\u{A7D9}'
        | '\u{A7F2}'..='\u{A82C}'
        | '\u{A830}'..='\u{A839}'
        | '\u{A840}'..='\u{A877}'
        | '\u{A880}'..='\u{A8C5}'
        | '\u{A8CE}'..='\u{A8D9}'
        | '\u{A8E0}'..='\u{A953}'
        | '\u{A95F}'..='\u{A97C}'
        | '\u{A980}'..='\u{A9CD}'
        | '\u{A9CF}'..='\u{A9D9}'
        | '\u{A9DE}'..='\u{A9FE}'
        | '\u{AA00}'..='\u{AA36}'
        | '\u{AA40}'..='\u{AA4D}'
        | '\u{AA50}'..='\u{AA59}'
        | '\u{AA5C}'..='\u{AAC2}'
        | '\u{AADB}'..='\u{AAF6}'
        | '\u{AB01}'..='\u{AB06}'
        | '\u{AB09}'..='\u{AB0E}'
        | '\u{AB11}'..='\u{AB16}'
        | '\u{AB20}'..='\u{AB26}'
        | '\u{AB28}'..='\u{AB2E}'
        | '\u{AB30}'..='\u{AB6B}'
        | '\u{AB70}'..='\u{ABED}'
        | '\u{ABF0}'..='\u{ABF9}'
        | '\u{AC00}'..='\u{D7A3}'
        | '\u{D7B0}'..='\u{D7C6}'
        | '\u{D7CB}'..='\u{D7FB}'
        | '\u{F900}'..='\u{FA6D}'
        | '\u{FA70}'..='\u{FAD9}'
        | '\u{FB00}'..='\u{FB06}'
        | '\u{FB13}'..='\u{FB17}'
        | '\u{FB1D}'..='\u{FB36}'
        | '\u{FB38}'..='\u{FB3C}'
        | '\u{FB3E}'
        | '\u{FB40}'..='\u{FB41}'
        | '\u{FB43}'..='\u{FB44}'
        | '\u{FB46}'..='\u{FBC2}'
        | '\u{FBD3}'..='\u{FD8F}'
        | '\u{FD92}'..='\u{FDC7}'
        | '\u{FDCF}'
        | '\u{FDF0}'..='\u{FE19}'
        | '\u{FE20}'..='\u{FE52}'
        | '\u{FE54}'..='\u{FE66}'
        | '\u{FE68}'..='\u{FE6B}'
        | '\u{FE70}'..='\u{FE74}'
        | '\u{FE76}'..='\u{FEFC}'
        | '\u{FEFF}'
        | '\u{FF01}'..='\u{FFBE}'
        | '\u{FFC2}'..='\u{FFC7}'
        | '\u{FFCA}'..='\u{FFCF}'
        | '\u{FFD2}'..='\u{FFD7}'
        | '\u{FFDA}'..='\u{FFDC}'
        | '\u{FFE0}'..='\u{FFE6}'
        | '\u{FFE8}'..='\u{FFEE}'
        | '\u{FFF9}'..='\u{FFFD}'
        | '\u{10000}'..='\u{1000B}'
        | '\u{1000D}'..='\u{10026}'
        | '\u{10028}'..='\u{1003A}'
        | '\u{1003C}'..='\u{1003D}'
        | '\u{1003F}'..='\u{1004D}'
        | '\u{10050}'..='\u{1005D}'
        | '\u{10080}'..='\u{100FA}'
        | '\u{10100}'..='\u{10102}'
        | '\u{10107}'..='\u{10133}'
        | '\u{10137}'..='\u{1018E}'
        | '\u{10190}'..='\u{1019C}'
        | '\u{101A0}'
        | '\u{101D0}'..='\u{101FD}'
        | '\u{10280}'..='\u{1029C}'
        | '\u{102A0}'..='\u{102D0}'
        | '\u{102E0}'..='\u{102FB}'
        | '\u{10300}'..='\u{10323}'
        | '\u{1032D}'..='\u{1034A}'
        | '\u{10350}'..='\u{1037A}'
        | '\u{10380}'..='\u{1039D}'
        | '\u{1039F}'..='\u{103C3}'
        | '\u{103C8}'..='\u{103D5}'
        | '\u{10400}'..='\u{1049D}'
        | '\u{104A0}'..='\u{104A9}'
        | '\u{104B0}'..='\u{104D3}'
        | '\u{104D8}'..='\u{104FB}'
        | '\u{10500}'..='\u{10527}'
        | '\u{10530}'..='\u{10563}'
        | '\u{1056F}'..='\u{1057A}'
        | '\u{1057C}'..='\u{1058A}'
        | '\u{1058C}'..='\u{10592}'
        | '\u{10594}'..='\u{10595}'
        | '\u{10597}'..='\u{105A1}'
        | '\u{105A3}'..='\u{105B1}'
        | '\u{105B3}'..='\u{105B9}'
        | '\u{105BB}'..='\u{105BC}'
        | '\u{10600}'..='\u{10736}'
        | '\u{10740}'..='\u{10755}'
        | '\u{10760}'..='\u{10767}'
        | '\u{10780}'..='\u{10785}'
        | '\u{10787}'..='\u{107B0}'
        | '\u{107B2}'..='\u{107BA}'
        | '\u{10800}'..='\u{10805}'
        | '\u{10808}'
        | '\u{1080A}'..='\u{10835}'
        | '\u{10837}'..='\u{10838}'
        | '\u{1083C}'
        | '\u{1083F}'..='\u{10855}'
        | '\u{10857}'..='\u{1089E}'
        | '\u{108A7}'..='\u{108AF}'
        | '\u{108E0}'..='\u{108F2}'
        | '\u{108F4}'..='\u{108F5}'
        | '\u{108FB}'..='\u{1091B}'
        | '\u{1091F}'..='\u{10939}'
        | '\u{1093F}'
        | '\u{10980}'..='\u{109B7}'
        | '\u{109BC}'..='\u{109CF}'
        | '\u{109D2}'..='\u{10A03}'
        | '\u{10A05}'..='\u{10A06}'
        | '\u{10A0C}'..='\u{10A13}'
        | '\u{10A15}'..='\u{10A17}'
        | '\u{10A19}'..='\u{10A35}'
        | '\u{10A38}'..='\u{10A3A}'
        | '\u{10A3F}'..='\u{10A48}'
        | '\u{10A50}'..='\u{10A58}'
        | '\u{10A60}'..='\u{10A9F}'
        | '\u{10AC0}'..='\u{10AE6}'
        | '\u{10AEB}'..='\u{10AF6}'
        | '\u{10B00}'..='\u{10B35}'
        | '\u{10B39}'..='\u{10B55}'
        | '\u{10B58}'..='\u{10B72}'
        | '\u{10B78}'..='\u{10B91}'
        | '\u{10B99}'..='\u{10B9C}'
        | '\u{10BA9}'..='\u{10BAF}'
        | '\u{10C00}'..='\u{10C48}'
        | '\u{10C80}'..='\u{10CB2}'
        | '\u{10CC0}'..='\u{10CF2}'
        | '\u{10CFA}'..='\u{10D27}'
        | '\u{10D30}'..='\u{10D39}'
        | '\u{10E60}'..='\u{10E7E}'
        | '\u{10E80}'..='\u{10EA9}'
        | '\u{10EAB}'..='\u{10EAD}'
        | '\u{10EB0}'..='\u{10EB1}'
        | '\u{10EFD}'..='\u{10F27}'
        | '\u{10F30}'..='\u{10F59}'
        | '\u{10F70}'..='\u{10F89}'
        | '\u{10FB0}'..='\u{10FCB}'
        | '\u{10FE0}'..='\u{10FF6}'
        | '\u{11000}'..='\u{1104D}'
        | '\u{11052}'..='\u{11075}'
        | '\u{1107F}'..='\u{110C2}'
        | '\u{110CD}'
        | '\u{110D0}'..='\u{110E8}'
        | '\u{110F0}'..='\u{110F9}'
        | '\u{11100}'..='\u{11134}'
        | '\u{11136}'..='\u{11147}'
        | '\u{11150}'..='\u{11176}'
        | '\u{11180}'..='\u{111DF}'
        | '\u{111E1}'..='\u{111F4}'
        | '\u{11200}'..='\u{11211}'
        | '\u{11213}'..='\u{11241}'
        | '\u{11280}'..='\u{11286}'
        | '\u{11288}'
        | '\u{1128A}'..='\u{1128D}'
        | '\u{1128F}'..='\u{1129D}'
        | '\u{1129F}'..='\u{112A9}'
        | '\u{112B0}'..='\u{112EA}'
        | '\u{112F0}'..='\u{112F9}'
        | '\u{11300}'..='\u{11303}'
        | '\u{11305}'..='\u{1130C}'
        | '\u{1130F}'..='\u{11310}'
        | '\u{11313}'..='\u{11328}'
        | '\u{1132A}'..='\u{11330}'
        | '\u{11332}'..='\u{11333}'
        | '\u{11335}'..='\u{11339}'
        | '\u{1133B}'..='\u{11344}'
        | '\u{11347}'..='\u{11348}'
        | '\u{1134B}'..='\u{1134D}'
        | '\u{11350}'
        | '\u{11357}'
        | '\u{1135D}'..='\u{11363}'
        | '\u{11366}'..='\u{1136C}'
        | '\u{11370}'..='\u{11374}'
        | '\u{11400}'..='\u{1145B}'
        | '\u{1145D}'..='\u{11461}'
        | '\u{11480}'..='\u{114C7}'
        | '\u{114D0}'..='\u{114D9}'
        | '\u{11580}'..='\u{115B5}'
        | '\u{115B8}'..='\u{115DD}'
        | '\u{11600}'..='\u{11644}'
        | '\u{11650}'..='\u{11659}'
        | '\u{11660}'..='\u{1166C}'
        | '\u{11680}'..='\u{116B9}'
        | '\u{116C0}'..='\u{116C9}'
        | '\u{11700}'..='\u{1171A}'
        | '\u{1171D}'..='\u{1172B}'
        | '\u{11730}'..='\u{11746}'
        | '\u{11800}'..='\u{1183B}'
        | '\u{118A0}'..='\u{118F2}'
        | '\u{118FF}'..='\u{11906}'
        | '\u{11909}'
        | '\u{1190C}'..='\u{11913}'
        | '\u{11915}'..='\u{11916}'
        | '\u{11918}'..='\u{11935}'
        | '\u{11937}'..='\u{11938}'
        | '\u{1193B}'..='\u{11946}'
        | '\u{11950}'..='\u{11959}'
        | '\u{119A0}'..='\u{119A7}'
        | '\u{119AA}'..='\u{119D7}'
        | '\u{119DA}'..='\u{119E4}'
        | '\u{11A00}'..='\u{11A47}'
        | '\u{11A50}'..='\u{11AA2}'
        | '\u{11AB0}'..='\u{11AF8}'
        | '\u{11B00}'..='\u{11B09}'
        | '\u{11C00}'..='\u{11C08}'
        | '\u{11C0A}'..='\u{11C36}'
        | '\u{11C38}'..='\u{11C45}'
        | '\u{11C50}'..='\u{11C6C}'
        | '\u{11C70}'..='\u{11C8F}'
        | '\u{11C92}'..='\u{11CA7}'
        | '\u{11CA9}'..='\u{11CB6}'
        | '\u{11D00}'..='\u{11D06}'
        | '\u{11D08}'..='\u{11D09}'
        | '\u{11D0B}'..='\u{11D36}'
        | '\u{11D3A}'
        | '\u{11D3C}'..='\u{11D3D}'
        | '\u{11D3F}'..='\u{11D47}'
        | '\u{11D50}'..='\u{11D59}'
        | '\u{11D60}'..='\u{11D65}'
        | '\u{11D67}'..='\u{11D68}'
        | '\u{11D6A}'..='\u{11D8E}'
        | '\u{11D90}'..='\u{11D91}'
        | '\u{11D93}'..='\u{11D98}'
        | '\u{11DA0}'..='\u{11DA9}'
        | '\u{11EE0}'..='\u{11EF8}'
        | '\u{11F00}'..='\u{11F10}'
        | '\u{11F12}'..='\u{11F3A}'
        | '\u{11F3E}'..='\u{11F59}'
        | '\u{11FB0}'
        | '\u{11FC0}'..='\u{11FF1}'
        | '\u{11FFF}'..='\u{12399}'
        | '\u{12400}'..='\u{1246E}'
        | '\u{12470}'..='\u{12474}'
        | '\u{12480}'..='\u{12543}'
        | '\u{12F90}'..='\u{12FF2}'
        | '\u{13000}'..='\u{13455}'
        | '\u{14400}'..='\u{14646}'
        | '\u{16800}'..='\u{16A38}'
        | '\u{16A40}'..='\u{16A5E}'
        | '\u{16A60}'..='\u{16A69}'
        | '\u{16A6E}'..='\u{16ABE}'
        | '\u{16AC0}'..='\u{16AC9}'
        | '\u{16AD0}'..='\u{16AED}'
        | '\u{16AF0}'..='\u{16AF5}'
        | '\u{16B00}'..='\u{16B45}'
        | '\u{16B50}'..='\u{16B59}'
        | '\u{16B5B}'..='\u{16B61}'
        | '\u{16B63}'..='\u{16B77}'
        | '\u{16B7D}'..='\u{16B8F}'
        | '\u{16E40}'..='\u{16E9A}'
        | '\u{16F00}'..='\u{16F4A}'
        | '\u{16F4F}'..='\u{16F87}'
        | '\u{16F8F}'..='\u{16F9F}'
        | '\u{16FE0}'..='\u{16FE4}'
        | '\u{16FF0}'..='\u{16FF1}'
        | '\u{17000}'..='\u{187F7}'
        | '\u{18800}'..='\u{18CD5}'
        | '\u{18D00}'..='\u{18D08}'
        | '\u{1AFF0}'..='\u{1AFF3}'
        | '\u{1AFF5}'..='\u{1AFFB}'
        | '\u{1AFFD}'..='\u{1AFFE}'
        | '\u{1B000}'..='\u{1B122}'
        | '\u{1B132}'
        | '\u{1B150}'..='\u{1B152}'
        | '\u{1B155}'
        | '\u{1B164}'..='\u{1B167}'
        | '\u{1B170}'..='\u{1B2FB}'
        | '\u{1BC00}'..='\u{1BC6A}'
        | '\u{1BC70}'..='\u{1BC7C}'
        | '\u{1BC80}'..='\u{1BC88}'
        | '\u{1BC90}'..='\u{1BC99}'
        | '\u{1BC9C}'..='\u{1BCA3}'
        | '\u{1CF00}'..='\u{1CF2D}'
        | '\u{1CF30}'..='\u{1CF46}'
        | '\u{1CF50}'..='\u{1CFC3}'
        | '\u{1D000}'..='\u{1D0F5}'
        | '\u{1D100}'..='\u{1D126}'
        | '\u{1D129}'..='\u{1D1EA}'
        | '\u{1D200}'..='\u{1D245}'
        | '\u{1D2C0}'..='\u{1D2D3}'
        | '\u{1D2E0}'..='\u{1D2F3}'
        | '\u{1D300}'..='\u{1D356}'
        | '\u{1D360}'..='\u{1D378}'
        | '\u{1D400}'..='\u{1D454}'
        | '\u{1D456}'..='\u{1D49C}'
        | '\u{1D49E}'..='\u{1D49F}'
        | '\u{1D4A2}'
        | '\u{1D4A5}'..='\u{1D4A6}'
        | '\u{1D4A9}'..='\u{1D4AC}'
        | '\u{1D4AE}'..='\u{1D4B9}'
        | '\u{1D4BB}'
        | '\u{1D4BD}'..='\u{1D4C3}'
        | '\u{1D4C5}'..='\u{1D505}'
        | '\u{1D507}'..='\u{1D50A}'
        | '\u{1D50D}'..='\u{1D514}'
        | '\u{1D516}'..='\u{1D51C}'
        | '\u{1D51E}'..='\u{1D539}'
        | '\u{1D53B}'..='\u{1D53E}'
        | '\u{1D540}'..='\u{1D544}'
        | '\u{1D546}'
        | '\u{1D54A}'..='\u{1D550}'
        | '\u{1D552}'..='\u{1D6A5}'
        | '\u{1D6A8}'..='\u{1D7CB}'
        | '\u{1D7CE}'..='\u{1DA8B}'
        | '\u{1DA9B}'..='\u{1DA9F}'
        | '\u{1DAA1}'..='\u{1DAAF}'
        | '\u{1DF00}'..='\u{1DF1E}'
        | '\u{1DF25}'..='\u{1DF2A}'
        | '\u{1E000}'..='\u{1E006}'
        | '\u{1E008}'..='\u{1E018}'
        | '\u{1E01B}'..='\u{1E021}'
        | '\u{1E023}'..='\u{1E024}'
        | '\u{1E026}'..='\u{1E02A}'
        | '\u{1E030}'..='\u{1E06D}'
        | '\u{1E08F}'
        | '\u{1E100}'..='\u{1E12C}'
        | '\u{1E130}'..='\u{1E13D}'
        | '\u{1E140}'..='\u{1E149}'
        | '\u{1E14E}'..='\u{1E14F}'
        | '\u{1E290}'..='\u{1E2AE}'
        | '\u{1E2C0}'..='\u{1E2F9}'
        | '\u{1E2FF}'
        | '\u{1E4D0}'..='\u{1E4F9}'
        | '\u{1E7E0}'..='\u{1E7E6}'
        | '\u{1E7E8}'..='\u{1E7EB}'
        | '\u{1E7ED}'..='\u{1E7EE}'
        | '\u{1E7F0}'..='\u{1E7FE}'
        | '\u{1E800}'..='\u{1E8C4}'
        | '\u{1E8C7}'..='\u{1E8D6}'
        | '\u{1E900}'..='\u{1E94B}'
        | '\u{1E950}'..='\u{1E959}'
        | '\u{1E95E}'..='\u{1E95F}'
        | '\u{1EC71}'..='\u{1ECB4}'
        | '\u{1ED01}'..='\u{1ED3D}'
        | '\u{1EE00}'..='\u{1EE03}'
        | '\u{1EE05}'..='\u{1EE1F}'
        | '\u{1EE21}'..='\u{1EE22}'
        | '\u{1EE24}'
        | '\u{1EE27}'
        | '\u{1EE29}'..='\u{1EE32}'
        | '\u{1EE34}'..='\u{1EE37}'
        | '\u{1EE39}'
        | '\u{1EE3B}'
        | '\u{1EE42}'
        | '\u{1EE47}'
        | '\u{1EE49}'
        | '\u{1EE4B}'
        | '\u{1EE4D}'..='\u{1EE4F}'
        | '\u{1EE51}'..='\u{1EE52}'
        | '\u{1EE54}'
        | '\u{1EE57}'
        | '\u{1EE59}'
        | '\u{1EE5B}'
        | '\u{1EE5D}'
        | '\u{1EE5F}'
        | '\u{1EE61}'..='\u{1EE62}'
        | '\u{1EE64}'
        | '\u{1EE67}'..='\u{1EE6A}'
        | '\u{1EE6C}'..='\u{1EE72}'
        | '\u{1EE74}'..='\u{1EE77}'
        | '\u{1EE79}'..='\u{1EE7C}'
        | '\u{1EE7E}'
        | '\u{1EE80}'..='\u{1EE89}'
        | '\u{1EE8B}'..='\u{1EE9B}'
        | '\u{1EEA1}'..='\u{1EEA3}'
        | '\u{1EEA5}'..='\u{1EEA9}'
        | '\u{1EEAB}'..='\u{1EEBB}'
        | '\u{1EEF0}'..='\u{1EEF1}'
        | '\u{1F000}'..='\u{1F02B}'
        | '\u{1F030}'..='\u{1F093}'
        | '\u{1F0A0}'..='\u{1F0AE}'
        | '\u{1F0B1}'..='\u{1F0BF}'
        | '\u{1F0C1}'..='\u{1F0CF}'
        | '\u{1F0D1}'..='\u{1F0F5}'
        | '\u{1F100}'..='\u{1F1AD}'
        | '\u{1F1E6}'..='\u{1F202}'
        | '\u{1F210}'..='\u{1F23B}'
        | '\u{1F240}'..='\u{1F248}'
        | '\u{1F250}'..='\u{1F251}'
        | '\u{1F260}'..='\u{1F265}'
        | '\u{1F300}'..='\u{1F6D7}'
        | '\u{1F6DC}'..='\u{1F6EC}'
        | '\u{1F6F0}'..='\u{1F6FC}'
        | '\u{1F700}'..='\u{1F776}'
        | '\u{1F77B}'..='\u{1F7D9}'
        | '\u{1F7E0}'..='\u{1F7EB}'
        | '\u{1F7F0}'
        | '\u{1F800}'..='\u{1F80B}'
        | '\u{1F810}'..='\u{1F847}'
        | '\u{1F850}'..='\u{1F859}'
        | '\u{1F860}'..='\u{1F887}'
        | '\u{1F890}'..='\u{1F8AD}'
        | '\u{1F8B0}'..='\u{1F8B1}'
        | '\u{1F900}'..='\u{1FA53}'
        | '\u{1FA60}'..='\u{1FA6D}'
        | '\u{1FA70}'..='\u{1FA7C}'
        | '\u{1FA80}'..='\u{1FA88}'
        | '\u{1FA90}'..='\u{1FABD}'
        | '\u{1FABF}'..='\u{1FAC5}'
        | '\u{1FACE}'..='\u{1FADB}'
        | '\u{1FAE0}'..='\u{1FAE8}'
        | '\u{1FAF0}'..='\u{1FAF8}'
        | '\u{1FB00}'..='\u{1FB92}'
        | '\u{1FB94}'..='\u{1FBCA}'
        | '\u{1FBF0}'..='\u{1FBF9}'
        | '\u{20000}'..='\u{2A6DF}'
        | '\u{2A700}'..='\u{2B739}'
        | '\u{2B740}'..='\u{2B81D}'
        | '\u{2B820}'..='\u{2CEA1}'
        | '\u{2CEB0}'..='\u{2EBE0}'
        | '\u{2F800}'..='\u{2FA1D}'
        | '\u{30000}'..='\u{3134A}'
        | '\u{31350}'..='\u{323AF}'
        | '\u{E0001}'
        | '\u{E0020}'..='\u{E007F}'
        | '\u{E0100}'..='\u{E01EF}'
        => true,
        _ => false,
    }
}


#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfc(c: char) -> IsNormalized {
    match c {
        '\u{0340}'...'\u{0341}' => No,
        '\u{0343}'...'\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037E}' => No,
        '\u{0387}' => No,
        '\u{0958}'...'\u{095F}' => No,
        '\u{09DC}'...'\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'...'\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B5C}'...'\u{0B5D}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'...'\u{0F76}' => No,
        '\u{0F78}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1F71}' => No,
        '\u{1F73}' => No,
        '\u{1F75}' => No,
        '\u{1F77}' => No,
        '\u{1F79}' => No,
        '\u{1F7B}' => No,
        '\u{1F7D}' => No,
        '\u{1FBB}' => No,
        '\u{1FBE}' => No,
        '\u{1FC9}' => No,
        '\u{1FCB}' => No,
        '\u{1FD3}' => No,
        '\u{1FDB}' => No,
        '\u{1FE3}' => No,
        '\u{1FEB}' => No,
        '\u{1FEE}'...'\u{1FEF}' => No,
        '\u{1FF9}' => No,
        '\u{1FFB}' => No,
        '\u{1FFD}' => No,
        '\u{2000}'...'\u{2001}' => No,
        '\u{2126}' => No,
        '\u{212A}'...'\u{212B}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2ADC}' => No,
        '\u{F900}'...'\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'...'\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'...'\u{FA26}' => No,
        '\u{FA2A}'...'\u{FA6D}' => No,
        '\u{FA70}'...'\u{FAD9}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}' => No,
        '\u{FB2A}'...'\u{FB36}' => No,
        '\u{FB38}'...'\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'...'\u{FB41}' => No,
        '\u{FB43}'...'\u{FB44}' => No,
        '\u{FB46}'...'\u{FB4E}' => No,
        '\u{1D15E}'...'\u{1D164}' => No,
        '\u{1D1BB}'...'\u{1D1C0}' => No,
        '\u{2F800}'...'\u{2FA1D}' => No,
        '\u{0300}'...'\u{0304}' => Maybe,
        '\u{0306}'...'\u{030C}' => Maybe,
        '\u{030F}' => Maybe,
        '\u{0311}' => Maybe,
        '\u{0313}'...'\u{0314}' => Maybe,
        '\u{031B}' => Maybe,
        '\u{0323}'...'\u{0328}' => Maybe,
        '\u{032D}'...'\u{032E}' => Maybe,
        '\u{0330}'...'\u{0331}' => Maybe,
        '\u{0338}' => Maybe,
        '\u{0342}' => Maybe,
        '\u{0345}' => Maybe,
        '\u{0653}'...'\u{0655}' => Maybe,
        '\u{093C}' => Maybe,
        '\u{09BE}' => Maybe,
        '\u{09D7}' => Maybe,
        '\u{0B3E}' => Maybe,
        '\u{0B56}' => Maybe,
        '\u{0B57}' => Maybe,
        '\u{0BBE}' => Maybe,
        '\u{0BD7}' => Maybe,
        '\u{0C56}' => Maybe,
        '\u{0CC2}' => Maybe,
        '\u{0CD5}'...'\u{0CD6}' => Maybe,
        '\u{0D3E}' => Maybe,
        '\u{0D57}' => Maybe,
        '\u{0DCA}' => Maybe,
        '\u{0DCF}' => Maybe,
        '\u{0DDF}' => Maybe,
        '\u{102E}' => Maybe,
        '\u{1161}'...'\u{1175}' => Maybe,
        '\u{11A8}'...'\u{11C2}' => Maybe,
        '\u{1B35}' => Maybe,
        '\u{3099}'...'\u{309A}' => Maybe,
        '\u{110BA}' => Maybe,
        '\u{11127}' => Maybe,
        '\u{1133E}' => Maybe,
        '\u{11357}' => Maybe,
        '\u{114B0}' => Maybe,
        '\u{114BA}' => Maybe,
        '\u{114BD}' => Maybe,
        '\u{115AF}' => Maybe,
        '\u{11930}' => Maybe,
        _ => Yes,
    }
}

#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfkc(c: char) -> IsNormalized {
    match c {
        '\u{00A0}' => No,
        '\u{00A8}' => No,
        '\u{00AA}' => No,
        '\u{00AF}' => No,
        '\u{00B2}'...'\u{00B3}' => No,
        '\u{00B4}' => No,
        '\u{00B5}' => No,
        '\u{00B8}' => No,
        '\u{00B9}' => No,
        '\u{00BA}' => No,
        '\u{00BC}'...'\u{00BE}' => No,
        '\u{0132}'...'\u{0133}' => No,
        '\u{013F}'...'\u{0140}' => No,
        '\u{0149}' => No,
        '\u{017F}' => No,
        '\u{01C4}'...'\u{01CC}' => No,
        '\u{01F1}'...'\u{01F3}' => No,
        '\u{02B0}'...'\u{02B8}' => No,
        '\u{02D8}'...'\u{02DD}' => No,
        '\u{02E0}'...'\u{02E4}' => No,
        '\u{0340}'...'\u{0341}' => No,
        '\u{0343}'...'\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037A}' => No,
        '\u{037E}' => No,
        '\u{0384}'...'\u{0385}' => No,
        '\u{0387}' => No,
        '\u{03D0}'...'\u{03D6}' => No,
        '\u{03F0}'...'\u{03F2}' => No,
        '\u{03F4}'...'\u{03F5}' => No,
        '\u{03F9}' => No,
        '\u{0587}' => No,
        '\u{0675}'...'\u{0678}' => No,
        '\u{0958}'...'\u{095F}' => No,
        '\u{09DC}'...'\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'...'\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B5C}'...'\u{0B5D}' => No,
        '\u{0E33}' => No,
        '\u{0EB3}' => No,
        '\u{0EDC}'...'\u{0EDD}' => No,
        '\u{0F0C}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'...'\u{0F79}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{10FC}' => No,
        '\u{1D2C}'...'\u{1D2E}' => No,
        '\u{1D30}'...'\u{1D3A}' => No,
        '\u{1D3C}'...'\u{1D4D}' => No,
        '\u{1D4F}'...'\u{1D6A}' => No,
        '\u{1D78}' => No,
        '\u{1D9B}'...'\u{1DBF}' => No,
        '\u{1E9A}'...'\u{1E9B}' => No,
        '\u{1F71}' => No,
        '\u{1F73}' => No,
        '\u{1F75}' => No,
        '\u{1F77}' => No,
        '\u{1F79}' => No,
        '\u{1F7B}' => No,
        '\u{1F7D}' => No,
        '\u{1FBB}' => No,
        '\u{1FBD}' => No,
        '\u{1FBE}' => No,
        '\u{1FBF}'...'\u{1FC1}' => No,
        '\u{1FC9}' => No,
        '\u{1FCB}' => No,
        '\u{1FCD}'...'\u{1FCF}' => No,
        '\u{1FD3}' => No,
        '\u{1FDB}' => No,
        '\u{1FDD}'...'\u{1FDF}' => No,
        '\u{1FE3}' => No,
        '\u{1FEB}' => No,
        '\u{1FED}'...'\u{1FEF}' => No,
        '\u{1FF9}' => No,
        '\u{1FFB}' => No,
        '\u{1FFD}'...'\u{1FFE}' => No,
        '\u{2000}'...'\u{200A}' => No,
        '\u{2011}' => No,
        '\u{2017}' => No,
        '\u{2024}'...'\u{2026}' => No,
        '\u{202F}' => No,
        '\u{2033}'...'\u{2034}' => No,
        '\u{2036}'...'\u{2037}' => No,
        '\u{203C}' => No,
        '\u{203E}' => No,
        '\u{2047}'...'\u{2049}' => No,
        '\u{2057}' => No,
        '\u{205F}' => No,
        '\u{2070}' => No,
        '\u{2071}' => No,
        '\u{2074}'...'\u{2079}' => No,
        '\u{207A}'...'\u{207C}' => No,
        '\u{207D}' => No,
        '\u{207E}' => No,
        '\u{207F}' => No,
        '\u{2080}'...'\u{2089}' => No,
        '\u{208A}'...'\u{208C}' => No,
        '\u{208D}' => No,
        '\u{208E}' => No,
        '\u{2090}'...'\u{209C}' => No,
        '\u{20A8}' => No,
        '\u{2100}'...'\u{2101}' => No,
        '\u{2102}' => No,
        '\u{2103}' => No,
        '\u{2105}'...'\u{2106}' => No,
        '\u{2107}' => No,
        '\u{2109}' => No,
        '\u{210A}'...'\u{2113}' => No,
        '\u{2115}' => No,
        '\u{2116}' => No,
        '\u{2119}'...'\u{211D}' => No,
        '\u{2120}'...'\u{2122}' => No,
        '\u{2124}' => No,
        '\u{2126}' => No,
        '\u{2128}' => No,
        '\u{212A}'...'\u{212D}' => No,
        '\u{212F}'...'\u{2131}' => No,
        '\u{2133}'...'\u{2134}' => No,
        '\u{2135}'...'\u{2138}' => No,
        '\u{2139}' => No,
        '\u{213B}' => No,
        '\u{213C}'...'\u{213F}' => No,
        '\u{2140}' => No,
        '\u{2145}'...'\u{2149}' => No,
        '\u{2150}'...'\u{215F}' => No,
        '\u{2160}'...'\u{217F}' => No,
        '\u{2189}' => No,
        '\u{222C}'...'\u{222D}' => No,
        '\u{222F}'...'\u{2230}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2460}'...'\u{249B}' => No,
        '\u{249C}'...'\u{24E9}' => No,
        '\u{24EA}' => No,
        '\u{2A0C}' => No,
        '\u{2A74}'...'\u{2A76}' => No,
        '\u{2ADC}' => No,
        '\u{2C7C}'...'\u{2C7D}' => No,
        '\u{2D6F}' => No,
        '\u{2E9F}' => No,
        '\u{2EF3}' => No,
        '\u{2F00}'...'\u{2FD5}' => No,
        '\u{3000}' => No,
        '\u{3036}' => No,
        '\u{3038}'...'\u{303A}' => No,
        '\u{309B}'...'\u{309C}' => No,
        '\u{309F}' => No,
        '\u{30FF}' => No,
        '\u{3131}'...'\u{318E}' => No,
        '\u{3192}'...'\u{3195}' => No,
        '\u{3196}'...'\u{319F}' => No,
        '\u{3200}'...'\u{321E}' => No,
        '\u{3220}'...'\u{3229}' => No,
        '\u{322A}'...'\u{3247}' => No,
        '\u{3250}' => No,
        '\u{3251}'...'\u{325F}' => No,
        '\u{3260}'...'\u{327E}' => No,
        '\u{3280}'...'\u{3289}' => No,
        '\u{328A}'...'\u{32B0}' => No,
        '\u{32B1}'...'\u{32BF}' => No,
        '\u{32C0}'...'\u{33FF}' => No,
        '\u{A69C}'...'\u{A69D}' => No,
        '\u{A770}' => No,
        '\u{A7F2}'...'\u{A7F4}' => No,
        '\u{A7F8}'...'\u{A7F9}' => No,
        '\u{AB5C}'...'\u{AB5F}' => No,
        '\u{AB69}' => No,
        '\u{F900}'...'\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'...'\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'...'\u{FA26}' => No,
        '\u{FA2A}'...'\u{FA6D}' => No,
        '\u{FA70}'...'\u{FAD9}' => No,
        '\u{FB00}'...'\u{FB06}' => No,
        '\u{FB13}'...'\u{FB17}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}'...'\u{FB28}' => No,
        '\u{FB29}' => No,
        '\u{FB2A}'...'\u{FB36}' => No,
        '\u{FB38}'...'\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'...'\u{FB41}' => No,
        '\u{FB43}'...'\u{FB44}' => No,
        '\u{FB46}'...'\u{FBB1}' => No,
        '\u{FBD3}'...'\u{FD3D}' => No,
        '\u{FD50}'...'\u{FD8F}' => No,
        '\u{FD92}'...'\u{FDC7}' => No,
        '\u{FDF0}'...'\u{FDFB}' => No,
        '\u{FDFC}' => No,
        '\u{FE10}'...'\u{FE16}' => No,
        '\u{FE17}' => No,
        '\u{FE18}' => No,
        '\u{FE19}' => No,
        '\u{FE30}' => No,
        '\u{FE31}'...'\u{FE32}' => No,
        '\u{FE33}'...'\u{FE34}' => No,
        '\u{FE35}' => No,
        '\u{FE36}' => No,
        '\u{FE37}' => No,
        '\u{FE38}' => No,
        '\u{FE39}' => No,
        '\u{FE3A}' => No,
        '\u{FE3B}' => No,
        '\u{FE3C}' => No,
        '\u{FE3D}' => No,
        '\u{FE3E}' => No,
        '\u{FE3F}' => No,
        '\u{FE40}' => No,
        '\u{FE41}' => No,
        '\u{FE42}' => No,
        '\u{FE43}' => No,
        '\u{FE44}' => No,
        '\u{FE47}' => No,
        '\u{FE48}' => No,
        '\u{FE49}'...'\u{FE4C}' => No,
        '\u{FE4D}'...'\u{FE4F}' => No,
        '\u{FE50}'...'\u{FE52}' => No,
        '\u{FE54}'...'\u{FE57}' => No,
        '\u{FE58}' => No,
        '\u{FE59}' => No,
        '\u{FE5A}' => No,
        '\u{FE5B}' => No,
        '\u{FE5C}' => No,
        '\u{FE5D}' => No,
        '\u{FE5E}' => No,
        '\u{FE5F}'...'\u{FE61}' => No,
        '\u{FE62}' => No,
        '\u{FE63}' => No,
        '\u{FE64}'...'\u{FE66}' => No,
        '\u{FE68}' => No,
        '\u{FE69}' => No,
        '\u{FE6A}'...'\u{FE6B}' => No,
        '\u{FE70}'...'\u{FE72}' => No,
        '\u{FE74}' => No,
        '\u{FE76}'...'\u{FEFC}' => No,
        '\u{FF01}'...'\u{FF03}' => No,
        '\u{FF04}' => No,
        '\u{FF05}'...'\u{FF07}' => No,
        '\u{FF08}' => No,
        '\u{FF09}' => No,
        '\u{FF0A}' => No,
        '\u{FF0B}' => No,
        '\u{FF0C}' => No,
        '\u{FF0D}' => No,
        '\u{FF0E}'...'\u{FF0F}' => No,
        '\u{FF10}'...'\u{FF19}' => No,
        '\u{FF1A}'...'\u{FF1B}' => No,
        '\u{FF1C}'...'\u{FF1E}' => No,
        '\u{FF1F}'...'\u{FF20}' => No,
        '\u{FF21}'...'\u{FF3A}' => No,
        '\u{FF3B}' => No,
        '\u{FF3C}' => No,
        '\u{FF3D}' => No,
        '\u{FF3E}' => No,
        '\u{FF3F}' => No,
        '\u{FF40}' => No,
        '\u{FF41}'...'\u{FF5A}' => No,
        '\u{FF5B}' => No,
        '\u{FF5C}' => No,
        '\u{FF5D}' => No,
        '\u{FF5E}' => No,
        '\u{FF5F}' => No,
        '\u{FF60}' => No,
        '\u{FF61}' => No,
        '\u{FF62}' => No,
        '\u{FF63}' => No,
        '\u{FF64}'...'\u{FF65}' => No,
        '\u{FF66}'...'\u{FF6F}' => No,
        '\u{FF70}' => No,
        '\u{FF71}'...'\u{FF9D}' => No,
        '\u{FF9E}'...'\u{FF9F}' => No,
        '\u{FFA0}'...'\u{FFBE}' => No,
        '\u{FFC2}'...'\u{FFC7}' => No,
        '\u{FFCA}'...'\u{FFCF}' => No,
        '\u{FFD2}'...'\u{FFD7}' => No,
        '\u{FFDA}'...'\u{FFDC}' => No,
        '\u{FFE0}'...'\u{FFE1}' => No,
        '\u{FFE2}' => No,
        '\u{FFE3}' => No,
        '\u{FFE4}' => No,
        '\u{FFE5}'...'\u{FFE6}' => No,
        '\u{FFE8}' => No,
        '\u{FFE9}'...'\u{FFEC}' => No,
        '\u{FFED}'...'\u{FFEE}' => No,
        '\u{10781}'...'\u{10785}' => No,
        '\u{10787}'...'\u{107B0}' => No,
        '\u{107B2}'...'\u{107BA}' => No,
        '\u{1D15E}'...'\u{1D164}' => No,
        '\u{1D1BB}'...'\u{1D1C0}' => No,
        '\u{1D400}'...'\u{1D454}' => No,
        '\u{1D456}'...'\u{1D49C}' => No,
        '\u{1D49E}'...'\u{1D49F}' => No,
        '\u{1D4A2}' => No,
        '\u{1D4A5}'...'\u{1D4A6}' => No,
        '\u{1D4A9}'...'\u{1D4AC}' => No,
        '\u{1D4AE}'...'\u{1D4B9}' => No,
        '\u{1D4BB}' => No,
        '\u{1D4BD}'...'\u{1D4C3}' => No,
        '\u{1D4C5}'...'\u{1D505}' => No,
        '\u{1D507}'...'\u{1D50A}' => No,
        '\u{1D50D}'...'\u{1D514}' => No,
        '\u{1D516}'...'\u{1D51C}' => No,
        '\u{1D51E}'...'\u{1D539}' => No,
        '\u{1D53B}'...'\u{1D53E}' => No,
        '\u{1D540}'...'\u{1D544}' => No,
        '\u{1D546}' => No,
        '\u{1D54A}'...'\u{1D550}' => No,
        '\u{1D552}'...'\u{1D6A5}' => No,
        '\u{1D6A8}'...'\u{1D6C0}' => No,
        '\u{1D6C1}' => No,
        '\u{1D6C2}'...'\u{1D6DA}' => No,
        '\u{1D6DB}' => No,
        '\u{1D6DC}'...'\u{1D6FA}' => No,
        '\u{1D6FB}' => No,
        '\u{1D6FC}'...'\u{1D714}' => No,
        '\u{1D715}' => No,
        '\u{1D716}'...'\u{1D734}' => No,
        '\u{1D735}' => No,
        '\u{1D736}'...'\u{1D74E}' => No,
        '\u{1D74F}' => No,
        '\u{1D750}'...'\u{1D76E}' => No,
        '\u{1D76F}' => No,
        '\u{1D770}'...'\u{1D788}' => No,
        '\u{1D789}' => No,
        '\u{1D78A}'...'\u{1D7A8}' => No,
        '\u{1D7A9}' => No,
        '\u{1D7AA}'...'\u{1D7C2}' => No,
        '\u{1D7C3}' => No,
        '\u{1D7C4}'...'\u{1D7CB}' => No,
        '\u{1D7CE}'...'\u{1D7FF}' => No,
        '\u{1E030}'...'\u{1E06D}' => No,
        '\u{1EE00}'...'\u{1EE03}' => No,
        '\u{1EE05}'...'\u{1EE1F}' => No,
        '\u{1EE21}'...'\u{1EE22}' => No,
        '\u{1EE24}' => No,
        '\u{1EE27}' => No,
        '\u{1EE29}'...'\u{1EE32}' => No,
        '\u{1EE34}'...'\u{1EE37}' => No,
        '\u{1EE39}' => No,
        '\u{1EE3B}' => No,
        '\u{1EE42}' => No,
        '\u{1EE47}' => No,
        '\u{1EE49}' => No,
        '\u{1EE4B}' => No,
        '\u{1EE4D}'...'\u{1EE4F}' => No,
        '\u{1EE51}'...'\u{1EE52}' => No,
        '\u{1EE54}' => No,
        '\u{1EE57}' => No,
        '\u{1EE59}' => No,
        '\u{1EE5B}' => No,
        '\u{1EE5D}' => No,
        '\u{1EE5F}' => No,
        '\u{1EE61}'...'\u{1EE62}' => No,
        '\u{1EE64}' => No,
        '\u{1EE67}'...'\u{1EE6A}' => No,
        '\u{1EE6C}'...'\u{1EE72}' => No,
        '\u{1EE74}'...'\u{1EE77}' => No,
        '\u{1EE79}'...'\u{1EE7C}' => No,
        '\u{1EE7E}' => No,
        '\u{1EE80}'...'\u{1EE89}' => No,
        '\u{1EE8B}'...'\u{1EE9B}' => No,
        '\u{1EEA1}'...'\u{1EEA3}' => No,
        '\u{1EEA5}'...'\u{1EEA9}' => No,
        '\u{1EEAB}'...'\u{1EEBB}' => No,
        '\u{1F100}'...'\u{1F10A}' => No,
        '\u{1F110}'...'\u{1F12E}' => No,
        '\u{1F130}'...'\u{1F14F}' => No,
        '\u{1F16A}'...'\u{1F16C}' => No,
        '\u{1F190}' => No,
        '\u{1F200}'...'\u{1F202}' => No,
        '\u{1F210}'...'\u{1F23B}' => No,
        '\u{1F240}'...'\u{1F248}' => No,
        '\u{1F250}'...'\u{1F251}' => No,
        '\u{1FBF0}'...'\u{1FBF9}' => No,
        '\u{2F800}'...'\u{2FA1D}' => No,
        '\u{0300}'...'\u{0304}' => Maybe,
        '\u{0306}'...'\u{030C}' => Maybe,
        '\u{030F}' => Maybe,
        '\u{0311}' => Maybe,
        '\u{0313}'...'\u{0314}' => Maybe,
        '\u{031B}' => Maybe,
        '\u{0323}'...'\u{0328}' => Maybe,
        '\u{032D}'...'\u{032E}' => Maybe,
        '\u{0330}'...'\u{0331}' => Maybe,
        '\u{0338}' => Maybe,
        '\u{0342}' => Maybe,
        '\u{0345}' => Maybe,
        '\u{0653}'...'\u{0655}' => Maybe,
        '\u{093C}' => Maybe,
        '\u{09BE}' => Maybe,
        '\u{09D7}' => Maybe,
        '\u{0B3E}' => Maybe,
        '\u{0B56}' => Maybe,
        '\u{0B57}' => Maybe,
        '\u{0BBE}' => Maybe,
        '\u{0BD7}' => Maybe,
        '\u{0C56}' => Maybe,
        '\u{0CC2}' => Maybe,
        '\u{0CD5}'...'\u{0CD6}' => Maybe,
        '\u{0D3E}' => Maybe,
        '\u{0D57}' => Maybe,
        '\u{0DCA}' => Maybe,
        '\u{0DCF}' => Maybe,
        '\u{0DDF}' => Maybe,
        '\u{102E}' => Maybe,
        '\u{1161}'...'\u{1175}' => Maybe,
        '\u{11A8}'...'\u{11C2}' => Maybe,
        '\u{1B35}' => Maybe,
        '\u{3099}'...'\u{309A}' => Maybe,
        '\u{110BA}' => Maybe,
        '\u{11127}' => Maybe,
        '\u{1133E}' => Maybe,
        '\u{11357}' => Maybe,
        '\u{114B0}' => Maybe,
        '\u{114BA}' => Maybe,
        '\u{114BD}' => Maybe,
        '\u{115AF}' => Maybe,
        '\u{11930}' => Maybe,
        _ => Yes,
    }
}

#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfd(c: char) -> IsNormalized {
    match c {
        '\u{00C0}'...'\u{00C5}' => No,
        '\u{00C7}'...'\u{00CF}' => No,
        '\u{00D1}'...'\u{00D6}' => No,
        '\u{00D9}'...'\u{00DD}' => No,
        '\u{00E0}'...'\u{00E5}' => No,
        '\u{00E7}'...'\u{00EF}' => No,
        '\u{00F1}'...'\u{00F6}' => No,
        '\u{00F9}'...'\u{00FD}' => No,
        '\u{00FF}'...'\u{010F}' => No,
        '\u{0112}'...'\u{0125}' => No,
        '\u{0128}'...'\u{0130}' => No,
        '\u{0134}'...'\u{0137}' => No,
        '\u{0139}'...'\u{013E}' => No,
        '\u{0143}'...'\u{0148}' => No,
        '\u{014C}'...'\u{0151}' => No,
        '\u{0154}'...'\u{0165}' => No,
        '\u{0168}'...'\u{017E}' => No,
        '\u{01A0}'...'\u{01A1}' => No,
        '\u{01AF}'...'\u{01B0}' => No,
        '\u{01CD}'...'\u{01DC}' => No,
        '\u{01DE}'...'\u{01E3}' => No,
        '\u{01E6}'...'\u{01F0}' => No,
        '\u{01F4}'...'\u{01F5}' => No,
        '\u{01F8}'...'\u{021B}' => No,
        '\u{021E}'...'\u{021F}' => No,
        '\u{0226}'...'\u{0233}' => No,
        '\u{0340}'...'\u{0341}' => No,
        '\u{0343}'...'\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037E}' => No,
        '\u{0385}' => No,
        '\u{0386}' => No,
        '\u{0387}' => No,
        '\u{0388}'...'\u{038A}' => No,
        '\u{038C}' => No,
        '\u{038E}'...'\u{0390}' => No,
        '\u{03AA}'...'\u{03B0}' => No,
        '\u{03CA}'...'\u{03CE}' => No,
        '\u{03D3}'...'\u{03D4}' => No,
        '\u{0400}'...'\u{0401}' => No,
        '\u{0403}' => No,
        '\u{0407}' => No,
        '\u{040C}'...'\u{040E}' => No,
        '\u{0419}' => No,
        '\u{0439}' => No,
        '\u{0450}'...'\u{0451}' => No,
        '\u{0453}' => No,
        '\u{0457}' => No,
        '\u{045C}'...'\u{045E}' => No,
        '\u{0476}'...'\u{0477}' => No,
        '\u{04C1}'...'\u{04C2}' => No,
        '\u{04D0}'...'\u{04D3}' => No,
        '\u{04D6}'...'\u{04D7}' => No,
        '\u{04DA}'...'\u{04DF}' => No,
        '\u{04E2}'...'\u{04E7}' => No,
        '\u{04EA}'...'\u{04F5}' => No,
        '\u{04F8}'...'\u{04F9}' => No,
        '\u{0622}'...'\u{0626}' => No,
        '\u{06C0}' => No,
        '\u{06C2}' => No,
        '\u{06D3}' => No,
        '\u{0929}' => No,
        '\u{0931}' => No,
        '\u{0934}' => No,
        '\u{0958}'...'\u{095F}' => No,
        '\u{09CB}'...'\u{09CC}' => No,
        '\u{09DC}'...'\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'...'\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B48}' => No,
        '\u{0B4B}'...'\u{0B4C}' => No,
        '\u{0B5C}'...'\u{0B5D}' => No,
        '\u{0B94}' => No,
        '\u{0BCA}'...'\u{0BCC}' => No,
        '\u{0C48}' => No,
        '\u{0CC0}' => No,
        '\u{0CC7}'...'\u{0CC8}' => No,
        '\u{0CCA}'...'\u{0CCB}' => No,
        '\u{0D4A}'...'\u{0D4C}' => No,
        '\u{0DDA}' => No,
        '\u{0DDC}'...'\u{0DDE}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'...'\u{0F76}' => No,
        '\u{0F78}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1026}' => No,
        '\u{1B06}' => No,
        '\u{1B08}' => No,
        '\u{1B0A}' => No,
        '\u{1B0C}' => No,
        '\u{1B0E}' => No,
        '\u{1B12}' => No,
        '\u{1B3B}' => No,
        '\u{1B3D}' => No,
        '\u{1B40}'...'\u{1B41}' => No,
        '\u{1B43}' => No,
        '\u{1E00}'...'\u{1E99}' => No,
        '\u{1E9B}' => No,
        '\u{1EA0}'...'\u{1EF9}' => No,
        '\u{1F00}'...'\u{1F15}' => No,
        '\u{1F18}'...'\u{1F1D}' => No,
        '\u{1F20}'...'\u{1F45}' => No,
        '\u{1F48}'...'\u{1F4D}' => No,
        '\u{1F50}'...'\u{1F57}' => No,
        '\u{1F59}' => No,
        '\u{1F5B}' => No,
        '\u{1F5D}' => No,
        '\u{1F5F}'...'\u{1F7D}' => No,
        '\u{1F80}'...'\u{1FB4}' => No,
        '\u{1FB6}'...'\u{1FBC}' => No,
        '\u{1FBE}' => No,
        '\u{1FC1}' => No,
        '\u{1FC2}'...'\u{1FC4}' => No,
        '\u{1FC6}'...'\u{1FCC}' => No,
        '\u{1FCD}'...'\u{1FCF}' => No,
        '\u{1FD0}'...'\u{1FD3}' => No,
        '\u{1FD6}'...'\u{1FDB}' => No,
        '\u{1FDD}'...'\u{1FDF}' => No,
        '\u{1FE0}'...'\u{1FEC}' => No,
        '\u{1FED}'...'\u{1FEF}' => No,
        '\u{1FF2}'...'\u{1FF4}' => No,
        '\u{1FF6}'...'\u{1FFC}' => No,
        '\u{1FFD}' => No,
        '\u{2000}'...'\u{2001}' => No,
        '\u{2126}' => No,
        '\u{212A}'...'\u{212B}' => No,
        '\u{219A}'...'\u{219B}' => No,
        '\u{21AE}' => No,
        '\u{21CD}' => No,
        '\u{21CE}'...'\u{21CF}' => No,
        '\u{2204}' => No,
        '\u{2209}' => No,
        '\u{220C}' => No,
        '\u{2224}' => No,
        '\u{2226}' => No,
        '\u{2241}' => No,
        '\u{2244}' => No,
        '\u{2247}' => No,
        '\u{2249}' => No,
        '\u{2260}' => No,
        '\u{2262}' => No,
        '\u{226D}'...'\u{2271}' => No,
        '\u{2274}'...'\u{2275}' => No,
        '\u{2278}'...'\u{2279}' => No,
        '\u{2280}'...'\u{2281}' => No,
        '\u{2284}'...'\u{2285}' => No,
        '\u{2288}'...'\u{2289}' => No,
        '\u{22AC}'...'\u{22AF}' => No,
        '\u{22E0}'...'\u{22E3}' => No,
        '\u{22EA}'...'\u{22ED}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2ADC}' => No,
        '\u{304C}' => No,
        '\u{304E}' => No,
        '\u{3050}' => No,
        '\u{3052}' => No,
        '\u{3054}' => No,
        '\u{3056}' => No,
        '\u{3058}' => No,
        '\u{305A}' => No,
        '\u{305C}' => No,
        '\u{305E}' => No,
        '\u{3060}' => No,
        '\u{3062}' => No,
        '\u{3065}' => No,
        '\u{3067}' => No,
        '\u{3069}' => No,
        '\u{3070}'...'\u{3071}' => No,
        '\u{3073}'...'\u{3074}' => No,
        '\u{3076}'...'\u{3077}' => No,
        '\u{3079}'...'\u{307A}' => No,
        '\u{307C}'...'\u{307D}' => No,
        '\u{3094}' => No,
        '\u{309E}' => No,
        '\u{30AC}' => No,
        '\u{30AE}' => No,
        '\u{30B0}' => No,
        '\u{30B2}' => No,
        '\u{30B4}' => No,
        '\u{30B6}' => No,
        '\u{30B8}' => No,
        '\u{30BA}' => No,
        '\u{30BC}' => No,
        '\u{30BE}' => No,
        '\u{30C0}' => No,
        '\u{30C2}' => No,
        '\u{30C5}' => No,
        '\u{30C7}' => No,
        '\u{30C9}' => No,
        '\u{30D0}'...'\u{30D1}' => No,
        '\u{30D3}'...'\u{30D4}' => No,
        '\u{30D6}'...'\u{30D7}' => No,
        '\u{30D9}'...'\u{30DA}' => No,
        '\u{30DC}'...'\u{30DD}' => No,
        '\u{30F4}' => No,
        '\u{30F7}'...'\u{30FA}' => No,
        '\u{30FE}' => No,
        '\u{AC00}'...'\u{D7A3}' => No,
        '\u{F900}'...'\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'...'\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'...'\u{FA26}' => No,
        '\u{FA2A}'...'\u{FA6D}' => No,
        '\u{FA70}'...'\u{FAD9}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}' => No,
        '\u{FB2A}'...'\u{FB36}' => No,
        '\u{FB38}'...'\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'...'\u{FB41}' => No,
        '\u{FB43}'...'\u{FB44}' => No,
        '\u{FB46}'...'\u{FB4E}' => No,
        '\u{1109A}' => No,
        '\u{1109C}' => No,
        '\u{110AB}' => No,
        '\u{1112E}'...'\u{1112F}' => No,
        '\u{1134B}'...'\u{1134C}' => No,
        '\u{114BB}'...'\u{114BC}' => No,
        '\u{114BE}' => No,
        '\u{115BA}'...'\u{115BB}' => No,
        '\u{11938}' => No,
        '\u{1D15E}'...'\u{1D164}' => No,
        '\u{1D1BB}'...'\u{1D1C0}' => No,
        '\u{2F800}'...'\u{2FA1D}' => No,
        _ => Yes,
    }
}

#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfkd(c: char) -> IsNormalized {
    match c {
        '\u{00A0}' => No,
        '\u{00A8}' => No,
        '\u{00AA}' => No,
        '\u{00AF}' => No,
        '\u{00B2}'...'\u{00B3}' => No,
        '\u{00B4}' => No,
        '\u{00B5}' => No,
        '\u{00B8}' => No,
        '\u{00B9}' => No,
        '\u{00BA}' => No,
        '\u{00BC}'...'\u{00BE}' => No,
        '\u{00C0}'...'\u{00C5}' => No,
        '\u{00C7}'...'\u{00CF}' => No,
        '\u{00D1}'...'\u{00D6}' => No,
        '\u{00D9}'...'\u{00DD}' => No,
        '\u{00E0}'...'\u{00E5}' => No,
        '\u{00E7}'...'\u{00EF}' => No,
        '\u{00F1}'...'\u{00F6}' => No,
        '\u{00F9}'...'\u{00FD}' => No,
        '\u{00FF}'...'\u{010F}' => No,
        '\u{0112}'...'\u{0125}' => No,
        '\u{0128}'...'\u{0130}' => No,
        '\u{0132}'...'\u{0137}' => No,
        '\u{0139}'...'\u{0140}' => No,
        '\u{0143}'...'\u{0149}' => No,
        '\u{014C}'...'\u{0151}' => No,
        '\u{0154}'...'\u{0165}' => No,
        '\u{0168}'...'\u{017F}' => No,
        '\u{01A0}'...'\u{01A1}' => No,
        '\u{01AF}'...'\u{01B0}' => No,
        '\u{01C4}'...'\u{01DC}' => No,
        '\u{01DE}'...'\u{01E3}' => No,
        '\u{01E6}'...'\u{01F5}' => No,
        '\u{01F8}'...'\u{021B}' => No,
        '\u{021E}'...'\u{021F}' => No,
        '\u{0226}'...'\u{0233}' => No,
        '\u{02B0}'...'\u{02B8}' => No,
        '\u{02D8}'...'\u{02DD}' => No,
        '\u{02E0}'...'\u{02E4}' => No,
        '\u{0340}'...'\u{0341}' => No,
        '\u{0343}'...'\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037A}' => No,
        '\u{037E}' => No,
        '\u{0384}'...'\u{0385}' => No,
        '\u{0386}' => No,
        '\u{0387}' => No,
        '\u{0388}'...'\u{038A}' => No,
        '\u{038C}' => No,
        '\u{038E}'...'\u{0390}' => No,
        '\u{03AA}'...'\u{03B0}' => No,
        '\u{03CA}'...'\u{03CE}' => No,
        '\u{03D0}'...'\u{03D6}' => No,
        '\u{03F0}'...'\u{03F2}' => No,
        '\u{03F4}'...'\u{03F5}' => No,
        '\u{03F9}' => No,
        '\u{0400}'...'\u{0401}' => No,
        '\u{0403}' => No,
        '\u{0407}' => No,
        '\u{040C}'...'\u{040E}' => No,
        '\u{0419}' => No,
        '\u{0439}' => No,
        '\u{0450}'...'\u{0451}' => No,
        '\u{0453}' => No,
        '\u{0457}' => No,
        '\u{045C}'...'\u{045E}' => No,
        '\u{0476}'...'\u{0477}' => No,
        '\u{04C1}'...'\u{04C2}' => No,
        '\u{04D0}'...'\u{04D3}' => No,
        '\u{04D6}'...'\u{04D7}' => No,
        '\u{04DA}'...'\u{04DF}' => No,
        '\u{04E2}'...'\u{04E7}' => No,
        '\u{04EA}'...'\u{04F5}' => No,
        '\u{04F8}'...'\u{04F9}' => No,
        '\u{0587}' => No,
        '\u{0622}'...'\u{0626}' => No,
        '\u{0675}'...'\u{0678}' => No,
        '\u{06C0}' => No,
        '\u{06C2}' => No,
        '\u{06D3}' => No,
        '\u{0929}' => No,
        '\u{0931}' => No,
        '\u{0934}' => No,
        '\u{0958}'...'\u{095F}' => No,
        '\u{09CB}'...'\u{09CC}' => No,
        '\u{09DC}'...'\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'...'\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B48}' => No,
        '\u{0B4B}'...'\u{0B4C}' => No,
        '\u{0B5C}'...'\u{0B5D}' => No,
        '\u{0B94}' => No,
        '\u{0BCA}'...'\u{0BCC}' => No,
        '\u{0C48}' => No,
        '\u{0CC0}' => No,
        '\u{0CC7}'...'\u{0CC8}' => No,
        '\u{0CCA}'...'\u{0CCB}' => No,
        '\u{0D4A}'...'\u{0D4C}' => No,
        '\u{0DDA}' => No,
        '\u{0DDC}'...'\u{0DDE}' => No,
        '\u{0E33}' => No,
        '\u{0EB3}' => No,
        '\u{0EDC}'...'\u{0EDD}' => No,
        '\u{0F0C}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'...'\u{0F79}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1026}' => No,
        '\u{10FC}' => No,
        '\u{1B06}' => No,
        '\u{1B08}' => No,
        '\u{1B0A}' => No,
        '\u{1B0C}' => No,
        '\u{1B0E}' => No,
        '\u{1B12}' => No,
        '\u{1B3B}' => No,
        '\u{1B3D}' => No,
        '\u{1B40}'...'\u{1B41}' => No,
        '\u{1B43}' => No,
        '\u{1D2C}'...'\u{1D2E}' => No,
        '\u{1D30}'...'\u{1D3A}' => No,
        '\u{1D3C}'...'\u{1D4D}' => No,
        '\u{1D4F}'...'\u{1D6A}' => No,
        '\u{1D78}' => No,
        '\u{1D9B}'...'\u{1DBF}' => No,
        '\u{1E00}'...'\u{1E9B}' => No,
        '\u{1EA0}'...'\u{1EF9}' => No,
        '\u{1F00}'...'\u{1F15}' => No,
        '\u{1F18}'...'\u{1F1D}' => No,
        '\u{1F20}'...'\u{1F45}' => No,
        '\u{1F48}'...'\u{1F4D}' => No,
        '\u{1F50}'...'\u{1F57}' => No,
        '\u{1F59}' => No,
        '\u{1F5B}' => No,
        '\u{1F5D}' => No,
        '\u{1F5F}'...'\u{1F7D}' => No,
        '\u{1F80}'...'\u{1FB4}' => No,
        '\u{1FB6}'...'\u{1FBC}' => No,
        '\u{1FBD}' => No,
        '\u{1FBE}' => No,
        '\u{1FBF}'...'\u{1FC1}' => No,
        '\u{1FC2}'...'\u{1FC4}' => No,
        '\u{1FC6}'...'\u{1FCC}' => No,
        '\u{1FCD}'...'\u{1FCF}' => No,
        '\u{1FD0}'...'\u{1FD3}' => No,
        '\u{1FD6}'...'\u{1FDB}' => No,
        '\u{1FDD}'...'\u{1FDF}' => No,
        '\u{1FE0}'...'\u{1FEC}' => No,
        '\u{1FED}'...'\u{1FEF}' => No,
        '\u{1FF2}'...'\u{1FF4}' => No,
        '\u{1FF6}'...'\u{1FFC}' => No,
        '\u{1FFD}'...'\u{1FFE}' => No,
        '\u{2000}'...'\u{200A}' => No,
        '\u{2011}' => No,
        '\u{2017}' => No,
        '\u{2024}'...'\u{2026}' => No,
        '\u{202F}' => No,
        '\u{2033}'...'\u{2034}' => No,
        '\u{2036}'...'\u{2037}' => No,
        '\u{203C}' => No,
        '\u{203E}' => No,
        '\u{2047}'...'\u{2049}' => No,
        '\u{2057}' => No,
        '\u{205F}' => No,
        '\u{2070}' => No,
        '\u{2071}' => No,
        '\u{2074}'...'\u{2079}' => No,
        '\u{207A}'...'\u{207C}' => No,
        '\u{207D}' => No,
        '\u{207E}' => No,
        '\u{207F}' => No,
        '\u{2080}'...'\u{2089}' => No,
        '\u{208A}'...'\u{208C}' => No,
        '\u{208D}' => No,
        '\u{208E}' => No,
        '\u{2090}'...'\u{209C}' => No,
        '\u{20A8}' => No,
        '\u{2100}'...'\u{2101}' => No,
        '\u{2102}' => No,
        '\u{2103}' => No,
        '\u{2105}'...'\u{2106}' => No,
        '\u{2107}' => No,
        '\u{2109}' => No,
        '\u{210A}'...'\u{2113}' => No,
        '\u{2115}' => No,
        '\u{2116}' => No,
        '\u{2119}'...'\u{211D}' => No,
        '\u{2120}'...'\u{2122}' => No,
        '\u{2124}' => No,
        '\u{2126}' => No,
        '\u{2128}' => No,
        '\u{212A}'...'\u{212D}' => No,
        '\u{212F}'...'\u{2131}' => No,
        '\u{2133}'...'\u{2134}' => No,
        '\u{2135}'...'\u{2138}' => No,
        '\u{2139}' => No,
        '\u{213B}' => No,
        '\u{213C}'...'\u{213F}' => No,
        '\u{2140}' => No,
        '\u{2145}'...'\u{2149}' => No,
        '\u{2150}'...'\u{215F}' => No,
        '\u{2160}'...'\u{217F}' => No,
        '\u{2189}' => No,
        '\u{219A}'...'\u{219B}' => No,
        '\u{21AE}' => No,
        '\u{21CD}' => No,
        '\u{21CE}'...'\u{21CF}' => No,
        '\u{2204}' => No,
        '\u{2209}' => No,
        '\u{220C}' => No,
        '\u{2224}' => No,
        '\u{2226}' => No,
        '\u{222C}'...'\u{222D}' => No,
        '\u{222F}'...'\u{2230}' => No,
        '\u{2241}' => No,
        '\u{2244}' => No,
        '\u{2247}' => No,
        '\u{2249}' => No,
        '\u{2260}' => No,
        '\u{2262}' => No,
        '\u{226D}'...'\u{2271}' => No,
        '\u{2274}'...'\u{2275}' => No,
        '\u{2278}'...'\u{2279}' => No,
        '\u{2280}'...'\u{2281}' => No,
        '\u{2284}'...'\u{2285}' => No,
        '\u{2288}'...'\u{2289}' => No,
        '\u{22AC}'...'\u{22AF}' => No,
        '\u{22E0}'...'\u{22E3}' => No,
        '\u{22EA}'...'\u{22ED}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2460}'...'\u{249B}' => No,
        '\u{249C}'...'\u{24E9}' => No,
        '\u{24EA}' => No,
        '\u{2A0C}' => No,
        '\u{2A74}'...'\u{2A76}' => No,
        '\u{2ADC}' => No,
        '\u{2C7C}'...'\u{2C7D}' => No,
        '\u{2D6F}' => No,
        '\u{2E9F}' => No,
        '\u{2EF3}' => No,
        '\u{2F00}'...'\u{2FD5}' => No,
        '\u{3000}' => No,
        '\u{3036}' => No,
        '\u{3038}'...'\u{303A}' => No,
        '\u{304C}' => No,
        '\u{304E}' => No,
        '\u{3050}' => No,
        '\u{3052}' => No,
        '\u{3054}' => No,
        '\u{3056}' => No,
        '\u{3058}' => No,
        '\u{305A}' => No,
        '\u{305C}' => No,
        '\u{305E}' => No,
        '\u{3060}' => No,
        '\u{3062}' => No,
        '\u{3065}' => No,
        '\u{3067}' => No,
        '\u{3069}' => No,
        '\u{3070}'...'\u{3071}' => No,
        '\u{3073}'...'\u{3074}' => No,
        '\u{3076}'...'\u{3077}' => No,
        '\u{3079}'...'\u{307A}' => No,
        '\u{307C}'...'\u{307D}' => No,
        '\u{3094}' => No,
        '\u{309B}'...'\u{309C}' => No,
        '\u{309E}' => No,
        '\u{309F}' => No,
        '\u{30AC}' => No,
        '\u{30AE}' => No,
        '\u{30B0}' => No,
        '\u{30B2}' => No,
        '\u{30B4}' => No,
        '\u{30B6}' => No,
        '\u{30B8}' => No,
        '\u{30BA}' => No,
        '\u{30BC}' => No,
        '\u{30BE}' => No,
        '\u{30C0}' => No,
        '\u{30C2}' => No,
        '\u{30C5}' => No,
        '\u{30C7}' => No,
        '\u{30C9}' => No,
        '\u{30D0}'...'\u{30D1}' => No,
        '\u{30D3}'...'\u{30D4}' => No,
        '\u{30D6}'...'\u{30D7}' => No,
        '\u{30D9}'...'\u{30DA}' => No,
        '\u{30DC}'...'\u{30DD}' => No,
        '\u{30F4}' => No,
        '\u{30F7}'...'\u{30FA}' => No,
        '\u{30FE}' => No,
        '\u{30FF}' => No,
        '\u{3131}'...'\u{318E}' => No,
        '\u{3192}'...'\u{3195}' => No,
        '\u{3196}'...'\u{319F}' => No,
        '\u{3200}'...'\u{321E}' => No,
        '\u{3220}'...'\u{3229}' => No,
        '\u{322A}'...'\u{3247}' => No,
        '\u{3250}' => No,
        '\u{3251}'...'\u{325F}' => No,
        '\u{3260}'...'\u{327E}' => No,
        '\u{3280}'...'\u{3289}' => No,
        '\u{328A}'...'\u{32B0}' => No,
        '\u{32B1}'...'\u{32BF}' => No,
        '\u{32C0}'...'\u{33FF}' => No,
        '\u{A69C}'...'\u{A69D}' => No,
        '\u{A770}' => No,
        '\u{A7F2}'...'\u{A7F4}' => No,
        '\u{A7F8}'...'\u{A7F9}' => No,
        '\u{AB5C}'...'\u{AB5F}' => No,
        '\u{AB69}' => No,
        '\u{AC00}'...'\u{D7A3}' => No,
        '\u{F900}'...'\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'...'\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'...'\u{FA26}' => No,
        '\u{FA2A}'...'\u{FA6D}' => No,
        '\u{FA70}'...'\u{FAD9}' => No,
        '\u{FB00}'...'\u{FB06}' => No,
        '\u{FB13}'...'\u{FB17}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}'...'\u{FB28}' => No,
        '\u{FB29}' => No,
        '\u{FB2A}'...'\u{FB36}' => No,
        '\u{FB38}'...'\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'...'\u{FB41}' => No,
        '\u{FB43}'...'\u{FB44}' => No,
        '\u{FB46}'...'\u{FBB1}' => No,
        '\u{FBD3}'...'\u{FD3D}' => No,
        '\u{FD50}'...'\u{FD8F}' => No,
        '\u{FD92}'...'\u{FDC7}' => No,
        '\u{FDF0}'...'\u{FDFB}' => No,
        '\u{FDFC}' => No,
        '\u{FE10}'...'\u{FE16}' => No,
        '\u{FE17}' => No,
        '\u{FE18}' => No,
        '\u{FE19}' => No,
        '\u{FE30}' => No,
        '\u{FE31}'...'\u{FE32}' => No,
        '\u{FE33}'...'\u{FE34}' => No,
        '\u{FE35}' => No,
        '\u{FE36}' => No,
        '\u{FE37}' => No,
        '\u{FE38}' => No,
        '\u{FE39}' => No,
        '\u{FE3A}' => No,
        '\u{FE3B}' => No,
        '\u{FE3C}' => No,
        '\u{FE3D}' => No,
        '\u{FE3E}' => No,
        '\u{FE3F}' => No,
        '\u{FE40}' => No,
        '\u{FE41}' => No,
        '\u{FE42}' => No,
        '\u{FE43}' => No,
        '\u{FE44}' => No,
        '\u{FE47}' => No,
        '\u{FE48}' => No,
        '\u{FE49}'...'\u{FE4C}' => No,
        '\u{FE4D}'...'\u{FE4F}' => No,
        '\u{FE50}'...'\u{FE52}' => No,
        '\u{FE54}'...'\u{FE57}' => No,
        '\u{FE58}' => No,
        '\u{FE59}' => No,
        '\u{FE5A}' => No,
        '\u{FE5B}' => No,
        '\u{FE5C}' => No,
        '\u{FE5D}' => No,
        '\u{FE5E}' => No,
        '\u{FE5F}'...'\u{FE61}' => No,
        '\u{FE62}' => No,
        '\u{FE63}' => No,
        '\u{FE64}'...'\u{FE66}' => No,
        '\u{FE68}' => No,
        '\u{FE69}' => No,
        '\u{FE6A}'...'\u{FE6B}' => No,
        '\u{FE70}'...'\u{FE72}' => No,
        '\u{FE74}' => No,
        '\u{FE76}'...'\u{FEFC}' => No,
        '\u{FF01}'...'\u{FF03}' => No,
        '\u{FF04}' => No,
        '\u{FF05}'...'\u{FF07}' => No,
        '\u{FF08}' => No,
        '\u{FF09}' => No,
        '\u{FF0A}' => No,
        '\u{FF0B}' => No,
        '\u{FF0C}' => No,
        '\u{FF0D}' => No,
        '\u{FF0E}'...'\u{FF0F}' => No,
        '\u{FF10}'...'\u{FF19}' => No,
        '\u{FF1A}'...'\u{FF1B}' => No,
        '\u{FF1C}'...'\u{FF1E}' => No,
        '\u{FF1F}'...'\u{FF20}' => No,
        '\u{FF21}'...'\u{FF3A}' => No,
        '\u{FF3B}' => No,
        '\u{FF3C}' => No,
        '\u{FF3D}' => No,
        '\u{FF3E}' => No,
        '\u{FF3F}' => No,
        '\u{FF40}' => No,
        '\u{FF41}'...'\u{FF5A}' => No,
        '\u{FF5B}' => No,
        '\u{FF5C}' => No,
        '\u{FF5D}' => No,
        '\u{FF5E}' => No,
        '\u{FF5F}' => No,
        '\u{FF60}' => No,
        '\u{FF61}' => No,
        '\u{FF62}' => No,
        '\u{FF63}' => No,
        '\u{FF64}'...'\u{FF65}' => No,
        '\u{FF66}'...'\u{FF6F}' => No,
        '\u{FF70}' => No,
        '\u{FF71}'...'\u{FF9D}' => No,
        '\u{FF9E}'...'\u{FF9F}' => No,
        '\u{FFA0}'...'\u{FFBE}' => No,
        '\u{FFC2}'...'\u{FFC7}' => No,
        '\u{FFCA}'...'\u{FFCF}' => No,
        '\u{FFD2}'...'\u{FFD7}' => No,
        '\u{FFDA}'...'\u{FFDC}' => No,
        '\u{FFE0}'...'\u{FFE1}' => No,
        '\u{FFE2}' => No,
        '\u{FFE3}' => No,
        '\u{FFE4}' => No,
        '\u{FFE5}'...'\u{FFE6}' => No,
        '\u{FFE8}' => No,
        '\u{FFE9}'...'\u{FFEC}' => No,
        '\u{FFED}'...'\u{FFEE}' => No,
        '\u{10781}'...'\u{10785}' => No,
        '\u{10787}'...'\u{107B0}' => No,
        '\u{107B2}'...'\u{107BA}' => No,
        '\u{1109A}' => No,
        '\u{1109C}' => No,
        '\u{110AB}' => No,
        '\u{1112E}'...'\u{1112F}' => No,
        '\u{1134B}'...'\u{1134C}' => No,
        '\u{114BB}'...'\u{114BC}' => No,
        '\u{114BE}' => No,
        '\u{115BA}'...'\u{115BB}' => No,
        '\u{11938}' => No,
        '\u{1D15E}'...'\u{1D164}' => No,
        '\u{1D1BB}'...'\u{1D1C0}' => No,
        '\u{1D400}'...'\u{1D454}' => No,
        '\u{1D456}'...'\u{1D49C}' => No,
        '\u{1D49E}'...'\u{1D49F}' => No,
        '\u{1D4A2}' => No,
        '\u{1D4A5}'...'\u{1D4A6}' => No,
        '\u{1D4A9}'...'\u{1D4AC}' => No,
        '\u{1D4AE}'...'\u{1D4B9}' => No,
        '\u{1D4BB}' => No,
        '\u{1D4BD}'...'\u{1D4C3}' => No,
        '\u{1D4C5}'...'\u{1D505}' => No,
        '\u{1D507}'...'\u{1D50A}' => No,
        '\u{1D50D}'...'\u{1D514}' => No,
        '\u{1D516}'...'\u{1D51C}' => No,
        '\u{1D51E}'...'\u{1D539}' => No,
        '\u{1D53B}'...'\u{1D53E}' => No,
        '\u{1D540}'...'\u{1D544}' => No,
        '\u{1D546}' => No,
        '\u{1D54A}'...'\u{1D550}' => No,
        '\u{1D552}'...'\u{1D6A5}' => No,
        '\u{1D6A8}'...'\u{1D6C0}' => No,
        '\u{1D6C1}' => No,
        '\u{1D6C2}'...'\u{1D6DA}' => No,
        '\u{1D6DB}' => No,
        '\u{1D6DC}'...'\u{1D6FA}' => No,
        '\u{1D6FB}' => No,
        '\u{1D6FC}'...'\u{1D714}' => No,
        '\u{1D715}' => No,
        '\u{1D716}'...'\u{1D734}' => No,
        '\u{1D735}' => No,
        '\u{1D736}'...'\u{1D74E}' => No,
        '\u{1D74F}' => No,
        '\u{1D750}'...'\u{1D76E}' => No,
        '\u{1D76F}' => No,
        '\u{1D770}'...'\u{1D788}' => No,
        '\u{1D789}' => No,
        '\u{1D78A}'...'\u{1D7A8}' => No,
        '\u{1D7A9}' => No,
        '\u{1D7AA}'...'\u{1D7C2}' => No,
        '\u{1D7C3}' => No,
        '\u{1D7C4}'...'\u{1D7CB}' => No,
        '\u{1D7CE}'...'\u{1D7FF}' => No,
        '\u{1E030}'...'\u{1E06D}' => No,
        '\u{1EE00}'...'\u{1EE03}' => No,
        '\u{1EE05}'...'\u{1EE1F}' => No,
        '\u{1EE21}'...'\u{1EE22}' => No,
        '\u{1EE24}' => No,
        '\u{1EE27}' => No,
        '\u{1EE29}'...'\u{1EE32}' => No,
        '\u{1EE34}'...'\u{1EE37}' => No,
        '\u{1EE39}' => No,
        '\u{1EE3B}' => No,
        '\u{1EE42}' => No,
        '\u{1EE47}' => No,
        '\u{1EE49}' => No,
        '\u{1EE4B}' => No,
        '\u{1EE4D}'...'\u{1EE4F}' => No,
        '\u{1EE51}'...'\u{1EE52}' => No,
        '\u{1EE54}' => No,
        '\u{1EE57}' => No,
        '\u{1EE59}' => No,
        '\u{1EE5B}' => No,
        '\u{1EE5D}' => No,
        '\u{1EE5F}' => No,
        '\u{1EE61}'...'\u{1EE62}' => No,
        '\u{1EE64}' => No,
        '\u{1EE67}'...'\u{1EE6A}' => No,
        '\u{1EE6C}'...'\u{1EE72}' => No,
        '\u{1EE74}'...'\u{1EE77}' => No,
        '\u{1EE79}'...'\u{1EE7C}' => No,
        '\u{1EE7E}' => No,
        '\u{1EE80}'...'\u{1EE89}' => No,
        '\u{1EE8B}'...'\u{1EE9B}' => No,
        '\u{1EEA1}'...'\u{1EEA3}' => No,
        '\u{1EEA5}'...'\u{1EEA9}' => No,
        '\u{1EEAB}'...'\u{1EEBB}' => No,
        '\u{1F100}'...'\u{1F10A}' => No,
        '\u{1F110}'...'\u{1F12E}' => No,
        '\u{1F130}'...'\u{1F14F}' => No,
        '\u{1F16A}'...'\u{1F16C}' => No,
        '\u{1F190}' => No,
        '\u{1F200}'...'\u{1F202}' => No,
        '\u{1F210}'...'\u{1F23B}' => No,
        '\u{1F240}'...'\u{1F248}' => No,
        '\u{1F250}'...'\u{1F251}' => No,
        '\u{1FBF0}'...'\u{1FBF9}' => No,
        '\u{2F800}'...'\u{2FA1D}' => No,
        _ => Yes,
    }
}

#[inline]
pub fn stream_safe_leading_nonstarters(c: char) -> usize {
    match c {
        '\u{0340}' => 1,
        '\u{0341}' => 1,
        '\u{0343}' => 1,
        '\u{0344}' => 2,
        '\u{0F73}' => 2,
        '\u{0F75}' => 2,
        '\u{0F81}' => 2,
        '\u{FF9E}' => 1,
        '\u{FF9F}' => 1,
        _ => 0,
    }
}

pub(crate) const TRAILING_NONSTARTERS_SALT: &[u16] = &[
    0x1bb,
    0x0,
    0x8,
    0x162,
    0x0,
    0x5,
    0x0,
    0x75,
    0x4,
    0x0,
    0x0,
    0x5,
    0x18,
    0x2,
    0x0,
    0x1,
    0x90,
    0x0,
    0x2,
    0x5f,
    0xc6,
    0x0,
    0x0,
    0x20,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x39,
    0x0,
    0x0,
    0x48,
    0x3,
    0x0,
    0x95,
    0xaf,
    0x30,
    0x6f,
    0x0,
    0x0,
    0x4,
    0x8,
    0x10b,
    0x13,
    0x0,
    0x2f,
    0x16,
    0x6d,
    0x1,
    0x3,
    0xe,
    0x0,
    0x2c,
    0x83,
    0x37,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x6,
    0x2,
    0x46,
    0xa,
    0xb,
    0x16,
    0x4c,
    0x0,
    0x0,
    0x0,
    0xe,
    0x1,
    0x0,
    0x7,
    0xf,
    0x26,
    0x2,
    0xb,
    0xb,
    0x3,
    0x6,
    0x1a,
    0x0,
    0x1,
    0x6,
    0x5,
    0x5c,
    0x6,
    0x8,
    0x0,
    0x0,
    0x0,
    0x4,
    0x59,
    0x9,
    0x20,
    0x3,
    0x0,
    0x4,
    0x1a,
    0x1,
    0x0,
    0xb,
    0x0,
    0x0,
    0x0,
    0x0,
    0x23,
    0x2,
    0x8,
    0x0,
    0x0,
    0x0,
    0x1,
    0x29,
    0x1a,
    0x20,
    0x6,
    0x15,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x13,
    0x14,
    0x3,
    0x1,
    0x14,
    0x1,
    0x1,
    0x0,
    0x3,
    0x4,
    0x0,
    0x5,
    0x8,
    0x3,
    0x2,
    0x1c,
    0x5,
    0x1,
    0x0,
    0x17,
    0x0,
    0x0,
    0x1b,
    0x0,
    0x6,
    0x0,
    0x3a,
    0x0,
    0x23,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x16,
    0x2d,
    0x3,
    0x1,
    0x4,
    0x14,
    0x0,
    0x0,
    0x16,
    0x2,
    0x3,
    0x9,
    0x0,
    0x56,
    0x0,
    0xd,
    0x0,
    0x4,
    0xd,
    0x0,
    0x2,
    0x10,
    0x0,
    0x0,
    0x0,
    0x3,
    0x23,
    0x0,
    0x0,
    0x0,
    0x6,
    0x13,
    0x10,
    0xd,
    0x5c,
    0x0,
    0x9,
    0xe,
    0x5,
    0x1,
    0x0,
    0xc,
    0xd,
    0x1,
    0x4,
    0x1,
    0x2,
    0x13,
    0x0,
    0x0,
    0x1,
    0xc,
    0xb,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0xc,
    0x0,
    0x7,
    0x0,
    0xf,
    0x0,
    0x5,
    0x4,
    0x4,
    0x3,
    0x2,
    0x4,
    0x1,
    0x11,
    0x11,
    0xc,
    0x5,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x2,
    0xc,
    0x0,
    0x0,
    0x11,
    0x6,
    0x0,
    0x0,
    0x0,
    0x4,
    0x8,
    0x0,
    0x0,
    0x2,
    0x12,
    0x9,
    0x1,
    0x0,
    0x3,
    0x9,
    0x0,
    0x0,
    0x3,
    0x9,
    0x0,
    0x0,
    0x1,
    0x0,
    0xc,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x9,
    0x2,
    0x2,
    0x8,
    0x0,
    0x0,
    0x5,
    0x13,
    0x7,
    0xc,
    0x0,
    0x9,
    0x1,
    0x3a,
    0x1,
    0x1,
    0x9,
    0x0,
    0x0,
    0x0,
    0x9,
    0x1,
    0x4,
    0x12,
    0x0,
    0x7,
    0x4,
    0x5,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x7,
    0x1,
    0x0,
    0x12,
    0x2,
    0x1,
    0x6,
    0x1a,
    0x4,
    0x6,
    0x0,
    0x0,
    0x1,
    0x0,
    0x9,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x5,
    0xb,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0xb,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x8,
    0x0,
    0x5,
    0x0,
    0x0,
    0x5,
    0x4,
    0xa,
    0x0,
    0x0,
    0x9,
    0x0,
    0xa,
    0x5,
    0x8,
    0x1,
    0x0,
    0x1c,
    0x2,
    0x1,
    0x3,
    0x0,
    0x1a,
    0x9,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x1,
    0x3,
    0x0,
    0x5,
    0x4,
    0x4,
    0xe,
    0x0,
    0x9,
    0x1,
    0x8,
    0x2,
    0x0,
    0x0,
    0x4,
    0x3,
    0x0,
    0x4,
    0xf,
    0x1,
    0x0,
    0x2,
    0x3,
    0x6,
    0x0,
    0x0,
    0x2,
    0x0,
    0x10,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x4,
    0x0,
    0x7,
    0x2,
    0x5,
    0x1,
    0x6,
    0x0,
    0x4,
    0x3,
    0xa,
    0x1,
    0xa,
    0x1,
    0x0,
    0x7,
    0x2,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2b,
    0x8,
    0x1,
    0x0,
    0xe,
    0xa,
    0x0,
    0xb,
    0x0,
    0x0,
    0x4,
    0x1,
    0xb,
    0x6,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x6,
    0x2,
    0x2,
    0x0,
    0x1,
    0x1e,
    0x5,
    0xa,
    0x5,
    0x7,
    0x9,
    0x0,
    0x0,
    0x0,
    0xa,
    0x3,
    0x0,
    0x0,
    0x4,
    0x0,
    0x5,
    0x4,
    0x4,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x8,
    0x1,
    0x5,
    0x6,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x4,
    0x6,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x9,
    0x1,
    0xb,
    0x0,
    0x1,
    0x0,
    0x6,
    0x1,
    0x2,
    0x3,
    0x4,
    0x2,
    0x1,
    0x1,
    0x0,
    0x8,
    0x1,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x5,
    0xa,
    0x4,
    0x1,
    0x0,
    0x1,
    0x3,
    0x1,
    0x8,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x2,
    0xc,
    0x2,
    0x2,
    0x8,
    0xd,
    0x1,
    0x1,
    0x3,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x6,
    0x4,
    0x0,
    0x0,
    0x8,
    0x6,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0xb,
    0x3,
    0x8,
    0x5,
    0x3,
    0x0,
    0x0,
    0x0,
    0x2,
    0x7,
    0x1,
    0x5,
    0x0,
    0x0,
    0x3,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0xd,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x4,
    0x8,
    0x0,
    0x3,
    0x1,
    0x0,
    0x7,
    0x0,
    0x1,
    0x2,
    0x0,
    0x3,
    0x0,
    0x7,
    0x0,
    0x1,
    0x1,
    0x9,
    0x2,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0x2,
    0x0,
    0x1,
    0x4,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x7,
    0x6,
    0x3,
    0x0,
    0x1,
    0x1,
    0x2,
    0x7,
    0x2,
    0x0,
    0x3,
    0x0,
    0x5,
    0x3,
    0x2,
    0x0,
    0x1,
    0x2,
    0x1,
    0x2,
    0x3,
    0x1,
    0x0,
    0x3,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x6,
    0x5,
    0xa,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x2,
    0x2,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x6,
    0x1,
    0x0,
    0x3,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x8,
    0x0,
    0x4,
    0x5,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x2,
    0x9,
    0x3,
    0x0,
    0x4,
    0x1,
    0x1,
    0xc,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0xa,
    0x9,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x8,
    0x0,
    0x8,
    0x2,
    0x5,
    0x6,
    0x3,
    0x1,
    0x0,
    0x6,
    0x0,
    0x6,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x4,
    0x0,
    0x7,
    0x3,
    0x0,
    0xb,
    0x1,
    0x0,
    0x4,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0x6,
    0x2,
    0x1,
    0x2,
    0x1,
    0x9,
    0x0,
    0x0,
    0x0,
    0x8,
    0x12,
    0x0,
    0x9,
    0x0,
    0x1,
    0x3,
    0x0,
    0x7,
    0x0,
    0x2,
    0x1,
    0x1,
    0x3,
    0x2,
    0x1,
    0x2,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x1,
    0x3,
    0x5,
    0x1,
    0x0,
    0x3,
    0x7,
    0x4,
    0x1,
    0x0,
    0x1,
    0x6,
    0x3,
    0x1,
    0x0,
    0x4,
    0x2,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x0,
    0x7,
    0x1,
    0x1,
    0x0,
    0x4,
    0x3,
    0x3,
    0x4,
    0x6,
    0x0,
    0x3,
    0x0,
    0x1,
    0x3,
    0x3,
    0x2,
    0x3,
    0x1,
    0x0,
    0x0,
    0x8,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x2,
    0x3,
    0x1,
    0x2,
    0x3,
    0x3,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0xe,
    0x4,
    0x5,
    0x3,
    0x0,
    0x0,
    0x3,
    0x7,
    0x1,
    0x7,
    0x1,
    0x0,
    0x2,
    0x0,
    0x3,
    0x3,
    0x2,
    0x3,
    0x3,
    0x5,
    0x1,
    0x4,
    0x3,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x3,
    0x6,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x2,
    0x6,
    0x3,
    0x6,
    0x4,
    0x3,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x2,
    0x2,
    0x4,
    0x1,
    0x2,
    0x1,
    0x0,
    0x8,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x3,
    0x1,
    0x7,
    0x6,
    0x3,
    0x9,
    0x0,
    0x0,
    0x1,
    0x0,
    0x5,
    0x4,
    0x0,
    0x0,
    0x0,
    0x3,
    0x6,
    0x0,
    0x1,
    0x4,
    0x8,
    0x0,
    0x0,
    0x5,
    0x0,
    0x3,
    0x3,
    0x1,
    0x4,
    0x1,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x2,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x3,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x2,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x3,
    0x4,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x5,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x5,
    0x0,
    0x4,
    0x2,
    0x1,
    0x4,
    0x3,
    0x1,
    0x0,
    0x1,
    0x2,
    0x4,
];
pub(crate) const TRAILING_NONSTARTERS_KV: &[u32] = &[
    0x4EE01,
    0x1E4B01,
    0x1F1D02,
    0x1E3C01,
    0x224901,
    0x1FB101,
    0x1E6902,
    0xFE8401,
    0x1E1A01,
    0x22901,
    0xFC6202,
    0xFE7101,
    0x1E5A01,
    0xEC01,
    0x15001,
    0x1E8901,
    0x21CF01,
    0x1F1101,
    0x1E5002,
    0x1E7201,
    0x1FB901,
    0x34301,
    0x1FD901,
    0x1FF801,
    0x1F8C03,
    0xDA01,
    0x1E5302,
    0x1FA203,
    0x1FC202,
    0x334E01,
    0x1F4502,
    0x12B01,
    0xFB4401,
    0x220401,
    0x13E01,
    0x12901,
    0x1E9301,
    0x1F001,
    0x307701,
    0xFE7D01,
    0x21B01,
    0x1EA802,
    0x1E6402,
    0x40301,
    0x95801,
    0x1E3902,
    0x30AC01,
    0x1F3502,
    0x4F501,
    0x1E7101,
    0x4E701,
    0x10801,
    0x334B01,
    0x14E01,
    0x1EC901,
    0x1FA02,
    0x4ED01,
    0x4EB01,
    0x21701,
    0x1FD001,
    0x14601,
    0x1D101,
    0x34101,
    0x1E3401,
    0x304C01,
    0xE901,
    0x1F9403,
    0x330701,
    0x1E4001,
    0x1E3601,
    0x1E3101,
    0x22AD01,
    0x1E0701,
    0x1F5202,
    0xF601,
    0x1FEB01,
    0x1EE501,
    0x1F7201,
    0x1EAF02,
    0x1F6D02,
    0x1E2201,
    0x1EEA02,
    0x1E4D02,
    0xA3301,
    0x4F901,
    0x17401,
    0x11D01,
    0xFB3601,
    0x305C01,
    0x12201,
    0x1F8802,
    0x1E5D02,
    0x1EC102,
    0x13D01,
    0x1EF102,
    0x30F401,
    0x40701,
    0x1FA802,
    0x1EB402,
    0x1E5801,
    0x1E0501,
    0xE001,
    0xFB3301,
    0xEB01,
    0xA5E01,
    0x1F3202,
    0x20A01,
    0x20801,
    0x1FF702,
    0x1FC901,
    0x228001,
    0xE401,
    0x1F2101,
    0x21CE01,
    0xCB01,
    0x1F9F03,
    0x14301,
    0x306701,
    0x1E601,
    0x1E4601,
    0x45D01,
    0x1E1001,
    0x1E4801,
    0x1FF402,
    0x30D701,
    0x22E301,
    0x1EB801,
    0x12C01,
    0x331E01,
    0x1F7001,
    0x1F5D02,
    0x21901,
    0x10D01,
    0x1FB402,
    0xA801,
    0x1FE801,
    0x15401,
    0x4D301,
    0xFC01,
    0x1EE401,
    0x1F0901,
    0x16B01,
    0x1E1201,
    0x1E2E02,
    0x4C201,
    0xFB1F01,
    0x1F5602,
    0x4DA01,
    0x1EC02,
    0x228801,
    0x1ECB01,
    0x16101,
    0x1E9101,
    0x1ECE01,
    0x1F8002,
    0x307401,
    0xFE4901,
    0x307101,
    0x1D16202,
    0x1FC001,
    0x3CB01,
    0x1FCF02,
    0x1FBF01,
    0x1FBD01,
    0xFB3501,
    0x1D15E01,
    0xFE7F01,
    0x22E01,
    0x1E7701,
    0xFBB001,
    0xE101,
    0x30B001,
    0x22EA01,
    0x1F3F02,
    0x1C601,
    0x1E1E01,
    0x9DC01,
    0x1F6302,
    0x1FC01,
    0x4D001,
    0x1FDE02,
    0x1E1301,
    0x1FCE02,
    0x4F101,
    0x228101,
    0x1F0101,
    0xFB1D01,
    0xDB01,
    0x1E8701,
    0x224101,
    0xFB3A01,
    0x40101,
    0x1FC402,
    0xFE7B01,
    0x30BA01,
    0xFBA501,
    0x30F701,
    0x1FF301,
    0x14C01,
    0x1D16302,
    0x15701,
    0x17801,
    0x1F7901,
    0x306201,
    0x1EAE02,
    0x30B801,
    0x1F2302,
    0x1F4D02,
    0x17C01,
    0x15601,
    0x22D02,
    0xFC9001,
    0x1E3B01,
    0x1E6A01,
    0x1EBE02,
    0x17301,
    0x22ED01,
    0x10E01,
    0x1E8A01,
    0x1F6B02,
    0x6C201,
    0xFEF901,
    0x1EB901,
    0x1EB102,
    0x1F5702,
    0x1F0D02,
    0x305A01,
    0x1FD702,
    0x30AE01,
    0x1E2001,
    0x17601,
    0xFB3401,
    0x1F8E03,
    0xFB4D01,
    0xFE8101,
    0x1E6101,
    0x1FE302,
    0x1D201,
    0x1FA403,
    0x1EE002,
    0x1F7A01,
    0xFB2F01,
    0x1F5502,
    0xFEFA01,
    0x1D602,
    0xFA01,
    0xFE8501,
    0x22F01,
    0x4DB01,
    0x1E5F01,
    0x1E2701,
    0x39002,
    0x41901,
    0x30F801,
    0x16C01,
    0x12401,
    0xC701,
    0x1F9503,
    0x228401,
    0x1E8C01,
    0xF7502,
    0x1FC301,
    0x1F7C01,
    0xFE7201,
    0x20C01,
    0xFB4901,
    0x1FBB01,
    0x10F01,
    0x1FB601,
    0x1F8902,
    0x1FF01,
    0x1F2402,
    0x1F5302,
    0x1E1702,
    0x1D802,
    0x309E01,
    0xFE7A01,
    0x305E01,
    0x226E01,
    0x1FE702,
    0x1EBF02,
    0x1F3801,
    0x1E3201,
    0x1FFB01,
    0x1E6B01,
    0x1F9D03,
    0x222401,
    0x201701,
    0xF7601,
    0x1FCC01,
    0x1FA002,
    0x1F7401,
    0x1F2C02,
    0x40D01,
    0x1EEE02,
    0x15C01,
    0xE301,
    0xCC01,
    0xFB3801,
    0x333201,
    0x1E7501,
    0x334001,
    0x11501,
    0x1E3001,
    0x34402,
    0x17701,
    0x1E9201,
    0x1E2D01,
    0xCA01,
    0x1E7D01,
    0x13001,
    0x1F6801,
    0x3AA01,
    0x309C01,
    0x1F4001,
    0x3AC01,
    0x1EBA01,
    0x43901,
    0xFB4C01,
    0x1E201,
    0x1109A01,
    0x1DB02,
    0x1E4101,
    0x1FE001,
    0xCE01,
    0x21F01,
    0x4DF01,
    0x47701,
    0x1F0302,
    0x3D401,
    0x23201,
    0x1E1101,
    0x1FD202,
    0x14401,
    0x1F4C02,
    0x1EF301,
    0x10C01,
    0x30D001,
    0x1E4C02,
    0x1E2C01,
    0x1F1C02,
    0xFC5F02,
    0x1FE101,
    0x1EC502,
    0x22801,
    0x22E101,
    0x1EC002,
    0xEA01,
    0x1E0802,
    0x95A01,
    0x1F8303,
    0x1EE302,
    0x306901,
    0x17101,
    0x1E1602,
    0x212B01,
    0x1E6001,
    0x22EC01,
    0x219B01,
    0x1E8F01,
    0x1F4302,
    0x4E501,
    0x1FA303,
    0x1F3C02,
    0x16D01,
    0x30BE01,
    0x1FA603,
    0x1E9601,
    0xFD01,
    0x1F0602,
    0x1ED402,
    0x1D502,
    0x1A001,
    0x222601,
    0x9DF01,
    0xFB3201,
    0xFB4701,
    0x1E6301,
    0x1DC02,
    0x1E4701,
    0x30BC01,
    0x1D1BB01,
    0x1FC702,
    0x1D1BC01,
    0x309B01,
    0xF7702,
    0xFF9E01,
    0x1EA702,
    0x95901,
    0xE501,
    0x30B601,
    0xFCF402,
    0x21601,
    0x4EA01,
    0x20501,
    0x4F001,
    0xC4801,
    0x14701,
    0x1EF801,
    0x1F5B02,
    0x1EA001,
    0xE201,
    0x1F9303,
    0x1F5901,
    0xFB4B01,
    0x1F3001,
    0x1E8401,
    0x62401,
    0x1F9703,
    0xDC01,
    0x1E8B01,
    0x1EDF02,
    0x3B002,
    0x1C401,
    0x1ED502,
    0x1F2901,
    0x1F7D01,
    0x1EE902,
    0x30DA01,
    0xD201,
    0x1F6A02,
    0x1EA402,
    0x1EB01,
    0xFEF801,
    0x93101,
    0x307601,
    0x1F0A02,
    0x1F2702,
    0x1FD601,
    0x3AB01,
    0x1E0101,
    0xFB2C02,
    0x11C01,
    0x203E01,
    0x16001,
    0x21001,
    0x1E0B01,
    0xFE8901,
    0x1E1C02,
    0x1E1801,
    0x1F9102,
    0x1E9501,
    0x11901,
    0x45C01,
    0x30DC01,
    0xFB2D02,
    0x22B02,
    0x2D901,
    0x1D001,
    0xDDA01,
    0x15D01,
    0x1E6E01,
    0x1EA602,
    0x1E4A01,
    0x1EDA02,
    0x306501,
    0x4F401,
    0x306001,
    0x110AB01,
    0x228501,
    0x1E8E01,
    0x227801,
    0x4F301,
    0x1F0502,
    0x1F7101,
    0x1E5C02,
    0xAF01,
    0x1EC302,
    0xFE8C01,
    0x1E8501,
    0x1F9802,
    0x1EA01,
    0xFB4801,
    0xC801,
    0xFE7901,
    0x62501,
    0x16501,
    0xF101,
    0x11601,
    0x1FDF02,
    0x1FEC01,
    0x1F3E02,
    0x331001,
    0xE701,
    0x1FB202,
    0x22601,
    0x6D301,
    0x1EAA02,
    0x1E1B01,
    0x12301,
    0x1F7701,
    0x1FAD03,
    0x1EDC02,
    0x11401,
    0x1F8B03,
    0x14501,
    0x1FBC01,
    0x1E7902,
    0x95F01,
    0x1F2801,
    0xDDD01,
    0x1FFA01,
    0x1CD01,
    0xFE4A01,
    0xFE7E01,
    0x1AF01,
    0x17E01,
    0x1F8603,
    0x227401,
    0x1FB301,
    0x13401,
    0xFB4A01,
    0x1F2502,
    0x1FD302,
    0x1F21301,
    0x20B01,
    0x38C01,
    0xFE8701,
    0x1F3101,
    0x1F1402,
    0x1E1F01,
    0x1FB02,
    0x1E7E01,
    0x1E0201,
    0xFE4B01,
    0xD901,
    0x1F0001,
    0xF7302,
    0xC501,
    0x4E401,
    0xFCF302,
    0x1F5101,
    0x1FE601,
    0x30C001,
    0x4F801,
    0x12801,
    0x1EB202,
    0x1E0A01,
    0x1E0C01,
    0x1E4401,
    0xEE01,
    0x30C201,
    0x16F01,
    0x1EA502,
    0x30FA01,
    0x1EB502,
    0x1D1BE02,
    0x22E001,
    0x22E201,
    0x1D1C002,
    0x1EC402,
    0x1F6702,
    0x30FE01,
    0x1F3402,
    0xFE7001,
    0x1E2101,
    0x1F5F02,
    0x220C01,
    0x1D902,
    0x1E0601,
    0x13B01,
    0x1ED802,
    0x1EEB02,
    0xC201,
    0x45001,
    0x1FDD02,
    0x1E7601,
    0x1D16402,
    0x1B001,
    0x20401,
    0x11201,
    0x21301,
    0x3D301,
    0x1EC202,
    0x1EAB02,
    0x1FAE03,
    0x1EE01,
    0x1ED602,
    0x1E3701,
    0x309401,
    0xD401,
    0x1E5E01,
    0x1E0D01,
    0x30D601,
    0x1ED702,
    0x1F5001,
    0x1D401,
    0x1FFD01,
    0xFB3C01,
    0x1E8D01,
    0x21501,
    0x3AF01,
    0x224701,
    0x1ECA01,
    0x305801,
    0x1E7F01,
    0x22AC01,
    0x15B01,
    0x4D601,
    0x17A01,
    0x1ED02,
    0x1E6702,
    0x1E2801,
    0x20D01,
    0x1EBD01,
    0x1FD01,
    0xFB2E01,
    0x1E4501,
    0x1EF701,
    0x45E01,
    0x1F3B02,
    0x20001,
    0x1FCD02,
    0x38502,
    0x13601,
    0x20301,
    0x21201,
    0x1E9B01,
    0x1F401,
    0x1E8001,
    0x1FC102,
    0x1F7601,
    0x3CA01,
    0x16301,
    0x1FCB01,
    0x95C01,
    0x21101,
    0x1EF901,
    0x1E7B02,
    0x1E901,
    0x1E1D02,
    0x1EDE02,
    0x15F01,
    0x1F6402,
    0x10001,
    0x20F01,
    0x1E6602,
    0x40E01,
    0x38E01,
    0x1F0801,
    0x11801,
    0xFB3101,
    0x1D702,
    0x1ED102,
    0x305201,
    0x1E2A01,
    0x227001,
    0x1F8503,
    0x1FFE01,
    0x1EF002,
    0x4DD01,
    0x95D01,
    0x1F6502,
    0xF401,
    0x4D701,
    0x38601,
    0x2D801,
    0x1EC801,
    0x45701,
    0xFF01,
    0x22AF01,
    0x1EBC01,
    0x11E01,
    0x45301,
    0xFE7801,
    0x21E01,
    0xB5D01,
    0x12A01,
    0xF501,
    0xD301,
    0x1E6502,
    0x21A01,
    0x1F6E02,
    0x1FB001,
    0x62201,
    0x333B01,
    0x30D301,
    0x1EA101,
    0x226F01,
    0x1E0E01,
    0x15E01,
    0x1FF202,
    0x21801,
    0x1F8203,
    0x20901,
    0x1FD101,
    0x2DB01,
    0xF201,
    0xF7902,
    0xA5A01,
    0x1F0E02,
    0x1F1801,
    0x307C01,
    0xFC5C01,
    0x2ADC01,
    0xE801,
    0x15801,
    0x1FDB01,
    0x1F6C02,
    0x1EB002,
    0x1E2301,
    0x1F1502,
    0x11F01,
    0xFC6002,
    0x1FA902,
    0x1E5501,
    0x23102,
    0x1FE01,
    0x1E3D01,
    0x21AE01,
    0xFD3C01,
    0x38401,
    0x1EE701,
    0x13701,
    0xFB3001,
    0xEF01,
    0x1FA703,
    0x10A01,
    0x1F2B02,
    0x1D16002,
    0xF901,
    0xFEF501,
    0x40C01,
    0x22A02,
    0xF301,
    0x12D01,
    0x1F9A03,
    0x1E4201,
    0x1E102,
    0xA5B01,
    0x1EAC02,
    0x1E1502,
    0x1F9E03,
    0x1FD801,
    0x1F4A02,
    0x20201,
    0x1E9801,
    0x1E2401,
    0x1EE601,
    0x304E01,
    0x1E6C01,
    0xFE8A01,
    0xFB4001,
    0x1F2D02,
    0xFD3D01,
    0x1FC801,
    0x1FB801,
    0x1F3D02,
    0x1EF501,
    0x13901,
    0x1E8101,
    0x1F9C03,
    0x10301,
    0xA5901,
    0x1F9002,
    0x1ED902,
    0x1EF201,
    0x4E301,
    0xFEF701,
    0x1ECD01,
    0x11A01,
    0xFB2A01,
    0x1E301,
    0x1F6602,
    0x1FB702,
    0x1E2501,
    0x30C701,
    0x1F8102,
    0xCF01,
    0x1EEF02,
    0x1E9701,
    0x1F6F02,
    0x1F2A02,
    0x10901,
    0x1E5601,
    0x1E0001,
    0xFB4E01,
    0x1FC601,
    0xC001,
    0x220901,
    0xFE8801,
    0x1CE01,
    0xED01,
    0x15901,
    0x15A01,
    0x37A01,
    0x227501,
    0xD501,
    0x4C101,
    0x1E1901,
    0x30D101,
    0x10701,
    0x1FAC03,
    0x1EA301,
    0x1F2E02,
    0x14D01,
    0x1F4901,
    0x1E8801,
    0x1EB302,
    0x20701,
    0x1F7801,
    0x1F8D03,
    0xFBA401,
    0x1F9902,
    0x38801,
    0x1F2001,
    0xFB4101,
    0x1EC602,
    0x40001,
    0x1EB602,
    0x1E2B01,
    0x1E3A01,
    0x1C501,
    0x16201,
    0x17D01,
    0x1E8201,
    0x1F1B02,
    0x17001,
    0x224401,
    0x23301,
    0x1E2601,
    0x1F3302,
    0x10401,
    0x30D901,
    0x30F901,
    0x1F8A03,
    0x93401,
    0x3CD01,
    0x1FFC01,
    0x10101,
    0x1F5402,
    0xFB4601,
    0x3AD01,
    0x1F0402,
    0x1FF601,
    0x30B201,
    0x1F1001,
    0x1E7301,
    0x20E01,
    0x1E0301,
    0x1F6901,
    0xFEF601,
    0x95B01,
    0x227101,
    0x22701,
    0x1E3501,
    0x34001,
    0x1F0B02,
    0x1E701,
    0x1ED302,
    0x1F8403,
    0x1F2F02,
    0x1E8301,
    0x1F6001,
    0x62301,
    0xFC5D01,
    0x226001,
    0x22C02,
    0x1E3F01,
    0x1F7501,
    0x226201,
    0x1FDA01,
    0x20601,
    0xFE7701,
    0x305601,
    0x12101,
    0x1F2602,
    0x1E9001,
    0x95E01,
    0x12F01,
    0x1F9603,
    0x1E4901,
    0x10B01,
    0x1DF02,
    0x1D16102,
    0xFB2B01,
    0x1E0902,
    0x11701,
    0xFF9F01,
    0x1F7B01,
    0x1E9901,
    0x1F9203,
    0x1FCA01,
    0xB801,
    0x1A101,
    0x1F3901,
    0xFE7401,
    0xFC6102,
    0x1E5B01,
    0x92901,
    0xFE8301,
    0x1FE202,
    0x305401,
    0x1CF01,
    0x2DC01,
    0xFB01,
    0x307A01,
    0xFB3901,
    0x17501,
    0x305001,
    0x1E801,
    0x1FE901,
    0x1D301,
    0x307D01,
    0x1E2F02,
    0xFE4C01,
    0xF8102,
    0x1FA503,
    0x1FAB03,
    0x1EDB02,
    0x1F4801,
    0x1EED02,
    0x1F4402,
    0x1DA02,
    0xD101,
    0x1E6802,
    0x2DA01,
    0x30B401,
    0x1ECF01,
    0x1E5901,
    0x1E002,
    0x1E5701,
    0x1F0F02,
    0x17201,
    0x1FEE02,
    0x1E5401,
    0xC901,
    0xA3601,
    0x228901,
    0x1ECC01,
    0xB401,
    0x16901,
    0x1EF601,
    0x10501,
    0x1E7C01,
    0x1F8F03,
    0x1E3301,
    0x14F01,
    0x1EE802,
    0x1F4202,
    0x1E3E01,
    0xFC6302,
    0x1F501,
    0x16401,
    0x4F201,
    0x1F0202,
    0x1E0F01,
    0x1FEA01,
    0x1F1901,
    0xFC5B01,
    0x1D1BD02,
    0xC101,
    0x38A01,
    0x1EE102,
    0xD601,
    0x1E7802,
    0x1F7301,
    0x1E7A02,
    0x1EA902,
    0xFCD901,
    0x1F9B03,
    0x1F2202,
    0x10601,
    0x38F01,
    0xF7801,
    0x1D15F01,
    0x1F8703,
    0x1FE501,
    0x1EE202,
    0x1F801,
    0x307901,
    0xFE8201,
    0x1ED002,
    0x4E201,
    0x13501,
    0x1109C01,
    0xFCF202,
    0x1E6F01,
    0x21CD01,
    0x1EB702,
    0x4EF01,
    0x1E6201,
    0x1EDD02,
    0xFC5E02,
    0xDD01,
    0x1F6202,
    0x1F4B02,
    0x4E601,
    0x14801,
    0x1F3A02,
    0x1FAF03,
    0xC401,
    0x1EEC02,
    0x1F4101,
    0x1EC702,
    0x4DC01,
    0x16E01,
    0x1F1A02,
    0x307301,
    0x22AE01,
    0x38901,
    0x23002,
    0x13C01,
    0x1FF901,
    0x1F0702,
    0x1EBB01,
    0x12501,
    0x1F1202,
    0x1E2901,
    0x1E4301,
    0x10201,
    0x330401,
    0x6C001,
    0x11301,
    0x1EA201,
    0x1F3702,
    0x1FED02,
    0x4D201,
    0xFFE301,
    0x30D401,
    0x15101,
    0x307001,
    0x3AE01,
    0x1F901,
    0x1FA102,
    0x1E9401,
    0x332101,
    0xC301,
    0x17901,
    0x1DE02,
    0xFB3E01,
    0x1E5102,
    0x4DE01,
    0x62601,
    0x3CC01,
    0x2DD01,
    0x1F6101,
    0x15501,
    0x3CE01,
    0x30C901,
    0x1E7001,
    0x227901,
    0x30C501,
    0x12001,
    0xFE8601,
    0x1E4F02,
    0x13A01,
    0x1E7401,
    0x1F1302,
    0x1D1BF02,
    0x11B01,
    0x9DD01,
    0x22EB01,
    0x1E6D01,
    0x1E5202,
    0x1ED202,
    0x1F3602,
    0x1EAD02,
    0x1FE401,
    0xB5C01,
    0x1FBA01,
    0x1E4E02,
    0x16801,
    0xFE7C01,
    0x1FAA03,
    0x1E0401,
    0x20101,
    0x1EF01,
    0x12E01,
    0x1F0C02,
    0x1E1402,
    0xFE7601,
    0x1E3802,
    0xFB3B01,
    0xCD01,
    0x226D01,
    0x4D101,
    0x1E8601,
    0x45101,
    0x17B01,
    0x47601,
    0x4EC01,
    0x21401,
    0x1EF401,
    0x16A01,
    0x30DD01,
    0xFE8B01,
    0xFBB101,
    0x219A01,
    0xFB4301,
];


