% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_handler-httr.R
\name{RequestHandlerHttr}
\alias{RequestHandlerHttr}
\title{RequestHandlerHttr}
\description{
Methods for the httr package, building on \link{RequestHandler}
}
\examples{
\dontrun{
vcr_configure(
 dir = tempdir(),
 record = "once"
)

# GET request
library(httr)
load("~/httr_req.rda")
req
x <- RequestHandlerHttr$new(req)
# x$handle()

# POST request
library(httr)
webmockr::httr_mock()
mydir <- file.path(tempdir(), "testing_httr")
invisible(vcr_configure(dir = mydir))
use_cassette(name = "testing2", {
  res <- POST("https://httpbin.org/post", body = list(foo = "bar"))
}, match_requests_on = c("method", "uri", "body"))

load("~/httr_req_post.rda")
insert_cassette("testing3")
httr_req_post
x <- RequestHandlerHttr$new(httr_req_post)
x
# x$handle()
self=x

}
}
\section{Super class}{
\code{\link[vcr:RequestHandler]{vcr::RequestHandler}} -> \code{RequestHandlerHttr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RequestHandlerHttr$new()}}
\item \href{#method-clone}{\code{RequestHandlerHttr$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="vcr" data-topic="RequestHandler" data-id="handle">}\href{../../vcr/html/RequestHandler.html#method-handle}{\code{vcr::RequestHandler$handle()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{RequestHandlerHttr} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestHandlerHttr$new(request)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request from an object of class \code{HttpInteraction}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RequestHandlerHttr} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestHandlerHttr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
