% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_draws.R
\name{bind_draws}
\alias{bind_draws}
\alias{bind_draws.draws_matrix}
\alias{bind_draws.draws_array}
\alias{bind_draws.draws_df}
\alias{bind_draws.draws_list}
\alias{bind_draws.draws_rvars}
\title{Bind \code{draws} objects together}
\usage{
bind_draws(x, ...)

\method{bind_draws}{draws_matrix}(x, ..., along = "variable")

\method{bind_draws}{draws_array}(x, ..., along = "variable")

\method{bind_draws}{draws_df}(x, ..., along = "variable")

\method{bind_draws}{draws_list}(x, ..., along = "variable")

\method{bind_draws}{draws_rvars}(x, ..., along = "variable")
}
\arguments{
\item{x}{(draws) A \code{\link{draws}} object. The draws format of \code{x} will define the
format of the returned draws object.}

\item{...}{(draws) Additional \code{\link{draws}} objects to bind to \code{x}.}

\item{along}{(string) The dimension along which draws objects should be bound
together. Possible values are \code{"variable"} (the default), \code{"chain"},
\code{"iteration"}, and \code{"draw"}. Not all options are supported for all input
formats.}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Bind multiple \code{\link{draws}} objects together to form a single \code{draws} object.
}
\examples{
x1 <- draws_matrix(alpha = rnorm(5), beta = rnorm(5))
x2 <- draws_matrix(alpha = rnorm(5), beta = rnorm(5))
ndraws(x1)
ndraws(x2)
x3 <- bind_draws(x1, x2, along = "draw")
ndraws(x3)

x4 <- draws_matrix(theta = rexp(5))
x5 <- bind_draws(x1, x4, along = "variable")
variables(x5)

}
