% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-cast.R
\name{as_rvar}
\alias{as_rvar}
\alias{as_rvar_numeric}
\alias{as_rvar_integer}
\alias{as_rvar_logical}
\title{Coerce to a random variable}
\usage{
as_rvar(x, dim = NULL, dimnames = NULL, nchains = NULL)

as_rvar_numeric(x, dim = NULL, dimnames = NULL, nchains = NULL)

as_rvar_integer(x, dim = NULL, dimnames = NULL, nchains = NULL)

as_rvar_logical(x, dim = NULL, dimnames = NULL, nchains = NULL)
}
\arguments{
\item{x}{(multiple options) An object that can be converted to an \code{\link{rvar}},
such as a vector, array, or an \code{\link{rvar}} itself.}

\item{dim}{(integer vector) One or more integers giving the maximal indices
in each dimension to override the dimensions of the \code{\link{rvar}} to be created
(see \code{\link[=dim]{dim()}}). If \code{NULL} (the default), \code{dim} is determined by the input.
\strong{NOTE:} This argument controls the dimensions of the \code{\link{rvar}}, not the
underlying array, so you cannot change the number of draws using this
argument.}

\item{dimnames}{(list) Character vectors giving the names in each dimension
to override the names of the dimensions of the \code{\link{rvar}} to be created (see
\code{\link[=dimnames]{dimnames()}}). If \code{NULL} (the default), this is determined by the input.
\strong{NOTE:} This argument controls the names of the dimensions of the
\code{\link{rvar}}, not the underlying array.}

\item{nchains}{(positive integer) The number of chains. The default is \code{1}.}
}
\value{
An object of class \code{"rvar"} (or one of its subtypes) representing a random variable.
}
\description{
Convert \code{x} to an \code{\link{rvar}} object.
}
\details{
For objects that are already \code{\link{rvar}}s, returns them (with modified dimensions
if \code{dim} is not \code{NULL}).

For numeric or logical vectors or arrays, returns an \code{\link{rvar}} with a single draw and
the same dimensions as \code{x}. This is in contrast to the \code{\link[=rvar]{rvar()}} constructor, which
treats the first dimension of \code{x} as the draws dimension. As a result, \code{as_rvar()}
is useful for creating constants.

While \code{as_rvar()} attempts to pick the most suitable subtype of \code{\link{rvar}} based on the
type of \code{x} (possibly returning an \code{\link{rvar_factor}} or \code{\link{rvar_ordered}}),
\code{as_rvar_numeric()}, \code{as_rvar_integer()}, and \code{as_rvar_logical()} always coerce
the draws of the output \code{\link{rvar}} to be \code{\link{numeric}}, \code{\link{integer}}, or \code{\link{logical}}
(respectively), and always return a base \code{\link{rvar}}, never a subtype.
}
\examples{

# You can use as_rvar() to create "constant" rvars (having only one draw):
x <- as_rvar(1)
x

# Such constants can be of arbitrary shape:
as_rvar(1:4)
as_rvar(matrix(1:10, nrow = 5))
as_rvar(array(1:12, dim = c(2, 3, 2)))

# as_rvar_numeric() coerces subtypes of rvar to the base rvar type
y <- as_rvar_factor(c("a", "b", "c"))
y
as_rvar_numeric(y)

}
\seealso{
\code{\link[=rvar]{rvar()}} to construct \code{\link{rvar}}s directly.  See \code{\link[=rdo]{rdo()}}, \code{\link[=rfun]{rfun()}}, and
\code{\link[=rvar_rng]{rvar_rng()}} for higher-level interfaces for creating \code{rvar}s.
}
