% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter}
\alias{filter}
\title{Return rows with matching conditions}
\usage{
filter(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{Logical predicated defined in terms of the variables in \code{.data}. Multiple conditions are combined with
\code{&}. Arguments within \code{...} are automatically quoted and evaluated within the context of the \code{data.frame}.}

\item{.preserve}{\code{logical(1)}. Relevant when the .data input is grouped. If \code{.preserve = FALSE} (the default), the
grouping structure is recalculated based on the resulting data, otherwise the grouping is kept as is.}
}
\value{
A \code{data.frame}.
}
\description{
Use \code{filter()} to choose rows/cases where conditions are \code{TRUE}.
}
\section{Useful filter functions}{

\itemize{
\item \code{==}, \code{>}, \code{>=}, etc.
\item \code{&}, \code{|}, \code{!}, \code{xor()}
\item \code{is.na()}
}
}

\examples{
filter(mtcars, am == 1)
mtcars \%>\% filter(cyl == 4)
mtcars \%>\% filter(cyl <= 5 & am > 0)
mtcars \%>\% filter(cyl == 4 | cyl == 8)
mtcars \%>\% filter(!(cyl \%in\% c(4, 6)), am != 0)

}
