% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pml_bb.R
\name{pml_bb}
\alias{pml_bb}
\title{Likelihood of a tree.}
\usage{
pml_bb(x, model = NULL, rearrangement = "stochastic",
  method = "unrooted", start = NULL, tip.dates = NULL, ...)
}
\arguments{
\item{x}{An alignment of class (either class \code{phyDat}, \code{DNAbin} or
\code{AAbin}) or an object of class \code{modelTest}.}

\item{model}{A string providing model (e.g. "GTR+G(4)+I"). Not necessary if
a modelTest object is supplied.}

\item{rearrangement}{Type of tree tree rearrangements to perform, one of
"none", "NNI", "stochastic" or "ratchet"}

\item{method}{One of "unrooted", "ultrametric" or "tiplabeled".}

\item{start}{A starting tree can be supplied.}

\item{tip.dates}{A named vector of sampling times associated to the tips /
sequences.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
\code{pml_bb} returns an object of class pml.
}
\description{
\code{pml_bb} for pml black box infers a phylogenetic tree infers a tree
using maximum likelihood (ML).
}
\details{
\code{pml_bb} is a convenience function combining \code{pml} and
\code{optim.pml}. If no tree is supplied, the function will generate a
starting tree. If a modelTest object is supplied the model will be chosen
according to BIC.

\code{tip.dates} should be a named vector of sampling times, in any time
unit, with time increasing toward the present. For example, this may be in
units of “days since study start” or “years since 10,000 BCE”, but not
“millions of years ago”.

\code{model} takes a string and tries to extract the model. When an
\code{modelTest} object the best BIC model is chosen by default.
The string should contain a substitution model (e.g. JC, GTR, WAG) and can
additional have  a term "+I" for invariant sites, "+G(4)" for a discrete
gamma model, "+R(4)" for a free rate model. In case of amino acid models
a term "+F" for estimating the amino acid frequencies. Whether nucleotide
frequencies are estimated is defined by \code{\link{pml.control}}.

Currently very experimental and likely to change.
}
\examples{

data(woodmouse)
tmp <- pml_bb(woodmouse, model="HKY+I", rearrangement="NNI")

\dontrun{
data(Laurasiatherian)
mt <- modelTest(Laurasiatherian)
fit <- pml_bb(mt)

# estimate free rate model with 2 rate categories
fit_HKY_R2 <- pml_bb(woodmouse, model="HKY+R(2)")
}
}
\seealso{
\code{\link{optim.pml}}, \code{\link{modelTest}},
\code{\link[ape]{rtt}}, \code{\link{pml.control}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
