% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{mark}
\alias{mark}
\alias{mark_html}
\alias{mark_latex}
\title{Render Markdown to an output format}
\usage{
mark(
  file = NULL,
  output = NULL,
  text = NULL,
  format = c("html", "latex"),
  options = NULL,
  template = FALSE,
  meta = list()
)

mark_html(..., template = TRUE)

mark_latex(..., template = TRUE)
}
\arguments{
\item{file}{Path to an input file. If not provided, it is presumed that the
\code{text} argument will be used instead. This argument can also take a
character vector of Markdown text directly. To avoid ambiguity in the
latter case, a single character string input will be treated as a file if
the file exists. If a string should be treated as Markdown text when it
happens to be a file path, wrap it in \code{\link[=I]{I()}}.}

\item{output}{Output file path. If not character, the results will be
returned as a character vector. If not specified and the input is a file
path, the output file path will have the same base name as the input file,
with an extension corresponding to the \code{format} argument, e.g.,
\code{mark('foo.md', format = 'latex')} will generate an output file
\file{foo.tex} by default.}

\item{text}{A character vector of the Markdown text. By default, it is read
from \code{file}.}

\item{format}{An output format supported by \pkg{commonmark}, e.g., \code{'html'},
\code{'man'}, and \code{'text'}, etc. See the
\code{\link[commonmark:commonmark]{markdown_*()}} renderers in \pkg{commonmark}.}

\item{options}{Options to be passed to the renderer. See \code{\link[=markdown_options]{markdown_options()}}
for details. This argument can take either a character vector of the form
\code{"+option1 option2-option3"} (use \code{+} or a space to enable an option, and
\code{-} to disable an option), or a list of the form \code{list(option1 = value1, option2 = value2, ...)}. A string \code{"+option1"} is equivalent to
\code{list(option1 = TRUE)}, and \code{"-option2"} means \code{list(option2 = FALSE)}.
Options that do not take logical values must be specified via a list, e.g.,
\code{list(width = 30)}.}

\item{template}{Path to a template file. The default value is
\code{getOption('markdown.FORMAT.template', markdown:::pkg_file('resources', 'markdown.FORMAT'))} where \code{FORMAT} is the output format name (\code{html} or
\code{latex}). It can also take a logical value: \code{TRUE} means to use the default
template, and \code{FALSE} means to generate only a fragment without using any
template.}

\item{meta}{A named list of metadata. Elements in the metadata will be used
to fill out the template by their names and values, e.g., \code{list(title = ...)} will replace the \verb{$title$} variable in the template. See the Section
\dQuote{YAML metadata} in the vignette \code{vignette('intro', package = 'markdown')} for supported variables.}

\item{...}{Arguments to be passed to \code{mark()}.}
}
\value{
Invisible \code{NULL} when output is to a file, otherwise a character
vector of the rendered output.
}
\description{
Render Markdown to an output format via the \pkg{commonmark} package. The
function \code{mark_html()} is a shorthand of \code{mark(format = 'html', template = TRUE)}, and \code{mark_latex()} is a shorthand of \code{mark(format = 'latex', template = TRUE)}.
}
\examples{
library(markdown)
mark(c("Hello _World_!", "", "Welcome to **markdown**."))
# a few corner cases
mark(character(0))
mark("")
# if input happens to be a file path but should be treated as text, use I()
mark(I("This is *not* a file.md"))
# that's equivalent to
mark(text = "This is *not* a file.md")

mark_html("Hello _World_!", template = FALSE)
# write HTML to an output file
mark_html("_Hello_, **World**!", output = tempfile())

mark_latex("Hello _World_!", template = FALSE)
}
\seealso{
The spec of GitHub Flavored Markdown:
\url{https://github.github.com/gfm/}
}
