% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit.R
\name{editing}
\alias{editing}
\alias{image_read}
\alias{image_read_svg}
\alias{image_read_pdf}
\alias{image_read_video}
\alias{image_write}
\alias{image_convert}
\alias{image_data}
\alias{image_raster}
\alias{image_display}
\alias{image_browse}
\alias{image_strip}
\alias{image_blank}
\alias{image_destroy}
\alias{image_join}
\alias{image_attributes}
\alias{demo_image}
\title{Image Editing}
\usage{
image_read(path, density = NULL, depth = NULL, strip = FALSE)

image_read_svg(path, width = NULL, height = NULL)

image_read_pdf(path, pages = NULL, density = 300, password = "")

image_read_video(path, fps = 1, format = "png")

image_write(
  image,
  path = NULL,
  format = NULL,
  quality = NULL,
  depth = NULL,
  density = NULL,
  comment = NULL,
  flatten = FALSE
)

image_convert(
  image,
  format = NULL,
  type = NULL,
  colorspace = NULL,
  depth = NULL,
  antialias = NULL,
  matte = NULL
)

image_data(image, channels = NULL, frame = 1)

image_raster(image, frame = 1, tidy = TRUE)

image_display(image, animate = TRUE)

image_browse(image, browser = getOption("browser"))

image_strip(image)

image_blank(width, height, color = "none", pseudo_image = "")

image_destroy(image)

image_join(...)

image_attributes(image)

demo_image(path)
}
\arguments{
\item{path}{a file, url, or raster object or bitmap array}

\item{density}{resolution to render pdf or svg}

\item{depth}{color depth (either 8 or 16)}

\item{strip}{drop image comments and metadata}

\item{width}{in pixels}

\item{height}{in pixels}

\item{pages}{integer vector with page numbers. Defaults to all pages.}

\item{password}{user \link[pdftools:pdf_render_page]{password} to open protected pdf files}

\item{fps}{how many images to capture per second of video. Set to
\code{NULL} to get all frames from the input video.}

\item{format}{output format such as \code{"png"}, \code{"jpeg"}, \code{"gif"}, \code{"rgb"} or \code{"rgba"}.}

\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{quality}{number between 0 and 100 for jpeg quality. Defaults to 75.}

\item{comment}{text string added to the image metadata for supported formats}

\item{flatten}{should image be flattened before writing? This also replaces
transparency with background color.}

\item{type}{string with \href{https://www.imagemagick.org/Magick++/Enumerations.html#ImageType}{imagetype}
value from \link{image_types} for example \code{grayscale} to convert into black/white}

\item{colorspace}{string with a \href{https://www.imagemagick.org/Magick++/Enumerations.html#ColorspaceType}{\code{colorspace}}
from \link{colorspace_types} for example \code{"gray"}, \code{"rgb"} or \code{"cmyk"}}

\item{antialias}{enable anti-aliasing for text and strokes}

\item{matte}{set to \code{TRUE} or \code{FALSE} to enable or disable transparency}

\item{channels}{string with image channel(s) for example \code{"rgb"}, \code{"rgba"},
\code{"cmyk"},\code{"gray"}, or \code{"ycbcr"}. Default is either \code{"gray"}, \code{"rgb"} or \code{"rgba"}
depending on the image}

\item{frame}{integer setting which frame to extract from the image}

\item{tidy}{converts raster data to long form for use with \link[ggplot2:geom_raster]{geom_raster}.
If \code{FALSE} output is the same as \code{as.raster()}.}

\item{animate}{support animations in the X11 display}

\item{browser}{argument passed to \link[utils:browseURL]{browseURL}}

\item{color}{a valid \href{https://www.imagemagick.org/Magick++/Color.html}{color string} such as
\code{"navyblue"} or \code{"#000080"}. Use \code{"none"} for transparency.}

\item{pseudo_image}{string with \href{http://www.imagemagick.org/script/formats.php#pseudo}{pseudo image}
specification for example \code{"radial-gradient:purple-yellow"}}

\item{...}{several images or lists of images to be combined}
}
\description{
Read, write and join or combine images. All image functions are vectorized, meaning
they operate either on a single frame or a series of frames (e.g. a collage, video,
or animation). Besides paths and URLs, \code{\link[=image_read]{image_read()}} supports commonly used bitmap
and raster object types.
}
\details{
All standard base vector methods such as \link{[}, \link{[[}, \code{\link[=c]{c()}}, \code{\link[=as.list]{as.list()}},
\code{\link[=as.raster]{as.raster()}}, \code{\link[=rev]{rev()}}, \code{\link[=length]{length()}}, and \code{\link[=print]{print()}} can be used to work with magick
image objects. Use the standard \code{img[i]} syntax to extract a subset of the frames
from an image. The \code{img[[i]]} method is an alias for \code{\link[=image_data]{image_data()}} which extracts
a single frame as a raw bitmap matrix with pixel values.

For reading svg or pdf it is recommended to use \code{image_read_svg()} and \code{image_read_pdf()}
if the \link[rsvg:rsvg]{rsvg} and \link[pdftools:pdf_render_page]{pdftools} R packages are available.
These functions provide more rendering options and better quality than built-in svg/pdf
rendering delegates from imagemagick itself.

X11 is required for \code{image_display()} which is only works on some platforms. A more
portable method is \code{image_browse()} which opens the image in a browser. RStudio has
an embedded viewer that does this automatically which is quite nice.

Image objects are automatically released by the garbage collector when they are no longer
reachable. Because the GC only runs once in a while, you can also call \code{image_destroy()}
explicitly to release the memory immediately. This is usually only needed if you create
a lot of images in a short period of time, and you might run out of memory.
}
\examples{
# Download image from the web
frink <- image_read("https://jeroen.github.io/images/frink.png")
worldcup_frink <- image_fill(frink, "orange", "+100+200", 20)
image_write(worldcup_frink, "output.png")

# extract raw bitmap array
bitmap <- frink[[1]]

# replace pixels with #FF69B4 ('hot pink') and convert back to image
bitmap[,50:100, 50:100] <- as.raw(c(0xff, 0x69, 0xb4, 0xff))
image_read(bitmap)

# Plot to graphics device via legacy raster format
raster <- as.raster(frink)
par(ask=FALSE)
plot(raster)

# Read bitmap arrays from from other image packages
curl::curl_download("https://jeroen.github.io/images/example.webp", "example.webp")
if(require(webp)) image_read(webp::read_webp("example.webp"))
unlink(c("example.webp", "output.png"))
if(require(rsvg))
tiger <- image_read_svg("http://jeroen.github.io/images/tiger.svg")
if(require(pdftools))
image_read_pdf(file.path(R.home('doc'), 'NEWS.pdf'), pages = 1, density = 100)
# create a solid canvas
image_blank(600, 400, "green")
image_blank(600, 400, pseudo_image = "radial-gradient:purple-yellow")
}
\seealso{
Other image: 
\code{\link{_index_}},
\code{\link{analysis}},
\code{\link{animation}},
\code{\link{attributes}()},
\code{\link{color}},
\code{\link{composite}},
\code{\link{device}},
\code{\link{edges}},
\code{\link{effects}()},
\code{\link{fx}},
\code{\link{geometry}},
\code{\link{morphology}},
\code{\link{ocr}},
\code{\link{options}()},
\code{\link{painting}},
\code{\link{segmentation}},
\code{\link{transform}()},
\code{\link{video}}
}
\concept{image}
