% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_null_device.R
\name{set_null_device}
\alias{set_null_device}
\title{Sets the null graphics device}
\usage{
set_null_device(null_device)
}
\arguments{
\item{null_device}{Either a string that defines the null device ("pdf", "png", "cairo") or a function
that returns a new graphics device.}
}
\description{
The function \code{\link[=as_grob]{as_grob()}} needs to open a graphics device to render ggplot objects into
grid graphics objects. Unfortunately, there is no universally reliable graphics device available
in R that always works. Therefore, this function allows you to switch out the null device.
}
\details{
You need to be aware that some graphics devices cause side effects when used as null devices.
If you use an interactive device as null device, you may see an empty plot window pop up. Similarly,
if you use a graphics device that writes a file, then you may find temporary files associated
with the device. The default null device, \code{pdf(NULL)}, does not cause these side effects. However, it has
has other limitations. For example, on OS X, it cannot use all the fonts that are available on the
system. The png device can use all fonts, but it will create temporary files.
}
\examples{
set_null_device("png") # set the png null device

# create a jpeg null device
jpeg_null_device <- function(width, height) {
  jpeg(
    filename = tempfile(pattern = "jpeg_null_plot", fileext = ".jpg"),
    width = width, height = height, units = "in", res = 96
   )
  dev.control("enable")
}
set_null_device(jpeg_null_device)
}
\seealso{
Available null devices are: \code{\link[=pdf_null_device]{pdf_null_device()}}, \code{\link[=png_null_device]{png_null_device()}}, \code{\link[=cairo_null_device]{cairo_null_device()}}
}
