% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_qualitative.R
\name{scale_colour_discrete_qualitative}
\alias{scale_colour_discrete_qualitative}
\alias{scale_color_discrete_qualitative}
\alias{scale_fill_discrete_qualitative}
\title{HCL-Based Discrete Qualitative Color Scales for ggplot2}
\usage{
scale_colour_discrete_qualitative(
  palette = NULL,
  c1 = NULL,
  l1 = NULL,
  h1 = NULL,
  h2 = NULL,
  alpha = 1,
  rev = FALSE,
  nmax = NULL,
  order = NULL,
  aesthetics = "colour",
  ...
)

scale_color_discrete_qualitative(
  palette = NULL,
  c1 = NULL,
  l1 = NULL,
  h1 = NULL,
  h2 = NULL,
  alpha = 1,
  rev = FALSE,
  nmax = NULL,
  order = NULL,
  aesthetics = "colour",
  ...
)

scale_fill_discrete_qualitative(..., aesthetics = "fill")
}
\arguments{
\item{palette}{The name of the palette to be used. Run \code{hcl_palettes(type = "qualitative")} for available options.}

\item{c1}{Chroma value, used for all colors in the scale.}

\item{l1}{Luminance value, used for all colors in the scale.}

\item{h1}{Beginning hue value.}

\item{h2}{Ending hue value.}

\item{alpha}{Numeric vector of values in the range \code{[0, 1]} for alpha transparency channel (0 means transparent and 1 means opaque).}

\item{rev}{If \code{TRUE}, reverses the order of the colors in the color scale.}

\item{nmax}{Maximum number of different colors the palette should contain. If not provided, is calculated automatically
from the data.}

\item{order}{Numeric vector listing the order in which the colors should be used. Default is \code{1:nmax}.}

\item{aesthetics}{The ggplot2 aesthetics to which this scale should be applied.}

\item{...}{common discrete scale parameters: \code{name}, \code{breaks}, \code{labels}, \code{na.value}, \code{limits} and \code{guide}. See
\code{\link[ggplot2]{discrete_scale}} for more details.}
}
\description{
Discrete ggplot2 color scales using the color palettes generated by \code{\link{qualitative_hcl}}.
}
\details{
If both a valid palette name and palette parameters are provided then the provided palette parameters overwrite the parameters in the
named palette. This enables easy customization of named palettes.
}
\examples{
library("ggplot2")

# default colors
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point() + theme_minimal() +
  scale_color_discrete_qualitative()
 
# color scale "Harmonic"
ggplot(iris, aes(Sepal.Length, fill = Species)) +
  geom_density(alpha = 0.7) + scale_fill_discrete_qualitative(palette = "Harmonic")
}
