% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsetSamples.R
\name{upsetSamples}
\alias{upsetSamples}
\title{Create a generalized Venn Diagram analog for sample membership in multiple
assays, using the upset algorithm in \code{UpSetR}}
\usage{
upsetSamples(
  MultiAssayExperiment,
  nsets = length(MultiAssayExperiment),
  nintersects = 24,
  order.by = "freq",
  nameFilter = force,
  check.names = FALSE,
  ...
)
}
\arguments{
\item{MultiAssayExperiment}{A
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
instance}

\item{nsets}{integer number of sets to analyze}

\item{nintersects}{Number of intersections to plot. If set to NA, all
intersections will be plotted.}

\item{order.by}{How the intersections in the matrix should be ordered by.
Options include frequency (entered as "freq"), degree, or both in any order.}

\item{nameFilter}{function, defaulting to force, to manipulate colnames of
incidence matrix}

\item{check.names}{logical(1) used when incidence matrix is coerced to
data.frame for use in UpSetR::upset}

\item{...}{parameters passed to \code{\link[UpSetR]{upset}}}
}
\value{
Produces a visualization of set intersections using the UpSet matrix
design
}
\description{
Create a generalized Venn Diagram analog for sample membership in multiple
assays, using the upset algorithm in \code{UpSetR}
}
\note{
This function is intended to provide convenient visualization of assay
availability configurations in MultiAssayExperiment instances. The
\code{\link[UpSetR]{upset}} function requires data.frame input and has
many parameters to tune appearance of the result. Assay name handling is
important for interpretability, and the \code{nameFilter} parameter may be
useful to simplify resulting outputs.
}
\examples{
data(miniACC)
upsetSamples(miniACC)
upsetSamples(miniACC, nameFilter = function(x) substr(x, 1, 5))

}
\author{
Vincent J Carey
}
