% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareModels.R
\name{compareFactors}
\alias{compareFactors}
\title{Correlation of the latent factors across different trials}
\usage{
compareFactors(models, comparison = "all", show_rownames = FALSE,
  show_colnames = FALSE, ...)
}
\arguments{
\item{models}{a list containing \code{\link{MOFAmodel}} objects.}

\item{comparison}{type of comparison, either 'pairwise', i.e. compare one model
with another one at a time, or 'all', i.e. calculate correlation between factors from all model.
By default, all models are compared.}

\item{show_rownames}{logical indicating whether to show rownames in heatmap (see also pheatmap documentation)}

\item{show_colnames}{logical indicating whether to show colnames in heatmap (see also pheatmap documentation)}

\item{...}{extra arguments passed to pheatmap}
}
\value{
Plots a heatmap of correlation of Latent Factors in all models when 'comparison' is 'all'. 
Otherwise, for each pair of models, a seperate heatmap is produced comparing one model againt the other.
The corresponding correlation matrix or list or pairwise correlation matrices is returned
}
\description{
Different objects of \code{\link{MOFAmodel}} are compared in terms of correlation between 
their latent factors. The correlation is calculated only on those samples which are present in all models.
Ideally, the output should look like a block diagonal matrix, suggesting that
 all detected factors are robust under different initializations.
If not, it suggests that some factors are weak and not captured by all models.
}
\details{
This function can be helpful to evaluate the robustness of factors across
 different random initilizations. 
Large block of factors from different models in the correlation matrix show consistent factors,
 while stand-alone factors that are only recovered in a single model instance are less reliable.
}
\examples{
### Example on simulated data
# Simulate Data
data <- makeExampleData()
# Create MOFA model
MOFAobject <- createMOFAobject(data)
# Prepare MOFA model
MOFAobject <- prepareMOFA(MOFAobject)
# Train several instances of MOFA models
n_inits <- 3 
MOFAlist <- lapply(seq_len(n_inits), function(i) runMOFA(MOFAobject, outfile=tempfile()))
compareFactors(MOFAlist, comparison="all")
compareFactors(MOFAlist, comparison="pairwise")
}
