## test_getBroadSets1 <- function() {
##     ## correct class creation, length, names
##     gsc <- getBroadSets(system.file("extdata", "Broad.xml", package="GSEABase"))
##     checkTrue(is(gsc, "GeneSetCollection"))
##     checkEquals(2, length(gsc))
##     checkTrue(all(names(gsc)==c("chr5q23", "chr16q24")))
## }

test_getBroadSets2 <- function() {
    ## details correct
    .broadXML <- list(c("<?xml version=\"1.0\" encoding=\"UTF-8\"?>",
                        "<MSIGDB NAME=\"chr16q24\" VERSION=\"1\" BUILD_DATE=\"1\">",
                        "<GENESET STANDARD_NAME=\"chr16q24\" SYSTEMATIC_NAME=\"c1:102\" ORGANISM=\"Human\" EXTERNAL_DETAILS_URL=\"http://genome.ucsc.edu/cgi-bin/hgTracks?position=16q24\" CHIP=\"GENE_SYMBOL\" CATEGORY_CODE=\"c1\" CONTRIBUTOR=\"Broad Institute\" DESCRIPTION_BRIEF=\"Genes in cytogenetic band chr16q24\" DESCRIPTION_FULL=\"Genes in cytogenetic band chr16q24\" TAGS=\"\" MEMBERS=\"GALNS,C16ORF44,FEOM3,CDH13,LOC646365,FBXO31,FOXL1,ZNF778,MC1R,IL17C,TUBB3,MAP1LC3B,KLHDC4,LOC390748,FLJ12986,LOC401865,LOC729924,DBNDD1,IRF8,PLCG2,LOC146429,FLJ12547,TMEM148,RPL13,LOC729942,LOC401864,ZNF469,LOC728054,COTL1,SNAI3,KIAA0513,FLJ46320,LOC348180,HSDL1,FLJ40448,SLC7A5,LRRC50,LOC727903,RNF166,COX4NB,LOC400553,LOC729508,JPH3,FLJ45121,LOC123855,MBTPS1,LOC283904,LOC642533,LOC727949,DKFZP434O0320,HSD17B2,CDK10,MGC16385,TCF25,C16ORF74,LOC161931,SCA4,C16ORF7,LOC729519,MGC23284,LOC146513,KIAA1609,FAM92B,PRDM7,KIAA0703,FLJ34515,C16ORF76,HDLC3,LOC729979,PCOLN3,BANP,AFG3L1,WFDC1,LOC642452,C16ORF3,APRT,SPIRE2,LOC197322,KIAA0182,MTHFSD,GAS8,GINS2,ZNF276,CA5A,NHN1,FLJ45530,CDH15,CRISPLD2,VV,ANKRD11,LOC727710,DKFZP434B2016,FLJ20186,LOC400558,LOC730018,LOC123862,LOC728028,MVD,LOC197331,LOC401863,LOC729887,TAF1C,C16ORF55,FANCA,CPNE7,LOC400548,KCNG4,LOC283861,ZFPM1,SNORD68,C16ORF81,LOC648774,ZCCHC14,LOC654780,LOC729922,GAN,DPEP1,FOXF1,LOC729464,LOC729441,SPG7,CDT1,LOC729895,FAM38A,FLJ30679,CBFA2T3,LOC728006,CYBA,TRAPPC2L\" MEMBERS_SYMBOLIZED=\"GALNS,C16ORF44,FEOM3,CDH13,LOC646365,FBXO31,FOXL1,ZNF778,MC1R,IL17C,TUBB3,MAP1LC3B,KLHDC4,LOC390748,FLJ12986,LOC401865,LOC729924,DBNDD1,IRF8,PLCG2,LOC146429,FLJ12547,TMEM148,RPL13,LOC729942,LOC401864,ZNF469,LOC728054,COTL1,SNAI3,KIAA0513,FLJ46320,LOC348180,HSDL1,FLJ40448,SLC7A5,LRRC50,LOC727903,RNF166,COX4NB,LOC400553,LOC729508,JPH3,FLJ45121,LOC123855,MBTPS1,LOC283904,LOC642533,LOC727949,DKFZP434O0320,HSD17B2,CDK10,MGC16385,TCF25,C16ORF74,LOC161931,SCA4,C16ORF7,LOC729519,MGC23284,LOC146513,KIAA1609,FAM92B,PRDM7,KIAA0703,FLJ34515,C16ORF76,HDLC3,LOC729979,PCOLN3,BANP,AFG3L1,WFDC1,LOC642452,C16ORF3,APRT,SPIRE2,LOC197322,KIAA0182,MTHFSD,GAS8,GINS2,ZNF276,CA5A,NHN1,FLJ45530,CDH15,CRISPLD2,VV,ANKRD11,LOC727710,DKFZP434B2016,FLJ20186,LOC400558,LOC730018,LOC123862,LOC728028,MVD,LOC197331,LOC401863,LOC729887,TAF1C,C16ORF55,FANCA,CPNE7,LOC400548,KCNG4,LOC283861,ZFPM1,SNORD68,C16ORF81,LOC648774,ZCCHC14,LOC654780,LOC729922,GAN,DPEP1,FOXF1,LOC729464,LOC729441,SPG7,CDT1,LOC729895,FAM38A,FLJ30679,CBFA2T3,LOC728006,CYBA,TRAPPC2L\"/>",
                        "</MSIGDB>"))
    gs <- getBroadSets(.broadXML)[[1]]
    checkTrue(setName(gs)=="chr16q24")
    checkTrue(setIdentifier(gs)=="c1:102")
    checkIdentical(length(geneIds(gs)), 129L)
    checkTrue(geneIds(gs)[length(geneIds(gs))]=="TRAPPC2L")
    checkTrue(class(geneIdType(gs))=="SymbolIdentifier")
    exp <- new("BroadCollection", category="c1", subCategory=NA_character_)
    checkIdentical(collectionType(gs), exp)
    checkTrue(nchar(description(gs))==34)
    checkIdentical(description(gs), longDescription(gs))
    checkTrue(organism(gs)=="Human")
    checkTrue(length(urls(gs))==1 &&
              urls(gs) == "http://genome.ucsc.edu/cgi-bin/hgTracks?position=16q24")
    checkTrue(contributor(gs) == "Broad Institute")
}

test_getGmt <- function() {
    gmtText <- c(
        "KEGG_GLYCOLYSIS_GLUCONEOGENESIS\thttp://www.broadinstitute.org/gsea/msigdb/cards/KEGG_GLYCOLYSIS_GLUCONEOGENESIS\tACSS2\tGCK\tPGK2\tPGK1",
        "KEGG_CITRATE_CYCLE_TCA_CYCLE\thttp://www.broadinstitute.org/gsea/msigdb/cards/KEGG_CITRATE_CYCLE_TCA_CYCLE\tIDH3B\tDLST\tPCK2" )
    gs <- getGmt(textConnection(gmtText))
    checkIdentical(
        c("KEGG_GLYCOLYSIS_GLUCONEOGENESIS", "KEGG_CITRATE_CYCLE_TCA_CYCLE"),
        names(gs))
    checkIdentical(
        list(c("ACSS2", "GCK", "PGK2", "PGK1"), c("IDH3B", "DLST", "PCK2")),
        lapply(gs, geneIds))
}
