% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{degMDS}
\alias{degMDS}
\title{Plot MDS from normalized count data}
\usage{
degMDS(counts, condition = NULL, k = 2, d = "euclidian", xi = 1, yi = 2)
}
\arguments{
\item{counts}{matrix samples in columns, features in rows}

\item{condition}{vector define groups of samples in counts.
It has to be same order than the count matrix for columns.}

\item{k}{integer number of dimensions to get}

\item{d}{type of distance to use, c("euclidian", "cor").}

\item{xi}{number of component to plot in x-axis}

\item{yi}{number of component to plot in y-axis}
}
\value{
ggplot2 object
}
\description{
Uses cmdscale to get multidimensional scaling of data matrix,
and plot the samples with ggplot2.
}
\examples{
data(humanGender)
library(DESeq2)
idx <- c(1:10, 75:85)
dse <- DESeqDataSetFromMatrix(assays(humanGender)[[1]][1:1000, idx],
  colData(humanGender)[idx,], design=~group)
degMDS(counts(dse), condition = colData(dse)[["group"]])
}
