// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Adjustment, Align, Buildable, Container, DeleteType, InputHints, InputPurpose, Justification,
    MovementStep, ResizeMode, ScrollStep, Scrollable, ScrollablePolicy, TextAttributes, TextBuffer,
    TextChildAnchor, TextExtendSelection, TextIter, TextMark, TextWindowType, Widget, WrapMode,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkTextView")]
    pub struct TextView(Object<ffi::GtkTextView, ffi::GtkTextViewClass>) @extends Container, Widget, @implements Buildable, Scrollable;

    match fn {
        type_ => || ffi::gtk_text_view_get_type(),
    }
}

impl TextView {
    pub const NONE: Option<&'static TextView> = None;

    #[doc(alias = "gtk_text_view_new")]
    pub fn new() -> TextView {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_text_view_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_text_view_new_with_buffer")]
    #[doc(alias = "new_with_buffer")]
    pub fn with_buffer(buffer: &impl IsA<TextBuffer>) -> TextView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_text_view_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TextView`] objects.
    ///
    /// This method returns an instance of [`TextViewBuilder`](crate::builders::TextViewBuilder) which can be used to create [`TextView`] objects.
    pub fn builder() -> TextViewBuilder {
        TextViewBuilder::new()
    }
}

impl Default for TextView {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TextView`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TextViewBuilder {
    builder: glib::object::ObjectBuilder<'static, TextView>,
}

impl TextViewBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn accepts_tab(self, accepts_tab: bool) -> Self {
        Self {
            builder: self.builder.property("accepts-tab", accepts_tab),
        }
    }

    pub fn bottom_margin(self, bottom_margin: i32) -> Self {
        Self {
            builder: self.builder.property("bottom-margin", bottom_margin),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<TextBuffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    pub fn cursor_visible(self, cursor_visible: bool) -> Self {
        Self {
            builder: self.builder.property("cursor-visible", cursor_visible),
        }
    }

    pub fn editable(self, editable: bool) -> Self {
        Self {
            builder: self.builder.property("editable", editable),
        }
    }

    pub fn im_module(self, im_module: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("im-module", im_module.into()),
        }
    }

    pub fn indent(self, indent: i32) -> Self {
        Self {
            builder: self.builder.property("indent", indent),
        }
    }

    pub fn input_hints(self, input_hints: InputHints) -> Self {
        Self {
            builder: self.builder.property("input-hints", input_hints),
        }
    }

    pub fn input_purpose(self, input_purpose: InputPurpose) -> Self {
        Self {
            builder: self.builder.property("input-purpose", input_purpose),
        }
    }

    pub fn justification(self, justification: Justification) -> Self {
        Self {
            builder: self.builder.property("justification", justification),
        }
    }

    pub fn left_margin(self, left_margin: i32) -> Self {
        Self {
            builder: self.builder.property("left-margin", left_margin),
        }
    }

    pub fn monospace(self, monospace: bool) -> Self {
        Self {
            builder: self.builder.property("monospace", monospace),
        }
    }

    pub fn overwrite(self, overwrite: bool) -> Self {
        Self {
            builder: self.builder.property("overwrite", overwrite),
        }
    }

    pub fn pixels_above_lines(self, pixels_above_lines: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-above-lines", pixels_above_lines),
        }
    }

    pub fn pixels_below_lines(self, pixels_below_lines: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-below-lines", pixels_below_lines),
        }
    }

    pub fn pixels_inside_wrap(self, pixels_inside_wrap: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-inside-wrap", pixels_inside_wrap),
        }
    }

    pub fn populate_all(self, populate_all: bool) -> Self {
        Self {
            builder: self.builder.property("populate-all", populate_all),
        }
    }

    pub fn right_margin(self, right_margin: i32) -> Self {
        Self {
            builder: self.builder.property("right-margin", right_margin),
        }
    }

    pub fn tabs(self, tabs: &pango::TabArray) -> Self {
        Self {
            builder: self.builder.property("tabs", tabs),
        }
    }

    pub fn top_margin(self, top_margin: i32) -> Self {
        Self {
            builder: self.builder.property("top-margin", top_margin),
        }
    }

    pub fn wrap_mode(self, wrap_mode: WrapMode) -> Self {
        Self {
            builder: self.builder.property("wrap-mode", wrap_mode),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn hadjustment(self, hadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("hadjustment", hadjustment.clone().upcast()),
        }
    }

    pub fn hscroll_policy(self, hscroll_policy: ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("hscroll-policy", hscroll_policy),
        }
    }

    pub fn vadjustment(self, vadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("vadjustment", vadjustment.clone().upcast()),
        }
    }

    pub fn vscroll_policy(self, vscroll_policy: ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("vscroll-policy", vscroll_policy),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TextView`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> TextView {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::TextView>> Sealed for T {}
}

pub trait TextViewExt: IsA<TextView> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_text_view_add_child_at_anchor")]
    fn add_child_at_anchor(&self, child: &impl IsA<Widget>, anchor: &impl IsA<TextChildAnchor>) {
        unsafe {
            ffi::gtk_text_view_add_child_at_anchor(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                anchor.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_text_view_add_child_in_window")]
    fn add_child_in_window(
        &self,
        child: &impl IsA<Widget>,
        which_window: TextWindowType,
        xpos: i32,
        ypos: i32,
    ) {
        unsafe {
            ffi::gtk_text_view_add_child_in_window(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                which_window.into_glib(),
                xpos,
                ypos,
            );
        }
    }

    #[doc(alias = "gtk_text_view_backward_display_line")]
    fn backward_display_line(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_backward_display_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_backward_display_line_start")]
    fn backward_display_line_start(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_backward_display_line_start(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_buffer_to_window_coords")]
    fn buffer_to_window_coords(
        &self,
        win: TextWindowType,
        buffer_x: i32,
        buffer_y: i32,
    ) -> (i32, i32) {
        unsafe {
            let mut window_x = mem::MaybeUninit::uninit();
            let mut window_y = mem::MaybeUninit::uninit();
            ffi::gtk_text_view_buffer_to_window_coords(
                self.as_ref().to_glib_none().0,
                win.into_glib(),
                buffer_x,
                buffer_y,
                window_x.as_mut_ptr(),
                window_y.as_mut_ptr(),
            );
            (window_x.assume_init(), window_y.assume_init())
        }
    }

    #[doc(alias = "gtk_text_view_forward_display_line")]
    fn forward_display_line(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_forward_display_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_forward_display_line_end")]
    fn forward_display_line_end(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_forward_display_line_end(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_accepts_tab")]
    #[doc(alias = "get_accepts_tab")]
    fn accepts_tab(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_get_accepts_tab(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_border_window_size")]
    #[doc(alias = "get_border_window_size")]
    fn border_window_size(&self, type_: TextWindowType) -> i32 {
        unsafe {
            ffi::gtk_text_view_get_border_window_size(
                self.as_ref().to_glib_none().0,
                type_.into_glib(),
            )
        }
    }

    #[doc(alias = "gtk_text_view_get_bottom_margin")]
    #[doc(alias = "get_bottom_margin")]
    fn bottom_margin(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_bottom_margin(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_view_get_buffer")]
    #[doc(alias = "get_buffer")]
    fn buffer(&self) -> Option<TextBuffer> {
        unsafe {
            from_glib_none(ffi::gtk_text_view_get_buffer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_cursor_locations")]
    #[doc(alias = "get_cursor_locations")]
    fn cursor_locations(&self, iter: Option<&TextIter>) -> (gdk::Rectangle, gdk::Rectangle) {
        unsafe {
            let mut strong = gdk::Rectangle::uninitialized();
            let mut weak = gdk::Rectangle::uninitialized();
            ffi::gtk_text_view_get_cursor_locations(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
                strong.to_glib_none_mut().0,
                weak.to_glib_none_mut().0,
            );
            (strong, weak)
        }
    }

    #[doc(alias = "gtk_text_view_get_cursor_visible")]
    #[doc(alias = "get_cursor_visible")]
    fn is_cursor_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_get_cursor_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_default_attributes")]
    #[doc(alias = "get_default_attributes")]
    fn default_attributes(&self) -> TextAttributes {
        unsafe {
            from_glib_full(ffi::gtk_text_view_get_default_attributes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_editable")]
    #[doc(alias = "get_editable")]
    fn is_editable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_get_editable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_indent")]
    #[doc(alias = "get_indent")]
    fn indent(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_indent(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_view_get_input_hints")]
    #[doc(alias = "get_input_hints")]
    fn input_hints(&self) -> InputHints {
        unsafe {
            from_glib(ffi::gtk_text_view_get_input_hints(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_input_purpose")]
    #[doc(alias = "get_input_purpose")]
    fn input_purpose(&self) -> InputPurpose {
        unsafe {
            from_glib(ffi::gtk_text_view_get_input_purpose(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_iter_at_location")]
    #[doc(alias = "get_iter_at_location")]
    fn iter_at_location(&self, x: i32, y: i32) -> Option<TextIter> {
        unsafe {
            let mut iter = TextIter::uninitialized();
            let ret = from_glib(ffi::gtk_text_view_get_iter_at_location(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                x,
                y,
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_text_view_get_iter_at_position")]
    #[doc(alias = "get_iter_at_position")]
    fn iter_at_position(&self, x: i32, y: i32) -> Option<(TextIter, i32)> {
        unsafe {
            let mut iter = TextIter::uninitialized();
            let mut trailing = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_text_view_get_iter_at_position(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                trailing.as_mut_ptr(),
                x,
                y,
            ));
            if ret {
                Some((iter, trailing.assume_init()))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_text_view_get_iter_location")]
    #[doc(alias = "get_iter_location")]
    fn iter_location(&self, iter: &TextIter) -> gdk::Rectangle {
        unsafe {
            let mut location = gdk::Rectangle::uninitialized();
            ffi::gtk_text_view_get_iter_location(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
                location.to_glib_none_mut().0,
            );
            location
        }
    }

    #[doc(alias = "gtk_text_view_get_justification")]
    #[doc(alias = "get_justification")]
    fn justification(&self) -> Justification {
        unsafe {
            from_glib(ffi::gtk_text_view_get_justification(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_left_margin")]
    #[doc(alias = "get_left_margin")]
    fn left_margin(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_left_margin(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_view_get_line_at_y")]
    #[doc(alias = "get_line_at_y")]
    fn line_at_y(&self, y: i32) -> (TextIter, i32) {
        unsafe {
            let mut target_iter = TextIter::uninitialized();
            let mut line_top = mem::MaybeUninit::uninit();
            ffi::gtk_text_view_get_line_at_y(
                self.as_ref().to_glib_none().0,
                target_iter.to_glib_none_mut().0,
                y,
                line_top.as_mut_ptr(),
            );
            (target_iter, line_top.assume_init())
        }
    }

    #[doc(alias = "gtk_text_view_get_line_yrange")]
    #[doc(alias = "get_line_yrange")]
    fn line_yrange(&self, iter: &TextIter) -> (i32, i32) {
        unsafe {
            let mut y = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            ffi::gtk_text_view_get_line_yrange(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
                y.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            (y.assume_init(), height.assume_init())
        }
    }

    #[doc(alias = "gtk_text_view_get_monospace")]
    #[doc(alias = "get_monospace")]
    fn is_monospace(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_get_monospace(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_overwrite")]
    #[doc(alias = "get_overwrite")]
    fn overwrites(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_get_overwrite(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_pixels_above_lines")]
    #[doc(alias = "get_pixels_above_lines")]
    fn pixels_above_lines(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_pixels_above_lines(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_view_get_pixels_below_lines")]
    #[doc(alias = "get_pixels_below_lines")]
    fn pixels_below_lines(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_pixels_below_lines(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_view_get_pixels_inside_wrap")]
    #[doc(alias = "get_pixels_inside_wrap")]
    fn pixels_inside_wrap(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_pixels_inside_wrap(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_view_get_right_margin")]
    #[doc(alias = "get_right_margin")]
    fn right_margin(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_right_margin(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_view_get_tabs")]
    #[doc(alias = "get_tabs")]
    fn tabs(&self) -> Option<pango::TabArray> {
        unsafe { from_glib_full(ffi::gtk_text_view_get_tabs(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_view_get_top_margin")]
    #[doc(alias = "get_top_margin")]
    fn top_margin(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_top_margin(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_view_get_visible_rect")]
    #[doc(alias = "get_visible_rect")]
    fn visible_rect(&self) -> gdk::Rectangle {
        unsafe {
            let mut visible_rect = gdk::Rectangle::uninitialized();
            ffi::gtk_text_view_get_visible_rect(
                self.as_ref().to_glib_none().0,
                visible_rect.to_glib_none_mut().0,
            );
            visible_rect
        }
    }

    #[doc(alias = "gtk_text_view_get_window")]
    #[doc(alias = "get_window")]
    fn window(&self, win: TextWindowType) -> Option<gdk::Window> {
        unsafe {
            from_glib_none(ffi::gtk_text_view_get_window(
                self.as_ref().to_glib_none().0,
                win.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_window_type")]
    #[doc(alias = "get_window_type")]
    fn window_type(&self, window: &gdk::Window) -> TextWindowType {
        unsafe {
            from_glib(ffi::gtk_text_view_get_window_type(
                self.as_ref().to_glib_none().0,
                window.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_get_wrap_mode")]
    #[doc(alias = "get_wrap_mode")]
    fn wrap_mode(&self) -> WrapMode {
        unsafe {
            from_glib(ffi::gtk_text_view_get_wrap_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_im_context_filter_keypress")]
    fn im_context_filter_keypress(&self, event: &gdk::EventKey) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_im_context_filter_keypress(
                self.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_text_view_move_child")]
    fn move_child(&self, child: &impl IsA<Widget>, xpos: i32, ypos: i32) {
        unsafe {
            ffi::gtk_text_view_move_child(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                xpos,
                ypos,
            );
        }
    }

    #[doc(alias = "gtk_text_view_move_mark_onscreen")]
    fn move_mark_onscreen(&self, mark: &impl IsA<TextMark>) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_move_mark_onscreen(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_move_visually")]
    fn move_visually(&self, iter: &mut TextIter, count: i32) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_move_visually(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                count,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_place_cursor_onscreen")]
    fn place_cursor_onscreen(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_place_cursor_onscreen(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_reset_cursor_blink")]
    fn reset_cursor_blink(&self) {
        unsafe {
            ffi::gtk_text_view_reset_cursor_blink(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_text_view_reset_im_context")]
    fn reset_im_context(&self) {
        unsafe {
            ffi::gtk_text_view_reset_im_context(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_text_view_scroll_mark_onscreen")]
    fn scroll_mark_onscreen(&self, mark: &impl IsA<TextMark>) {
        unsafe {
            ffi::gtk_text_view_scroll_mark_onscreen(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_text_view_scroll_to_iter")]
    fn scroll_to_iter(
        &self,
        iter: &mut TextIter,
        within_margin: f64,
        use_align: bool,
        xalign: f64,
        yalign: f64,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_scroll_to_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                within_margin,
                use_align.into_glib(),
                xalign,
                yalign,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_scroll_to_mark")]
    fn scroll_to_mark(
        &self,
        mark: &impl IsA<TextMark>,
        within_margin: f64,
        use_align: bool,
        xalign: f64,
        yalign: f64,
    ) {
        unsafe {
            ffi::gtk_text_view_scroll_to_mark(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
                within_margin,
                use_align.into_glib(),
                xalign,
                yalign,
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_accepts_tab")]
    fn set_accepts_tab(&self, accepts_tab: bool) {
        unsafe {
            ffi::gtk_text_view_set_accepts_tab(
                self.as_ref().to_glib_none().0,
                accepts_tab.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_border_window_size")]
    fn set_border_window_size(&self, type_: TextWindowType, size: i32) {
        unsafe {
            ffi::gtk_text_view_set_border_window_size(
                self.as_ref().to_glib_none().0,
                type_.into_glib(),
                size,
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_bottom_margin")]
    fn set_bottom_margin(&self, bottom_margin: i32) {
        unsafe {
            ffi::gtk_text_view_set_bottom_margin(self.as_ref().to_glib_none().0, bottom_margin);
        }
    }

    #[doc(alias = "gtk_text_view_set_buffer")]
    fn set_buffer(&self, buffer: Option<&impl IsA<TextBuffer>>) {
        unsafe {
            ffi::gtk_text_view_set_buffer(
                self.as_ref().to_glib_none().0,
                buffer.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_cursor_visible")]
    fn set_cursor_visible(&self, setting: bool) {
        unsafe {
            ffi::gtk_text_view_set_cursor_visible(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_editable")]
    fn set_editable(&self, setting: bool) {
        unsafe {
            ffi::gtk_text_view_set_editable(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_text_view_set_indent")]
    fn set_indent(&self, indent: i32) {
        unsafe {
            ffi::gtk_text_view_set_indent(self.as_ref().to_glib_none().0, indent);
        }
    }

    #[doc(alias = "gtk_text_view_set_input_hints")]
    fn set_input_hints(&self, hints: InputHints) {
        unsafe {
            ffi::gtk_text_view_set_input_hints(self.as_ref().to_glib_none().0, hints.into_glib());
        }
    }

    #[doc(alias = "gtk_text_view_set_input_purpose")]
    fn set_input_purpose(&self, purpose: InputPurpose) {
        unsafe {
            ffi::gtk_text_view_set_input_purpose(
                self.as_ref().to_glib_none().0,
                purpose.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_justification")]
    fn set_justification(&self, justification: Justification) {
        unsafe {
            ffi::gtk_text_view_set_justification(
                self.as_ref().to_glib_none().0,
                justification.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_left_margin")]
    fn set_left_margin(&self, left_margin: i32) {
        unsafe {
            ffi::gtk_text_view_set_left_margin(self.as_ref().to_glib_none().0, left_margin);
        }
    }

    #[doc(alias = "gtk_text_view_set_monospace")]
    fn set_monospace(&self, monospace: bool) {
        unsafe {
            ffi::gtk_text_view_set_monospace(self.as_ref().to_glib_none().0, monospace.into_glib());
        }
    }

    #[doc(alias = "gtk_text_view_set_overwrite")]
    fn set_overwrite(&self, overwrite: bool) {
        unsafe {
            ffi::gtk_text_view_set_overwrite(self.as_ref().to_glib_none().0, overwrite.into_glib());
        }
    }

    #[doc(alias = "gtk_text_view_set_pixels_above_lines")]
    fn set_pixels_above_lines(&self, pixels_above_lines: i32) {
        unsafe {
            ffi::gtk_text_view_set_pixels_above_lines(
                self.as_ref().to_glib_none().0,
                pixels_above_lines,
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_pixels_below_lines")]
    fn set_pixels_below_lines(&self, pixels_below_lines: i32) {
        unsafe {
            ffi::gtk_text_view_set_pixels_below_lines(
                self.as_ref().to_glib_none().0,
                pixels_below_lines,
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_pixels_inside_wrap")]
    fn set_pixels_inside_wrap(&self, pixels_inside_wrap: i32) {
        unsafe {
            ffi::gtk_text_view_set_pixels_inside_wrap(
                self.as_ref().to_glib_none().0,
                pixels_inside_wrap,
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_right_margin")]
    fn set_right_margin(&self, right_margin: i32) {
        unsafe {
            ffi::gtk_text_view_set_right_margin(self.as_ref().to_glib_none().0, right_margin);
        }
    }

    #[doc(alias = "gtk_text_view_set_tabs")]
    fn set_tabs(&self, tabs: &pango::TabArray) {
        unsafe {
            ffi::gtk_text_view_set_tabs(
                self.as_ref().to_glib_none().0,
                mut_override(tabs.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_text_view_set_top_margin")]
    fn set_top_margin(&self, top_margin: i32) {
        unsafe {
            ffi::gtk_text_view_set_top_margin(self.as_ref().to_glib_none().0, top_margin);
        }
    }

    #[doc(alias = "gtk_text_view_set_wrap_mode")]
    fn set_wrap_mode(&self, wrap_mode: WrapMode) {
        unsafe {
            ffi::gtk_text_view_set_wrap_mode(self.as_ref().to_glib_none().0, wrap_mode.into_glib());
        }
    }

    #[doc(alias = "gtk_text_view_starts_display_line")]
    fn starts_display_line(&self, iter: &TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_starts_display_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_view_window_to_buffer_coords")]
    fn window_to_buffer_coords(
        &self,
        win: TextWindowType,
        window_x: i32,
        window_y: i32,
    ) -> (i32, i32) {
        unsafe {
            let mut buffer_x = mem::MaybeUninit::uninit();
            let mut buffer_y = mem::MaybeUninit::uninit();
            ffi::gtk_text_view_window_to_buffer_coords(
                self.as_ref().to_glib_none().0,
                win.into_glib(),
                window_x,
                window_y,
                buffer_x.as_mut_ptr(),
                buffer_y.as_mut_ptr(),
            );
            (buffer_x.assume_init(), buffer_y.assume_init())
        }
    }

    #[doc(alias = "im-module")]
    fn im_module(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "im-module")
    }

    #[doc(alias = "im-module")]
    fn set_im_module(&self, im_module: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "im-module", im_module)
    }

    #[doc(alias = "populate-all")]
    fn populates_all(&self) -> bool {
        ObjectExt::property(self.as_ref(), "populate-all")
    }

    #[doc(alias = "populate-all")]
    fn set_populate_all(&self, populate_all: bool) {
        ObjectExt::set_property(self.as_ref(), "populate-all", populate_all)
    }

    #[doc(alias = "backspace")]
    fn connect_backspace<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn backspace_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"backspace\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    backspace_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_backspace(&self) {
        self.emit_by_name::<()>("backspace", &[]);
    }

    #[doc(alias = "copy-clipboard")]
    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn copy_clipboard_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"copy-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    copy_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_copy_clipboard(&self) {
        self.emit_by_name::<()>("copy-clipboard", &[]);
    }

    #[doc(alias = "cut-clipboard")]
    fn connect_cut_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn cut_clipboard_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cut-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    cut_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_cut_clipboard(&self) {
        self.emit_by_name::<()>("cut-clipboard", &[]);
    }

    #[doc(alias = "delete-from-cursor")]
    fn connect_delete_from_cursor<F: Fn(&Self, DeleteType, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn delete_from_cursor_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, DeleteType, i32) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            type_: ffi::GtkDeleteType,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(type_),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"delete-from-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    delete_from_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_delete_from_cursor(&self, type_: DeleteType, count: i32) {
        self.emit_by_name::<()>("delete-from-cursor", &[&type_, &count]);
    }

    #[doc(alias = "extend-selection")]
    fn connect_extend_selection<
        F: Fn(&Self, TextExtendSelection, &TextIter, &TextIter, &TextIter) -> glib::Propagation
            + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn extend_selection_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, TextExtendSelection, &TextIter, &TextIter, &TextIter) -> glib::Propagation
                + 'static,
        >(
            this: *mut ffi::GtkTextView,
            granularity: ffi::GtkTextExtendSelection,
            location: *mut ffi::GtkTextIter,
            start: *mut ffi::GtkTextIter,
            end: *mut ffi::GtkTextIter,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(granularity),
                &from_glib_borrow(location),
                &from_glib_borrow(start),
                &from_glib_borrow(end),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"extend-selection\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    extend_selection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "insert-at-cursor")]
    fn connect_insert_at_cursor<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn insert_at_cursor_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, &str) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            string: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(string),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-at-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    insert_at_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_insert_at_cursor(&self, string: &str) {
        self.emit_by_name::<()>("insert-at-cursor", &[&string]);
    }

    #[doc(alias = "insert-emoji")]
    fn connect_insert_emoji<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn insert_emoji_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-emoji\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    insert_emoji_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_insert_emoji(&self) {
        self.emit_by_name::<()>("insert-emoji", &[]);
    }

    #[doc(alias = "move-cursor")]
    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, MovementStep, i32, bool) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            step: ffi::GtkMovementStep,
            count: libc::c_int,
            extend_selection: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(step),
                count,
                from_glib(extend_selection),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool) {
        self.emit_by_name::<()>("move-cursor", &[&step, &count, &extend_selection]);
    }

    #[doc(alias = "move-viewport")]
    fn connect_move_viewport<F: Fn(&Self, ScrollStep, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_viewport_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, ScrollStep, i32) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            step: ffi::GtkScrollStep,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(step),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-viewport\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_viewport_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_viewport(&self, step: ScrollStep, count: i32) {
        self.emit_by_name::<()>("move-viewport", &[&step, &count]);
    }

    #[doc(alias = "paste-clipboard")]
    fn connect_paste_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn paste_clipboard_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"paste-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    paste_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_paste_clipboard(&self) {
        self.emit_by_name::<()>("paste-clipboard", &[]);
    }

    #[doc(alias = "populate-popup")]
    fn connect_populate_popup<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn populate_popup_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, &Widget) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            popup: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(popup),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"populate-popup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    populate_popup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "preedit-changed")]
    fn connect_preedit_changed<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn preedit_changed_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, &str) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            preedit: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(preedit),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"preedit-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    preedit_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_preedit_changed(&self, preedit: &str) {
        self.emit_by_name::<()>("preedit-changed", &[&preedit]);
    }

    #[doc(alias = "select-all")]
    fn connect_select_all<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_all_trampoline<P: IsA<TextView>, F: Fn(&P, bool) + 'static>(
            this: *mut ffi::GtkTextView,
            select: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(select),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_all(&self, select: bool) {
        self.emit_by_name::<()>("select-all", &[&select]);
    }

    #[doc(alias = "set-anchor")]
    fn connect_set_anchor<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn set_anchor_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"set-anchor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    set_anchor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_set_anchor(&self) {
        self.emit_by_name::<()>("set-anchor", &[]);
    }

    #[doc(alias = "toggle-cursor-visible")]
    fn connect_toggle_cursor_visible<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_cursor_visible_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-cursor-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    toggle_cursor_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_cursor_visible(&self) {
        self.emit_by_name::<()>("toggle-cursor-visible", &[]);
    }

    #[doc(alias = "toggle-overwrite")]
    fn connect_toggle_overwrite<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_overwrite_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-overwrite\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    toggle_overwrite_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_overwrite(&self) {
        self.emit_by_name::<()>("toggle-overwrite", &[]);
    }

    #[doc(alias = "accepts-tab")]
    fn connect_accepts_tab_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accepts_tab_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accepts-tab\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_accepts_tab_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "bottom-margin")]
    fn connect_bottom_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_bottom_margin_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::bottom-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_bottom_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "buffer")]
    fn connect_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::buffer\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_buffer_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "cursor-visible")]
    fn connect_cursor_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_visible_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cursor_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "editable")]
    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "im-module")]
    fn connect_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_im_module_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::im-module\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_im_module_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "indent")]
    fn connect_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-hints")]
    fn connect_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_hints_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-hints\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_hints_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-purpose")]
    fn connect_input_purpose_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_purpose_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-purpose\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_purpose_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "justification")]
    fn connect_justification_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_justification_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justification\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_justification_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "left-margin")]
    fn connect_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_left_margin_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::left-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_left_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "monospace")]
    fn connect_monospace_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_monospace_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::monospace\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_monospace_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "overwrite")]
    fn connect_overwrite_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overwrite_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overwrite\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overwrite_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pixels-above-lines")]
    fn connect_pixels_above_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_above_lines_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-above-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_above_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pixels-below-lines")]
    fn connect_pixels_below_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_below_lines_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-below-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_below_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pixels-inside-wrap")]
    fn connect_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_inside_wrap_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-inside-wrap\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_inside_wrap_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "populate-all")]
    fn connect_populate_all_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_populate_all_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::populate-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_populate_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "right-margin")]
    fn connect_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_right_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tabs")]
    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "top-margin")]
    fn connect_top_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_top_margin_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::top-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_top_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrap-mode")]
    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<TextView>> TextViewExt for O {}

impl fmt::Display for TextView {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TextView")
    }
}
