# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.newrelicobservability.aio import NewRelicObservabilityMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNewRelicObservabilityMgmtTagRulesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NewRelicObservabilityMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tag_rules_list_by_new_relic_monitor_resource(self, resource_group):
        response = self.client.tag_rules.list_by_new_relic_monitor_resource(
            resource_group_name=resource_group.name,
            monitor_name="str",
            api_version="2025-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tag_rules_get(self, resource_group):
        response = await self.client.tag_rules.get(
            resource_group_name=resource_group.name,
            monitor_name="str",
            rule_set_name="str",
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tag_rules_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.tag_rules.begin_create_or_update(
                resource_group_name=resource_group.name,
                monitor_name="str",
                rule_set_name="str",
                resource={
                    "id": "str",
                    "logRules": {
                        "filteringTags": [{"action": "str", "name": "str", "value": "str"}],
                        "sendAadLogs": "str",
                        "sendActivityLogs": "str",
                        "sendSubscriptionLogs": "str",
                    },
                    "metricRules": {
                        "filteringTags": [{"action": "str", "name": "str", "value": "str"}],
                        "sendMetrics": "str",
                        "userEmail": "str",
                    },
                    "name": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tag_rules_begin_delete(self, resource_group):
        response = await (
            await self.client.tag_rules.begin_delete(
                resource_group_name=resource_group.name,
                monitor_name="str",
                rule_set_name="str",
                api_version="2025-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tag_rules_update(self, resource_group):
        response = await self.client.tag_rules.update(
            resource_group_name=resource_group.name,
            monitor_name="str",
            rule_set_name="str",
            properties={
                "logRules": {
                    "filteringTags": [{"action": "str", "name": "str", "value": "str"}],
                    "sendAadLogs": "str",
                    "sendActivityLogs": "str",
                    "sendSubscriptionLogs": "str",
                },
                "metricRules": {
                    "filteringTags": [{"action": "str", "name": "str", "value": "str"}],
                    "sendMetrics": "str",
                    "userEmail": "str",
                },
            },
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...
