# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, Type, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_request(
    report_name: str,
    *,
    skip_token: Optional[str] = None,
    top: Optional[int] = None,
    select: Optional[str] = None,
    filter: Optional[str] = None,
    orderby: Optional[str] = None,
    offer_guid: Optional[str] = None,
    report_creator_tenant_id: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-06-27"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/snapshots")
    path_format_arguments = {
        "reportName": _SERIALIZER.url("report_name", report_name, "str", pattern=r"^[-a-zA-Z0-9_]{1,50}$"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skipToken"] = _SERIALIZER.query("skip_token", skip_token, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", maximum=100, minimum=1)
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str", min_length=1)
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str", min_length=1)
    if orderby is not None:
        _params["$orderby"] = _SERIALIZER.query("orderby", orderby, "str", min_length=1)
    if offer_guid is not None:
        _params["offerGuid"] = _SERIALIZER.query("offer_guid", offer_guid, "str", min_length=1)
    if report_creator_tenant_id is not None:
        _params["reportCreatorTenantId"] = _SERIALIZER.query(
            "report_creator_tenant_id", report_creator_tenant_id, "str", min_length=1
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(report_name: str, snapshot_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-06-27"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url", "/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/snapshots/{snapshotName}"
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "reportName": _SERIALIZER.url("report_name", report_name, "str", pattern=r"^[-a-zA-Z0-9_]{1,50}$"),
        "snapshotName": _SERIALIZER.url("snapshot_name", snapshot_name, "str", pattern=r"^[a-zA-Z0-9-_]{1,64}$"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_download_request(report_name: str, snapshot_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-06-27"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/snapshots/{snapshotName}/download",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "reportName": _SERIALIZER.url("report_name", report_name, "str", pattern=r"^[-a-zA-Z0-9_]{1,50}$"),
        "snapshotName": _SERIALIZER.url("snapshot_name", snapshot_name, "str", pattern=r"^[a-zA-Z0-9-_]{1,64}$"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class SnapshotOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.appcomplianceautomation.AppComplianceAutomationMgmtClient`'s
        :attr:`snapshot` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        report_name: str,
        skip_token: Optional[str] = None,
        top: Optional[int] = None,
        select: Optional[str] = None,
        filter: Optional[str] = None,
        orderby: Optional[str] = None,
        offer_guid: Optional[str] = None,
        report_creator_tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.SnapshotResource"]:
        """Get the AppComplianceAutomation snapshot list.

        :param report_name: Report Name. Required.
        :type report_name: str
        :param skip_token: Skip over when retrieving results. Default value is None.
        :type skip_token: str
        :param top: Number of elements to return when retrieving results. Default value is None.
        :type top: int
        :param select: OData Select statement. Limits the properties on each entry to just those
         requested, e.g. ?$select=reportName,id. Default value is None.
        :type select: str
        :param filter: The filter to apply on the operation. Default value is None.
        :type filter: str
        :param orderby: OData order by query option. Default value is None.
        :type orderby: str
        :param offer_guid: The offerGuid which mapping to the reports. Default value is None.
        :type offer_guid: str
        :param report_creator_tenant_id: The tenant id of the report creator. Default value is None.
        :type report_creator_tenant_id: str
        :return: An iterator like instance of either SnapshotResource or the result of cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.appcomplianceautomation.models.SnapshotResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.SnapshotResourceListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    report_name=report_name,
                    skip_token=skip_token,
                    top=top,
                    select=select,
                    filter=filter,
                    orderby=orderby,
                    offer_guid=offer_guid,
                    report_creator_tenant_id=report_creator_tenant_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("SnapshotResourceListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get(self, report_name: str, snapshot_name: str, **kwargs: Any) -> _models.SnapshotResource:
        """Get the AppComplianceAutomation snapshot and its properties.

        :param report_name: Report Name. Required.
        :type report_name: str
        :param snapshot_name: Snapshot Name. Required.
        :type snapshot_name: str
        :return: SnapshotResource or the result of cls(response)
        :rtype: ~azure.mgmt.appcomplianceautomation.models.SnapshotResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.SnapshotResource] = kwargs.pop("cls", None)

        _request = build_get_request(
            report_name=report_name,
            snapshot_name=snapshot_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SnapshotResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    def _download_initial(
        self,
        report_name: str,
        snapshot_name: str,
        body: Union[_models.SnapshotDownloadRequest, IO[bytes]],
        **kwargs: Any
    ) -> Optional[_models.DownloadResponse]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.DownloadResponse]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "SnapshotDownloadRequest")

        _request = build_download_request(
            report_name=report_name,
            snapshot_name=snapshot_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            deserialized = self._deserialize("DownloadResponse", pipeline_response)

        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_download(
        self,
        report_name: str,
        snapshot_name: str,
        body: _models.SnapshotDownloadRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.DownloadResponse]:
        """Download compliance needs from snapshot, like: Compliance Report, Resource List.

        :param report_name: Report Name. Required.
        :type report_name: str
        :param snapshot_name: Snapshot Name. Required.
        :type snapshot_name: str
        :param body: Parameters for the query operation. Required.
        :type body: ~azure.mgmt.appcomplianceautomation.models.SnapshotDownloadRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns either DownloadResponse or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.appcomplianceautomation.models.DownloadResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_download(
        self,
        report_name: str,
        snapshot_name: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.DownloadResponse]:
        """Download compliance needs from snapshot, like: Compliance Report, Resource List.

        :param report_name: Report Name. Required.
        :type report_name: str
        :param snapshot_name: Snapshot Name. Required.
        :type snapshot_name: str
        :param body: Parameters for the query operation. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns either DownloadResponse or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.appcomplianceautomation.models.DownloadResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_download(
        self,
        report_name: str,
        snapshot_name: str,
        body: Union[_models.SnapshotDownloadRequest, IO[bytes]],
        **kwargs: Any
    ) -> LROPoller[_models.DownloadResponse]:
        """Download compliance needs from snapshot, like: Compliance Report, Resource List.

        :param report_name: Report Name. Required.
        :type report_name: str
        :param snapshot_name: Snapshot Name. Required.
        :type snapshot_name: str
        :param body: Parameters for the query operation. Is either a SnapshotDownloadRequest type or a
         IO[bytes] type. Required.
        :type body: ~azure.mgmt.appcomplianceautomation.models.SnapshotDownloadRequest or IO[bytes]
        :return: An instance of LROPoller that returns either DownloadResponse or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.appcomplianceautomation.models.DownloadResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DownloadResponse] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._download_initial(
                report_name=report_name,
                snapshot_name=snapshot_name,
                body=body,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("DownloadResponse", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.DownloadResponse].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.DownloadResponse](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )
