# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CheckNameRequest(_serialization.Model):
    """The result returned from a database check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Resource name. Required.
    :vartype name: str
    :ivar type: The type of resource, for instance Microsoft.DigitalTwins/digitalTwinsInstances.
     Required. Default value is "Microsoft.DigitalTwins/digitalTwinsInstances".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.DigitalTwins/digitalTwinsInstances"

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Resource name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CheckNameResult(_serialization.Model):
    """The result returned from a check name availability request.

    :ivar name_available: Specifies a Boolean value that indicates if the name is available.
    :vartype name_available: bool
    :ivar name: The name that was checked.
    :vartype name: str
    :ivar message: Message indicating an unavailable name due to a conflict, or a description of
     the naming rules that are violated.
    :vartype message: str
    :ivar reason: Message providing the reason why the given name is invalid. Known values are:
     "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.Reason
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        name: Optional[str] = None,
        message: Optional[str] = None,
        reason: Optional[Union[str, "_models.Reason"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Specifies a Boolean value that indicates if the name is available.
        :paramtype name_available: bool
        :keyword name: The name that was checked.
        :paramtype name: str
        :keyword message: Message indicating an unavailable name due to a conflict, or a description of
         the naming rules that are violated.
        :paramtype message: str
        :keyword reason: Message providing the reason why the given name is invalid. Known values are:
         "Invalid" and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.Reason
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.name = name
        self.message = message
        self.reason = reason


class DigitalTwinsResource(_serialization.Model):
    """The common properties of a DigitalTwinsInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location. Required.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: This property is reserved for future use, and will be ignored/omitted.
    :vartype sku: ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsSkuInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "DigitalTwinsSkuInfo"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.DigitalTwinsSkuInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The resource location. Required.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: This property is reserved for future use, and will be ignored/omitted.
        :paramtype sku: ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsSkuInfo
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.sku = sku


class DigitalTwinsDescription(DigitalTwinsResource):
    """The description of the DigitalTwins service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location. Required.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: This property is reserved for future use, and will be ignored/omitted.
    :vartype sku: ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsSkuInfo
    :ivar created_time: Time when DigitalTwinsInstance was created.
    :vartype created_time: ~datetime.datetime
    :ivar last_updated_time: Time when DigitalTwinsInstance was created.
    :vartype last_updated_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.ProvisioningState
    :ivar host_name: Api endpoint to work with DigitalTwinsInstance.
    :vartype host_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "location": {"required": True},
        "created_time": {"readonly": True},
        "last_updated_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "host_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "DigitalTwinsSkuInfo"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.DigitalTwinsSkuInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The resource location. Required.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: This property is reserved for future use, and will be ignored/omitted.
        :paramtype sku: ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsSkuInfo
        """
        super().__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.created_time = None
        self.last_updated_time = None
        self.provisioning_state = None
        self.host_name = None


class DigitalTwinsDescriptionListResult(_serialization.Model):
    """A list of DigitalTwins description objects with a next link.

    :ivar next_link: The link used to get the next page of DigitalTwins description objects.
    :vartype next_link: str
    :ivar value: A list of DigitalTwins description objects.
    :vartype value:
     list[~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsDescription]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DigitalTwinsDescription]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.DigitalTwinsDescription"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of DigitalTwins description objects.
        :paramtype next_link: str
        :keyword value: A list of DigitalTwins description objects.
        :paramtype value:
         list[~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsDescription]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ExternalResource(_serialization.Model):
    """Definition of a Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: Extension resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class DigitalTwinsEndpointResource(ExternalResource):
    """DigitalTwinsInstance endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: Extension resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar properties: DigitalTwinsInstance endpoint resource properties.
    :vartype properties:
     ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsEndpointResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DigitalTwinsEndpointResourceProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.DigitalTwinsEndpointResourceProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: DigitalTwinsInstance endpoint resource properties.
        :paramtype properties:
         ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsEndpointResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DigitalTwinsEndpointResourceListResult(_serialization.Model):
    """A list of DigitalTwinsInstance Endpoints with a next link.

    :ivar next_link: The link used to get the next page of DigitalTwinsInstance Endpoints.
    :vartype next_link: str
    :ivar value: A list of DigitalTwinsInstance Endpoints.
    :vartype value:
     list[~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsEndpointResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DigitalTwinsEndpointResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.DigitalTwinsEndpointResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of DigitalTwinsInstance Endpoints.
        :paramtype next_link: str
        :keyword value: A list of DigitalTwinsInstance Endpoints.
        :paramtype value:
         list[~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsEndpointResource]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DigitalTwinsEndpointResourceProperties(_serialization.Model):
    """Properties related to Digital Twins Endpoint.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EventGrid, EventHub, ServiceBus

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    _subtype_map = {"endpoint_type": {"EventGrid": "EventGrid", "EventHub": "EventHub", "ServiceBus": "ServiceBus"}}

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.endpoint_type: Optional[str] = None
        self.provisioning_state = None
        self.created_time = None
        self.tags = tags


class DigitalTwinsPatchDescription(_serialization.Model):
    """The description of the DigitalTwins service.

    :ivar tags: Instance tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Instance tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class DigitalTwinsSkuInfo(_serialization.Model):
    """Information about the SKU of the DigitalTwinsInstance.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the SKU. Required. "F1"
    :vartype name: str or ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsSku
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Union[str, "_models.DigitalTwinsSku"], **kwargs: Any) -> None:
        """
        :keyword name: The name of the SKU. Required. "F1"
        :paramtype name: str or ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.DigitalTwinsSku
        """
        super().__init__(**kwargs)
        self.name = name


class ErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.digitaltwins.v2020_03_01_preview.models.ErrorDefinition]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinition]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class ErrorResponse(_serialization.Model):
    """Error response.

    :ivar error: Error description.
    :vartype error: ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.ErrorDefinition
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinition"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinition"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Error description.
        :paramtype error: ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.ErrorDefinition
        """
        super().__init__(**kwargs)
        self.error = error


class EventGrid(DigitalTwinsEndpointResourceProperties):
    """properties related to eventgrid.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar topic_endpoint: EventGrid Topic Endpoint.
    :vartype topic_endpoint: str
    :ivar access_key1: EventGrid secondary accesskey. Will be obfuscated during read. Required.
    :vartype access_key1: str
    :ivar access_key2: EventGrid secondary accesskey. Will be obfuscated during read. Required.
    :vartype access_key2: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
        "access_key1": {"required": True},
        "access_key2": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "tags": {"key": "tags", "type": "{str}"},
        "topic_endpoint": {"key": "TopicEndpoint", "type": "str"},
        "access_key1": {"key": "accessKey1", "type": "str"},
        "access_key2": {"key": "accessKey2", "type": "str"},
    }

    def __init__(
        self,
        *,
        access_key1: str,
        access_key2: str,
        tags: Optional[Dict[str, str]] = None,
        topic_endpoint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword topic_endpoint: EventGrid Topic Endpoint.
        :paramtype topic_endpoint: str
        :keyword access_key1: EventGrid secondary accesskey. Will be obfuscated during read. Required.
        :paramtype access_key1: str
        :keyword access_key2: EventGrid secondary accesskey. Will be obfuscated during read. Required.
        :paramtype access_key2: str
        """
        super().__init__(tags=tags, **kwargs)
        self.endpoint_type: str = "EventGrid"
        self.topic_endpoint = topic_endpoint
        self.access_key1 = access_key1
        self.access_key2 = access_key2


class EventHub(DigitalTwinsEndpointResourceProperties):
    """properties related to eventhub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar connection_string_primary_key: PrimaryConnectionString of the endpoint. Will be
     obfuscated during read. Required.
    :vartype connection_string_primary_key: str
    :ivar connection_string_secondary_key: SecondaryConnectionString of the endpoint. Will be
     obfuscated during read. Required.
    :vartype connection_string_secondary_key: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
        "connection_string_primary_key": {"required": True},
        "connection_string_secondary_key": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "tags": {"key": "tags", "type": "{str}"},
        "connection_string_primary_key": {"key": "connectionString-PrimaryKey", "type": "str"},
        "connection_string_secondary_key": {"key": "connectionString-SecondaryKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        connection_string_primary_key: str,
        connection_string_secondary_key: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword connection_string_primary_key: PrimaryConnectionString of the endpoint. Will be
         obfuscated during read. Required.
        :paramtype connection_string_primary_key: str
        :keyword connection_string_secondary_key: SecondaryConnectionString of the endpoint. Will be
         obfuscated during read. Required.
        :paramtype connection_string_secondary_key: str
        """
        super().__init__(tags=tags, **kwargs)
        self.endpoint_type: str = "EventHub"
        self.connection_string_primary_key = connection_string_primary_key
        self.connection_string_secondary_key = connection_string_secondary_key


class Operation(_serialization.Model):
    """DigitalTwins service REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{read | write | action | delete}.
    :vartype name: str
    :ivar display: Operation properties display.
    :vartype display: ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.OperationDisplay
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Operation properties display.
        :paramtype display: ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft DigitalTwins.
    :vartype provider: str
    :ivar resource: Resource Type: DigitalTwinsInstances.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Friendly description for the operation,.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of DigitalTwins service operations. It contains a list of operations and a URL link to
    get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The link used to get the next page of DigitalTwins description objects.
    :vartype next_link: str
    :ivar value: A list of DigitalTwins operations supported by the Microsoft.DigitalTwins resource
     provider.
    :vartype value: list[~azure.mgmt.digitaltwins.v2020_03_01_preview.models.Operation]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The link used to get the next page of DigitalTwins description objects.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class ServiceBus(DigitalTwinsEndpointResourceProperties):
    """properties related to servicebus.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_03_01_preview.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar primary_connection_string: PrimaryConnectionString of the endpoint. Will be obfuscated
     during read. Required.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: SecondaryConnectionString of the endpoint. Will be
     obfuscated during read. Required.
    :vartype secondary_connection_string: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
        "primary_connection_string": {"required": True},
        "secondary_connection_string": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "tags": {"key": "tags", "type": "{str}"},
        "primary_connection_string": {"key": "primaryConnectionString", "type": "str"},
        "secondary_connection_string": {"key": "secondaryConnectionString", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_connection_string: str,
        secondary_connection_string: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword primary_connection_string: PrimaryConnectionString of the endpoint. Will be obfuscated
         during read. Required.
        :paramtype primary_connection_string: str
        :keyword secondary_connection_string: SecondaryConnectionString of the endpoint. Will be
         obfuscated during read. Required.
        :paramtype secondary_connection_string: str
        """
        super().__init__(tags=tags, **kwargs)
        self.endpoint_type: str = "ServiceBus"
        self.primary_connection_string = primary_connection_string
        self.secondary_connection_string = secondary_connection_string
