# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._web_site_management_client_enums import *


class AppServiceCertificate(msrest.serialization.Model):
    """Key Vault container for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceCertificate, self).__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateCollection(msrest.serialization.Model):
    """Collection of certificate order certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceCertificateResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServiceCertificateResource"],
        **kwargs
    ):
        super(AppServiceCertificateCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Resource(msrest.serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.location = location
        self.type = None
        self.tags = tags


class AppServiceCertificateOrder(Resource):
    """SSL certificate purchase order.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param certificates: State of the Key Vault secret.
    :type certificates: dict[str, ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificate]
    :param distinguished_name: Certificate distinguished name.
    :type distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :param validity_in_years: Duration in years (must be between 1 and 3).
    :type validity_in_years: int
    :param key_size: Certificate key size.
    :type key_size: int
    :param product_type: Certificate product type. Possible values include:
     "StandardDomainValidatedSsl", "StandardDomainValidatedWildCardSsl".
    :type product_type: str or ~azure.mgmt.web.v2015_08_01.models.CertificateProductType
    :param auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :type auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_08_01.models.ProvisioningState
    :ivar status: Current order status. Possible values include: "Pendingissuance", "Issued",
     "Revoked", "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired",
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2015_08_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :param csr: Last CSR that was created for this order.
    :type csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrderPropertiesAppServiceCertificateNotRenewableReasonsItem]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'domain_verification_token': {'readonly': True},
        'validity_in_years': {'maximum': 3, 'minimum': 1},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'signed_certificate': {'readonly': True},
        'intermediate': {'readonly': True},
        'root': {'readonly': True},
        'serial_number': {'readonly': True},
        'last_certificate_issuance_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'is_private_key_external': {'readonly': True},
        'app_service_certificate_not_renewable_reasons': {'readonly': True},
        'next_auto_renewal_time_stamp': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'certificates': {'key': 'properties.certificates', 'type': '{AppServiceCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'str'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
        'app_service_certificate_not_renewable_reasons': {'key': 'properties.appServiceCertificateNotRenewableReasons', 'type': '[str]'},
        'next_auto_renewal_time_stamp': {'key': 'properties.nextAutoRenewalTimeStamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        certificates: Optional[Dict[str, "AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: Optional[int] = 1,
        key_size: Optional[int] = 2048,
        product_type: Optional[Union[str, "CertificateProductType"]] = None,
        auto_renew: Optional[bool] = True,
        csr: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceCertificateOrder, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None


class AppServiceCertificateOrderCollection(msrest.serialization.Model):
    """Collection of certificate orders.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceCertificateOrder]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServiceCertificateOrder"],
        **kwargs
    ):
        super(AppServiceCertificateOrderCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProxyOnlyResource(msrest.serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.type = None


class AppServiceCertificateOrderPatchResource(ProxyOnlyResource):
    """ARM resource for a certificate order that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param certificates: State of the Key Vault secret.
    :type certificates: dict[str, ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificate]
    :param distinguished_name: Certificate distinguished name.
    :type distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :param validity_in_years: Duration in years (must be between 1 and 3).
    :type validity_in_years: int
    :param key_size: Certificate key size.
    :type key_size: int
    :param product_type: Certificate product type. Possible values include:
     "StandardDomainValidatedSsl", "StandardDomainValidatedWildCardSsl".
    :type product_type: str or ~azure.mgmt.web.v2015_08_01.models.CertificateProductType
    :param auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :type auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_08_01.models.ProvisioningState
    :ivar status: Current order status. Possible values include: "Pendingissuance", "Issued",
     "Revoked", "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired",
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2015_08_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :param csr: Last CSR that was created for this order.
    :type csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrderPatchResourcePropertiesAppServiceCertificateNotRenewableReasonsItem]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'domain_verification_token': {'readonly': True},
        'validity_in_years': {'maximum': 3, 'minimum': 1},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'signed_certificate': {'readonly': True},
        'intermediate': {'readonly': True},
        'root': {'readonly': True},
        'serial_number': {'readonly': True},
        'last_certificate_issuance_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'is_private_key_external': {'readonly': True},
        'app_service_certificate_not_renewable_reasons': {'readonly': True},
        'next_auto_renewal_time_stamp': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'certificates': {'key': 'properties.certificates', 'type': '{AppServiceCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'str'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
        'app_service_certificate_not_renewable_reasons': {'key': 'properties.appServiceCertificateNotRenewableReasons', 'type': '[str]'},
        'next_auto_renewal_time_stamp': {'key': 'properties.nextAutoRenewalTimeStamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        certificates: Optional[Dict[str, "AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: Optional[int] = 1,
        key_size: Optional[int] = 2048,
        product_type: Optional[Union[str, "CertificateProductType"]] = None,
        auto_renew: Optional[bool] = True,
        csr: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceCertificateOrderPatchResource, self).__init__(kind=kind, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None


class AppServiceCertificatePatchResource(ProxyOnlyResource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceCertificatePatchResource, self).__init__(kind=kind, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateResource(Resource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        super(AppServiceCertificateResource, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class CertificateDetails(msrest.serialization.Model):
    """SSL certificate details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: Certificate Version.
    :vartype version: int
    :ivar serial_number: Certificate Serial Number.
    :vartype serial_number: str
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    :ivar subject: Certificate Subject.
    :vartype subject: str
    :ivar not_before: Date Certificate is valid from.
    :vartype not_before: ~datetime.datetime
    :ivar not_after: Date Certificate is valid to.
    :vartype not_after: ~datetime.datetime
    :ivar signature_algorithm: Certificate Signature algorithm.
    :vartype signature_algorithm: str
    :ivar issuer: Certificate Issuer.
    :vartype issuer: str
    :ivar raw_data: Raw certificate data.
    :vartype raw_data: str
    """

    _validation = {
        'version': {'readonly': True},
        'serial_number': {'readonly': True},
        'thumbprint': {'readonly': True},
        'subject': {'readonly': True},
        'not_before': {'readonly': True},
        'not_after': {'readonly': True},
        'signature_algorithm': {'readonly': True},
        'issuer': {'readonly': True},
        'raw_data': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'int'},
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'not_before': {'key': 'notBefore', 'type': 'iso-8601'},
        'not_after': {'key': 'notAfter', 'type': 'iso-8601'},
        'signature_algorithm': {'key': 'signatureAlgorithm', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'raw_data': {'key': 'rawData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateDetails, self).__init__(**kwargs)
        self.version = None
        self.serial_number = None
        self.thumbprint = None
        self.subject = None
        self.not_before = None
        self.not_after = None
        self.signature_algorithm = None
        self.issuer = None
        self.raw_data = None


class CertificateEmail(ProxyOnlyResource):
    """SSL certificate email.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param email_id: Email id.
    :type email_id: str
    :param time_stamp: Time stamp.
    :type time_stamp: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email_id': {'key': 'properties.emailId', 'type': 'str'},
        'time_stamp': {'key': 'properties.timeStamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        email_id: Optional[str] = None,
        time_stamp: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(CertificateEmail, self).__init__(kind=kind, **kwargs)
        self.email_id = email_id
        self.time_stamp = time_stamp


class CertificateOrderAction(ProxyOnlyResource):
    """Certificate order action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param type_properties_type: Action type. Possible values include: "CertificateIssued",
     "CertificateOrderCanceled", "CertificateOrderCreated", "CertificateRevoked",
     "DomainValidationComplete", "FraudDetected", "OrgNameChange", "OrgValidationComplete",
     "SanDrop", "FraudCleared", "CertificateExpired", "CertificateExpirationWarning",
     "FraudDocumentationRequired", "Unknown".
    :type type_properties_type: str or
     ~azure.mgmt.web.v2015_08_01.models.CertificateOrderActionType
    :param created_at: Time at which the certificate action was performed.
    :type created_at: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        type_properties_type: Optional[Union[str, "CertificateOrderActionType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(CertificateOrderAction, self).__init__(kind=kind, **kwargs)
        self.type_properties_type = type_properties_type
        self.created_at = created_at


class CsmOperationCollection(msrest.serialization.Model):
    """Collection of Azure resource manager operation metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2015_08_01.models.CsmOperationDescription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmOperationDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["CsmOperationDescription"],
        **kwargs
    ):
        super(CsmOperationCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CsmOperationDescription(msrest.serialization.Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :param name:
    :type name: str
    :param display: Meta data about operation used for display in portal.
    :type display: ~azure.mgmt.web.v2015_08_01.models.CsmOperationDisplay
    :param origin:
    :type origin: str
    :param properties: Properties available for a Microsoft.Web resource provider operation.
    :type properties: ~azure.mgmt.web.v2015_08_01.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'CsmOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CsmOperationDescriptionProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["CsmOperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["CsmOperationDescriptionProperties"] = None,
        **kwargs
    ):
        super(CsmOperationDescription, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class CsmOperationDescriptionProperties(msrest.serialization.Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :param service_specification: Resource metrics service provided by Microsoft.Insights resource
     provider.
    :type service_specification: ~azure.mgmt.web.v2015_08_01.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        service_specification: Optional["ServiceSpecification"] = None,
        **kwargs
    ):
        super(CsmOperationDescriptionProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class CsmOperationDisplay(msrest.serialization.Model):
    """Meta data about operation used for display in portal.

    :param provider:
    :type provider: str
    :param resource:
    :type resource: str
    :param operation:
    :type operation: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(CsmOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class Dimension(msrest.serialization.Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app, 
where instance name is dimension of the metric HTTP request.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param internal_name:
    :type internal_name: str
    :param to_be_exported_for_shoebox:
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs
    ):
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class MetricAvailability(msrest.serialization.Model):
    """Retention policy of a resource metric.

    :param time_grain:
    :type time_grain: str
    :param blob_duration:
    :type blob_duration: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(msrest.serialization.Model):
    """Definition of a single resource metric.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param display_description:
    :type display_description: str
    :param unit:
    :type unit: str
    :param aggregation_type:
    :type aggregation_type: str
    :param supports_instance_level_aggregation:
    :type supports_instance_level_aggregation: bool
    :param enable_regional_mdm_account:
    :type enable_regional_mdm_account: bool
    :param source_mdm_account:
    :type source_mdm_account: str
    :param source_mdm_namespace:
    :type source_mdm_namespace: str
    :param metric_filter_pattern:
    :type metric_filter_pattern: str
    :param fill_gap_with_zero:
    :type fill_gap_with_zero: bool
    :param is_internal:
    :type is_internal: bool
    :param dimensions:
    :type dimensions: list[~azure.mgmt.web.v2015_08_01.models.Dimension]
    :param category:
    :type category: str
    :param availabilities:
    :type availabilities: list[~azure.mgmt.web.v2015_08_01.models.MetricAvailability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supports_instance_level_aggregation': {'key': 'supportsInstanceLevelAggregation', 'type': 'bool'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'category': {'key': 'category', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[MetricAvailability]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supports_instance_level_aggregation: Optional[bool] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        metric_filter_pattern: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        is_internal: Optional[bool] = None,
        dimensions: Optional[List["Dimension"]] = None,
        category: Optional[str] = None,
        availabilities: Optional[List["MetricAvailability"]] = None,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.metric_filter_pattern = metric_filter_pattern
        self.fill_gap_with_zero = fill_gap_with_zero
        self.is_internal = is_internal
        self.dimensions = dimensions
        self.category = category
        self.availabilities = availabilities


class NameIdentifier(msrest.serialization.Model):
    """Identifies an object.

    :param name: Name of the object.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(NameIdentifier, self).__init__(**kwargs)
        self.name = name


class ReissueCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate reissue request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_size: Certificate Key Size.
    :type key_size: int
    :param delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after the
     new certificate is issued.
    :type delay_existing_revoke_in_hours: int
    :param csr: Csr to be used for re-key operation.
    :type csr: str
    :param is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :type is_private_key_external: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'delay_existing_revoke_in_hours': {'key': 'properties.delayExistingRevokeInHours', 'type': 'int'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        delay_existing_revoke_in_hours: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs
    ):
        super(ReissueCertificateOrderRequest, self).__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.delay_existing_revoke_in_hours = delay_existing_revoke_in_hours
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RenewCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate renew request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_size: Certificate Key Size.
    :type key_size: int
    :param csr: Csr to be used for re-key operation.
    :type csr: str
    :param is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :type is_private_key_external: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs
    ):
        super(RenewCertificateOrderRequest, self).__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class ServiceSpecification(msrest.serialization.Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :param metric_specifications:
    :type metric_specifications: list[~azure.mgmt.web.v2015_08_01.models.MetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["MetricSpecification"]] = None,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class SiteSeal(msrest.serialization.Model):
    """Site seal.

    All required parameters must be populated in order to send to Azure.

    :param html: Required. HTML snippet.
    :type html: str
    """

    _validation = {
        'html': {'required': True},
    }

    _attribute_map = {
        'html': {'key': 'html', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        html: str,
        **kwargs
    ):
        super(SiteSeal, self).__init__(**kwargs)
        self.html = html


class SiteSealRequest(msrest.serialization.Model):
    """Site seal request.

    :param light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
     otherwise, use the default color theme.
    :type light_theme: bool
    :param locale: Locale of site seal.
    :type locale: str
    """

    _attribute_map = {
        'light_theme': {'key': 'lightTheme', 'type': 'bool'},
        'locale': {'key': 'locale', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        light_theme: Optional[bool] = None,
        locale: Optional[str] = None,
        **kwargs
    ):
        super(SiteSealRequest, self).__init__(**kwargs)
        self.light_theme = light_theme
        self.locale = locale
