# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LatestOperationResult(Model):
    """Details of the status of an operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar status: The current status of the operation.
    :vartype status: str
    :ivar error_code: Error code on failure.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    :ivar request_uri: Request URI of the operation.
    :vartype request_uri: str
    :ivar http_method: The HttpMethod - PUT/POST/DELETE for the operation.
    :vartype http_method: str
    :ivar operation_url: The URL to use to check long-running operation status
    :vartype operation_url: str
    """

    _validation = {
        'status': {'readonly': True},
        'error_code': {'readonly': True},
        'error_message': {'readonly': True},
        'request_uri': {'readonly': True},
        'http_method': {'readonly': True},
        'operation_url': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'http_method': {'key': 'httpMethod', 'type': 'str'},
        'operation_url': {'key': 'operationUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(LatestOperationResult, self).__init__(**kwargs)
        self.status = None
        self.error_code = None
        self.error_message = None
        self.request_uri = None
        self.http_method = None
        self.operation_url = None
