# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationInsightsComponentFeature(Model):
    """An Application Insights component daily data volume cap status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar feature_name: The pricing feature name.
    :vartype feature_name: str
    :ivar meter_id: The meter id used for the feature.
    :vartype meter_id: str
    :ivar meter_rate_frequency: The meter rate for the feature's meter.
    :vartype meter_rate_frequency: str
    :ivar resouce_id: Reserved, not used now.
    :vartype resouce_id: str
    :ivar is_hidden: Reserved, not used now.
    :vartype is_hidden: bool
    :ivar capabilities: A list of Application Insights component feature
     capability.
    :vartype capabilities:
     list[~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFeatureCapability]
    :ivar title: Display name of the feature.
    :vartype title: str
    :ivar is_main_feature: Whether can apply addon feature on to it.
    :vartype is_main_feature: bool
    :ivar supported_addon_features: The add on features on main feature.
    :vartype supported_addon_features: str
    """

    _validation = {
        'feature_name': {'readonly': True},
        'meter_id': {'readonly': True},
        'meter_rate_frequency': {'readonly': True},
        'resouce_id': {'readonly': True},
        'is_hidden': {'readonly': True},
        'capabilities': {'readonly': True},
        'title': {'readonly': True},
        'is_main_feature': {'readonly': True},
        'supported_addon_features': {'readonly': True},
    }

    _attribute_map = {
        'feature_name': {'key': 'FeatureName', 'type': 'str'},
        'meter_id': {'key': 'MeterId', 'type': 'str'},
        'meter_rate_frequency': {'key': 'MeterRateFrequency', 'type': 'str'},
        'resouce_id': {'key': 'ResouceId', 'type': 'str'},
        'is_hidden': {'key': 'IsHidden', 'type': 'bool'},
        'capabilities': {'key': 'Capabilities', 'type': '[ApplicationInsightsComponentFeatureCapability]'},
        'title': {'key': 'Title', 'type': 'str'},
        'is_main_feature': {'key': 'IsMainFeature', 'type': 'bool'},
        'supported_addon_features': {'key': 'SupportedAddonFeatures', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationInsightsComponentFeature, self).__init__(**kwargs)
        self.feature_name = None
        self.meter_id = None
        self.meter_rate_frequency = None
        self.resouce_id = None
        self.is_hidden = None
        self.capabilities = None
        self.title = None
        self.is_main_feature = None
        self.supported_addon_features = None
