/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.lang.StringUtils;

/**
 * 翻訳単語のトレース調査を行うための辞書クラスです。
 * pleiades-config.xml に指定したトレース対象に一致したときの状態をトレースします。
 * <p>
 * @author cypher256
 */
public class TraceableTranslationDictionary extends UnderscoreMnemonicDictionary {

	/** ロガー */
	private static final Logger log = Logger.getLogger(TraceableTranslationDictionary.class);
	private static String tracePattern;
	private static Boolean traceIsJa;

	/**
	 * トレース翻訳辞書を生成します。
	 * @return Pleiades 構成ファイルに trace.pattern が未設定の場合は null
	 */
	public static TraceableTranslationDictionary getInstance() {

		PleiadesConfig config = PleiadesConfig.getInstance();
		tracePattern = config.getProperty("trace.pattern");

		if (StringUtils.isNotEmpty(tracePattern)) {
			traceIsJa = Boolean.valueOf(config.getProperty("trace.is.ja"));
			log.warn("トレース翻訳辞書を生成します。tracePattern=%s, traceIsJa=%s", tracePattern, traceIsJa);
			return new TraceableTranslationDictionary();
		}
		return null;
	}

	/**
	 * トレース翻訳辞書を構築します。
	 */
	private TraceableTranslationDictionary() {
	}

	@Override
	protected String lookupInternal(String en, JointPoint jointPoint) {

		String ja = super.lookupInternal(en, jointPoint);

		String target = traceIsJa ? ja : en;
		if (target.matches(tracePattern)) {
			String s = System.currentTimeMillis() + "「" + en + "」→「" + ja + "」";
			log.debug(new Exception(s), "デバッグ翻訳追跡スタックトレース jointPoint:" + jointPoint);
			return s;
		}
		return ja;
	}
}
