-- This sample shows how to invoke an ImageJ script on every DICOM
-- image received by Orthanc. The ImageJ script is generated by the
-- "Initialize()" function at the startup of Orthanc. Whenever a new
-- instance is received, its DICOM file is stored into a temporary
-- file, and a system call to ImageJ is triggered.

SCRIPT = 'ImageJScript.txt'

function Initialize()
   local target = assert(io.open(SCRIPT, 'w'))

   -- This is a sample ImageJ script that display the size of the DICOM image
   target:write('if (getArgument=="") exit ("No argument!");\n')
   target:write('open(getArgument);\n')
   target:write('print(getTitle + ": " + getWidth + "x" + getHeight);\n')

   target:close()
end

function OnStoredInstance(instanceId)
   -- Retrieve the DICOM instance from Orthanc
   local dicom = RestApiGet('/instances/' .. instanceId .. '/file')

   -- Write the DICOM content to some temporary file
   local path = instanceId .. '.dcm'
   local target = assert(io.open(path, 'wb'))
   target:write(dicom)
   target:close()

   -- Call ImageJ
   os.execute('imagej -b ' .. SCRIPT .. ' ' .. path)

   -- Remove the temporary DICOM file
   os.remove(path)
end
