/**
 * Orthanc - A Lightweight, RESTful DICOM Store
 * Copyright (C) 2012-2016 Sebastien Jodogne, Medical Physics
 * Department, University Hospital of Liege, Belgium
 * Copyright (C) 2017-2022 Osimis S.A., Belgium
 * Copyright (C) 2021-2022 Sebastien Jodogne, ICTEAM UCLouvain, Belgium
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program. If not, see
 * <http://www.gnu.org/licenses/>.
 **/


#pragma once

#include <dcmtk/dcmnet/assoc.h>

#include "../DicomFormat/DicomMap.h"

#include <string>


namespace Orthanc
{
  class IGetRequestHandler : boost::noncopyable
  {
  public:
    virtual ~IGetRequestHandler()
    {
    }

    virtual bool Handle(const DicomMap& input,
                        const std::string& originatorIp,
                        const std::string& originatorAet,
                        const std::string& calledAet,
                        uint32_t timeout) = 0;
    
    virtual unsigned int GetSubOperationCount() const = 0;

    // Must return "false" iff. a "Cancel" was returned by the remote SCU
    virtual bool DoNext(T_ASC_Association *) = 0;
    
    virtual unsigned int GetCompletedCount() const = 0;
    
    virtual unsigned int GetWarningCount() const = 0;
    
    virtual unsigned int GetFailedCount() const = 0;
    
    virtual const std::string& GetFailedUids() const = 0;
  };
}
