/* Generated by re2c 1.2.1 */
/**
 * MojoShader; generate shader programs from bytecode of compiled
 *  Direct3D shaders.
 *
 * Please see the file LICENSE.txt in the source's root directory.
 *
 *  This file written by Ryan C. Gordon.
 */

// This was originally based on examples/pp-c.re from re2c: http://re2c.org/
//   re2c is public domain code.
//
// You build mojoshader_lexer.c from the .re file with re2c...
// re2c -is -o mojoshader_lexer.c mojoshader_lexer.re
//
// Changes to the lexer are done to the .re file, not the C code!
//
// Please note that this isn't a perfect C lexer, since it is used for both
//  HLSL and shader assembly language, and follows the quirks of Microsoft's
//  tools.

#define __MOJOSHADER_INTERNAL__ 1
#include "mojoshader_internal.h"

typedef unsigned char uchar;

#define YYMAXFILL 8

#define RET(t) return update_state(s, eoi, cursor, token, (Token) t)
#define YYCTYPE uchar
#define YYCURSOR cursor
#define YYLIMIT limit
#define YYMARKER s->lexer_marker
#define YYFILL(n) { if ((n) == 1) { cursor = sentinel; limit = cursor + YYMAXFILL; eoi = 1; } }

static uchar sentinel[YYMAXFILL];

static Token update_state(IncludeState *s, int eoi, const uchar *cur,
                          const uchar *tok, const Token val)
{
    if (eoi)
    {
        s->bytes_left = 0;
        s->source = (const char *) s->source_base + s->orig_length;
        if ( (tok >= sentinel) && (tok < (sentinel+YYMAXFILL)) )
            s->token = s->source;
        else
            s->token = (const char *) tok;
    } // if
    else
    {
        s->bytes_left -= (unsigned int) (cur - ((const uchar *) s->source));
        s->source = (const char *) cur;
        s->token = (const char *) tok;
    } // else
    s->tokenlen = (unsigned int) (s->source - s->token);
    s->tokenval = val;
    return val;
} // update_state

Token preprocessor_lexer(IncludeState *s)
{
    const uchar *cursor = (const uchar *) s->source;
    const uchar *token = cursor;
    const uchar *matchptr;
    const uchar *limit = cursor + s->bytes_left;
    int eoi = 0;



    // preprocessor directives are only valid at start of line.
    if (s->tokenval == ((Token) '\n'))
        goto ppdirective;  // may jump back to scanner_loop.

scanner_loop:
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    token = cursor;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto yy2;
	case '\t':
	case '\v':
	case '\f':
	case ' ':	goto yy6;
	case '\n':	goto yy9;
	case '\r':	goto yy11;
	case '!':	goto yy12;
	case '"':	goto yy14;
	case '#':	goto yy15;
	case '%':	goto yy17;
	case '&':	goto yy19;
	case '\'':	goto yy21;
	case '(':	goto yy22;
	case ')':	goto yy24;
	case '*':	goto yy26;
	case '+':	goto yy28;
	case ',':	goto yy30;
	case '-':	goto yy32;
	case '.':	goto yy34;
	case '/':	goto yy36;
	case '0':	goto yy38;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy40;
	case ':':	goto yy42;
	case ';':	goto yy44;
	case '<':	goto yy46;
	case '=':	goto yy48;
	case '>':	goto yy50;
	case '?':	goto yy52;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy54;
	case '[':	goto yy57;
	case '\\':	goto yy59;
	case ']':	goto yy60;
	case '^':	goto yy62;
	case '{':	goto yy64;
	case '|':	goto yy66;
	case '}':	goto yy68;
	case '~':	goto yy70;
	default:	goto yy4;
	}
yy2:
	++YYCURSOR;
	{ if (eoi) { RET(TOKEN_EOI); } goto bad_chars; }
yy4:
	++YYCURSOR;
yy5:
	{ goto bad_chars; }
yy6:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\n') {
		if (yych == '\t') goto yy6;
	} else {
		if (yych <= '\f') goto yy6;
		if (yych == ' ') goto yy6;
	}
	{ if (s->report_whitespace) RET(' '); goto scanner_loop; }
yy9:
	++YYCURSOR;
yy10:
	{ s->line++; RET('\n'); }
yy11:
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy9;
	goto yy10;
yy12:
	yych = *++YYCURSOR;
	if (yych == '=') goto yy72;
	{ RET('!'); }
yy14:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\n') goto yy5;
	if (yych == '\r') goto yy5;
	goto yy75;
yy15:
	yych = *++YYCURSOR;
	if (yych == '#') goto yy80;
	{ RET(TOKEN_HASH); }
yy17:
	yych = *++YYCURSOR;
	if (yych == '=') goto yy82;
	{ RET('%'); }
yy19:
	yych = *++YYCURSOR;
	if (yych == '&') goto yy84;
	if (yych == '=') goto yy86;
	{ RET('&'); }
yy21:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\n') goto yy5;
	if (yych == '\r') goto yy5;
	goto yy89;
yy22:
	++YYCURSOR;
	{ RET('('); }
yy24:
	++YYCURSOR;
	{ RET(')'); }
yy26:
	yych = *++YYCURSOR;
	if (yych == '=') goto yy92;
	{ RET('*'); }
yy28:
	yych = *++YYCURSOR;
	if (yych == '+') goto yy94;
	if (yych == '=') goto yy96;
	{ RET('+'); }
yy30:
	++YYCURSOR;
	{ RET(','); }
yy32:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy98;
	if (yych == '=') goto yy100;
	{ RET('-'); }
yy34:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy35;
	if (yych <= '9') goto yy102;
yy35:
	{ RET('.'); }
yy36:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych == '*') goto yy105;
	} else {
		if (yych <= '/') goto yy107;
		if (yych == '=') goto yy109;
	}
	{ RET('/'); }
yy38:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'X') goto yy114;
	if (yych == 'x') goto yy114;
	goto yy41;
yy39:
	{ RET(TOKEN_INT_LITERAL); }
yy40:
	yyaccept = 1;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
	yych = *YYCURSOR;
yy41:
	if (yych <= 'L') {
		if (yych <= '9') {
			if (yych == '.') goto yy102;
			if (yych <= '/') goto yy39;
			goto yy40;
		} else {
			if (yych == 'E') goto yy111;
			if (yych <= 'K') goto yy39;
			goto yy112;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'U') goto yy112;
			if (yych <= 'd') goto yy39;
			goto yy111;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy39;
				goto yy112;
			} else {
				if (yych == 'u') goto yy112;
				goto yy39;
			}
		}
	}
yy42:
	++YYCURSOR;
	{ RET(':'); }
yy44:
	++YYCURSOR;
	{ if (s->asm_comments) goto singlelinecomment; RET(';'); }
yy46:
	yych = *++YYCURSOR;
	if (yych <= ';') goto yy47;
	if (yych <= '<') goto yy115;
	if (yych <= '=') goto yy117;
yy47:
	{ RET('<'); }
yy48:
	yych = *++YYCURSOR;
	if (yych == '=') goto yy119;
	{ RET('='); }
yy50:
	yych = *++YYCURSOR;
	if (yych <= '<') goto yy51;
	if (yych <= '=') goto yy121;
	if (yych <= '>') goto yy123;
yy51:
	{ RET('>'); }
yy52:
	++YYCURSOR;
	{ RET('?'); }
yy54:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy54;
		if (yych >= 'A') goto yy54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy54;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy54;
		}
	}
yy56:
	{ RET(TOKEN_IDENTIFIER); }
yy57:
	++YYCURSOR;
	{ RET('['); }
yy59:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x08) goto yy5;
	if (yych <= '\r') goto yy126;
	if (yych == ' ') goto yy126;
	goto yy5;
yy60:
	++YYCURSOR;
	{ RET(']'); }
yy62:
	yych = *++YYCURSOR;
	if (yych == '=') goto yy130;
	{ RET('^'); }
yy64:
	++YYCURSOR;
	{ RET('{'); }
yy66:
	yych = *++YYCURSOR;
	if (yych == '=') goto yy132;
	if (yych == '|') goto yy134;
	{ RET('|'); }
yy68:
	++YYCURSOR;
	{ RET('}'); }
yy70:
	++YYCURSOR;
	{ RET('~'); }
yy72:
	++YYCURSOR;
	{ RET(TOKEN_NEQ); }
yy74:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy75:
	if (yych <= '\r') {
		if (yych == '\n') goto yy76;
		if (yych <= '\f') goto yy74;
	} else {
		if (yych <= '"') {
			if (yych <= '!') goto yy74;
			goto yy77;
		} else {
			if (yych == '\\') goto yy79;
			goto yy74;
		}
	}
yy76:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 1) {
		if (yyaccept == 0) {
			goto yy5;
		} else {
			goto yy39;
		}
	} else {
		goto yy104;
	}
yy77:
	++YYCURSOR;
	{ RET(TOKEN_STRING_LITERAL); }
yy79:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 'b') {
		if (yych <= '7') {
			if (yych <= '&') {
				if (yych == '"') goto yy74;
				goto yy76;
			} else {
				if (yych <= '\'') goto yy74;
				if (yych <= '/') goto yy76;
				goto yy74;
			}
		} else {
			if (yych <= '[') {
				if (yych == '?') goto yy74;
				goto yy76;
			} else {
				if (yych <= '\\') goto yy74;
				if (yych <= '`') goto yy76;
				goto yy74;
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'm') {
				if (yych == 'f') goto yy74;
				goto yy76;
			} else {
				if (yych <= 'n') goto yy74;
				if (yych <= 'q') goto yy76;
				goto yy74;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 't') goto yy74;
				goto yy76;
			} else {
				if (yych <= 'v') goto yy74;
				if (yych == 'x') goto yy136;
				goto yy76;
			}
		}
	}
yy80:
	++YYCURSOR;
	{ RET(TOKEN_HASHHASH); }
yy82:
	++YYCURSOR;
	{ RET(TOKEN_MODASSIGN); }
yy84:
	++YYCURSOR;
	{ RET(TOKEN_ANDAND); }
yy86:
	++YYCURSOR;
	{ RET(TOKEN_ANDASSIGN); }
yy88:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy89:
	if (yych <= '\r') {
		if (yych == '\n') goto yy76;
		if (yych <= '\f') goto yy88;
		goto yy76;
	} else {
		if (yych <= '\'') {
			if (yych <= '&') goto yy88;
		} else {
			if (yych == '\\') goto yy91;
			goto yy88;
		}
	}
	++YYCURSOR;
	goto yy39;
yy91:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 'b') {
		if (yych <= '7') {
			if (yych <= '&') {
				if (yych == '"') goto yy88;
				goto yy76;
			} else {
				if (yych <= '\'') goto yy88;
				if (yych <= '/') goto yy76;
				goto yy88;
			}
		} else {
			if (yych <= '[') {
				if (yych == '?') goto yy88;
				goto yy76;
			} else {
				if (yych <= '\\') goto yy88;
				if (yych <= '`') goto yy76;
				goto yy88;
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'm') {
				if (yych == 'f') goto yy88;
				goto yy76;
			} else {
				if (yych <= 'n') goto yy88;
				if (yych <= 'q') goto yy76;
				goto yy88;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 't') goto yy88;
				goto yy76;
			} else {
				if (yych <= 'v') goto yy88;
				if (yych == 'x') goto yy137;
				goto yy76;
			}
		}
	}
yy92:
	++YYCURSOR;
	{ RET(TOKEN_MULTASSIGN); }
yy94:
	++YYCURSOR;
	{ RET(TOKEN_INCREMENT); }
yy96:
	++YYCURSOR;
	{ RET(TOKEN_ADDASSIGN); }
yy98:
	++YYCURSOR;
	{ RET(TOKEN_DECREMENT); }
yy100:
	++YYCURSOR;
	{ RET(TOKEN_SUBASSIGN); }
yy102:
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
	yych = *YYCURSOR;
	if (yych <= 'G') {
		if (yych <= 'D') {
			if (yych <= '/') goto yy104;
			if (yych <= '9') goto yy102;
		} else {
			if (yych <= 'E') goto yy111;
			if (yych <= 'F') goto yy138;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'H') goto yy138;
			if (yych >= 'e') goto yy111;
		} else {
			if (yych == 'g') goto yy104;
			if (yych <= 'h') goto yy138;
		}
	}
yy104:
	{ RET(TOKEN_FLOAT_LITERAL); }
yy105:
	++YYCURSOR;
	{ goto multilinecomment; }
yy107:
	++YYCURSOR;
	{ goto singlelinecomment; }
yy109:
	++YYCURSOR;
	{ RET(TOKEN_DIVASSIGN); }
yy111:
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '+') goto yy139;
		goto yy76;
	} else {
		if (yych <= '-') goto yy139;
		if (yych <= '/') goto yy76;
		if (yych <= '9') goto yy140;
		goto yy76;
	}
yy112:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'L') goto yy112;
		if (yych <= 'T') goto yy39;
		goto yy112;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy39;
			goto yy112;
		} else {
			if (yych == 'u') goto yy112;
			goto yy39;
		}
	}
yy114:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto yy76;
		if (yych <= '9') goto yy142;
		goto yy76;
	} else {
		if (yych <= 'F') goto yy142;
		if (yych <= '`') goto yy76;
		if (yych <= 'f') goto yy142;
		goto yy76;
	}
yy115:
	yych = *++YYCURSOR;
	if (yych == '=') goto yy144;
	{ RET(TOKEN_LSHIFT); }
yy117:
	++YYCURSOR;
	{ RET(TOKEN_LEQ); }
yy119:
	++YYCURSOR;
	{ RET(TOKEN_EQL); }
yy121:
	++YYCURSOR;
	{ RET(TOKEN_GEQ); }
yy123:
	yych = *++YYCURSOR;
	if (yych == '=') goto yy146;
	{ RET(TOKEN_RSHIFT); }
yy125:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
yy126:
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy76;
		if (yych != '\n') goto yy125;
	} else {
		if (yych <= '\r') goto yy129;
		if (yych == ' ') goto yy125;
		goto yy76;
	}
yy127:
	++YYCURSOR;
yy128:
	{ s->line++; goto scanner_loop; }
yy129:
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy127;
	goto yy128;
yy130:
	++YYCURSOR;
	{ RET(TOKEN_XORASSIGN); }
yy132:
	++YYCURSOR;
	{ RET(TOKEN_ORASSIGN); }
yy134:
	++YYCURSOR;
	{ RET(TOKEN_OROR); }
yy136:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto yy76;
		if (yych <= '9') goto yy74;
		goto yy76;
	} else {
		if (yych <= 'F') goto yy74;
		if (yych <= '`') goto yy76;
		if (yych <= 'f') goto yy74;
		goto yy76;
	}
yy137:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto yy76;
		if (yych <= '9') goto yy88;
		goto yy76;
	} else {
		if (yych <= 'F') goto yy88;
		if (yych <= '`') goto yy76;
		if (yych <= 'f') goto yy88;
		goto yy76;
	}
yy138:
	++YYCURSOR;
	goto yy104;
yy139:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy76;
	if (yych >= ':') goto yy76;
yy140:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 'G') {
		if (yych <= '9') {
			if (yych <= '/') goto yy104;
			goto yy140;
		} else {
			if (yych == 'F') goto yy138;
			goto yy104;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'H') goto yy138;
			if (yych <= 'e') goto yy104;
			goto yy138;
		} else {
			if (yych == 'h') goto yy138;
			goto yy104;
		}
	}
yy142:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 'T') {
		if (yych <= '@') {
			if (yych <= '/') goto yy39;
			if (yych <= '9') goto yy142;
			goto yy39;
		} else {
			if (yych <= 'F') goto yy142;
			if (yych == 'L') goto yy112;
			goto yy39;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'U') goto yy112;
			if (yych <= '`') goto yy39;
			if (yych <= 'f') goto yy142;
			goto yy39;
		} else {
			if (yych <= 'l') goto yy112;
			if (yych == 'u') goto yy112;
			goto yy39;
		}
	}
yy144:
	++YYCURSOR;
	{ RET(TOKEN_LSHIFTASSIGN); }
yy146:
	++YYCURSOR;
	{ RET(TOKEN_RSHIFTASSIGN); }
}


multilinecomment:
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    matchptr = cursor;
// The "*\/" is just to avoid screwing up text editor syntax highlighting.

{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x00) goto yy150;
		if (yych == '\n') goto yy154;
		goto yy152;
	} else {
		if (yych <= '\r') goto yy156;
		if (yych == '*') goto yy157;
		goto yy152;
	}
yy150:
	++YYCURSOR;
	{
                        if (eoi)
                            RET(TOKEN_INCOMPLETE_COMMENT);
                        goto multilinecomment;
                    }
yy152:
	++YYCURSOR;
yy153:
	{ goto multilinecomment; }
yy154:
	++YYCURSOR;
yy155:
	{
                        s->line++;
                        goto multilinecomment;
                    }
yy156:
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy154;
	goto yy155;
yy157:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy153;
	++YYCURSOR;
	{
                        if (s->report_comments)
                            RET(TOKEN_MULTI_COMMENT);
                        else if (s->report_whitespace)
                            RET(' ');

                        // Microsoft's preprocessor allows multiline comments
                        //  before a preprocessor directive, even though C/C++
                        //  doesn't. See if we've hit this case.
                        #if MATCH_MICROSOFT_PREPROCESSOR
                        if (s->tokenval == ((Token) '\n'))  // was start of line?
                        {
                            update_state(s, eoi, cursor, token, (Token) '\n');
                            goto ppdirective;  // may jump back to scanner_loop.
                        }
                        #endif

                        goto scanner_loop;
                    }
}


singlelinecomment:
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    matchptr = cursor;

{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= '\n') {
		if (yych <= 0x00) goto yy162;
		if (yych <= '\t') goto yy164;
		goto yy166;
	} else {
		if (yych == '\r') goto yy168;
		goto yy164;
	}
yy162:
	++YYCURSOR;
	{
                        if (eoi)
                        {
                            if (s->report_comments)
                                RET(TOKEN_SINGLE_COMMENT);
                            else
                                RET(TOKEN_EOI);
                        }
                        goto singlelinecomment;
                    }
yy164:
	++YYCURSOR;
	{ goto singlelinecomment; }
yy166:
	++YYCURSOR;
yy167:
	{
                        s->line++;
                        if (s->report_comments)
                        {
                            cursor = matchptr;  // so we RET('\n') next.
                            RET(TOKEN_SINGLE_COMMENT);
                        }
                        token = matchptr;
                        RET('\n');
                    }
yy168:
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy166;
	goto yy167;
}


ppdirective:
    if (YYLIMIT == YYCURSOR) YYFILL(1);

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy173;
		if (yych >= '\v') goto yy173;
	} else {
		if (yych <= ' ') {
			if (yych >= ' ') goto yy173;
		} else {
			if (yych == '#') goto yy176;
		}
	}
	++YYCURSOR;
yy172:
	{
                            token = cursor = (const uchar *) s->source;
                            limit = cursor + s->bytes_left;
                            goto scanner_loop;
                        }
yy173:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\n') {
		if (yych == '\t') goto yy173;
	} else {
		if (yych <= '\f') goto yy173;
		if (yych == ' ') goto yy173;
	}
	{ goto ppdirective; }
yy176:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'h') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy178;
			goto yy172;
		} else {
			if (yych <= ' ') goto yy178;
			if (yych <= 'c') goto yy172;
			if (yych <= 'e') goto yy178;
			goto yy172;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'i') goto yy178;
			if (yych == 'l') goto yy178;
			goto yy172;
		} else {
			if (yych <= 'p') goto yy178;
			if (yych == 'u') goto yy178;
			goto yy172;
		}
	}
yy177:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
yy178:
	if (yych <= 'h') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy177;
			if (yych >= ' ') goto yy177;
		} else {
			if (yych <= 'c') goto yy179;
			if (yych <= 'd') goto yy180;
			if (yych <= 'e') goto yy181;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'i') goto yy182;
			if (yych == 'l') goto yy183;
		} else {
			if (yych <= 'p') goto yy184;
			if (yych == 'u') goto yy185;
		}
	}
yy179:
	YYCURSOR = YYMARKER;
	if (yyaccept == 0) {
		goto yy172;
	} else {
		goto yy191;
	}
yy180:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy186;
	goto yy179;
yy181:
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych == 'l') goto yy187;
		goto yy179;
	} else {
		if (yych <= 'n') goto yy188;
		if (yych == 'r') goto yy189;
		goto yy179;
	}
yy182:
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy190;
	if (yych == 'n') goto yy192;
	goto yy179;
yy183:
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy193;
	goto yy179;
yy184:
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy194;
	goto yy179;
yy185:
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy195;
	goto yy179;
yy186:
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy196;
	goto yy179;
yy187:
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy197;
	if (yych == 's') goto yy198;
	goto yy179;
yy188:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy199;
	goto yy179;
yy189:
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy200;
	goto yy179;
yy190:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy201;
	if (yych == 'n') goto yy202;
yy191:
	{ RET(TOKEN_PP_IF); }
yy192:
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy203;
	goto yy179;
yy193:
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy204;
	goto yy179;
yy194:
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy205;
	goto yy179;
yy195:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy206;
	goto yy179;
yy196:
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy207;
	goto yy179;
yy197:
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy208;
	goto yy179;
yy198:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy210;
	goto yy179;
yy199:
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy212;
	goto yy179;
yy200:
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy213;
	goto yy179;
yy201:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy214;
	goto yy179;
yy202:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy215;
	goto yy179;
yy203:
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy216;
	goto yy179;
yy204:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy217;
	goto yy179;
yy205:
	yych = *++YYCURSOR;
	if (yych == 'g') goto yy219;
	goto yy179;
yy206:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy220;
	goto yy179;
yy207:
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy221;
	goto yy179;
yy208:
	++YYCURSOR;
	{ RET(TOKEN_PP_ELIF); }
yy210:
	++YYCURSOR;
	{ RET(TOKEN_PP_ELSE); }
yy212:
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy222;
	goto yy179;
yy213:
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy224;
	goto yy179;
yy214:
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy226;
	goto yy179;
yy215:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy228;
	goto yy179;
yy216:
	yych = *++YYCURSOR;
	if (yych == 'u') goto yy229;
	goto yy179;
yy217:
	++YYCURSOR;
	{ RET(TOKEN_PP_LINE); }
yy219:
	yych = *++YYCURSOR;
	if (yych == 'm') goto yy230;
	goto yy179;
yy220:
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy231;
	goto yy179;
yy221:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy233;
	goto yy179;
yy222:
	++YYCURSOR;
	{ RET(TOKEN_PP_ENDIF); }
yy224:
	++YYCURSOR;
	{ RET(TOKEN_PP_ERROR); }
yy226:
	++YYCURSOR;
	{ RET(TOKEN_PP_IFDEF); }
yy228:
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy235;
	goto yy179;
yy229:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy237;
	goto yy179;
yy230:
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy238;
	goto yy179;
yy231:
	++YYCURSOR;
	{ RET(TOKEN_PP_UNDEF); }
yy233:
	++YYCURSOR;
	{ RET(TOKEN_PP_DEFINE); }
yy235:
	++YYCURSOR;
	{ RET(TOKEN_PP_IFNDEF); }
yy237:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy240;
	goto yy179;
yy238:
	++YYCURSOR;
	{ RET(TOKEN_PP_PRAGMA); }
yy240:
	++YYCURSOR;
	{ RET(TOKEN_PP_INCLUDE); }
}


bad_chars:
    if (YYLIMIT == YYCURSOR) YYFILL(1);

{
	YYCTYPE yych;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '#') {
		if (yych <= '\r') {
			if (yych <= 0x00) goto yy244;
			if (yych <= 0x08) goto yy246;
			goto yy248;
		} else {
			if (yych <= 0x1F) goto yy246;
			if (yych == '"') goto yy246;
			goto yy248;
		}
	} else {
		if (yych <= '@') {
			if (yych <= '$') goto yy246;
			if (yych <= '?') goto yy248;
			goto yy246;
		} else {
			if (yych == '`') goto yy246;
			if (yych <= '~') goto yy248;
			goto yy246;
		}
	}
yy244:
	++YYCURSOR;
	{
                        if (eoi)
                        {
                            assert( !((token >= sentinel) &&
                                     (token < sentinel+YYMAXFILL)) );
                            eoi = 0;
                            cursor = (uchar *) s->source_base + s->orig_length;
                            RET(TOKEN_BAD_CHARS);  // next call will be EOI.
                        }
                        goto bad_chars;
                    }
yy246:
	++YYCURSOR;
	{ goto bad_chars; }
yy248:
	++YYCURSOR;
	{ cursor--; RET(TOKEN_BAD_CHARS); }
}


    assert(0 && "Shouldn't hit this code");
    RET(TOKEN_UNKNOWN);
} // preprocessor_lexer

// end of mojoshader_lexer.re (or .c) ...

