/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File TextLine.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef ColorHelp_H
#define ColorHelp_H

#include "UIColorHelp.h"

#ifndef RequestPanelHelp_H
#include "RequestPanelHelp.h"
#endif

#ifndef ParamList_H
#include "ParamList.h"
#endif

class ColorHelp: public XHelp<UIColorHelp_c> {
public:

// -- Contructors

	ColorHelp(Widget, RequestPanel&, const Parameter&);

// -- Destructor

	virtual ~ColorHelp(); 

private:

// No copy allowed

	ColorHelp(const ColorHelp&);
	ColorHelp& operator=(const ColorHelp&);

// -- Members
	
	ParamList xlist_;

// -- Overridden methods

	// From XD

	virtual void browseCB(Widget,XtPointer);
	virtual void singleCB(Widget,XtPointer);
	virtual void multipleCB(Widget,XtPointer);
	virtual void extendedCB(Widget,XtPointer);

	virtual void rgbCB(Widget,XtPointer);
	virtual void hslCB(Widget,XtPointer);
	virtual void addCB(Widget,XtPointer);

	// From RequestPanelItem

	virtual void refresh(const vector<string>&);
  	virtual long flags();
	virtual void set(Request&);

};

#endif
