/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef HelpFactory_H
#define HelpFactory_H

#include <string>
using std::string;

#include "mars.h"

class MvQRequestPanelHelp;
class RequestPanel;
class Parameter;

class HelpFactory 
{
public:

	HelpFactory(const string& name);
	virtual ~HelpFactory();

	virtual MvQRequestPanelHelp* make(RequestPanel& owner, const Parameter& def) = 0;
	static MvQRequestPanelHelp* create(RequestPanel& owner, const Parameter& info);
	
private:
	// No copy allowed						
	HelpFactory(const HelpFactory&);
	HelpFactory& operator=(const HelpFactory&);
};


template<class T>
class HelpMaker : public HelpFactory 
{
	MvQRequestPanelHelp* make(RequestPanel& owner, const Parameter& def) { return new T(owner, def); }
public:
	HelpMaker(const string& name) : HelpFactory(name) {}
};


#endif
