// license:BSD-3-Clause
// copyright-holders:Nicola Salmoria
/*******************************************************************************

    Input port macros used by games in the galpanic.c driver

*******************************************************************************/


/**************************** Inputs ****************************/

#define GALS_PANIC_JOYSTICK_4WAY(PL)\
	PORT_BIT( 0x0100, IP_ACTIVE_LOW, IPT_JOYSTICK_UP ) PORT_4WAY PORT_PLAYER(PL)\
	PORT_BIT( 0x0200, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN ) PORT_4WAY PORT_PLAYER(PL)\
	PORT_BIT( 0x0400, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT ) PORT_4WAY PORT_PLAYER(PL)\
	PORT_BIT( 0x0800, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT ) PORT_4WAY PORT_PLAYER(PL)\
	PORT_BIT( 0x1000, IP_ACTIVE_LOW, IPT_BUTTON1 ) PORT_PLAYER(PL)\
	PORT_BIT( 0x2000, IP_ACTIVE_LOW, IPT_BUTTON2 ) PORT_PLAYER(PL) PORT_OPTIONAL\
	PORT_BIT( 0x4000, IP_ACTIVE_LOW, IPT_UNKNOWN )\
	PORT_BIT( 0x8000, IP_ACTIVE_LOW, IPT_UNKNOWN )

#define GALS_PANIC_JOYSTICK_8WAY(PL)\
	PORT_BIT( 0x0100, IP_ACTIVE_LOW, IPT_JOYSTICK_UP ) PORT_8WAY PORT_PLAYER(PL)\
	PORT_BIT( 0x0200, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN ) PORT_8WAY PORT_PLAYER(PL)\
	PORT_BIT( 0x0400, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT ) PORT_8WAY PORT_PLAYER(PL)\
	PORT_BIT( 0x0800, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT ) PORT_8WAY PORT_PLAYER(PL)\
	PORT_BIT( 0x1000, IP_ACTIVE_LOW, IPT_BUTTON1 ) PORT_PLAYER(PL)\
	PORT_BIT( 0x2000, IP_ACTIVE_LOW, IPT_BUTTON2 ) PORT_PLAYER(PL)\
	PORT_BIT( 0x4000, IP_ACTIVE_LOW, IPT_BUTTON3 ) PORT_PLAYER(PL)\
	PORT_BIT( 0x8000, IP_ACTIVE_LOW, IPT_UNKNOWN )

#define SYSTEM_SERVICE\
	PORT_START("SYSTEM")\
	PORT_BIT( 0x00ff, IP_ACTIVE_LOW, IPT_UNKNOWN )\
	PORT_BIT( 0x0100, IP_ACTIVE_LOW, IPT_START1 )\
	PORT_BIT( 0x0200, IP_ACTIVE_LOW, IPT_START2 )\
	PORT_BIT( 0x0400, IP_ACTIVE_LOW, IPT_COIN1 )\
	PORT_BIT( 0x0800, IP_ACTIVE_LOW, IPT_COIN2 )\
	PORT_BIT( 0x1000, IP_ACTIVE_LOW, IPT_UNKNOWN )\
	PORT_BIT( 0x2000, IP_ACTIVE_LOW, IPT_TILT )\
	PORT_BIT( 0x4000, IP_ACTIVE_LOW, IPT_SERVICE1 )\
	PORT_BIT( 0x8000, IP_ACTIVE_LOW, IPT_UNKNOWN )

#define SYSTEM_NO_SERVICE\
	PORT_START("SYSTEM")\
	PORT_BIT( 0x00ff, IP_ACTIVE_LOW, IPT_UNKNOWN )\
	PORT_BIT( 0x0100, IP_ACTIVE_LOW, IPT_START1 )\
	PORT_BIT( 0x0200, IP_ACTIVE_LOW, IPT_START2 )\
	PORT_BIT( 0x0400, IP_ACTIVE_LOW, IPT_COIN1 )\
	PORT_BIT( 0x0800, IP_ACTIVE_LOW, IPT_COIN2 )\
	PORT_BIT( 0x1000, IP_ACTIVE_LOW, IPT_UNKNOWN )\
	PORT_BIT( 0x2000, IP_ACTIVE_LOW, IPT_TILT )\
	PORT_BIT( 0x4000, IP_ACTIVE_LOW, IPT_UNKNOWN )\
	PORT_BIT( 0x8000, IP_ACTIVE_LOW, IPT_UNKNOWN )

#define SYSTEM_NO_TILT\
	PORT_START("SYSTEM")\
	PORT_BIT( 0x00ff, IP_ACTIVE_LOW, IPT_UNKNOWN )\
	PORT_BIT( 0x0100, IP_ACTIVE_LOW, IPT_START1 )\
	PORT_BIT( 0x0200, IP_ACTIVE_LOW, IPT_START2 )\
	PORT_BIT( 0x0400, IP_ACTIVE_LOW, IPT_COIN1 )\
	PORT_BIT( 0x0800, IP_ACTIVE_LOW, IPT_COIN2 )\
	PORT_BIT( 0x1000, IP_ACTIVE_LOW, IPT_UNKNOWN )\
	PORT_BIT( 0x2000, IP_ACTIVE_LOW, IPT_UNKNOWN )\
	PORT_BIT( 0x4000, IP_ACTIVE_LOW, IPT_UNKNOWN )\
	PORT_BIT( 0x8000, IP_ACTIVE_LOW, IPT_UNKNOWN )

/**************************** Coinage & Dip Switches ****************************/

#define COINAGE_WORLD\
	PORT_DIPNAME( 0x0030, 0x0030, DEF_STR( Coin_A ) )   PORT_DIPLOCATION("SW1:5,6")\
	PORT_DIPSETTING(      0x0000, DEF_STR( 4C_1C ) )\
	PORT_DIPSETTING(      0x0010, DEF_STR( 3C_1C ) )\
	PORT_DIPSETTING(      0x0020, DEF_STR( 2C_1C ) )\
	PORT_DIPSETTING(      0x0030, DEF_STR( 1C_1C ) )\
	PORT_DIPNAME( 0x00c0, 0x00c0, DEF_STR( Coin_B ) )   PORT_DIPLOCATION("SW1:7,8")\
	PORT_DIPSETTING(      0x00c0, DEF_STR( 1C_2C ) )\
	PORT_DIPSETTING(      0x0080, DEF_STR( 1C_3C ) )\
	PORT_DIPSETTING(      0x0040, DEF_STR( 1C_4C ) )\
	PORT_DIPSETTING(      0x0000, DEF_STR( 1C_6C ) )

#define COINAGE_JAPAN\
	PORT_DIPNAME( 0x0030, 0x0030, DEF_STR( Coin_A ) )   PORT_DIPLOCATION("SW1:5,6")\
	PORT_DIPSETTING(      0x0010, DEF_STR( 2C_1C ) )\
	PORT_DIPSETTING(      0x0030, DEF_STR( 1C_1C ) )\
	PORT_DIPSETTING(      0x0000, DEF_STR( 2C_3C ) )\
	PORT_DIPSETTING(      0x0020, DEF_STR( 1C_2C ) )\
	PORT_DIPNAME( 0x00c0, 0x00c0, DEF_STR( Coin_B ) )   PORT_DIPLOCATION("SW1:7,8")\
	PORT_DIPSETTING(      0x0040, DEF_STR( 2C_1C ) )\
	PORT_DIPSETTING(      0x00c0, DEF_STR( 1C_1C ) )\
	PORT_DIPSETTING(      0x0000, DEF_STR( 2C_3C ) )\
	PORT_DIPSETTING(      0x0080, DEF_STR( 1C_2C ) )

#define COINAGE_NO_TEST_LOC\
	PORT_DIPUNUSED_DIPLOC( 0x0001, 0x0001, "SW1:1" )\
	PORT_DIPNAME( 0x0002, 0x0002, DEF_STR( Unknown ) )  PORT_DIPLOCATION("SW1:2")\
	PORT_DIPSETTING(      0x0002, DEF_STR( Off ) )\
	PORT_DIPSETTING(      0x0000, DEF_STR( On ) )\
	PORT_DIPUNUSED_DIPLOC( 0x0004, 0x0004, "SW1:3" )\
	PORT_DIPNAME( 0x0008, 0x0008, "Coin Mode" )         PORT_DIPLOCATION("SW1:4")\
	PORT_DIPSETTING(      0x0008, "Mode 1" )\
	PORT_DIPSETTING(      0x0000, "Mode 2" )\
	PORT_DIPNAME( 0x0030, 0x0030, DEF_STR( Coin_A ) )   PORT_DIPLOCATION("SW1:5,6")\
	PORT_DIPSETTING(      0x0020, DEF_STR( 2C_1C ) )\
	PORT_DIPSETTING(      0x0030, DEF_STR( 1C_1C ) )\
	PORT_DIPSETTING(      0x0010, DEF_STR( 1C_2C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0008)\
	PORT_DIPSETTING(      0x0010, DEF_STR( 1C_3C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0000)\
	PORT_DIPSETTING(      0x0000, DEF_STR( 1C_4C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0000)\
	PORT_DIPSETTING(      0x0000, DEF_STR( 1C_6C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0008)\
	PORT_DIPNAME( 0x00c0, 0x00c0, DEF_STR( Coin_B ) )   PORT_DIPLOCATION("SW1:7,8")\
	PORT_DIPSETTING(      0x0080, DEF_STR( 2C_1C ) )\
	PORT_DIPSETTING(      0x00c0, DEF_STR( 1C_1C ) )\
	PORT_DIPSETTING(      0x0040, DEF_STR( 1C_2C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0008)\
	PORT_DIPSETTING(      0x0040, DEF_STR( 1C_3C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0000)\
	PORT_DIPSETTING(      0x0000, DEF_STR( 1C_4C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0000)\
	PORT_DIPSETTING(      0x0000, DEF_STR( 1C_6C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0008)

#define COINAGE_TEST_LOC\
	PORT_DIPUNUSED_DIPLOC( 0x0001, 0x0001, "SW1:1" )\
	PORT_DIPNAME( 0x0002, 0x0002, DEF_STR( Unknown ) )  PORT_DIPLOCATION("SW1:2")\
	PORT_DIPSETTING(      0x0002, DEF_STR( Off ) )\
	PORT_DIPSETTING(      0x0000, DEF_STR( On ) )\
	PORT_SERVICE_DIPLOC(  0x0004, IP_ACTIVE_LOW, "SW1:3" )\
	PORT_DIPNAME( 0x0008, 0x0008, "Coin Mode" )         PORT_DIPLOCATION("SW1:4")\
	PORT_DIPSETTING(      0x0008, "Mode 1" )\
	PORT_DIPSETTING(      0x0000, "Mode 2" )\
	PORT_DIPNAME( 0x0030, 0x0030, DEF_STR( Coin_A ) )   PORT_DIPLOCATION("SW1:5,6")\
	PORT_DIPSETTING(      0x0020, DEF_STR( 2C_1C ) )\
	PORT_DIPSETTING(      0x0030, DEF_STR( 1C_1C ) )\
	PORT_DIPSETTING(      0x0010, DEF_STR( 1C_2C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0008)\
	PORT_DIPSETTING(      0x0010, DEF_STR( 1C_3C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0000)\
	PORT_DIPSETTING(      0x0000, DEF_STR( 1C_4C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0000)\
	PORT_DIPSETTING(      0x0000, DEF_STR( 1C_6C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0008)\
	PORT_DIPNAME( 0x00c0, 0x00c0, DEF_STR( Coin_B ) )   PORT_DIPLOCATION("SW1:7,8")\
	PORT_DIPSETTING(      0x0080, DEF_STR( 2C_1C ) )\
	PORT_DIPSETTING(      0x00c0, DEF_STR( 1C_1C ) )\
	PORT_DIPSETTING(      0x0040, DEF_STR( 1C_2C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0008)\
	PORT_DIPSETTING(      0x0040, DEF_STR( 1C_3C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0000)\
	PORT_DIPSETTING(      0x0000, DEF_STR( 1C_4C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0000)\
	PORT_DIPSETTING(      0x0000, DEF_STR( 1C_6C ) )    PORT_CONDITION("DSW1",0x0008,EQUALS,0x0008)


#define DIFFICULTY_DEMO_SOUNDS\
	PORT_DIPNAME( 0x0003, 0x0003, DEF_STR( Difficulty ) )   PORT_DIPLOCATION("SW2:1,2")\
	PORT_DIPSETTING(      0x0002, DEF_STR( Easy ) )\
	PORT_DIPSETTING(      0x0003, DEF_STR( Normal ) )\
	PORT_DIPSETTING(      0x0001, DEF_STR( Hard ) )\
	PORT_DIPSETTING(      0x0000, DEF_STR( Hardest ) )\
	PORT_DIPUNUSED_DIPLOC( 0x0004, 0x0004, "SW2:3" )\
	PORT_DIPUNKNOWN_DIPLOC( 0x0008, 0x0008, "SW2:4" )\
	PORT_DIPNAME( 0x0030, 0x0030, DEF_STR( Lives ) )    PORT_DIPLOCATION("SW2:5,6")\
	PORT_DIPSETTING(      0x0010, "2" )\
	PORT_DIPSETTING(      0x0030, "3" )\
	PORT_DIPSETTING(      0x0020, "4" )\
	PORT_DIPSETTING(      0x0000, "5" )\
	PORT_DIPNAME( 0x0040, 0x0040, DEF_STR( Demo_Sounds ) )  PORT_DIPLOCATION("SW2:7")\
	PORT_DIPSETTING(      0x0000, DEF_STR( Off ) )\
	PORT_DIPSETTING(      0x0040, DEF_STR( On ) )\
	PORT_DIPUNUSED_DIPLOC( 0x0080, 0x0080, "SW2:8" )
