[comment {-*- tcl -*- doctools}]
[vset FORMATNAME sun]
[vset FORMATFULLNAME {Sun Raster Format}]

[include format-header.inc]

[include format-package.inc]

This handler provides new additional configuration options. See
section [sectref {SUN OPTIONS}] for more detailed explanations.


[include format-middle.inc]

In addition the value for the option is treated as list and may
contain any of the special options listed in section

[sectref {SUN OPTIONS}].

[list_end]


[section {SUPPORTED SUN TYPES}]

[example_begin]
  1-bit pixels: Black and White.
  8-bit pixels: Grayscale or indexed.
 24-bit pixels: True-color (RGB, each channel 8 bit).
 32-bit pixels: True-color with alpha channel (RGBA, each channel 8 bit).

 List of currently supported features:

 Type   |     Read      |     Write     |
        | -file | -data | -file | -data |
 ----------------------------------------
  1-bit | Yes   | Yes   | No    | No    |
  8-bit | Yes   | Yes   | No    | No    |
 24-bit | Yes   | Yes   | Yes   | Yes   |
 32-bit | Yes   | Yes   | Yes   | Yes   |

 All images types may be either uncompressed or run-length encoded.
[example_end]


[section {SUN OPTIONS}]

The handler provides the following options:

[list_begin definitions]

[def "[option -verbose] [arg bool]"]

This option is supported for reading and writing.
[para]
If set to [const true], additional information about the loaded/stored image
is printed to stdout. Default is [const false].

[def "[option -compression] [arg string]"]

This option is supported for writing only.
[para]
Set the compression mode to either [const none] or [const rle].
Default is [const rle].

[def "[option -matte] [arg bool]"]

This option is supported for reading and writing.
[para]
If set to [const false], a matte (alpha) channel is ignored
during reading or writing. Default is [const true].

[list_end]

[list_begin definitions]
[include format-footer.inc]
