; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instsimplify < %s | FileCheck %s

target datalayout = "A5"

; A 0 valued byval pointer may be valid
define i1 @byval_may_be_zero(ptr addrspace(5) byval(i32) %ptr) {
; CHECK-LABEL: @byval_may_be_zero(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr addrspace(5) [[PTR:%.*]], null
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = icmp eq ptr addrspace(5) %ptr, null
  ret i1 %cmp
}

; FIXME: The interpretation of nonnull assumes a 0 pointer value, so
; this really is an incorrect fold.
define i1 @nonnull_may_be_zero(ptr addrspace(5) nonnull %ptr) {
; CHECK-LABEL: @nonnull_may_be_zero(
; CHECK-NEXT:    ret i1 false
;
  %cmp = icmp eq ptr addrspace(5) %ptr, null
  ret i1 %cmp
}
