/*
*
*  $Id: comandopacs.cpp $
*  Ginkgo CADx Project
*
*  Copyright 2008-14 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
//#define _GINKGO_TRACE

#include <sstream>
#include <map>

#include <api/api.h>
#include <api/globals.h>
#include <api/ientorno.h>

#include <api/controllers/icontroladorlog.h>
#include <main/controllers/commandcontroller.h>
#include <api/controllers/ieventscontroller.h>
#include <api/controllers/icontroladorpermisos.h>

#include <eventos/mensajes.h>

#include <main/controllers/dcmtk/dicomservers.h>

#include "comandopacs.h"
#include "comandoincluirhistorial.h"



#define IDC_PACS_BUSCAR                  61
#define IDC_PACS_DESCARGAR               62
#define IDC_PACS_SUBIR			         64

#define ID_REFRESCO_PROGRESO 1

#define PARALLEL

// Singleton de persistencia
namespace GADAPI
{
	ComandoPACSParams::ComandoPACSParams(const std::string& pacienteID, const std::string& pacienteNombre, const std::string& studyUID,
		const std::string& estudioAccNumber, const std::string& estudioModalidad, const std::string& estudioFechaDesde,
		const std::string& estudioFechaHasta, const std::string& studyTimeFrom, const std::string& studyTimeTo, const std::string& serverSeleccionado,
		TipoAmbito ambito, GNC::GCS::Ptr<IModeloDicom> pModeloDicom, GADAPI::PACS::IComandoPACSNotificador* pNotificador) :
		m_pacienteID(pacienteID),
		m_pacienteNombre(pacienteNombre),
		m_studyUID(studyUID),
		m_accessionNumber(estudioAccNumber),
		m_estudioModalidad(estudioModalidad),
		m_estudioFechaDesde(estudioFechaDesde),
		m_estudioFechaHasta(estudioFechaHasta),
		m_studyTimeFrom(studyTimeFrom),
		m_studyTimeTo(studyTimeTo),
		m_pNotificador(pNotificador),
		m_pModelo(pModeloDicom),
		m_Ambito(ambito)
	{
			
		if(serverSeleccionado == "") {
			if(!DicomServerList::Instance()->Empty()) {
				m_serverSeleccionado = DicomServerList::Instance()->GetDefaultServer()->ID;
			} else {
				throw GIL::DICOM::PACSException(_Std("There is not any Remote PACS configured"));
			}
		} else {
			m_serverSeleccionado = serverSeleccionado;
		}
		m_informar=true;
		m_error = "";
	}

	ComandoPACSParams::~ComandoPACSParams() {
		m_pNotificador = NULL;
	}


	ComandoPACS::ComandoPACS(ComandoPACSParams* pParams) : IComando(pParams)
	{
		m_pPACSParams = pParams;
		
		SetId(IDC_PACS_BUSCAR);
#if !defined(PARALLEL)
		EsperaA(IDC_PACS_BUSCAR);
		EsperaA(IDC_PACS_DESCARGAR);
		EsperaA(IDC_PACS_SUBIR);
#endif				
	}

	void ComandoPACS::Execute()
	{
		std::string tarea=_Std("Querying PACS ...");
		if (!NotificarProgreso(0.0f,tarea)) {
		    return;
		}
		GIL::DICOM::IPACSController* pCI = NULL;
		try {

			pCI = GNC::GCS::IEntorno::Instance()->GetPACSController();

			pCI->GetConnection(this);

			if (pCI == NULL) {
				throw GIL::DICOM::PACSException(_Std("Error accessing the controller subsystem integration: (GIL:: DICOM)."));
			}
			if (!m_pPACSParams->m_pModelo.IsValid()) {
				throw GIL::DICOM::PACSException(_Std("Subsystem integration error: uninitialized result data container."));
			}

			std::string mensaje = _Std("Starting Search ...");
			if ( !NotificarProgreso(0.0f, mensaje) ) {
			    return;
			}

			switch (m_pPACSParams->m_Ambito) {
				case ComandoPACSParams::TA_Paciente:
					//std::cout << "patient" << std::endl;
					break;
				case ComandoPACSParams::TA_Estudio:
					pCI->BuscarEstudio(
						this,
						m_pPACSParams->m_serverSeleccionado, // Server ID
						m_pPACSParams->m_pacienteID, // ID Paciente
						m_pPACSParams->m_pacienteNombre, // Nombre Paciente
						m_pPACSParams->m_studyUID,
						m_pPACSParams->m_accessionNumber, // Accesion Number
						m_pPACSParams->m_estudioModalidad, // Modalidad
						m_pPACSParams->m_estudioFechaDesde, // Fecha Desde
						m_pPACSParams->m_estudioFechaHasta, // Fecha Hasta
						m_pPACSParams->m_studyTimeFrom,  // time from
						m_pPACSParams->m_studyTimeTo,		// time To
						"", // Description
						"", // Nombre de la estación
						m_pPACSParams->m_pModelo,
						this);
					break;
				case ComandoPACSParams::TA_Serie:
					{
						const IModeloEstudio* estudio = NULL;
						m_pPACSParams->m_pModelo->BuscarEstudio(m_pPACSParams->m_studyUID,&estudio);
						if (estudio == NULL) {
							pCI->BuscarEstudio(
								this,
								m_pPACSParams->m_serverSeleccionado, // Server ID
								"", // ID Paciente
								"", // Nombre Paciente
								m_pPACSParams->m_studyUID,
								"", // Accesion Number
								"", // Modalidad
								"", // Fecha Desde
								"", // Fecha Hasta
								"", // time from
								"", // time to
								"", // Descripcion del Estudio
								"", // Nombre de la estación
								m_pPACSParams->m_pModelo,this
							);
						}
						GNC::GCS::IEntorno::Instance()->GetPACSController()->BuscarSeries(
							this,
							m_pPACSParams->m_serverSeleccionado, // Server ID
							m_pPACSParams->m_studyUID,
							std::string(),
							m_pPACSParams->m_pModelo,this
						);
					}
					break;
				default:
					break;
			}
			GTRACE(m_pPACSParams->m_pModelo);
		} catch (GinkgoNoServerFoundException& ) {
			m_pPACSParams->m_error= _Std("Server ID not found. ID = ") + m_pPACSParams->m_serverSeleccionado;
			m_pPACSParams->m_pModelo->Error = true;
		} catch (GIL::DICOM::PACSException& ex) {
			m_pPACSParams->m_error= _Std("Query error with PACS Id ") + m_pPACSParams->m_serverSeleccionado + "\n" + (const std::string)ex;
			m_pPACSParams->m_pModelo->Error = true;
		} catch (GIL::DICOM::ModelException& ex) {
			m_pPACSParams->m_error= _Std("Query error with PACS Id ") + m_pPACSParams->m_serverSeleccionado + "\n" + (const std::string)ex;
			m_pPACSParams->m_pModelo->Error = true;
		} catch (std::exception& ex) {
			m_pPACSParams->m_error= _Std("Query error with PACS Id ") + m_pPACSParams->m_serverSeleccionado + "\n" + ex.what();
			m_pPACSParams->m_pModelo->Error = true;
		} catch ( ... ) {
			m_pPACSParams->m_error= _Std("Query error with PACS Id ") + m_pPACSParams->m_serverSeleccionado + "\n" + _Std("Internal error");
			m_pPACSParams->m_pModelo->Error = true;
		}
		if (pCI) {
			pCI->ReleaseConnection(this);
		}
		if (!NotificarProgreso(1.0f,tarea)) {
		    return;
		}
	}

	void ComandoPACS::Update()
	{

		if (EstaAbortado()) {
		    return;
		}
				
		if(m_pPACSParams->m_pNotificador != NULL){
			if(!m_pPACSParams->m_error.empty()){
				LOG_ERROR("C-FIND", "Error searching on PACS:\n"  << m_pPACSParams->m_error);
				if (m_pPACSParams->m_informar) {
					GNC::GCS::IEventsController::Instance()->ProcesarEvento(new GNC::GCS::Events::EventoMensajes(NULL, _Std("Failed to perform search: ") + "\n" + m_pPACSParams->m_error, GNC::GCS::Events::EventoMensajes::PopUpMessage,false, GNC::GCS::Events::EventoMensajes::Error));
				}
				m_pPACSParams->m_informar = false;
				m_pPACSParams->m_pNotificador->PACSCargarListado(m_pPACSParams->m_pModelo);
			} else {
				m_pPACSParams->m_pNotificador->PACSCargarListado(m_pPACSParams->m_pModelo);
			}
		} else {
			// There is no notifier specified
		}
		
	}


	bool ComandoPACS::NotificarProgreso(float progresoNormalizado,const std::string &texto) {
		if (EstaAbortado())
		{
			return false;
		}
		return IComando::NotificarProgreso(progresoNormalizado, texto);
	}

	void ComandoPACS::LiberarRecursos()
	{
	}

}
