-- $Id$ 

-- unconstrained arrays and the 'range attribute.

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


package t is 
	type byte is array(integer range <>) of bit;
	procedure foo(variable a : inout byte);
end package t;

package body t is
	procedure foo(variable a : inout byte) is
	begin
		for i in a'range loop
			a(i) := '0';
		end loop;
	end;
end t;

entity test_bench is
end entity test_bench;

use t.all;
architecture test_bench_impl of test_bench is
begin
	p : process
		variable x : bit;
		variable b : byte(0 to 7);
	begin
		b := "11111111";
		foo(b);
		for i in b'range loop
			assert(b(i) = '0') 
			report "foo(b) should set b(i) to '0'."
			severity failure;
		end loop;
		assert false report "simulation finished" severity note;
		wait;
	end process;
end test_bench_impl;
