/** @file
PPI to describe all hash digests for a given FV

Copyright (c) 2017, Intel Corporation. All rights reserved.<BR>
This program and the accompanying materials
are licensed and made available under the terms and conditions of the BSD License
which accompanies this distribution.  The full text of the license may be found at
http://opensource.org/licenses/bsd-license.php

THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.

**/
/**
PPI to describe all hash digests for a given FV

Copyright (c) 2017, Microsoft Corporation

All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
 and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

**/

#ifndef __PEI_FIRMWARE_VOLUME_INFO_PREHASHED_FV_H__
#define __PEI_FIRMWARE_VOLUME_INFO_PREHASHED_FV_H__

#define EDKII_PEI_FIRMWARE_VOLUME_INFO_PREHASHED_FV_PPI_GUID \
 { 0x3ce1e631, 0x7008, 0x477c, { 0xad, 0xa7, 0x5d, 0xcf, 0xc7, 0xc1, 0x49, 0x4b } }

//
// HashAlgoId is TPM_ALG_ID in Tpm20.h
//
typedef struct _HASH_INFO {
  UINT16                                     HashAlgoId;
  UINT16                                     HashSize;
  //UINT8                                    Hash[];
} HASH_INFO;

//
// This PPI carries prehashsed data for one FV.  Platform should ensure 1:1 mapping between pre-hashed PPI and corresponding FV.
// The Count field in PPI is followed by Count number of FV hash info entries, which can be extended to PCR and logged to TCG event log directly by TCG modules.
// TCG module checks TPM required hash algorithms(PcdTpm2HashMask) with each pre-hased PPIs
//   For each pre-hashed PPI
//     If PPI carries hash generated by equivalent or larger algorithm set than TPM required, directly use PPI
//     else, drops PPI data and cacluate all hash again
//
typedef struct {
  UINT32                                     FvBase;
  UINT32                                     FvLength;
  UINT32                                     Count;
  //HASH_INFO                                HashInfo[];
} EDKII_PEI_FIRMWARE_VOLUME_INFO_PREHASHED_FV_PPI;

extern EFI_GUID gEdkiiPeiFirmwareVolumeInfoPrehashedFvPpiGuid;

#endif

