#!/bin/sh

set -e

# called by uscan with '--upstream-version' <version> <file>
echo "version $2"
PACKAGE=`dpkg-parsechangelog | sed -n 's/^Source: //p'`
VERSION=$2
tarball=$3
TAR=../${PACKAGE}_${VERSION}.orig.tar.xz
DIR=${PACKAGE}-${VERSION}.orig

unzip $tarball -d $DIR
XZ_OPT=--best tar --numeric --group 0 --owner 0 -c -v -J -f $TAR $DIR
rm -rf $tarball $DIR
