// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "printing/printed_page.h"

namespace printing {

PrintedPage::PrintedPage(int page_number,
                         Metafile* metafile,
                         const gfx::Size& page_size,
                         const gfx::Rect& page_content_rect,
                         double shrink_factor)
    : page_number_(page_number),
      metafile_(metafile),
      page_size_(page_size),
      page_content_rect_(page_content_rect),
      shrink_factor_(shrink_factor) {
}

PrintedPage::~PrintedPage() {
}

const Metafile* PrintedPage::metafile() const {
  return metafile_.get();
}

void PrintedPage::GetCenteredPageContentRect(
    const gfx::Size& paper_size, gfx::Rect* content_rect) const {
  *content_rect = page_content_rect();
  if (paper_size.width() > page_size().width()) {
    int diff = paper_size.width() - page_size().width();
    content_rect->set_x(content_rect->x() + diff / 2);
  }
  if (paper_size.height() > page_size().height()) {
    int diff = paper_size.height() - page_size().height();
    content_rect->set_y(content_rect->y() + diff / 2);
  }
}

}  // namespace printing
