{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetClosed: Boolean;
    procedure SetClosed(const Value: Boolean);
    function GetNormalizeVelocity: Boolean;
    procedure SetNormalizeVelocity(const Value: Boolean);
  public
    { X3D field "closed". } { }
    property Closed: Boolean read GetClosed write SetClosed;
    { Set X3D field "keyValue". } { }
    procedure SetKeyValue(const Value: array of Single);
    { Set X3D field "keyValue". } { }
    procedure SetKeyValue(const Value: TSingleList);
    { Set X3D field "keyVelocity". } { }
    procedure SetKeyVelocity(const Value: array of Single);
    { Set X3D field "keyVelocity". } { }
    procedure SetKeyVelocity(const Value: TSingleList);
    { X3D field "normalizeVelocity". } { }
    property NormalizeVelocity: Boolean read GetNormalizeVelocity write SetNormalizeVelocity;

{$endif read_interface}

{$ifdef read_implementation}

{ TSplineScalarInterpolatorNode ----------------------------------------------- }

function TSplineScalarInterpolatorNode.GetClosed: Boolean;
begin
  Result := FdClosed.Value;
end;

procedure TSplineScalarInterpolatorNode.SetClosed(const Value: Boolean);
begin
  FdClosed.Send(Value);
end;

procedure TSplineScalarInterpolatorNode.SetKeyValue(const Value: array of Single);
begin
  FdKeyValue.Send(Value);
end;

procedure TSplineScalarInterpolatorNode.SetKeyValue(const Value: TSingleList);
begin
  FdKeyValue.Send(Value);
end;

procedure TSplineScalarInterpolatorNode.SetKeyVelocity(const Value: array of Single);
begin
  FdKeyVelocity.Send(Value);
end;

procedure TSplineScalarInterpolatorNode.SetKeyVelocity(const Value: TSingleList);
begin
  FdKeyVelocity.Send(Value);
end;

function TSplineScalarInterpolatorNode.GetNormalizeVelocity: Boolean;
begin
  Result := FdNormalizeVelocity.Value;
end;

procedure TSplineScalarInterpolatorNode.SetNormalizeVelocity(const Value: Boolean);
begin
  FdNormalizeVelocity.Send(Value);
end;

{$endif read_implementation}
