{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAngularDampingFactor: Single;
    procedure SetAngularDampingFactor(const Value: Single);
    function GetAngularVelocity: TVector3;
    procedure SetAngularVelocity(const Value: TVector3);
    function GetAutoDamp: Boolean;
    procedure SetAutoDamp(const Value: Boolean);
    function GetAutoDisable: Boolean;
    procedure SetAutoDisable(const Value: Boolean);
    function GetCenterOfMass: TVector3;
    procedure SetCenterOfMass(const Value: TVector3);
    function GetDisableAngularSpeed: Single;
    procedure SetDisableAngularSpeed(const Value: Single);
    function GetDisableLinearSpeed: Single;
    procedure SetDisableLinearSpeed(const Value: Single);
    function GetDisableTime: Single;
    procedure SetDisableTime(const Value: Single);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetFiniteRotationAxis: TVector3;
    procedure SetFiniteRotationAxis(const Value: TVector3);
    function GetFixed: Boolean;
    procedure SetFixed(const Value: Boolean);
    function GetInertia: TMatrix3;
    procedure SetInertia(const Value: TMatrix3);
    function GetLinearDampingFactor: Single;
    procedure SetLinearDampingFactor(const Value: Single);
    function GetLinearVelocity: TVector3;
    procedure SetLinearVelocity(const Value: TVector3);
    function GetMass: Single;
    procedure SetMass(const Value: Single);
    function GetOrientation: TVector4;
    procedure SetOrientation(const Value: TVector4);
    function GetPosition: TVector3;
    procedure SetPosition(const Value: TVector3);
    function GetUseFiniteRotation: Boolean;
    procedure SetUseFiniteRotation(const Value: Boolean);
    function GetUseGlobalGravity: Boolean;
    procedure SetUseGlobalGravity(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdAngularDampingFactor: TSFFloat;
    { X3D field "angularDampingFactor". } { }
    public property FdAngularDampingFactor: TSFFloat read FFdAngularDampingFactor;
    { X3D field "angularDampingFactor". } { }
    property AngularDampingFactor: Single read GetAngularDampingFactor write SetAngularDampingFactor;

    strict private FFdAngularVelocity: TSFVec3f;
    { X3D field "angularVelocity". } { }
    public property FdAngularVelocity: TSFVec3f read FFdAngularVelocity;
    { X3D field "angularVelocity". } { }
    property AngularVelocity: TVector3 read GetAngularVelocity write SetAngularVelocity;

    strict private FFdAutoDamp: TSFBool;
    { X3D field "autoDamp". } { }
    public property FdAutoDamp: TSFBool read FFdAutoDamp;
    { X3D field "autoDamp". } { }
    property AutoDamp: Boolean read GetAutoDamp write SetAutoDamp;

    strict private FFdAutoDisable: TSFBool;
    { X3D field "autoDisable". } { }
    public property FdAutoDisable: TSFBool read FFdAutoDisable;
    { X3D field "autoDisable". } { }
    property AutoDisable: Boolean read GetAutoDisable write SetAutoDisable;

    strict private FFdCenterOfMass: TSFVec3f;
    { X3D field "centerOfMass". } { }
    public property FdCenterOfMass: TSFVec3f read FFdCenterOfMass;
    { X3D field "centerOfMass". } { }
    property CenterOfMass: TVector3 read GetCenterOfMass write SetCenterOfMass;

    strict private FFdDisableAngularSpeed: TSFFloat;
    { X3D field "disableAngularSpeed". } { }
    public property FdDisableAngularSpeed: TSFFloat read FFdDisableAngularSpeed;
    { X3D field "disableAngularSpeed". } { }
    property DisableAngularSpeed: Single read GetDisableAngularSpeed write SetDisableAngularSpeed;

    strict private FFdDisableLinearSpeed: TSFFloat;
    { X3D field "disableLinearSpeed". } { }
    public property FdDisableLinearSpeed: TSFFloat read FFdDisableLinearSpeed;
    { X3D field "disableLinearSpeed". } { }
    property DisableLinearSpeed: Single read GetDisableLinearSpeed write SetDisableLinearSpeed;

    strict private FFdDisableTime: TSFFloat;
    { X3D field "disableTime". } { }
    public property FdDisableTime: TSFFloat read FFdDisableTime;
    { X3D field "disableTime". } { }
    property DisableTime: Single read GetDisableTime write SetDisableTime;

    strict private FFdEnabled: TSFBool;
    { X3D field "enabled". } { }
    public property FdEnabled: TSFBool read FFdEnabled;
    { X3D field "enabled". } { }
    property Enabled: Boolean read GetEnabled write SetEnabled;

    strict private FFdFiniteRotationAxis: TSFVec3f;
    { X3D field "finiteRotationAxis". } { }
    public property FdFiniteRotationAxis: TSFVec3f read FFdFiniteRotationAxis;
    { X3D field "finiteRotationAxis". } { }
    property FiniteRotationAxis: TVector3 read GetFiniteRotationAxis write SetFiniteRotationAxis;

    strict private FFdFixed: TSFBool;
    { X3D field "fixed". } { }
    public property FdFixed: TSFBool read FFdFixed;
    { X3D field "fixed". } { }
    property Fixed: Boolean read GetFixed write SetFixed;

    strict private FFdForces: TMFVec3f;
    { X3D field "forces". } { }
    public property FdForces: TMFVec3f read FFdForces;
    { Set X3D field "forces". } { }
    procedure SetForces(const Value: array of TVector3);
    { Set X3D field "forces". } { }
    procedure SetForces(const Value: TVector3List);

    strict private FFdGeometry: TMFNode;
    { X3D field "geometry". } { }
    public property FdGeometry: TMFNode read FFdGeometry;
    { Set X3D field "geometry". } { }
    procedure SetGeometry(const Value: array of TAbstractNBodyCollidableNode);

    strict private FFdInertia: TSFMatrix3f;
    { X3D field "inertia". } { }
    public property FdInertia: TSFMatrix3f read FFdInertia;
    { X3D field "inertia". } { }
    property Inertia: TMatrix3 read GetInertia write SetInertia;

    strict private FFdLinearDampingFactor: TSFFloat;
    { X3D field "linearDampingFactor". } { }
    public property FdLinearDampingFactor: TSFFloat read FFdLinearDampingFactor;
    { X3D field "linearDampingFactor". } { }
    property LinearDampingFactor: Single read GetLinearDampingFactor write SetLinearDampingFactor;

    strict private FFdLinearVelocity: TSFVec3f;
    { X3D field "linearVelocity". } { }
    public property FdLinearVelocity: TSFVec3f read FFdLinearVelocity;
    { X3D field "linearVelocity". } { }
    property LinearVelocity: TVector3 read GetLinearVelocity write SetLinearVelocity;

    strict private FFdMass: TSFFloat;
    { X3D field "mass". } { }
    public property FdMass: TSFFloat read FFdMass;
    { X3D field "mass". } { }
    property Mass: Single read GetMass write SetMass;

    strict private FFdMassDensityModel: TSFNode;
    { X3D field "massDensityModel". } { }
    public property FdMassDensityModel: TSFNode read FFdMassDensityModel;

    strict private FFdOrientation: TSFRotation;
    { X3D field "orientation". } { }
    public property FdOrientation: TSFRotation read FFdOrientation;
    { X3D field "orientation". } { }
    property Orientation: TVector4 read GetOrientation write SetOrientation;

    strict private FFdPosition: TSFVec3f;
    { X3D field "position". } { }
    public property FdPosition: TSFVec3f read FFdPosition;
    { X3D field "position". } { }
    property Position: TVector3 read GetPosition write SetPosition;

    strict private FFdTorques: TMFVec3f;
    { X3D field "torques". } { }
    public property FdTorques: TMFVec3f read FFdTorques;
    { Set X3D field "torques". } { }
    procedure SetTorques(const Value: array of TVector3);
    { Set X3D field "torques". } { }
    procedure SetTorques(const Value: TVector3List);

    strict private FFdUseFiniteRotation: TSFBool;
    { X3D field "useFiniteRotation". } { }
    public property FdUseFiniteRotation: TSFBool read FFdUseFiniteRotation;
    { X3D field "useFiniteRotation". } { }
    property UseFiniteRotation: Boolean read GetUseFiniteRotation write SetUseFiniteRotation;

    strict private FFdUseGlobalGravity: TSFBool;
    { X3D field "useGlobalGravity". } { }
    public property FdUseGlobalGravity: TSFBool read FFdUseGlobalGravity;
    { X3D field "useGlobalGravity". } { }
    property UseGlobalGravity: Boolean read GetUseGlobalGravity write SetUseGlobalGravity;

{$endif read_interface}

{$ifdef read_implementation}

{ TRigidBodyNode ----------------------------------------------- }

function TRigidBodyNode.GetAngularDampingFactor: Single;
begin
  Result := FdAngularDampingFactor.Value;
end;

procedure TRigidBodyNode.SetAngularDampingFactor(const Value: Single);
begin
  FdAngularDampingFactor.Send(Value);
end;

function TRigidBodyNode.GetAngularVelocity: TVector3;
begin
  Result := FdAngularVelocity.Value;
end;

procedure TRigidBodyNode.SetAngularVelocity(const Value: TVector3);
begin
  FdAngularVelocity.Send(Value);
end;

function TRigidBodyNode.GetAutoDamp: Boolean;
begin
  Result := FdAutoDamp.Value;
end;

procedure TRigidBodyNode.SetAutoDamp(const Value: Boolean);
begin
  FdAutoDamp.Send(Value);
end;

function TRigidBodyNode.GetAutoDisable: Boolean;
begin
  Result := FdAutoDisable.Value;
end;

procedure TRigidBodyNode.SetAutoDisable(const Value: Boolean);
begin
  FdAutoDisable.Send(Value);
end;

function TRigidBodyNode.GetCenterOfMass: TVector3;
begin
  Result := FdCenterOfMass.Value;
end;

procedure TRigidBodyNode.SetCenterOfMass(const Value: TVector3);
begin
  FdCenterOfMass.Send(Value);
end;

function TRigidBodyNode.GetDisableAngularSpeed: Single;
begin
  Result := FdDisableAngularSpeed.Value;
end;

procedure TRigidBodyNode.SetDisableAngularSpeed(const Value: Single);
begin
  FdDisableAngularSpeed.Send(Value);
end;

function TRigidBodyNode.GetDisableLinearSpeed: Single;
begin
  Result := FdDisableLinearSpeed.Value;
end;

procedure TRigidBodyNode.SetDisableLinearSpeed(const Value: Single);
begin
  FdDisableLinearSpeed.Send(Value);
end;

function TRigidBodyNode.GetDisableTime: Single;
begin
  Result := FdDisableTime.Value;
end;

procedure TRigidBodyNode.SetDisableTime(const Value: Single);
begin
  FdDisableTime.Send(Value);
end;

function TRigidBodyNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TRigidBodyNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TRigidBodyNode.GetFiniteRotationAxis: TVector3;
begin
  Result := FdFiniteRotationAxis.Value;
end;

procedure TRigidBodyNode.SetFiniteRotationAxis(const Value: TVector3);
begin
  FdFiniteRotationAxis.Send(Value);
end;

function TRigidBodyNode.GetFixed: Boolean;
begin
  Result := FdFixed.Value;
end;

procedure TRigidBodyNode.SetFixed(const Value: Boolean);
begin
  FdFixed.Send(Value);
end;

procedure TRigidBodyNode.SetForces(const Value: array of TVector3);
begin
  FdForces.Send(Value);
end;

procedure TRigidBodyNode.SetForces(const Value: TVector3List);
begin
  FdForces.Send(Value);
end;

procedure TRigidBodyNode.SetGeometry(const Value: array of TAbstractNBodyCollidableNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractNBodyCollidableNode));
  FdGeometry.Send(A);
end;

function TRigidBodyNode.GetInertia: TMatrix3;
begin
  Result := FdInertia.Value;
end;

procedure TRigidBodyNode.SetInertia(const Value: TMatrix3);
begin
  FdInertia.Send(Value);
end;

function TRigidBodyNode.GetLinearDampingFactor: Single;
begin
  Result := FdLinearDampingFactor.Value;
end;

procedure TRigidBodyNode.SetLinearDampingFactor(const Value: Single);
begin
  FdLinearDampingFactor.Send(Value);
end;

function TRigidBodyNode.GetLinearVelocity: TVector3;
begin
  Result := FdLinearVelocity.Value;
end;

procedure TRigidBodyNode.SetLinearVelocity(const Value: TVector3);
begin
  FdLinearVelocity.Send(Value);
end;

function TRigidBodyNode.GetMass: Single;
begin
  Result := FdMass.Value;
end;

procedure TRigidBodyNode.SetMass(const Value: Single);
begin
  FdMass.Send(Value);
end;

function TRigidBodyNode.GetOrientation: TVector4;
begin
  Result := FdOrientation.Value;
end;

procedure TRigidBodyNode.SetOrientation(const Value: TVector4);
begin
  FdOrientation.Send(Value);
end;

function TRigidBodyNode.GetPosition: TVector3;
begin
  Result := FdPosition.Value;
end;

procedure TRigidBodyNode.SetPosition(const Value: TVector3);
begin
  FdPosition.Send(Value);
end;

procedure TRigidBodyNode.SetTorques(const Value: array of TVector3);
begin
  FdTorques.Send(Value);
end;

procedure TRigidBodyNode.SetTorques(const Value: TVector3List);
begin
  FdTorques.Send(Value);
end;

function TRigidBodyNode.GetUseFiniteRotation: Boolean;
begin
  Result := FdUseFiniteRotation.Value;
end;

procedure TRigidBodyNode.SetUseFiniteRotation(const Value: Boolean);
begin
  FdUseFiniteRotation.Send(Value);
end;

function TRigidBodyNode.GetUseGlobalGravity: Boolean;
begin
  Result := FdUseGlobalGravity.Value;
end;

procedure TRigidBodyNode.SetUseGlobalGravity(const Value: Boolean);
begin
  FdUseGlobalGravity.Send(Value);
end;

class function TRigidBodyNode.ClassX3DType: String;
begin
  Result := 'RigidBody';
end;

procedure TRigidBodyNode.CreateNode;
begin
  inherited;

  FFdAngularDampingFactor := TSFFloat.Create(Self, True, 'angularDampingFactor', 0.001);
   FdAngularDampingFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAngularDampingFactor);
  { X3D specification comment: [0,1] }

  FFdAngularVelocity := TSFVec3f.Create(Self, True, 'angularVelocity', Vector3(0, 0, 0));
   FdAngularVelocity.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAngularVelocity);
  { X3D specification comment: (-Inf,Inf) }

  FFdAutoDamp := TSFBool.Create(Self, True, 'autoDamp', false);
   FdAutoDamp.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAutoDamp);

  FFdAutoDisable := TSFBool.Create(Self, True, 'autoDisable', false);
   FdAutoDisable.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAutoDisable);

  FFdCenterOfMass := TSFVec3f.Create(Self, True, 'centerOfMass', Vector3(0, 0, 0));
   FdCenterOfMass.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCenterOfMass);
  { X3D specification comment: (-Inf,Inf) }

  FFdDisableAngularSpeed := TSFFloat.Create(Self, True, 'disableAngularSpeed', 0);
   FdDisableAngularSpeed.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisableAngularSpeed);
  { X3D specification comment: [0,Inf) }

  FFdDisableLinearSpeed := TSFFloat.Create(Self, True, 'disableLinearSpeed', 0);
   FdDisableLinearSpeed.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisableLinearSpeed);
  { X3D specification comment: [0,Inf) }

  FFdDisableTime := TSFFloat.Create(Self, True, 'disableTime', 0);
   FdDisableTime.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisableTime);
  { X3D specification comment: [0,Inf) }

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnabled);

  FFdFiniteRotationAxis := TSFVec3f.Create(Self, True, 'finiteRotationAxis', Vector3(0, 0, 0));
   FdFiniteRotationAxis.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFiniteRotationAxis);
  { X3D specification comment: [-1,1] }

  FFdFixed := TSFBool.Create(Self, True, 'fixed', false);
   FdFixed.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFixed);

  FFdForces := TMFVec3f.Create(Self, True, 'forces', []);
   FdForces.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdForces);

  FFdGeometry := TMFNode.Create(Self, True, 'geometry', [TAbstractNBodyCollidableNode]);
   FdGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeometry);

  FFdInertia := TSFMatrix3f.Create(Self, True, 'inertia', TMatrix3.Identity);
   FdInertia.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInertia);

  FFdLinearDampingFactor := TSFFloat.Create(Self, True, 'linearDampingFactor', 0.001);
   FdLinearDampingFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLinearDampingFactor);
  { X3D specification comment: [0,1] }

  FFdLinearVelocity := TSFVec3f.Create(Self, True, 'linearVelocity', Vector3(0, 0, 0));
   FdLinearVelocity.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLinearVelocity);
  { X3D specification comment: (-Inf,Inf) }

  FFdMass := TSFFloat.Create(Self, True, 'mass', 1);
   FdMass.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMass);
  { X3D specification comment: (0,Inf) }

  FFdMassDensityModel := TSFNode.Create(Self, True, 'massDensityModel', [TSphereNode, TBoxNode, TConeNode]);
   FdMassDensityModel.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMassDensityModel);

  FFdOrientation := TSFRotation.Create(Self, True, 'orientation', Vector3(0, 0, 1), 0);
   FdOrientation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOrientation);
  { X3D specification comment: [0,1] }

  FFdPosition := TSFVec3f.Create(Self, True, 'position', Vector3(0, 0, 0));
   FdPosition.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdPosition);
  { X3D specification comment: (-Inf,Inf) }

  FFdTorques := TMFVec3f.Create(Self, True, 'torques', []);
   FdTorques.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTorques);

  FFdUseFiniteRotation := TSFBool.Create(Self, True, 'useFiniteRotation', false);
   FdUseFiniteRotation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUseFiniteRotation);

  FFdUseGlobalGravity := TSFBool.Create(Self, True, 'useGlobalGravity', true);
   FdUseGlobalGravity.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUseGlobalGravity);

  DefaultContainerField := 'bodies';
end;

{$endif read_implementation}
