+++
title = "Python on Linux"
weight = 10
+++

## Install Python on Linux

Any Linux distribution (Debian/Ubuntu, Fedora, etc) provides packages
for Python and for many Python modules. This approach, however, runs into
difficulties if one needs Python modules that are _not_ available in the
distribution. Installing them using the Python package manager Pip can
cause inconsistencies and break the system. Therefore, distributions at
some point (e.g. Debian 12) disabled Pip, which terminates with
`error: externally-managed-environment`. While this behavior can be
overridden by a special flag, we advise against.

#### Python in pyenv

Rather, we recommend escaping from Python version hell by using the
Python version manager [pyenv](https://github.com/pyenv/pyenv).

Install the venerable GUI toolkit Tk (e.g. Debian package tk-dev).

Prepare the shell by adding
```
export PYENV_ROOT="$HOME/.pyenv"
command -v pyenv >/dev/null || export PATH="$PYENV_ROOT/bin:$PATH"
eval "$(pyenv init -)"
```
to `~/.bashrc` (or whatever startup configuration file), and
restart the shell.

Then:
```bash
# install pyenv
curl https://pyenv.run | bash

#install Python
pyenv install {{% recommended-python %}}
pyenv global {{% recommended-python %}}
which python # shows path in virtual environment

#install Python modules
pip install numpy
```
etc.
For the full list of modules required by BornAgain, see the [modules](/installation/py/modules/) page.
