//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Job/JobView.h
//! @brief     Defines class JobView
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_JOB_JOBVIEW_H
#define BORNAGAIN_GUI_VIEW_JOB_JOBVIEW_H

#include <QActionGroup>
#include <QMainWindow>

enum class JobViewActivity;
class DocksController;
class FitActivityPanel;
class JobItem;
class JobMessagePanel;
class JobProgressAssistant;
class JobRealTimeWidget;
class JobResultsPresenter;
class JobSelectorWidget;
class JobView;
class ProjectDocument;
class QProgressBar;


//! The JobView class is a main view to show list of jobs, job results and widgets for real time
//! and fitting activities.

class JobView : public QMainWindow {
    Q_OBJECT

public:
    JobView(QProgressBar* progressBar, ProjectDocument* document);

    void fillViewMenu(QMenu* menu);

signals:
    void focusRequest(int);

public slots:
    void onFocusRequest(JobItem* jobItem);
    void setActivity(JobViewActivity activity);
    void onSelectionChanged();

private:
    JobItem* selectedJobItem();
    void createSubWindows();
    void createActions();
    void connectJobRelated();

    void setActivityAndPresentationForNewJob(JobItem* jobItem);
    void resetLayout();

    DocksController* m_docks;
    JobProgressAssistant* m_progressAssistant;

    JobSelectorWidget* m_jobSelector = nullptr;
    JobResultsPresenter* m_jobResultsPresenter = nullptr;
    JobRealTimeWidget* m_jobRealTimeWidget = nullptr;
    FitActivityPanel* m_fitActivityPanel = nullptr;
    JobMessagePanel* m_jobMessagePanel = nullptr;

    QActionGroup m_activityActions;
    ProjectDocument* m_document;
};

#endif // BORNAGAIN_GUI_VIEW_JOB_JOBVIEW_H
