//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Application/ApplicationSettings.h
//! @brief     Defines class ApplicationSettings
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_APPLICATION_APPLICATIONSETTINGS_H
#define BORNAGAIN_GUI_APPLICATION_APPLICATIONSETTINGS_H

#include <QColor>
#include <QPalette>

class QWidget;
class QVariant;

//! Application wide settings.
//!
//! Contains settings which the user can change. Also
//! contains settings which may be user editable in the future.
class ApplicationSettings {
public:
    enum class Style { native, light, dark };

    ApplicationSettings();

    bool useNativeFileDialog() const;
    bool createNewProjectOnStartup() const;
    void setCreateNewProjectOnStartup(bool b);
    Style styleToUse() const;
    void setStyleToUse(Style style);

    QVariant defaultFunctionalities(const QVariant& absenceValue) const;
    void setDefaultFunctionalities(const QVariant& functionalities);

    bool defaultIsSingleInstrumentMode() const;
    void setDefaultIsSingleInstrumentMode(bool b);

    bool defaultIsSingleSampleMode() const;
    void setDefaultIsSingleSampleMode(bool b);

    bool defaultUnitIsAngstrom() const;
    void setDefaultUnitIsAngstrom(bool b) const;

    void saveWindowSizeAndPos(const QWidget* w);
    void loadWindowSizeAndPos(QWidget* w);

    void loadStyle(ApplicationSettings::Style style);
    ApplicationSettings::Style currentStyle();

    const QPalette& styleSheetPalette() const;

private:
    ApplicationSettings::Style m_currentStyle;
    QPalette m_styleSheetPalette;
};

extern ApplicationSettings* appSettings; //!< global pointer to the single instance

#endif // BORNAGAIN_GUI_APPLICATION_APPLICATIONSETTINGS_H
