//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Base/Axis/MakeScale.h
//! @brief     Declares functions that create instances of class Scale.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_BASE_AXIS_MAKESCALE_H
#define BORNAGAIN_BASE_AXIS_MAKESCALE_H

#include <memory>
#include <string>
#include <vector>

class Scale;

Scale GenericScale(const std::string& name, const std::vector<double>& limits);
#ifndef SWIG
Scale* newGenericScale(const std::string& name, const std::vector<double>& limits);
#endif // SWIG

Scale ListScan(const std::string& name, const std::vector<double>& points);
#ifndef SWIG
Scale* newListScan(const std::string& name, const std::vector<double>& points);
#endif // SWIG

//! Returns axis with fixed bin size.
Scale EquiDivision(const std::string& name, size_t nbins, double start, double end);
#ifndef SWIG
Scale* newEquiDivision(const std::string& name, size_t nbins, double start, double end);
std::shared_ptr<Scale> sharedEquiDivision(const std::string& name, size_t nbins, double start,
                                          double end);
std::unique_ptr<Scale> uniqueEquiDivision(const std::string& name, size_t nbins, double start,
                                          double end);
#endif // SWIG

#ifndef SWIG
//! Returns a EquiDivision determined by first and last point in scan.
Scale EquiScan(const std::string& name, size_t nbins, double start, double end);
Scale* newEquiScan(const std::string& name, size_t nbins, double start, double end);
std::shared_ptr<Scale> sharedEquiScan(const std::string& name, size_t nbins, double start,
                                      double end);
std::unique_ptr<Scale> uniqueEquiScan(const std::string& name, size_t nbins, double start,
                                      double end);
#endif // SWIG

#endif // BORNAGAIN_BASE_AXIS_MAKESCALE_H
