/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import java.util.Iterator;
import picard.vcf.VcTuple;

class PairedVariantSubContextIterator
implements Iterator<VcTuple> {
    private final PeekableIterator<VariantContext> truthIterator;
    private final String truthSample;
    private final PeekableIterator<VariantContext> callIterator;
    private final String callSample;
    private final VariantContextComparator comparator;

    PairedVariantSubContextIterator(Iterator<VariantContext> truthIterator, String truthSample, Iterator<VariantContext> callIterator, String callSample, SAMSequenceDictionary dict) {
        this.truthIterator = new PeekableIterator(truthIterator);
        this.truthSample = truthSample;
        this.callIterator = new PeekableIterator(callIterator);
        this.callSample = callSample;
        this.comparator = new VariantContextComparator(dict);
    }

    @Override
    public boolean hasNext() {
        return this.truthIterator.hasNext() || this.callIterator.hasNext();
    }

    @Override
    public VcTuple next() {
        VariantContext callVariantContext;
        if (!this.hasNext()) {
            throw new IllegalStateException("next() called while hasNext() is false.");
        }
        VariantContext truthVariantContext = this.truthIterator.hasNext() ? (VariantContext)this.truthIterator.peek() : null;
        VariantContext variantContext = callVariantContext = this.callIterator.hasNext() ? (VariantContext)this.callIterator.peek() : null;
        if (truthVariantContext == null) {
            return new VcTuple(null, ((VariantContext)this.callIterator.next()).subContextFromSample(this.callSample));
        }
        if (callVariantContext == null) {
            return new VcTuple(((VariantContext)this.truthIterator.next()).subContextFromSample(this.truthSample), null);
        }
        int ordering = this.comparator.compare(truthVariantContext, callVariantContext);
        if (ordering == 0) {
            return new VcTuple(((VariantContext)this.truthIterator.next()).subContextFromSample(this.truthSample), ((VariantContext)this.callIterator.next()).subContextFromSample(this.callSample));
        }
        if (ordering < 0) {
            return new VcTuple(((VariantContext)this.truthIterator.next()).subContextFromSample(this.truthSample), null);
        }
        return new VcTuple(null, ((VariantContext)this.callIterator.next()).subContextFromSample(this.callSample));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

