/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import htsjdk.samtools.util.CloseableIterator;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.PicardException;

public abstract class AbstractIlluminaPositionFileReader
implements CloseableIterator<PositionInfo> {
    public static final float MAX_POS = 1.0E7f;
    public static final float MIN_POS = -10.0f;
    private static final Pattern FileNamePattern = Pattern.compile("^s_(\\d+)_(\\d+)(_pos\\.txt|\\.locs|\\.clocs|_pos\\.txt.gz|_pos\\.txt.bz2)$");
    private final File file;
    private final int lane;
    private final int tile;

    public AbstractIlluminaPositionFileReader(File file) {
        this.file = file;
        int[] laneAndTile = this.fileNameToLaneAndTile(file.getName());
        this.lane = laneAndTile[0];
        this.tile = laneAndTile[1];
    }

    public AbstractIlluminaPositionFileReader(File file, int lane, int tile) {
        this.file = file;
        this.lane = lane;
        this.tile = tile;
    }

    public int getTile() {
        return this.tile;
    }

    public int getLane() {
        return this.lane;
    }

    public File getFile() {
        return this.file;
    }

    private int[] fileNameToLaneAndTile(String fileName) {
        String[] tokens = fileName.split(File.pathSeparator);
        Matcher matcher = FileNamePattern.matcher(tokens[tokens.length - 1]);
        if (!matcher.matches()) {
            throw new PicardException("File name not of the right structure: <filePath>/s_<lane>_<tile>(_pos.txt|_pos.txt.gz|_pos.txt.bz2.locs|.clocs).  File name (" + fileName + ")");
        }
        return new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))};
    }

    public final PositionInfo next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such cluster, cluster count(" + this.makeExceptionMsg() + ")");
        }
        return this.unsafeNextInfo();
    }

    protected abstract PositionInfo unsafeNextInfo();

    protected abstract String makeExceptionMsg();

    public abstract boolean hasNext();

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class PositionInfo {
        public final float xPos;
        public final float yPos;
        public final int lane;
        public final int tile;
        public final int xQseqCoord;
        public final int yQseqCoord;

        public PositionInfo(float x, float y, int lane, int tile) {
            if (x < -10.0f || y < -10.0f || x > 1.0E7f || y > 1.0E7f) {
                throw new IllegalArgumentException(String.format("Cluster location not in the range %f..%f. x: %f; y: %f; lane: %d; tile: %d", Float.valueOf(-10.0f), Float.valueOf(1.0E7f), Float.valueOf(x), Float.valueOf(y), lane, tile));
            }
            this.xPos = x;
            this.yPos = y;
            this.xQseqCoord = this.posToQSeqCoord(x);
            this.yQseqCoord = this.posToQSeqCoord(y);
            this.lane = lane;
            this.tile = tile;
        }

        private int posToQSeqCoord(float pos) {
            return Math.round(pos * 10.0f + 1000.0f);
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != PositionInfo.class) {
                return false;
            }
            if (other == this) {
                return true;
            }
            PositionInfo otherPi = (PositionInfo)other;
            return this.xPos == otherPi.xPos && this.yPos == otherPi.yPos && this.lane == otherPi.lane && this.tile == otherPi.tile && this.xQseqCoord == otherPi.xQseqCoord && this.yQseqCoord == otherPi.yQseqCoord;
        }
    }
}

