An associated type wasn't specified for a trait object.

Erroneous code example:

```compile_fail,E0191
trait Trait {
    type Bar;
}

type Foo = dyn Trait; // error: the value of the associated type `Bar` (from
                      //        the trait `Trait`) must be specified
```

Trait objects need to have all associated types specified. Please verify that
all associated types of the trait were specified and the correct trait was used.
Example:

```
trait Trait {
    type Bar;
}

type Foo = dyn Trait<Bar=i32>; // ok!
```
