// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/renderer_host/backing_store.h"

namespace content {

BackingStore::BackingStore(RenderWidgetHost* widget, const gfx::Size& size)
    : render_widget_host_(widget),
      size_(size) {
}

BackingStore::~BackingStore() {
}

size_t BackingStore::MemorySize() {
  return size_.GetArea() * 4;
}

}  // namespace content
