// |reftest| skip-if(!this.hasOwnProperty('Temporal')) -- Temporal is not enabled unconditionally
// Copyright (C) 2022 Igalia, S.L. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-temporal.zoneddatetime.compare
description: Properties on objects passed to compare() are accessed in the correct order
includes: [compareArray.js, temporalHelpers.js]
features: [Temporal]
---*/

const expected = [
  "get one.calendar",
  "has one.calendar.dateAdd",
  "has one.calendar.dateFromFields",
  "has one.calendar.dateUntil",
  "has one.calendar.day",
  "has one.calendar.dayOfWeek",
  "has one.calendar.dayOfYear",
  "has one.calendar.daysInMonth",
  "has one.calendar.daysInWeek",
  "has one.calendar.daysInYear",
  "has one.calendar.fields",
  "has one.calendar.id",
  "has one.calendar.inLeapYear",
  "has one.calendar.mergeFields",
  "has one.calendar.month",
  "has one.calendar.monthCode",
  "has one.calendar.monthDayFromFields",
  "has one.calendar.monthsInYear",
  "has one.calendar.weekOfYear",
  "has one.calendar.year",
  "has one.calendar.yearMonthFromFields",
  "has one.calendar.yearOfWeek",
  "get one.calendar.dateFromFields",
  "get one.calendar.fields",
  "call one.calendar.fields",
  // PrepareTemporalFields
  "get one.day",
  "get one.day.valueOf",
  "call one.day.valueOf",
  "get one.hour",
  "get one.hour.valueOf",
  "call one.hour.valueOf",
  "get one.microsecond",
  "get one.microsecond.valueOf",
  "call one.microsecond.valueOf",
  "get one.millisecond",
  "get one.millisecond.valueOf",
  "call one.millisecond.valueOf",
  "get one.minute",
  "get one.minute.valueOf",
  "call one.minute.valueOf",
  "get one.month",
  "get one.month.valueOf",
  "call one.month.valueOf",
  "get one.monthCode",
  "get one.monthCode.toString",
  "call one.monthCode.toString",
  "get one.nanosecond",
  "get one.nanosecond.valueOf",
  "call one.nanosecond.valueOf",
  "get one.offset",
  "get one.offset.toString",
  "call one.offset.toString",
  "get one.second",
  "get one.second.valueOf",
  "call one.second.valueOf",
  "get one.timeZone",
  "get one.year",
  "get one.year.valueOf",
  "call one.year.valueOf",
  "has one.timeZone.getOffsetNanosecondsFor",
  "has one.timeZone.getPossibleInstantsFor",
  "has one.timeZone.id",
  // InterpretTemporalDateTimeFields
  "call one.calendar.dateFromFields",
  // InterpretISODateTimeOffset
  "get one.timeZone.getOffsetNanosecondsFor",
  "get one.timeZone.getPossibleInstantsFor",
  "call one.timeZone.getPossibleInstantsFor",
  "call one.timeZone.getOffsetNanosecondsFor",
  // Same set of operations, for the other argument:
  "get two.calendar",
  "has two.calendar.dateAdd",
  "has two.calendar.dateFromFields",
  "has two.calendar.dateUntil",
  "has two.calendar.day",
  "has two.calendar.dayOfWeek",
  "has two.calendar.dayOfYear",
  "has two.calendar.daysInMonth",
  "has two.calendar.daysInWeek",
  "has two.calendar.daysInYear",
  "has two.calendar.fields",
  "has two.calendar.id",
  "has two.calendar.inLeapYear",
  "has two.calendar.mergeFields",
  "has two.calendar.month",
  "has two.calendar.monthCode",
  "has two.calendar.monthDayFromFields",
  "has two.calendar.monthsInYear",
  "has two.calendar.weekOfYear",
  "has two.calendar.year",
  "has two.calendar.yearMonthFromFields",
  "has two.calendar.yearOfWeek",
  "get two.calendar.dateFromFields",
  "get two.calendar.fields",
  "call two.calendar.fields",
  // PrepareTemporalFields
  "get two.day",
  "get two.day.valueOf",
  "call two.day.valueOf",
  "get two.hour",
  "get two.hour.valueOf",
  "call two.hour.valueOf",
  "get two.microsecond",
  "get two.microsecond.valueOf",
  "call two.microsecond.valueOf",
  "get two.millisecond",
  "get two.millisecond.valueOf",
  "call two.millisecond.valueOf",
  "get two.minute",
  "get two.minute.valueOf",
  "call two.minute.valueOf",
  "get two.month",
  "get two.month.valueOf",
  "call two.month.valueOf",
  "get two.monthCode",
  "get two.monthCode.toString",
  "call two.monthCode.toString",
  "get two.nanosecond",
  "get two.nanosecond.valueOf",
  "call two.nanosecond.valueOf",
  "get two.offset",
  "get two.offset.toString",
  "call two.offset.toString",
  "get two.second",
  "get two.second.valueOf",
  "call two.second.valueOf",
  "get two.timeZone",
  "get two.year",
  "get two.year.valueOf",
  "call two.year.valueOf",
  "has two.timeZone.getOffsetNanosecondsFor",
  "has two.timeZone.getPossibleInstantsFor",
  "has two.timeZone.id",
  // InterpretTemporalDateTimeFields
  "call two.calendar.dateFromFields",
  // InterpretISODateTimeOffset
  "get two.timeZone.getOffsetNanosecondsFor",
  "get two.timeZone.getPossibleInstantsFor",
  "call two.timeZone.getPossibleInstantsFor",
  "call two.timeZone.getOffsetNanosecondsFor",
];
const actual = [];

const one = TemporalHelpers.propertyBagObserver(actual, {
  year: 2001,
  month: 5,
  monthCode: "M05",
  day: 2,
  hour: 6,
  minute: 54,
  second: 32,
  millisecond: 987,
  microsecond: 654,
  nanosecond: 321,
  offset: "+00:00",
  calendar: TemporalHelpers.calendarObserver(actual, "one.calendar"),
  timeZone: TemporalHelpers.timeZoneObserver(actual, "one.timeZone"),
}, "one");

const two = TemporalHelpers.propertyBagObserver(actual, {
  year: 2014,
  month: 7,
  monthCode: "M07",
  day: 19,
  hour: 12,
  minute: 34,
  second: 56,
  millisecond: 123,
  microsecond: 456,
  nanosecond: 789,
  offset: "+00:00",
  calendar: TemporalHelpers.calendarObserver(actual, "two.calendar"),
  timeZone: TemporalHelpers.timeZoneObserver(actual, "two.timeZone"),
}, "two");

Temporal.ZonedDateTime.compare(one, two);
assert.compareArray(actual, expected, "order of operations");

reportCompare(0, 0);
